#!/home/yellow/bin/perl

# search.pl - a CGI script to search a swish index

# Eric Lease Morgan <emorgan@nd.edu>

# 2003/08/28 - first investigations; based on gallery.pl


# define the index file to search
my $index = '/home/yellow/apache/htdocs/colldev/index.swish-e';


###############################################################################################
# no configuration should be necessary below this line, unless you want to configure the output

# define the necessary modules
use SWISH::API;
use CGI;
use CGI::Carp qw(fatalsToBrowser);

# initalize CGI I/O
$input  = new CGI;
$output = new CGI("");

# get the command
$cmd = $input->param('cmd');

# initialilze the HTML output
$html  = $output->header;
$html .= $output->start_html(-title=>'Search');

# branch according to the command
if (! $cmd ) {

	# simply get the home page
	$html .= &home();

}

elsif ( $cmd eq 'help' ) {

	# simply disply the search help
	$html .= &help();
	
}

elsif ( $cmd eq 'about' ) {

	# simply disply the about text -- the documentation
	$html .= &about();
	
}

elsif ( $cmd eq 'search' ) {

	# get the query
	$query = $input->param('query');
	
	# check for query
	if (! $query) {
	
		# error
		$html .= '<b>Opps!</b> No query was supplied.';
		
		# quit
		&gracefulExit();
	
	}
	
	# search the index
	&search();
	
}

else {

	# error; unknown command
	$html .= "<b>Oops!</b> Unknown value for cmd ($cmd). Call Eric.";

}

# quit
&gracefulExit();


#############
# subroutines

# display the output and exit the application
sub gracefulExit {

	# get the search form
	$form = &form();
	
	# add the footer to the output
	$html .= '</body></html>';
	
	# proces each macro
	$html =~ s/##NUMBEROFHITS##/$number_of_hits/g;
	$html =~ s/##SEARCHFORM##/$form/g;
	$html =~ s/##HITLIST##/$hit_list/g;
	$html =~ s/##QUERY##/$query/g;
	
	# display the html, finally
	print $html;
	
	# quit, whew!
	exit;
	
}

# the heart of the matter
sub search {

	# get the result page
	$html .= &results();

	# open the index
	my $swish = SWISH::API->new($index);
	
	# search the index
	$results = $swish->Query($query);
	
	# check for search results; needs error checking
	$number_of_hits = $results->Hits;
	unless ( $number_of_hits ) {
			
		return;  # or next.
		
	}
	
	# initalize the hit list
	$hit_list .= "<ol>";
	
	# process each hit
	while (my $result = $results->NextResult) {
		
		# get the results
		$author  = $result->Property (author);
		$subject = $result->Property (subject);
		$date    = $result->Property (date);
		$url     = $result->Property (swishdocpath);
		
		# update the hit list
		$hit_list .= "<li><a href='$url'>$subject</a> - $author ($date)</li>";
				
	}
	
	# finish the hit list
	$hit_list .= "</ol>";
	
}

# edit these subroutines to change the output's display

sub form {

	return <<EOF
<form action='$ENV{SCRIPT_NAME}' method='get'>
<input type='hidden' name='cmd' value='search'>
Query: <input name='query' size='60' value='##QUERY##'><br>
<input type='submit' value='Go'> <small><a href='$ENV{SCRIPT_NAME}?cmd=help'>Help</a></small>
</form>    
EOF

}

sub about {

	return <<EOF
<h1>About</h1>
<p>This text will describe what is indexed here.</p>   
EOF

}

sub home {

	return <<EOF
<h1>Search</h1>
<p>
This is an searchable index of the Libraries intranet content. Try it: ##SEARCHFORM##
</p>
EOF

}

sub results {

	return <<EOF
<h1>Search results</h1>
<p>
Your search (##QUERY##) returned ##NUMBEROFHITS## hit(s).
</p>
##HITLIST##

##SEARCHFORM##

EOF

}

sub help {

	return <<EOF
<h1>Help text</h1>
<p>
The search engine supports any combination of Boolean logic, nested queries, phrase, and field searches. Queries are case-insensitive. Examples include:
</p>
<center>
<table border='0'>
<tr>
	<td align='right' bgcolor='silver'><b>Types</b></td>
	<td bgcolor='silver'><b>Examples</b></td>
</tr>
<tr>
	<td align='right'>simple:</td>
	<td>red</td>
</tr>
<tr>
	<td align='right'>Boolean and:</td>
	<td>red and blue</td>
</tr>
<tr>
	<td align='right'>Boolean and:</td>
	<td>red blue</td>
</tr>
<tr>
	<td align='right'>Boolean or:</td>
	<td>red or blue</td>
</tr>
<tr>
	<td align='right'>Boolean not:</td>
	<td>red not blue</td>
</tr>
<tr>
	<td align='right'>nested:</td>
	<td>(red or blue) and green</td>
</tr>
<tr>
	<td align='right'>phrase:</td>
	<td>"light red"</td>
</tr>
<tr>
	<td align='right'>field:</td>
	<td>title = red</td>
</tr>
</table>
</center>
<h2>Try it</h2>
<center>
##SEARCHFORM##
</center>
EOF

}


