# swish-alawon.pl - a script to search a swish index of ALAWON plain text files

# Eric Lease Morgan <emorgan@nd.edu>
# September 1, 2003 - Labor Day; based on search-directory.pl

# define sum constants
my $INDEX = './index.swish-e';

# define the necessary modules
use SWISH::API;

# get the query
my $query = join(" ", @ARGV);

if (! $query) {

	print "\n  Usage: swish-alawon.pl <query>\n\n";
	exit;
	
}

# open the index
my $swish = SWISH::API->new($INDEX);
	
# search the index
$results = $swish->Query("$query");
	
# check for search results; need error checking
$number_of_hits = $results->Hits;
print "\nYour search ($query) returned $number_of_hits hit(s).\n\n";
	
# process each hit
while (my $result = $results->NextResult) {
	
	# get the results
	$location = $result->Property ('swishdocpath');
	
	print <<EOF;
  location: $location
EOF

}

print "\n";

exit;
