# sample-data.sql - a set of SQL statements filling a
#                   database with sample data for a 
#                   system called MyLibrary
#
# Sample usage from the Unix command line:
#
#    mysql -umylibrary -p mylibrary < sample-data.sql
#
# For more information about MyLibrary see:
#
#   http://dewey.library.nd.edu/mylibrary/
#
# Eric Lease Morgan <emorgan@nd.edu>
# University Libraries of Notre Dame
#
# June 20, 2003

#
# Table structure for table `bib_databases`
#

-- MySQL dump 8.22
--
-- Host: localhost    Database: mylibrary
---------------------------------------------------------
-- Server version	3.23.53-log

--
-- Table structure for table 'bib_databases'
--

CREATE TABLE bib_databases (
  bib_database_id int(6) NOT NULL default '0',
  bib_database_name varchar(255) default NULL,
  bib_database_url varchar(255) default NULL,
  bib_database_note varchar(255) default NULL,
  bib_database_fkey varchar(255) NOT NULL default '',
  bib_database_date date NOT NULL default '0000-00-00',
  bib_database_lcd int(1) NOT NULL default '0',
  PRIMARY KEY  (bib_database_id)
) TYPE=MyISAM;

--
-- Dumping data for table 'bib_databases'
--


INSERT INTO bib_databases VALUES (335,'Lit-O-Box','http://www.geocities.com/SoHo/Gallery/4688/','Lit-O-Box Literature and Creative Writing is a site geared toward enriching the on-line literary and artistic community. The site was created on the premise that literature is never static, it evolves as its reader evolves.','','2000-11-20',1);
INSERT INTO bib_databases VALUES (333,'BookBrowse','http://www.bookbrowse.com/','BookBrowse selects an eclectic cross section of the best new literature - from biographies to novels, sci-fi to science, thrillers to religion - for your reading pleasure.','','2000-11-17',0);
INSERT INTO bib_databases VALUES (334,'BookWeb','http://www.bookweb.org/','The official home page of the American Booksellers Association. Founded in 1900, the American Booksellers Association is a not-for-profit trade organization devoted to meeting the needs of its core members--independently owned bookstores with store front','','2000-11-20',1);
INSERT INTO bib_databases VALUES (305,'SixtiesRock','http://www.sixtiesrock.com/','Sixtiesrock.com Bibliographies will serve to provide a comprehensive listing of articles and books related to sixties rock artists. For each artist listed, sixtiesrock.com will identify up to 100 articles and 100 books published on the artist or containin','','2000-11-17',0);
INSERT INTO bib_databases VALUES (336,'Alex Catalogue of Electronic Texts','http://www.infomotions.com/alex','The Alex Catalogue is a collection of public domain documents from the area of American and English literature as well as Western philosophy.','','2000-11-17',0);
INSERT INTO bib_databases VALUES (337,'Digital BookWorld','http://www.digitalbookworld.com/','Digital BookWorld is a web site about books: New Books, Authors, Booksellers, and Publishers. It also provides Excerpts, Interviews, a Calendar, & Bulletin Board.','','2000-11-17',0);
INSERT INTO bib_databases VALUES (338,'Epistemelinks.com','http://www.epistemelinks.com/Main/MainTopi.asp','This site provides easy access to resources in philosophy, categorized by topic, tradition, or time period.','','2000-11-17',0);
INSERT INTO bib_databases VALUES (339,'20th WCP','http://www.bu.edu/wcp/MainTKno.htm','The papers indexed below were given at the Twentieth World Congress of Philosophy, in Boston, Massachusetts from August 10-15, 1998.','','2000-11-17',0);
INSERT INTO bib_databases VALUES (340,'Women in Philosophy','http://billyboy.ius.indiana.edu/WomeninPhilosophy/WomeninPhilo.html','This bibliography is a project in collaborative scholarship with a database now containing over 16,000 records representing the work of over 5,000 women. You are invited to participate in building a first-rate, comprehensive, and continuously up-dated bib','','2000-11-17',0);
INSERT INTO bib_databases VALUES (341,'Contemporary Philosophy of Mind','http://www.u.arizona.edu/~chalmers/biblio.html','This is a bibliography of recent work in the philosophy of mind, philosophy of cognitive science, philosophy of artificial intelligence, and on consciousness in the sciences. It consists of 5196 entries, and is divided into six parts, each of which is fur','','2000-11-17',0);
INSERT INTO bib_databases VALUES (342,'Essencial Readings in Chinese Philosophy','http://faculty.vassar.edu/~brvannor/bibliography.html','Represents one opinion on the essential secondary readings in English on Chinese philosophy. My editorial policy is to include only works that are essential reading on particular topics (i.e., this is not a comprehensive list), and only works th','','2000-11-20',1);
INSERT INTO bib_databases VALUES (343,'Bibliography of publications by Jacques Derrida','http://www.hydra.umn.edu/derrida/jdind.html','Below you find bibliographies of texts and interviews by Jacques Derrida, ordered chronologically (by publication year) or alphabetically.','','2000-11-17',0);
INSERT INTO bib_databases VALUES (344,'NASA Astrophysics Data System','http://adswww.harvard.edu/','The Astrophysics Data System (ADS) is a NASA-funded project whose main resource is an Abstract Service, which includes four sets of abstracts: 1) astronomy and astrophysics, containing 621,668 abstracts; 2) instrumentation, containing 590,197 abstracts; 3','','2000-11-17',0);
INSERT INTO bib_databases VALUES (345,'Simbad Astronomical Database','http://simbad.u-strasbg.fr/Simbad','The SIMBAD astronomical database provides basic data, cross-identifications and bibliography for astronomical objects outside the solar system.\r\nSIMBAD can be queried by object name, coordinates and other criteria (filters).\r\nLinks to some other databases','','2000-11-17',0);
INSERT INTO bib_databases VALUES (346,'Munich Astro Archive','http://www.maa.mhn.de/home.html','This project has been started for all people interested in Astronomy and Astrophysics. You do not need special knowledge to use the information which is collected here. One of the goals is to offer interesting things as well to complete laymans as to prof','','2000-11-17',0);
INSERT INTO bib_databases VALUES (347,'NSSDC Photo Gallery','http://nssdc.gsfc.nasa.gov/photo_gallery/','he images presented in the Photo Gallery have a number of different sources, primarily NASA missions, however. They are generally organized by object and/or phenomenon on separate pages. The source of the image as well as the processing involved in produc','','2000-11-17',0);
INSERT INTO bib_databases VALUES (349,'JSC Digital Image Collection','http://images.jsc.nasa.gov/','\r\n\r\nNASA\'s Johnson Space Center is proud to provide this collection of all  \r\ncataloged Shuttle mission Earth-looking imagery from the first shuttle \r\nmission, STS-1, through STS-76, a total of nearly 250,000 images. \r\n \r\nThis collection also includes pre','','2000-11-17',0);
INSERT INTO bib_databases VALUES (350,'AstroWeb','http://www.stsci.edu/astroweb/astronomy.html','A collection of pointers to astronomy-related information available on the Internet. The database is maintained by the AstroWeb Consortium, a collaboration involving 9 individuals at 7 institutions. In addition to classified lists of resource records,','','2000-11-17',0);
INSERT INTO bib_databases VALUES (351,'WWW Virtual Library: Astronomy and Astrophysics','http://webhead.com/wwwvl/astronomy/','a collection of pointers to astronomy-related information available on the Internet. The database is maintained by the AstroWeb Consortium, a collaboration involving 9 individuals at 7 institutions. These CERN - La Plata AstroWeb pages are recomputed at a','','2000-11-17',0);
INSERT INTO bib_databases VALUES (353,'sciastro.net','http://www.sciastro.net/','sciastro.net is a network of amateur astronomers who wish to share their love of astronomy with others. We do this through our irc chat group and our newsletter. This is made possible through the generosity of our sponsors, so please be sure to visit th','','2000-11-20',1);
INSERT INTO bib_databases VALUES (356,'Math Database','http://www.emis.de/ZMATH/','The database is edited by European Mathematical Society, the FIZ Karlsruhe, and the Heidelberg Academy of Sciences. It is established in cooperation with Math Doc Cell (France).','','2000-11-17',0);
INSERT INTO bib_databases VALUES (357,'MathPages','http://www.seanet.com/~ksbrown/','Informal notes written on\r\nvarious mathematical topics','','2000-11-17',0);
INSERT INTO bib_databases VALUES (358,'Mathmanica Tour','http://www.theory.csc.uvic.ca/~mmania/','This site is dedicated to helping young students and other explore some topics in higher mathematics. Please take 10 minutes to take this tour and familiarize yourself with the kind of resources you can find on this site.','','2000-11-17',0);
INSERT INTO bib_databases VALUES (359,'Ask Dr. Math','http://forum.swarthmore.edu/dr.math/','Ask Dr. Math is a question and answer service for math students and their teachers. A searchable archive is available by level and topic, as well as summaries of Frequently Asked Questions (the Dr. Math FAQ).','','2000-11-17',0);
INSERT INTO bib_databases VALUES (360,'Mathtools','http://www.mathtools.net/','Technical computing portal for scientific and engineering needs.','','2000-11-20',1);
INSERT INTO bib_databases VALUES (361,'CGAL','http://www.cgal.org/','C++ library of algorithms and data structures used in computational geometry.','','2000-11-17',0);
INSERT INTO bib_databases VALUES (362,'Spreadsheets in Eduction','http://sunsite.univie.ac.at/Spreadsite/spreaded.html','This page tries to collect some information about spreadsheets with an emphasis on mathematics and statistics education.','','2000-11-17',0);
INSERT INTO bib_databases VALUES (363,'Wall of Sound: Reviews','http://wallofsound.go.com/reviews/','','','2000-11-20',1);
INSERT INTO bib_databases VALUES (364,'Billboard Spotlight Reviews','http://www.billboard.com/reviews/current.asp','Read original Billboard album reviews online! Current reviews are shown below; search our database to explore more than 35,000 original entries dating back to 1970. (Sound samples not available for all albums.)','','2000-11-17',0);
INSERT INTO bib_databases VALUES (365,'sonicnet.com: Reviews','http://www.sonicnet.com/reviews/','A guide to all the sonicnet reviews from every genre.','','2000-11-17',0);
INSERT INTO bib_databases VALUES (366,'CD Reviews','http://www.cdconsumer.com/','A guide to the best music of the year.','','2000-11-17',0);
INSERT INTO bib_databases VALUES (422,'All databases','http://hegel.lib.ncsu.edu/development/disciplines/00-databases.html','This is a list of all the database items listed alplhabetically.','','2000-11-21',1);

--
-- Table structure for table 'colors'
--

CREATE TABLE colors (
  color_id int(6) NOT NULL default '0',
  color_code varchar(7) default NULL,
  color_name varchar(255) default NULL,
  PRIMARY KEY  (color_id)
) TYPE=MyISAM;

--
-- Dumping data for table 'colors'
--


INSERT INTO colors VALUES (2,'#000000','Black');
INSERT INTO colors VALUES (28,'#0000FF','Blue');
INSERT INTO colors VALUES (38,'#8A2BE2','Blue Violet');
INSERT INTO colors VALUES (33,'#5F9EA0','Cadet Blue');
INSERT INTO colors VALUES (10,'#D2691E','Chocolate');
INSERT INTO colors VALUES (15,'#FF7F50','Coral');
INSERT INTO colors VALUES (34,'#6495ED','Corn Flower Blue');
INSERT INTO colors VALUES (48,'#DC143C','Crimson');
INSERT INTO colors VALUES (8,'#B8860B','Dark Goldenrod');
INSERT INTO colors VALUES (17,'#006400','Dark Green');
INSERT INTO colors VALUES (44,'#8B008B','Dark Magenta');
INSERT INTO colors VALUES (21,'#556B2F','Dark Olive Green');
INSERT INTO colors VALUES (6,'#FF8C00','Dark Orange');
INSERT INTO colors VALUES (39,'#932CC','Dark Orchid');
INSERT INTO colors VALUES (40,'#483D8B','Dark Slate Blue');
INSERT INTO colors VALUES (30,'#2F4F4F','Dark Slate Gray');
INSERT INTO colors VALUES (37,'#9400D3','Dark Violet');
INSERT INTO colors VALUES (47,'#FF1493','Deep Pink');
INSERT INTO colors VALUES (11,'#B22222','Fire Brick');
INSERT INTO colors VALUES (19,'#228B22','Forest Green');
INSERT INTO colors VALUES (46,'#FF00FF','Fuchsia');
INSERT INTO colors VALUES (18,'#008000','Green');
INSERT INTO colors VALUES (16,'#CD5C5C','Indian Red');
INSERT INTO colors VALUES (36,'#4B0082','Indigo');
INSERT INTO colors VALUES (22,'#20B2AA','Light Sea Green');
INSERT INTO colors VALUES (45,'#FF00FF','Magenta');
INSERT INTO colors VALUES (3,'#800000','Maroon');
INSERT INTO colors VALUES (27,'#0000CD','Medium Blue');
INSERT INTO colors VALUES (42,'#9370DB','Medium Purple');
INSERT INTO colors VALUES (24,'#3CB371','Medium Sea Green');
INSERT INTO colors VALUES (49,'#C71585','Medium Violet Red');
INSERT INTO colors VALUES (29,'#191970','Midnight Blue');
INSERT INTO colors VALUES (26,'#000080','Navy');
INSERT INTO colors VALUES (7,'#808000','Olive');
INSERT INTO colors VALUES (20,'#6B8E23','Olive Drab');
INSERT INTO colors VALUES (5,'#FF4500','Orange Red');
INSERT INTO colors VALUES (13,'#CD853F','Peru');
INSERT INTO colors VALUES (43,'#800080','Purple');
INSERT INTO colors VALUES (4,'#FF0000','Red');
INSERT INTO colors VALUES (31,'#4169E1','Royal Blue');
INSERT INTO colors VALUES (9,'#8B4513','Saddle Brown');
INSERT INTO colors VALUES (23,'#2E8B57','Sea Green');
INSERT INTO colors VALUES (12,'#A0522D','Sienna');
INSERT INTO colors VALUES (35,'#708090','Slate Gray');
INSERT INTO colors VALUES (41,'#6A5ACD','SlateBlue');
INSERT INTO colors VALUES (32,'#4682B4','Steel Blue');
INSERT INTO colors VALUES (25,'#008080','Teal');
INSERT INTO colors VALUES (14,'#FF6347','Tomato');
INSERT INTO colors VALUES (50,'#00FFFF','Aqua');
INSERT INTO colors VALUES (51,'#808080','Gray');
INSERT INTO colors VALUES (52,'#00FF00','Lime');
INSERT INTO colors VALUES (53,'#C0C0C0','Silver');
INSERT INTO colors VALUES (54,'#FFFF00','Yellow');
INSERT INTO colors VALUES (55,'#FFFFFF','White');

--
-- Table structure for table 'defaultBibdatabases'
--

CREATE TABLE defaultBibdatabases (
  discipline_id int(6) default NULL,
  bib_database_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'defaultBibdatabases'
--


INSERT INTO defaultBibdatabases VALUES (5,351);
INSERT INTO defaultBibdatabases VALUES (5,353);
INSERT INTO defaultBibdatabases VALUES (1,335);
INSERT INTO defaultBibdatabases VALUES (1,334);
INSERT INTO defaultBibdatabases VALUES (1,333);
INSERT INTO defaultBibdatabases VALUES (3,357);
INSERT INTO defaultBibdatabases VALUES (3,358);
INSERT INTO defaultBibdatabases VALUES (3,359);
INSERT INTO defaultBibdatabases VALUES (4,363);
INSERT INTO defaultBibdatabases VALUES (4,305);
INSERT INTO defaultBibdatabases VALUES (4,356);
INSERT INTO defaultBibdatabases VALUES (2,340);
INSERT INTO defaultBibdatabases VALUES (2,342);
INSERT INTO defaultBibdatabases VALUES (2,338);
INSERT INTO defaultBibdatabases VALUES (5,344);
INSERT INTO defaultBibdatabases VALUES (5,346);
INSERT INTO defaultBibdatabases VALUES (5,350);
INSERT INTO defaultBibdatabases VALUES (1,336);
INSERT INTO defaultBibdatabases VALUES (4,364);
INSERT INTO defaultBibdatabases VALUES (2,343);

--
-- Table structure for table 'defaultEtexts'
--

CREATE TABLE defaultEtexts (
  discipline_id int(6) default NULL,
  etext_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'defaultEtexts'
--


INSERT INTO defaultEtexts VALUES (5,391);
INSERT INTO defaultEtexts VALUES (5,367);
INSERT INTO defaultEtexts VALUES (1,396);
INSERT INTO defaultEtexts VALUES (1,398);
INSERT INTO defaultEtexts VALUES (1,370);
INSERT INTO defaultEtexts VALUES (3,382);
INSERT INTO defaultEtexts VALUES (3,354);
INSERT INTO defaultEtexts VALUES (3,383);
INSERT INTO defaultEtexts VALUES (2,462);
INSERT INTO defaultEtexts VALUES (4,402);
INSERT INTO defaultEtexts VALUES (4,474);
INSERT INTO defaultEtexts VALUES (2,470);
INSERT INTO defaultEtexts VALUES (4,401);
INSERT INTO defaultEtexts VALUES (4,400);
INSERT INTO defaultEtexts VALUES (2,397);
INSERT INTO defaultEtexts VALUES (5,392);
INSERT INTO defaultEtexts VALUES (5,348);
INSERT INTO defaultEtexts VALUES (5,329);
INSERT INTO defaultEtexts VALUES (1,369);
INSERT INTO defaultEtexts VALUES (1,368);
INSERT INTO defaultEtexts VALUES (3,387);
INSERT INTO defaultEtexts VALUES (2,459);

--
-- Table structure for table 'defaultLibraries'
--

CREATE TABLE defaultLibraries (
  discipline_id int(6) default NULL,
  libraries_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'defaultLibraries'
--


INSERT INTO defaultLibraries VALUES (5,251);
INSERT INTO defaultLibraries VALUES (5,250);
INSERT INTO defaultLibraries VALUES (5,246);
INSERT INTO defaultLibraries VALUES (1,251);
INSERT INTO defaultLibraries VALUES (1,250);
INSERT INTO defaultLibraries VALUES (1,261);
INSERT INTO defaultLibraries VALUES (3,251);
INSERT INTO defaultLibraries VALUES (3,260);
INSERT INTO defaultLibraries VALUES (4,251);
INSERT INTO defaultLibraries VALUES (4,259);
INSERT INTO defaultLibraries VALUES (2,251);
INSERT INTO defaultLibraries VALUES (2,254);
INSERT INTO defaultLibraries VALUES (5,258);
INSERT INTO defaultLibraries VALUES (5,256);
INSERT INTO defaultLibraries VALUES (1,248);
INSERT INTO defaultLibraries VALUES (1,257);
INSERT INTO defaultLibraries VALUES (1,256);
INSERT INTO defaultLibraries VALUES (3,250);
INSERT INTO defaultLibraries VALUES (3,261);
INSERT INTO defaultLibraries VALUES (3,249);
INSERT INTO defaultLibraries VALUES (3,257);
INSERT INTO defaultLibraries VALUES (3,256);
INSERT INTO defaultLibraries VALUES (4,246);
INSERT INTO defaultLibraries VALUES (4,249);
INSERT INTO defaultLibraries VALUES (4,263);
INSERT INTO defaultLibraries VALUES (4,256);
INSERT INTO defaultLibraries VALUES (2,249);
INSERT INTO defaultLibraries VALUES (2,257);
INSERT INTO defaultLibraries VALUES (2,256);

--
-- Table structure for table 'defaultProfiles'
--

CREATE TABLE defaultProfiles (
  defaultProfile_id int(6) NOT NULL default '0',
  discipline_id int(6) NOT NULL default '0',
  lower_bounds varchar(255) NOT NULL default '',
  upper_bounds varchar(255) NOT NULL default ''
) TYPE=MyISAM;

--
-- Dumping data for table 'defaultProfiles'
--


INSERT INTO defaultProfiles VALUES (134,5,'Q','QA');
INSERT INTO defaultProfiles VALUES (137,1,'P','Q');
INSERT INTO defaultProfiles VALUES (133,2,'B','BD');
INSERT INTO defaultProfiles VALUES (490,4,'M','N');
INSERT INTO defaultProfiles VALUES (489,3,'Q','QA');

--
-- Table structure for table 'defaultQseaches'
--

CREATE TABLE defaultQseaches (
  discipline_id int(6) default NULL,
  qsearch_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'defaultQseaches'
--


INSERT INTO defaultQseaches VALUES (5,3);
INSERT INTO defaultQseaches VALUES (5,7);
INSERT INTO defaultQseaches VALUES (1,8);
INSERT INTO defaultQseaches VALUES (1,7);
INSERT INTO defaultQseaches VALUES (3,3);
INSERT INTO defaultQseaches VALUES (3,7);
INSERT INTO defaultQseaches VALUES (4,3);
INSERT INTO defaultQseaches VALUES (4,7);
INSERT INTO defaultQseaches VALUES (2,3);
INSERT INTO defaultQseaches VALUES (2,7);
INSERT INTO defaultQseaches VALUES (2,330);
INSERT INTO defaultQseaches VALUES (5,4);
INSERT INTO defaultQseaches VALUES (5,211);
INSERT INTO defaultQseaches VALUES (1,2);
INSERT INTO defaultQseaches VALUES (1,4);
INSERT INTO defaultQseaches VALUES (1,211);
INSERT INTO defaultQseaches VALUES (3,330);
INSERT INTO defaultQseaches VALUES (3,4);
INSERT INTO defaultQseaches VALUES (3,211);
INSERT INTO defaultQseaches VALUES (4,330);
INSERT INTO defaultQseaches VALUES (4,4);
INSERT INTO defaultQseaches VALUES (4,211);
INSERT INTO defaultQseaches VALUES (2,4);
INSERT INTO defaultQseaches VALUES (2,211);

--
-- Table structure for table 'defaultReferences'
--

CREATE TABLE defaultReferences (
  discipline_id int(6) default NULL,
  reference_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'defaultReferences'
--


INSERT INTO defaultReferences VALUES (5,4);
INSERT INTO defaultReferences VALUES (5,298);
INSERT INTO defaultReferences VALUES (5,1);
INSERT INTO defaultReferences VALUES (1,4);
INSERT INTO defaultReferences VALUES (1,322);
INSERT INTO defaultReferences VALUES (1,315);
INSERT INTO defaultReferences VALUES (3,4);
INSERT INTO defaultReferences VALUES (3,323);
INSERT INTO defaultReferences VALUES (3,310);
INSERT INTO defaultReferences VALUES (4,4);
INSERT INTO defaultReferences VALUES (4,2);
INSERT INTO defaultReferences VALUES (4,294);
INSERT INTO defaultReferences VALUES (2,326);
INSERT INTO defaultReferences VALUES (2,2);
INSERT INTO defaultReferences VALUES (5,299);
INSERT INTO defaultReferences VALUES (1,323);
INSERT INTO defaultReferences VALUES (1,316);
INSERT INTO defaultReferences VALUES (1,3);
INSERT INTO defaultReferences VALUES (1,1);
INSERT INTO defaultReferences VALUES (1,420);
INSERT INTO defaultReferences VALUES (3,3);
INSERT INTO defaultReferences VALUES (3,314);
INSERT INTO defaultReferences VALUES (3,299);
INSERT INTO defaultReferences VALUES (4,308);
INSERT INTO defaultReferences VALUES (4,307);
INSERT INTO defaultReferences VALUES (4,3);
INSERT INTO defaultReferences VALUES (4,1);
INSERT INTO defaultReferences VALUES (2,325);
INSERT INTO defaultReferences VALUES (2,311);
INSERT INTO defaultReferences VALUES (2,3);
INSERT INTO defaultReferences VALUES (2,1);
INSERT INTO defaultReferences VALUES (5,420);
INSERT INTO defaultReferences VALUES (1,429);
INSERT INTO defaultReferences VALUES (3,420);
INSERT INTO defaultReferences VALUES (4,420);
INSERT INTO defaultReferences VALUES (2,420);
INSERT INTO defaultReferences VALUES (5,428);
INSERT INTO defaultReferences VALUES (1,328);
INSERT INTO defaultReferences VALUES (3,430);
INSERT INTO defaultReferences VALUES (4,431);
INSERT INTO defaultReferences VALUES (2,432);

--
-- Table structure for table 'defaultUniversity'
--

CREATE TABLE defaultUniversity (
  discipline_id int(6) default NULL,
  university_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'defaultUniversity'
--


INSERT INTO defaultUniversity VALUES (5,280);
INSERT INTO defaultUniversity VALUES (5,284);
INSERT INTO defaultUniversity VALUES (1,280);
INSERT INTO defaultUniversity VALUES (1,278);
INSERT INTO defaultUniversity VALUES (1,273);
INSERT INTO defaultUniversity VALUES (3,280);
INSERT INTO defaultUniversity VALUES (3,279);
INSERT INTO defaultUniversity VALUES (3,284);
INSERT INTO defaultUniversity VALUES (4,280);
INSERT INTO defaultUniversity VALUES (4,279);
INSERT INTO defaultUniversity VALUES (4,284);
INSERT INTO defaultUniversity VALUES (2,268);
INSERT INTO defaultUniversity VALUES (2,265);
INSERT INTO defaultUniversity VALUES (2,282);
INSERT INTO defaultUniversity VALUES (5,281);
INSERT INTO defaultUniversity VALUES (5,270);
INSERT INTO defaultUniversity VALUES (5,286);
INSERT INTO defaultUniversity VALUES (1,274);
INSERT INTO defaultUniversity VALUES (1,270);
INSERT INTO defaultUniversity VALUES (1,286);
INSERT INTO defaultUniversity VALUES (3,276);
INSERT INTO defaultUniversity VALUES (3,272);
INSERT INTO defaultUniversity VALUES (3,264);
INSERT INTO defaultUniversity VALUES (3,286);
INSERT INTO defaultUniversity VALUES (4,272);
INSERT INTO defaultUniversity VALUES (4,270);
INSERT INTO defaultUniversity VALUES (4,286);
INSERT INTO defaultUniversity VALUES (2,280);
INSERT INTO defaultUniversity VALUES (2,279);
INSERT INTO defaultUniversity VALUES (2,281);
INSERT INTO defaultUniversity VALUES (2,274);
INSERT INTO defaultUniversity VALUES (2,270);
INSERT INTO defaultUniversity VALUES (2,286);

--
-- Table structure for table 'disciplines'
--

CREATE TABLE disciplines (
  discipline_id int(6) NOT NULL default '0',
  discipline_name varchar(255) default NULL,
  motd_text blob,
  PRIMARY KEY  (discipline_id)
) TYPE=MyISAM;

--
-- Dumping data for table 'disciplines'
--


INSERT INTO disciplines VALUES (1,'Literature','Reading is <i>really</i> FUNdamental.');
INSERT INTO disciplines VALUES (2,'Philosophy','Contigo ero sum.\r\n\r\n');
INSERT INTO disciplines VALUES (3,'Mathematics','How can you be sure 2 + 2 = 4?');
INSERT INTO disciplines VALUES (4,'Music','Music soothes the sole of the savage beast.\r\n');
INSERT INTO disciplines VALUES (5,'Astronomy','People who do astronomy are lunatics.');

--
-- Table structure for table 'etexts'
--

CREATE TABLE etexts (
  etext_id int(6) NOT NULL default '0',
  etext_name varchar(255) default NULL,
  etext_url varchar(255) default NULL,
  etext_note varchar(255) default NULL,
  etext_fkey varchar(255) NOT NULL default '',
  etext_date date NOT NULL default '0000-00-00',
  etext_lcd int(1) NOT NULL default '0',
  PRIMARY KEY  (etext_id)
) TYPE=MyISAM;

--
-- Dumping data for table 'etexts'
--


INSERT INTO etexts VALUES (329,'Astronomy Now Online','http://www.astronomynow.com/','Popular Astronomy Magazine from the U.K.','','2000-11-17',0);
INSERT INTO etexts VALUES (368,'Anagram','http://www.jhu.edu/~anagram/','Literature, photography, and other art of the Asian American culture.','','2000-11-17',0);
INSERT INTO etexts VALUES (320,'Center for EUV Astrophysics Newsletter','http://www.cea.berkeley.edu/','Official Publication of the Center for EUV Astrophsics at Berkeley','','2000-11-17',0);
INSERT INTO etexts VALUES (367,'Space Policy Digest','http://www.spacepolicy.org/','Articles discussing issues in space policy, funding, future endeavors.','','2000-11-17',0);
INSERT INTO etexts VALUES (354,'Living Reviews in Relativity Compendium','http://www.livingreviews.org/sitecontents.html','A peer-reviewed journal offering articles in the field of relativity.','','2000-11-17',0);
INSERT INTO etexts VALUES (369,'Bartleby','http://www.bartleby.com/','Internet publishings of books, verse and reference.','','2000-11-17',0);
INSERT INTO etexts VALUES (324,'Publications of the Astronomy Society of Australia','http://www.atnf.csiro.au/pasa/','Offers electronic versions of articles published by the Astronomy Society of Australia','','2000-11-17',0);
INSERT INTO etexts VALUES (348,'Earth Observation Quarterly','http://esapub.esrin.esa.it/eoq/eoq.htm','Free publication about the activities of the European Space Agency\'s Earth Observation Programme.','','2000-11-17',0);
INSERT INTO etexts VALUES (370,'January Magazine','http://www.januarymagazine.com/index.html','Offers reviews of mostly mainstream fiction, non-fiction, sci-fi, mysteries, and childrens books.','','2000-11-20',1);
INSERT INTO etexts VALUES (373,'Internet Writing Journal','http://www.writerswrite.com/journal/','Provides articles, reviews, interviews and an events calendar.','','2000-11-30',0);
INSERT INTO etexts VALUES (380,'Early Modern Literary Studies','http://www.shu.ac.uk/emls/emlshome.html','Journal that examines English literature, literary culture, and language during the sixteenth and seventeenth centuries.','','2000-11-17',0);
INSERT INTO etexts VALUES (381,'Renaissance Forum','http://www.hull.ac.uk/renforum/','Journal specializing in early-modern English literary and historical scholarship and in critical methodology.','','2000-11-30',0);
INSERT INTO etexts VALUES (382,'Notices of the American Mathematical Society','http://www.ams.org/notices/','Publishes expository articles about mathematics research, information and news pertaining to the mathematics profession, and opinion pieces on a range of topics.','','2000-11-17',0);
INSERT INTO etexts VALUES (383,'Geometry & Topology','http://www.maths.warwick.ac.uk/gt/','Refereed international journal dealing with all aspects of geometry and topology and their applications','','2000-11-17',0);
INSERT INTO etexts VALUES (385,'Electronic Journal of Combinatorics','http://www.combinatorics.org/','A fully-refereed electronic journal that welcomes papers in all branches of discrete mathematics, including combinatorics, graph theory, discrete algorithms, etc.','','2000-11-30',0);
INSERT INTO etexts VALUES (386,'New York Journal of Mathematics','http://nyjm.albany.edu:8000/nyjm.html','Electronic journal of general mathematics with full-text article back to 1994.','','2000-11-20',1);
INSERT INTO etexts VALUES (387,'Documenta Mathematica','http://www.math.uiuc.edu/documenta/','Refereed general mathematics journal with full-text articles available in a gzip postscript format.','','2000-11-17',0);
INSERT INTO etexts VALUES (388,'Journal of Integer Sequences','http://www.research.att.com/~njas/sequences/JIS/','This journal is devoted to papers dealing with integer sequences and related topics.','','2000-11-17',0);
INSERT INTO etexts VALUES (389,'Electronic Journal of Differential Equations','http://ejde.math.unt.edu/welcome.html','Covers topics related to differential equations and their applications. \r\n','','2000-11-17',0);
INSERT INTO etexts VALUES (390,'Electronic Journal of Linear Algebra','http://isis5.math.temple.edu/iic/ela/','A journal that welcomes mathematical articles that contribute new information and new insights to matrix analysis and the various aspects of linear algebra and its applications.','','2000-11-17',0);
INSERT INTO etexts VALUES (391,'Traces of Catastrophe','http://www.lpi.usra.edu/publications/books/CB-954/CB-954.intro.html','Full-text book by Bevan M. French concerning meteorite impact.','','2000-11-20',1);
INSERT INTO etexts VALUES (392,'Origin of the Moon','http://adsabs.harvard.edu/books/ormo/','Full-text of papers presented at the Conference on the Origin of the Moon, Hawaii.','','2000-11-17',0);
INSERT INTO etexts VALUES (394,'Energy Output of the Universe','http://nedwww.ipac.caltech.edu/level5/Fabian2/frames.html','Full-text book by A.C. Fabian','','2000-11-30',1);
INSERT INTO etexts VALUES (396,'Through the Looking Glass','http://www.literature.org/authors/carroll-lewis/through-the-looking-glass/','Lewis Carroll\'s novel in full-text online.','','2000-11-17',0);
INSERT INTO etexts VALUES (397,'Discourse on the Method','http://www.literature.org/authors/descartes-rene/reason-discourse/','Full-text of Descarte\'s classic.','','2000-11-30',0);
INSERT INTO etexts VALUES (458,'Cultural Logic','http://eserver.org/clogic/','Electronic Journal of Marxist Theory and Practice.','','2000-11-30',0);
INSERT INTO etexts VALUES (398,'Adventures of Huckleberry Finn','http://www.literature.org/authors/twain-mark/huckleberry/','Full-text of novel by Mark Twain.','','2000-11-30',0);
INSERT INTO etexts VALUES (399,'Library of Southern Literature','http://docsouth.unc.edu/southlit/southlit.html','Collection of electronic full-texts and an Introduction to Literature of the American South.','','2000-11-17',0);
INSERT INTO etexts VALUES (400,'Music Theory Online','http://smt.ucsb.edu/mto/mtohome.html','The electronic Journal for the Society of Music Theory.','','2000-11-17',0);
INSERT INTO etexts VALUES (401,'Research Perspectives in Music Education','http://www.arts.usf.edu/music/rpme.html','Professional research journal for music educators and students.','','2000-11-17',0);
INSERT INTO etexts VALUES (402,'Journal of Seventeenth Century Music','http://www.sscm.harvard.edu/jscm/Welcome.html','Provides a forum for articles regarding the study of the music culture of the seventeenth century.','','2000-11-17',0);
INSERT INTO etexts VALUES (403,'Ls Scena Musicale','http://www.scena.org/','Journal from Canada, emphasis on reviews of performances of classical works, interviews and other articles.','','2000-11-17',0);
INSERT INTO etexts VALUES (404,'Sorcerer','http://diamond.idbsu.edu/GaS/sorcerer/html/sorcerer_home.html','Full-text of Gillbert and Sullivan Opera.','','2000-11-30',0);
INSERT INTO etexts VALUES (405,'Gillbert and Sullivan Opera, A History and a Comment','http://diamond.idbsu.edu/GaS/books/walbrook/index.html','Book about all the Gillbert and Sullivan Operas.','','2000-11-17',0);
INSERT INTO etexts VALUES (423,'All etexts and ejournals','http://hegel.lib.ncsu.edu/development/disciplines/00-etexts-and-ejournals.html','This is a list of all etexts and ejournals organized alphabetically.','','2000-11-21',1);
INSERT INTO etexts VALUES (459,'Techne: Journal of the Society for Philosophy and Technology','http://scholar.lib.vt.edu/ejournals/SPT/spt.html','Electronic journal published by the Scholarly Communications Project dealing with the application of philosophy in the science fields.','','2000-11-30',0);
INSERT INTO etexts VALUES (460,'Electronic Journal of Analytic Philosophy','http://www.phil.indiana.edu/ejap/ejap.html','Issues on topics of special concern to analytic philosophers.','','2000-11-30',0);
INSERT INTO etexts VALUES (471,'Student Journal of Philosophy','http://rideau.carleton.ca/philosophy/cusjp/','Refereed Journal containing articles written by graduate and undergraduate students of philosophy.','','2000-12-01',0);
INSERT INTO etexts VALUES (462,'Minerva','http://www.ul.ie/~philos/','An internet journal of Philosophy edited by faculty at the University of Limerick, Ireland.','','2000-11-30',0);
INSERT INTO etexts VALUES (469,'Kant\'s Critique of Pure Reason','http://www.arts.cuhk.edu.hk/Philosophy/Kant/cpr/','E-text of Kant\'s work, translated by Norman Smith.','','2000-12-01',0);
INSERT INTO etexts VALUES (470,'Issues in Ethics','http://www.scu.edu/SCU/Centers/Ethics/publications/iie/','Publication of the Markkula Center for Applied Ethics at Santa Clara University.','','2000-12-01',0);
INSERT INTO etexts VALUES (472,'Aphil Library','http://coombs.anu.edu.au/Depts/RSSS/Philosophy/Texts/TextsTOC.html','Collection of full text of many classic works, divided by Philosopher.','','2000-12-01',0);
INSERT INTO etexts VALUES (474,'Ethnomusicology Online','http://research.umbc.edu/efhm/eol.html','Peer-reviewed multimedia e-journal.','','2000-12-01',0);
INSERT INTO etexts VALUES (475,'Online Trombone Journal','http://www.trombone.org/','The Online Trombone Journal is dedicated to the advancement of the trombone, its literature, and pedagogy.','','2000-12-01',0);
INSERT INTO etexts VALUES (476,'J.S. Bach Text of the Complete Vocal Works','http://www.uvm.edu/~classics/faculty/bach/','Translated with commentary, full text of Bach vocal works.','','2000-12-01',0);

--
-- Table structure for table 'guestbook'
--

CREATE TABLE guestbook (
  name varchar(255) default NULL,
  email varchar(255) default NULL,
  can_contact int(1) default NULL,
  date_visited varchar(10) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'guestbook'
--



--
-- Table structure for table 'help_simple'
--

CREATE TABLE help_simple (
  help_id int(6) NOT NULL default '0',
  help_title varchar(255) default NULL,
  help_text blob,
  PRIMARY KEY  (help_id)
) TYPE=MyISAM;

--
-- Dumping data for table 'help_simple'
--


INSERT INTO help_simple VALUES (1,'Customize Quick Searches','<!--USER-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nYou may select the resources you would like to be able to search from your MyLibrary page. They will appear as resources in your Quick Searches drop-down menu of resources.\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (2,'Customize bibliographic databases','<!--USER-->\n\n<blockquote>\n\nUse this page to customize your database selections.<p>\n\nThese are your current selections. You may remove  items by clicking to eliminate the check mark, then select \'Customize\' to activate your change.\n\n</blockquote>');
INSERT INTO help_simple VALUES (3,'Customize University links','<!--USER-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe MyLibrary system allows you to personally customize the university links which appear on your page.  Use the check boxes on the left to select or remove items.\n\n</p>\n\n<p>\n\nThis is a select group of University links. If the one you need is not here then you may either add it using the Personal Links option or send a message to your librarian asking that the link be considered.\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (4,'Customize electronic journals','<!--USER-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this page to edit your\n\nelectronic journal selections.\n\nRemember, a journal may appear\n\nin more than one subject area.\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (5,'Customize reference shelf','<!--USER-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nTo remove items from your Reference Shelf, unselect any of the checkboxed items below.\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (6,'Customize personal links','<!--USER-->\n\n<blockquote>\n\n<big>\n\nUse this page to edit your\n\nyour personal selection of \n\ninternet resources.</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (7,'Customize NCSU Libraries','<!--USER-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this page to edit your selection of NCSU Library links.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (8,'Customize your Profile','<!--USER-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nYour Profile is personal information related to your account and your interest areas. Use this page to customize or change your information.\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (9,'Customize your title and colors','<!--USER-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this page to have the system remember your title and color preferences. Caution! It is easy to select color combinations that make some functions unreadable. Use \"Re-instate defaults\" to return the color assignments to their default state. \n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (10,'Create New Account','<!--USER-->\n\nUse this form to create a new account in MyLibrary. All fields are required in order to guarantee unique accounts. ');
INSERT INTO help_simple VALUES (11,'Some fields are empty','<!--public-->\n\nIn order to create a MyLibrary account you must supply values for all the fields. \n\nSome of the fields on the previous page were not completed. \n\nPlease use your browser\'s back button or <a href=\"./?cmd=customizeNewUser\">try again</a>.');
INSERT INTO help_simple VALUES (12,'Passwords did not match','<!--user-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUnfortunately, the password you supplied did not match. \n\nPlease use your browser\'s <b>back</b> button and try again.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (13,'Username already taken','<!--public-->\n\nThe user name you have selected is already taken. Please use your browser\'s back button and try again.');
INSERT INTO help_simple VALUES (14,'Username too short','<!--public-->\n\nThe user name you have selected is too short. It must be at least 6 characters long. Please use your browser\'s back button and try again. ');
INSERT INTO help_simple VALUES (15,'Password too short','<!--user-->\n\n<blockquote>\n\n<big>\n\n<p>The password you have selected is too short. It must be at least 8 characters long. Please use your browser\'s <b>back</b> button and try again.\n\n</big>\n\n</p>\n\n</blockquote>');
INSERT INTO help_simple VALUES (16,'Login to MyLibrary','<!--user-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this page to login into MyLibrary.\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (17,'Thank you for being with us','<!--public-->\r\n\r\n<p>\r\nYou are now logged out of MyLibrary, but you must quit your browser to insure nobody can edit your page.\r\n</p>');
INSERT INTO help_simple VALUES (18,'Logout?','<!--user-->\n\n<blockquote>\n\n<big>\n\n<p>You only need to logout if the computer you are using is used by other people.</p>\n\n\n\n<p><a href=\"./?cmd=killCookie\">Logout</a> or <a href=\"./\">return</a> to MyLibrary.\n\n</p>\n\n</big></blockquote>');
INSERT INTO help_simple VALUES (19,'Welcome to MyLibrary','<!--public-->\n\n<blockquote>\n\n\n\n<p>\n\nWelcome! MyLibrary is a user-driven, customizable information service providing access to Internet resources</p>\n\n\n\n<ul>\n\n<li>I already have a profile, <a href=\"./?cmd=findPatron\">open my account </a>.</li>\n\n\n\n<li>I do not have an account, <a href=\"./?cmd=customizeNewUser\">create one</a>.\n\n\n\n</ul>\n\n\n\n<p>By telling us a bit about yourself, MyLibrary provides the faculty, students, and staff at this institution with the ability to create a portable Web page listing information resources available from the Libraries. A more <a href=\"./?cmd=about&id=39\">detailed description</a> is available online. See also the page listing <a href=\"./?cmd=about&id=40\">end-user computer requirements</a>.\n\n</p>\n\n\n\n\n\n<h2>MyLibrary Computer Requirements</h2>\n\n\n\n<p>\n\nTo use MyLibrary all you need is a Web browser. The browser must support cookies and it must be configured to <em>not</em> look in its cache for its content. For more information, see the page listing <a href=\"./?cmd=about&id=40\">end-user computer requirements</a>.\n\n</p>\n\n\n\n<h2>Privacy</h2>\n\n\n\n<p>\n\nThe configurations you make to MyLibrary are held in the strictest of confidence. Just as with  doctor-patient and lawyer-client relationships, confidentiality is assured for library transactions and inquiries. For more information, see our <a href=\"./?cmd=about&id=41\">Privacy Statement</a>.\n\n</p>\n\n\n\n\n\n</blockquote>');
INSERT INTO help_simple VALUES (20,'Username/password combination not found','<!--public-->\r\n<p>\r\nThe user name/password combination you entered was not found in the database: You have three options:\r\n</p>\r\n\r\n<ol>\r\n<li><a href=\"./?cmd=findPatron\">Try to log in again</a>\r\n<li><a href=\"./?cmd=customizeNewUser\">Create a new account</a>\r\n<li>Ask for technical support\r\n</ol>');
INSERT INTO help_simple VALUES (21,'Logged in','<!--user-->\n\n<blockquote>\n\n<big>\n\n\n\n<p>\n\nYou are now logged into MyLibrary.\n\n</p>\n\n\n\n<a href=\"./?cmd=saveCookie&wants_cookie=1\">Show me my page and remember me so I don\'t have to log in again</a> (<a href=\"./?cmd=about&id=161\">Help</a>)\n\n<br><b><i>DO NOT use this option if you are using MyLibrary from a shared computer.</b></i>\n\n<br>or<br>\n\n<a href=\"./?cmd=saveCookie&wants_cookie=0\">just show me my page</a> (<a href=\"./?cmd=about&id=160\">Help</a>). \n\n\n\n<p>\n\nRemember, there are many resources accessible in MyLibrary@NCState that require you to dynamically use the library\'s proxy server. Please read <a href=\"http://www.lib.ncsu.edu/proxy/proxy_description.html\">how to configure your browser for proxy services</a>.\n\n</p>\n\n\n\n<p>\n\nThe information you enter into MyLibrary is confidential. For more information, see the our <a href=\"./?cmd=about&id=41\">Privacy Statement</a>.\n\n</p>\n\n\n\n\n\n\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (22,'Customize Current Awareness Service','<!--USER-->\n\n<blockquote>\n\n\n\n<p>\n\nUse this page to customize your Current Awareness Service profile.\n\n</p>\n\n\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (23,'Your Current Awareness profiles','<!--public-->\n\n<blockquote>\n\n\n\n<p>\n\nBelow are listed the call number ranges you have previously created. You can delete them or <a href=\"./?cmd=cam4one\">test</a> them.\n\n</p>\n\n\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (24,'List of Personal Links','<!--user-->\n\n<blockquote>\n\n<big>\n\nThis is the list of Internet links you have created.\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (25,'Customize discipline-specific journal selection','<!--USER-->\n\n<blockquote>\n\n<big>\n\nUse this page to select journals. Please be aware that our list of journals is increasing and changing daily.\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (26,'Journals listed by discipline','<blockquote>\n\n<big>\n\n<p>\n\nTo make new journal selections, first choose from the disciplines below and then make selections from the resulting lists.<!--USER-->\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (27,'Discipline-specific databases','<blockquote>\n\n<big>\n\n<p>\n\nSelect databases here.<!--USER-->\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (28,'Discipline-specific references','<blockquote>\n\n<big>\n\n\n\nSelect from the disciplines below to choose more reference shelf items.<!--USER-->\n\n\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (29,'Customize discipline-specific reference shelf items','<!--USER-->\n\n<blockquote>\n\n<big>\n\nUse this page to edit your reference shelf items.\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (30,'Customize discipline-specific bibliographic databases','<!--USER-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nChoose discipline specific databases here.    \n\n\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (31,'About Personal Links','<!--USER-->\n\n<blockquote>\n\n\n\n<p>\n\nThe Personal Links section allows you to add Internet resources to your page that are not found in the MyLibrary database. For example, you could add here the URL of your home page, online courses, or links to your favorite hobbies.\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (32,'About Quick Searches','<!--USER-->\n\n<blockquote>\n\n\n\n<p>\n\nThe Quick Searches provide fast and direct access to commonly used books and databases.\n\n</p>\n\n\n\n\n\n<h2>How to use</h2>\n\n\n\n<p>\n\nTo use the Quick Searches:\n\n</p>\n\n\n\n<ol>\n\n<li>Choose a resource from the pop-up menu.\n\n<li>Enter a query into the text field.\n\n<li>Select the Search button.\n\n</ol>\n\n\n\n<p>\n\nMyLibrary will then take your query, remember it for your future reference, and send it to the chosen resource\'s search engine. The results of the search will then be displayed in your browser\'s window.\n\n</p>\n\n\n\n<p>\n\nIf you want to apply the same query to another resource, then simply choose a different one from the pop-up menu and select the Search button.\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (33,'About Reference Shelf','<!--USER-->\n\n<blockquote>\n\n\n\n<p>\n\nThe MyLibrary system allows you to personally customize the resources that appear on your page.  You may perform any of the following functions:\n\n<ul>\n\n<li> Remove previously selected items\n\n<li> Add items from any disciplinary area\n\n<li> Create your updated MyLibrary page\n\n</ul>\n\nIf an item you need is not available please send a message to your Librarian.\n\n\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>');
INSERT INTO help_simple VALUES (34,'About Bibliographic Databases','<!--USER-->\n\n<blockquote>\n\n<p>\n\nBibliographic databases are indexes to journal literature. By searching these databases for particular authors, titles, subjects, or keywords, you can identify journal articles that meet your research needs.\n\n</p>\n\n\n\n<p>\n\nSome of the bibliographic databases have the full-text of articles and some do not. Consequently, the articles you locate using these tools will only sometimes be found online.\n\n</p>\n\n\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>');
INSERT INTO help_simple VALUES (35,'About Electronic Journals','<!--USER-->\n\n<blockquote>\n\n\n\n<p>\n\nThe NCSU Libraries licenses more than 1000 full-text, electronic journals. These journals are listed here.\n\n</p>\n\n<p>\n\nThis section of MyLibrary is changing almost daily.  This is in large part due to the differing interfaces, protocols, and access points for many of the electronic journals to which we subscribe at the NCSU Libraries. Many of the journals listed will only be available to users on the local NC State Network; we are working rapidly to add off-campus access to these titles.  Please pardon any inconvenience, and we will keep you updated on progress through this help page as well as via the global messages.\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>');
INSERT INTO help_simple VALUES (36,'About Your Librarians','<!--USER-->\n\n<blockquote>\n\n\n\n<p>\n\nListed here are the names and addresses of people who can directly help you with your library needs.\n\n</p>\n\n\n\n<p>\n\nThe staff of the Libraries have areas of subject expertise corresponding to the academic disciplines of the University. Based on the discipline you selected when creating your profile, the names of the librarians who are best able to help you are listed in the Your Librarians section.\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (37,'About University Links','<!--USER-->\n\n<blockquote>\n\n\n\n<p>\n\nThe Libraries have made a selection of some of the links from the University\'s home pages and made them available in this section. \n\nThe Librarian in your interest area may have pre-selected some University pages for you. These selections may be modified under Customize.\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>');
INSERT INTO help_simple VALUES (38,'About Library Links','<!--USER-->\n\n<blockquote>\n\n\n\n<p>\n\nListed here are links to information about the Libraries such as hours, e-forms, departments, services, staff home pages, the <cite>Bulletin,</cite> and the<cite> Focus.</cite>\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>');
INSERT INTO help_simple VALUES (39,'About MyLibrary','<!--USER-->\n\n<blockquote>\n\n<big>\n\n\n\n<p>\n\nMyLibrary is a user-driven, customizable information service hosted by the NCSU Libraries. By telling us a bit about yourself, MyLibrary allows you to create a portable Web page listing information resources available from the Libraries.\n\n</p>\n\n\n\n</big>\n\n\n\n<h2>Features</h2>\n\n\n\n<p>\n\nMyLibrary is a new kind of Web page allowing you to define what is displayed. It is:\n\n</p>\n\n\n\n<ul>\n\n\n\n<p>\n\n<li><b>Content rich</b> - The database supporting MyLibrary contains links to information-rich content. It represents the sort of content necessary to do real research in an academic environment. Types of information include full-text databases, data sets, bibliographic databases, electronic texts of all kinds, ready reference materials, and most importantly, direct access to librarians.\n\n</p>\n\n\n\n<p>\n\n<li><b>Portable</b> - Since you create for yourself a MyLibrary username and password you can login to MyLibrary just about anywhere there is Web browser.\n\n</p>\n\n\n\n<p>\n\n<li><b>Customizable</b> - By selecting the customizable options, you choose just what items you want displayed, or, more importantly, what items are not displayed.\n\n</p>\n\n\n\n<p>\n\n<li><b>Dynamic</b> - Global messages, as well as discipline-specific messages, help keep MyLibrary fresh. Because MyLibrary is easy for us to maintain, MyLibrary\'s content is continually kept up-to-date.\n\n</p>\n\n\n\n<p>\n\n<li><b>Pro-active</b> - Because the networked environment is constantly changing, MyLibrary allows librarians to send you messages or information (like lists of recently received books) on a regular basis. Of course, you will only be contacted in this way only if you turn these features on.\n\n</p>\n\n\n\n<p>\n\n<li><b>Focused</b> - Most of the time, MyLibrary allows you to list only the information you want listed. Consequently, you do not have to be bombarded with \"noise\". At the same time, you are not limited to the number of items you have on your page.\n\n</p>\n\n\n\n<p>\n\n<li><b>Platform independent</b> - To use MyLibrary all you need is a Web browser. The browser must support cookies and it must be configured to <em>not</em> look in its cache for its content. If you access MyLibrary from a non-NC State University domain, then your browser must support a protocol called Secure Socket Layer (SSL) for security purposes. For more information, see the page listing <a href=\"./?cmd=about&id=40\">end-user computer requirements</a>.\n\n</p>\n\n\n\n<p>\n\n<li><b>Private</b> - The configurations you make to MyLibrary are held in the strictest of confidence. Just like the doctor-patient and lawyer-client relationships, there exists a librarian-patron relationship that is held in the strictest of confidence. For more information, see our <a href=\"./?cmd=about&id=41\">Privacy Statement</a>.\n\n</p>\n\n</ul>\n\n\n\n<h2>Technically speaking</h2>\n\n\n\n<p>\n\nA brain-child of the Digital Library Initiatives Department of the NCSU Libraries, the technical foundation of MyLibrary is a relational database, a Web server, and a set of scripts providing mediation between the two. A more <a href=\"/about/\">complete description of the how\'s and why\'s of MyLibrary</a> is also available online.\n\n</p>\n\n\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (40,'End-user computer requirements','<P>\n\nTo use MyLibrary@NCState you need an NC State University Unity account and a Web browser. The <A HREF=\"http://www2.ncsu.edu/ncsu/cc/pub/cc_forms/unityapp-intro.html\">Unity account</A> is used to uniquely identify you as a member of the NC State Universitiy community. The Web browser is the tool used to interface with the system and has to support two basic functions:\n\n</P>\n\n\n\n<OL>\n\n	<p>\n\n<LI>Forms - Your browser must support HTML forms where forms provide the ability to complete electronic data-entry fields. All but the oldest of Web browsers support HTML forms.\n\n</p>\n\n\n\n<p>\n\n	<LI>SSL - SSL is an acronym for Secure Socket Layer, and when you are asked to log into MyLibrary your browser will need to support SSL so your Unity username and password cannot be read by outsiders.\n\n</p>\n\n</OL>\n\n\n\n<p>\n\nIn short, any version of Internet Explorer greater than 2.0 or any version of Netscape Navigator greater than 3.0 will function correctly with MyLibrary@NCState.<!--ADMIN-->\n\n</p>');
INSERT INTO help_simple VALUES (41,'Privacy Statement','<!--user-->\n\n<P>\n\nPersonal information provided will be used in accordance with the Code of Fair Information Practices. It will not be re-distributed or used for any purpose other than to customize this service. Any personal data collected will not be sold to parties outside of the NCSU Libraries.\n\n</P>\n\n\n\n<P>\n\nLinks are provided throughout the system to both commercial and publicly available sites. Many databases have restrictive licensing requirements to which NC State must adhere in order to offer access. These restrictions are contractual with the database producer and limit access to NC State faculty, staff, and students.\n\n</P>\n\n\n\n<P>\n\nNeither North Carolina State University, nor the North Carolina Cooperative Extension Service, are responsible for the accuracy, currency, and content of any \"OFF-SITE\" WEB pages referenced from this server. Also, reference in this system to any specific commercial product, process, service, manufacturer, or company does not constitute its endorsement or recommendation by the developers and site administrator. \n\n</P>\n\n<p><a href=\"./\">Return to MyLibrary</a>');
INSERT INTO help_simple VALUES (42,'About Message from your librarian','<!--USER-->\n\n<blockquote>\n\n\n\n<p>\n\nHere you will find notes from your librarian related to your information interests. The notes may contain links to remote resources, announcements of upcoming training events, or descriptions of new resources.\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (43,'Customize profile','<!--USER-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThere are two different profile customizations:\n\n<ol>\n\n<li>Name, e-mail address, and discipline information (<a href=\"./?cmd=about&id=46\">about</a> | <a href=\"./?cmd=customizeProfile\">customize</a>)\n\n<!-- <li>Current Awareness Manager (<a href=\"./?cmd=about&id=45\">about</a> | <a href=\"./?cmd=customizeCAMProfile\">customize</a>) -->\n\n<li>Title and colors (<a href=\"./?cmd=about&id=44\">about</a> | <a href=\"./?cmd=customizeColors\">customize</a>)\n\n</ol>\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (44,'About customizing title and colors','<!--USER-->\n\n<blockquote>\n\n\n\n<p>\n\nYou can change the colors and title of your MyLibrary page by using the Customize Title/colors page.\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>');
INSERT INTO help_simple VALUES (45,'About Current Awareness Manager','<!--USER-->\n\n<blockquote>\n\n<p>\n\nThe Current Awareness Manager (CAM) is a service allowing you to get regular email listings of the new books received by the NCSU Libraries.\n\n</p>\n\n<p>\n\nBy associating one or more CAM profiles, which are Library of Congress call number ranges, with your MyLibrary account, you can be regularly made aware of new books, serials, and online databases added to the library\'s collection.\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>\n\n\n\n</p>');
INSERT INTO help_simple VALUES (46,'About customizing your name','<!--USER-->\n\n<blockquote>\n\n\n\n<p>\n\nUse your ability to customize your name, e-mail address and discipline information to tell us a bit about yourself. This information will allow us to provide better service to you and make MyLibrary a more useful service. The name you select will be used in the opening Welcome greeting.\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (47,'Call number ranges','<!--USER-->\n\n<blockquote>\n\n\n\n<p>\n\nEnter the call numbers representing the subject range of the items you want to receive notification of on a regular basis. For more information about call number ranges, see our <a href=\"./schedule.html\">brief call number schedule</a>.\n\n</p>\n\n\n\n</blockquote>');
INSERT INTO help_simple VALUES (48,'Test CAM','<!--public-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this page to test your CAM profiles.\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (49,'Administer MyLibrary','<!--ADMIN-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this page to administer the features of MyLibrary.\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (52,'Edit the style sheet','<blockquote>\n\n<big>\n\n<p>\n\nUse this page to edit the cascading style sheet. Simply enter what you would like the style sheet to look like and submit the Edit button.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (53,'Style sheet success?','<blockquote>\n\n<big>\n\n<p>\n\nBelow should be the text of the style sheet.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (54,'Edit the banner or footer','<p>\r\n<!--ADMIN-->\r\nUse this page to edit the banner or footer, which is the text appearing at the top and bottom of patrons\' MyLibrary pages. These \"documents\" are intended to include HTML markup.\r\n</p>\r\n<p>\r\nRemember, the banner supports four (4) tokens: bannerColor, patronFirst, patronLast, patronUsername. By including any of these tokens in the banner you can display the patron\'s first name, last name, and/or username in the banner. Don\'t forget to surround the tokens with percent signs (ex: %%bannerColor%%).\r\n</p>\r\n');
INSERT INTO help_simple VALUES (55,'Banner success?','<!--ADMIN-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nBelow should be rendering of the banner.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (56,'Edit global MOTD','<blockquote>\n\n<big>\n\n<p>\n\nUse this page to edit the text appearing just under every patron\'s initial colored bar on their MyLibrary page. This is called the global message of the day (MOTD).\n\n<p>\n\n\n\n<!--ADMIN-->\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (57,'MOTD success?','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nBelow should appear a rendering of the global MOTD. Remember to check your spelling!\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (58,'Select Simple Help texts','<blockquote>\n\n<big>\n\n<p>\n\nUse this page to select a Simple Help text to edit. Simple Help texts are the informational texts, like this one, that tell about a service, function, or a feature.\n\n<p>\n\n<p>\n\nThe texts are listed alphabetically and are intended to be unique. The numbers in parentheses to the right of each text represents the texts\' unique id number. This number is necessary when using the About function call.\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (59,'Edit Simple Help texts','<blockquote>\n\n<big>\n\n<p>\n\nUse the form below to edit the selected Simple Help text.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (60,'Simple Help text success?','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nBelow should be the title and text of your edited Simple Help text.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (61,'Edit CAM disclaimer','<blockquote>\n\n<big>\n\n<p>\n\nUse this page to edit the text that will appear at the top of every patron\'s email message receiving the Current Awareness Manager (CAM) service.\n\n<p>\n\n<p>\n\n<b>WARNING!</b> <u>Do not include HTML markup,</u> in this message and remember to hardwrap your text.<!--ADMIN-->\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (62,'Successful CAM edit?','<blockquote>\n\n<big>\n\n<p>\n\nThe Current Awareness Manager service disclaimer text should appear below.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (63,'Manage patrons','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this page to manage the patron records.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (64,'Find a patron','<blockquote>\n\n<big>\n\n<p>\n\nUse this page to find a patron. For more information about searching the database, see the <a href=\"./?cmd=about&id=65\">help text</a>.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (65,'How to search','<P>\n\nSearching for items in the MyLibrary database is rather straight forward. There are essentially two types of searches: exact match and stemming. Both are <u>case-insensitive</u> and both only search the human readable name of the resource, not the URL or description fields:\n\n</P>\n\n\n\n<OL>\n\n<P>\n\n	<LI>Exact match - To use this search type select \"is\" from the pop-up menu and then enter your query in the text field. Barring case, it will locate all the items in the database that are equal to your query. You will use exact match queries infrequently.\n\n</P>\n\n\n\n<P>\n\n	<LI>Stemming - To use this search type select \"like\" from the pop-up menu. Enter your query in the text field and make sure your query includes at least one (1) percent symbol (%). The percent symbol is the wild-card character and the search engine allows left-hand, right-hand, and internal wild-card searching. For example, all of the following stemming search queries are valid and will find the items with the word library in its title:\n\n</p>\n\n\n\n<OL>\n\n	<LI>librar% - will locate all items beginning with the characters \"librar\"\n\n	<LI>%ibrary - will locate all items ending with the characters \"ibrary\"\n\n	<LI>%ibrar% - will locate all items where the characters \"ibrar\" appear anywhere in the title\n\n</OL>\n\n\n\n<p>\n\nIt is expected that you will use something like example #3 most often.<!--USER-->\n\n</P>\n\n</OL>');
INSERT INTO help_simple VALUES (66,'Found patrons','<blockquote>\n\n<big>\n\n<p>\n\nListed here are the patron records matching your query. They are listed in alphabetical order by last name and first name.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (67,'Delete patron','<blockquote>\n\n<big>\n\n<p>\n\nEnter the ID of a patron record you want to delete. Be careful, <u>there is no undo</u>, yet.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (68,'Patron deleted','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe patron record has been deleted. Poof!\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (69,'Select patron record','<blockquote>\n\n<big>\n\n<p>\n\nEnter the ID of a patron record you want to edit.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (70,'Edit patron','<blockquote>\n\n<big>\n\n<p>\n\nUse this form to edit the patron\'s record.<!--ADMIN-->\n\n<p>\n\n</big>\n\n\n\n</blockquote>');
INSERT INTO help_simple VALUES (71,'Patron changed','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe patron record has been changed.\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (72,'Manage Collection Managers','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse these functions to create, find, edit, and delete the records describing Collection Managers.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (73,'Collection Manager, Create','<!--ADMIN-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this form to create a Collection Manager record. It really helps if <u>all</u> the fields have values. \n\n<p>\n\n<h5>Remember: Listing yourself as \"The All Powerful One\" is fine, but may get you more than you bargained.</h5>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (74,'Collection Manager created','<!--ADMIN-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe following Collection Manager record has been created.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (75,'Collection Manager, find','<!--ADMIN-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this form to find a collection manager record. For more information about using the find features, see the <a href=\"./?cmd=about&id=65\">other help text</a>.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (76,'Collection Manager, located','<!--ADMIN-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe list below contains all the Collection Manager records found from your search.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (77,'Collection Manager, delete','<!--ADMIN-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nEnter the ID representing the collection manager record you want to delete.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (78,'Collection Manager, deleted','<!--ADMIN-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe collection manager record has been deleted. Poof!\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (79,'Collection Manager, edit','<!--ADMIN-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nWhat is the ID number of the collection manager record you want to edit? Submit it.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (80,'Collection Manager, select to edit','<!--ADMIN-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this form to edit a Collection Manager record. It really helps if all the fields have values.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (81,'Collection Manager, edited','<!--ADMIN-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe collection manager record has been edited. Thank you for keeping the database up-to-date. \"We love clean data!\"\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (82,'Librarians, manage','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse the functions below to manage the data representing the reference librarians.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (83,'Librarians, create','<blockquote>\n\n<big>\n\n<p>\n\nThis is the form you use to create a librarian record. <u>Be complete!</u><H5> And do not list yourself as either Sheena, Warrior Princess or the Mighty Hercules unless you are prepared for the consequences!</H5>\n\n<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (84,'Librarians, created','<blockquote>\n\n<big>\n\n<p>\n\nThe following librarian record has been created. Sit back and enjoy the ride!<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (85,'Librarians, find','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this page to find records describing librarians. See the <a href=\"./?cmd=about&id=65\">other help text</a> for more information.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (86,'Librarians, located','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe following librarian records match your query.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (87,'Librarians, select for delete','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nEnter the ID number of the librarian record you want to delete.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (88,'Librarians, deleted','<blockquote>\n\n<big>\n\n<p>\n\nThe librarian record has been deleted.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (89,'Librarians, select for edit','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nEnter the ID number of the librarian record you want to edit.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (90,'Librarians, edit','<! -- admin -->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this form to edit the record describing a librarian. Please be complete.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (91,'Librarians, edited','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe record has been updated. Thank you for keeping our database clean.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (92,'Disciplines, manage','<blockquote>\n\n<big>\n\n<p>\n\nUse this page to manage the disciplines, the controlled vocabulary that drives the entire MyLibrary service.\n\n<p>\n\n\n\n<p>\n\n<font color=\"red\">Use this service only after you have communicated with your Subject Teams. Use with care.<!--ADMIN--></font>\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (93,'Disciplines, create','<blockquote>\n\n<big>\n\n<p>\n\nUse this form to create disciplines.\n\n<p>\n\n\n\n<p>\n\nBe careful. We want to create enough disciplines to cover most people\'s information needs, but at the same time we do not want to overwhelm our users by having them select one or more disciplines from a menu of 100 or more items.\n\n<p>\n\n\n\n<p>\n\nAs a librarian, use your best judgement and communicate with your <b>Subject Teams</b> before creating new discipline headings.<!--ADMIN-->\n\n</p>\n\n\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (94,'Disciplines, created','<blockquote>\n\n<big>\n\n<p>\n\nThe following discipline has been created. Remember that it now exists in every category available in MyLibrary.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (95,'Disciplines, find','<blockquote>\n\n<big>\n\n<p>\n\nUse this page to find a discipline to edit or delete. For more help in using find, see the <a href=\"./?cmd=about&id=65\">other help text</a>.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (96,'Disciplines, located','Use the form below to edit the selecte\nd Simple Help text. <!--ADMIN-->');
INSERT INTO help_simple VALUES (97,'Disciplines, select for delete','<blockquote>\n\n<big>\n\n<p>\n\nSubmit the ID number of the discipline you want to delete.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (98,'Disciplines, deleted','<blockquote>\n\n<big>\n\n<p>\n\nThe discipline has been deleted. <P>\n\nConsider the following: Do any users need to be made aware that their discipline is GONE?<!--ADMIN-->\n\n\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (99,'Disciplines, select for edit','<blockquote>\n\n<big>\n\n<p>\n\nSubmit the ID number of a discipline heading you want to edit.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (100,'Disciplines, edit','<blockquote>\n\n<big>\n\n<p>\n\nUse this form to edit a discpline\'s name.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (101,'Disciplines, updated','<blockquote>\n\n<big>\n\n<p>\n\nThe discipline record has been updated.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (102,'Messages, select','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nDiscipline-specific messages from librarians provide you with the opportunity to be proactive and update your clientele about things they may want to know that are of particular interest to their discipline.\n\n<p>\n\n\n\n<p>\n\nSelect a discipline to edit its message.\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (103,'Messages, edit','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nEnter the text you would like to have appear in the section labeled \"Message from your librarian.\" The message can, but does not have to, include HTML markup.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (104,'Messages, changed','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe message has been changed and should appear below.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (105,'Defaults, select','<blockquote>\n\n<big>\n\n<p>\n\nUse this page to select a discipline and then define the default resources for that discipline.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (106,'Defaults, edit','<blockquote>\n\n<big>\n\n<p>\n\nUse this form to edit the defaults for a particular discipline.\n\n<p>\n\n\n\n<p>\n\nYou can select more than one item from the scrolling lists by Command-clicking (Macintosh) or Ctrl-clicking (Windows) on individual items. You can select ranges of items by shift-clicking (both operating systems) on more than one item.\n\n</p>\n\n\n\n<p>\n\nHere\'s a hidden feature. If the defaults for two or more disciplines are very similar, then create the defaults for one discipline and use it as a model for the others. To do this, first create the defaults for one discipline. Save the edits. Then edit that discipline again, change the value of the pop-up menu at the top of the form, modify the values from the remaining fields, and submit the changes.<!--ADMIN-->\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (107,'Defaults, defined','<blockquote>\n\n<big>\n\n<p>\n\nThe defaults for the discipline have been created\n\n<p>\n\n\n\n<p>\n\nRemember the hidden feature. If the defaults for two or more disciplines are very similar, then create the defaults for one discipline and use it as a model for the others. To do this, first create the defaults for one discipline. Save the edits. Then, edit that discipline again, change the value of the pop-up menu at the top of the form, modify the values from the remaining fields, and submit the changes.\n\n</p>\n\n\n\n<p>\n\nYou might want to use your browser\'s back button and try the hidden feature now.<!--ADMIN-->\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (108,'Libraries, manage','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse these pages to maintain the links to pages describing the services of the Libraries. Items like hours, e-forms, and informational links are intended to go here.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (109,'Libraries, create','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this page to create a Libraries record. <p>\n\nIf you use jargon then please be sure that the description is complete and de-jargonizes the record for the user.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (110,'Libraries, created','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe following Libraries record was created.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (111,'Libraries, find','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this page to locate a Libraries record. Remember, the <a href=\"./?cmd=about&id=65\">other help text</a> describes in more detail how to use the find form.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (112,'Libraries, located','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe following records match your query. They are sorted by title.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (113,'Libraries, select for delete','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nEnter the ID number of the Libraries record you want to delete.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (114,'Libraries, delete','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe record has been deleted. I hope you didn\'t make a mistake. Sometime in the future we will include an \"Are you sure?\" message. Stay tuned.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (115,'Libraries, select for edit','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nEnter the ID number of the Libraries record you wish to edit.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (116,'Libraries, edit','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this form to edit the Libraries record below. Enjoy.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (117,'Libraries, edited','<blockquote>\n\n<big>\n\n<p>\n\nThe record has been edited. It\'s been fun. Come back again soon.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (118,'Journals, manage','<blockquote>\n\n<big>\n\n<p>\n\nUse this page to manage the journals links.\n\n<p>\n\n\n\n</p>The things here are (were) intended to include only the electronic journals the Libraries subscribes to, but I advocate the inclusion of other electronic journals as well. Enjoy.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (119,'Journals, create','<blockquote>\n\n<big>\n\n<p>\n\nUse this page to create a journal record.\n\n</p>\n\n\n\n<p>\n\nPlease supply all the information. If you do not supply a database control number from the MARION database, the output will produce errors. \"Garbage in, garbage out.\" <!--ADMIN-->\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (120,'Journals, created','<blockquote>\n\n<big>\n\n<p>\n\nThe following journal record was created.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (121,'Journals, find','<blockquote>\n\n<big>\n\n<p>\n\nUse this page to find a journal record. See the <a href=\"./?cmd=about&id=65\">detailed find help</a> page for more information about constructing queries.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (122,'Journals, located','<blockquote>\n\n<big>\n\n<p>\n\nThe following journal records match your query. They are listed in alphabetical order, hopefully.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (123,'Journals, select for deletion','<blockquote>\n\n<big>\n\n<p>\n\nEnter the ID of the journal record you want to delete. WARNING! There is no going back, yet.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (124,'Journals, deleted','<blockquote>\n\n<big>\n\n<p>\n\nThe record has been deleted. Now we have some hard disk space for something else. Thanks!<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (125,'Journals, select for editing','<blockquote>\n\n<big>\n\n<p>\n\nSubmit the ID of a journal record you want to edit. <!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (126,'Journals, edit','<blockquote>\n\n<big>\n\n<p>\n\nEdit the journal record below. \"We love clean data.\"<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (127,'Journals, edited','<blockquote>\n\n<big>\n\n<p>\n\nThe record has been changed. Thank you for maintaining MyLibrary.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (128,'University, manage','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this page to manage the University links.\n\n<p>\n\n\n\n<p>\n\nUniversity links are intended to be the most important and/or prominent links from the University\'s Web page and subpages. The links here are intended to supplement, not replace, the University\'s home page in an effort to create a \"one-stop shopping\" experience for our users.\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (129,'University, create','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this page to create a University link. Please provide complete information; don\'t assume any thing is obvious. \n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (148,'Reference, manage','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this page to manage the collection of Reference links.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (130,'University, created','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe following record has been created.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (131,'University, find','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this page to locate a University link. Use the <a href=\"./?cmd=about&id=65\">extended help page</a> to learn more about searching.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (132,'University, located','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nBelow are listed the University links matching your query. They should be listed in alphabetical order.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (133,'University, select for deletion','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nSubmit the ID number of the University record you want to delete. Remember, there is no going back, yet.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (134,'University, deleted','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe University record has been deleted. \n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (135,'University, select for editing','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nEnter the ID number of the University record you want to edit.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (136,'University, edit','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this form to edit the selected University record. Provide complete information.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (137,'University, changed','<blockquote>\n\n<big>\n\n<p>\n\nThe record has been updated. \n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (138,'Databases, manage','<blockquote>\n\n<big>\n\n<p>\n\nUse these functions to manage the collection of database records in MyLibrary.<!--ADMIN-->\n\n<p>\n\n\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (139,'Databases, create','<blockquote>\n\n<big>\n\n<p>\n\nUse this form to create a database record. Please fill out completely. The form must include a DB control number or the end-user will not be able to get a description of the resource.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (140,'Databases, created','<blockquote>\n\n<big>\n\n<p>\n\nThe following database record has been created. <!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (141,'Databases, find','<blockquote>\n\n<big>\n\n<p>\n\nUse this form to locate a database record. Read the <a href=\"./?cmd=about&id=65\">extended find help text</a> to learn more about find\'s features.<!--ADMIN-->\n\n\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (142,'Databases, located','<blockquote>\n\n<big>\n\n<p>\n\nThe following records match your query. They are listed in alphabetical order.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (143,'Databases, select for delete','<blockquote>\n\n<big>\n\n<p>\n\nEnter the ID number of the database record you want to delete.\n\n</p>\n\n\n\n<p>\n\nHere is where you must use confidence and self-assuredness since there is no going back. Once you click that Delete button your record will be deleted. Look to future releases to add a \"Are you sure?\" screen.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (144,'Databases, deleted','<blockquote>\n\n<big>\n\n<p>\n\nThe record has been deleted.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (145,'Databases, select for editing','<blockquote>\n\n<big>\n\n<p>\n\nEnter the ID of the database record you want to edit.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (146,'Databases, edit','<blockquote>\n\n<big>\n\n<p>\n\nUse this form to edit the selected database record. Please be complete.<!--ADMIN-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (147,'Databases, changed','<!--ADMIN-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe database record has been changed. Keep up the good work. We appreciate your time and effort in keeping the database maintained.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (149,'Reference, create','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this page to create a Reference link.\n\n<p>\n\n<p>\n\nAs originally intended, Reference links were meant to encompass \"reference\" materials. These things included: dictionaries, encyclopedias, almanacs, thesari, handbooks, bibliographies, pathfinders, directories, etc. You know, stuff from Reference 101.\n\n</p>\n\n<p>\n\nPlease be as complete as possible and do not assume anything is obvious.\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (150,'Reference, created','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe following Reference links have been created.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (151,'Reference, find','<p>\r\nUse this page to find a Reference link. Consult the <a href=\"./?cmd=about&id=65\">extended help text</a> for more information on using find.\r\n<p>\r\n');
INSERT INTO help_simple VALUES (152,'Reference, located','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nYour query returned the following links. They are listed in alphabetical order.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (153,'Reference, select for deletion','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nSubmit the ID of the Reference link you want to delete. \n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (154,'Reference, delete','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nPoof! The Reference link has been deleted.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (155,'Reference, select for edit','<blockquote>\n\n<big>\n\n<p>\n\nEnter the ID of the Reference link you want to edit.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (156,'Reference, edit','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThis is the page you can use to edit a Reference link. Please be as complete as possible.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (157,'Reference, changed','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nThe Reference link has been edited. Thank you for helping to maintain MyLibrary. Your efforts are appreciated.\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (158,'Help - Login, username','<blockquote>\n\n<big>\n\n<p>\n\nEnter your MyLibrary username. You may have selected a username that is the same as your UnityID name.\n\n</p>\n\n<p>\n\nIf you have forgotten your username or password, please contact <a href=\"mailto:mylibary@emorgan.lib.ncsu.edu\">mylibary@emorgan.lib.ncsu.edu</a>.<!--USER-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (159,'Help - Login, password','<blockquote>\n\n<big>\n\n<p>\n\nEnter your password.\n\n</p>\n\n<p>\n\nTo protect your privacy, your password will appear as asterisks (i.e. ********) on the screen. If you created your MyLibrary username to match your UnityID username you were advised to <strong>not use</strong> your UnityID password in order to preserve UnityID privacy. Passwords must be a minimum of 8 characters (letters or numbers).<!--USER-->\n\n</p>\n\n<p>\n\nIf you have forgotten your username or password, please contact <a href=\"mailto:mylibrary@emorgan.lib.ncsu.edu\">mylibrary@emorgan.lib.ncsu.edu</a>.\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (160,'Help - View your page','<blockquote>\n\n\n\n<p>\n\nTo use MyLibrary you need a Web browser that supports cookies and it must be configured to not look in its cache for its content. The cache is generally configured in under your browser\'s preferences. \n\n</p>\n\n<p>\n\nIf you access MyLibrary from a non-NC State University domain, your browser must support a protocol called Secure Socket Layer (SSL) for security purposes. Current versions of Netscape and Internet Explorer both support these requirements.<!--USER--> \n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>');
INSERT INTO help_simple VALUES (161,'Help - Save cookie','<blockquote>\n\n\n\n<p>\n\nA MyLibrary cookie is a personal profile reminder placed in a file on your computer. It provides for an automatic login to your personal MyLibrary page.  If you access your personal page from a computer that is publically accessible <strong>do not save a cookie</strong>. When a cookie is saved to a computer, anyone requesting the MyLibrary URL from that computer will be logged into your personal account. When accessing your personal MyLibrary page from a machine with no cookie, simply login and then <strong>remember to logout</strong>. Logout is located in the top title bar.<!--USER-->\n\n<p>\n\n\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</p>\n\n</blockquote>');
INSERT INTO help_simple VALUES (162,'Help - Firstname','<blockquote>\n\n<big>\n\n<p>\n\nEnter your first name or name by which you prefer to be addressed.<!--USER-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (163,'Help - Lastname','<blockquote>\n\n<big>\n\n<p>\n\nEnter your surname.<!--USER-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (164,'Help - Discipline','<blockquote>\n\n<big>\n\n<p>\n\nSelect the discipline which best represents the area of your information needs. This is the discipline area to which your page will be tailored. You may add resources from other discipline areas by selecting \"customize\" from the main resource headings, such as Electronic Resources or Bibliographic Databases.<!--USER-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (165,'Help - Keywords','<blockquote>\n\n<big>\n\n<p>\n\nEntering a sentence description or subject specific keywords will help us in future upgrades to further tailor the product to your specifications.<!--USER-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (166,'Help - Rank','<blockquote>\n\n<big>\n\n<p>\n\nEnter your current status at NC State University. If more than one type applies, select one to be primary.<!--USER-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (167,'Help - Email address','<blockquote>\n\n<big>\n\n<p>\n\nEnter your entire email address. For Example:<p>\n\nmylibrary@unity.ncsu.edu <p>\n\nmy_library@ncsu.edu\n\n<!--USER-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (168,'Help - Can contact?','<blockquote>\n\n\n\n<p>\n\nThis lets us know if we may contact you directly via email with information relevant to either MyLibrary or to new information products in your discipline area. <!--USER-->\n\n<p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>');
INSERT INTO help_simple VALUES (169,'Help - Telephone','<blockquote>\n\n<big>\n\n<p>\n\nThis provides us with an alternate method of contacting you should a problem arise with the product.<!--USER-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (170,'Help - Want HTML','<blockquote>\n\n<big>\n\n<p>\n\nThis lets us know if you would like your files sent to you in HTML, readable via your browser, or if you would prefer a plain text email.<!--USER-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (171,'Help - Want Current Awareness','<blockquote>\n\n<big>\n\n<p>\n\nThis is a service which will send you a list of the new books received by the NCSU Libraries. This system is based on the Library of Congress Classification System which organizes books by 21 broad subject areas. The LC system of classification begins with letters and then is followed by a combination of letters and numbers. The 21 categories (labeled A to Z, but missing I, O, W, X and Y) are further divided by adding one or two additional letters and a set of numbers. This number is unique to each book and is specific to the book\'s content.  For Example:\n\n</p>\n\n<ul>\n\n<li><b>TJ151 .C73 1998</b> CRC Handbook of Mechanical Engineering, 1988\n\n<ol>\n\n<li><b>TJ151</b> Mechanical Engineering and Machinery\n\n<li><b>.C73</b> Cutter number based on the first word in the title.\n\n</ol>\n\n<li><b>NA190 .W380</b> The rise of architectural history by David Watkin.\n\n<ol>\n\n<li><b>NA190</b> Architecture. Historical monuments.\n\n<li><b>.W380</b> Cutter number based on authors last name.\n\n<!--USER-->\n\n</ol>\n\n</ul>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (172,'Help - Lower bounds','<blockquote>\n\n<big>\n\n<p>\n\nThis represents the point in the subject classification you would like to begin receiving books. For Example:<p>\n\nIf you are interested in the area of Mechanical Engineering you should begin your range with a call number of <b>TJ1</b><p>\n\nIf you are interested in Economic history and conditions you should begin your range with a call number of <b>HD28</b><p><!--USER-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (173,'Help - Upper bounds','<blockquote>\n\n<big>\n\n<p>\n\nThis represents the point in the subject classification you would like to end of the range of books you receive.  For example:<p>\n\n<ul>\n\n<li>You are interested in books on Geology <b>QE1-996.5</b> but not books on Biology which begins with <b>QH1</b> \n\n<li>You must select as your upper bounds a number greater than the greatest number in the<b>QE</b> range. For examble:\n\n 	<ul>\n\n		<li><b>QE9999</b>\n\n	</ul>\n\n </ul><!--USER-->\n\n<p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (174,'Help - Delete Current Awareness profile','<blockquote>\n\n\n\n<p>\n\nThis allows you to delete your settings for Current Awareness manager. You may reconfigure the service to represent a different subject.<!--USER-->\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>');
INSERT INTO help_simple VALUES (175,'Help - Early date','<blockquote>\n\n<big>\n\n<p>\n\nYou may choose how far back you wish to see the items the library has received. For examble:<p>\n\nTo see items received as far back as 1 month choose 4 weeks from the menu.<!--USER-->\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (176,'Help - Late date','<blockquote>\n\n<big>\n\n<p>\n\nYou may choose the latest time after which you do not wish to see books received by the Libraries.  For example:<p>\n\nTo see items received over a week ago choose 1 week.<!--USER-->\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (177,'Help - Test output','<blockquote>\n\n<big>\n\n<p>\n\n<ul>\n\n<li><b>My screen</b> immediately gives you a list of the titles on your browser screen.\n\n<Li><b>My email</b> sends the list to the email address you specified for your self when you customized your profile.\n\n</ul>\n\n<!--USER-->\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (178,'Help - Customize title','<blockquote>\n\n\n\n<p>\n\nYou may create your own title for your personal MyLibrary page. It will appear in the title bar at the top of your browser\'s window.<!--USER-->\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>');
INSERT INTO help_simple VALUES (179,'Help - Customize banner color','<blockquote>\n\n\n\n<p>\n\nYou may change the colors of your display. If you mistakenly select the same color for two or more display elements, remember to use your browser\'s Back button to return to the Customize Title and Colors page.<!--USER-->\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>');
INSERT INTO help_simple VALUES (180,'Help - Customize background color','<blockquote>\n\n\n\n<p>\n\nYou may change the colors of your display. If you mistakenly select the same color for two or more display elements, remember to use your browser\'s Back button to return to the Customize Title and Colors page.<!--USER-->\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>');
INSERT INTO help_simple VALUES (181,'Help - Customize text color','<blockquote>\n\n\n\n<p>\n\nYou may change the colors of your display. If you mistakenly select the same color for two or more display elements, remember to use your browser\'s Back button to return to the Customize Title and Colors page.<!--USER-->\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>');
INSERT INTO help_simple VALUES (182,'Help - Customize link color','<blockquote>\n\n\n\n<p>\n\nYou may change the colors of your display. If you mistakenly select the same color for two or more display elements, remember to use your browser\'s Back button to return to the Customize Title and Colors page.<!--USER-->\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>');
INSERT INTO help_simple VALUES (183,'Help - Customize active link color','<blockquote>\n\n\n\n<p>\n\nYou may change the colors of your display. If you mistakenly select the same color for two or more display elements, remember to use your browser\'s Back button to return to the Customize Title and Colors page.<!--USER-->\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>');
INSERT INTO help_simple VALUES (184,'Help - Customize visited link color','<blockquote>\n\n\n\n<p>\n\nYou may change the colors of your display. If you mistakenly select the same color for two or more display elements, remember to use your browser\'s Back button to return to the Customize Title and Colors page.<!--USER-->\n\n</p>\n\n<p><a href=\"./\">Return to MyLibrary</a>\n\n</blockquote>');
INSERT INTO help_simple VALUES (185,'Help - Personal Link name','<blockquote>\n\n<big>\n\n<p>\n\nEnter the name of the resource you are adding as you would like it to appear on your MyLibrary page.<!--USER-->\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (186,'Help - Personal Link location','<blockquote>\n\n<big>\n\n<p>\n\nEnter the URL of the resource you are adding.  Please note that an incorrect URL will appear as a broken link. <!--USER-->\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (187,'Help - Delete Personal Link','<blockquote>\n\n<big>\n\n<p>\n\nThis allows you to delete an item from your personal links.<!--USER-->\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (188,'Help - Username','<blockquote>\n\n<big>\n\n<p>\n\nYou will use your MyLibrary username to access your personal, customized page of resources. Selecting a username that is the same as your UnityID name will make it easier to remember and facilitate unique usernames for all users.\n\n</p><!--USER-->\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (189,'Help - Password','<blockquote>\n\n<big>\n\n<p>\n\nYour password protects access to your personal page. MyLibrary user accounts are not associated with campus wide UnityID accounts at this point in time. In order to preserve UnityID privacy, DO NOT USE your UnityID password as your MyLibrary password. Select a password that is a minimum of 8 characters (letters or numbers). To protect your privacy, your password will appear as asterisks - ******** - on the screen.<!--USER-->\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (190,'Help - Echo password','<blockquote>\n\n<big>\n\n<p>\n\nRe-enter your password to ensure you have typed it correctly. To protect your privacy, your password will appear as asterisks - ******** - on the screen. When you select the \"create\" button to create the account, if there are typographical differences in the two password entries, you will be asked to try again.<!--USER-->\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (191,'Compose email message','<!--ADMIN-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this page to select who will get the message and compose it.\n\n</p>\n\n</big>\n\n</blockquote>');
INSERT INTO help_simple VALUES (192,'Send mail SQL query','<blockquote>\n\n<big>\n\n<p>\n\nBelow should be the SQL query that will be used to generate the results of your search.\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (193,'Send mail, SQL query results','<blockquote>\n\n<big>\n\n<p>\n\nBelow should be results of the SQL query.\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (194,'Send mail, \"Show me the money!\"','<blockquote>\n\n<big>\n\n<p>\n\nThis is not implemented yet. Sorry. Really.\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (195,'Send mail, no disciplines selected','<blockquote>\n\n<big>\n\n<p>\n\nOops! You did not select any disciplines. Use your browser\'s back button and try again.\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (196,'Send mail, \"Send it to me.\"','<blockquote>\n\n<big>\n\n<p>\n\nThe message you composed has been sent to the following address:\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (197,'Send mail, no first name','<blockquote>\n\n<big>\n\n<p>\n\nOops! You did not supply your first name. Use your browser\'s back button and please try again.\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (198,'Send mail, no last name','<blockquote>\n\n<big>\n\n<p>\n\nYou did not submit a last name. Please go back and enter your last name.\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (199,'Send mail, no email address','<blockquote>\n\n<big>\n\n<p>\n\nYou did not supply your email address. Please try again.\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (200,'Send mail, no subject','<blockquote>\n\n<big>\n\n<p>\n\nNo subject line was included with your message. Please go back and give your message a subject.\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (201,'Send mail, no message','<blockquote>\n\n<big>\n\n<p>\n\nC\'mon. How can you expect to send a message to many people without actually entering any data. Please go back and give your message a... message.\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (202,'Send mail, mail sent','<blockquote>\n\n<big>\n\n<p>\n\nMail has been sent to the following addresses:\n\n</p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (203,'ID not found','<p>\r\nWe\'re sorry, but the ID (cookie) your browser sent the system was not found in the database. You have three choices:\r\n</p>\r\n\r\n<ol>\r\n<li><a href=\"./?cmd=findPatron\">Try to log in manually</a>\r\n<li><a href=\"./?cmd=CustomizeNewUser\">Create a new account</a>\r\n<li>Ask for technical support\r\n</ol>');
INSERT INTO help_simple VALUES (204,'Reports','<p>\r\n<blockquote>\r\n<big>\r\nThese options allow you to perform searches against the MyLibrary database and output <em>simple</em> reports.\r\n</big>\r\n</blockquote>\r\n</p>\r\n');
INSERT INTO help_simple VALUES (205,'Who\'s got the discipline','<!--admin-->\n\n<p>\n\n<big>\n\n<blockquote>\n\nThis report lists each discipline, the librarians, and if collection managers are turned on in the variables.pl file, collection managers associated with that discipline. Each discipline must have at least one librarian associated with it.\n\n</blockquote>\n\n</big>\n\n</p>\n\n');
INSERT INTO help_simple VALUES (206,'Username updated','<blockquote>\n\n<p>\n\nYour MyLibrary username has been updated to equal your Unity ID. Thank you.\n\n</p>\n\n\n\n<p>\n\n<em>Now here\'s the tricky part!</em> Before Wednesday, January 20 you will have to use your Unity ID and your MyLibrary password to manually log into the system.\n\n</p>\n\n\n\n<p>\n\nOn Wednesday, January 20 you will only have to remember your Unity ID and password to gain access to the system.\n\n</p>\n\n\n\n<p>\n\nWe know this is rather confusing, and we thank you for your patience. <a href=\"./\">Click here to be returned to our regularly scheduled program, MyLibrary@NCState</a>.\n\n</p>\n\n\n\n<p>\n\nIf you have any questions, then <a href=\"mailto:mylibrary@emorgan.lib.ncsu.edu\">email us</a>.\n\n</p>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (207,'Static pages, create','<p>\r\nUse these functions to create and update sets of static, browsable HTML files for the library\'s primary Web server. <em>Remember, there are three types of static HTML templates (alphabetic, discipline-based, and index). Be sure to select the correct template for your specific need.</em>\r\n</p>\r\n\r\n\r\n');
INSERT INTO help_simple VALUES (208,'Select disciplines to create','<!--admin-->\n\n<blockquote>\n\nSelect the discipline page(s) you want to create from the MyLibrary database.\n\n</blockquote>');
INSERT INTO help_simple VALUES (209,'Sign the guestbook','<!--public-->\n\n<blockquote>\n\n<p>\n\nPlease sign the guestbook so that we know who is using our guest services. This will also provide a means for you to learn about future developments of the MyLibrary@NCState system.\n\n</p>\n\n\n\n<p>\n\nEnjoy MyLibrary@NCState!\n\n</p>\n\n\n\n</blockquote>');
INSERT INTO help_simple VALUES (210,'View Disciplines','<blockquote>\r\n\r\n<p>\r\nUse this page to list the default/non-default resources associated with disciplines. To use this form:\r\n</p>\r\n\r\n<ol>\r\n<li>Select a discipline to query\r\n<li>Select the sections from that discipline that you want to query\r\n<li>Select how you want the output grouped\r\n<li>Create the report\r\n</ol>\r\n<p>\r\nTry it; you can\'t break it.\r\n</p>\r\n\r\n\r\n</blockquote>\r\n\r\n\r\n\r\n<p>\r\n\r\n<hr>\r\n\r\n</p>');
INSERT INTO help_simple VALUES (211,'View Disciplines Report','<blockquote>\r\n\r\n<p>\r\n\r\nHere is the result of your query.\r\n\r\n</p>\r\n\r\n\r\n\r\n<ul>\r\n\r\n<li>Default links - items prescribed by content providers as recommended links for the selected discipline/section\r\n\r\n<li>Non-default links - items not prescribed by content providers for a selected discipline/section\r\n\r\n<li>Alphabetical list - all items assoicated with the selected discipline/section where items marked with an asterick are default links\r\n\r\n</ul>\r\n\r\n \r\n\r\n</blockquote>\r\n\r\n');
INSERT INTO help_simple VALUES (212,'Link checker','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nUse this form to check and report broken links in the system.\n\n<p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (213,'Link checker results','<!--admin-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nHere are the results of the check. Generally speaking, any item associated with a number that is not 200 is a broken link.\n\n<p>\n\n</big>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (214,'Alphabetic list of journals','<!--USER-->\n\n<blockquote>\n\nSelect the link below to display the complete list of journals in alphabetic order by journal title.\n\n</blockquote>\n\n\n\n<ul>\n\n<li><a href=\"./?cmd=displayAlphabeticJournals\">All journals listed alphabetically by title</a>\n\n</ul>');
INSERT INTO help_simple VALUES (215,'Select electronic journals','<blockquote>\n\nUse the form below to select electronic journals to add to your library.\n\n</blockquote>');
INSERT INTO help_simple VALUES (216,'Alphabetic list of databases','<!--USER-->\n\n<blockquote>\n\nSelect the link below to display the complete list of databases in alphabetic order by database name.\n\n</blockquote>\n\n\n\n<ul>\n\n<li><a href=\"./?cmd=displayAlphabeticDatabases\"> All databases listed alphabetically by name</a>\n\n</ul>');
INSERT INTO help_simple VALUES (217,'Select databases','<blockquote>\n\nUse the form below to select databases to add to your library.\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (218,'No titles found','<!--user-->\n\n<blockquote>\n\n<big>\n\n<p>\n\nSorry, but there are no titles in the database for this discipline and the selected resource type (reference link, bibliographic database, or electronic journal).\n\n</big>\n\n</p>\n\n</blockquote>');
INSERT INTO help_simple VALUES (219,'Impersonate','<blockquote>\n\nBy magic, you are now impersonating a MyLibrary@NCState patron. The patron\'s vital statistics are below, and you can now <a href=\"../\" target=impersonate>view and edit his/her page in a new window</a>. <b>Please remember to logout, or login as yourself after you are finished.</b><!--ADMIN-->\n\n</blockquote>');
INSERT INTO help_simple VALUES (220,'Discipline change','<p>\n\nYou have opted to change your discipline. How do you want your presently customized selections of Reference Shelf, Bibliographic Databases, and Electronic Journal items handled?<!--USER-->\n\n</p>\n\n');
INSERT INTO help_simple VALUES (221,'Guest access','<blockquote>\n\n<p>\n\nMyLibrary@NCState supports guest access, but there is only one guest account. Consequently, any edits you make as guest will not necessarily be there when you visit as a guest again. Similarly, you will see the previous guest\'s configurations.<!--USER-->\n\n</p>\n\n</blockquote>\n\n');
INSERT INTO help_simple VALUES (222,'Manage Discipline','<blockquote>\r\n<p>Use this screen to manage the settings for:\r\n</blockquote>');
INSERT INTO help_simple VALUES (223,'Create New Resource Link','<p>\r\nUse this form to create a link to a new resource.\r\n<p>\r\nIf you use jargon then please be sure that the description is complete and\r\nde-jargonizes the record for the user.');
INSERT INTO help_simple VALUES (224,'Edit Defaults for Discipline','<p>\r\nUse this form to edit the defaults for a particular discipline.\r\n<p>\r\nYou can select more than one item from the scrolling lists by\r\nCommand-clicking (Macintosh) or Ctrl-clicking (Windows) on individual items.\r\nYou can select ranges of items by shift-clicking (both operating systems) on\r\nmore than one item.');
INSERT INTO help_simple VALUES (225,'Preferences, display and edit','');
INSERT INTO help_simple VALUES (226,'Preferences, updated','');
INSERT INTO help_simple VALUES (227,'Quick Searches, create','');
INSERT INTO help_simple VALUES (228,'Quick Searches, created','');
INSERT INTO help_simple VALUES (229,'Quick Searches, Find','');
INSERT INTO help_simple VALUES (230,'Quick Searches, Found','');
INSERT INTO help_simple VALUES (231,'Quick Searches, Edit record number','');
INSERT INTO help_simple VALUES (232,'Quick Searches, Edit','');
INSERT INTO help_simple VALUES (233,'Quick Searches, Edited','');
INSERT INTO help_simple VALUES (234,'Quick Searches, Menu','');
INSERT INTO help_simple VALUES (235,'Quick Searches, Delete record number','');
INSERT INTO help_simple VALUES (236,'Quick Searches, Deleted','');
INSERT INTO help_simple VALUES (237,'Static pages creation, database success','');
INSERT INTO help_simple VALUES (238,'Static pages creation, journals success','');
INSERT INTO help_simple VALUES (239,'Static pages creation, index success','');
INSERT INTO help_simple VALUES (240,'Static pages creation, reference success','');
INSERT INTO help_simple VALUES (241,'Static pages creation, no username','<p>\r\nOops! No username has been specified in the variables.pl file, and consequently, this function will not work. Get the systems administrator to edit the variables.pl file accordingly.\r\n</p>');
INSERT INTO help_simple VALUES (242,'Static pages creation, no password','<p>\r\nOops! No password has been supplied in the variables.pl file, and consequently this function won\'t work. Get the systems administrator to edit the variables.pl file accordingly, and try again.\r\n</p>\r\n');
INSERT INTO help_simple VALUES (243,'Static pages creation, no host','<p>\r\nOops! The name of the remote computer, host, where files are to be copied has not been defined in the variables.pl file. Have the systems administrator edit the variables.pl file accordingly and try again.\r\n</p>');
INSERT INTO help_simple VALUES (244,'Static pages creation, no relative path','<p>\r\nOops! The name of the path relative to the root of your hypertext document tree has not been defined in the variables.pl file. Have the systems administrator edit the variables.pl file accordingly and try again.\r\n</p>');
INSERT INTO help_simple VALUES (245,'Static pages creation, no root path','<p>\r\nOops! The name of the full path (root) defining where files are to be copied to has not been defined in the variables.pl file. Have the systems administrator edit the variables.pl file accordingly and try again.\r\n</p>');
INSERT INTO help_simple VALUES (246,'Edit discipline profile ranges','<p>\r\nUse this page to edit the default profile (call number) ranges for each discipline.  These ranges will be used to populate Current Awareness (New Book Shelf) profiles for first time users. First, select a discipline to edit from the pop-up menu. Second, enter call number ranges in the resulting form. Delete call number ranges from the list of previously created profiles. Remember, <em>keep the profiles simple</em> because this system is not very smart when it comes to sorting call numbers.\r\n</p>\r\n');
INSERT INTO help_simple VALUES (247,'Template, User, Menu','<p>\r\nUse the items below to manage your collection of user templates. For more information, see the <a href=./?cmd=about&id=268>text describing user templates in detail</a>.\r\n</p>');
INSERT INTO help_simple VALUES (248,'Template, User, Create','<p>\r\nUse this form to create new user templates. <em>Every field must have a value,</em> and remember, write the template as if it were an ordinary HTML file and delimit the tokens with a pair of percent signs (%). For more information, see the <a href=./?cmd=about&id=268>text describing user templates in detail</a>.\r\n</p>');
INSERT INTO help_simple VALUES (249,'Template, User, Created','<p>\r\nThe user template has been saved to the database.\r\n</p>');
INSERT INTO help_simple VALUES (250,'Template, User List all','<p>\r\nThis is a list of all the user templates.\r\n</p>');
INSERT INTO help_simple VALUES (251,'Template, User Edit select','<p>To edit a user template, enter a template ID.</p>');
INSERT INTO help_simple VALUES (252,'Template, User Edit','<p>Use this form to edit a user template. For more information, see the <a href=./?cmd=about&id=268>text describing user templates in detail</a>.');
INSERT INTO help_simple VALUES (253,'Template, User Edited','<p>The user template as been edited and saved to the database.</p>');
INSERT INTO help_simple VALUES (254,'Template, User, Delete select','<p>To delete a user template, enter a template ID.</p>');
INSERT INTO help_simple VALUES (255,'Template, User, Deleted','<p>The user template has been deleted.</p>');
INSERT INTO help_simple VALUES (256,'Template, Help','<p>\r\nTemplates are like MP3 player \"skins\". They allow you to have your content displayed in your choice of styles.\r\n</p>');
INSERT INTO help_simple VALUES (257,'Login first','<p>You must create a new account or log in before you can customize the page:</p>\r\n\r\n<ul>\r\n<li><a href=\"./?cmd=customizeNewUser\">Create a new account</a>\r\n<li><a href=\"./?cmd=findPatron\">Log in</a>\r\n</ul>\r\n');
INSERT INTO help_simple VALUES (258,'Template, Free, Menu','<p>Use the items below to manage your collection of  <a href=./?cmd=about&id=260>\"free\" templates</a>.</p>');
INSERT INTO help_simple VALUES (259,'Template, Free, Create','Use this form to create new \"free\" templates. Free templates are the template used to display resources when users have not logged into the system. Every field must have a value, and remember, write the template as if it were an ordinary HTML file and delimit the <a href=./?cmd=about&id=260>tokens</a> with pairs of percent signs (%). ');
INSERT INTO help_simple VALUES (260,'Template, Free, Tokens described','<p>This text describes the free tokens for free templates. Print this page.</p>\r\n\r\n<p>\r\nFree templates represent the HTML to display to users when they have not yet logged into the system. The templates can include any sort of HTML you desire and they can include any number of the available \"free tokens\". Tokens are place holders for information extracted from this system\'s underlying database. Each token in your template(s) are case-sensitive and they must be surrounded by pairs of percent signs (%%).\r\n</p>\r\n\r\n<p>For example, if you wanted your free template to contain no lists of resources but just the Message Of The Day, then your template may look like this:\r\n\r\n<blockquote>\r\n&lt;html&gt;<br>\r\n&lt;head&gt;<br>\r\n&lt;title&gt;Library&lt;/title&gt;<br>\r\n&lt;style type=\"text/css\"&gt;%%stylesheet%%&lt;/style&gt;<br>\r\n&lt;/head&gt;<br>\r\n&lt;body&gt;<br>\r\n&lt;p&gt;The Message Of The Day is: %%motd%%.&lt;/p&gt;<br>\r\n&lt;/body&gt;<br>\r\n&lt;/html&gt;<br>\r\n</blockquote>\r\n\r\n<p>\r\n<em>Be forewarned</em>. This system is not a text editor; it is a database. Create your templates outside this system, next import them here, and only do minor tweaks in the system itself.\r\n</p>\r\n\r\n<p>\r\nHere is a list of all the \"free tokens\" and their definitions:\r\n</p>\r\n\r\n<dl>\r\n	<dt>title</dt>\r\n		<dd>The title as defined in the global preferences</dd>\r\n	<dt>stylesheet</dt>\r\n		<dd>The value of the stylesheet as created/specified in the administrative interface</dd>\r\n	<dt>bgcolor</dt>\r\n		<dd>The background color as defined in the global preferences</dd>\r\n	<dt>link</dt>\r\n		<dd>The link color as defined in the global preferences</dd>\r\n	<dt>alink</dt>\r\n		<dd>The active link color as defined in the global preferences</dd>\r\n	<dt>vlink</dt>\r\n		<dd>The visited link color as defined in the global preferences</dd>\r\n	<dt>text</dt>\r\n		<dd>The text color as defined in the global preferences</dd>\r\n	<dt>bannerColor</dt>\r\n		<dd>The banner color as defined in the global preferences</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>banner</dt>\r\n		<dd>The contents of the banner</dd>\r\n	<dt>motd</dt>\r\n		<dd>The contents of the global message of the day</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>aboutMyLibrary</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing this system (ID #39)</dd>\r\n	<dt>customizeProfile</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text allowing users to customize their profile (ID #43)</dd>\r\n	<dt>logout</dt>\r\n		<dd>A relative URL allowing patrons to log out</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>yourLibrarians</dt>\r\n		<dd>The name of the \"Your Librarians\" section as defined in the global preferences</dd>\r\n	<dt>aboutLibrarians</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the librarians (ID #36)</dd>\r\n	<dt>librarians</dt>\r\n		<dd>The generic librarians blurb as defined in the global preferences</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>libraryLinks</dt>\r\n		<dd>The name of the \"Library Links\" section as defined in the global preferences</dd>\r\n	<dt>aboutLibraryLinks</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the \"Library Links\" (ID #38)</dd>\r\n	<dt>customizeLibraryLinks</dt>\r\n		<dd>A relative URL pointing to a form allowing users to customize the \"Library Links\"</dd>\r\n	<dt>listLibraryLinks</dt>\r\n		<dd>An HTML ordered list of all \"Library Links\" classified as LCD resources</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>universityLinks</dt>\r\n		<dd>The name of the \"Community Links\" section as defined in the global preferences</dd>\r\n	<dt>aboutUniversityLinks</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the \"Community Links\" (ID #37)</dd>\r\n	<dt>customizeUniversityLinks</dt>\r\n		<dd>A relative URL pointing to a form allowing users to customize the \"Community Links\"</dd>\r\n	<dt>listUniversityLinks</dt>\r\n		<dd>An HTML ordered list of all \"Community Links\" classified as LCD resources</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>currentAwareness</dt>\r\n		<dd>The name of the \"New Bookshelf\" section as defined in the global preferences</dd>\r\n	<dt>aboutCurrentAwareness</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the \"New Bookshelf\" (ID #45)</dd>\r\n	<dt>customizeCurrentAwareness</dt>\r\n		<dd>A relative URL pointing to a form allowing users to customize the \"New Bookshelf\"</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>personalLinks</dt>\r\n		<dd>The name of the \"Personal Links\" section as defined in the global preferences</dd>\r\n	<dt>aboutPersonalLinks</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the \"Personal Links\" (ID #31)</dd>\r\n	<dt>customizePersonalLinks</dt>\r\n		<dd>A relative URL pointing to a form allowing users to customize the \"Personal Links\"</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>quickSearches</dt>\r\n		<dd>The name of the \"Quick Searches\" section as defined in the global preferences</dd>\r\n	<dt>aboutQuickSearches</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the \"Quick Searches\" (ID #32)</dd>\r\n	<dt>customizeQuickSearches</dt>\r\n		<dd>A relative URL pointing to a form allowing users to customize the \"Quick Searches\"</dd>\r\n	<dt>formQuickSearches</dt>\r\n		<dd>An HTML form allowing users to use the \"Quick Searches\" classified as LCD resources</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>referenceShelf</dt>\r\n		<dd>The name of the \"Reference Shelf Links\" section as defined in the global preferences</dd>\r\n	<dt>aboutReferenceShelf</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the \"Reference Shelf Links\" (ID #33)</dd>\r\n	<dt>customizeReferenceShelf</dt>\r\n		<dd>A relative URL pointing to a form allowing users to customize the \"Reference Shelf Links\"</dd>\r\n	<dt>listReferenceShelf</dt>\r\n		<dd>An HTML ordered list of all \"Reference Shelf Links\" classified as LCD resources</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>databaseLinks</dt>\r\n		<dd>The name of the \"Database Links\" section as defined in the global preferences</dd>\r\n	<dt>aboutDatabaseLinks</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the \"Database Links\" (ID #34)</dd>\r\n	<dt>customizeDatabaseLinks</dt>\r\n		<dd>A relative URL pointing to a form allowing users to customize the \"Database Links\"</dd>\r\n	<dt>listDatabaseLinks</dt>\r\n		<dd>An HTML ordered list of all \"Database Links\" classified as LCD resources</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>journalLinks</dt>\r\n		<dd>The name of the \"Etext Links\" section as defined in the global preferences</dd>\r\n	<dt>aboutJournalLinks</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the \"Etext Links\" (ID #35)</dd>\r\n	<dt>customizeJournalLinks</dt>\r\n		<dd>A relative URL pointing to a form allowing users to customize the \"Etext Links\"</dd>\r\n	<dt>listJournalLinks</dt>\r\n		<dd>An HTML ordered list of all \"Etext Links\" classified as LCD resources</dd>\r\n</dl>\r\n');
INSERT INTO help_simple VALUES (261,'Template, Free, Edit select','<p>To edit a free template, enter a template ID.</p>');
INSERT INTO help_simple VALUES (262,'Template, Free, List all','<p>This is a list of all the free templates.</p>');
INSERT INTO help_simple VALUES (263,'Template, Free, Edit','</p>Use this form to edit a free template. See <a href=./?cmd=about&id=260>\"about free templates\"</a> for more information!</p>');
INSERT INTO help_simple VALUES (264,'Template, Free, Edited','<p>The free template as been edited and saved to the database.</p>');
INSERT INTO help_simple VALUES (265,'Template, Free, Created','</p>The free template has been saved to the database.<p>');
INSERT INTO help_simple VALUES (266,'Template, Free, Delete select','<p>To delete a free template, enter a template ID.</p>');
INSERT INTO help_simple VALUES (267,'Template, Free, Deleted','<p>The free template has been deleted.</p>');
INSERT INTO help_simple VALUES (268,'Template, User, Tokens described','<p>This text describes the user tokens for user templates. Print this page.</p>\r\n\r\n<p>\r\nUser templates are sets of HTML allowing users to have their content displayed in any number of ways as articulated by the hosting institution. For example, an institution can create a user template that is very simple and devoid of graphics making it easily readable by page reading machines. On the other hand, templates can be created that are graphically rich and portray the institution\'s identity. Furthermore, given enough user templates to choose from, this option also allows users to define, to some extent, how they want their content arranged.\r\n</p>\r\n\r\n<p>\r\nLike the \"free templates\", user templates contain HTML tag plus tokens, listed below. Tokens are variables representing content from the underlying database. They are case-sensitive and must be surrounded by pairs of percent signs (%%) in order for them to be reconized by the system.\r\n</p>\r\n\r\n<p>\r\nFor example, if you wanted your template only to display the system\'s banner, the user\'s custom title, their list of customized \"Reference Shelf\" items, and a link allowing them to change their selections, then your template my look something like this:\r\n</p>\r\n\r\n<blockquote>\r\n&lt;html&gt;<br>\r\n&lt;head&gt;<br>\r\n&lt;title&gt;%%title%%&lt;/title&gt;<br>\r\n&lt;style type=\"text/css\"&gt;%%stylesheet%%&lt;/style&gt;<br>\r\n&lt;/head&gt;<br>\r\n&lt;body&gt;<br>\r\n%%banner%%<br>\r\n&lt;h1&gt;%%referenceShelf%%&lt;/h1&gt;<br>\r\n&lt;p&gt;Listed here are your customized selections.<br>\r\nChange them &lt;a href=%%customizeReferenceShelf%%&gt;here&lt;/a&gt;.&lt;/p&gt;<br>\r\n%%listReferenceShelf%%<br>\r\n</blockquote>\r\n\r\n<p>\r\nRemember, you don\'t have to supply any closing HTML because that is done by way of the system\'s footer.\r\n</p>\r\n\r\n<p>\r\n<em>Be forewarned</em>. This system is not a text editor; it\'s a database. Create your templates outside this system, import them here, and do only minor tweaks in the system itself.\r\n</p>\r\n\r\n<p>\r\nHere is a list of all the \"user tokens\" and their definitions:\r\n</p>\r\n\r\n<dl>\r\n	<dt>patronFirst</dt>\r\n		<dd>The user\'s first name</dd>\r\n	<dt>patronLast</dt>\r\n		<dd>The user\'s last name</dd>\r\n	<dt>patronUsername</dt>\r\n		<dd>The user\'s username</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>title</dt>\r\n		<dd>The title as defined in the global preferences</dd>\r\n	<dt>stylesheet</dt>\r\n		<dd>The stylesheet information as created/specified via the administrative interface</dd>\r\n	<dt>bgcolor</dt>\r\n		<dd>The background color as defined by the user\'s layout preferences</dd>\r\n	<dt>link</dt>\r\n		<dd>The link color as defined by the user\'s layout preferences</dd>\r\n	<dt>alink</dt>\r\n		<dd>The active link color as defined by the user\'s layout preferences</dd>\r\n	<dt>vlink</dt>\r\n		<dd>The visited link color as defined by the user\'s layout preferences</dd>\r\n	<dt>text</dt>\r\n		<dd>The text color as defined by the user\'s layout preferences</dd>\r\n	<dt>bannerColor</dt>\r\n		<dd>The banner color as defined by the user\'s layout preferences</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>banner</dt>\r\n		<dd>The contents of the banner</dd>\r\n	<dt>motd</dt>\r\n		<dd>The contents of the global message of the day</dd>\r\n	<dt>messageFromLibrarian</dt>\r\n		<dd>The name of the \"Message From the Librarian\" section as defined in the global preferences</dd>\r\n	<dt>aboutMessageFromLibrarian</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text allowing users to customize their profile (ID #42)</dd>\r\n	<dt>disciplineMOTD</dt>\r\n		<dd>The content of the user\'s discipline-specific \"Message From the Librarian\"</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>aboutMyLibrary</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing this system (ID #39)</dd>\r\n	<dt>customizeProfile</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text allowing users to customize their profile (ID #43)</dd>\r\n	<dt>logout</dt>\r\n		<dd>A relative URL allowing patrons to log out</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>yourLibrarians</dt>\r\n		<dd>The name of the \"Your Librarians\" section as defined in the global preferences</dd>\r\n	<dt>aboutLibrarians</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the librarians (ID #36)</dd>\r\n	<dt>librarians</dt>\r\n		<dd>A concationation of the various librarian blurbs as defined in the global preferences as well as a list of the librarians associated with the user\'s discipline</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>libraryLinks</dt>\r\n		<dd>The name of the \"Library Links\" section as defined in the global preferences</dd>\r\n	<dt>aboutLibraryLinks</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the \"Library Links\" (ID #38)</dd>\r\n	<dt>customizeLibraryLinks</dt>\r\n		<dd>A relative URL pointing to a form allowing users to customize the \"Library Links\"</dd>\r\n	<dt>listLibraryLinks</dt>\r\n		<dd>An HTML ordered list of all \"Library Links\" associated with the user.</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>universityLinks</dt>\r\n		<dd>The name of the \"Community Links\" section as defined in the global preferences</dd>\r\n	<dt>aboutUniversityLinks</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the \"Community Links\" (ID #37)</dd>\r\n	<dt>customizeUniversityLinks</dt>\r\n		<dd>A relative URL pointing to a form allowing users to customize the \"Community Links\"</dd>\r\n	<dt>listUniversityLinks</dt>\r\n		<dd>An HTML ordered list of all \"Community Links\" associated with the user.</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>currentAwareness</dt>\r\n		<dd>The name of the \"New Bookshelf\" section as defined in the global preferences</dd>\r\n	<dt>aboutCurrentAwareness</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the \"New Bookshelf\" (ID #45)</dd>\r\n	<dt>customizeCurrentAwareness</dt>\r\n		<dd>A relative URL pointing to a form allowing users to customize the \"New Bookshelf\"</dd>\r\n	<dt>formCurrentAwareness</dt>\r\n		<dd>An HTML form allowing the user to search the content of the \"New Bookshelf\"</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>personalLinks</dt>\r\n		<dd>The name of the \"Personal Links\" section as defined in the global preferences</dd>\r\n	<dt>aboutPersonalLinks</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the \"Personal Links\" (ID #31)</dd>\r\n	<dt>customizePersonalLinks</dt>\r\n		<dd>A relative URL pointing to a form allowing users to customize the \"Personal Links\"</dd>\r\n	<dt>listPersonalLinks</dt>\r\n		<dd>An HTML ordered list of all the user\'s \"Personal Links\"</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>quickSearches</dt>\r\n		<dd>The name of the \"Quick Searches\" section as defined in the global preferences</dd>\r\n	<dt>aboutQuickSearches</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the \"Quick Searches\" (ID #32)</dd>\r\n	<dt>customizeQuickSearches</dt>\r\n		<dd>A relative URL pointing to a form allowing users to customize the \"Quick Searches\"</dd>\r\n	<dt>formQuickSearches</dt>\r\n		<dd>An HTML form allowing users to use the \"Quick Searches\" associated with the user</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>referenceShelf</dt>\r\n		<dd>The name of the \"Reference Shelf Links\" section as defined in the global preferences</dd>\r\n	<dt>aboutReferenceShelf</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the \"Reference Shelf Links\" (ID #33)</dd>\r\n	<dt>customizeReferenceShelf</dt>\r\n		<dd>A relative URL pointing to a form allowing users to customize the \"Reference Shelf Links\"</dd>\r\n	<dt>listReferenceShelf</dt>\r\n		<dd>An HTML ordered list of all \"Reference Shelf Links\" associated with the user</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>databaseLinks</dt>\r\n		<dd>The name of the \"Database Links\" section as defined in the global preferences</dd>\r\n	<dt>aboutDatabaseLinks</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the \"Database Links\" (ID #34)</dd>\r\n	<dt>customizeDatabaseLinks</dt>\r\n		<dd>A relative URL pointing to a form allowing users to customize the \"Database Links\"</dd>\r\n	<dt>listDatabaseLinks</dt>\r\n		<dd>An HTML ordered list of all \"Database Links\" associated with the user</dd>\r\n	\r\n	<br><br>\r\n	\r\n	<dt>journalLinks</dt>\r\n		<dd>The name of the \"Etext Links\" section as defined in the global preferences</dd>\r\n	<dt>aboutJournalLinks</dt>\r\n		<dd>A relative URL pointing to the Simple Help Text describing the \"Etext Links\" (ID #35)</dd>\r\n	<dt>customizeJournalLinks</dt>\r\n		<dd>A relative URL pointing to a form allowing users to customize the \"Etext Links\"</dd>\r\n	<dt>listJournalLinks</dt>\r\n		<dd>An HTML ordered list of all \"Etext Links\" associated with the user</dd>\r\n</dl>\r\n');
INSERT INTO help_simple VALUES (269,'Template, Static, Menu','<p>Use the items below to manage your collection of static  templates. For more information, see the <a href=./?cmd=about&id=278>text describing static  templates</a> in detail</p>');
INSERT INTO help_simple VALUES (270,'Template, Static, Create','<p>Use this form to create new user templates. Every field must have a value, and remember, write the template as if it were an ordinary HTML file and delimit the tokens with a pair of percent signs (%). For more information, see the <a href=./?cmd=about&id=278>text describing static  templates</a> in detail</p>');
INSERT INTO help_simple VALUES (271,'Template, Static, Created','<p>');
INSERT INTO help_simple VALUES (272,'Template, Static, Edit','</p>Use this form to edit a static template. For more information, see the <a href=./?cmd=about&id=278>text describing static  templates</a> in detail</p>');
INSERT INTO help_simple VALUES (273,'Template, Static, Deleted','<p>The static template has been deleted.</p>');
INSERT INTO help_simple VALUES (274,'Template, Static, Edit','<p>Enter a static template ID to edit that template.</p>');
INSERT INTO help_simple VALUES (275,'Template, Static, Edited','<p>The static template has been edited and the database has been updated.</p>');
INSERT INTO help_simple VALUES (276,'Template, Static, List all','<p>This is a list of all the static templates.</p>');
INSERT INTO help_simple VALUES (277,'Template, Static, Delete select','<p>To delete a static template, enter a template ID.</p>');
INSERT INTO help_simple VALUES (278,'Template, Static, Tokens described','<p>This text describes the static tokens for static templates. Print this page.</p>\r\n\r\n<p>\r\nUsing a template/token approach, this system can create three different sets of static HTML pages based on the content of its database. The three different types of static pages that it can create are 1) alphabetic lists of all resources, 2) lists of resources based on disciplines, and 3) an index page pointing to page types #1 and #2.\r\n</p>\r\n\r\n<p>\r\nLike the \"free templates\" and \"user templates\", static templates contain HTML tags plus tokens, listed below. Tokens are variables representing content from the underlying database. They are case-sensitive and must be surrounded by pairs of percent signs (%%) in order for them to be reconized by the system. Each type of static page template can include certain tokens, and it is easy to forget which of the static templates you create are for what purpose. Therefore, be careful to accurately name your templates.\r\n</p>\r\n\r\n<p>\r\nFor example, if you wanted your discipline-specific lists (page type #2) to contain a simple title and the list of the resources, then your template my look like this:\r\n</p>\r\n\r\n<blockquote>\r\n&lt;html&gt;<br>\r\n&lt;head&gt;<br>\r\n&lt;title&gt;All %%disciplineTitle%% Items&lt;/title&gt;<br>\r\n&lt;style type=\"text/css\"&gt;%%stylesheet%%&lt;/style&gt;<br>\r\n&lt;/head&gt;<br>\r\n&lt;body&gt;<br>\r\n&lt;h1&gt;All %%disciplineTitle%% Items&lt;/h1&gt;<br>\r\n&lt;h2&gt;%%referenceTitle%%&lt;/h2&gt;<br>\r\n%%referenceList%%<br>\r\n&lt;h2&gt;%%bibDatabaseTitle%%&lt;/h2&gt;<br>\r\n%%bibDatabaseList%%<br>\r\n&lt;h2&gt;%%ejournalTitle%%&lt;/h2&gt;<br>\r\n%%ejournalList%%<br>\r\n&lt;/body&gt;<br>\r\n&lt;/html&gt;<br>\r\n</blockquote>\r\n\r\n<p>\r\nHere are some helpful hints and power uses of static templates:\r\n</p>\r\n\r\n<ul>\r\n	<li>Insert server side includes into your templates so they have the same look and feel of the balance of your site.</li>\r\n	<li>Create sets of discipline-specific pages and then catalog them in the system making them recommended resources for that discipline.</li>\r\n	<li>Create alphabetic lists of resources and make them LCD resources so they get displayed in the \"free\" templates.</li>\r\n	<li>Create your alphabetic lists and discipline-specific lists on a regular basis, make sure they work, and then create your index file\r\n	<li>Make your index file an LCD as well as recommended resource for all disciplines\r\n</ul>\r\n\r\n<p>\r\n<em>Be forewarned</em>. This system is not a text editor; it\'s a database. Create your templates outside this system, import them here, and do only minor tweaks in the system itself.\r\n</p>\r\n\r\n<h3>Tokens for alphabetic lists</h3>\r\n\r\n<dl>\r\n	<dt>stylesheet</dt>\r\n		<dd>The stylesheet information/specification created and saved using the administrative interface</dd>\r\n	<dt>title</dt>\r\n		<dd>The name of the resource type (\"Library Links\", \"Community Links\", \"Reference Shelf\", \"Bibliographic Databases\", \"Ejournals\") as defined in the global preferences and selected when the static page is created</dd>\r\n	<dt>resourceList</dt>\r\n		<dd>An HTML ordered list of all the resources associated with the resource type</dd>\r\n\r\n</dl>\r\n\r\n<h3>Tokens for discipline-specific lists</h3>\r\n\r\n<dl>\r\n	<dt>stylesheet</dt>\r\n		<dd>The stylesheet information/specification created and saved using the administrative interface</dd>\r\n	<dt>disciplineTitle</dt>\r\n		<dd>The name of the discipline</dd>\r\n	<dt>referenceTitle</dt>\r\n		<dd>The name of the \"Reference Shelf\" items as defined in the global preferences</dd>\r\n	<dt>referenceList</dt>\r\n		<dd>An HTML ordered list of all \"Reference Shelf\" items associated with the selected discipline</dd>\r\n	<dt>bibDatabaseTitle</dt>\r\n		<dd>The name of the \"Bibliographic Database\" items as defined in the global preferences</dd>\r\n	<dt>bibDatabaseList</dt>\r\n		<dd>An HTML ordered list of all \"Bibliographic Database\" items associated with the selected discipline</dd>\r\n	<dt>ejournalTitle</dt>\r\n		<dd>The name of the \"Ejournal\" items as defined in the global preferences</dd>\r\n	<dt>ejournalList</dt>\r\n		<dd>An HTML ordered list of all \"Ejournal\" items associated with the selected discipline</dd>\r\n</dl>\r\n\r\n<h3>Tokens for index pages</h3>\r\n\r\n<dl>\r\n	<dt>stylesheet</dt>\r\n		<dd>The stylesheet information/specification created and saved using the administrative interface</dd>\r\n	<dt>resourceList</dt>\r\n		<dd>An HTML ordered list containing the names of all the resource types (\"Library Links\", \"Community Links\", \"Reference Shelf\", \"Bibliographic Databases\", \"Ejournals\"), and where each item in the list is hot linked to alphabetic lists themselves</dd>\r\n	<dt>resourceList</dt>\r\n		<dd>An HTML ordered list of all the disciplines, and where each item in the list is hot linked to discipline-specific lists themselves</dd>\r\n</dl>\r\n\r\n\r\n');
INSERT INTO help_simple VALUES (279,'No, ID','<p>\r\nYour browser did not send the sytem an ID via the cookie mechanism. Please contact the system\'s administrator and report this problem.\r\n</p>');
INSERT INTO help_simple VALUES (280,'No encoded key','<p>\r\nYour browser did not send an encoded key. Please log in again and the problem should be resolved. If not, then please contact the systems administrator.\r\n</p>\r\n');
INSERT INTO help_simple VALUES (281,'Key expired','<p>\r\nThey key sent by your browser verifying your identity has most likely expired. Please log in again. If the problem persists, then please contact the system administrator.\r\n</p>\r\n');

--
-- Table structure for table 'items4DisBibdatabases'
--

CREATE TABLE items4DisBibdatabases (
  discipline_id int(6) default NULL,
  bib_database_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'items4DisBibdatabases'
--


INSERT INTO items4DisBibdatabases VALUES (2,340);
INSERT INTO items4DisBibdatabases VALUES (3,357);
INSERT INTO items4DisBibdatabases VALUES (5,349);
INSERT INTO items4DisBibdatabases VALUES (4,363);
INSERT INTO items4DisBibdatabases VALUES (3,362);
INSERT INTO items4DisBibdatabases VALUES (5,350);
INSERT INTO items4DisBibdatabases VALUES (5,351);
INSERT INTO items4DisBibdatabases VALUES (2,342);
INSERT INTO items4DisBibdatabases VALUES (1,337);
INSERT INTO items4DisBibdatabases VALUES (5,346);
INSERT INTO items4DisBibdatabases VALUES (3,361);
INSERT INTO items4DisBibdatabases VALUES (2,338);
INSERT INTO items4DisBibdatabases VALUES (2,341);
INSERT INTO items4DisBibdatabases VALUES (5,347);
INSERT INTO items4DisBibdatabases VALUES (1,335);
INSERT INTO items4DisBibdatabases VALUES (4,305);
INSERT INTO items4DisBibdatabases VALUES (5,345);
INSERT INTO items4DisBibdatabases VALUES (2,339);
INSERT INTO items4DisBibdatabases VALUES (1,333);
INSERT INTO items4DisBibdatabases VALUES (1,334);
INSERT INTO items4DisBibdatabases VALUES (1,336);
INSERT INTO items4DisBibdatabases VALUES (3,360);
INSERT INTO items4DisBibdatabases VALUES (3,359);
INSERT INTO items4DisBibdatabases VALUES (3,358);
INSERT INTO items4DisBibdatabases VALUES (1,422);
INSERT INTO items4DisBibdatabases VALUES (5,422);
INSERT INTO items4DisBibdatabases VALUES (4,366);
INSERT INTO items4DisBibdatabases VALUES (4,365);
INSERT INTO items4DisBibdatabases VALUES (4,364);
INSERT INTO items4DisBibdatabases VALUES (4,356);
INSERT INTO items4DisBibdatabases VALUES (5,353);
INSERT INTO items4DisBibdatabases VALUES (5,344);
INSERT INTO items4DisBibdatabases VALUES (2,343);
INSERT INTO items4DisBibdatabases VALUES (3,422);
INSERT INTO items4DisBibdatabases VALUES (4,422);
INSERT INTO items4DisBibdatabases VALUES (2,422);

--
-- Table structure for table 'items4DisEtexts'
--

CREATE TABLE items4DisEtexts (
  discipline_id int(6) default NULL,
  etext_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'items4DisEtexts'
--


INSERT INTO items4DisEtexts VALUES (4,405);
INSERT INTO items4DisEtexts VALUES (4,404);
INSERT INTO items4DisEtexts VALUES (1,368);
INSERT INTO items4DisEtexts VALUES (5,320);
INSERT INTO items4DisEtexts VALUES (5,392);
INSERT INTO items4DisEtexts VALUES (5,391);
INSERT INTO items4DisEtexts VALUES (3,390);
INSERT INTO items4DisEtexts VALUES (3,354);
INSERT INTO items4DisEtexts VALUES (5,354);
INSERT INTO items4DisEtexts VALUES (5,324);
INSERT INTO items4DisEtexts VALUES (1,381);
INSERT INTO items4DisEtexts VALUES (1,380);
INSERT INTO items4DisEtexts VALUES (1,369);
INSERT INTO items4DisEtexts VALUES (5,394);
INSERT INTO items4DisEtexts VALUES (3,389);
INSERT INTO items4DisEtexts VALUES (3,388);
INSERT INTO items4DisEtexts VALUES (5,348);
INSERT INTO items4DisEtexts VALUES (5,329);
INSERT INTO items4DisEtexts VALUES (1,373);
INSERT INTO items4DisEtexts VALUES (1,370);
INSERT INTO items4DisEtexts VALUES (5,367);
INSERT INTO items4DisEtexts VALUES (2,397);
INSERT INTO items4DisEtexts VALUES (1,396);
INSERT INTO items4DisEtexts VALUES (4,400);
INSERT INTO items4DisEtexts VALUES (1,399);
INSERT INTO items4DisEtexts VALUES (1,398);
INSERT INTO items4DisEtexts VALUES (4,403);
INSERT INTO items4DisEtexts VALUES (4,402);
INSERT INTO items4DisEtexts VALUES (4,401);
INSERT INTO items4DisEtexts VALUES (3,387);
INSERT INTO items4DisEtexts VALUES (3,386);
INSERT INTO items4DisEtexts VALUES (3,385);
INSERT INTO items4DisEtexts VALUES (3,383);
INSERT INTO items4DisEtexts VALUES (3,382);
INSERT INTO items4DisEtexts VALUES (5,423);
INSERT INTO items4DisEtexts VALUES (1,423);
INSERT INTO items4DisEtexts VALUES (3,423);
INSERT INTO items4DisEtexts VALUES (4,423);
INSERT INTO items4DisEtexts VALUES (2,423);
INSERT INTO items4DisEtexts VALUES (2,458);
INSERT INTO items4DisEtexts VALUES (2,459);
INSERT INTO items4DisEtexts VALUES (2,460);
INSERT INTO items4DisEtexts VALUES (2,471);
INSERT INTO items4DisEtexts VALUES (2,462);
INSERT INTO items4DisEtexts VALUES (2,469);
INSERT INTO items4DisEtexts VALUES (2,470);
INSERT INTO items4DisEtexts VALUES (2,472);
INSERT INTO items4DisEtexts VALUES (4,474);
INSERT INTO items4DisEtexts VALUES (4,475);
INSERT INTO items4DisEtexts VALUES (4,476);

--
-- Table structure for table 'items4DisQSearches'
--

CREATE TABLE items4DisQSearches (
  discipline_id int(6) default NULL,
  qsearch_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'items4DisQSearches'
--


INSERT INTO items4DisQSearches VALUES (1,0);
INSERT INTO items4DisQSearches VALUES (1,290);
INSERT INTO items4DisQSearches VALUES (1,291);
INSERT INTO items4DisQSearches VALUES (1,292);
INSERT INTO items4DisQSearches VALUES (2,2);
INSERT INTO items4DisQSearches VALUES (2,1);
INSERT INTO items4DisQSearches VALUES (4,1);
INSERT INTO items4DisQSearches VALUES (3,1);
INSERT INTO items4DisQSearches VALUES (1,1);
INSERT INTO items4DisQSearches VALUES (5,1);
INSERT INTO items4DisQSearches VALUES (4,2);
INSERT INTO items4DisQSearches VALUES (3,2);
INSERT INTO items4DisQSearches VALUES (1,2);
INSERT INTO items4DisQSearches VALUES (5,2);
INSERT INTO items4DisQSearches VALUES (2,3);
INSERT INTO items4DisQSearches VALUES (4,3);
INSERT INTO items4DisQSearches VALUES (3,3);
INSERT INTO items4DisQSearches VALUES (1,3);
INSERT INTO items4DisQSearches VALUES (5,3);
INSERT INTO items4DisQSearches VALUES (2,4);
INSERT INTO items4DisQSearches VALUES (4,4);
INSERT INTO items4DisQSearches VALUES (3,4);
INSERT INTO items4DisQSearches VALUES (1,4);
INSERT INTO items4DisQSearches VALUES (5,4);
INSERT INTO items4DisQSearches VALUES (2,7);
INSERT INTO items4DisQSearches VALUES (4,7);
INSERT INTO items4DisQSearches VALUES (3,287);
INSERT INTO items4DisQSearches VALUES (1,287);
INSERT INTO items4DisQSearches VALUES (5,287);
INSERT INTO items4DisQSearches VALUES (2,8);
INSERT INTO items4DisQSearches VALUES (4,8);
INSERT INTO items4DisQSearches VALUES (3,7);
INSERT INTO items4DisQSearches VALUES (1,7);
INSERT INTO items4DisQSearches VALUES (5,7);
INSERT INTO items4DisQSearches VALUES (2,330);
INSERT INTO items4DisQSearches VALUES (2,288);
INSERT INTO items4DisQSearches VALUES (3,8);
INSERT INTO items4DisQSearches VALUES (1,8);
INSERT INTO items4DisQSearches VALUES (5,8);
INSERT INTO items4DisQSearches VALUES (2,211);
INSERT INTO items4DisQSearches VALUES (1,211);
INSERT INTO items4DisQSearches VALUES (4,330);
INSERT INTO items4DisQSearches VALUES (1,288);
INSERT INTO items4DisQSearches VALUES (2,287);
INSERT INTO items4DisQSearches VALUES (4,287);
INSERT INTO items4DisQSearches VALUES (3,330);
INSERT INTO items4DisQSearches VALUES (1,330);
INSERT INTO items4DisQSearches VALUES (5,330);

--
-- Table structure for table 'items4DisReference'
--

CREATE TABLE items4DisReference (
  discipline_id int(6) default NULL,
  reference_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'items4DisReference'
--


INSERT INTO items4DisReference VALUES (4,293);
INSERT INTO items4DisReference VALUES (2,1);
INSERT INTO items4DisReference VALUES (4,1);
INSERT INTO items4DisReference VALUES (1,1);
INSERT INTO items4DisReference VALUES (5,1);
INSERT INTO items4DisReference VALUES (5,2);
INSERT INTO items4DisReference VALUES (1,2);
INSERT INTO items4DisReference VALUES (3,2);
INSERT INTO items4DisReference VALUES (4,2);
INSERT INTO items4DisReference VALUES (2,2);
INSERT INTO items4DisReference VALUES (3,1);
INSERT INTO items4DisReference VALUES (4,3);
INSERT INTO items4DisReference VALUES (3,3);
INSERT INTO items4DisReference VALUES (1,3);
INSERT INTO items4DisReference VALUES (5,3);
INSERT INTO items4DisReference VALUES (2,4);
INSERT INTO items4DisReference VALUES (4,4);
INSERT INTO items4DisReference VALUES (3,4);
INSERT INTO items4DisReference VALUES (1,4);
INSERT INTO items4DisReference VALUES (5,4);
INSERT INTO items4DisReference VALUES (4,289);
INSERT INTO items4DisReference VALUES (3,289);
INSERT INTO items4DisReference VALUES (1,289);
INSERT INTO items4DisReference VALUES (5,289);
INSERT INTO items4DisReference VALUES (2,3);
INSERT INTO items4DisReference VALUES (3,299);
INSERT INTO items4DisReference VALUES (2,289);
INSERT INTO items4DisReference VALUES (5,299);
INSERT INTO items4DisReference VALUES (5,298);
INSERT INTO items4DisReference VALUES (3,297);
INSERT INTO items4DisReference VALUES (4,296);
INSERT INTO items4DisReference VALUES (4,295);
INSERT INTO items4DisReference VALUES (4,294);
INSERT INTO items4DisReference VALUES (5,300);
INSERT INTO items4DisReference VALUES (2,301);
INSERT INTO items4DisReference VALUES (1,302);
INSERT INTO items4DisReference VALUES (1,303);
INSERT INTO items4DisReference VALUES (1,304);
INSERT INTO items4DisReference VALUES (4,306);
INSERT INTO items4DisReference VALUES (4,307);
INSERT INTO items4DisReference VALUES (4,308);
INSERT INTO items4DisReference VALUES (5,309);
INSERT INTO items4DisReference VALUES (5,310);
INSERT INTO items4DisReference VALUES (1,310);
INSERT INTO items4DisReference VALUES (3,310);
INSERT INTO items4DisReference VALUES (4,310);
INSERT INTO items4DisReference VALUES (2,310);
INSERT INTO items4DisReference VALUES (2,311);
INSERT INTO items4DisReference VALUES (3,312);
INSERT INTO items4DisReference VALUES (2,313);
INSERT INTO items4DisReference VALUES (3,314);
INSERT INTO items4DisReference VALUES (1,315);
INSERT INTO items4DisReference VALUES (1,316);
INSERT INTO items4DisReference VALUES (1,321);
INSERT INTO items4DisReference VALUES (1,322);
INSERT INTO items4DisReference VALUES (5,323);
INSERT INTO items4DisReference VALUES (1,323);
INSERT INTO items4DisReference VALUES (3,323);
INSERT INTO items4DisReference VALUES (4,323);
INSERT INTO items4DisReference VALUES (2,323);
INSERT INTO items4DisReference VALUES (5,325);
INSERT INTO items4DisReference VALUES (1,325);
INSERT INTO items4DisReference VALUES (3,325);
INSERT INTO items4DisReference VALUES (4,325);
INSERT INTO items4DisReference VALUES (2,325);
INSERT INTO items4DisReference VALUES (5,326);
INSERT INTO items4DisReference VALUES (1,326);
INSERT INTO items4DisReference VALUES (3,326);
INSERT INTO items4DisReference VALUES (4,326);
INSERT INTO items4DisReference VALUES (2,326);
INSERT INTO items4DisReference VALUES (1,327);
INSERT INTO items4DisReference VALUES (5,328);
INSERT INTO items4DisReference VALUES (1,328);
INSERT INTO items4DisReference VALUES (3,328);
INSERT INTO items4DisReference VALUES (4,328);
INSERT INTO items4DisReference VALUES (2,328);
INSERT INTO items4DisReference VALUES (5,355);
INSERT INTO items4DisReference VALUES (2,420);
INSERT INTO items4DisReference VALUES (4,420);
INSERT INTO items4DisReference VALUES (3,420);
INSERT INTO items4DisReference VALUES (1,420);
INSERT INTO items4DisReference VALUES (5,420);
INSERT INTO items4DisReference VALUES (5,421);
INSERT INTO items4DisReference VALUES (1,421);
INSERT INTO items4DisReference VALUES (3,421);
INSERT INTO items4DisReference VALUES (4,421);
INSERT INTO items4DisReference VALUES (2,421);
INSERT INTO items4DisReference VALUES (5,428);
INSERT INTO items4DisReference VALUES (3,428);
INSERT INTO items4DisReference VALUES (1,429);
INSERT INTO items4DisReference VALUES (2,429);
INSERT INTO items4DisReference VALUES (5,430);
INSERT INTO items4DisReference VALUES (3,430);
INSERT INTO items4DisReference VALUES (4,431);
INSERT INTO items4DisReference VALUES (1,432);
INSERT INTO items4DisReference VALUES (2,432);

--
-- Table structure for table 'items4bibdatabases'
--

CREATE TABLE items4bibdatabases (
  patron_id int(6) default NULL,
  bib_database_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'items4bibdatabases'
--


INSERT INTO items4bibdatabases VALUES (546,351);
INSERT INTO items4bibdatabases VALUES (546,353);
INSERT INTO items4bibdatabases VALUES (546,344);
INSERT INTO items4bibdatabases VALUES (546,346);
INSERT INTO items4bibdatabases VALUES (546,350);

--
-- Table structure for table 'items4etexts'
--

CREATE TABLE items4etexts (
  patron_id int(6) default NULL,
  etext_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'items4etexts'
--


INSERT INTO items4etexts VALUES (546,391);
INSERT INTO items4etexts VALUES (546,367);
INSERT INTO items4etexts VALUES (546,392);
INSERT INTO items4etexts VALUES (546,348);
INSERT INTO items4etexts VALUES (546,329);

--
-- Table structure for table 'items4librarians'
--

CREATE TABLE items4librarians (
  discipline_id int(6) default NULL,
  librarian_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'items4librarians'
--


INSERT INTO items4librarians VALUES (3,1);
INSERT INTO items4librarians VALUES (1,2);
INSERT INTO items4librarians VALUES (2,3);
INSERT INTO items4librarians VALUES (4,4);
INSERT INTO items4librarians VALUES (5,5);

--
-- Table structure for table 'items4libraries'
--

CREATE TABLE items4libraries (
  patron_id int(6) default NULL,
  libraries_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'items4libraries'
--


INSERT INTO items4libraries VALUES (546,251);
INSERT INTO items4libraries VALUES (546,250);
INSERT INTO items4libraries VALUES (546,246);
INSERT INTO items4libraries VALUES (546,258);
INSERT INTO items4libraries VALUES (546,256);

--
-- Table structure for table 'items4managers'
--

CREATE TABLE items4managers (
  discipline_id int(6) default NULL,
  manager_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'items4managers'
--


INSERT INTO items4managers VALUES (4,23);
INSERT INTO items4managers VALUES (112,0);
INSERT INTO items4managers VALUES (112,0);
INSERT INTO items4managers VALUES (2,24);
INSERT INTO items4managers VALUES (5,20);
INSERT INTO items4managers VALUES (1,21);
INSERT INTO items4managers VALUES (3,22);

--
-- Table structure for table 'items4qsearches'
--

CREATE TABLE items4qsearches (
  patron_id int(6) default NULL,
  qsearch_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'items4qsearches'
--


INSERT INTO items4qsearches VALUES (546,3);
INSERT INTO items4qsearches VALUES (546,7);
INSERT INTO items4qsearches VALUES (546,4);
INSERT INTO items4qsearches VALUES (546,211);

--
-- Table structure for table 'items4references'
--

CREATE TABLE items4references (
  patron_id int(6) default NULL,
  reference_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'items4references'
--


INSERT INTO items4references VALUES (1170,1);
INSERT INTO items4references VALUES (1170,4);
INSERT INTO items4references VALUES (546,4);
INSERT INTO items4references VALUES (546,298);
INSERT INTO items4references VALUES (546,1);
INSERT INTO items4references VALUES (546,299);
INSERT INTO items4references VALUES (546,420);
INSERT INTO items4references VALUES (546,428);

--
-- Table structure for table 'items4university'
--

CREATE TABLE items4university (
  patron_id int(6) default NULL,
  university_id int(6) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'items4university'
--


INSERT INTO items4university VALUES (546,280);
INSERT INTO items4university VALUES (546,284);
INSERT INTO items4university VALUES (546,281);
INSERT INTO items4university VALUES (546,270);
INSERT INTO items4university VALUES (546,286);

--
-- Table structure for table 'librarians'
--

CREATE TABLE librarians (
  librarian_id int(6) NOT NULL default '0',
  name varchar(255) default NULL,
  telephone_area char(3) default NULL,
  telephone_start char(3) default NULL,
  telephone_end varchar(4) default NULL,
  email_address varchar(255) default NULL,
  url varchar(255) default NULL,
  PRIMARY KEY  (librarian_id)
) TYPE=MyISAM;

--
-- Dumping data for table 'librarians'
--


INSERT INTO librarians VALUES (1,'Alcuin','574','631','8604','emorgan@nd.edu','http://dewey.library.nd.edu/morgan/');
INSERT INTO librarians VALUES (2,'Melvil Dewey','574','631','0804','emorgan@nd.edu','http://dewey.library.nd.edu/morgan/');
INSERT INTO librarians VALUES (3,'Mr. Serials','574','631','8604','emorgan@nd.edu','http://dewey.library.nd.edu/morgan/');
INSERT INTO librarians VALUES (4,'S.R. Ranganathan','574','246','8604','emorgan@nd.edu','http://dewey.library.nd.edu/morgan/');
INSERT INTO librarians VALUES (5,'St. Laurence','574','631','8604','emorgan@nd.edu','http://dewey.library.nd.edu/morgan/');

--
-- Table structure for table 'libraries'
--

CREATE TABLE libraries (
  libraries_id int(6) NOT NULL default '0',
  libraries_name varchar(255) default NULL,
  libraries_url varchar(255) default NULL,
  libraries_note varchar(255) default NULL,
  libraries_fkey varchar(255) NOT NULL default '',
  libraries_date date NOT NULL default '0000-00-00',
  libraries_lcd int(1) NOT NULL default '0',
  PRIMARY KEY  (libraries_id)
) TYPE=MyISAM;

--
-- Dumping data for table 'libraries'
--


INSERT INTO libraries VALUES (246,'Hours','http://www.lib.ncsu.edu/hours.html','This page lists  when the Libraries are open.','','2000-11-17',0);
INSERT INTO libraries VALUES (252,'Vet Med Library','http://www.lib.ncsu.edu/vetmed/','Here you will find the services and collections of the Vet Med Library described.','','2000-11-16',0);
INSERT INTO libraries VALUES (250,'Natural Resources Library','http://www.lib.ncsu.edu/natural/','The services and collections of the Natural Resources Library are described here.','','2000-11-16',0);
INSERT INTO libraries VALUES (249,'Design Library','http://www.lib.ncsu.edu/design/','These pages describe the services and collections of the Lyon Design Library.','','2000-11-16',0);
INSERT INTO libraries VALUES (248,'Directions','http://www.lib.ncsu.edu/directions.html','Here you will find instructions for getting to the Libraries.','','2000-11-16',1);
INSERT INTO libraries VALUES (251,'Textiles Library','http://www.lib.ncsu.edu/textiles/','The Textiles library is described on these pages.','','2000-11-16',0);
INSERT INTO libraries VALUES (253,'Afro-American Reading Room','http://www.lib.ncsu.edu/aarr/','The Afro-American Reading Room\'s services and collections are linked from this page.','','2000-11-16',0);
INSERT INTO libraries VALUES (254,'Learning Resources Center','http://www2.ncsu.edu/ncsu/cep/lrl/','The home page of the Learning Resources Center is found here.','','2000-11-16',0);
INSERT INTO libraries VALUES (255,'Working Collections','http://www.lib.ncsu.edu/risd/callnumbers/callnumbers_text.html#working','The University hosts a number of smaller libraries called \"working collections\", and a list of these collections is found here.','','2000-11-17',0);
INSERT INTO libraries VALUES (256,'Acquisitions','http://www.lib.ncsu.edu/acquisitions/','The home page of the Acquisistions Department is found off this link.','','2000-11-16',0);
INSERT INTO libraries VALUES (257,'Cataloging Department','http://www.lib.ncsu.edu/cataloging/','The Libraries Cataloging Department has its home page here.','','2000-11-16',0);
INSERT INTO libraries VALUES (258,'Collection Management','http://www.lib.ncsu.edu/colmgmt/','The folks in Collection Management evaluate the library\'s holdings and decide what to license and purchase. Consequently, the Libraries collection management policies can be found here.','','2000-11-16',1);
INSERT INTO libraries VALUES (259,'Reference Department','http://www.lib.ncsu.edu/risd/','The people who provide much of the library\'s public services are located in this department. Use this link to learn more about the services provided.','','2000-11-16',1);
INSERT INTO libraries VALUES (260,'Special Collections','http://www.lib.ncsu.edu/archives/','This department archives the unique items of the University and higlights a few of the library\'s rare collections.','','2000-11-16',1);
INSERT INTO libraries VALUES (261,'Friends of the Libraries','http://www.lib.ncsu.edu/administration/fol/','The Friends of the Libraries help promote the libraries in the local community. Their pages describe the servcies and events they sponsor.','','2000-11-17',0);
INSERT INTO libraries VALUES (262,'Distance Education','http://www.lib.ncsu.edu/distance/','The Distance Education Department facilitates remote learning. These pages describe what services they provide.','','2000-11-17',0);
INSERT INTO libraries VALUES (263,'Circulation','http://www.lib.ncsu.edu/ads/circulation/','The Circulation Department facilitates the borrowing of library materials. Their pages describe the policies involved.','','2000-11-16',1);

--
-- Table structure for table 'managers'
--

CREATE TABLE managers (
  manager_id int(6) NOT NULL default '0',
  name varchar(255) default NULL,
  telephone_area char(3) default NULL,
  telephone_start char(3) default NULL,
  telephone_end varchar(4) default NULL,
  email_address varchar(255) default NULL,
  url varchar(255) default NULL,
  PRIMARY KEY  (manager_id)
) TYPE=MyISAM;

--
-- Dumping data for table 'managers'
--


INSERT INTO managers VALUES (23,'St. Laurence','574','631','8604','emorgan@nd.edu','http://dewey.library.nd.edu/morgan/');
INSERT INTO managers VALUES (24,'S.R. Ranganathan','574','631','8604','emorgan@nd.edu','http://dewey.library.nd.edu/morgan/');
INSERT INTO managers VALUES (20,'Mr. Serials','574','631','8604','emorgan@nd.edu','http://dewey.library.nd.edu/morgan/');
INSERT INTO managers VALUES (21,'Alcuin','574','246','8604','emorgan@nd.edu','http://dewey.library.nd.edu/morgan/');
INSERT INTO managers VALUES (22,'Melvil Dewey','574','631','8604','emorgan@nd.edu','http://dewey.library.nd.edu/morgan/');

--
-- Table structure for table 'new_titles'
--

CREATE TABLE new_titles (
  inventory_date varchar(10) default NULL,
  call_number varchar(255) default NULL,
  control_number varchar(255) default NULL,
  author varchar(255) default NULL,
  title varchar(255) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'new_titles'
--


INSERT INTO new_titles VALUES ('2000/09/27','HX260.5.A6 L78313 2000','ANY-1479','Lukcs, Gyrgy, 1885-1971.','A defence of history and class consciousness : tailism and the dialectic /');
INSERT INTO new_titles VALUES ('2000/09/27','JC421 .I57 2000','ANY-1030','','The internet, democracy, and democratization /');
INSERT INTO new_titles VALUES ('2000/09/27','QA76.76.O63 P63 2000','ANY-1019','Pogue, David, 1963-','Mac OS 9 : the missing manual /');
INSERT INTO new_titles VALUES ('2000/10/11','SB458 .N58 1999','ANX-7165','Nitschke, Gnter.','Japanese gardens : right angle and natural form /');
INSERT INTO new_titles VALUES ('2000/10/11','TS121 .R39 1999','ANX-7158','Rawsthorn, Alice.','Marc Newson /');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:HEHS-00-58 R','ANY-9232','United States. General Accounting Office.','Evaluations of Even Start Family Literacy Program effectiveness');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:HEHS-00-47 R','ANY-9231','United States. General Accounting Office.','Laboratory quality financing the Clinical Laboratory Improvement Act (CLIA) program /');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:GGD-00-67 R','ANY-9229','United States. General Accounting Office.','Responses to questions concerning long-term capital management and related events');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:GGD-00-60 R','ANY-9228','United States. General Accounting Office.','Internal Revenue Service preparing substitute for returns for individuals /');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:GGD-00-57 R','ANY-9227','United States. General Accounting Office.','Insurers\' ability to pay catastrophe claims');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:HEHS-00-46','ANY-9226','United States. General Accounting Office.','Medicare contractors further improvement needed in headquarters and regional office oversight : report to the Chairman,');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:AIMD-00-20','ANY-9225','United States. General Accounting Office.','Financial management differences in Army and Air Force disbursing and accounting records : report to the Honorable Charl');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:GGD-00-59','ANY-9224','United States. General Accounting Office.','EPA paperwork burden estimate increasing despite reduction claims : report to the Chairman, Committee on Small Business,');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:HEHS-00-66 R','ANY-9215','United States. General Accounting Office. Health, Education, and Human Services Division.','Child care state requirements for background checks /');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:HEHS-00-70 R','ANY-9214','United States. General Accounting Office. Health, Education, and Human Services Division.','Medigap premiums for standardized plans that cover prescription drugs /');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:RCED-00-100 R','ANY-9213','United States. General Accounting Office. RCED.','Motor fuels gasoline price spikes in Oregon in 1999 /');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:RCED-00-71 R','ANY-9212','United States. General Accounting Office. RCED.','National Institute of Standards and Technology carryover balances for the Advanced Technology Program /');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:RCED-00-54','ANY-9211','United States. General Accounting Office.','Water quality key EPA and state decisions limited by inconsistent and incomplete data : report to the Chairman, Subcommi');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:NSIAD-00-113 R','ANY-9210','United States. General Accounting Office. National Security and International Affairs Division.','Defense budget funding for Southeastern Europe Defense Ministerial initiatives /');
INSERT INTO new_titles VALUES ('2000/10/11','KF730 .I585 1998','ANX-7143','','Introduction to trusts.');
INSERT INTO new_titles VALUES ('2000/10/11','A 13.88:PNW-GTR-486','ANX-4684','McIver, James D.','Environmental effects of postfire logging : literature review and annotated bibliography /');
INSERT INTO new_titles VALUES ('2000/10/11','BX4656 .A85 2000','ANX-4218','Ashton, Gail, 1957-','The generation of identity in late medieval hagiography : speaking the saint /');
INSERT INTO new_titles VALUES ('2000/10/11','TS155 .D544 2000','ANX-4173','Dilworth, James B., 1939-','Operations management : providing value in goods and services /');
INSERT INTO new_titles VALUES ('2000/10/11','GE40 .P73 2000','ANX-4104','Pratt, Vernon, 1943-','Environment and philosophy /');
INSERT INTO new_titles VALUES ('2000/10/11','TS157.5 .P557 1999','ANX-4128','Pinedo, Michael.','Operations scheduling with applications in manufacturing and services /');
INSERT INTO new_titles VALUES ('2000/10/11','QR201.P33 P38 2000','ANX-3973','','Parvoviruses : from molecular biology to pathology and therapeutic uses /');
INSERT INTO new_titles VALUES ('2000/10/11','HC79.E5 R63 1999','ANX-3886','Robertson, James, 1928-','The new economics of sustainable development : a briefing for policy makers /');
INSERT INTO new_titles VALUES ('2000/10/11','KFN7916.H3 H35','ANX-0176','','Halifax County family court rules : domestic and juvenile.');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:AIMD-00-54 R','ANY-9207','United States. General Accounting Office. Accounting and Information Management Division.','Securities Exchange Act review of reporting under Section 10A /');
INSERT INTO new_titles VALUES ('2000/10/06','F1030 .M793 2000','ANX-7560','Moogk, Peter N., 1943-','La Nouvelle France : the making of French Canada : a cultural history /');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:AIMD/GGD-00-94 R','ANY-9205','United States. General Accounting Office. Accounting and Information Management Division.','U.S. Customs Service reasonableness of costs for processing air and sea passengers cannot be determined /');
INSERT INTO new_titles VALUES ('2000/10/05','SF959.C6 E656 2000','ANY-7719','','Equine colic II /');
INSERT INTO new_titles VALUES ('2000/10/05','HN513.5 .V8513 2000','ANY-7414','Vuijsje, Herman.','The politically correct Netherlands : since the 1960s /');
INSERT INTO new_titles VALUES ('2000/10/06','HG6024.3 .C48 1998','ANX-7556','Chorafas, Dimitris N.','The market risk amendment : understanding the marking-to-model and value-at-risk /');
INSERT INTO new_titles VALUES ('2000/10/06','KF6452.Z9 B87 1999','ANX-7197','Burke, Karen C., 1951-','Federal income taxation of partners and partnerships in a nutshell /');
INSERT INTO new_titles VALUES ('2000/10/06','TP690 .L484 2000','ANX-7157','Leffler, William L.','Petroleum refining in nontechnical language /');
INSERT INTO new_titles VALUES ('2000/10/06','F334.L55 H46 2000','ANX-4276','Hemphill, Paul, 1936-','The ballad of Little River : a tale of race and restless youth in the rural South /');
INSERT INTO new_titles VALUES ('2000/10/05','PR 42.8:C 43/C 43/2000','ANY-3982','','America\'s Children: Key National Indicators Of Well-Being 2000,');
INSERT INTO new_titles VALUES ('2000/10/05','EP 1.8:M 31/5','ANY-3980','','Environmental Management Guide For Small Laboratories, EPA 233-B-00-001, May 2000');
INSERT INTO new_titles VALUES ('2000/10/05','QR100 .T73 2000','ANY-3517','','Tracking genetically engineered microorganisms /');
INSERT INTO new_titles VALUES ('2000/10/05','RS164 .H385 2000','ANY-2250','','Herbs, botanicals & teas /');
INSERT INTO new_titles VALUES ('2000/09/28','Y 4.SM 1/2:S.HRG.106-457','ANZ-4659','United States. Congress. Senate. Committee on Small Business.','Internet cramming : the latest high-tech fraud on small business : hearing ... 106th Congress, 1st session, October 25,');
INSERT INTO new_titles VALUES ('2000/09/28','','ANZ-4656','McIntosh, Peggy.','White Privilege and Male Privilege: a Personal Account of Coming to See Correspondences Through Work in Women\'s Studies.');
INSERT INTO new_titles VALUES ('2000/09/28','GA 1.5/A-2:B-271021','ANZ-4654','United States. General Accounting Office.','[Improper travel advance paid by EEOC Imprest Fund cashier]');
INSERT INTO new_titles VALUES ('2000/09/28','GA 1.5/A-2:B-270916','ANZ-4650','United States. General Accounting Office.','[Rental firm\'s claim for stolen rented automobile]');
INSERT INTO new_titles VALUES ('2000/09/28','GA 1.5/A-2:B-270403','ANZ-4649','United States. General Accounting Office.','[Propriety of VA OIG local travel reimbursement payments]');
INSERT INTO new_titles VALUES ('2000/09/28','GA 1.5/A-2:B-265901','ANZ-4642','United States. General Accounting Office.','[National Guard, fiscal year to be charged for mandated uniform purchases (reconsideration)]');
INSERT INTO new_titles VALUES ('2000/10/05','RA999.F65 K65 1994','ANY-2019','Kolasa, Karen S.','Dietetic service operation handbook : practical applications in geriatric care /');
INSERT INTO new_titles VALUES ('2000/10/05','DS35.2 .A37 1999','ANY-0700','','After the Asian crises : perspectives on global politics and economics /');
INSERT INTO new_titles VALUES ('2000/09/28','GA 1.5/A-2:B-261440','ANZ-4640','United States. General Accounting Office.','[Non-federal employee\'s claim for temporary duty expenses charged on personal credit card]');
INSERT INTO new_titles VALUES ('2000/09/28','GA 1.5/A-2:B-260983.3','ANZ-4630','United States. General Accounting Office.','[Protest of IRS rejection fo bid for janitorial services]');
INSERT INTO new_titles VALUES ('2000/09/28','GA 1.5/A-2:B-257634.4','ANZ-4629','United States. General Accounting Office.','[Request for reconsideration of protest of GSA lease award for office space]');
INSERT INTO new_titles VALUES ('2000/10/05','HF5415.1265 .H36 2000','ANX-7588','Hanson, Ward A.','Principles of internet marketing /');
INSERT INTO new_titles VALUES ('2000/10/05','[Microfiche] E 3.59:','ANX-7851','','Emissions of greenhouse gases in the United States.');
INSERT INTO new_titles VALUES ('2000/09/28','GA 1.5/A-2:B-256897','ANZ-4623','United States. General Accounting Office.','[FSIS employee\'s claim for travel costs]');
INSERT INTO new_titles VALUES ('2000/09/28','GA 1.5/A-2:B-234029','ANZ-4604','United States. General Accounting Office.','[Protest of Air Force contract award for liquid oxygen tank services]');
INSERT INTO new_titles VALUES ('2000/09/28','SF395.8.A1 P67 vol. 103 1985','ANZ-4432','Woods, George T, 1924-','Trichinosis /');
INSERT INTO new_titles VALUES ('2000/09/28','GA 1.5/A-2:B-77467','ANZ-4584','United States. General Accounting Office.','[Leases under Bankhead/Jones Farm Tenant Act]');
INSERT INTO new_titles VALUES ('2000/09/28','SF395.8.A1','ANZ-4412','Songer, Glenn J.','Mycobacteriosis (tuberculosis,TB) /');
INSERT INTO new_titles VALUES ('2000/09/28','EP 1.23:600/3-88/021b','ANZ-4353','','Chemical characteristics of streams in the Mid-Atlantic and Southeastern United States : (results of the National Stream');
INSERT INTO new_titles VALUES ('2000/09/28','','ANZ-4343','D\'Souza, Dinesh.','Uncle Tom\'s Dilemma: Pathologies of Black Culture (Ch 12).');
INSERT INTO new_titles VALUES ('2000/10/05','HD58.8 .B376 2000','ANX-7251','Baum, David H.','Lightning in a bottle : proven lessons for leading change /');
INSERT INTO new_titles VALUES ('2000/09/28','','ANZ-4338','Cherry, Robert.','The Radical View (Ch 4).');
INSERT INTO new_titles VALUES ('2000/09/28','SF395.8.A1 P67 vol. 98 1985','ANZ-4339','','Porcine proliferative enteritis : (intestinal adenomatosis, necroproliferative enteropathy, proliferative ileitis) /');
INSERT INTO new_titles VALUES ('2000/09/28','','ANZ-4334','Kelly, Robin D.G.','Looking Backward: The Limits of Self Help Ideology.');
INSERT INTO new_titles VALUES ('2000/09/28','','ANZ-4331','Kelly, Robin D.G.','Introduction.');
INSERT INTO new_titles VALUES ('2000/09/28','','ANZ-4326','Goldfield, Michael.','The Contours of Race and Politics in the United States (Ch 10)');
INSERT INTO new_titles VALUES ('2000/09/28','A 13.80:SRS-49','ANZ-4319','Schweitzer, Callie Jo.','Forest statistics for Tennessee\'s plateau counties, 1999 /');
INSERT INTO new_titles VALUES ('2000/09/28','A 13.80:SRS-48','ANZ-4318','Brown, Mark J.','Florida\'s forests, 1995 /');
INSERT INTO new_titles VALUES ('2000/09/28','A 13.88:SRS-35','ANZ-4310','','Ozark-Ouachita highlands assessment : terrestrial vegetation and wildlife /');
INSERT INTO new_titles VALUES ('2000/09/28','A 13.88:SRS-34','ANZ-4309','','Ozark-Ouachita highlands assessment : social and economic conditions /');
INSERT INTO new_titles VALUES ('2000/09/28','A 13.88:SRS-33','ANZ-4308','','Ozark-Ouachita highlands assessment : aquatic conditions.');
INSERT INTO new_titles VALUES ('2000/09/28','A 13.88:SRS-31','ANZ-4307','','Ozark-Ouachita highlands assessment : summary report /');
INSERT INTO new_titles VALUES ('2000/09/28','A 13.88:SRS-32','ANZ-4306','','Ozark-Ouachita highlands assessment : air quality /');
INSERT INTO new_titles VALUES ('2000/09/28','TD 4.8/5:8082-5','ANZ-4298','','Commercial pilot knowledge test guide');
INSERT INTO new_titles VALUES ('2000/10/05','HD58.82 .B43 2000','ANX-7148','Belasen, Alan T., 1951-','Leading the learning organization : communication and competencies for managing change /');
INSERT INTO new_titles VALUES ('2000/10/05','RC570.2 .B44 2000','ANX-6784','','Behavioral observation : technology and applications in developmental disabilities /');
INSERT INTO new_titles VALUES ('2000/10/06','T 22.19/2:IN 8/5-3','ANX-1793','','INTERNAL REVENUE MANUAL... NUMERICAL & ALPHABETICAL INDEX (AS OF APRIL 18, 2000)... DEPARTMENT OF THE TREASURY');
INSERT INTO new_titles VALUES ('2000/10/05','QA76.76.O63 M3727 2000','ANX-5518','Matthews, Martin S.','Windows 2000 : a beginner\'s guide /');
INSERT INTO new_titles VALUES ('2000/10/05','TC157.8 .C65 1999','ANX-4436','','Computer applications in hydraulic engineering /');
INSERT INTO new_titles VALUES ('2000/10/06','NS 1.22:SCI 2/22/998','ANX-1792','','STATISTICAL PROFILES OF FOREIGN DOCTORAL RECIPIENTS IN SCIENCE AND ENGINEERING: PLANS TO STAY IN THE UNITED STATES... A');
INSERT INTO new_titles VALUES ('2000/10/06','L 2.71:940','ANX-1791','','CONSUMER EXPENDITURES IN 1998... REPORT 940... U.S. DEPARTMENT OF LABOR... FEBRUARY 2000');
INSERT INTO new_titles VALUES ('2000/10/06','PR6019.O9 Z7115 2000','ANW-3351','Levitt, Morton.','James Joyce and modernism : beyond Dublin /');
INSERT INTO new_titles VALUES ('2000/10/05','TK1001 .E36 2000','ANX-3878','El-Hawary, M. E.','Electrical energy systems /');
INSERT INTO new_titles VALUES ('2000/10/06','LB1029.P67 C65 2000','ANS-3141','','Portfolios across the curriculum and beyond /');
INSERT INTO new_titles VALUES ('2000/10/06','RL96 .B69 1999','ANR-1044','Bozzo, Paul, 1938-','Dermatology and dermatopathology : a dynamic interface /');
INSERT INTO new_titles VALUES ('2000/09/27','GV199.44.N462 A5664 2000','ANY-1005','Roberts, David, 1943-','True summit : what really happened on the legendary ascent of Annapurna /');
INSERT INTO new_titles VALUES ('2000/09/27','B2799.E8 Z87 2000','ANY-1001','Zupancic, Alenka.','Ethics of the real : Kant, Lacan /');
INSERT INTO new_titles VALUES ('2000/09/27','DS110.I68 T45 1999','ANY-0734','','Tel `Ira : a stronghold in the Biblical Negev /');
INSERT INTO new_titles VALUES ('2000/10/05','VA 1.1/5:','ANX-3426','United States. Board of Veterans Appeals.','Report of the chairman');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.2:OSI-00-4','ANX-1834','United States. General Accounting Office.','HCFA three largest Medicare overpayment settlements were improper : report to the Chairman, Permanent Subcommittee on In');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.2:OGC-00-25','ANX-1833','United States. General Accounting Office. Office of the General Counsel.','Department of Agriculture, Farm Service Agency and Commodity Credit Corporation 1999 crop and market loss assistance /');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.2:OGC-00-24','ANX-1832','United States. General Accounting Office. Office of the General Counsel.','Federal Emergency Management Agency Hurricane Floyd property acquisition and relocation grants /');
INSERT INTO new_titles VALUES ('2000/09/27','QA274.A1 C66 2001','ANY-7400','','Complex stochastic systems /');
INSERT INTO new_titles VALUES ('2000/09/27','RJ499.3 .H332 2000','ANY-7403','','Handbook of developmental psychopathology /');
INSERT INTO new_titles VALUES ('2000/09/27','E99.C88 J648 2000','ANY-7387','Wiebe, Rudy Henry, 1934-','Stolen life : the journey of a Cree woman /');
INSERT INTO new_titles VALUES ('2000/09/27','QL696.F32 S56 2000','ANY-7380','Simmons, Robert E.','Harriers of the world : their behaviour and ecology /');
INSERT INTO new_titles VALUES ('2000/09/27','PN2035 .W485 2000','ANY-7370','','Who\'s who in contemporary world theatre /');
INSERT INTO new_titles VALUES ('2000/09/27','LB2331.72 .S83 2000','ANY-7368','','Succeeding in an academic career : a guide for faculty of color /');
INSERT INTO new_titles VALUES ('2000/09/27','G680 .N33 1999','ANY-7363','','The natural and societal challenges of the Northern Sea route : a reference work /');
INSERT INTO new_titles VALUES ('2000/09/27','HV8141 .R67 2000','ANY-7361','Ross, Jeffrey Ian.','Making news of police violence : a comparative study of Toronto and New York City /');
INSERT INTO new_titles VALUES ('2000/09/27','ML395 .G65 2000','ANY-7357','Goldsmith, Martin, 1952-','The inextinguishable symphony : a true story of music and love in Nazi Germany /');
INSERT INTO new_titles VALUES ('2000/09/27','QH541 .G64 2000','ANY-7352','Gorshkov, V. G., 1935-','Biotic regulation of the environment : key issue of global change /');
INSERT INTO new_titles VALUES ('2000/09/27','JK2261 .S86 2000','ANY-7353','Stonecash, Jeffrey M.','Class and party in American politics /');
INSERT INTO new_titles VALUES ('2000/09/27','E208 .B36 2000','ANY-7355','Barnes, Ian, 1946-','The historical atlas of the American Revolution /');
INSERT INTO new_titles VALUES ('2000/09/27','HQ1064.U5 K63 2000','ANY-7350','Koch, Tom, 1949-','Age speaks for itself : silent voices of the elderly /');
INSERT INTO new_titles VALUES ('2000/09/27','JC11 .S57 2000','ANY-7345','Smith, Mark J., 1962-','Rethinking state theory /');
INSERT INTO new_titles VALUES ('2000/09/27','QA372 .C5482 2000','ANY-7342','Chowdhury, A. R. (A. Roy)','Painlev analysis and its applications /');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.2:OGC-00-16','ANX-1831','United States. General Accounting Office. Office of the General Counsel.','Department of Agriculture, Food Safety and Inspection Service irradiation of meat food products /');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.2:JFMIP-SR-99-14','ANX-1825','United States. Joint Financial Management Improvement Program.','Seized property and forfeited assets systems requirements');
INSERT INTO new_titles VALUES ('2000/09/27','HQ759 .I33 2000','ANY-7337','','Ideologies and technologies of motherhood : race, class, sexuality, nationalism /');
INSERT INTO new_titles VALUES ('2000/09/27','RC756 .L38 vol. 148','ANY-7307','','Pulmonary and peripheral gas exchange in health and disease /');
INSERT INTO new_titles VALUES ('2000/09/27','TA355 .I5337 2000','ANY-5768','International Conference on Vibration Measurements by Laser Techniques: Advances and Applications (4th : 2000 : Ancona, Italy)','Fourth International Conference on Vibration Measurements by Laser Techniques: Advances and Applications : 21-23 June, 2');
INSERT INTO new_titles VALUES ('2000/09/27','HF3840.S45 I58 1999','ANY-5763','','Inventing Nanjing Road : commercial culture in Shanghai, 1900-1945 /');
INSERT INTO new_titles VALUES ('2000/09/27','TK7895.O6 O69 2000','ANY-5767','','Optics in computing 2000 : 18-23 June, 2000, Quebec City, Canada /');
INSERT INTO new_titles VALUES ('2000/09/27','NA6422 .A78 1985','ANY-1913','','Art + architecture + landscape : the Clos Pegase Design Competition /');
INSERT INTO new_titles VALUES ('2000/09/27','TR140.B75 B73 2000','ANY-4521','','Brassa : the monograph /');
INSERT INTO new_titles VALUES ('2000/09/27','TS885 .G68 1984','ANY-1907','Greenberg, Cara.','Mid-century modern : furniture of the 1950\'s /');
INSERT INTO new_titles VALUES ('2000/09/27','NA3511.C4 R66 1984','ANY-1912','Rooney, William A.','Architectural ornamentation in Chicago /');
INSERT INTO new_titles VALUES ('2000/09/27','RD71 .F36 2000','ANY-1603','Faraz, Ali.','Engineering approaches to mechanical and robotic design for minimally invasive surgery (MIS) /');
INSERT INTO new_titles VALUES ('2000/09/28','','ANZ-4294','Duggan, Christopher','Francesco Crispi, \'Political Education\' and the Problem of Italian National Consciousness, 1860-1896');
INSERT INTO new_titles VALUES ('2000/09/28','','ANZ-4290','Akira Iriye','Japan\'s Drive to Great-Power Status (Ch.5)');
INSERT INTO new_titles VALUES ('2000/09/28','SF395.8.A1 P67 vol. 68 1989','ANZ-4281','Biehl, LeRoy G.','Guidelines for the development of a swine herd health calendar /');
INSERT INTO new_titles VALUES ('2000/09/28','A 1.36:1882','ANZ-4271','Canning, Patrick N.','Regionalism, federalism, and taxation a food and farm perspective /');
INSERT INTO new_titles VALUES ('2000/09/28','A 1.36:1881','ANZ-4269','Reed, Albert J.','Structural change and competition in seven U.S. food markets /');
INSERT INTO new_titles VALUES ('2000/09/28','Y 3.N 88:27/0169','ANZ-4232','Water Reactor Safety Information Meeting (27th : 1999 : Bethesda, Md.)','Proceedings of the Twenty-seventh Water Reactor Safety Information Meeting : held at Bethesda Marriott Hotel, Bethesda,');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.2:GGD-OGC-00-51 R','ANX-1818','','ROLE OF THE OFFICE OF THRIFT SUPERVISION AND OFFICE OF THE COMPTROLLER OF THE CURRENCY IN THE PREEMPTION OF STATE LAW..');
INSERT INTO new_titles VALUES ('2000/09/29','','ANZ-4928','Vanderheiden, Gregg C.','Ch. 60 : Design for people with functional limitations resulting from disability, aging, or circumstance[Photocopy]');
INSERT INTO new_titles VALUES ('2000/09/29','','ANZ-4924','French, J.S.','Order Expanded: Racial and Neoclassicform');
INSERT INTO new_titles VALUES ('2000/09/29','','ANZ-4912','Cogswell, David','Chomsky for beginners');
INSERT INTO new_titles VALUES ('2000/09/29','','ANZ-4922','French,J.S.','CH3: Order Evolved: Medieval Metamorphosis');
INSERT INTO new_titles VALUES ('2000/09/29','TG24.N82 D8 2000b','ANZ-4830','James, Michele L.','Durham County bridge no. 42 on Chapel Hill Road (SR 1127) over US 15-501 Business, federal aid project # BRSTP-1127(4),');
INSERT INTO new_titles VALUES ('2000/09/29','','ANZ-4865','Kleimann, Susan.','Reciprocal Relattionship of Workplace Culture and Review.');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-272182','ANZ-4807','United States. General Accounting Office.','[Protest of USMS contract award for x-ray security screening systems]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-272179','ANZ-4806','United States. General Accounting Office.','[Protest of NAVFAC rejection of bid for street and parking lot repair and resurfacing]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-272168','ANZ-4804','United States. General Accounting Office.','[Protest of HUD contract award for real estate closing services]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-272163','ANZ-4792','United States. General Accounting Office.','[Protest of proposed DRMS contract award for sale of assorted surplus electrical, electronic, and aircraft parts]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-272162','ANZ-4791','United States. General Accounting Office.','[Protest of DPSC contract award for shirts]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-272139','ANZ-4752','United States. General Accounting Office.','[Protest of Army solicitation for munitions demilitarization]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-272121','ANZ-4751','United States. General Accounting Office.','[Protest of VA purchase order for piping system and alarm services]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-272114','ANZ-4745','United States. General Accounting Office.','[Protest of Army rejection of bid for security guard services]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-272069','ANZ-4740','United States. General Accounting Office.','[Protest of Army rejection of bid for howitzer development participation]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-272067','ANZ-4739','United States. General Accounting Office.','[Protest of Navy contract award for pump diaphragm assemblies]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-272040','ANZ-4736','United States. General Accounting Office.','[National Aeronautics and Space Administration, use of appropriations to fund expansion of \"Career Transition Assistance');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-271895','ANZ-4735','United States. General Accounting Office.','[Comments on Embassy employee\'s relief from liability for lost cash]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-271891','ANZ-4731','United States. General Accounting Office.','[Air Force member\'s claim for dislocation allowance]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-271882','ANZ-4730','United States. General Accounting Office.','[Protest of Army contract award for GPS receiver]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-271821','ANZ-4726','United States. General Accounting Office.','[Protest of Army contract awards for program support services]');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.2:AIMD/HEHS-00-102 R','ANX-1811','','SOCIAL SECURITY REFORM: EVALUATION OF THE NICK SMITH PROPOSAL... 163307... U.S. GAO... FEBRUARY 29, 2000');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-271693','ANZ-4725','United States. General Accounting Office.','[Protest of Forest Service contract award for publication support services]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-271587.2','ANZ-4720','United States. General Accounting Office.','[Protest of USDA rejection of bid and contract award for road construction]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-271415','ANZ-4719','United States. General Accounting Office.','[Navy member\'s claim for pay and allowances during appellate leave status]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-271242','ANZ-4714','United States. General Accounting Office.','[FAA employee\'s claim for real estate expenses]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-271236.3','ANZ-4713','United States. General Accounting Office.','[Protest of USDA rejection of bid and contract award for road construction]');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.5/A-2:B-271034.2','ANZ-4709','United States. General Accounting Office.','[Claim for reimbursement for protest costs]');
INSERT INTO new_titles VALUES ('2000/09/29','LD3921 Marine, Earth & Atm. Sci. M46','ANZ-4556','McManus, Terrie Ruth, 1955-','Adaptation of geology laboratory exercises for students with blindness /');
INSERT INTO new_titles VALUES ('2000/09/29','[DVD] PN1997.99 .K343 1996','ANZ-3936','','Kaho naa-- pyaar hai');
INSERT INTO new_titles VALUES ('2000/09/29','NA2765 .G65 1941','ANZ-3487','Goldfinger, Ern.','The sensation of space /');
INSERT INTO new_titles VALUES ('2000/09/29','TS1105 .P26 2000','ANZ-3732','','Papermaking.');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/7:106-231','ANY-9199','United States. President (1993- : Clinton)','Progress toward achieving benchmarks in Bosnia : communication from the President of the United States transmitting a re');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/7:106-223','ANY-9129','United States. President (1993- : Clinton)','Status of U.S. efforts regarding Iraq\'s compliance with UNSC resolutions : communication from the President of the Unite');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/5:106-267','ANY-9124','United States. Congress. Senate. Committee on Energy and Natural Resources.','Valles Caldera Preservation Act : report (to accompany S. 1892).');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/5:106-271','ANY-9105','United States. Congress. Senate. Committee on Energy and Natural Resources.','Exchanges of land around the Cascade Reservoir : report (to accompany S. 1778).');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/8:106-610/PT.1-','ANY-9059','United States. Congress. House. Committee on Government Reform.','Long-Term Care Security Act : report (to accompany H.R. 4040).');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/7:106-192','ANY-9042','United States. Office of the Assistant Secretary of the Army (Civil Works)','Rio Grande de Manati at Barceloneta, Puerto Rico flood damage reduction project : communication from the Assistant Secre');
INSERT INTO new_titles VALUES ('2000/09/29','BT205 .T47 1994','ANY-8518','Thangaraj, M. Thomas (Melchizedec Thomas)','The crucified guru : an experiment in cross-cultural Christology /');
INSERT INTO new_titles VALUES ('2000/09/29','M985.X5 P55 1996','ANY-8099','Xenakis, Iannis, 1922-','Pleades');
INSERT INTO new_titles VALUES ('2000/09/29','TA480.M3 N34 2000','ANY-7763','Nagaoka International Workshop on Magnesium Platform Science and Technology (1st : 2000 : Nagaoka City, Japan)','Magnesium alloys 2000 : proceedings of the first Nagaoka International Workshop on Magnesium Platform Science and Techno');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.2:AIMD-00-92 R','ANX-1809','','COMPUTER SECURITY: REPORTED APPROPRIATIONS AND OBLIGATIONS FOR FOUR MAJOR INITIATIVES... 163299... U.S. GAO... FEBRUARY');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.2:AIMD-00-82 R','ANX-1807','','GAO REPORT ON APPLYING AGREED-UPON PROCEDURES: HIGHWAY TRUST FUND EXCISE TAXES... 163278... U.S. GAO... FEBRUARY 25, 20');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.2:AIMD-00-79','ANX-1804','','FINANCIAL AUDIT: BUREAU OF THE PUBLIC DEBT\'S FISCAL YEARS 1999 AND 1998 SCHEDULES OF FEDERAL DEBT... 163260... U.S. GAO');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.2:AIMD-00-76','ANX-1803','','FINANCIAL AUDIT: IRS\' FISCAL YEAR 1999 FINANCIAL STATEMENTS... 163257... U.S. GAO... FEBRUARY 29, 2000');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-0085','Mahanama-sthavira, Thera','Chapters 1-5');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-0087','Mahanama-sthavira, Thera','Chapters 13-14, 17-20');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-0089','Breckler, Steven J.','Emotion and Attitude Change');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-8908','Cobb, Edith','The ecology of imagination in childhood');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-8669','Batchelor, Peter','Interpretations of Urban Form and Structure');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-8675','Batchelor, Peter','Case Studies in Urban Development');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-8386','Batchelor, Peter','Grain');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-8433','Batchelor, Peter','Densityand Built Form andTable: Comparative Urbanism');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-8188','Batchelor,Peter','Internal Pattern');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-7992','Batchelor , Peter','LandForms');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-8101','Batchelor, Peter','Structure and Land Use');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-7990','Batchelor,Peter','Seminar Presentations Origin and Evolution of Cities');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-7942','Batchelor, Peter','Vehicular Movement Classification System');
INSERT INTO new_titles VALUES ('2000/09/29','E840.8.A37 L57 2000','ANY-7405','Lippman, Thomas W.','Madeleine Albright and the new American diplomacy /');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-7836','Batchelor, Peter','General requirements and Readings,Seminar and Lecture notes');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-7450','Allison, Archibald','Essays on the Nature ...of taste');
INSERT INTO new_titles VALUES ('2000/09/29','PN98.I58 A45 2000','ANY-7338','Allen, Graham, 1963-','Intertextuality /');
INSERT INTO new_titles VALUES ('2000/09/29','PN1996 .D39 2000','ANY-7323','Dawson, Jonathan.','Screenwriting : a manual /');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-0083','Mahanama-sthavira, Thera','Chapters 28-31');
INSERT INTO new_titles VALUES ('2000/10/04','I 19.91:I-2628','AOA-1387','Geological Survey (U.S.)','Geologic map of the Littlefield 30\' x 60\' quadrangle, Mohave County, northwestern Arizona /');
INSERT INTO new_titles VALUES ('2000/10/04','I 19.91:I-2702','AOA-1386','Valentine, Page C.','Sun-illuminated sea floor topography of quadrangle 2 in the Stellwagen Bank National Marine Sanctuary off Boston, Massac');
INSERT INTO new_titles VALUES ('2000/10/04','I 19.91:I-2706','AOA-1384','Valentine, Page C.','Sun-illuminated sea floor topography of quadrangle 6 in the Stellwagen Bank National Marine Sanctuary off Boston, Massac');
INSERT INTO new_titles VALUES ('2000/10/04','I 19.91:I-2703','AOA-1385','Valentine, Page C.','Sun-illuminated sea floor topography of quadrangle 3 in the Stellwagen Bank National Marine Sanctuary off Boston, Massac');
INSERT INTO new_titles VALUES ('2000/10/04','I 19.91:I-2705','AOA-1383','Valentine, Page C.','Sun-illuminated sea floor topography of quadrangle 5 in the Stellwagen Bank National Marine Sanctuary off Boston, Massac');
INSERT INTO new_titles VALUES ('2000/10/04','I 19.91:I-2542','AOA-1382','Geological Survey (U.S.)','Geologic map of the Red Bluff 30\' x 60\' quadrangle, California /');
INSERT INTO new_titles VALUES ('2000/10/04','I 19.91:I-2308','AOA-1010','Geological Survey (U.S.)','Geologic map of the Mohave Mountains area, Mohave County, western Arizona /');
INSERT INTO new_titles VALUES ('2000/10/04','I 19.91:I-2692','AOA-1007','','Sidescan sonar image, surficial geologic interpretation, and bathymetry of the Long Island Sound sea floor off Roanoke P');
INSERT INTO new_titles VALUES ('2000/10/04','I 19.91:I-2653','AOA-1005','Geological Survey (U.S.)','Geologic map of the Eminence quadrangle, Shannon County, Missouri ... 1999 /');
INSERT INTO new_titles VALUES ('2000/10/04','I 19.91:I-2707','AOA-1002','Valentine, Page C.','Sun-illuminated sea floor topography of quadrangle 7 in the Stellwagen Bank National Marine Sanctuary off Boston, Massac');
INSERT INTO new_titles VALUES ('2000/10/04','PR1868.P3 F3','ANZ-5264','Faulkner, Dewey R., comp.','Twentieth century interpretations of the Pardoner\'s tale; a collection of critical essays,');
INSERT INTO new_titles VALUES ('2000/10/04','TP814 .F56 1999','ANZ-4780','','Finishing of advanced ceramics and glasses /');
INSERT INTO new_titles VALUES ('2000/10/04','HD5717.5.A78 L33 1999','ANZ-5105','','Labour migration and the recent financial crisis in Asia /');
INSERT INTO new_titles VALUES ('2000/10/04','QP752.F35 C87 1999','ANZ-4769','','Current views of fatty acid oxidation and ketogenesis : from organelles to point mutations /');
INSERT INTO new_titles VALUES ('2000/10/04','TK7876 .M358 2000','ANZ-4765','','Materials issues for tunable RF and microwave devices : symposium held November 30-December 2, 1999, Boston, Massachuset');
INSERT INTO new_titles VALUES ('2000/10/04','PS3554.E17615 F37 2000','ANZ-4349','DeBerry, Virginia.','Far from the tree /');
INSERT INTO new_titles VALUES ('2000/10/04','Q125.2 .D67 2000','ANZ-4285','Dorn, Matthias.','Das Problem der Autonomie der Naturwissenschaften bei Galilei /');
INSERT INTO new_titles VALUES ('2000/10/04','TS156 .W85 2000','ANZ-3038','Wu, Yuin.','Taguchi Methods for robust design /');
INSERT INTO new_titles VALUES ('2000/10/04','TD194.68.E852 E54 2000','ANZ-3652','','Environmental assessment in countries in transition /');
INSERT INTO new_titles VALUES ('2000/10/04','PG3485.5.A85 P7613 1991b','ANZ-2756','Rasputin, Valentin Grigor\'evich.','Farewell to Matyora /');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/5:106-310','ANZ-2201','United States. Congress. Senate. Committee on Commerce, Science, and Transportation.','The next generation Internet 2000 : report of the Committee on Commerce, Science, and Transportation on S. 2046.');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/5:106-315','ANZ-2200','United States. Congress. Senate. Committee on Energy and Natural Resources.','Conveyance of certain land to Park County, Wyoming : report (to accompany S. 1894).');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/5:106-320','ANZ-2199','United States. Congress. Senate. Committee on Energy and Natural Resources.','Wilson Creek, North Carolina : report (to accompany H.R. 1749).');
INSERT INTO new_titles VALUES ('2000/09/29','PS3569.W247 N49 2000','ANY-7319','Swan, Gladys, 1934-','News from the volcano : stories /');
INSERT INTO new_titles VALUES ('2000/09/29','PS3573.H47447 M37 2000','ANY-7318','White, Michael C.','Marked men : stories /');
INSERT INTO new_titles VALUES ('2000/09/29','PR4173 .B36 2000','ANY-7313','Barnard, Robert.','Emily Bront /');
INSERT INTO new_titles VALUES ('2000/09/29','PS3570.H5626 D4 2000','ANY-7312','Thomas, F. Richard.','Death at Camp Pahoka : poems /');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/5:106-313','ANZ-2198','United States. Congress. Senate. Committee on Energy and Natural Resources.','Washakie County and Big Horn County, Wyoming : report (to accompany S. 610).');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/5:106-319','ANZ-2166','United States. Congress. Senate. Committee on Energy and Natural Resources.','Saint Croix Island Heritage Act : report (to accompany S. 2485).');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/5:106-312','ANZ-2089','United States. Congress. Senate. Committee on Appropriations.','Department of the Interior and related agencies appropriations bill, 2001 : report (to accompany H.R. 4578).');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/7:106-255','ANZ-2056','United States. President (1993- : Clinton)','A report to the Congress on Executive Order 12938 : message from the President of the United States transmitting a repor');
INSERT INTO new_titles VALUES ('2000/10/04','TK9360 .O734 2000','ANZ-0806','','Radiological impacts of spent nuclear fuel management options : a comparative study /');
INSERT INTO new_titles VALUES ('2000/10/04','TD898.14.R57 R44 2000','ANZ-0674','','Regulatory reviews of assessments of deep geologic repositories : lessons learnt = valuation des dpts gologiques pro');
INSERT INTO new_titles VALUES ('2000/10/04','LC93.R6 R65 2000','ANZ-0673','','Romania /');
INSERT INTO new_titles VALUES ('2000/10/04','TD171.5.G8 E65 2000','ANZ-0671','','Environmental performance reviews.');
INSERT INTO new_titles VALUES ('2000/10/04','LC149 .L4993 2000','ANZ-0537','','Literacy in the information age : final report of the International Adult Literacy Survey.');
INSERT INTO new_titles VALUES ('2000/10/04','HD5811.8.A6 L33 2000','ANZ-0538','','Labour market and social policies in Romania /');
INSERT INTO new_titles VALUES ('2000/10/04','HD9502.A2 W46 2000','ANZ-0536','Wene, Clas-Otto.','Experience curves for energy technology policy /');
INSERT INTO new_titles VALUES ('2000/10/04','LB1065 .C45 2000','ANZ-0533','','Motivating students for lifelong learning /');
INSERT INTO new_titles VALUES ('2000/10/04','HD5764.5.A5 P55 2000','ANZ-0534','','Policies towards full employment.');
INSERT INTO new_titles VALUES ('2000/10/04','TK9178 .W76 1999','ANZ-0523','Workshop on Core Monitoring For Commercial Reactors : Improvements in Systems and Methods (1999 : Stockholm, Sweden)','Proceedings of the workshop on core monitoring for commercial reactors : improvements in systems and methods : Stockholm');
INSERT INTO new_titles VALUES ('2000/10/04','HC60 .D473 1999 no. 36','ANZ-0405','','Norway /');
INSERT INTO new_titles VALUES ('2000/10/04','HD9685.U5 P29 1999','ANZ-0411','Paffenbarger, John.','Electricity reform : power generation costs and investment /');
INSERT INTO new_titles VALUES ('2000/10/04','HF1379 .A86 2000','ANZ-0060','','Assessing the environmental effects of trade liberalisation agreements : methodologies.');
INSERT INTO new_titles VALUES ('2000/10/04','HD3616.M6 R44 1999','ANZ-0010','','Regulatory reform in Mexico.');
INSERT INTO new_titles VALUES ('2000/10/04','HT169.G72 B4987 2000','ANZ-0011','','Urban renaissance : Belfast\'s lessons for policy and partnership /');
INSERT INTO new_titles VALUES ('2000/10/04','HE305 .I54 2000','ANZ-0008','','Integrating transport in the city : reconciling the economic, social and environmental dimensions.');
INSERT INTO new_titles VALUES ('2000/10/04','HG925 .E48 2000','ANZ-0007','','EMU : one year on');
INSERT INTO new_titles VALUES ('2000/10/04','HC79.E5 V663 1999','ANZ-0006','','Voluntary approaches for environmental policy : an assessment.');
INSERT INTO new_titles VALUES ('2000/10/04','HG3821 .P871 1999','ANZ-0005','','Purchasing power parities and real expenditures = Parits de pouvoir d\'achat et dpenses relles : 1996 results = Rsult');
INSERT INTO new_titles VALUES ('2000/10/04','LC191 .K59 2000','ANZ-0004','','Knowledge management in the learning society /');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/7:106-191','ANY-9293','United States. Office of the Assistant Secretary of the Army (Civil Works)','Restoration project for Oakland Harbor, California : communication from the Assistant Secretary (Civil Works), the Depar');
INSERT INTO new_titles VALUES ('2000/09/27','DS87.54 D34 2000','ANY-0670','Dagher, Carole.','Bring down the walls : Lebanon\'s post-war challenge /');
INSERT INTO new_titles VALUES ('2000/09/27','Y 4.IN 8/16:SE 2/9','ANX-8976','','106-1 Hearing: Encryption Security in a High Tech Era, May 18, 1999');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/5:106-316','ANY-9267','United States. Congress. Senate. Committee on Energy and Natural Resources.','Wekiva Wild and Scenic River Designation Act : report (to accompany S. 2352).');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/4:106-34','ANY-9266','Sri Lanka.','Extradition treaty with Sri Lanka : message from the President of the United States transmitting Extradition Treaty betw');
INSERT INTO new_titles VALUES ('2000/09/27','Y 4.ED 8/1:106-96','ANX-8974','United States. Congress. House. Committee on Education and the Workforce. Subcommittee on Employer-Employee Relations.','\"The Wealth through the Workplace Act : worker ownership in today\'s economy\" : hearing before the Subcommittee on Employ');
INSERT INTO new_titles VALUES ('2000/09/27','Y 4.ED 8/1:106-92','ANX-8972','United States. Congress. House. Committee on Education and the Workforce. Subcommittee on Early Childhood, Youth, and Families.','The role of character education in America\'s schools : hearing before the Subcommittee on Early Childhood, Youth, and Fa');
INSERT INTO new_titles VALUES ('2000/09/27','Y 4.ED 8/1:106-105','ANX-8970','United States. Congress. House. Committee on Education and the Workforce. Subcommittee on Oversight and Investigations.','Open shops in the 21st century workplace : hearing before the Subcommittee on Oversight and Investigations of the Commit');
INSERT INTO new_titles VALUES ('2000/09/27','Y 4.ED 8/1:106-101','ANX-8969','United States. Congress. House. Committee on Education and the Workforce. Subcommittee on Oversight and Investigations.','Under the radar screen, rulemaking at the U.S. Department of Labor : OSHA\'s employee work-at-home policy and beyond : he');
INSERT INTO new_titles VALUES ('2000/09/27','Y 4.B 22/1:106-50','ANX-8968','United States. Congress. House. Committee on Banking and Financial Services. Subcommittee on Capital Markets, Securities, and Government Sponsored Enterprises.','H.R. 2924, the Hedge Fund Disclosure Act : hearing before the Subcommittee on Capital Markets, Securities, and Governmen');
INSERT INTO new_titles VALUES ('2000/09/27','PREX 3.10/4:SR 3/4','ANX-8962','United States. Central Intelligence Agency.','Sri Lanka.');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/4:106-33','ANY-9265','Nicaragua.','Investment treaty with Nicaragua : message from the President of the United States transmitting Treaty between the Gover');
INSERT INTO new_titles VALUES ('2000/09/27','L 2.3:2528','ANX-8920','','Occupational Employment and Wages, 1998, Bulletin 2528, June 2000');
INSERT INTO new_titles VALUES ('2000/09/27','PREX 3.10/4:SR 3/3','ANX-8961','United States. Central Intelligence Agency.','Sri Lanka.');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/4:106-32','ANY-9264','Vienna Convention for the Protection of the Ozone Layer (1985). Protocols, etc., 1987 Sept. 15.','Amendment to Montreal Protocol (\"Beijing Amendment\") : message from the President of the United States transmitting amen');
INSERT INTO new_titles VALUES ('2000/09/27','HE 20.409/2:EL 2','ANX-8917','','Elementary youth /');
INSERT INTO new_titles VALUES ('2000/09/27','L 35.2:W 57/2000/ENG./SPAN.','ANX-8919','','Protecting Whistleblowers with job safety and health complaints, 2000, (ENGLISH/SPANISH)');
INSERT INTO new_titles VALUES ('2000/09/27','HE 20.3958:N 21','ANX-8916','','The NIDA Community-Based Outreach Model: A Manual To Reduce the Risk of HIV etc., July 2000');
INSERT INTO new_titles VALUES ('2000/09/27','ED 1.308:B 11/SPAN.','ANX-8915','Dodge, Diane Trister.','Cmo estimular el cerebro infantil : una gua para padres de familia /');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/5:106-307','ANY-9240','United States. Congress. Senate. Committee on Indian Affairs (1993- )','To make technical corrections to the status of certain land held in trust for the Mississippi Band of Choctaw Indians, t');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/5:106-309','ANY-9223','United States. Congress. Senate. Committee on Appropriations.','Department of Transportation and related agencies appropriations bill, 2001 : report (to accompany S. 2720).');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:210200','ANY-8164','','A REVIEW OF ELECTRICAL IMPEDANCE SPECTROMETRY METHODS FOR PARAMETRIC ESTIMATION OF PHYSIOLOGIC FINAL REPORT... NASA/TM-');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:210132','ANY-8163','','A PILOT STUDY FOR APPLYING AN EXTRAVEHICULAR ACTIVITY EXERCISE PREBREATHE PROTOCOL TO THE INTERNATIONAL SPACE... NASA/T');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:210131','ANY-8162','','ANALYSIS AND ASSESSMENT OF PEAK LIGHTNING CURRENT PROBABILITIES AT THE NASA KENNEDY SPACE CENTER... NASA/TM-2000-210131');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:210130','ANY-8161','','SCIENTIFIC AND TECHNICAL REPORTS, ARTICLES, PAPERS, AND PRESENTATIONS... NASA/TM-2000-210130... JUN. 7, 2000');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:210129','ANY-8160','','MAGNETICALLY ACTUATED PROPELLANT ORIENTATION EXPERIMENT, CONTROLLING FLUID MOTION WITH MAGNETIC FINAL REPORT... NASA/TM');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:210107','ANY-8159','','HIGH-SPEED RESEARCH SURVEILLANCE SYMBOLOGY ASSESSMENT EXPERIMENT... NASA/TM-2000-210107... JUN. 7, 2000');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:210106','ANY-8158','','A PRACTICAL ENGINEERING APPROACH TO PREDICTING FATIGUE CRACK GROWTH IN RIVETED LAP JOINTS... NASA/TM-2000-210106... JUN');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:210084','ANY-8156','','ADVANCES IN FATIGUE AND FRACTURE MECHANICS ANALYSES FOR METALLIC AIRCRAFT STRUCTURES... NASA/TM-2000-210084... JUN. 7,');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:210095','ANY-8157','','AEROTHERMAL ANALYSIS AND DESIGN OF THE GRAVITY RECOVERY AND CLIMATE EXPERIMENT (GRACE) SPACECRAFT... NASA/TM-2000-21009');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:209883','ANY-8155','','THE MAGNETOSPHERIC MULTISCALE MISSION... RESOLVING FUNDAMENTAL PROCESSES IN SPACE PLASMAS... NASA/TM-2000-209883... JUN');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:209882','ANY-8154','','NASA/GSFC RESEARCH ACTIVITIES FOR THE GLOBAL OCEAN CARBON CYCLE: A PROSPECTUS FOR THE 21ST CENTURY... NASA/TM-2000/2098');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:209859','ANY-8153','','FLIGHT TEST MEASUREMENTS FROM THE TU-144LL STRUCTURE/CABIN NOISE FOLLOW-ON EXPERIMENT... NASA/TM-2000-209859... JUN. 7,');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:209858','ANY-8152','','FLIGHT TEST MEASUREMENTS FROM THE TU-144LL STRUCTURE/CABIN NOISE EXPERIMENT... NASA/TM-2000-209858... JUN. 7, 2000');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:209856','ANY-8150','','RESIDUAL STRENGTH ANALYSES OF RIVETED LAP-SPLICE JOINTS... NASA/TM-2000-209856... JUN. 7, 2000');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:209761','ANY-8149','','SKIN TEMPERATURES DURING UNAIDED EGRESS: UNSUITED AND WHILE WEARING THE NASA LAUNCH AND ENTRY OR ADVANCED CREW... NASA/');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:209710','ANY-8148','','RAMAN SHIFTING A TUNABLE ARF EXCIMER LASER TO WAVELENGTHS OF 190 TO 240 NM WITH A FORCED CONVECTION RAMAN CELL... NASA/');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:209291','ANY-8147','','PREPARATION OF ION EXCHANGE FILMS FOR SOLID-PHASE SPECTROPHOTOMETRY AND SOLID-PHASE FLUOROMETRY... NASA/TM-2000-209291.');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:209021','ANY-8145','','OPTIMAL PITCH THRUST-VECTOR ANGLE AND BENEFITS FOR ALL FLIGHT REGIMES... NASA/TM-2000-209021... JUN. 8, 2000');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:209019','ANY-8144','','AERODYNAMIC LIFT AND MOMENT CALCULATIONS USING A CLOSED-FORM SOLUTION OF THE POSSIO EQUATION... NASA/TM-2000-209019...');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:209017','ANY-8143','','DEVELOPMENT OF A FLUSH AIRDATA SENSING SYSTEM ON A SHARP-NOSED VEHICLE FOR FLIGHT AT MACH 3 TO 8... NASA/TM-2000-209017');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:208769','ANY-8142','','STEADY SECONDARY FLOWS GENERATED BY PERIODIC COMPRESSION AND EXPANSION OF AN IDEAL GAS IN A PULSE TUBE... NASA/TM-1999-');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:208647','ANY-8141','','SUMMARY REPORT OF MISSION ACCELERATION MEASUREMENT FOR STS-97: LAUNCHED NOVEMBER 19, 1997... NASA/TM-1999-208647... JUN');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:107479','ANY-8140','','FLOW QUALITY STUDIES OF THE NASA GLENN RESEARCH CENTER ICING RESEARCH TUNNEL CIRCUIT (1995 TESTS)... NASA/TM-2000-10747');
INSERT INTO new_titles VALUES ('2000/10/04','GV1785.H37 R68 2000','ANY-7383','Ross, Janice.','Moving lessons : Margaret H\'Doubler and the beginning of dance in American education /');
INSERT INTO new_titles VALUES ('2000/10/04','P96.S34 R58 2000','ANY-7366','Roberts, Adam (Adam Charles)','Science fiction /');
INSERT INTO new_titles VALUES ('2000/10/04','LC58.4 .P58 2001','ANY-7364','Peshkin, Alan.','Permissible advantage? : the moral consequences of elite schooling /');
INSERT INTO new_titles VALUES ('2000/10/04','QH541 .M43 2000','ANY-7362','','Methods in ecosystem science /');
INSERT INTO new_titles VALUES ('2000/10/04','QR185.8.M35 M366 2000','ANY-7339','','Mast cells and basophils /');
INSERT INTO new_titles VALUES ('2000/10/04','QA295 .S85 2000','ANY-7348','','Survey on classical inequalities /');
INSERT INTO new_titles VALUES ('2000/10/04','TJ211 .M45 2000','ANY-7322','Menzel, Peter, 1948-','Robo sapiens : evolution of a new species /');
INSERT INTO new_titles VALUES ('2000/10/04','QA278.8 .B35 2000','ANY-7306','Balakrishnan, N., 1956-','Progressive censoring : theory, methods, and applications /');
INSERT INTO new_titles VALUES ('2000/10/04','TK5105.5 .N48 2000','ANY-7305','','The network manager\'s handbook /');
INSERT INTO new_titles VALUES ('2000/10/04','QC759.6 .J36 1998','ANY-7298','Japan-Hungary Joint Seminar on Applied Electromagnetics in Materials and Computational Technology (5th : 1998 : Budapest, Hungary)','Applied electromagnetics and computational technology II : poceedings of the 5th Japan-Hungary Joint Seminar on Applied');
INSERT INTO new_titles VALUES ('2000/10/04','J 32.10:ED 8/3','ANY-6689','Burrell, Sue.','Special education and the juvenile justice system /');
INSERT INTO new_titles VALUES ('2000/10/04','SI 1.27:607','ANY-6690','Zahuranec, Bernard J.','Zoogeography and systematics of the lanternfishes of the genus Nannobrachium (Myctophidae:Lampanyctini) /');
INSERT INTO new_titles VALUES ('2000/10/04','J 1.2:L 52','ANY-6688','','Do your legal career, Justice : opportunities for entry-level attorneys and law students at the U.S. Department of Justi');
INSERT INTO new_titles VALUES ('2000/10/04','[videocassette] GN286 .O76 1997','ANY-6180','','Origins of homo sapiens East African roots.');
INSERT INTO new_titles VALUES ('2000/10/04','[videocassette] GN281.4 .H57 1997','ANY-6179','','History of the anthropoid the search for the beginning.');
INSERT INTO new_titles VALUES ('2000/10/04','N6512.5.A25 J33 2000','ANY-4794','Jachec, Nancy.','The philosophy and politics of abstract expressionism, 1940-1960 /');
INSERT INTO new_titles VALUES ('2000/10/04','NA6090.2.M37 M56 1998','ANY-4792','','The minbar from the Kutubiyya Mosque /');
INSERT INTO new_titles VALUES ('2000/10/04','NC975 .B57 2000','ANY-4789','Blechman, Nicholas.','Fresh dialogue one : new voices in graphic design /');
INSERT INTO new_titles VALUES ('2000/10/04','NC246 .S75 1999','ANY-4788','Stein, Perrin.','Eighteenth-century French drawings in New York collections /');
INSERT INTO new_titles VALUES ('2000/10/04','HD31 .M625 2000','ANY-4463','Moore, Geoffrey A., 1946-','Living on the fault line : managing for shareholder value in the age of the internet /');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/7:106-262','ANY-4081','','The Corrected 2000 Annual Report Of The Board Of Trustees Of The Federal Hospital Insurance Trust Fund... Communication');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/7:106-261','ANY-4080','','Six Month Periodic Review With Respect To The National Emergency Declared In Iran... Message From The President Of The U');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/7:106-260','ANY-4079','','Six Month Periodic Report On The National Emergency With Respect To Iran... Message From The President Of The United Sta');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/7:106-259','ANY-4078','','National Emergency Regarding Russian Federation Nuclear Weapons... Message From The President Of The United States... Ho');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/7:106-258','ANY-4077','','Report On Continued Contributions In Support Of Peacekeeping Operations In Kosovo... Communication From The President Of');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/7:106-257','ANY-4076','','Report On Rescissions And Deferrals... Communication From The Director, The Office Of Management And Budget... House Doc');
INSERT INTO new_titles VALUES ('2000/10/11','QR46 .A85 1995','ANW-9824','Atlas, Ronald M., 1946-','Handbook of media for clinical microbiology /');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/7:106-256','ANY-4075','','Six Month Periodic Review With Regards To The Lapse Of The Export Administration Act Of 1979... Message From The Preside');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/5:106-321','ANY-4072','','Golden Spike Rail Study... Report 106-321... Senate... 106th Congress, 2nd Session');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/5:106-318','ANY-4069','','Peopling Of America Theme Study Act... Report 106-318... Senate... 106th Congress, 2nd Session');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/5:106-317','ANY-4068','','Upper Housatonic Valley National Heritage Area Study Act Of 2000... Report 106-317... Senate... 106th Congress, 2nd Sess');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/5:106-314','ANY-4065','','Saint-Gaudens National Historic Site... Report 106-314... Senate... 106th Congress, 2nd Session');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/5:106-311','ANY-4062','','Further Revised Allocation To Subcommittees Of Budget Totals For Fiscal Year 2001... Report 106-311... Senate... 106th C');
INSERT INTO new_titles VALUES ('2000/10/04','Y 1.1/5:106-308','ANY-4059','','Further Revised Allocation To Subcommittees Of Budget Totals For Fiscal Year 2001... Report 106-308... Senate... 106th C');
INSERT INTO new_titles VALUES ('2000/10/04','DS146.G4 G4813 2000','ANY-3595','Gerlach, Wolfgang.','And the witnesses were silent : the Confessing Church and the persecution of the Jews /');
INSERT INTO new_titles VALUES ('2000/10/04','DS918 .A555 2000','ANY-3601','Thornton, Richard C.','Odd man out : Truman, Stalin, Mao, and the origin of the Korean War /');
INSERT INTO new_titles VALUES ('2000/10/04','HC10 .W65','ANY-3568','','A guide to world resources /');
INSERT INTO new_titles VALUES ('2000/10/04','DS126.99.J4 C353 2000','ANY-3586','Cailingold, Asher.','An unlikely heroine : Esther Cailingold\'s fight for Jerusalem /');
INSERT INTO new_titles VALUES ('2000/09/29','M1473.S82 K65 1992','ANY-6214','Stockhausen, Karlheinz, 1928-','Kontakte fr elektronische Klnge, Klavier und Schlagzeug /');
INSERT INTO new_titles VALUES ('2000/09/29','M3.1 .B118 1988','ANY-6212','Babbitt, Milton, 1916-','An Elizabethan sextette ; Solo piano works ; Groupwise ; Vision and prayer');
INSERT INTO new_titles VALUES ('2000/09/29','M22.B101 G6 1997','ANY-6205','Babbitt, Milton, 1916-','Canonical form Emblems : (Ars emblematica) ; Preludes, interludes, and postlude ; Tutte le corde /');
INSERT INTO new_titles VALUES ('2000/09/29','[videocassette] HV8694 .N68 1994','ANY-6135','','Not too young to die capital punishment for juvenile offenders /');
INSERT INTO new_titles VALUES ('2000/09/29','HV9469 .N49 1990z','ANY-6134','','The new Gulag America\'s prisons /');
INSERT INTO new_titles VALUES ('2000/09/29','DB2244.7 .S44 2000','ANY-4875','Shepherd, Robin H. E., 1968-','Czechoslovakia : the velvet revolution and beyond /');
INSERT INTO new_titles VALUES ('2000/09/29','TA450 .B66 2000','ANY-4846','Boolchand, Punit.','Insulating and semiconducting glasses /');
INSERT INTO new_titles VALUES ('2000/09/29','DB99.1 .H48 2000','ANY-4873','Hills, Alice, 1950-','Britain and the occupation of Austria, 1943-45 /');
INSERT INTO new_titles VALUES ('2000/09/29','QC16.E5 E524 2000','ANY-4841','','Einstein : the formative years, 1879-1909 /');
INSERT INTO new_titles VALUES ('2000/09/29','PS374.N6 R87 2000','ANY-4828','Russell, John, 1928-','Reciprocities in the nonfiction novel /');
INSERT INTO new_titles VALUES ('2000/09/29','PS1833 .S38 2000','ANY-4816','Scharnhorst, Gary.','Bret Harte : opening the American literary West /');
INSERT INTO new_titles VALUES ('2000/10/04','RL801 .C67 2000','ANY-3518','','Cosmeceuticals : drugs vs. cosmetics /');
INSERT INTO new_titles VALUES ('2000/10/04','QR46 .H37 2000','ANY-3516','Hawley, Louise B.','High-yield microbiology and infectious diseases /');
INSERT INTO new_titles VALUES ('2000/09/27','ED 1.308:B 11','ANX-8914','Dodge, Diane Trister.','Building your baby\'s brain : a parent\'s guide to the first five years /');
INSERT INTO new_titles VALUES ('2000/09/27','HD8081.A8 K56 1999','ANX-7573','Kim, Jongsung.','Labor supply and occupational structure of Asian immigrants in the U.S. labor market /');
INSERT INTO new_titles VALUES ('2000/10/18','QA276 .S4827 2000','ANZ-3139','Shiriaev, Al\'bert Nikolaevich.','Statistical experiments and decisions : asymptotic theory /');
INSERT INTO new_titles VALUES ('2000/09/29','ND237.E15 B47 2000','ANY-4791','Berger, Martin A.','Man made : Thomas Eakins and the construction of Gilded Age manhood /');
INSERT INTO new_titles VALUES ('2000/09/29','PT405 .E83 2000','ANY-4743','','Evolving Jewish identities in German culture : borders and crossings /');
INSERT INTO new_titles VALUES ('2000/09/29','QC174.12 .F68 2000','ANY-4663','','The foundations of quantum mechanics : historical analysis and open questions : Lecce, Italy, 13-16 October 1998 /');
INSERT INTO new_titles VALUES ('2000/09/29','RC523 .C58 2000','ANY-4641','','Cerebral amyloid angiopathy in Alzheimer\'s disease and related disorders /');
INSERT INTO new_titles VALUES ('2000/09/29','QD504 .C658 2000','ANY-4570','Klotz, Irving M.','Companion to chemical thermodynamics : basic theory and methods /');
INSERT INTO new_titles VALUES ('2000/09/29','TR676 .H36 1999','ANY-4531','Hamilton, China.','Woman /');
INSERT INTO new_titles VALUES ('2000/09/29','DT1970 .M37 2000','ANY-3596','Marks, Susan Collin, 1949-','Watching the wind : conflict resolution during South Africa\'s transition to democracy /');
INSERT INTO new_titles VALUES ('2000/09/29','DA415 .H88 1999','ANY-3522','Hutton, Ronald.','The Royalist war effort, 1642-1646 /');
INSERT INTO new_titles VALUES ('2000/09/29','JQ3898.A1 K37 1999','ANY-3509','Kassem, May.','In the guise of democracy : governance in contemporary Egypt /');
INSERT INTO new_titles VALUES ('2000/09/29','DA125.C4 P577 1999','ANY-3503','Pittock, Murray.','Celtic identity and the British image /');
INSERT INTO new_titles VALUES ('2000/09/29','QA313 .D96 2000','ANY-3315','','Dynamical systems, ergodic theory, and applications /');
INSERT INTO new_titles VALUES ('2000/09/29','QA76.76.H94 X54 2000','ANY-1006','','Professional XML /');
INSERT INTO new_titles VALUES ('2000/09/29','TJ184 .I68 2000','ANY-3297','International Conference on Gearing, Transmissions, and Mechanical Systems (2000 : Nottingham, England)','Proceedings of the International Conference on Gearing, Transmissions, and Mechanical Systems : 3-6, July 2000, Nottingh');
INSERT INTO new_titles VALUES ('2000/09/29','DT510 .N39 2000','ANY-0649','Naylor, Rachel.','Ghana /');
INSERT INTO new_titles VALUES ('2000/09/29','DA334.M8 G88 2000','ANY-0644','Guy, J. A. (John Alexander)','Thomas More /');
INSERT INTO new_titles VALUES ('2000/09/29','D842.2 .R39 2000','ANY-0646','Raymond, Alan.','Children in war /');
INSERT INTO new_titles VALUES ('2000/09/29','Y 4.J 89/1:106/50','ANX-8977','United States. Congress. House. Committee on the Judiciary. Subcommittee on Commercial and Administrative Law.','Consent of Congress to the Missouri-Nebraska Boundary Compact and the boundary change between Georgia and South Carolina');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RMRS-RP-13','AOF-5404','Bartos, Dale L.','Characteristics of endemic-level mountain pine beetle populations in south-central Wyoming /');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-RP-327','AOF-5385','Williams, Michael S.','The extent of bias caused by substituting points in forest survey : a simulation study /');
INSERT INTO new_titles VALUES ('2000/10/28','Course Shelf','AOF-5355','','SEE CSC565.');
INSERT INTO new_titles VALUES ('2000/10/28','Desk File','AOF-5380','Ihde, Don..','Technology and the Lifeworld [Photocopy].');
INSERT INTO new_titles VALUES ('2000/10/28','Course Shelf','AOF-5357','','SEE CSC565.');
INSERT INTO new_titles VALUES ('2000/10/28','Desk Shelf','AOF-5360','Braut, Christian.','Musician\'s Guide to MIDI.');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:PNW-RP-416','AOF-5352','Carey, Andrew B.','Optimal sampling for radiotelemetry studies of spotted owl habitat and home range');
INSERT INTO new_titles VALUES ('2000/10/11','TG24.N82 W2 2000c','ANW-9659','','[NCDOT will replace bridge no. 437 over Lower Barton\'s Creek, on SR 1831 in Wake County].');
INSERT INTO new_titles VALUES ('2000/10/11','TG24.N82 R6 2000','ANW-9639','','Robeson County bridge no. 430 on SR 1539 over Lumber River, federal project MABRZ-1539(1), state project 8.2462001, TIP');
INSERT INTO new_titles VALUES ('2000/10/11','LT4310.G57 A43 1996','ANW-9436','','Fearon\'s American literature.');
INSERT INTO new_titles VALUES ('2000/10/11','LT4310.G57 W67 1998','ANW-9337','','Globe Fearon\'s world literature.');
INSERT INTO new_titles VALUES ('2000/10/11','LT4310.I56 L57 1998 vol.3','ANW-9343','Johnson, Elaine Bowe.','American literature for life and work /');
INSERT INTO new_titles VALUES ('2000/10/11','LC212.42 .S49 2000','ANS-3165','','Sex, race, and merit : debating affirmative action in education and employment /');
INSERT INTO new_titles VALUES ('2000/10/11','TS1548.5 .T57 1993b','ANS-1681','Textured Yarn Association of America, inc. Technical Conference (1993 : Charlotte, N.C.)','Technical papers presented during the 1993 Winter Technical Conference of the Textured Yarn Association of America, Inc.');
INSERT INTO new_titles VALUES ('2000/10/11','TS1548.5 .T57 1997b','ANS-1644','Textured Yarn Association of America, inc. Technical Conference (1997 : Charlotte, N.C.)','Technical papers presented during the 1997 Winter Technical Conference of the Textured Yarn Association of America, Inc');
INSERT INTO new_titles VALUES ('2000/10/11','TS1548.5 .T57 1996b','ANS-1633','Textured Yarn Association of America, inc. Technical Conference (1996 : Myrtle Beach, S.C.)','Technical papers presented during the 1996 Summer Technical Conference of the Textured Yarn Association of America, Inc.');
INSERT INTO new_titles VALUES ('2000/10/11','LT5120.M37 S54 2000','ANR-0535','Shier, David.','Hole\'s essentials of human anatomy and physiology /');
INSERT INTO new_titles VALUES ('2000/10/11','TD 8.8:F 51/ENG./SPAN./KIT','ANR-7347','','First There, First Care, Stop to Help, Call for Help, Assess the Victim, Start The Breathing, Stop the Bleeding, Englis');
INSERT INTO new_titles VALUES ('2000/10/11','C 55.13/2:MNFS-NE-125','ANQ-8464','Cargnelli, Luca M.','Essential fish habitat source document.');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5339','Martin, Emily.','Premenstrual Syndrome, Work Discipline, and Anger.');
INSERT INTO new_titles VALUES ('2000/10/11','A 13.88:NE-267','ANQ-7855','Symposium on Sustainable Management of Hemlock Ecosystems in Eastern North America (1999 : Durham, N.H.)','Proceedings : Symposium on Sustainable Management of Hemlock Ecosystems in Eastern North America, June 22-24, 1999, Durh');
INSERT INTO new_titles VALUES ('2000/10/04','HD42 .L56 2000','ANY-0657','Linkemer, Bobbi.','Solving people problems /');
INSERT INTO new_titles VALUES ('2000/10/04','TK5103.2 .C66 2000','ANY-3462','','The Comprehensive guide to wireless technologies /');
INSERT INTO new_titles VALUES ('2000/10/04','T 22.2/15:10853/2000','ANX-8997','','Occupational Safety and Health Handbook, Document 10853, June 2000');
INSERT INTO new_titles VALUES ('2000/10/04','I 19.42/4:00-4041','ANX-8996','','Organochlorine Compounds in Streambed Sediment and in Biological Tissue from Streams and Their Relations to Land Use, C');
INSERT INTO new_titles VALUES ('2000/10/04','HE 20.3152:OV 1/2000','ANX-8993','','What You Need To Know About Ovarian Cancer, Revised March 2000');
INSERT INTO new_titles VALUES ('2000/10/04','HE 20.3352:M 59/2/2000','ANX-8992','','Milk Matters for Your Child\'s Health!, May 2000');
INSERT INTO new_titles VALUES ('2000/10/04','D 213.4:178','ANX-8991','','List of Active Professional Observatories, Circular No. 178, June 1, 2000');
INSERT INTO new_titles VALUES ('2000/10/04','HG4529.5 .G75 2000','ANX-7301','Grinold, Richard C.','Active portfolio management : a quantitative approach for providing superior returns and controlling risk /');
INSERT INTO new_titles VALUES ('2000/10/04','HF1002 .D477 1999','ANX-7288','','Diccionario bilinge de negocios = Bilingual business dictionary /');
INSERT INTO new_titles VALUES ('2000/10/04','HD58.6 .T56 2000','ANX-7253','Tipler, Julia, 1951-','Successful negotiating /');
INSERT INTO new_titles VALUES ('2000/10/04','HD58.8 .F85 2000','ANX-7252','Fulmer, William E.','Shaping the adaptive organization /');
INSERT INTO new_titles VALUES ('2000/10/04','ML421.W5 A9 2000','ANX-7240','Atkins, John, 1961-','The Who on record : a critical history, 1963-1998 /');
INSERT INTO new_titles VALUES ('2000/10/21','Desk File','AOE-9105','','NTR415 Croom lesson 13. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/21','Desk File','AOE-9103','','NTR415 Croom lesson 12. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/21','','AOE-9096','Gilman, Charlotte Perkins','Yellow Wallpaper');
INSERT INTO new_titles VALUES ('2000/10/21','','AOE-9094','Joravsky, David','Stalinist Mentality and the Higher Learning');
INSERT INTO new_titles VALUES ('2000/10/21','QH105.W2 W38 2001','AOE-6861','','Wetlands and urbanization : implications for the future /');
INSERT INTO new_titles VALUES ('2000/10/21','LC191.9 .S28 2000','AOE-6859','Sassower, Raphael.','A sanctuary of their own : intellectual refugees in the academy /');
INSERT INTO new_titles VALUES ('2000/10/21','QA76.575 .M83285 2001','AOE-6858','','Multimedia image and video processing /');
INSERT INTO new_titles VALUES ('2000/10/21','DT353.5.U6 C64 2000','AOE-6857','Cohen, Herman J.','Intervening in Africa : superpower peacemaking in a troubled continent /');
INSERT INTO new_titles VALUES ('2000/10/21','QA76.9.D26 D395 2001','AOE-6855','Shirai, Tetsuya.','DB2 universal database in application development environments /');
INSERT INTO new_titles VALUES ('2000/10/21','S539.7 .T69 2000','AOE-6847','','Towards an agenda for agricultural research in Europe : proceedings of a conference held in Wageningen, The Netherlands');
INSERT INTO new_titles VALUES ('2000/10/21','SB211.P8 S77 1999','AOE-6845','Struik, P. C. (Paul Christiaan), 1954-','Seed potato technology /');
INSERT INTO new_titles VALUES ('2000/10/21','D547.A8 K47 2000','AOE-6843','Kerr, Greg, 1964-','Private wars : personal records of the Anzacs in the Great War /');
INSERT INTO new_titles VALUES ('2000/10/21','PS3562.I43 F58 2000','AOE-6837','Lieberman, Laurence.','Flight from the mother stone : poems /');
INSERT INTO new_titles VALUES ('2000/10/21','PS3570.R66 F55 2000','AOE-6836','Trowbridge, William, 1941-','Flickers : poems /');
INSERT INTO new_titles VALUES ('2000/10/13','','AOE-6152','Damon, Maria.','Jazz-Jews, Jive, and Gender: The Ethnic Politics of Jazz Argot.');
INSERT INTO new_titles VALUES ('2000/10/13','','AOE-6148','Jones, Carolyn M.','Moses: Identity and Community in Exodus.');
INSERT INTO new_titles VALUES ('2000/10/13','','AOE-6146','Matlack, Glenn R.','Four Centuries of Forest Clearance and Regeneration in the Hinterland of a Large City');
INSERT INTO new_titles VALUES ('2000/10/13','LD3921 Physics. D34','AOE-6045','Dancy, Melissa Hayes, 1970-','Investigating animations for assessment with an animated version of the force concept inventory /');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.91:I-2678-G','AOE-5900','Geological Survey (U.S.)','Zangezur : satellite image map = Zangezur : obzornaia sputnikovaiia karta /');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.91:I-2678-F','AOE-5898','Geological Survey (U.S.)','Middle Araks : satellite image map = Srednee techenie r Araks : obzornaia sputnikovaiia karta /');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.91:I-2678-D','AOE-5896','Geological Survey (U.S.)','Sevan Lake : satellite image map = Ozero Sevan : obzornaia sputnikovaiia karta /');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.91:I-2678-B','AOE-5895','Geological Survey (U.S.)','Ijevan : satellite image map = Idzhevan : obzornaia sputnikovaiia karta /');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.91:I-2678-E','AOE-5894','Geological Survey (U.S.)','Karabakh : satellite image map = Karabakh : obzornaia sputnikovaiia karta /');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.91:I-2678-C','AOE-5892','Geological Survey (U.S.)','Yerevan : satellite image map = Erevan : obzornaia sputnikovaiia karta /');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.91:I-2678-A','AOE-5887','Geological Survey (U.S.)','Shirak : satellite image map = Shirak : obzornaia sputnikovaiia karta /');
INSERT INTO new_titles VALUES ('2000/10/13','P95.82.U6 C63 1992','AOE-5179','Cockburn, Alexander.','The media and the environment /');
INSERT INTO new_titles VALUES ('2000/10/13','QE364 .T73 2000','ANZ-4289','','Transformation processes in minerals /');
INSERT INTO new_titles VALUES ('2000/10/13','PN2602.B4 G74 2000','ANZ-3181','Greene, John C., 1946-','Theatre in Belfast, 1736-1800 /');
INSERT INTO new_titles VALUES ('2000/10/13','PS501 .S85 vol.44','ANZ-3179','Mihesuah, Devon A. (Devon Abbott), 1957-','The roads of my relations : stories /');
INSERT INTO new_titles VALUES ('2000/10/13','PS1018 .D69 2000','ANZ-3176','Doyle, Christine.','Louisa May Alcott & Charlotte Bront : transatlantic translations /');
INSERT INTO new_titles VALUES ('2000/10/13','T174.5 V57 2000','ANZ-3163','','Vision assessment : shaping technology in 21st century society towards a repertoire for technology assessment /');
INSERT INTO new_titles VALUES ('2000/10/13','TK7888.3 .L274 2001','ANZ-3160','Lala, Parag K., 1948-','Self-checking and fault-tolerant digital design /');
INSERT INTO new_titles VALUES ('2000/09/27','HD69.P75 H63 2000','ANX-7566','Hobbs, Peter, 1960-','Project management : the essential guide to thinking and working smarter /');
INSERT INTO new_titles VALUES ('2000/09/27','HG8051 .R44 1998','ANX-7554','Rejda, George E., 1931-','Principles of risk management and insurance /');
INSERT INTO new_titles VALUES ('2000/09/27','HC441 .Q47 1998','ANX-7544','','The quest for sustained growth : Southeast Asian and Southeast European cases /');
INSERT INTO new_titles VALUES ('2000/09/27','HD59.2 .C366 2000','ANX-7291','Carlson, Gustav.','Total exposure : controlling your company\'s image in the glare of the business media explosion /');
INSERT INTO new_titles VALUES ('2000/09/27','HF5415.5 .H24 2000','ANX-7261','Haddad, Aneace.','Using smart cards to gain market share /');
INSERT INTO new_titles VALUES ('2000/09/27','KF6425.Z9 L69 1999','ANX-7200','Lowder, Eleanor A.','403(b) plans /');
INSERT INTO new_titles VALUES ('2000/09/27','HF5415.123 .F58 2000','ANX-7152','Fitzgerald, Maureen.','Marketing communications classics : an international collection of classic and contemporary papers /');
INSERT INTO new_titles VALUES ('2000/09/27','ML102.W67 W67 1999','ANX-7145','','World music : the rough guide /');
INSERT INTO new_titles VALUES ('2000/09/27','KF3509 .C73 1999','ANX-7123','Crane, Roderick B.','Federal workplace laws affecting public-sector employee benefit programs /');
INSERT INTO new_titles VALUES ('2000/09/27','BF39 .E34 1999','ANX-6795','Edenborough, Robert.','Using psychometrics : a practical guide to testing and assessment /');
INSERT INTO new_titles VALUES ('2000/09/27','RC489.P72 G39 2000','ANX-6771','Gaylin, Willard.','Talk is not enough : how psychotherapy really works /');
INSERT INTO new_titles VALUES ('2000/09/27','DJK26 .N48 2000','ANX-6762','','The new European diasporas : national minorities and conflict in Eastern Europe /');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.88:RMRS-GTR-54','ANX-6419','','Managing for enhancement of riparian and wetland areas of the western United States an annotated bibliography /');
INSERT INTO new_titles VALUES ('2000/09/27','QC611 .H83 2000','ANX-5662','Huang, Kun, 1919-','Selected papers of Kun Huang : with commentary /');
INSERT INTO new_titles VALUES ('2000/09/27','Q172.5.C45 N66 2000','ANX-5659','International Specialist Workshop on \'Non-linear Dynamics of Electronic Systems\' (2000 : Catania, Italy)','Proceedings of the IEEE Workshop on Nonlinear Dynamics of Electronic Systems : Catania, Italy, 18-20 May 2000 /');
INSERT INTO new_titles VALUES ('2000/09/27','RA399.A1 S93 2000','ANX-5649','Swage, Thoreya.','Clinical governance in healthcare practice /');
INSERT INTO new_titles VALUES ('2000/09/27','QA76.575 .A38 2000','ANX-5645','','Advances in multimedia and databases for the new century : a Swiss/Japanese perspective : Kyoto, Japan, 30 November - 2');
INSERT INTO new_titles VALUES ('2000/09/27','F1035.A1 B36 2000','ANX-4288','Bannerji, Himani.','The dark side of the nation : essays on multiculturalism, nationalism and gender /');
INSERT INTO new_titles VALUES ('2000/09/27','F589.M657 G874 1999','ANX-4256','Gurda, John.','The making of Milwaukee /');
INSERT INTO new_titles VALUES ('2000/09/27','BR1307 .Y3613 1999','ANX-4224','Yamaji, Aizan, 1865-1917.','Essays on the modern Japanese church : Christianity in Meiji Japan /');
INSERT INTO new_titles VALUES ('2000/09/27','DS54.9 .O43 1999','ANX-4207','O\'Malley, Brendan.','The Cyprus conspiracy : America, espionage, and the Turkish invasion /');
INSERT INTO new_titles VALUES ('2000/09/27','QA76.9.O35 W45 2000','ANX-4195','Weisfeld, Matt A.','The object-oriented thought process /');
INSERT INTO new_titles VALUES ('2000/09/27','QA76.9.U83 W754 2000','ANX-4068','Wright, Peter.','Beginning GTK+/GNOME programming /');
INSERT INTO new_titles VALUES ('2000/09/27','QA76.76.H94 K39 2000','ANX-4067','Kay, Michael.','XSLT programmer\'s reference /');
INSERT INTO new_titles VALUES ('2000/09/27','QA76.73.B3 B73 2000','ANX-4064','Britt, James.','Professional Visual Basic 6 XML /');
INSERT INTO new_titles VALUES ('2000/09/27','QL690.A1 S8413 1999','ANX-4061','Svensson, Lars.','Birds of Europe /');
INSERT INTO new_titles VALUES ('2000/10/13','DK189 .R875 2000','ANZ-3158','','Russian modernity : politics, knowledge, practices /');
INSERT INTO new_titles VALUES ('2000/10/13','PS3558.A6248 S64 2000','ANZ-3093','Harper, Michael S., 1938-','Songlines in Michaeltree : new and collected poems /');
INSERT INTO new_titles VALUES ('2000/10/13','PR2983 .R39 2000','ANZ-3092','Reid, Robert Lanier, 1943-','Shakespeare\'s tragic form : spirit in the wheel /');
INSERT INTO new_titles VALUES ('2000/10/13','QA9.47 .D84 2000','ANZ-3086','Dummett, Michael A. E.','Elements of intuitionism /');
INSERT INTO new_titles VALUES ('2000/10/13','PS153.I52 H44 2000','ANZ-3085','Heflin, Ruth J.','I remain alive : the Sioux literary renaissance /');
INSERT INTO new_titles VALUES ('2000/10/13','I 53.11/4:36116-E 1-TM-100/2000','ANZ-2153','United States. Bureau of Land Management.','Nevada, California Desert District : Beatty : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/13','HD2346.O43 O44','ANZ-0675','','The OECD small and medium enterprise outlook.');
INSERT INTO new_titles VALUES ('2000/10/13','A 13.28:C 42/18','ANY-9155','United States. Forest Service. Eastern Region.','Chequamegon National Forest (Hayward-Washburn-Glidden Ranger districts) Wisconsin, 1986 /');
INSERT INTO new_titles VALUES ('2000/10/13','I 53.11/4:35117-E 1-TM-100/998','ANY-8972','United States. Bureau of Land Management.','California Desert District : Ridgecrest : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/13','QP321.5 .F86 2000','ANX-5350','','A functional view of smooth muscle /');
INSERT INTO new_titles VALUES ('2000/10/13','DA407.M37 B37 2000','ANX-4261','Barber, Sarah.','A revolutionary rogue : Henry Marten and the English Republic /');
INSERT INTO new_titles VALUES ('2000/10/13','HC800 .C255 2000','ANS-6595','','Can Africa claim the 21st century?');
INSERT INTO new_titles VALUES ('2000/10/13','A 13.150/4:','ANX-3932','','Directory of research scientists, Southern Research Station /');
INSERT INTO new_titles VALUES ('2000/10/13','Y 4.G 74/7-10:','ANS-2209','United States. Congress. House. Committee on Government Reform.','Rules of the Committee on Government Reform, House of Representatives, together with selected rules of the House of Repr');
INSERT INTO new_titles VALUES ('2000/10/13','LD3921 Chem. Eng. N5972','ANR-8757','Norman, Carnley Laurence, 1970-','Development and modeling of a biphasic countercurrent extractive column reactor using the conversion of nitrobenzene to');
INSERT INTO new_titles VALUES ('2000/10/13','LD3921 Adult Educ. M278','ANR-8749','Mabry, Christie Knittel.','Negotiating power and interests in program planning for adult education : multiple interviews with adult educators at a');
INSERT INTO new_titles VALUES ('2000/10/13','LD3921 Matls. Sci. & Eng. K358','ANR-8287','Kang, Donghun, 1967-','Field emission study on ultra-thin A1N coated Mo emitters /');
INSERT INTO new_titles VALUES ('2000/10/13','LD3921 Chem. G89','ANR-8285','Gwaltney, Kevin Payne, 1970-','Potential building blocks for improved porphyrinic molecular magnetic materials : design, synthesis and characterization');
INSERT INTO new_titles VALUES ('2000/10/13','Y 1.1/8:106-562','ANQ-6401','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 1776, the American Homeownership and Economic Opportunity Act of 2000 : report (');
INSERT INTO new_titles VALUES ('2000/10/13','Y 1.1/8:106-546','ANQ-6400','United States. Congress. House. Committee on Ways and Means.','Education Savings and School Excellence Act of 2000 : report together with dissenting views (to accompany H.R. 7) (inclu');
INSERT INTO new_titles VALUES ('2000/10/13','Y 1.1/8:106-545','ANQ-6399','United States. Congress. House. Committee on Transportation and Infrastructure.','San Gabriel Basin Water Quality Initiative : report (to accompany H.R. 910) (including cost estimate of the Congressiona');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5337','Fedigan, Linda Marie.','Is Primatology A Feminist Science?');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5334','Maines, Rachel.','Sociallly Camaflouged Technologies: The Case of the Electromechanical Vibrator.');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5332','Longino, Helen E.','Can There Be A Feminist Science?');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5328','Bleier, Ruth.','Sociobiology, Biological Determinism, and Human Behavior.');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5330','Wajcman, Judy.','The Built Environment: Women\'s Place, Gendered Space.');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5325','Kessler, Suzanne J.','The Medical Construction of Gender: Case Management of Intersexed Infants.');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5322','Keller, Evelyn Fox.','Gender and Science: An Update');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5319','Osgood, J. et al.','Cultural features of Pullen Park');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5317','Cohn, Carol.','Sex and Death in the Rational World of Defense Intellectuals.');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5304','Deerwester, J., et al.','Site analysis of Pullen Park');
INSERT INTO new_titles VALUES ('2000/10/10','TP368 .I383 1986','AOE-5111','','Ift 86 program & abstracts : 46th Annual IFT meeting : Dallas, June 15-18, 1986.');
INSERT INTO new_titles VALUES ('2000/10/10','J 21.19:G-639 (REV 6-11-99)N','AOE-4724','United States. Immigration and Naturalization Service.','Freedom of information/privacy act request.');
INSERT INTO new_titles VALUES ('2000/10/10','TD 5.4/2:10-99','AOE-4722','','Interpretations of SOLAS Chapter II-2.');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.127:025-99','AOE-4720','','Mississippi.');
INSERT INTO new_titles VALUES ('2000/10/10','TD 5.4/2:8-99','AOE-4721','','Guidance for the enforcement of the 1999 Amendments to Title 33 Code Federal Regulation (CFR) Part 151, Implementation o');
INSERT INTO new_titles VALUES ('2000/10/10','C 59.23:BE-10 A BANK','AOE-4717','','Benchmark survey of U.S. direct investment abroad, 1999.');
INSERT INTO new_titles VALUES ('2000/10/10','HH 1.2:SE 2/5','AOE-4666','HUD Secretary\'s Award for Excellence (4th : 2000 : Des Plaines, Ill.)','The HUD Secretary\'s Award for Excellence /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:34084-D 4-TF-024/997','AOE-4646','Geological Survey (U.S.)','Jasper quadrangle, Georgia : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:34084-C 6-TF-024/997','AOE-4644','Geological Survey (U.S.)','White East quadrangle, Georgia : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:31081-H 3-TF-024/997','AOE-4641','Geological Survey (U.S.)','Richmond Hill quadrangle, Georgia : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:34084-C 4-TF-024/997','AOE-4640','Geological Survey (U.S.)','Ball Ground West quadrangle, Georgia : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:33084-F 4-TF-024/997','AOE-4635','Geological Survey (U.S.)','Southwest Atlanta quadrangle, Georgia : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:30086-D 7-TF-024/994','AOE-4634','Geological Survey (U.S.)','Navarre quadrangle, Florida, 1994 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:98-440','ANP-4673','','IMPLEMENTATION OF THE CENTURY ECOSYSTEM MODEL FOR AND ERODING HILLSLOPE IN MISSISSIPPI SHARPE, JODIE, ET AL.');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:33077-H 8-TF-024/997','AOE-4632','Geological Survey (U.S.)','Kure Beach quadrangle, North Carolina : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:34077-D 5-TF-024/997','AOE-4631','Geological Survey (U.S.)','Holly Ridge quadrangle, North Carolina : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:36081-D 2-TF-024/998','AOE-4630','Geological Survey (U.S.)','Whitehead quadrangle, North Carolina, 1998 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:36076-F 5-TF-024/997','AOE-4626','Geological Survey (U.S.)','Suffolk quadrangle, Virginia--Suffolk Co. /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:39077-D 7-TF-024/994','AOE-4623','Geological Survey (U.S.)','Shepherdstown quadrangle, West Virginia--Maryland : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','L 38.20/3:','AOE-4564','Coal. Surface fatalities (Beckley, W. Va.)','Coal.');
INSERT INTO new_titles VALUES ('2000/10/10','D 5.356:56064/999','AOE-4125','United States. National Imagery and Mapping Agency.','Mediterranean Sea, Israel--Lebanon, Hefa (Haifa) and approaches /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:35089-C 8-TF-024/997','AOE-4089','Geological Survey (U.S.)','Millington quadrangle, Tennessee--Shelby Co., 1997 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:30086-E 4-TF-024/994','AOE-4086','Geological Survey (U.S.)','Niceville quadrangle, Florida, 1994 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:30086-E 5-TF-024/994','AOD-6076','Geological Survey (U.S.)','Valparaiso quadrangle, Florida--Okaloosa Co., 1994 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:30086-F 5-TF-024/994','AOD-6075','Geological Survey (U.S.)','Crestview South quadrangle, Florida--Okaloosa Co. 1994 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:34084-C 2-TF-024/993','AOD-6073','Geological Survey (U.S.)','Matt quadrangle, Georgia, 1993 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:33084-G 4-TF-024/997','AOD-6072','Geological Survey (U.S.)','Northwest Atlanta quadrangle, Georgia : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:36081-C 5-TF-024/998','AOD-6071','Geological Survey (U.S.)','Todd quadrangle, North Carolina, 1998 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:36081-D 4-TF-024/998','AOD-6069','Geological Survey (U.S.)','Jefferson quadrangle, North Carolina--Ashe Co., 1998 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:36081-B 5-TF-024/998','AOD-6067','Geological Survey (U.S.)','Deep Gap quadrangle, North Carolina, 1998 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:35089-A 7-TF-024/997','AOD-6065','Geological Survey (U.S.)','Germantown quadrangle, Tennessee--Shelby Co., 1997 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:35089-B 8-TF-024/997','AOD-6062','Geological Survey (U.S.)','Northeast Memphis quadrangle, Tennessee--Shelby Co., 1997 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:39080-F 1-TF-024/997','AOD-6059','Geological Survey (U.S.)','Osage quadrangle, West Virginia--Pennsylvania, 1997 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:39080-H 6-TF-024/997','AOD-6053','Geological Survey (U.S.)','Moundsville quadrangle, West Virginia--Ohio, 1997 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:35090-B 1-TF-024/997','AOD-6050','Geological Survey (U.S.)','Northwest Memphis quadrangle, Tennessee--Arkansas, 1997 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.81:30087-E 3-TF-024/994','AOD-6047','Geological Survey (U.S.)','West Pensacola quadrangle, Florida-Alabama, 1994 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','QA174.2 .R53 2000','AOD-5391','Ribes, Luis.','Profinite groups /');
INSERT INTO new_titles VALUES ('2000/10/10','HD9696.63.U64 M5367 2000','AOD-1217','Rivlin, Gary.','The plot to get Bill Gates : an irreverent investigation of the world\'s richest man--and the people who hate him /');
INSERT INTO new_titles VALUES ('2000/10/10','QA3 .L28 no.1738','AOC-3123','Ecole d\'t de probabilits de Saint-Flour (28th : 1998)','Lectures on probability theory and statistics : Ecole d\'t de probabilits de Saint-Flour XXVIII, 1998 /');
INSERT INTO new_titles VALUES ('2000/10/10','F1008 .T36 2000','AOC-3114','Thompson, Wayne C., 1943-','Canada 2000 /');
INSERT INTO new_titles VALUES ('2000/10/10','TE275 .W47 1999','AOB-7215','West, Terry R.','Effects of salt and trace minerals on aggregates for bituminous pavements /');
INSERT INTO new_titles VALUES ('2000/09/27','PN4071 .B37','ANX-3858','','Basic course communication annual.');
INSERT INTO new_titles VALUES ('2000/09/27','NA7205 .D44 2000','ANX-3925','Fader, Steven, 1951-','Density by design : new directions in residential development /');
INSERT INTO new_titles VALUES ('2000/09/27','D811 .T4386 2000','ANX-3660','Thamm, Gerhardt B., 1930-','Boy soldier : a German teenager at the Nazi twilight /');
INSERT INTO new_titles VALUES ('2000/09/27','[videocassette] HN65 .D375 1999','ANX-3151','','Democratic promise Saul Alinsky and his legacy /');
INSERT INTO new_titles VALUES ('2000/09/27','BF575.D35 L67 2000','ANX-0363','','Loss and trauma : general and close relationship perspectives /');
INSERT INTO new_titles VALUES ('2000/10/06','[Microfiche] E 1.38/5:','ANP-3090','','Wind power today ... wind energy program highlights.');
INSERT INTO new_titles VALUES ('2000/10/06','Y 4.AP 6/1:D 36/5/997/PT.1-','ANP-1011','United States. Congress. House. Committee on Appropriations. Subcommittee on National Security.','Department of Defense appropriations for 1997 : hearings before a subcommittee of the Committee on Appropriations, House');
INSERT INTO new_titles VALUES ('2000/10/06','HQ1061 .V54145 1999','ANO-7825','Vincent, John A., 1947-','Politics, power and old age /');
INSERT INTO new_titles VALUES ('2000/10/06','TA654.6 .E97 1998 CD-ROM','ANF-6297','European Conference on Earthquake Engineering (11th : 1998 : Paris, France)','Proceedings of the eleventh European Conference on Earthquake Engineering : 6-11 September 1998, Paris, France /');
INSERT INTO new_titles VALUES ('2000/09/27','TG24.N82 B5 2000','ANW-9698','','[Emergency bridge replacement-replace culvert on NC 87 Business at Browns Creek in Bladen County with a 130-foot bridge');
INSERT INTO new_titles VALUES ('2000/09/27','KFN7994 .A25 2000','ANW-9697','','A guide for victims of crimes /');
INSERT INTO new_titles VALUES ('2000/09/27','QK865 .C36 2000','ANW-9691','Campbell, C. Ray.','Plant tissue analysis : improving agriculture & protecting the environment /');
INSERT INTO new_titles VALUES ('2000/09/27','NA2542.4 .C58 1979','ANW-7064','','City visions');
INSERT INTO new_titles VALUES ('2000/09/27','BF723.C7 I58 1999','ANW-3547','','Investigating creativity in youth : research and methods /');
INSERT INTO new_titles VALUES ('2000/09/27','[videocassette] HV4504 .R53 1997','ANW-3274','','Riding the rails');
INSERT INTO new_titles VALUES ('2000/09/27','PR3634 .B38 1999','ANW-3392','Batey, Mavis.','Alexander Pope : the poet and the landscape /');
INSERT INTO new_titles VALUES ('2000/09/27','HC60 .T677 2000','ANS-5003','','Transforming development : foreign aid for a changing world /');
INSERT INTO new_titles VALUES ('2000/09/27','[videocassette] DS786 .S45 1990z','ANS-4006','','The shadow circus the CIA in Tibet /');
INSERT INTO new_titles VALUES ('2000/09/27','BF311 .B452 2000','ANS-3302','Bentley, Evie, 1947-','Awareness : biorhythms, sleep, and dreaming /');
INSERT INTO new_titles VALUES ('2000/09/27','TE24.N82 E34 2000','ANS-2978','','[Replacement of a two barrel box culvert with a three barrel box culvert on SR 1289 (Saint James Street) over Hendrick\'s');
INSERT INTO new_titles VALUES ('2000/09/27','TE24.N82 F6 1999d','ANS-2976','','[Pavement rehabilitation, guardrail replacement, and drainage structures improvements and updating along US-421 from I-4');
INSERT INTO new_titles VALUES ('2000/09/27','TG24.N82 E2 1999','ANS-2973','','[Emergency roadway repair, removal of bridge no. 71 on US 258 over CSX rail right of way, Edgecombe County, TIP project');
INSERT INTO new_titles VALUES ('2000/09/27','TD 2.30:00-064','ANS-2124','','Application notes LTPP findings pay off for Pennsylvania : change in pavement joint design standard saves Pennsylvania m');
INSERT INTO new_titles VALUES ('2000/09/27','I 27.79:99-11','ANS-2160','Holroyd, Edmond W.','Snow accumulation algorithm for the WSR-88D radar supplemental report /');
INSERT INTO new_titles VALUES ('2000/09/27','TD 2.30:00-052','ANS-2113','','WesTrack track roughness, fuel consumption, and maintenance costs');
INSERT INTO new_titles VALUES ('2000/09/27','TD 2.30/15:93-038/999','ANS-2123','','NEPA and the transportation decision making process participant notebook.');
INSERT INTO new_titles VALUES ('2000/09/27','QK1 .N525 vol. 84','ANS-1659','Luteyn, James L., 1948-','Pramos : a checklist of plant diversity, geographical distribuion, and botanical literature /');
INSERT INTO new_titles VALUES ('2000/09/27','QK495.A12 G68 1998','ANS-1371','Govaerts, Rafal.','World checklist and bibliography of Fagales : Betulaceae, Corylaceae, Fagaceae and Ticodendraceae /');
INSERT INTO new_titles VALUES ('2000/09/27','QK569.D54 H37 1996','ANS-1370','Hartley, B. (Bernard), 1917-','An atlas of British diatoms /');
INSERT INTO new_titles VALUES ('2000/09/27','[Microfiche] SBA 1.52:','ANR-0598','','Small business lending in the United States');
INSERT INTO new_titles VALUES ('2000/09/27','DF521 .I613 2000','ANQ-4718','Iorga, Nicolae, 1871-1940.','Byzantium after Byzantium /');
INSERT INTO new_titles VALUES ('2000/10/28','Desk Shelf','AOF-5350','Mitchell, Joan L. et al., eds.','MPEG Video Compression Standard.');
INSERT INTO new_titles VALUES ('2000/10/28','Desk Shelf','AOF-5342','Gibson, Jerry D. et al.','Digital Compression for Multimedia: Principles and Standards.');
INSERT INTO new_titles VALUES ('2000/10/28','Desk Shelf','AOF-5347','Smith, Steven W.','Scientist and Engineer\'s Guide to Digital Signal Processing..');
INSERT INTO new_titles VALUES ('2000/10/28','E185.615 .G666 2000','AOE-9281','Gordon, Jacob U.','Black leadership for social change /');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-121-128','AOF-5302','Alexander, Robert R.','Silviculture of subalpine forests in the central and southern Rocky mountains : the status of our knowledge /');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.79:RMRS-RN-6','ANE-6090','Geils, Brian W.','A preliminary hazard model of white pine blister rust for the Sacramento Ranger District, Lincoln National Forest /');
INSERT INTO new_titles VALUES ('2000/10/28','PR6011.O58 Z839 1999','AOF-5293','Royle, Nicholas.','E.M. Forster /');
INSERT INTO new_titles VALUES ('2000/10/04','KFN7530 .A25 2000','ANX-5827','North Carolina. General Assembly. Legislative Research Commission. Committee on Credit Insurance and Mortgage Credit.','Credit insurance and mortgage credit : report to the 2000 session of the 1999 General Assembly of North Carolina /');
INSERT INTO new_titles VALUES ('2000/10/04','LC3732.N8 N67 1998','ANX-5279','North Carolina. General Assembly. Joint Legislative Commission on Improving the Academic Achievement of Minority and At-Risk Students.','Commission on Improving the Academic Achievement of Minority and At-Risk Students : report to the 2000 session of the 19');
INSERT INTO new_titles VALUES ('2000/10/04','A 13.88:PNW-GTR-452','ANX-4677','Shindler, Bruce.','Monitoring and evaluating citizen-agency interactions : a framework developed for adaptive management /');
INSERT INTO new_titles VALUES ('2000/10/04','TX746 .G67 1998','ANX-4134','Gordon, David G. (David George), 1950-','The eat-a-bug cookbook /');
INSERT INTO new_titles VALUES ('2000/10/04','BX8074.H85 S58 2000','ANW-9763','Sittler, Joseph.','Evocations of grace : the writings of Joseph Sittler on ecology, theology, and ethics /');
INSERT INTO new_titles VALUES ('2000/10/04','LT4020.G57 K73 2000','ANW-8993','','Basic English.');
INSERT INTO new_titles VALUES ('2000/10/04','BX8080.J44 T75 2000','ANW-9759','','Trinity, time, and church : a response to the theology of Robert W. Jenson /');
INSERT INTO new_titles VALUES ('2000/10/04','E184.S75 H5596 2000','ANW-3282','','Hispanic Americans : a statistical sourcebook /');
INSERT INTO new_titles VALUES ('2000/10/04','[DVD] PN1995.9.E96 S46 2000','ANW-3277','','Short.');
INSERT INTO new_titles VALUES ('2000/10/04','LT4330.P73 R62 1999','ANW-2116','Roberts, Edgar V.','Writing about literature /');
INSERT INTO new_titles VALUES ('2000/10/04','LT2860.G55 G552 2000','ANR-0558','Schmitt, Conrad J.','Glencoe Spanish : buen viaje!');
INSERT INTO new_titles VALUES ('2000/10/04','TX558.S7 Y39 1996','ANR-3916','Yazici, Fehmi, 1966-','Calcium fortification of soy milk yogurt formulated to low fat plain yogurt composition /');
INSERT INTO new_titles VALUES ('2000/10/04','LT4420.S36 F62 1998 te','ANR-0555','','Focus on geometry : an integrated approach /');
INSERT INTO new_titles VALUES ('2000/10/04','LT4411.S36 F62 1998 te','ANR-0552','','Focus on advanced algebra : an integrated approach /');
INSERT INTO new_titles VALUES ('2000/10/04','FEM 1.209/33:370086/ETC./2000/V.-','ANQ-8499','','Flood insurance study Durham County, North Carolina and incorporated areas.');
INSERT INTO new_titles VALUES ('2000/10/04','DS849.C6 W358 2000','ANQ-8010','Wang, Qingxin K., 1964-','Hegemonic cooperation and conflict : postwar Japan\'s China policy and the United States /');
INSERT INTO new_titles VALUES ('2000/10/04','QA315 .W66 1994','ANE-1323','Woo, Jae Lin, 1928-','Phumoil kwan lilul wuhap peyntong haysek = Variations analysis for quality control /');
INSERT INTO new_titles VALUES ('2000/10/04','RC111 .I51282 1999','AND-7630','','Infectious diseases /');
INSERT INTO new_titles VALUES ('2000/10/04','SSA 1.2:P 29/YR/ENG/SPAN','ANB-0713','Social security, your payments while you are outside the United States. Spanish.','Seguro social, sus pagos mientras est fuera de los Estados Unidos.');
INSERT INTO new_titles VALUES ('2000/10/04','FEM 1.209/33:370158/2000/V.1-','AMQ-5709','','Flood insurance study Mecklenburg County, North Carolina, (unincorporated areas).');
INSERT INTO new_titles VALUES ('2000/10/28','N5220.A66 F68 1986','AOE-7469','Foushee, Ola Maie, 1905-','A biographical sketch of Katherine Clark Pendleton Arrington, North Carolina\'s lady of the arts /');
INSERT INTO new_titles VALUES ('2000/10/28','NX454 .S54 2000','AOE-6995','Siegel, Jonah, 1963-','Desire and excess : the nineteenth-century culture of art / Jonah Siegel.');
INSERT INTO new_titles VALUES ('2000/10/28','QA76.9.D43 S784 2000','AOE-6970','Steinberg, Louis A.','Troubleshooting with SNMP and analyzing MIBS /');
INSERT INTO new_titles VALUES ('2000/10/28','QA76.9.A25 S352 2000','AOE-6969','Schneier, Bruce, 1963-','Secrets and lies : digital security in a networked world /');
INSERT INTO new_titles VALUES ('2000/10/28','JF799 .P57 2000','AOE-6988','Pitney, John J., 1955-','The art of political warfare /');
INSERT INTO new_titles VALUES ('2000/10/28','PS3527.A15 Z659 1999','AOE-6960','Cornwell, Neil.','Vladimir Nabokov /');
INSERT INTO new_titles VALUES ('2000/10/28','DC35 .H35 2000','AOE-6968','Haine, W. Scott.','The history of France /');
INSERT INTO new_titles VALUES ('2000/10/28','QH75 .H363 2001','AOE-6967','','Handbook for restoring tidal wetlands /');
INSERT INTO new_titles VALUES ('2000/10/28','JC574 .B75 2000','AOE-6958','Brink, Bert van den.','The tragedy of liberalism : an alternative defense of a political tradition /');
INSERT INTO new_titles VALUES ('2000/10/28','DR1214 .A43 2000','AOE-6911','Allcock, John B.','Explaining Yugoslavia / John B. Allcock.');
INSERT INTO new_titles VALUES ('2000/10/28','TL867 .B85 2000','AOE-6956','Burgess, Colin, 1947-','Teacher in space : Christa McAuliffe and the Challenger legacy /');
INSERT INTO new_titles VALUES ('2000/10/28','HN981.C6 E45 2000','AOE-6955','Ellis, Frank, 1947-','Rural livelihoods and diversity in developing countries /');
INSERT INTO new_titles VALUES ('2000/10/28','QA324 .C46 2000','AOE-6909','Chazelle, B. (Bernard)','The discrepancy method : randomness and complexity /');
INSERT INTO new_titles VALUES ('2000/10/28','LC5225.L42 T39 2000','AOE-6889','Taylor, Kathleen, 1943-','Developing adult learners : strategies for teachers and trainers /');
INSERT INTO new_titles VALUES ('2000/10/28','QA76.76.H94 K48 2001','AOE-6887','Klein, Jeannine M. E.','Building enhanced HTML help with DHTML & CSS /');
INSERT INTO new_titles VALUES ('2000/10/28','QA76.76.A65 G65 2000','AOE-6888','Gomaa, Hassan.','Designing concurrent, distributed, and real-time applications with UML /');
INSERT INTO new_titles VALUES ('2000/10/28','TD461 .G68 2000','AOE-6878','Gottschalk, C. (Christiane)','Ozonation of water and waste water : a practical guide to understanding ozone and its application /');
INSERT INTO new_titles VALUES ('2000/10/28','HQ798 .M44 2000','AOE-6800','McRobbie, Angela.','Feminism and youth culture /');
INSERT INTO new_titles VALUES ('2000/10/28','TK7825 .W48 2001','AOE-6768','Whitaker, Jerry C.','The resource handbook of electronics /');
INSERT INTO new_titles VALUES ('2000/10/28','LB1738.5 .S52 2001','AOE-6761','Shapiro, Joan Poliner.','Ethical leadership and decision making in education : applying theoretical perspectives to complex dilemmas /');
INSERT INTO new_titles VALUES ('2000/10/28','RJ499 .E34 2000','AOE-6760','','The effects of early adversity on neurobehavioral development /');
INSERT INTO new_titles VALUES ('2000/10/28','DA591.A45 D468 2000','AOE-4343','Edwards, Anne, 1927-','Ever after : Diana and the life she led /');
INSERT INTO new_titles VALUES ('2000/10/28','DC33.7 .C87 2000','AOE-6758','','Currents in contemporary French intellectural life /');
INSERT INTO new_titles VALUES ('2000/10/28','BD418.3 .F627 2000','ANZ-3860','Fodor, Jerry A.','The mind doesn\'t work that way : the scope and limits of computational psychology /');
INSERT INTO new_titles VALUES ('2000/10/28','F1941.A1 S34 2000','ANZ-0439','Sag\'as, Ernesto.','Race and politics in the Dominican Republic /');
INSERT INTO new_titles VALUES ('2000/10/28','F2183 .S43 2000','ANZ-0433','','Security in the Caribbean Basin : the challenge of regional cooperation /');
INSERT INTO new_titles VALUES ('2000/10/28','D805.A2 B365 2000','ANY-9376','Bartrop, Paul R. (Paul Robert), 1955-','Surviving the camps : unity in adversity during the Holocaust /');
INSERT INTO new_titles VALUES ('2000/10/28','F547.R2 P55 2000','ANY-9415','Pirtle, Carol, 1938-','Escape betwixt two suns : a true tale of the underground railroad in Illinois /');
INSERT INTO new_titles VALUES ('2000/10/28','RC268 .S76 2000','ANY-4418','','Stopping cancer before it starts : the American Institute for Cancer Research\'s program for cancer prevention /');
INSERT INTO new_titles VALUES ('2000/09/27','TS1871 .N49 1996','ANE-4853','','New opportunities for thermoplastic elastomers : a one-day seminar : to be held at Rapra Technology Limited, Shawbury, S');
INSERT INTO new_titles VALUES ('2000/09/27','QH181 .I587 1993','AND-5082','International Workshop on the Mangrove Ecosystem of Deep Bay and the Mai Po Marshes (1993 : Hong Kong, China)','The mangrove ecosystem of Deep Bay and the Mai Po marshes, Hong Kong : proceedings of the International Workshop on the');
INSERT INTO new_titles VALUES ('2000/09/27','SF413 .M47 1999','ANA-3707','Messonnier, Shawn.','Exotic pets : essential information about the care and welfare of small pets other than cats and dogs /');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:FPL-RP-541','AMV-9969','','Efficient utilization of red maple lumber in glued-laminated timber beams');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:FPL-RP-542','AMV-5182','Alig, Joanne T.','National forests of Wisconsin : demographics and recreation participation /');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:FPL-RP-543','AMU-4492','Winandy, Jerrold E.','Roof temperatures in simulated attics');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:FPL-RP-532','AMT-9210','Hernandez, Roland.','Fiber stress values for design of glulam timber utility structures');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:FPL-RP-540','AMT-7246','Fuller, James J.','Modeling prong test response during conditioning of red oak lumber');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:FPL-RP-539','AMT-7158','Wacker, James P.','Field performance of timber bridges.');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:FPL-RP-536','AMS-7057','Ritter, Michael A.','Field performance of timber bridges.');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:FPL-RP-523','AMQ-9984','','Biopulping : a glimpse of the future? /');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:FPL-RP-533','AMP-6631','Liu, Jen Y.','Diffusion coefficient of porous solid obtained from isothermal sorption tests');
INSERT INTO new_titles VALUES ('2000/09/27','TD194.7 .E57 1995','AMP-3608','','Environmental auditing : a useful tool that can improve environmental performance and reduce costs.');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:FPL-RP-531','AMP-1815','Green, David W.','Moisture content and the properties of clear southern pine /');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:FPL-RP-527','AMO-8667','Rammer, Douglas R.','Experimental shear strength of glued-laminated beams');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:FPL-RP-491-505','ALV-5145','Boone, R. Sidney.','Kiln drying 4/4 American elm and sweetgum lumber with a combination of conventional-temperature and high-temperature sch');
INSERT INTO new_titles VALUES ('2000/09/27','I 1.98:B 38/8/v.1-2/draft','ALV-3806','','Beaufort Sea planning area : oil and gas lease sale 124 : draft environmental impact statement.');
INSERT INTO new_titles VALUES ('2000/09/27','I 1.98:Al 1 s/11/draft/v.1-2','ALP-4750','','Alaska Maritime National Wildlife Refuge : draft comprehensive conservation plan, wilderness review, and environmental i');
INSERT INTO new_titles VALUES ('2000/09/27','[Microfiche] HE 20.6210/A:','ALN-1148','','Vital statistics of the United States.');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:FPL-RP-471-490','ALM-6802','Wolfe, Ronald W.','Strength and stiffness of light-frame sloped trusses /');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:FPL-411-412, 414-445','AKO-7302','Geimer, Robert L.','Feasibility of producing reconstituted railroad ties on a commercial scale.');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/5:106-51','AKM-7764','United States. Congress. Senate. Committee on Commerce, Science, and Transportation.','Satellite Television Act of 1999 : report of the Committee on Commerce, Science, and Transportation on S. 303, together');
INSERT INTO new_titles VALUES ('2000/09/27','I 1.98:Al 5/v.1-2','AKK-8345','','Final environmental impact statement on Allen-Warner Valley energy system /');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/5:106-70','AKD-9786','United States. Congress. Senate. Committee on Environment and Public Works.','Fuels Regulatory Relief Act : report (to accompany S. 880) together with minority views (including cost estimate of the');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/5:106-71','AKD-9776','United States. Congress. Senate. Committee on Energy and Natural Resources.','Denali National Park and Preserve rescues : report (to accompany S. 698).');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/5:106-69','AKD-9775','United States. Congress. Senate. Committee on Energy and Natural Resources.','Black Canyon National Park and Gunnison National Conservation Area Act of 1999 : report (to accompany S. 323).');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/5:106-61','AKD-9691','United States. Congress. Senate. Committee on Energy and Natural Resources.','Public lands in the state of Alaska : report together with minority views (to accompany S. 744).');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/5:106-63','AKD-9662','United States. Congress. Senate. Committee on Energy and Natural Resources.','Star-Spangled Banner National Historic Trail Study Act of 1999 : report (to accompany S. 441).');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/5:106-62','AKD-9622','United States. Congress. Senate. Committee on Energy and Natural Resources.','Chattahoochee River National Recreation Area : report (to accompany S. 109).');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/5:106-67','AKD-9621','United States. Congress. Senate. Committee on Energy and Natural Resources.','Motion picture fees in national park system units : report (to accompany H.R. 154).');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/5:106-66','AKD-9587','United States. Congress. Senate. Committee on Energy and Natural Resources.','Loess Hills Preservation Study Act of 1999 : report (to accompany S. 776).');
INSERT INTO new_titles VALUES ('2000/09/27','PK2200.S27 1995','AKC-7565','Sahir Ludhiyanvi, 1921-1980.','Kulliyat-i Sahir /');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-60','AKC-1126','United States. Congress. House. Committee on Transportation and Infrastructure.','Authorizing the use of the Capitol grounds for the opening ceremonies of Sunrayce \'99 : report (to accompany H. Con. Res');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-55','AKC-1125','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 975, Reducing the Volume of Steel Imports and Establishing a Steel Import Notifi');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-33','AKC-1122','United States. Congress. House. Committee on Small Business.','Disaster Mitigation Coordination Act of 1999 : report (to accompany H.R. 818) (including cost estimate of the Congressio');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-21','AKC-1109','United States. Congress. House. Committee on Transportation and Infrastructure.','James F. Battin United States Courthouse : report (to accompany H.R. 158) (including cost estimate of the Congressional');
INSERT INTO new_titles VALUES ('2000/10/06','GA 1.2:P 43','AND-9415','United States. GAO Personnel Appeals Board.','Personnel appeals board promotions of banded employees (1991-1995) /');
INSERT INTO new_titles VALUES ('2000/10/06','Y 4.IN 2/11:S.HRG.106-239','AND-9332','United States. Congress. Senate. Committee on Indian Affairs (1993- )','Alcohol and Substance Abuse Program Consolidation Act : hearing before the Committee on Indian Affairs, United States Se');
INSERT INTO new_titles VALUES ('2000/10/06','Y 4.IN 2/11:S.HRG.106-233','AND-9331','United States. Congress. Senate. Committee on Indian Affairs (1993- )','Tribal justice systems : hearing before the Committee on Indian Affairs, United States Senate, One Hundred Sixth Congres');
INSERT INTO new_titles VALUES ('2000/10/06','Y 4.AP 6/2:S.HRG.106-221','AND-9325','','DOT AND RELATED AGENCIES APPROPRIATIONS... SENATE HRGS.... H.R. 2084/S. 1143... S. HRG. 106-221... COM. ON APPR., U.S.');
INSERT INTO new_titles VALUES ('2000/10/06','Y 4.V 64/3:106-21','AND-9324','United States. Congress. House. Committee on Veterans\' Affairs. Subcommittee on Oversight and Investigations.','Effectiveness and strategic planning of Veterans\' Employment and Training Service program : hearing before the Subcommit');
INSERT INTO new_titles VALUES ('2000/10/06','Y 3.N 88:25/5500/V.1-','ANC-7949','','Reliability study');
INSERT INTO new_titles VALUES ('2000/10/06','D 101.11:8-231','AMU-6676','','Orthopedic specialist');
INSERT INTO new_titles VALUES ('2000/10/06','Y 4.AP 6/2:S.HRG.106-238','AMY-9387','United States. Congress. Senate. Committee on Appropriations. Subcommittee on Defense.','Department of Defense appropriations for fiscal year 2000 : hearings before a subcommittee of the Committee on Appropria');
INSERT INTO new_titles VALUES ('2000/10/06','D 101.11:5-4320-306-24 P/999','AMU-6675','','Organizational, direct support, and general support maintenance repair parts and special tools list for pump unit, centr');
INSERT INTO new_titles VALUES ('2000/10/06','D 101.11:5-2805-261-23 P','AMU-6673','','Organizational and direct support maintenance repair parts and special tools list for outboard motor, gasoline, OMC mode');
INSERT INTO new_titles VALUES ('2000/10/06','D 101.11:10-3930-669-10','AMU-6671','','Operator\'s manual truck, lift, fork, clean burn diesel, front/side loading, 6,000 lb capacity, model R60SL-DC, NSN 3930-');
INSERT INTO new_titles VALUES ('2000/10/06','Y 3.N 88:25/6644','AMQ-6661','McCabe, P. H.','Generic issue 158 : performance of safety-related power-operated valves under operating conditions');
INSERT INTO new_titles VALUES ('2000/10/06','FEM 1.2:SE 5','AMQ-6659','','Seismic safety of federal and federally assisted, leased, or regulated buildings a progress report on federal agencies\'');
INSERT INTO new_titles VALUES ('2000/10/06','EP 1.2:R 31/33/997/LIST','AMQ-6654','','LIST OF LARGE QUANTITY GENERATORS IN THE UNITED STATES... THE NATIONAL BIENNIAL RCRA HAZARDOUS WASTE REPORT (BASED ON 1');
INSERT INTO new_titles VALUES ('2000/10/06','D 103.53:99/50','AMQ-6653','','STREAMLINED RELIABILITY CENTERED MAINTENANCE (RCM)... CERL TECHNCIAL REPORT 99/50... U.S. DEPARTMENT OF DEFENSE... MAY');
INSERT INTO new_titles VALUES ('2000/10/06','D 101.11:9-2350-288-20-2-4','AMQ-6651','','TECHNICAL MANUAL, UNIT MAINTENANCE MANUAL, VOLUME 4 OF 4... TM 9-2350-288-20-2-4... U.S. DEPARTMENT OF DEFENSE... AUGUS');
INSERT INTO new_titles VALUES ('2000/10/06','D 101.11:5-4930-237-10','AMQ-6649','','Operator\'s manual HEMTT tanker aviation refueling system (HTARS), NSN 4930-01-269-2273, model number 50-0051.');
INSERT INTO new_titles VALUES ('2000/10/06','C 13.58:6374','AMQ-6648','Linteris, Gregory T.','Premixed carbon monoxide-nitrous oxide-hydrogen flames measured and calculated burning velocities with and without Fe(CO');
INSERT INTO new_titles VALUES ('2000/10/05','Course Shelf','AOC-5323','','Readings for MDS302 Korte. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/05','Desk File','AOC-5321','','NTR415 Croom lesson 14. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/05','','AOC-5316','Becker, Franklin D. and Clara Mayo','Delineating Personal Distance and Territoriality');
INSERT INTO new_titles VALUES ('2000/10/05','','AOC-5318','Evans, Gary W. and Stephen J.Lepore','Household Crowding and Social Support: A Quasiexperimental Analysis');
INSERT INTO new_titles VALUES ('2000/10/05','','AOC-5314','Cook, Thomas D. and Donald T.Campbell','Causal Inference and the Language of Experimentation (Ch.1)');
INSERT INTO new_titles VALUES ('2000/10/05','','AOC-5225','Colin, Scipio A.J., III.','Marcus Garvey: Africentric Adult Education for Selfethnic Reliance.');
INSERT INTO new_titles VALUES ('2000/10/05','','AOC-5222','Peterson, Elizabeth A.','Fanny Chopin, Mary Shadd Cary, and Charlotte Grimke: Three African American Women Who Made a Difference.');
INSERT INTO new_titles VALUES ('2000/10/10','HD30.29 .N33 1998','AOB-3256','Nadler, Gerald.','Breakthrough thinking : the seven principles of creative problem solving /');
INSERT INTO new_titles VALUES ('2000/10/05','','AOC-3468','Mansfield, Katherine','Marriage a la Mode');
INSERT INTO new_titles VALUES ('2000/10/05','VA 1.55:','AOC-5204','United States. Veterans Administration. Inspector General.','Semi-annual report ... of the Inspector General : made pursuant to section 5(a), Public Law 95-452, Inspector General Ac');
INSERT INTO new_titles VALUES ('2000/10/05','','AOC-3244','Mansfield, Katherine','Man Without a Temperament');
INSERT INTO new_titles VALUES ('2000/10/05','','AOC-3328','Mansfield, Katherine','Stranger');
INSERT INTO new_titles VALUES ('2000/10/05','','AOC-3136','Andrade, Heidi G.','Using Rubrics to Promote Thinking and Learning.');
INSERT INTO new_titles VALUES ('2000/10/05','','AOC-3166','Mansfield, Katherine','Bliss');
INSERT INTO new_titles VALUES ('2000/10/05','','AOC-3132','Lindblom, Charles E.','The Science of Muddling Through.');
INSERT INTO new_titles VALUES ('2000/10/05','PRVP 42.2:B 87','AOC-2882','','Building livable communities : sustaining prosperity, improving quality of life, building a sense of community.');
INSERT INTO new_titles VALUES ('2000/10/05','','AOC-0645','Riccucci, Norma M.','Will Affirmative Action Survive into to the Twenty-First Century?');
INSERT INTO new_titles VALUES ('2000/10/05','','AOC-0647','Rabin, Jack; Thomas Vocino, W. Bartley Hildreth, and Gerald Miller.','Unit I & II');
INSERT INTO new_titles VALUES ('2000/10/05','','AOC-0643','Berkley, George and John Rouse','Administrative Law and Control');
INSERT INTO new_titles VALUES ('2000/10/05','TA417.2 .N6724 2000','ANZ-5187','','Nondestructive evaluation of highways, utilities, and pipelines IV : March 7-9, 2000, Newport Beach, USA /');
INSERT INTO new_titles VALUES ('2000/10/05','QC374 .S552 2000','ANZ-5186','','Sol-gel optics V : 16-28 January, 2000, San Jose, California /');
INSERT INTO new_titles VALUES ('2000/10/05','RC78.7.D53 I495 2000','ANZ-5185','','In-vitro diagnostic instrumentation : 26-27 January 2000, San Jose, California /');
INSERT INTO new_titles VALUES ('2000/10/05','QH585.5.L37 O68 2000','ANZ-5184','','Optical diagnostics of living cells III : 24-25 January 2000, San Jose, California /');
INSERT INTO new_titles VALUES ('2000/10/05','QH603.C95 E43 2000','ANZ-4783','','Elastic filaments of the cell /');
INSERT INTO new_titles VALUES ('2000/10/05','TK7872.P8 O68 2000','ANZ-5183','','Optical pulse and beam propagation II : 25-27 January, 2000, San Jose, California /');
INSERT INTO new_titles VALUES ('2000/10/05','SF239 .L49 1999','ANZ-4782','Lewis, Jerre G., 1937-','How to start & manage a dairy farming business : a practical way to start your own business /');
INSERT INTO new_titles VALUES ('2000/10/05','QA76.9.D5 D375 2000','ANZ-2407','DCW 2000 (2000 : Qubec, Qubec)','Distributed communities on the Web : Third International Workshop, DCW 2000, Quebec City, Quebec, Canada, June 19-21, 20');
INSERT INTO new_titles VALUES ('2000/10/05','HM467 .S75 2000','ANZ-0595','Stirk, Peter M. R., 1954-','Critical theory, politics and society : an introduction /');
INSERT INTO new_titles VALUES ('2000/10/05','TD898.2 .G46 1999','ANZ-0410','','Geological disposal of radioactive waste : review of developments in the last decade.');
INSERT INTO new_titles VALUES ('2000/10/05','HG5782 .D46 2000','ANZ-0409','Dmurger, Sylvie.','Economic opening and growth in China /');
INSERT INTO new_titles VALUES ('2000/10/05','JZ1318 .G583 2000','ANZ-0355','','Globalization and its discontents /');
INSERT INTO new_titles VALUES ('2000/10/05','TA139 .V55 1988','ANY-9505','Viterbo, Sousa, 1845-1910.','Dicionrio histrico e documental dos arquitectos, engenheiros e construtores portugueses /');
INSERT INTO new_titles VALUES ('2000/10/10','TA357.5.M84 N67 2000','ANZ-4800','North American Conference on Multiphase Technology (2nd : 1998 : Banff, Canada)','2nd North American Conference on Multiphase Technology /');
INSERT INTO new_titles VALUES ('2000/10/10','TE228.3 .K67 2000','ANZ-3963','Krogmeier, James V.','Borman Expressway point-to-point wireless modem /');
INSERT INTO new_titles VALUES ('2000/10/10','TE210 .D47 1999','ANZ-3962','Deschamps, Richard J., 1957-','Landslide remediation using unconventional methods /');
INSERT INTO new_titles VALUES ('2000/10/10','TG380 .C43 2000','ANZ-3960','Chang, Luh M.','Optical imaging method for bridge painting maintenance and inspection /');
INSERT INTO new_titles VALUES ('2000/10/10','TE228.3 .K674 2000','ANZ-3959','Krogmeier, James V.','Wireless local area network for ITS communications using the 220 MHz ITS spectral allocation /');
INSERT INTO new_titles VALUES ('2000/10/10','TE175 .M433 2000','ANZ-3958','McCullouch, Bob G.','Construction data management 2000 /');
INSERT INTO new_titles VALUES ('2000/10/10','FEM 1.2:M 69/2','ANZ-3408','','Interagency Hazard Mitigation Team report : long-term hazard mitigation alternatives and funding sources for state and l');
INSERT INTO new_titles VALUES ('2000/10/10','T 22.44/2:2053','ANZ-3407','','Quick and easy access to IRS tax help and forms.');
INSERT INTO new_titles VALUES ('2000/10/10','QA76.76.H94 G73345 2000','ANZ-3026','Graham, Ian S., 1955-','XHTML 1.0 Web development sourcebook : building better sites and applications /');
INSERT INTO new_titles VALUES ('2000/10/10','QB985 .U55 2000','ANZ-3025','','The universe : visions and perspectives /');
INSERT INTO new_titles VALUES ('2000/10/10','JK2281 .M335 2000','ANZ-3024','MacManus, Susan A.','Targeting senior voters : campaign outreach to elders and others with special needs /');
INSERT INTO new_titles VALUES ('2000/10/10','QL474 .A76 2000','ANZ-3008','Arnett, Ross H.','American insects : a handbook of the insects of America north of Mexico /');
INSERT INTO new_titles VALUES ('2000/10/10','SF996.45 .S755 2000','ANZ-2927','Stocker, Les.','Practical wildlife care : for veterinary nurses, animal care students and rehabilitators /');
INSERT INTO new_titles VALUES ('2000/10/10','TK7804 .F47 2000','ANZ-2952','Ferretti, Vittorio, 1941-','Dictionary of electronics, computing and telecommunications = Wrterbuch der Elektronik, Datentechnik und Telekommunikat');
INSERT INTO new_titles VALUES ('2000/10/10','QL696.F3 Z35 2000','ANZ-2924','Zalles, Jorje I.','Raptor watch : a global directory of raptor migration sites /');
INSERT INTO new_titles VALUES ('2000/10/10','QL737.M35 M34 2000','ANZ-2901','McCullough, Dale R., 1933-','Kangaroos in outback Australia : comparative ecology and behavior of three coexisting species /');
INSERT INTO new_titles VALUES ('2000/10/10','QL708 .W45 2000','ANZ-2911','Wilson, Don E.','Common names of mammals of the world /');
INSERT INTO new_titles VALUES ('2000/10/10','GV848.6.W65 T54 2000','ANZ-2899','Theberge, Nancy.','Higher goals : women\'s ice hockey and the politics of gender /');
INSERT INTO new_titles VALUES ('2000/10/10','GV191.42.N7 G54 2000','ANZ-2894','Gilborn, Craig A.','Adirondack camps : homes away from home, 1850-1950 /');
INSERT INTO new_titles VALUES ('2000/10/18','PS217.M67 K48 2000','ANZ-3113','Kete, Mary Louise.','Sentimental collaboration : mourning and middle-class identity in nineteenth century America /');
INSERT INTO new_titles VALUES ('2000/10/10','SF407.S97 B66 2000','ANZ-2889','Bollen, Peter J. A.','The laboratory swine /');
INSERT INTO new_titles VALUES ('2000/10/10','JA84.U5 A617 2000','ANZ-2884','Adair, Douglass.','The intellectual origins of Jeffersonian democracy : republicanism, the class struggle, and the virtuous farmer /');
INSERT INTO new_titles VALUES ('2000/10/05','NA9204.R7 R66 1979','ANY-9489','','Roma interrotta : Piero Sartogo ... [et al.] : [exhibiton organized by the Incontri internazionali d\'arte, Roma, Mercati');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:12352/2000','ANZ-2466','','Shinnecock Bay To East Rockaway Inlet, South Coast of Long Island, New York, Nautical Chart 12352, May 6, 2000');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:12281/2000','ANZ-2138','','United States - East Coast Maryland, Baltimore Harbor, 12281, May 13, 2000');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:12311/2000','ANZ-2137','','United States - East Coast, New Jersey and Delaware, Delaware River Smyrna River To Wilmington, 12311, May 6, 2000');
INSERT INTO new_titles VALUES ('2000/10/05','NA1044 .H32 1963','ANY-9487','Hautecur, Louis, 1884-1973.','Histoire de l\'architecture classique en France /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:12225/2000','ANZ-2136','','United States - East Coast, Virginia-Maryland, Chesapeake Bay, Wolf Trap To Smith Point, 12225, Loran-C, May 13, 2000');
INSERT INTO new_titles VALUES ('2000/10/10','D 5.356:52047/999','ANZ-2135','','Mediterranean Sea, Africa - Northwest Coast, Morocco - Spain, Al Hoceima, Melilla and Approaches, Scale 1:75,000, 52047');
INSERT INTO new_titles VALUES ('2000/10/10','D 5.356:51165/2000','ANZ-2134','','North Atlantic Ocean Spain-Southwest Coast, Porta of Cadiz, Base Naval De Rots and El Puerto De Santa Maria, Scale 1:15');
INSERT INTO new_titles VALUES ('2000/10/10','D 5.356:51164/2000','ANZ-2133','','North Atlantic Ocean, Southwest Coast of Spain, Chipiona To Cabo Roche, Scale 1:50,000, 51164, February 5, 2000');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:25664/2000','ANZ-2132','','West Indies, Puerto Rico - East Coast, Pasaje De Vieques and Radas Roosevelt, 25664, May 6, 2000');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:12354/2000','ANZ-2130','','United States - East Coast Connecticut - New York, Long Island Sound - Eastern Part, 12354, Loran-C, May 13, 2000');
INSERT INTO new_titles VALUES ('2000/10/10','HD30.3 .D48 1999','ANZ-0641','Devlin, Keith J.','Infosense : turning information into knowledge /');
INSERT INTO new_titles VALUES ('2000/10/10','BR305.2 .P48 2000','ANZ-0599','','The Reformation world /');
INSERT INTO new_titles VALUES ('2000/10/10','E184.S75 D36 2000','ANZ-0592','Davis, Mike, 1946-','Magical urbanism : Latinos reinvent the US city /');
INSERT INTO new_titles VALUES ('2000/10/10','B105.A35 P54 2000','ANZ-0591','Pietroski, Paul M.','Causing actions /');
INSERT INTO new_titles VALUES ('2000/10/10','HQ789 .R52 2000','ANZ-0442','','The right of the child to a clean environment /');
INSERT INTO new_titles VALUES ('2000/10/10','HQ534 .F35 2000','ANZ-0440','','Families & change : coping with stressful events and transitions /');
INSERT INTO new_titles VALUES ('2000/10/10','HD9696.C6 I543','ANZ-0414','','OECD information technology outlook.');
INSERT INTO new_titles VALUES ('2000/10/10','UF500 .B74 2000','ANZ-0393','Breuer, William B., 1923-','Secret weapons of World War II /');
INSERT INTO new_titles VALUES ('2000/10/10','JC337 .E84 2000','ANZ-0363','','The essential civil society reader : classic essays in the American civil society debate /');
INSERT INTO new_titles VALUES ('2000/10/10','HD2768.O434 P75 2000','ANZ-0056','','Privatisation, competition and regulation /');
INSERT INTO new_titles VALUES ('2000/10/10','Q172.5.S34 B37','ANZ-0061','','Basic science and technology statistics = Statistiques de base de la science et de la technologie.');
INSERT INTO new_titles VALUES ('2000/10/10','HC79.I5 T35','ANZ-0021','','Taxing wages = Les impts sur les salaires.');
INSERT INTO new_titles VALUES ('2000/10/10','HC79.I5 N393','ANZ-0013','','National accounts of OECD countries. Comptes nationaux des pays de l\'OCDE. Volume 1, Principaux agrgats.');
INSERT INTO new_titles VALUES ('2000/10/10','HC240.A1 O25','ANY-9996','','OECD historical statistics = Statistiques rtrospectives de l\'OCDE.');
INSERT INTO new_titles VALUES ('2000/10/10','DS557.7 .V56659 1999','ANY-9430','','The Vietnam war and postmodernity /');
INSERT INTO new_titles VALUES ('2000/10/10','DU178 .M645 1999','ANY-9427','Moorhouse, Geoffrey, 1931-','Sydney /');
INSERT INTO new_titles VALUES ('2000/10/10','DS736 .N47 2000','ANY-9384','','New frontiers : imperialism\'s new communities in East Asia, 1842-1953 /');
INSERT INTO new_titles VALUES ('2000/10/10','DS247.A144 B7513 1999','ANY-9375','Breton, Jean-Franois.','Arabia Felix from the time of the Queen of Sheba : eighth century B.C. to first century A.D. /');
INSERT INTO new_titles VALUES ('2000/10/10','DR48.6 .M37 2000','ANY-9360','','Masters of the universe? : NATO\'s Balkan crusade /');
INSERT INTO new_titles VALUES ('2000/10/10','DA963 .I74 2000','ANY-9369','','Ireland and the Second World War : politics, society and remembrance /');
INSERT INTO new_titles VALUES ('2000/10/10','E74.G3 P4 2000','ANY-9341','','Exploration of the Etowah site in Georgia : the Etowah papers /');
INSERT INTO new_titles VALUES ('2000/10/10','D 5.356:94082/2000','ANY-8242','','Asia, Taiwan - West Coast, Approaches To Taiwan Ports, Scale 1:100,000, 94082, February 26, 2000');
INSERT INTO new_titles VALUES ('2000/10/10','D 5.356:82349/998','ANY-8241','','South Pacific Ocean, Solomon Islands, Santa Isabel - Western Part, Scale 1:150,000, 82349, October 24, 2998');
INSERT INTO new_titles VALUES ('2000/10/10','D 5.356:74393/999','ANY-8240','','Australia - North Coast, Northern Territory, Approaches To Port Darwin, Scale 1:75,000, 74393, October 30, 1999');
INSERT INTO new_titles VALUES ('2000/10/10','D 5.356:71050/999','ANY-8238','','Indonesia - India, Great Channel, Scale 1:300,000, 71050, May 1, 1999');
INSERT INTO new_titles VALUES ('2000/10/10','D 5.356:73022/999','ANY-8239','','Indonesia, West Coast Of Irian Jaya (New Gunea) To Pulau Seram With Adjacent Islands, Scale 1:500,000, 73022, November 2');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:98-276','ANP-4672','Mueller, David K.','Quality of nutrient data from streams and ground water sampled during 1993-95 National Water-Quality Assessment Program');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-58','AKC-1101','United States. Congress. House. Committee on Transportation and Infrastructure.','Authorizing the use of the Capitol grounds for the 18th annual National Peace Officers\' Memorial Service : report (to ac');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-35','AKC-1100','United States. Congress. House. Committee on Transportation and Infrastructure.','Commercial operation of supersonic transport category aircraft : report (to accompany H.R. 661) (including cost estimate');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-42','AKC-1051','United States. Congress. House. Committee on Transportation and Infrastructure.','Federal Maritime Commission Authorization Act of 1999 : report (to accompany H.R. 819) (including cost estimate of the C');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-46','AKC-1050','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 800, the Education Flexibility Partnership Act of 1999 : report (to accompany H.');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-53','AKC-0939','United States. Congress. House. Committee on Government Reform.','Federal Reserve Board Retirement Portability Act : report (to accompany H.R. 807).');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-66','AKC-0877','United States. Congress. House. Committee on Resources.','Gateway Visitor Center Authorization Act of 1999 : report (to accompany H.R. 449) (including cost estimate of the Congre');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-54','AKC-0782','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 820, the Coast Guard Authorization Act of 1999 : report (to accompany H. Res. 11');
INSERT INTO new_titles VALUES ('2000/10/04','I 29.79/3:W 59/DRAFT','AMD-1922','United States. National Park Service.','Whitman Mission National Historic Site draft general management plan & environmental impact statement.');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-51','AKC-0781','United States. Congress. House. Committee on Transportation and Infrastructure.','Coast Guard Authorization Act of 1999 : report (to accompany H.R. 820) (including cost estimate of the Congressional Bud');
INSERT INTO new_titles VALUES ('2000/10/04','I 49.2:L 72','AMD-1921','U.S. Fish and Wildlife Service. Region 1.','Draft comprehensive conservation plan and environmental impact statement for the Little Pend Oreille National Wildlife R');
INSERT INTO new_titles VALUES ('2000/10/10','D 5.356:62405/2000','ANY-8237','','Persian Gulf United Arab Emirates, Approaches To Dubayy And Ash Shariqah, Scale 1:25,000, 62405, March 18, 2000');
INSERT INTO new_titles VALUES ('2000/10/10','D 5.356:62144/2000','ANY-8236','','Sudan, Red Sea-Western Coast, Approaches To Sawakin, Scale 1:20,000, 62144, April 15, 2000');
INSERT INTO new_titles VALUES ('2000/10/10','D 5.356:44072/2000','ANY-8235','','Germany, Approaches To Wismar, Scale 1:25,000, 44072, January 8, 2000');
INSERT INTO new_titles VALUES ('2000/10/10','D 5.356:43374/2000','ANY-8234','','Norway, OslofJorden, Approaches To Oslo, Scale 1:25,000, 43374, January 15, 2000');
INSERT INTO new_titles VALUES ('2000/10/10','QA76.58. C34 2000','ANY-7351','Calinescu, Radu C., 1968-','Architecture-independent loop parallelisation /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:11550/2000','ANY-5797','United States Coast Survey.','United States--east coast, North Carolina, Ocracoke Inlet and part of Core Sound /');
INSERT INTO new_titles VALUES ('2000/10/10','DS432.S5 S48 2000','ANY-5074','Singh, Patwant, 1925-','The Sikhs /');
INSERT INTO new_titles VALUES ('2000/10/10','NA725 .S39 2000','ANY-4785','Scott, Quinta, 1941-','Along Route 66 /');
INSERT INTO new_titles VALUES ('2000/10/10','HF5548.32 .C65 1999','ANY-4483','Columbus, Louis.','Administrator\'s guide to e-commerce : a hands-on guide to setting up systems and websites using Microsoft BackOffice /');
INSERT INTO new_titles VALUES ('2000/10/10','HF5548.32 .T74 2000','ANY-4476','Trepper, Charles H.','E-commerce strategies /');
INSERT INTO new_titles VALUES ('2000/10/10','HF5548.32 .T36 2000','ANY-4473','Tapscott, Don, 1947-','Digital capital : harnessing the power of business webs /');
INSERT INTO new_titles VALUES ('2000/10/10','HE7775 .K4 1999','ANY-4470','Keating, Stephen.','Cutthroat : high stakes & killer moves on the electronic frontier /');
INSERT INTO new_titles VALUES ('2000/10/10','HF5429 .Y47 1997','ANY-4469','Yesil, Magdalena, 1958-','Creating the virtual store : taking your web site from browsing to buying /');
INSERT INTO new_titles VALUES ('2000/10/10','HF5548.32 .S73 2000','ANY-4462','Standing, Craig.','Internet commerce development /');
INSERT INTO new_titles VALUES ('2000/10/10','HD30.37 .J82 2000','ANY-4461','Judson, Bruce.','HyperWars : eleven essential strategies for survival and profit in the era of online business /');
INSERT INTO new_titles VALUES ('2000/10/10','HF5548.32 .W47 1999','ANY-4460','Westland, J. Christopher.','Global electronic commerce : theory and case studies /');
INSERT INTO new_titles VALUES ('2000/10/13','Y 1.1/8:106-544','ANQ-6398','United States. Congress. House. Committee on Transportation and Infrastructure.','Authorizing the use of the east front of the Capitol grounds for performances sponsored by the John F. Kennedy Center fo');
INSERT INTO new_titles VALUES ('2000/10/10','HF5548.32 .K54 2000','ANY-4430','Kienan, Brenda.','Small business solutions : E-commerce /');
INSERT INTO new_titles VALUES ('2000/10/13','Y 1.1/5:106-257','ANQ-6397','United States. Congress. Senate. Committee on Foreign Relations.','The Technical Assistance, Trade Promotion, and Anti-corruption Act of 2000 : report (to accompany S. 2382).');
INSERT INTO new_titles VALUES ('2000/10/13','Y 1.1/5:106-254','ANQ-6396','United States. Congress. Senate. Committee on the Judiciary.','Crime Victims\' Rights Constitutional Amendment : report together with additional and minority views (to accompany S.J. R');
INSERT INTO new_titles VALUES ('2000/10/13','Y 1.1/7:106-221','ANQ-6395','','THE 2000 ANNUAL REPORT OF THE BOARD OF TRUSTEES OF THE..., HOUSE DOCUMENT 106-221... COMMUNICATION FROM THE FISCAL ASSI');
INSERT INTO new_titles VALUES ('2000/10/13','Y 1.1/7:106-219','ANQ-6394','','2000 ANNUAL REPORT OF THE SUPPLEMENTARY MEDICAL..., HOUSE DOCUMENT 106-219... COMMUNICATION FROM THE FISCAL ASSISTANT S');
INSERT INTO new_titles VALUES ('2000/10/13','Y 1.1/7:106-188','ANQ-6393','United States. Office of the Assistant Secretary of the Army (Civil Works)','Yuba River basin, California : communication from Assistant Secretary of the Army, transmitting a letter from the Chief');
INSERT INTO new_titles VALUES ('2000/10/13','LD3921 Oc. Educ. M43','ANQ-2426','Meek, Janis Paynter, 1949-','Relationship between principal instructional leadership and student achievement in North Carolina public elementary scho');
INSERT INTO new_titles VALUES ('2000/10/13','LD3921 Adult Educ. A537','ANP-5508','Andrews, Vikki Michelle Suggs, 1959-','African American grandparents who parent their grandchildren : is providing care a universal grandparent issue? /');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:99-350','ANP-4701','','STRATIGRAPHY, TEPHROCHRONOLOGY, AND STRUCTURAL SETTINGS OF MIOCENE SEDIMENTARY ROCKS IN THE MIDDLEGATE AREA, WEST CENTR');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:99-341','ANP-4696','','GEOCHEMISTRY OF STREAM-SEDIMENT SAMPLES FROM THE SANTA RENIA FIELDS AND BEAVER PEAK QUADRANGLES, NORTHERN CARLIN TREND,');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-68','AKB-3243','United States. Congress. House. Committee on Resources.','To direct the Secretary of the Interior to transfer to John R. and Margaret J. Lowe of Big Horn County, Wyoming, certain');
INSERT INTO new_titles VALUES ('2000/10/13','LD3921 Adult Educ. H3775','ANP-3644','Hartsell, James Leroy, 1961-','The relationship between academic advising preferences, career decidedness and certain demographic characteristics of co');
INSERT INTO new_titles VALUES ('2000/10/28','SB405.5.S68 O33 2000','ANY-3636','Odenwald, Neil G.','The bountiful flower garden : growing and sharing cut flowers in the south /');
INSERT INTO new_titles VALUES ('2000/10/28','D 214.2:D 56','ANS-2550','','Logistics mini-dictionary : provision, procure, supply, service.');
INSERT INTO new_titles VALUES ('2000/10/28','TK7887 .W46 2000','ANY-1070','Wempen, Faithe.','Tune up your PC in a weekend /');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RMRS-RP-6','AND-3529','Schreuder, Hans T.','Weighted linear regression using D2H and D2 as the independent variables');
INSERT INTO new_titles VALUES ('2000/10/28','TK5101.A1 T353','ANR-5911','','Telecommunications engineering.');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RMRS-RP-12','AND-0879','Clayton, James L. (James Lindow), 1942-','Alkalinity generation in snowmelt and rain runoff during short distance flow over rock');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RMRS-RP-11','AND-0877','Saab, Victoria A.','Responses of cavity-nesting birds to stand-replacement fire and salvage logging in Ponderosa pine/Douglas-fir forests of');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RMRS-RP-10','AND-0609','','Comparing manager and visitor perceptions of llama use in wilderness');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RMRS-RP-7','ANB-8551','Chojnacky, David C.','Double sampling for stratification a forest inventory application in the Interior West /');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RMRS-RP-8','ANB-8345','','Native woodlands and birds of South Dakota past and present /');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RMRS-RP-3','ANA-0893','Lyon, L. Jack, 1929-','Tracking elk hunters with the Global Positioning System');
INSERT INTO new_titles VALUES ('2000/10/13','I 53.11/4:31110-E 1-TM-100/999','ANP-3213','United States. Bureau of Land Management.','Arizona : Fort Huachuca : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/13','I 53.11/4:41109-A 1-TM-100/999','ANP-3199','United States. Bureau of Land Management.','Wyoming : Firehole Canyon : 1:1000,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/13','LD3921 Civil Eng. F8','ANP-3187','Fu, Joshua Sing-Yih.','Conjunctive use of air quality models for efficiently developing cost-effective ozone control strategies /');
INSERT INTO new_titles VALUES ('2000/10/13','I 53.11/4-2:38108-A 1-TM-100/999','ANP-3186','United States. Bureau of Land Management.','Colorado : Nucla : 1:100 000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/13','I 53.11/4:37103-E 1-TM-100/999','ANP-3181','United States. Bureau of Land Management.','Colorado : La Junta : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/13','I 53.11/4:38110-A 1-TM-100/998','ANP-3176','United States. Bureau of Land Management.','Utah : Hanksville : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/13','I 53.11/4-2:38110-A 1-TM-100/998','ANP-3173','United States. Bureau of Land Management.','Utah : Hanksville : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/13','I 53.11/4:47106-A 1-TM-100/999','ANP-3163','United States. Bureau of Land Management.','Montana : Jordan : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/13','Y 3.L 71:2 EQ 5/3','AND-7048','Stein, Sondra Gayle.','Equipped for the future content standards : what adults need to know and be able to do in the 21st century /');
INSERT INTO new_titles VALUES ('2000/10/13','NAS 1.21:4313','AND-7046','Dunar, Andrew J.','Power to explore : a history of Marshall Space Flight Center, 1960-1990 /');
INSERT INTO new_titles VALUES ('2000/10/13','C 55.418/7:12205/999','AND-7045','','Cape Henry To Pamlico Sound Including Albemarle Sound, Virginia - North Carolina, Nautical Chart 12205, November 1999');
INSERT INTO new_titles VALUES ('2000/10/13','I 27.27/2:','AMQ-9660','United States. Bureau of Reclamation.','The Reclamation Reform Act of 1982 annual report to the Congress.');
INSERT INTO new_titles VALUES ('2000/10/13','Y 3.EQ 2:2 IN 2/','AMM-0666','','Indicators of equal employment opportunity--status and trends /');
INSERT INTO new_titles VALUES ('2000/10/13','Y 4.G 74/7:R 86/','AMD-3636','United States. Congress. House. Committee on Government Operations.','Rules of the Committee on Government Operations, House of Representatives together with selected rules of the House of R');
INSERT INTO new_titles VALUES ('2000/10/13','I 53.11/4:44107-A 1-TM-100','ALT-5790','United States. Bureau of Land Management.','Wyoming : 1:100 000-scale topographic map : Worland : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/13','S37 .E27','AJV-1059','Research bulletin (University of Arkansas, Fayetteville. Agricultural Experiment Station)','Research bulletin /');
INSERT INTO new_titles VALUES ('2000/10/13','Mf 162 no. 11769','AJS-5177','Widmann, Martin Ludwig 1963-','Mesoscale variablilty and long-term trends of Alpine precipitation and their relation to the synoptic-scale flow /');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:99-336','ANP-4695','','GEOGRAPHIC INFORMATION SYSTEM (GIS) PROCEDURE FOR PRELIMINARY DELINEATION OF DEBRIS-FLOW HAZARD AREAS FROM A DIGITAL TE');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:99-335','ANP-4694','','DELINEATION OF BACKGROUND LABORATORY CONTAMINATION IN THE ANALYSIS OF TRACE CONCENTRATIONS OF EXTRACTABLE ORGANIC MATER');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:99-331','ANP-4693','Geological Survey (U.S.)','Preliminary geologic map of the Skull Springs quadrangle, Malheur County, Oregon');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:99-328','ANP-4691','','REGIONAL BASELINE GEOCHEMISTRY AND ENVIRONMENTAL EFFECTS OF PLACER MINING OPERATIONS ON THE FORTYMILE RIVER, EASTERN AL');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:99-327','ANP-4690','','GAS: OIL RATIONS FOR SOURCE ROCKS CONTAINING TYPE I, II, AND III KEROGENS AS DETERMINED BY HYDROUS PYROLYSIS LEWAN, MI');
INSERT INTO new_titles VALUES ('2000/10/13','HD9000.1 .A473','AJF-6416','','Agricultural policies in OECD countries.');
INSERT INTO new_titles VALUES ('2000/10/13','B20.6 .G73','AIQ-2792','','Grazer philosophische Studien.');
INSERT INTO new_titles VALUES ('2000/10/13','HD9502.P8 E53','AIS-6140','','Energy policies of IEA countries.');
INSERT INTO new_titles VALUES ('2000/10/13','HD9502.C2 E53','AIN-3697','','Energy policies of IEA countries.');
INSERT INTO new_titles VALUES ('2000/10/13','HD9698.A1 N8','AGE-4482','','Nuclear energy data /');
INSERT INTO new_titles VALUES ('2000/10/13','LB1044 .E32','AID-4017','','Educators guide to free films, filmstrips, and slides.');
INSERT INTO new_titles VALUES ('2000/10/13','HG4538 .I5355','AFR-4238','','International direct investment statistics yearbook.');
INSERT INTO new_titles VALUES ('2000/10/13','QA11.A1 U5','AFX-3240','','UMAP modules.');
INSERT INTO new_titles VALUES ('2000/10/13','HG3881 .I5','ACG-2122','International Bank for Reconstruction and Development.','The World Bank annual report');
INSERT INTO new_titles VALUES ('2000/10/13','HD5701 .O215','ACB-1902','','OECD employment outlook');
INSERT INTO new_titles VALUES ('2000/10/13','RC648.A1 C55','ACG-1593','','Endocrinology and metabolism clinics of North America');
INSERT INTO new_titles VALUES ('2000/10/13','S671 .A32','ACA-2085','','ASAE standards.');
INSERT INTO new_titles VALUES ('2000/10/13','QC1 .P391','ABY-1068','','Physica scripta.');
INSERT INTO new_titles VALUES ('2000/10/13','HF91 .O74','ABY-6053','','Foreign trade by commodities = Commerce extrieur par produits');
INSERT INTO new_titles VALUES ('2000/10/13','HG4517 .O72','ABS-6475','','Geographical distribution of financial flows to developing countries = Rpartition gographique des ressources financir');
INSERT INTO new_titles VALUES ('2000/10/13','H1 .T62','ABQ-5573','','The Tocqueville review = La Revue Tocqueville');
INSERT INTO new_titles VALUES ('2000/10/13','SB610 .W460','ABM-7929','Western Society of Weed Science (U.S.)','Research progress report - Western Society of Weed Science');
INSERT INTO new_titles VALUES ('2000/10/12','LD3921 Mech. & Aerospace Eng. D35','AOE-6049','Dale, Crystal Buchanan, 1971-','Experimental Investigation of suspended droplet evaporation in a turbulent free-stream /');
INSERT INTO new_titles VALUES ('2000/10/12','LD3921 Biomath. C689','AOE-6044','Cowell, Lindsay Grey.','Analysis of somatic hypermutation and other diversification mechanisms of the immune system /');
INSERT INTO new_titles VALUES ('2000/10/12','LD3921 Marine, Earth & Atm. Sci. D566','AOE-6043','Ding, Feng, 1966-','Large-eddy simulations of the decay of convective turbulence and the stable boundary layer /');
INSERT INTO new_titles VALUES ('2000/10/12','LD3921 Mech. & Aerospace Eng. H881','AOE-6042','Hutapea, Parsaoran, 1972-','Microstress prediction in composite laminate /');
INSERT INTO new_titles VALUES ('2000/10/12','LD3921 Vet. Medical Sciences. H4','AOE-6041','He, Fang, 1969-','Mechanism of human neutrophil elastase induced mucin hypersecretion from normal human bronchial epithelial cells in vitr');
INSERT INTO new_titles VALUES ('2000/10/12','LD3921 Vet. Medical Sciences. F86','AOE-6040','Funk, Julie Ann, 1966-','Epidemiology of Salmonella enterica in multiple site swine production systems /');
INSERT INTO new_titles VALUES ('2000/10/12','LD3921 Physiol. M34','AOE-6039','Mahmoud, Kamel (Kamel Z.), 1968-','Genetic and environmental variations of chicken heat shock proteins /');
INSERT INTO new_titles VALUES ('2000/10/12','LD3921 Soil Sci. L567','AOE-6038','Locatelli, Marlia.','Effectiveness of mycorrhizae on phosphorus uptake and nitrogen fixation of humid tropical leguminous tree seedlings in a');
INSERT INTO new_titles VALUES ('2000/10/12','LD3921 Mech. & Aerospace Eng. H37193','AOE-6037','Harwell, Karen Elizabeth, 1970-','Matching boundary layer and inviscid flowfields at hypersonic speeds /');
INSERT INTO new_titles VALUES ('2000/10/12','LD3921 For. H47','AOE-6036','Herstine, James Howard.','The North Carolina Public Beach and Coastal Waterfront Access Program under the 1974 Coastal Area Management Act (CAMA)');
INSERT INTO new_titles VALUES ('2000/10/12','I 27.1/2:','AOE-6024','United States. Bureau of Reclamation.','Statistical report of the Commissioner, Bureau of Reclamation to the Secretary of the Interior for the fiscal year ended');
INSERT INTO new_titles VALUES ('2000/10/12','I 27.1/2:','AOE-6019','United States. Bureau of Reclamation.','Summary report of the Commissioner of the Bureau of Reclamation to the Secretary of the Interior for the fiscal year end');
INSERT INTO new_titles VALUES ('2000/10/12','I 27.1/2:','AOE-6015','United States. Bureau of Reclamation.','Report of the Commissioner of the Bureau of Reclamation to the Secretary of the Interior for the fiscal year ended June');
INSERT INTO new_titles VALUES ('2000/10/12','I 27.1:','AOE-5964','United States. Bureau of Reclamation.','Annual report of the Commissioner of the Bureau of Reclamation to the Secretary of the Interior.');
INSERT INTO new_titles VALUES ('2000/10/12','I 27.1:','AOE-5963','United States. Bureau of Reclamation.','Annual report of the Commissioner of Reclamation.');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.17/1:','AOE-5959','Geological Survey (U.S.). Reclamation Service.','Annual report of the Reclamation Service /');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.17/1:','AOE-5960','United States Reclamation Service.','Annual report of the Reclamation Service.');
INSERT INTO new_titles VALUES ('2000/10/12','PREX 2.8/5:','AOE-5939','United States. Bureau of the Budget.','Special analyses, budget of the United States.');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.42/4:00-4092','AOE-5862','Tanner, Dwight Q.','The effects of calcium magnesium acetate (CMA) deicing material on the water quality of Bear Creek, Clackamas County, Or');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.81:28081-E 3-TF-024/994','AOE-5750','Geological Survey (U.S.)','Orlando East quadrangle, Florida, 1994 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','TD 1.101:','AOE-5610','United States. National Transportation Safety Board.','Annual report to Congress /');
INSERT INTO new_titles VALUES ('2000/10/12','[Microfiche] TD 1.101:','AOE-5605','United States. National Transportation Safety Board.','Annual report.');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.81:35089-A 8-TF-024/997','AOE-5526','Geological Survey (U.S.)','Southeast Memphis quadrangle, Tennessee--Shelby Co., 1997 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.81:36076-G 4-TF-024/994','AOE-5525','Geological Survey (U.S.)','Bowers Hill quadrangle, Virginia, 1994 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.81:37080-G 4-TF-024/998','AOE-5522','Geological Survey (U.S.)','Lewisburg quadrangle, West Virginia--Greenbrier Co. : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.81:37080-E 8-TF-024/998','AOE-5518','Geological Survey (U.S.)','Pipestem quadrangle, West Virginia : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.81:30087-D 4-TF-024/994','AOE-5517','Geological Survey (U.S.)','Lillian quadrangle, Alabama--Florida, 1994 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.81:35090-C 1-TF-024/997','AOE-5514','Geological Survey (U.S.)','Locke quadrangle, Tennessee--Arkansas, 1997 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.81:34077-F 4-TF-024/997','AOE-5511','Geological Survey (U.S.)','Jacksonville South quadrangle, North Carolina--Onslow Co., 1997 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.81:34084-E 2-TF-024/997','AOE-5508','Geological Survey (U.S.)','Nimblewill quadrangle, Georgia : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.81:33083-F 8-TF-024/993','AOE-5503','Geological Survey (U.S.)','Milstead quadrangle, Georgia, 1993 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.81:33081-D 8-TF-024/995','AOE-5502','Geological Survey (U.S.)','Augusta East quadrangle, Georgia--South Carolina, 1995 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.81:28082-A 1-TF-024/994','AOE-5501','Geological Survey (U.S.)','Plant City East quadrangle, Florida, 1994 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/05','NA1455.P6 Z313 1967','ANY-9482','Zachwatowicz, Jan.','Polish architecture /');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:AIMD-00-80 R','ANY-9246','United States. General Accounting Office. Accounting and Information Management Division.','GAO report on applying agreed-upon procedures federal unemployment taxes /');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:NSIAD-00-59 R','ANY-9237','United States. General Accounting Office. National Security and International Affairs Division.','Defense budget Army National Guard operation and maintenance budget /');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:NSIAD-00-66 R','ANY-9236','United States. General Accounting Office. National Security and International Affairs Division.','Contract management DOD could benefit from the use of internal recovery auditing /');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:99-326','ANP-4689','','COMPARISON OF KINETIC-MODEL PREDICTIONS OF DEEP GAS GENERATION HENRY, ALLISON A., LEWAN, MICHAEL D.');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:99-324','ANP-4687','','HEAT CAPACITY AND THERMODYNAMIC PROPERTIES OF EQUILIBRIUM SULFUR TO THE TEMPERATURE 388.36 K, AND THE HEAT CAPACITY OF');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:99-323','ANP-4686','','GEOCHEMICAL INVESTIGATIONS AND INTERIM RECOMMENDATIONS FOR PRIORITY ABANDONED MINE SITES, BLM LANDS, UPPER ANIMAS RIVER');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:99-322','ANP-4685','','ACID GENERATION AND METAL MOBILITY OF SOME METAL-MINING RELATED WASTES IN COLORADO DESBOROUGH, GEORGE, ET AL');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:99-319','ANP-4684','','MISSISSIPPI BASIN CARBON PROJECT: UPLAND SOIL DATABASE FOR SITES IN YAZOO BASIN, NORTHERN MISSISSIPPI HARDEN, JENNIFER');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:99-318','ANP-4682','','TIMING OF PALEOEARTHQUAKES ON THE NORTHERN HAYWARD FAULT - PRELIMINARY EVIDENCE IN EL CERRITO, CALIFORNIA HPEG (HAYWARD');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:99-315 A','ANP-4681','','AN ASSESSMENT OF IN-PLACE GAS RESOURCES IN THE LOW-PERMEABILITY BASIN-CENTERED GAS ACCUMULATION OF THE BIGHORN BASIN, W');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:99-314','ANP-4680','','WIDE-ANGLE SEISMIC RECORDINGS FROM THE 1998 SEISMIC HAZARDS INVESTIGATION OF PUGET SOUND (SHIPS), WESTERN WASHINGTON AN');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:99-206','ANP-4679','','WATER-RELATED SCIENTIFIC ACTIVITIES OF THE U.S. GEOLOGICAL SURVEY IN NEVADA, FISCAL YEARS 1997 AND 1998 FOGLESONG, M. T');
INSERT INTO new_titles VALUES ('2000/10/13','I 19.76:99-203','ANP-4678','','U.S. GEOLOGICAL SURVEY MIDDLE RIO GRANDE BASIN STUDY--PROCEEDINGS OF THE THIRD ANNUAL WORKSHOP, ALBUQUERQUE, NEW MEXICO');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5841','Tolkien, J.R.R.','Beowulf as a Heroic-Elegiac Poem (Ch.1,#1)');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5843','Hieatt, A.Kent','Pessimism of Many Germanic Stories (Ch.1,#4)');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5839','Heaney, Seamus, trans.','Introduction / Beowulf [Pt.2 of 2]');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5795','Tagliabue,John','Creative Web Taxes in Europe');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5797','Steinberg, Jaques','Parents Say Censoring FilmsIs Their Job, Not Politicians');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5793','Angier,Natalie','Do Races Differ? Not Really ,DNA shows');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5789','Egan,Timothy','U.S. TakesTribes\' Side on Bones');
INSERT INTO new_titles VALUES ('2000/10/29','SF395.8.A1 P67 vol. 11 1982','AOF-5463','','Swine growing-finishing units /');
INSERT INTO new_titles VALUES ('2000/10/29','SF395.8.A1 P67 vol. 61 1987','AOF-5459','Saif, Linda J.','Rotaviral diarrhea in pigs /');
INSERT INTO new_titles VALUES ('2000/10/29','SF395.8.A1 P67 vol. 22 1984','AOF-5461','Muehling, Arthur J., 1928-','Combining swine housing units into a system of buildings /');
INSERT INTO new_titles VALUES ('2000/10/18','PR179.T48 R49 2000','ANZ-3110','','Rewriting Old English in the twelfth century /');
INSERT INTO new_titles VALUES ('2000/10/18','CT275.W3299 A4 2000','ANZ-3108','Waugh, Elizabeth Dey Jenkinson, 1894-1944.','The princess with the golden hair : letters of Elizabeth Waugh to Edmund Wilson, 1933-1942 /');
INSERT INTO new_titles VALUES ('2000/10/18','PS3552.O7538 A79 2000','ANZ-3098','Borkhuis, Charles.','Alpha Ruins');
INSERT INTO new_titles VALUES ('2000/10/18','D860 .L55 2000','ANZ-3097','Lipschutz, Ronnie D.','After authority : war, peace, and global politics in the 21st century /');
INSERT INTO new_titles VALUES ('2000/10/18','PR888.M63 O97 2000','ANZ-3077','','Outside modernism : in pursuit of the English novel, 1900-30 /');
INSERT INTO new_titles VALUES ('2000/10/18','BF173 .S8454 2000','ANZ-3004','','The subject of Lacan : a Lacanian reader for psychologists /');
INSERT INTO new_titles VALUES ('2000/10/18','PN1993.5.G7 W55 2000','ANZ-3003','Williams, Tony, 1946 Jan. 11-','Structures of desire : British cinema, 1939-1955 /');
INSERT INTO new_titles VALUES ('2000/10/18','PS3523.O833 Z48 2000','ANZ-2902','Lovecraft, H. P. (Howard Phillips), 1890-1937.','Lord of a visible world : an autobiography in letters /');
INSERT INTO new_titles VALUES ('2000/10/18','BL65.P7 R45 2000','ANZ-2305','','Religion and global order /');
INSERT INTO new_titles VALUES ('2000/10/18','NA1313.G3 G38 1977','ANZ-0100','Gaud, Antoni, 1852-1926.','Antonio Gaudi = ishi no naka ni kochiku sareta kenchikuteki bijon /');
INSERT INTO new_titles VALUES ('2000/10/18','NA1173.V4 P58 1987','ANY-9499','Ploegaerts, Lon.','L\'uvre architecturale de Henry van de Velde /');
INSERT INTO new_titles VALUES ('2000/10/18','DK188.3 .Z44 2000','ANY-9368','Zeepvat, Charlotte.','Romanov autumn : stories from the last century of Imperial Russia /');
INSERT INTO new_titles VALUES ('2000/09/28','RC465.5 .P79 1999','ANZ-3769','','The traumatic bond between the psychotheraptist and managed care /');
INSERT INTO new_titles VALUES ('2000/09/28','A 13.78:FPL-RP-481','ANZ-3683','DeGroot, Rodney C.','Efficacy of alternative preservatives used in dip treatments for wood boxes /');
INSERT INTO new_titles VALUES ('2000/10/29','SF395.8.A1 P67 vol. 93 1990','AOF-5456','Meyer, Kenneth.','Slaughter checks : an aid to better herd health /');
INSERT INTO new_titles VALUES ('2000/10/29','SF395.8.A1 P67 vol. 122 1989','AOF-5457','Straw, Barbara E.','Basics of immunology /');
INSERT INTO new_titles VALUES ('2000/10/29','SF395.8.A1 P67 vol. 81 1982','AOF-5454','Hall, Robert E.','Swine coccidiosis /');
INSERT INTO new_titles VALUES ('2000/10/29','SF395.8.A1 P67 vol. 82 1988','AOF-5455','','Actinobacillus (haemophilus) pleuropneumoniae /');
INSERT INTO new_titles VALUES ('2000/10/29','','AOF-5439','Menniger, Karl.','Who is to Blame? Chapter 2.');
INSERT INTO new_titles VALUES ('2000/09/28','SF604 .T33','ANZ-3246','','Taehan Suui Hakhoe chi.');
INSERT INTO new_titles VALUES ('2000/09/28','QC174.85.P45 C47 2000','ANZ-3395','Cerf, Raphal.','Large deviations for three dimensional supercriticial percolation /');
INSERT INTO new_titles VALUES ('2000/09/29','Y 4.ED 8/1:106-93','ANX-8973','United States. Congress. House. Committee on Education and the Workforce. Subcommittee on Oversight and Investigations.','Financial management at the Department of Education : hearing before the Subcommittee on Oversight and Investigations of');
INSERT INTO new_titles VALUES ('2000/09/29','TJ163.25.D44 E54 2000','ANX-8016','','Energy services for the world\'s poor /');
INSERT INTO new_titles VALUES ('2000/09/29','HC59.15 .C656 1999','ANX-7581','Conrad, Jon M.','Resource economics /');
INSERT INTO new_titles VALUES ('2000/09/29','QH366.2 .F87 1998','ANX-8010','Futuyma, Douglas J., 1942-','Evolutionary biology /');
INSERT INTO new_titles VALUES ('2000/09/29','HG4026 .S778 1997','ANX-7552','Sulock, Joseph Michael.','Cases in financial management /');
INSERT INTO new_titles VALUES ('2000/09/28','DR479.E85 K47 2000','ANZ-2877','Khalilzad, Zalmay.','The future of Turkish-Western relations : toward a strategic plan /');
INSERT INTO new_titles VALUES ('2000/09/28','TA157 .W68 2000','ANZ-3041','','Working in Japan : an insider\'s guide for engineers and scientists /');
INSERT INTO new_titles VALUES ('2000/09/28','RB152.7 .H34 2000','ANZ-2875','Haggstrom, Gus W.','An assessment of technical issues raised in R.W. Haley\'s critique of three studies of health effects of the Gulf War /');
INSERT INTO new_titles VALUES ('2000/09/28','R834.5 .F57 2000','ANZ-2741','','First aid for the USMLE step 1 : a student to student guide, updated for 2000 /');
INSERT INTO new_titles VALUES ('2000/09/28','TA1632 .V555 2000','ANZ-2710','','Visual communications and image processing 2000 : 20-23 June, 2000, Perth, Australia /');
INSERT INTO new_titles VALUES ('2000/09/28','LD3921 Marine, Earth & Atm. Sci. T867','ANZ-2385','Turner, Heather Van Roekel, 1971-','Behavior and growth in post-copulatory female blue crabs /');
INSERT INTO new_titles VALUES ('2000/09/28','Y 4.AP 6/1:EN 2/2/2001/PT.','ANZ-2353','United States. Congress. House. Committee on Appropriations. Subcommittee on Energy and Water Development.','Energy and water development appropriations for 2001 : hearings before a subcommittee of the Committee on Appropriations');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:NSAID-00-69','ANY-9235','United States. General Accounting Office.','Depot maintenance future year estimates of public and private workloads are likely to change : report to the Chairman, S');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:NSIAD-00-100 R','ANY-9234','United States. General Accounting Office. National Security and International Affairs Division.','Defense budget fiscal years 1999 and 2000 contingency operations costs and funding /');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.13:HEHS-00-63 R','ANY-9233','United States. General Accounting Office.','Military treatment facilities emergency department utilization /');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5868','Drake, St. Clair','Rise and Fall of the Ethiopian (Twenty-fifth) Dynasty');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5866','Drake, St. Clair','Theories of Color Prejudice: A Critical Review (Ch.3)');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5862','Drake, St. Clair','Preface and Introduction');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5864','Drake, St.Clair','White Racism and the Black Experience (Ch.1)');
INSERT INTO new_titles VALUES ('2000/10/02','Desk File','ANZ-5858','','MA546//ST546 Bishir. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/02','Desk File','ANZ-5856','','NTR//ANS//FS301 Ash readings. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/02','Desk File','ANZ-5852','','ENG111 Tozcu readings. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/02','Course Shelf','ANZ-5849','','Readings for HI491U Sylla. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/02','Course Shelf','ANZ-5846','','Readings for NTR706//FS706 Odle. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5843','Shier, Harry','Adventure playgrounds : an introduction');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5841','Keaney, Brian and Bill Lucas, eds.','The outdoor classroom');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5830','Moore, Robin C. and Wendy J. Miller','Neighborhoods as childhood habitats');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5827','Mason, John','The environment of play : volume 2: where');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5823','Lambert, Jack','Adventure playgrounds : a book for playleaders');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5821','Jeavons, Mary','Opportunities lost and found');
INSERT INTO new_titles VALUES ('2000/10/02','ED 1.76:97-10','ANZ-5819','','[Action letter 1998-99, application processing system ... Action letter #1, this letter provides information & ...]');
INSERT INTO new_titles VALUES ('2000/10/02','ED 1.76/2:ANN-98-11','ANZ-5719','','[This letter announces two federal student aid training events for high school ... student financial assistance programs');
INSERT INTO new_titles VALUES ('2000/10/02','ED 1.76:98-L-202','ANZ-5657','','[On September 30, 1997, the United States Court of Appeals for the District of Columbia Circuit affirmed a District Cour');
INSERT INTO new_titles VALUES ('2000/10/02','ED 1.76:97-5','ANZ-5479','','[Office of Postsecondary Education, student financial assistance programs ... summary: distribution of the 1997 spring .');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5337','Titman, Wendy','Special places; special people');
INSERT INTO new_titles VALUES ('2000/10/02','ED 1.76:97-G-304','ANZ-5336','','[Extension of guaranty agency claims and collections report (ED form 1189) ...');
INSERT INTO new_titles VALUES ('2000/10/02','ED 1.76:GEN-98-27','ANZ-5329','','[On October 7, 1998, President Clinton signed the Higher Education Amendments of 1998 ...]');
INSERT INTO new_titles VALUES ('2000/10/02','ED 1.76:GEN-98-21','ANZ-5315','','[Dear President: I am writing to you to ask for your continued support as your financial aid office, business office, an');
INSERT INTO new_titles VALUES ('2000/10/02','ED 1.76:GEN-98-17','ANZ-5310','','[Electronic dissemination to replace many SFA mailings ... Student Financial Assistance Program]');
INSERT INTO new_titles VALUES ('2000/10/02','ED 1.76:GEN-98-16','ANZ-5303','','[This letter announces a less burdensome way for Peace Corps volunteers to apply ...]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275643','ANZ-5291','United States. General Accounting Office.','[Protest of Army sole source procurement of vehicle spare parts]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275636','ANZ-5287','United States. General Accounting Office.','[Protest of DOE CBD notice for decontamination, decommissioning, and recycling project]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275605','ANZ-5284','United States. General Accounting Office.','[Comments on transfer of claims settlement and related advance decisions, waivers, and other functions from GAO]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275596','ANZ-5275','United States. General Accounting Office.','[Protest of Army contract award for telephone and telecommunication operation and maintenance services]');
INSERT INTO new_titles VALUES ('2000/10/02','BL51 .P519 1999','ANZ-5254','Phillips, D. Z. (Dewi Zephaniah)','Recovering religious concepts : closing epistemic divides /');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275587.5','ANZ-5274','United States. General Accounting Office.','[Request for reconsideration of Air Force contract award for aircraft maintenance]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275587.9','ANZ-5253','United States. General Accounting Office.','[Protest of AF cancellation of solicitation for C-130 programmed depot-level maintenance]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275554','ANZ-5250','United States. General Accounting Office.','[Protest of VA contract award for replacement telephone system]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275427.2','ANZ-5249','United States. General Accounting Office.','[Protest of VA contract award for wheelchair van and bed van services]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275439.3','ANZ-5245','United States. General Accounting Office.','[Protest of proposed DOD corrective action pursuant to protest of contract award for shipboard audio entertainment syste');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275419','ANZ-5235','United States. General Accounting Office.','[Protests of Army contract award for rotary wing flight training services]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275334','ANZ-5234','United States. General Accounting Office.','[Protest of GSA contract award for commercial facility management services]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275332','ANZ-5229','United States. General Accounting Office.','[Protest of Army contract award for exchange or sale of aircraft]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275321','ANZ-5228','United States. General Accounting Office.','[Protest of BMDO contract award for scientific, engineering, and technical assistance services]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275319','ANZ-5224','United States. General Accounting Office.','[Protest of Navy contract award for roofing repair and replacement]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275304','ANZ-5223','United States. General Accounting Office.','[Protest of Navy rejection of bid for electrical distribution system replacement]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275303','ANZ-5214','United States. General Accounting Office.','[Protest of National Guard property and fiscal office delivery orders for moving tank targets]');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5212','Baker, Keith M.','Representation Redefined (Ch 10).');
INSERT INTO new_titles VALUES ('2000/10/10','BF575.L8 L49 2000','ANY-4416','Lewis, Thomas.','A general theory of love /');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5784','Brooke, James','A Big Push Is On For NaturalGasUnder the Arctic');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5778','Lopez,Barry','OnEntering a New Place');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5780','Stegner,Wallace','TheTown Dump');
INSERT INTO new_titles VALUES ('2000/10/11','A 13.78:PSW-112-123','AOE-5759','Heller, Robert Chester, 1918-','Evaluation of ERTS-1 data for forest and rangeland surveys /');
INSERT INTO new_titles VALUES ('2000/10/11','A 13.78:PSW-78-90','AOE-5693','Skolmen, Roger G.','Specific gravity variation in robusta eucalyptus grown in Hawaii /');
INSERT INTO new_titles VALUES ('2000/10/11','A 13.78:PSW-46-60','AOE-5656','Griffin, James R.','Soil moisture and vegetation patterns in northern California forests /');
INSERT INTO new_titles VALUES ('2000/10/11','C 55.12:P 13-1996','AOE-5640','','National winter storms operations plan /');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5642','Baumer,David','Chapter 10: Current and Future Contract Laws for E-commerce PArt II');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5637','Baumer,David','Chapter 10: Current andFuture Contract LAws forE-commerce Part I');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5632','Baumer David','Chapter 3: Intellectual Property Part I');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5635','Baumer, David','Chapter 3: Intellectual Property Part II');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5554','Kellison, Todd.','MEA 200 Lecture Notes.');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5575','Jones, Sabrina; staff writer','Manager\'s Playing Musical Chairs.');
INSERT INTO new_titles VALUES ('2000/10/11','Y 4.T 68/2:106-29','AOE-5544','United States. Congress. House. Committee on Transportation and Infrastructure. Subcommittee on Aviation.','Aviation operations during severe or rapidly changing weather conditions : hearing before the Subcommittee on Aviation o');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5530','Thelen, Esther.','The Improvising Infant: Learning about Learning to Move.');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5528','Flavell, John H. & Wohlwill, Joachim F.','Formal and Functional Aspects of Cognitive Development.');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5521','Baillargeon, Renee.','Object Permanence in 3 1/2- and 4 1/2-Month Old Infants.');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5513','McHarg, Ian L.','Natural Factors in Planning.');
INSERT INTO new_titles VALUES ('2000/10/11','D 208.109:','AOE-5426','United States Naval Academy.','Annapolis, the United States Naval Academy catalog.');
INSERT INTO new_titles VALUES ('2000/10/11','D 208.109','AOE-5506','United States Naval Academy.','Catalogue /');
INSERT INTO new_titles VALUES ('2000/10/11','NA7863.F7 L42 1950','AOE-5423','Le Corbusier, 1887-1965.','L\'unit d\'habitation de Marseille.');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5387','Tegene, Abebayehu. et al.','Dynamic Corn Supply Functions: a Model with Explicit Optimization.');
INSERT INTO new_titles VALUES ('2000/10/11','Desk File','AOE-5389','','Readings for ECG741 Lamb.[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5384','Lerner, Allan W. and John Wanat','Promulgating a Controversial Administrative Order: Administrative Law in the Making');
INSERT INTO new_titles VALUES ('2000/10/11','Course Shelf','AOE-5382','','Readings for SOC/GEO220[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5380','Franks, Emma','Women and Resistance in East Timor');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5378','Huffman, Terry','The Transculturation of Native American College Students');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5376','Harris, Marvin','India\'s Sacred Cow');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5374','Thio, Alex','The Essence of Sociology');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5370','Sharp, Ilsa','The Typical Australian');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5372','Goodwin, Paul Jr.','The Caribbean: Sea of Diversity');
INSERT INTO new_titles VALUES ('2000/10/11','','AOE-5368','Soroos, Marvin','The Climate Change Regime');
INSERT INTO new_titles VALUES ('2000/10/11','PE68.U5 T75 2000','AOE-4287','','Trends and issues in postsecondary English studies.');
INSERT INTO new_titles VALUES ('2000/10/11','TA705 .J93 2000','AOE-4122','','Judgment and innovation : the heritage and future of the geotechnical engineering profession /');
INSERT INTO new_titles VALUES ('2000/10/11','RJ506.B65 B68 2000','AOE-4091','','The borderline psychotic child : a selective integration /');
INSERT INTO new_titles VALUES ('2000/10/11','NK9504.7 .G53 1999','AOD-1218','Gibbon, Kate Fitz.','Ikat : splendid silks of Central Asia : the Guido Goldman collection /');
INSERT INTO new_titles VALUES ('2000/10/11','QD181.P9 T67 2000','AOC-3128','Topical Conference on Plutonium and Actinides (2000 : Santa Fe, N.M.)','Plutonium futures-- the science : Topical Conference on Plutonium and Actinides, Santa Fe, New Mexico, 10-13 July 2000 /');
INSERT INTO new_titles VALUES ('2000/10/11','DT3 .C87 2000','AOC-3118','Cutter, Charles Hickman, 1938-','Africa, 2000 /');
INSERT INTO new_titles VALUES ('2000/10/11','DS502 .L45 2000','AOC-3117','Leibo, Steven A., 1950-','East, Southeast Asia, and the Western Pacific, 2000 /');
INSERT INTO new_titles VALUES ('2000/10/11','DJK9 .S45 2000','AOC-3116','Shoemaker, Merle Wesley.','Russia, Eurasian States, and Eastern Europe, 2000 /');
INSERT INTO new_titles VALUES ('2000/10/11','F1408 .B83 2000','AOC-3115','','Latin America, 2000 /');
INSERT INTO new_titles VALUES ('2000/10/11','TA1637 .F89 2000','AOC-3102','','Fuzzy techniques in image processing : techniques and applications /');
INSERT INTO new_titles VALUES ('2000/10/11','QA76.65. F75 2000','AOC-2967','Friedhoff, Richard Mark.','Visual computing /');
INSERT INTO new_titles VALUES ('2000/10/11','RC582 .R67 1999','AOC-2958','Rosen, Fred S.','Case studies in immunology : a clinical companion /');
INSERT INTO new_titles VALUES ('2000/10/11','Q175 .R337 2000','AOC-2959','','The reality of the unobservable : observability, unobservability and their impact on the issue of scientific realism /');
INSERT INTO new_titles VALUES ('2000/10/11','TS932 .F67 2000','ANZ-9419','','Forest products chemistry /');
INSERT INTO new_titles VALUES ('2000/10/11','TS1120.5 .R429 2000','ANZ-9417','','Recycled fiber and deinking /');
INSERT INTO new_titles VALUES ('2000/10/11','TS1118.F5 P496 2000','ANZ-9415','','Pigment coating and surface sizing of paper /');
INSERT INTO new_titles VALUES ('2000/10/11','TP1183.L3 P58 2000','ANZ-9414','Plastic Laminates Symposium (2000 : Atlanta, Ga.)','2000 TAPPI Plastic Laminates Symposium : August 21-23, 2000, Hyatt Regency, Atlanta, GA.');
INSERT INTO new_titles VALUES ('2000/10/11','TP967 .H68 2000','ANZ-9411','Hot Melt Symposium (2000 : Bal Harbour, Fla.)','2000 Hot Melt Symposium : June 25-28, 2000, Sheraton Bal Harbour, Bal Harbour, FL.');
INSERT INTO new_titles VALUES ('2000/10/11','TS1118.F5 M47 2000','ANZ-9408','Metered Size Press Forum (3rd : 2000 : Washington, D.C.)','2000 TAPPI Metered Size Press Forum III : April 27-29, 2000, Renaissance Hotel, Washington, D.C.');
INSERT INTO new_titles VALUES ('2000/10/11','TS155.6 .I55 2000','ANZ-4795','International Conference on Computer-Aided Production Engineering (16th : 1995 : Edinburgh, Scotland)','16th International Conference on Computer-Aided Production Engineering : CAPE 2000 ; 7-9 August 2000 /');
INSERT INTO new_titles VALUES ('2000/10/11','HB849.53 .N385 2000','ANZ-3198','National Research Council (U.S.)','Beyond six billion : forecasting the world\'s population /');
INSERT INTO new_titles VALUES ('2000/10/11','TK5105.7 .T78 2000','ANZ-3017','Trulove, James.','LAN wiring : an illustrated network cabling guide /');
INSERT INTO new_titles VALUES ('2000/10/11','HC430.E5 H6 2000','ANZ-3023','Ho, Sam P. S.','Sustainable economic development in South China /');
INSERT INTO new_titles VALUES ('2000/10/11','LC3746 .I6 2000','ANZ-3015','','Immigrant voices : in search of educational equity /');
INSERT INTO new_titles VALUES ('2000/10/11','LC225.3 .L37 2000','ANZ-3014','Lareau, Annette.','Home advantage : social class and parental intervention in elementary education /');
INSERT INTO new_titles VALUES ('2000/10/11','HV6028 .L45 2000','ANZ-3011','Lemert, Edwin McCarthy, 1912-','Crime and deviance : essays and innovations of Edwin M. Lemert /');
INSERT INTO new_titles VALUES ('2000/10/11','E183.8.P6 B57 2000','ANZ-3010','Blitz, Amy, 1961-','The contested state : American foreign policy and regime change in the Philippines /');
INSERT INTO new_titles VALUES ('2000/10/11','HM758 .A87 2000','ANZ-3009','','Autonomy and order : a communitarian anthology /');
INSERT INTO new_titles VALUES ('2000/10/11','SB608.R5 A38 1998','ANZ-3007','','Advances in rice blast research : proceedings of the 2nd international Rice Blast Conference 4-8 August 1998, Montpellie');
INSERT INTO new_titles VALUES ('2000/10/11','HT1321 .L68 2000','ANZ-3006','Lovejoy, Paul E.','Transformations in slavery : a history of slavery in Africa /');
INSERT INTO new_titles VALUES ('2000/10/11','E449 .R5135 2000','ANZ-3002','Richards, Leonard L.','The slave power : the free North and southern domination, 1780-1860 /');
INSERT INTO new_titles VALUES ('2000/10/11','PN1995.9.H55 K89 2000','ANZ-3001','Kuzniar, Alice A.','The queer German cinema /');
INSERT INTO new_titles VALUES ('2000/10/11','AZ103 .H69 2000','ANZ-2995','Hyrup, Jens.','Human sciences : reappraising the humanities through history and philosophy / Jens Hyrup.');
INSERT INTO new_titles VALUES ('2000/10/11','PR418.S64 M38 2000','ANZ-2993','Matz, Robert.','Defending literature in early modern England : Renaissance literary theory in social context /');
INSERT INTO new_titles VALUES ('2000/10/11','CB204 .B87 2000','ANZ-2992','Burrow, J. W. (John Wyon), 1935-','The crisis of reason : European thought, 1848-1914 /');
INSERT INTO new_titles VALUES ('2000/10/11','E302.6.F8 B454 2000','ANZ-2989','','Benjamin Franklin and women /');
INSERT INTO new_titles VALUES ('2000/10/11','TK5102.92. V83 2000','ANZ-2986','Vucetic, Branka.','Turbo codes : principles and applications /');
INSERT INTO new_titles VALUES ('2000/10/11','QP535.O1 E24 2001','ANZ-2982','Eberhardt, Manfred K.','Reactive oxygen metabolites : chemistry and medical consequences /');
INSERT INTO new_titles VALUES ('2000/10/11','PN56.5.W64 N37 2000','ANZ-2978','','Nature, woman, and the art of politics /');
INSERT INTO new_titles VALUES ('2000/10/11','QA76.76.H94 S57 2001','ANZ-2977','Simpson, John E.','Just XML /');
INSERT INTO new_titles VALUES ('2000/10/11','H61.8 .W543 2000','ANZ-2975','Willinsky, John, 1950-','If only we knew : increasing the public value of social-science research /');
INSERT INTO new_titles VALUES ('2000/10/11','GN281.4 .E374 2000','ANZ-2974','Ehrlich, Paul R.','Human natures : genes, cultures, and the human prospect /');
INSERT INTO new_titles VALUES ('2000/10/11','TA450 .C87 2000','ANZ-2972','Curran, James Michael.','Forensic interpretation of glass evidence /');
INSERT INTO new_titles VALUES ('2000/10/11','QA246 .U73 2000','ANZ-2971','Urbanowicz, Jerzy, 1951-','Congruences for L-functions /');
INSERT INTO new_titles VALUES ('2000/10/11','TA455.P5 S39 2000','ANZ-2970','Scott, Derick Vernon.','Advanced materials for water handling : composites and thermoplastics /');
INSERT INTO new_titles VALUES ('2000/10/11','PN4749 .P83 2000','ANZ-2965','','Public journalism and political knowledge /');
INSERT INTO new_titles VALUES ('2000/10/11','TA1634 .P48 2000','ANZ-2964','','Performance characterization in computer vision /');
INSERT INTO new_titles VALUES ('2000/10/11','T55 .N53 2000','ANZ-2963','Noble, Michael T.','Organizational mastery with integrated management systems : controlling the dragon : a manager\'s tool box for enhancing');
INSERT INTO new_titles VALUES ('2000/10/11','QA808 .N38 2000','ANZ-2962','Nayfeh, Ali Hasan, 1933-','Nonlinear interactions : analytical, computational, and experimental methods /');
INSERT INTO new_titles VALUES ('2000/10/11','QC176.8.M46 C47 2000','ANZ-2960','Chow, Tsu-sen.','Mesoscopic physics of complex materials /');
INSERT INTO new_titles VALUES ('2000/10/11','PR468.H57 C35 2000','ANZ-2959','Campbell, Matthew (Matthew J. B.)','Memory and memorials, 1789-1914 : literary and cultural perspectives /');
INSERT INTO new_titles VALUES ('2000/10/11','TA1677 .L3622 2000','ANZ-2958','','Laser beam shaping : theory and techniques /');
INSERT INTO new_titles VALUES ('2000/10/11','QA76.76.C66 B76 2000','ANZ-2957','Brown, Alan W., 1962-','Large-scale, component-based development /');
INSERT INTO new_titles VALUES ('2000/10/11','QD341.H9 F35 2000','ANZ-2956','Fetzer, John.','Large (C>=24) polycyclic aromatic hydrocarbons : chemistry and analysis /');
INSERT INTO new_titles VALUES ('2000/10/11','QA76.9.D43 M38 2000','ANZ-2951','McKay, Everett N., 1961-','Debugging Windows programs : strategies, tools, and techniques for Visual C++ programmers /');
INSERT INTO new_titles VALUES ('2000/10/11','PA3003 .L54 2000','ANZ-2938','','Literature in the Greek and Roman worlds : a new perspective /');
INSERT INTO new_titles VALUES ('2000/10/11','TN270 .P3344 2000','ANZ-2936','Pan, Guocheng.','Information synthesis for mineral exploration /');
INSERT INTO new_titles VALUES ('2000/10/11','GV714.5 .S65 2000','ANZ-2934','Spindel, Carol.','Dancing at halftime : sports and the controversy over American Indian mascots /');
INSERT INTO new_titles VALUES ('2000/10/11','DD86 .C73 2000','ANZ-2932','Crane, Susan A.','Collecting and historical consciousness in early nineteenth-century Germany /');
INSERT INTO new_titles VALUES ('2000/10/11','DP66 .S63 2000','ANZ-2926','','Spain : a history /');
INSERT INTO new_titles VALUES ('2000/10/11','QH31.B8925 S53 2000','ANZ-2925','','Sharp eyes : John Burroughs and American nature writing /');
INSERT INTO new_titles VALUES ('2000/10/11','JC573.B7 P68 2000','ANZ-2922','Power, Timothy J. (Timothy Joseph), 1962-','The political right in postauthoritarian Brazil : elites, institutions, and democratization /');
INSERT INTO new_titles VALUES ('2000/10/11','PS3569.T33938 P56 2000','ANZ-2921','Stegner, Lynn.','Pipers at the gates of dawn : a triptych /');
INSERT INTO new_titles VALUES ('2000/10/11','HQ796 .C458237 2000','ANZ-2920','Childress, Herb, 1958-','Landscapes of betrayal, landscapes of joy : Curtisville in the lives of its teenagers /');
INSERT INTO new_titles VALUES ('2000/10/11','P301 .K48 2000','ANZ-2919','','The Kinneavy papers : theory and the study of discourse /');
INSERT INTO new_titles VALUES ('2000/10/11','DC33.9 .F76 2000','ANZ-2917','','French cultural studies : criticism at the crossroads /');
INSERT INTO new_titles VALUES ('2000/10/11','PS3562.I51127 D36 2000','ANZ-2913','Lindisfarne, Nancy, 1944-','Dancing in Damascus : stories /');
INSERT INTO new_titles VALUES ('2000/10/11','D790 .B686 2000','ANZ-2908','Brulle, Robert V.','Angels zero : P-47 close air support in Europe /');
INSERT INTO new_titles VALUES ('2000/10/11','HX83 .L54 2000','ANZ-2906','Lieberman, Robbie, 1954-','The strangest dream : communism, anticommunism and the U.S. peace movement 1945-1963 /');
INSERT INTO new_titles VALUES ('2000/10/11','LA212 .R42 2000','ANZ-2905','','Reconstructing the common good in education : coping with intractable American dilemmas /');
INSERT INTO new_titles VALUES ('2000/10/11','E92 .R87 2000','ANZ-2904','Russell, Dan, 1950-','A people\'s dream : Aboriginal self-government in Canada /');
INSERT INTO new_titles VALUES ('2000/10/11','TP248.65.F66 M37 2000','ANZ-2903','McHughen, Alan.','Pandora\'s picnic basket : the potential and hazards of genetically modified foods /');
INSERT INTO new_titles VALUES ('2000/10/11','D15.B8 H56 2000','ANZ-2900','Hinde, John Roderick, 1964-','Jacob Burckhardt and the crisis of modernity /');
INSERT INTO new_titles VALUES ('2000/10/11','PQ2191.Z5 D23 2000','ANZ-2898','DalMolin, Eliane Franoise.','Cutting the body : representing woman in Baudelaire\'s poetry, Truffaut\'s cinema, and Freud\'s psychoanalysis /');
INSERT INTO new_titles VALUES ('2000/10/11','BF311 .C5477 2000','ANZ-2896','','Cognition and emotion /');
INSERT INTO new_titles VALUES ('2000/10/11','DS559.83.W18 M67 2000','ANZ-2895','Morrissey, Thomas F.','Between the lines : photographs from the National Vietnam Veterans Memorial /');
INSERT INTO new_titles VALUES ('2000/10/11','LB17 .R68 2000','ANZ-2892','','Routledge international companion to education /');
INSERT INTO new_titles VALUES ('2000/10/11','QA76.76.D47 J348 2000','ANZ-2891','Jacobson, Ivar.','The road to the unified software development process /');
INSERT INTO new_titles VALUES ('2000/10/11','TA418.9.C6 I555 2000','ANZ-2888','','Integrated design and manufacture using fibre-reinforced polymeric composites /');
INSERT INTO new_titles VALUES ('2000/10/11','QP88.15 .A45 1999','ANZ-2885','Steenbock Symposium (27th : 1999 : Madison, Wis.)','Adipocyte biology and hormone signaling /');
INSERT INTO new_titles VALUES ('2000/10/11','DS480.853 .J39 2000','ANZ-0590','Jayapal, Pramila, 1965-','Pilgrimage : one woman\'s return to a changing India /');
INSERT INTO new_titles VALUES ('2000/10/11','JZ1480 .M67 2000','ANZ-0362','Mosler, David, 1941-','Global America : imposing liberalism on a recalcitrant world /');
INSERT INTO new_titles VALUES ('2000/10/11','NA1053.G3 T33 1978','ANY-9500','Tadgell, Christopher, 1939-','Ange-Jacques Gabriel /');
INSERT INTO new_titles VALUES ('2000/10/11','F614.S4 V35 2000','ANY-9434','Valds, Dennis Nodn.','Barrios norteos : St. Paul and midwestern Mexican communities in the twentieth century /');
INSERT INTO new_titles VALUES ('2000/10/11','DA405 .B343 2000','ANY-9433','Bennett, Martyn.','The civil wars experienced : Britain and Ireland, 1638-1661 /');
INSERT INTO new_titles VALUES ('2000/10/11','DS339 .I54 2000','ANY-9414','Inden, Ronald B.','Querying the medieval : texts and the history of practices in South Asia /');
INSERT INTO new_titles VALUES ('2000/10/11','E464 .N65 2000','ANY-9413','Nolan, Alan T.','\"Rally, once again!\" : selected Civil War writings of Alan T. Nolan.');
INSERT INTO new_titles VALUES ('2000/10/11','DT1738.M87 A3 1997','ANY-9403','Murphy, Dervla, 1931-','South from the Limpopo : travels through South Africa /');
INSERT INTO new_titles VALUES ('2000/10/11','F3429 .S275 2000','ANY-9391','Saunders, Nicholas J.','The Incas /');
INSERT INTO new_titles VALUES ('2000/10/11','DC101.5.A2 H53 2000','ANY-9389','Hibbert, Christopher, 1924-','Agincourt /');
INSERT INTO new_titles VALUES ('2000/10/11','DS775.7 .G74 2000','ANY-9387','Gregor, A. James (Anthony James), 1929-','A place in the sun : Marxism and Fascism in China\'s long revolution /');
INSERT INTO new_titles VALUES ('2000/10/11','DS849.S65 J36 2000','ANY-9380','','Japan and Russia : the tortuous path to normalization, 1949-1999 /');
INSERT INTO new_titles VALUES ('2000/10/11','DT1896 .V36 2000','ANY-9370','Van Hartesveldt, Fred R.','The Boer War /');
INSERT INTO new_titles VALUES ('2000/10/11','F1021 .F75 2000','ANY-9363','Friesen, Gerald, 1943-','Citizens and nation : an essay on history, communication, and Canada /');
INSERT INTO new_titles VALUES ('2000/10/11','DP517 .L35 2000','ANY-9362','Laidlar, John.','Portugal /');
INSERT INTO new_titles VALUES ('2000/10/11','DC137 .H373 2000','ANY-9361','Hardman, John.','Louis XVI : the silent king /');
INSERT INTO new_titles VALUES ('2000/10/11','E547.P5 H3 2000','ANY-9348','Harrison, Walter.','Pickett\'s men : a fragment of war history /');
INSERT INTO new_titles VALUES ('2000/10/18','D769 .T42 2000','ANY-9333','Takaki, Ronald T., 1939-','Double victory : a multicultural history of America in World War II /');
INSERT INTO new_titles VALUES ('2000/10/18','Y 1.1/7:106-236','ANY-9126','United States. President (1993- : Clinton)','Notification of supply delivery to Sierra Leone : communication from the President of the United States transmitting not');
INSERT INTO new_titles VALUES ('2000/10/18','Y 1.1/7:106-235','ANY-9125','United States. President (1993- : Clinton)','Consumer Product Safety Commission Enhanced Enforcement Act of 2000 : message from the President of the United States tr');
INSERT INTO new_titles VALUES ('2000/10/18','Y 1.1/7:106-243','ANY-9096','Korea (South)','Agreement with Korea on Social Security : message from the President of the United States transmitting an Agreement betw');
INSERT INTO new_titles VALUES ('2000/10/18','Y 1.1/7:106-247','ANY-9091','United States. President (1993- : Clinton)','Periodic report on the Cyprus question : communication from the President of the United States transmitting progress tow');
INSERT INTO new_titles VALUES ('2000/10/18','QR201.R67 R67 2000','ANY-5014','','Rotaviruses : methods and protocols /');
INSERT INTO new_titles VALUES ('2000/10/18','Y 1.1/7:106-214','ANY-8985','United States.','The Constitution of the United States of America as amended : unratified amendments, analytical index /');
INSERT INTO new_titles VALUES ('2000/10/18','NA2440.C56 C66 1991','ANY-1904','Robinson, Sidney K., 1943-','The continuous present of organic architecture /');
INSERT INTO new_titles VALUES ('2000/10/18','TX773 .H44 1998','ANY-1631','Herm, Pierre.','Desserts by Pierre Herm /');
INSERT INTO new_titles VALUES ('2000/10/18','QA76.73.C153 G875 1997','ANY-1639','Gurewich, Ori.','Teach yourself Visual C++ 5 in 21 days /');
INSERT INTO new_titles VALUES ('2000/10/18','QH642 .T83 2000','ANY-1565','Tuchin, V. (Valerii)','Tissue optics : light scattering methods and instruments for medical diagnosis /');
INSERT INTO new_titles VALUES ('2000/10/18','PS3535.A547 Z9 2000','ANY-1077','Torres, Louis, 1938-','What art is : the esthetic theory of Ayn Rand /');
INSERT INTO new_titles VALUES ('2000/10/18','QA76.6 .W45 1998','ANY-1045','Weinberg, Gerald M.','The psychology of computer programming /');
INSERT INTO new_titles VALUES ('2000/10/18','TK7882.S3 D36 1997','ANY-1039','Day, Jerry B.','Color scanning handbook : your guide to Hewlett-Packard ScanJet color scanners /');
INSERT INTO new_titles VALUES ('2000/10/18','TA157 .H24 1997','ANY-0924','Hagerty, D. Joseph.','Opportunities in civil engineering careers /');
INSERT INTO new_titles VALUES ('2000/10/18','RM854 .L47 2000','ANX-2281','','Lessons learned from accidental exposures in radiotherapy /');
INSERT INTO new_titles VALUES ('2000/10/18','QH506 .A88 1999','ANX-7316','Attwood, Teresa K.','Introduction to bioinformatics /');
INSERT INTO new_titles VALUES ('2000/10/18','PR6052.A849 M36 2000','ANW-9772','Baxter, Stephen.','Manifold : time /');
INSERT INTO new_titles VALUES ('2000/10/18','QC795.32.R3 I44 2000','ANX-2280','','Indirect methods for assessing intakes of radionuclides causing occupational exposure /');
INSERT INTO new_titles VALUES ('2000/10/18','PS3558.A626 G38 2000','ANW-9768','Harrigan, Stephen, 1948-','The gates of the Alamo : a novel /');
INSERT INTO new_titles VALUES ('2000/10/18','EP 2.8:C 82/3','ANW-8513','','Cost-effectiveness analysis for the final action regarding pretreatment standards for the industrial laundries point sou');
INSERT INTO new_titles VALUES ('2000/10/18','HE 20.3302:R 31/4','ANW-8512','National Institute of Diabetes and Digestive and Kidney Diseases (U.S.)','National Institute of Diabetes and Digestive and Kidney Diseases research progress reviews for FY 2000 program plan /');
INSERT INTO new_titles VALUES ('2000/10/18','HE 20.3002:R 11/9','ANW-8511','','Uncertainties in radiation dosimetry and their impact on dose-response analyses');
INSERT INTO new_titles VALUES ('2000/10/18','EP 4.8:SU 7/3/999','ANW-8510','','The Sun, UV and you a guide to sunwise behavior.');
INSERT INTO new_titles VALUES ('2000/10/18','EP 4.2:SE 4/SPAN.','ANW-8509','','BOLETIN TECNICO... SELECCIONANDO UN SISTEMA DE ADSORCION PARA COV: CARBON, ZEOLITA, O POLIMEROS... U.S. ENVIRONMENTAL P');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5206','Baker, Keith M.','Inventing the French Revolution (Ch 9).');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275213','ANZ-5211','United States. General Accounting Office.','[Protest of Army contract award for mortar inner containers]');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5205','Perkins, Douglas D.','Physical Environment of Street Blocks and Resident Perceptions of Crime and Disorder: Implications for Theory and Measur');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275209','ANZ-5203','United States. General Accounting Office.','[Protest of Forest Service contract award for environmental impact statement services]');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5199','Skinner, Quentin.','Meaning and Understanding in the History of Ideas.');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275193','ANZ-5198','United States. General Accounting Office.','[Protest of DFSC solicitation for bulk fuel]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275185','ANZ-5197','United States. General Accounting Office.','[Protest of PCC contract award for signal station cab]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275181','ANZ-5191','United States. General Accounting Office.','[Protest of HHS contract award for adoption information clearinghouse operation and management]');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5190','Stromberg, Roland.','Some Models Used by Intellectual Historians.');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275180.2','ANZ-5189','United States. General Accounting Office.','[Protest of NASA contract award for metallurgy research facility operation and maintenance]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275163','ANZ-5179','United States. General Accounting Office.','[Protest of Air Force solicitation for aircraft overhaul and repair services]');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5178','Weisman, Jerry','Evaluating Architectural Legibility: Way-Finding in the Built Environment');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5176','Marans, Robert W. and Sherry Ahrentzen','Developments in Research Design, Data Collection, and Analysis: Quantitative Methods (Ch.10)');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275157','ANZ-5175','United States. General Accounting Office.','[Protest of Army contract award for food services]');
INSERT INTO new_titles VALUES ('2000/10/02','Desk Shelf','ANZ-5166','','SEE CE488 Ranjithan.');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5172','Pekovich, Stevan R. et al','Thiamine Deficiency Decreases Steady-State Transketolase and Pyruvate Dehydrogenase but...');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275152','ANZ-5164','United States. General Accounting Office.','[Protest of USMS cancellation of solicitation for towing, storage, and disposal services for seized and forfeited vehicl');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275139','ANZ-5154','United States. General Accounting Office.','[Protest of DLA contract award for police security jackets]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-275113','ANZ-5146','United States. General Accounting Office.','[Protest of Army Corps of Engineers contract award for hurricane damage repairs]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-274823','ANZ-5139','United States. General Accounting Office.','[Protest of Air Force contract award for uninterruptible power supplies and related services]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-274802.2','ANZ-5138','United States. General Accounting Office.','[Protest of Air Force contract award for environmental monitoring system installation]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-274694.2','ANZ-5131','United States. General Accounting Office.','[Protest of Air Force solicitation for avionics engineering');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-274454.4','ANZ-5130','United States. General Accounting Office.','[Request for reconsideration of protest of VA contract award for home oxygen services and equipment]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-274450.2','ANZ-5127','United States. General Accounting Office.','[Request for reimbursement of protest costs]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-274140.2','ANZ-5126','United States. General Accounting Office.','[Protest of GSA solicitation for office space construction and lease]');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5116','Heffernan, James and John Lincoln','Persuasion and Argument (Ch.7)');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5118','Morison, Samuel Eliot','Oxford History of the American People, Excerpts');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5113','Lewis, Tim.','L\'Espoir: Andre Malraux and the Art of Propoganda.');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5111','Glendinning, Nigel.','Art and the Spanish Civil War.');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5109','Preston, Paul.','The Legacy of the Spanish Civil War.');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-274122','ANZ-5108','United States. General Accounting Office.','[Protest of Interior contract award for helicopter services]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-274110.2','ANZ-5106','United States. General Accounting Office.','[Protest of VA contract award for mortgage services]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-272947.2','ANZ-5103','United States. General Accounting Office.','[Protest of Army contract award for security services]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-272748','ANZ-5099','United States. General Accounting Office.','[Protests of Army contract award for engineering and maintenance services]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-272830','ANZ-5101','United States. General Accounting Office.','[Protest of Navy contract award for ship\'s post-shakedown availability]');
INSERT INTO new_titles VALUES ('2000/10/02','','ANZ-5095','Stengel, Marc K.','Diffusionists Have Landed.');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-272413','ANZ-5094','United States. General Accounting Office.','[Protest of GSA contract award for tool kits]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-272388.2','ANZ-5091','United States. General Accounting Office.','[Protest of Navy contract award for transportation services]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-272380','ANZ-5089','United States. General Accounting Office.','[Protest of FEMA contract award for computerized photographic identification card systems]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-272313','ANZ-5087','United States. General Accounting Office.','[Protest of Navy purchase order for aerobics classes]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-272291','ANZ-5085','United States. General Accounting Office.','[Protest of GSA solicitation for diskette mailers]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-272290','ANZ-5083','United States. General Accounting Office.','[Protest of Army contract award for repair tool]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-272255','ANZ-5081','United States. General Accounting Office.','[Protest of VA cancellation of solicitation for laser system]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-272230.4','ANZ-5079','United States. General Accounting Office.','[Protest of Navy contract award for deck covering services]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-272222','ANZ-5076','United States. General Accounting Office.','[Protest of HHS cancellation of Indian set-aside solicitation]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-272191','ANZ-5073','United States. General Accounting Office.','[Funding for Army repair projects]');
INSERT INTO new_titles VALUES ('2000/10/02','GA 1.5/A-2:B-272188.2','ANZ-5071','United States. General Accounting Office.','[Protest of Navy contract award for building maintenance and repair services]');
INSERT INTO new_titles VALUES ('2000/10/02','Y 4.T 68/2:106-23','ANZ-4947','United States. Congress. House. Committee on Transportation and Infrastructure. Subcommittee on Water Resources and Environment.','Clean water infrastructure and wet weather flows legislation : hearing before the Subcommittee on Water Resources and En');
INSERT INTO new_titles VALUES ('2000/10/02','Y 4.SE 2:P 23/7','ANZ-4946','','Croatia\'s parliamentary elections : a report /');
INSERT INTO new_titles VALUES ('2000/10/02','QA267 .A66 2000','ANZ-4798','','Application and theory of petri nets 2000 : 21st International Conference, ICATPN 2000, Aarhus, Denmark, June 26-30, 200');
INSERT INTO new_titles VALUES ('2000/10/02','QA323 .I54 1998','ANZ-4786','International Conference \"Function Spaces\" (5th : 1998 : Poznan, Poland)','Function spaces : the fifth conference : proceedings of the conference at Poznan, Poland /');
INSERT INTO new_titles VALUES ('2000/10/02','TK7871.15.C4 M86 1999','ANZ-4777','','Multilayer electronic ceramic devices /');
INSERT INTO new_titles VALUES ('2000/10/02','QA76.758 .I5743 2000','ANZ-4784','International Conference PROFES 2000 (2000 : Oulu, Finland)','Product focused software process improvement : Second International Conference PROFES 2000, Oulu, Finland, June 20-22, 2');
INSERT INTO new_titles VALUES ('2000/10/02','TK5105.6 .C66 1999','ANZ-4541','','Computer media and communication : a reader /');
INSERT INTO new_titles VALUES ('2000/10/02','NA737.W7 F85 1967','ANZ-4226','Wright, Frank Lloyd, 1867-1959.','Frank Lloyd Wright : [a scrapbook].');
INSERT INTO new_titles VALUES ('2000/10/02','ML3838 .S35 1999','ANZ-3644','','The effects of music : a series of essays');
INSERT INTO new_titles VALUES ('2000/10/02','TK5981 .S92 2000','ANY-7417','','Surface acoustic wave devices in telecommunications : modelling and simulation /');
INSERT INTO new_titles VALUES ('2000/10/02','HT1523 .C48 2000','ANY-7411','Christian, Mark, 1961-','Multiracial identity : an international perspective /');
INSERT INTO new_titles VALUES ('2000/10/02','QA76.9.A25 M56 2000','ANY-7407','','Microsoft Windows 2000 security technical reference /');
INSERT INTO new_titles VALUES ('2000/10/02','NA737.W7 L36 2000','ANY-7392','Langmead, Donald.','Architectural excursions : Frank Lloyd Wright, Holland and Europe /');
INSERT INTO new_titles VALUES ('2000/10/02','HV95 .W38 2000','ANY-7314','Weaver, R. Kent, 1953-','Ending welfare as we know it /');
INSERT INTO new_titles VALUES ('2000/10/02','[videocassette] HF5822 .K55 2000','ANY-6133','','Killing us softly 3');
INSERT INTO new_titles VALUES ('2000/10/02','ND553.W3 P65 2000','ANY-4795','Plax, Julie Anne.','Watteau and the cultural politics of eighteenth-century France /');
INSERT INTO new_titles VALUES ('2000/10/02','DT83 .B7 1948','ANY-4901','Breasted, James Henry, 1865-1935.','A history of Egypt : from the earliest times to the Persian conquest /');
INSERT INTO new_titles VALUES ('2000/10/02','HF5548.32 .Z64 2000','ANY-4432','Zoellick, Bill.','Web engagement : connecting to customers in e-business /');
INSERT INTO new_titles VALUES ('2000/10/02','GE40 .P65 2000','ANY-3508','Porritt, Jonathon.','Playing safe : science and the environment /');
INSERT INTO new_titles VALUES ('2000/10/02','S593 .R455 2000','ANY-3399','','Relevance of soil testing to agriculture and the environment /');
INSERT INTO new_titles VALUES ('2000/10/02','Y 4.L 11/4:S.HRG.106-514','ANX-8989','','106-2 Hearing: E-Drugs: Who Regulates Internet Pharmacies?, S. Hrg. 106-514, March 21, 2000');
INSERT INTO new_titles VALUES ('2000/10/02','Y 4.EN 2:S.HRG.106-525','ANX-8988','United States. Congress. Senate. Committee on Energy and Natural Resources.','Proposed fiscal year 2001 budget request for the Department of the Interior : hearing before the Committee on Energy and');
INSERT INTO new_titles VALUES ('2000/10/02','Y 4.R 31/3:106-70','ANX-8987','United States. Congress. House. Committee on Resources. Subcommittee on National Parks and Public Lands.','Hearing on H.R. 3605, to establish the San Rafael Western Legacy District in Utah, and for other purposes : hearing befo');
INSERT INTO new_titles VALUES ('2000/10/02','Y 4.C 73/8:106-103','ANX-8986','United States. Congress. House. Committee on Commerce. Subcommittee on Oversight and Investigations.','The state of security at the Department of Energy\'s nuclear weapon laboratories : hearing before the Subcommittee on Ove');
INSERT INTO new_titles VALUES ('2000/10/02','Y 4.IN 8/16:R 44/4','ANX-8985','','106-1 Markup: H. CON. RES. 295, Relating to Continuing Human Rights Violations and Political Oppression in The Socialis');
INSERT INTO new_titles VALUES ('2000/10/02','Y 4.IN 8/16:P 75/17','ANX-8984','','106-1 Hearing: U.S. Policy Toward North Korea II: Misuse of U.S. Aid To North Korea, October 27, 1999');
INSERT INTO new_titles VALUES ('2000/10/02','Y 4.IN 8/16:IN 2/18','ANX-8983','','106-1 Hearing: Indonesia: Confronting The Political and Economic Crises, February 16, 2000');
INSERT INTO new_titles VALUES ('2000/10/02','Y 4.IN 8/16:H 12/8','ANX-8982','','106-1 Hearing: U.S. Policy Toward Haiti, November 9, 1999');
INSERT INTO new_titles VALUES ('2000/10/02','Y 4.ED 8/1:106-86','ANX-8981','United States. Congress. House. Committee on Education and the Workforce. Subcommittee on Oversight and Investigations.','Dropout prevention : hearing before the Subcommittee on Oversight and Investigations of the Committee on Education and t');
INSERT INTO new_titles VALUES ('2000/10/02','Y 4.3:S.HRG.106-511','ANX-8980','United States. Congress. Senate. Caucus on International Narcotics Control.','Colombia : counter-insurgency vs. counter-narcotics : hearing before the Senate Caucus on International Narcotics Contro');
INSERT INTO new_titles VALUES ('2000/10/02','RA1224.3 .E88 2000','ANX-7945','','Estrogenicity and endocrine disruption /');
INSERT INTO new_titles VALUES ('2000/10/02','TK5105.38 .F766 1998','ANX-7852','Frame Relay Forum. Technical Committee.','Physical layer interface implementation agreement /');
INSERT INTO new_titles VALUES ('2000/10/02','SB613.5 .P52 1998','ANX-7317','','Plant invasions : ecological mechanisms and human responses /');
INSERT INTO new_titles VALUES ('2000/10/02','QE707.C63 J34 2000','ANX-7321','Jaffe, Mark.','The gilded dinosaur : the fossil war between E.D. Cope and O.C. Marsh and the rise of American science /');
INSERT INTO new_titles VALUES ('2000/10/02','HD58.82 .G37 2000','ANX-7249','Garvin, David A.','Learning in action : a guide to putting the learning organization to work /');
INSERT INTO new_titles VALUES ('2000/10/02','HF5381 .C265235 2000','ANX-7210','','Career counseling models for diverse populations : hands-on applications by practitioners /');
INSERT INTO new_titles VALUES ('2000/10/02','NC998.4 .C67 1998','ANX-7131','','Corporate profile graphics 3 : an international collection of brochures of companies, schools and facilities.');
INSERT INTO new_titles VALUES ('2000/10/02','ML102.O6 B69 1999','ANX-7128','Boyden, Matthew.','Opera : the rough guide /');
INSERT INTO new_titles VALUES ('2000/10/02','NA1088.H42 A4 2000','ANX-5770','','Nachhaltige Hhe : Deutsche Messe AG Hannover, Verwaltungsgebude : Architekten, Herzog + Partner BDA, Mnchen, Thomas H');
INSERT INTO new_titles VALUES ('2000/10/02','HV9105.N9 N672 2000','ANX-5708','North Carolina. General Assembly. Legislative Research Commission. Juvenile Crime and Delinquency Committee.','Legislative Research Commission, Juvenile Crime and Delinquency Committee : report to the 2000 session of the 1999 Gener');
INSERT INTO new_titles VALUES ('2000/10/02','Z681.3.D53 N67 2000','ANX-5634','North Carolina. General Assembly. Legislative Research Commission. Committee on Digitization of Public Records by State Archives.','Digitization of public records by state archives : report to the 2000 session of the 1999 General Assembly of North Caro');
INSERT INTO new_titles VALUES ('2000/10/02','TG24.N82 H9 2000','ANX-5271','','US 264 Hyde County bridge no. 32 over Rose Bay Canal, federal-aid project no. BRSTP-264(11), state project no. 8.1080701');
INSERT INTO new_titles VALUES ('2000/10/02','TG24.N82 G7 2000b','ANX-5260','Orthner, Karen T.','Granville County bridge no. 47 on US 15 over a branch, federal project BRSTP-15 (5), state project 8.1371001, TIP no. B-');
INSERT INTO new_titles VALUES ('2000/10/02','TG24.N82 .R7 2000','ANX-5259','','Rockingham County SR 1378 bridge no. 243 over Norfolk & Southern Railway, federal-aid project no. BRZ-1378(1), state pro');
INSERT INTO new_titles VALUES ('2000/10/02','GR238 .F65 2000','ANX-5086','Fontes, Manuel da Costa.','Folklore and literature : studies in the Portuguese, Brazilian, Sephardic, and Hispanic oral traditions /');
INSERT INTO new_titles VALUES ('2000/10/02','BX8495.L45 K38 2000','ANX-4219','Kaufman, Paul Leslie, 1944-','\"Logical\" Luther Lee and the Methodist war against slavery /');
INSERT INTO new_titles VALUES ('2000/10/02','HD9685.U63 N6632 1999','ANW-9862','','Estimates of the benefits and detriments of electric industry restructuring in North Carolina : volume 2 : detailed resu');
INSERT INTO new_titles VALUES ('2000/10/02','BL240.2 .A77 2000','ANW-3761','Artigas, Mariano.','The mind of the universe : understanding science and religion /');
INSERT INTO new_titles VALUES ('2000/10/02','SF487 .S15 2000','ANS-4281','Sainsbury, David.','Poultry health and management : chickens, turkeys, ducks, geese, and quail /');
INSERT INTO new_titles VALUES ('2000/10/02','BL430 .L47 2000','ANW-3491','Lerro, Bruce, 1948-','From earth spirits to sky gods : the socioecological origins of monotheism, individualism, and hyperabstract reasoning f');
INSERT INTO new_titles VALUES ('2000/10/02','TE24.N82 M4 2000','ANS-2977','','[US 19-23, construct a rest area/welcome center near the Tennessee state line in Madison County, TIP project no. K-3304,');
INSERT INTO new_titles VALUES ('2000/10/02','TG24.N82 M86 1999','ANS-2971','','[Replace bridge no. 149 and bridge no. 150 over Little River Overflow and the Little River on SR 1861 in Moore County, T');
INSERT INTO new_titles VALUES ('2000/10/02','GV430.N8 N68 1999','ANS-1277','','North Carolina statewide facilities guide.');
INSERT INTO new_titles VALUES ('2000/10/02','TG24.N82 B5 1999b','ANS-2970','','[Replace bridge no. 59 on NC 11 over Colly Creek in Bladen County, TIP project no. B-3112, state project no. 8.1421001,');
INSERT INTO new_titles VALUES ('2000/09/28','LD3921 Micro-biol. S22','ANZ-2192','Saah, J. Royden (Joseph Royden), 1968-','Role of arc, fnr, and fur in the expression of katG, katE, and hemA : effects on hydroperoxidases in Escherichia coli /');
INSERT INTO new_titles VALUES ('2000/09/28','LD3921 Parks, Recr. & Tour. Mgmt. R632','ANZ-2184','Roberts, Snow Loy, 1975-','North Carolina State University\'s Department of Parks, Recreation and Tourism Management : year 2000 survey of master\'s');
INSERT INTO new_titles VALUES ('2000/09/28','LD3921 Mech. & Aerospace Eng. R48','ANZ-2182','Reynolds, Wayne E. (Wayne Edward), 1950-','Monocoque chassis structural design and analysis /');
INSERT INTO new_titles VALUES ('2000/09/28','LD3921 Tex. Mgt. & Tech. N48','ANZ-2174','Nguyen, Paul Anh, 1975-','Evaluation of meltblown nonwoven fabrics /');
INSERT INTO new_titles VALUES ('2000/09/28','LD3921 Psy. M76','ANZ-2171','Mroczka, Mary Ann.','Effects of type and modality of pretraining on learning the names for Braille symbols /');
INSERT INTO new_titles VALUES ('2000/09/28','C 55.13/2:NMFS-NE-154','ANZ-2088','Joint Scientific Review Group Workshop (1999 : Seattle, Wash.)','Report of the Joint Scientific Review Group Workshop, April 13-14, 1999, Seattle, Washington');
INSERT INTO new_titles VALUES ('2000/09/28','TA417.6 .E97 1999','ANY-7767','European Conference on Residual Stresses (5th : 1999 : Delft-Noordwijkerhout, Netherlands)','ECRS 5 : proceedings of the Fifth European Conference on Residual Stresses : held September 28-30, 1999 in Delft-Noordwi');
INSERT INTO new_titles VALUES ('2000/09/28','QA331 .M675 2000','ANY-7402','Mityushev, Vladimir V.','Constructive methods for linear and nonlinear boundary value problems for analytic functions : theory and applications /');
INSERT INTO new_titles VALUES ('2000/09/28','DS919.A8 O36 2000','ANY-7381','O\'Dowd, Ben, 1918-','In valiant company /');
INSERT INTO new_titles VALUES ('2000/09/28','PN1992.5 .H63 2000','ANY-7369','Holland, Patricia.','The television handbook /');
INSERT INTO new_titles VALUES ('2000/09/28','QA448.D38 R53 2000','ANY-7349','Richter-Gebert, Jrgen.','User manual for the interactive geometry software Cinderella /');
INSERT INTO new_titles VALUES ('2000/09/28','PS153.N5 B45 2000','ANY-7343','Benston, Kimberly W.','Performing blackness : enactments of African-American modernism /');
INSERT INTO new_titles VALUES ('2000/09/28','HM886 .V56 2000','ANY-7327','','Violence and subjectivity /');
INSERT INTO new_titles VALUES ('2000/09/28','DT1945 .T78 2000','ANY-7326','','Truth v. justice : the morality of truth commissions /');
INSERT INTO new_titles VALUES ('2000/09/28','E505.5 105th .C73 2000','ANY-7325','Cram, George Franklin, 1841-1928.','Soldiering with Sherman : Civil War letters of George F. Cram /');
INSERT INTO new_titles VALUES ('2000/09/28','HD75.6 .C97 2000','ANY-7324','Czech, Brian, 1960-','Shoveling fuel for a runaway train : errant economists, shameful spenders, and a plan to stop them all /');
INSERT INTO new_titles VALUES ('2000/09/29','QH541.13 .C35 1998','ANX-7324','Callenbach, Ernest.','Ecology : a pocket guide /');
INSERT INTO new_titles VALUES ('2000/09/29','Z473.A485 S64 2000','ANX-7275','Spector, Robert, 1947-','Amazon.com : get big fast /');
INSERT INTO new_titles VALUES ('2000/09/29','HG4910 .C626 1998','ANX-7269','Cornell, Joseph W., 1963-','Spin-off to pay-off : an analytical guide to investing in corporate divestitures /');
INSERT INTO new_titles VALUES ('2000/09/29','K380 .R445 1999','ANX-7196','Reisman, W. Michael (William Michael), 1939-','Law in brief encounters /');
INSERT INTO new_titles VALUES ('2000/09/29','TK5105.888 .S533 1999','ANX-7132','Siegel, David.','Futurize your enterprise : business strategy in the age of the e-customer /');
INSERT INTO new_titles VALUES ('2000/09/29','ML160 .R42 1999','ANX-7127','','Reader\'s guide to music : history, theory, criticism /');
INSERT INTO new_titles VALUES ('2000/09/29','DR20 .S945 1999','ANX-6801','Syme, Ronald, Sir, 1903-','The provincial at Rome : and, Rome and the Balkans 80BC-AD14 /');
INSERT INTO new_titles VALUES ('2000/09/29','DS799.63.C6 U534 2000','ANX-6796','','Uncertain future : Taiwan-Hong Kong-China relations after Hong Kong\'s return to Chinese sovereignty /');
INSERT INTO new_titles VALUES ('2000/09/29','RC487 .C55 1999','ANX-6770','','Client-centred practice in occupational therapy : a guide to implementation /');
INSERT INTO new_titles VALUES ('2000/09/29','Y 3.P 31:2 IS 7','ANW-9366','Cobban, Helena.','The Israeli-Syrian peace talks 1991-96 and beyond /');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/8:106-602','ANW-9256','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 2957, the Lake Pontchartrain Basin Restoration Act : report (to accompany H. Res');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/7:106-150','ANW-9188','United States. Office of the Assistant Secretary of the Army (Civil Works)','Lower Cumberland and Tennessee rivers, Kentucky Lock addition : communication from the Assistant Secretary of the Army (');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/8:106-608','ANW-9169','United States. Congress. House. Committee on Education and the Workforce.','Education Opportunities to Protect and Invest in Our Nation\'s Students (Education OPTIONS) Act : report of the Committee');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/8:106-603','ANW-9166','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 1106, the Alternative Water Sources Act of 1999 : report (to accompany H. Res. 4');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/8:106-598','ANW-9160','United States. Congress. House. Committee on Resources.','Ak-Chin Water Use Amendments Act of 1999 : report (to accompany H.R. 2647) (including cost estimate of the Congressional');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/5:106-277','ANW-9049','United States. Congress. Senate. Committee on Indian Affairs (1993- )','Amending the Indian Employment, Training, and Related Services Demonstration Act of 1992, to emphasize the need for job');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/5:106-276','ANW-9048','United States. Congress. Senate. Committee on Foreign Relations.','Intercountry Adoption Act of 2000 : report (to accompany S. 682).');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/5:106-275','ANW-9047','United States. Congress. Senate. Committee on Energy and Natural Resources.','Secure Rural Schools and Community Self-determination Act of 1999 : report (to accompany S. 1608).');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/5:106-274','ANW-9046','United States. Congress. Senate. Committee on Banking, Housing, and Urban Affairs.','Manufactured Housing Improvement Act of 2000 : report of the Committee on Banking, Housing, and Urban Affairs, United St');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/5:106-273','ANW-9045','United States. Congress. Senate. Committee on Energy and Natural Resources.','Disabled Veterans\' LIFE Memorial Foundation : report (to accompany S. 311).');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/8:106-601','ANW-9007','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 673, the Florida Keys Water Quality Improvements Act of 2000 : report (to accomp');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/8:106-605','ANW-9004','United States. Congress. House. Committee on Rules.','Waiving a requirement of clause 6(a) of rule XIII with respect to the same day consideration of certain resolutions repo');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/5:106-279','ANW-8861','United States. Congress. Senate. Select Committee on Intelligence.','Authorizing appropriations for fiscal year 2001 for the intelligence activities of the United States government and the');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/5:106-278','ANW-8834','United States. Congress. Senate. Committee on Commerce, Science, and Transportation.','Amateur Sports Integrity Act : report of the Committee on Commerce, Science, and Transportation on S. 2340.');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/8:106-607','ANW-8813','United States. Congress. House. Committee on Rules.','Waiving points of order against the conference report to accompany H.R. 434, the Trade and Development Act of 2000 : rep');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/8:106-606','ANW-8812','United States. Congress (106th, 2nd session : 2000)','Trade and Development Act of 2000 : conference report to (accompany H.R. 434).');
INSERT INTO new_titles VALUES ('2000/09/29','Y 1.1/7:106-226','ANW-8688','United States. Supreme Court.','Amendments to Federal rules of bankruptcy : communication from the Chief Justice, the Supreme Court of the United States');
INSERT INTO new_titles VALUES ('2000/09/29','E184.S75 C35 1995','ANW-3691','Campbell, Richard C.','Two eagles in the sun : your questions answered about Mexican Hispanics in the border Southwest & other Hispanics in the');
INSERT INTO new_titles VALUES ('2000/09/29','QH75 .P793 2000','ANW-3458','','Protecting biodiversity : national laws regulating access to genetic resources in the Americas /');
INSERT INTO new_titles VALUES ('2000/09/29','TE24.N82 W8 1999c','ANS-2979','','[Install median guardrail for I-95 from the Johnston/Wilson county line to the Virginia state line and on US 264 from ea');
INSERT INTO new_titles VALUES ('2000/09/29','TE24.N82 J5 1999b','ANS-2975','','[Widen the intersection of SR 1004 (Old US 70) and SR 1553 (Shotwell Road) in Johnston County, TIP project no. W-4005, s');
INSERT INTO new_titles VALUES ('2000/09/29','RA778 .W65 2000','ANS-1939','','Women and health /');
INSERT INTO new_titles VALUES ('2000/09/29','TG24.N82 I6 1999','ANS-2972','','[Bridge rehabilitation, cable guardrail installation, concrete patching, and shoulder drain installation for I-77 south');
INSERT INTO new_titles VALUES ('2000/09/29','[DVD] PN1993.5.I829 M345 1998','ANR-4585','','Maine Pyar Kiya');
INSERT INTO new_titles VALUES ('2000/09/29','[DVD] PN1993.5.I829 D87 1998','ANR-6038','','Duplicate');
INSERT INTO new_titles VALUES ('2000/09/29','SB379.R34 O65 1998','ANR-3597','Ong, Peter Kheng-Chuan, 1968-','The flavor chemistry of rambutan (Nephelium lappaceum L.) and lychee (Litchi Chinesis Sonn.) / y Peter Kheng-Chuan Ong.');
INSERT INTO new_titles VALUES ('2000/09/29','QH603.M5 W38 1998','ANR-3558','Watkins, Steven Michael.','Cardiolipin acyl composition is uniquely regulated and critically influences mitochondrial function /');
INSERT INTO new_titles VALUES ('2000/09/29','TL574.B6 H56 1997','ANR-3314','Hites, Michael Hubert.','Scaling of high-reynolds number turbulent boundary layers in the national diagnostic facility /');
INSERT INTO new_titles VALUES ('2000/09/29','QC611.8.S5 S95 1997','ANR-3253','Sweryda-Krawiec, Beata.','The impact of Lewis acid/base exposure on the surface states of luminescent porous silicon /');
INSERT INTO new_titles VALUES ('2000/09/29','TP684.S6 S85 1999','ANR-2956','Steenson, Donald Frank, 1970-','Carotene thermal degradation products and their effects on the oxidative stability of Soybean Oil /');
INSERT INTO new_titles VALUES ('2000/09/29','TP380 .B46 1999','ANR-2912','Ben-Yoseph, Eyal.','Computer modeling of sucrose crystallization during drying of thin sucrose films /');
INSERT INTO new_titles VALUES ('2000/09/29','TK7872.P54 N53 1998','ANR-2955','Nickles, Annabel Susan.','The development of lead zirconate titanate thin films for piezoelectric microactuators /');
INSERT INTO new_titles VALUES ('2000/09/29','TX360.N6 L63 1999','ANR-2880','Lockett, Cassius Tyrone.','Nutritional consequences of food-related behaviors during drought and chemical composition of edible wild plants consume');
INSERT INTO new_titles VALUES ('2000/09/29','TN693.C9 T38 1998','ANR-2860','Taube, Michelle.','Selective dissolution in copper-tin alloys : formation of the surface finish on early Chinese bronze mirrors /');
INSERT INTO new_titles VALUES ('2000/09/29','TA654 .N35 1997','ANR-2277','Na, Sungsoo, 1963-','Control of dynamic response of thin-walled composite beams using structural tailoring and piezoelectric actuation /');
INSERT INTO new_titles VALUES ('2000/09/29','TA430 .D46 1997','ANR-2081','De Carvalho, Eduardo Atem, 1964-','Characterization of the effect of severe environment on advanced materials /');
INSERT INTO new_titles VALUES ('2000/09/29','TK7870 .H35 1998','ANR-1999','Hautamaki, Charles Albert.','Discrete embedded microsensors in laminated composites /');
INSERT INTO new_titles VALUES ('2000/09/29','BS476 .P67 1995','ANQ-1015','','The postmodern Bible /');
INSERT INTO new_titles VALUES ('2000/09/29','TJ223.A25 W37 1998','ANR-1833','Wang, Xiaodong.','The dynamic behaviour of interacting piezoelectric actuators in smart structures /');
INSERT INTO new_titles VALUES ('2000/10/02','SH156.8 .D67 1999','ANS-1063','Dorsey, Lawrence G.','Retention of coded wire tags by juvenile muskellunge /');
INSERT INTO new_titles VALUES ('2000/10/02','J 34.8:C 43','ANR-7240','','Working With Grieving Children After Violent Death: A Guidebook For Crime Victim Assistance Professionals, Instructor\'s');
INSERT INTO new_titles VALUES ('2000/10/02','[DVD] PN1993.5.I829 H367 1998','ANR-6048','','Haseena maan jaayegi');
INSERT INTO new_titles VALUES ('2000/10/02','[DVD] PN1993.5.I829 C43 1998','ANR-4664','','Chachi 420');
INSERT INTO new_titles VALUES ('2000/10/02','[DVD] PN1993.5.I829 D65 1998','ANR-4667','','Doli saja ke rakhna');
INSERT INTO new_titles VALUES ('2000/10/02','BM723 .J487 1986','ANQ-0998','','Jewish spirituality /');
INSERT INTO new_titles VALUES ('2000/10/02','QK711.2 .S36','ANQ-4739','Schopfer, Peter, 1938-','Pflanzenphysiologie /');
INSERT INTO new_titles VALUES ('2000/10/02','TS1770.I53 J65','ANN-1675','','Journal of industrial textiles.');
INSERT INTO new_titles VALUES ('2000/10/02','QC611.8.S86 I58 1999','ANF-5808','International Workshop on Lattice-Mismatched and Heterovalent Thin Film Epitaxy (1st : 1998 : Castelvecchio Pascoli, Italy)','Lattice mismatched thin films : proceedings of the First International Workshop on Lattice-Mismatched and Heterovalent T');
INSERT INTO new_titles VALUES ('2000/10/02','QH541.5.W3 A67 1995','AMY-2484','','Aquatic ecosystems of China : environmental and toxicological assessment = Chung-huo ti shui sheng t`ai hsi t`ung : huan');
INSERT INTO new_titles VALUES ('2000/10/02','HA4666 .A22','AJQ-8276','','Majmu`at al-ihsa\'at wa-al-mu\'ashshirat al-ijtima`iyah /');
INSERT INTO new_titles VALUES ('2000/10/02','TS1300 .I6689','AJK-3432','','International textile bulletin.');
INSERT INTO new_titles VALUES ('2000/10/02','BF724.65.M53 L54 1999','AJP-0708','','Life in the middle : psychological and social development in middle age /');
INSERT INTO new_titles VALUES ('2000/10/02','PE1403 .I87','AJK-3079','','Issues in writing.');
INSERT INTO new_titles VALUES ('2000/10/02','TA459 .J67','AIR-2389','','Journal of materials science & technology.');
INSERT INTO new_titles VALUES ('2000/10/02','TS1465 .I530','AIQ-8707','','Indian journal of fibre & textile research.');
INSERT INTO new_titles VALUES ('2000/10/02','TS933.C4 C4','AIQ-7746','Cellulose (London, England)','Cellulose.');
INSERT INTO new_titles VALUES ('2000/10/02','QD1 .J62','AIO-4258','','The journal of physical chemistry.');
INSERT INTO new_titles VALUES ('2000/10/02','E185.615 .S5828 1996','AIL-6596','Smith, Robert Charles, 1947-','We have no leaders : African Americans in the post-civil rights era /');
INSERT INTO new_titles VALUES ('2000/10/02','HD9284 .W5','AIK-6608','','Who\'s who in the egg and poultry industries in the United States and Canada.');
INSERT INTO new_titles VALUES ('2000/10/02','TS1300 .A97','AIK-2474','','Australasian textiles & fashion.');
INSERT INTO new_titles VALUES ('2000/10/02','RM1 .E82','AIE-5373','','Environmental toxicology and pharmacology.');
INSERT INTO new_titles VALUES ('2000/10/02','TS1300 .I952','AIB-3522','','ITS textile leader.');
INSERT INTO new_titles VALUES ('2000/09/28','PN1059.A9 K56 1999','ANY-7320','Kinzie, Mary.','A poet\'s guide to poetry /');
INSERT INTO new_titles VALUES ('2000/09/28','ML3477 .G36 2000','ANY-7321','Garman, Bryan K.','A race of singers : Whitman\'s working-class hero from Guthrie to Springsteen /');
INSERT INTO new_titles VALUES ('2000/09/28','P117 .L363 2000','ANY-7317','','Language and gesture /');
INSERT INTO new_titles VALUES ('2000/09/28','E840.8.S29 S29 2000','ANY-7316','Saxbe, William B.','I\'ve seen the elephant : an autobiography /');
INSERT INTO new_titles VALUES ('2000/09/28','TA347.F5 M38 2000','ANY-7064','','The mathematics of finite elements and applications X : MAFELAP 1999 /');
INSERT INTO new_titles VALUES ('2000/09/28','TP372.5 .S74 1996','ANY-6471','Steffe, James Freeman.','Rheological methods in food process engineering /');
INSERT INTO new_titles VALUES ('2000/09/28','PQ7389.C263 R413 1989','ANY-6335','Carpentier, Alejo, 1904-','The kingdom of this world /');
INSERT INTO new_titles VALUES ('2000/09/28','M985.X5 P55 1990','ANY-6216','Xenakis, Iannis, 1922-','Pliades : 1978 ; Psappha : for percussion solo (1975)');
INSERT INTO new_titles VALUES ('2000/09/28','PN2071.I47 S46 2000','ANY-4874','Senelick, Laurence.','The changing room : sex, drag and theatre /');
INSERT INTO new_titles VALUES ('2000/09/28','PS2382 .R63 2000','ANY-4871','Melville, Herman, 1819-1891.','The poems of Herman Melville /');
INSERT INTO new_titles VALUES ('2000/09/28','QA427 .W67 1999','ANY-4852','Workshop on Nonlinearity, Integrability and All That--Twenty Years after NEEDS \'79 (1999 : Lecce, Italy)','Proceedings of the Workshop on Nonlinearity, Integrability and All That--Twenty Years after NEEDS \'79 : Lecce, Italy, 1-');
INSERT INTO new_titles VALUES ('2000/09/28','GC10.4.M36 K36 2000','ANY-4779','Kantha, Lakshmi H.','Numerical models of oceans and oceanic processes /');
INSERT INTO new_titles VALUES ('2000/09/28','DJ158 .P83 2000','ANY-4762','','The public and private in Dutch culture of the Golden Age /');
INSERT INTO new_titles VALUES ('2000/09/28','DR485 .Q37 2000','ANY-4759','Quataert, Donald, 1941-','The Ottoman Empire, 1700-1922 /');
INSERT INTO new_titles VALUES ('2000/09/28','HD9433.U5 G747 2000','ANY-4756','Patterson, Paul E., 1926-','Great Plains cattle empire : Thatcher Brothers and Associates (1875-1945) /');
INSERT INTO new_titles VALUES ('2000/09/28','PS3242.S47 P65 2000','ANY-4752','Pollak, Vivian R.','The erotic Whitman /');
INSERT INTO new_titles VALUES ('2000/09/28','PS3554.R83 D57 2000','ANY-4751','Drury, John, 1950-','The disappearing town /');
INSERT INTO new_titles VALUES ('2000/09/28','PS3572.I9 C47 2000','ANY-4747','Vizenor, Gerald Robert, 1934-','Chancers : a novel /');
INSERT INTO new_titles VALUES ('2000/09/28','PS366.T73 G55 2000','ANY-4746','Gifra-Adroher, Pere, 1966-','Between history and romance : travel writing on Spain in the early nineteenth-century United States /');
INSERT INTO new_titles VALUES ('2000/09/28','HF5548.32 .C365 2000','ANY-4465','','Cases in electronic commerce /');
INSERT INTO new_titles VALUES ('2000/09/28','HF5548.32 .S35 2000','ANY-4480','Schneider, Gary P.','Electronic commerce /');
INSERT INTO new_titles VALUES ('2000/09/28','TX814.5.P66 S62 1999','ANY-4123','Smith, Andrew F., 1946-','Popped culture : a social history of popcorn in America /');
INSERT INTO new_titles VALUES ('2000/09/28','DS318.84.K48 M65 2000','ANY-3611','Moin, Baqer.','Khomeini : life of the Ayatollah /');
INSERT INTO new_titles VALUES ('2000/09/28','F342 .W44 2000','ANY-3608','Welty, Eudora, 1909-','Country churchyards /');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.81:28081-E 4-TF-024/995','AOE-5500','Geological Survey (U.S.)','Orlando West quadrangle, Florida--Orange Co., 1995 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.81:28081-A 8-TF-024/994','AOE-5499','Geological Survey (U.S.)','Lakeland quadrangle, Florida--Polk Co., 1994 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.81:30087-E 3-TF-024/994','AOE-5498','Geological Survey (U.S.)','Cantonment quadrangle, Florida, 1994 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','[DVD] TR850 .V58 2000','AOE-5088','','Visions of light the art of cinematography /');
INSERT INTO new_titles VALUES ('2000/10/12','D 5.356:62142/2000','AOE-5397','United States. National Imagery and Mapping Agency.','Africa, Red Sea--western shore, Sudan, approaches to Port Sudan /');
INSERT INTO new_titles VALUES ('2000/10/12','D 5.356:62442/2000','AOE-4863','','Persian Gulf - Iran, Bandar-E Emam Khomeyni and Bandar-E Mahshahr, Khowr-E Musa, Scale 1:25,000, 62442, April 29, 2000');
INSERT INTO new_titles VALUES ('2000/10/12','D 5.356:62162/2000','AOE-4861','','Red Sea Egypt, Baranis and Approaches, Scale 1:50,000, 62162, April 22, 2000');
INSERT INTO new_titles VALUES ('2000/10/12','D 5.356:62222/2000','AOE-4862','','Red Sea Gulf of Aqaba, Strait of Tiran, Scale 1:25,000, 62222, March 18, 2000');
INSERT INTO new_titles VALUES ('2000/10/12','D 5.356:55128/2000','AOE-4858','','Black Sea Russia, Port Novorossiysk, Scale 1:25,000, 55128, March 18, 2000');
INSERT INTO new_titles VALUES ('2000/10/12','D 5.356:55139/2000','AOE-4859','','Georgia-Turkey Black Sea, Approaches to Bat\'umis Navsadguri, Scale 1:50,000, 55139, May 6, 2000');
INSERT INTO new_titles VALUES ('2000/10/12','QC176.8.E4 T73 1999','AOE-4463','Training Course in the Physics of Correlated Electron Systems and High-Tc Superconductors (4th : 1999 : Salerno, Italy)','Lectures on the physics of highly correlated electron systems IV : Fourth Training Course in the Physics of Correlated E');
INSERT INTO new_titles VALUES ('2000/10/12','QB470.A1 I84 2000','AOE-4456','','ISO surveys of a dusty universe : proceedings of a Ringberg workshop held at Ringberg Castle, Tegernsee, Germany, 8-12 N');
INSERT INTO new_titles VALUES ('2000/10/12','D967 .T73 2000','AOD-5991','Thompson, Wayne C., 1943-','Western Europe, 2000 /');
INSERT INTO new_titles VALUES ('2000/10/12','LT4210.S33 L57 2000 vol.4','AOC-4802','','Scholastic literacy place, Grade 3 /');
INSERT INTO new_titles VALUES ('2000/10/12','LT4250.S33 S33 2001, v. 2','AOD-2240','','Scholastic read XL');
INSERT INTO new_titles VALUES ('2000/10/12','HV1568 .R45 2000','ANZ-2994','Reinders, Hans S.','The future of the disabled in liberal society : an ethical analysis /');
INSERT INTO new_titles VALUES ('2000/10/12','P91 .H66 2000','ANZ-2973','Hoveyda, Fereydoun.','The hidden meaning of mass communications : cinema, books, and television in the age of computers /');
INSERT INTO new_titles VALUES ('2000/10/12','TJ828 .H3813 2000','ANZ-2968','Hau, E. (Erich)','Windturbines : fundamentals, technologies, application and economics /');
INSERT INTO new_titles VALUES ('2000/10/12','Q181 .S694 2000','ANZ-2935','Stavy, Ruth.','How students (mis-) understand science and mathematics : intuitive rules /');
INSERT INTO new_titles VALUES ('2000/10/12','UA42 .A7418 2000','ANZ-2882','Asch, Beth J.','The thrift savings plan : will reservists participate? /');
INSERT INTO new_titles VALUES ('2000/10/12','HD4901 .L117 1994','ANZ-2757','','Labor economics and industrial relations : markets and institutions /');
INSERT INTO new_titles VALUES ('2000/10/12','J 29.11/10:995','ANZ-2207','','Criminal victimization in the United States, 1995.');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:37117-A 1-TM-100/2000','ANZ-2155','United States. Bureau of Land Management.','California Desert District : Last Chance Range : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:35116-A 1-TM-100/2000','ANZ-2154','United States. Bureau of Land Management.','California Desert District : Soda Mountains : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:36114-E 1-TM-100/2000','ANZ-2150','United States. Bureau of Land Management.','Nevada : Overton : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:36114-A 1-TM-100/2000','ANZ-2149','United States. Bureau of Land Management.','Nevada : Lake Mead : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:35113-E 1-TM-100/2000','ANZ-2148','United States. Bureau of Land Management.','Arizona : Peach Springs : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:36113-A 1-TM-100/2000','ANZ-2147','United States. Bureau of Land Management.','Arizona : Mount Trumbull : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:36113-E 1-TM-100/2000','ANZ-2146','United States. Bureau of Land Management.','Arizona : Littlefield : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4-2:43118-E 1-TM-100/999','ANZ-2143','United States. Bureau of Land Management.','Oregon : Stinkingwater Mountains : 1:100 000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:43118-E 1-TM-100/999','ANZ-2142','United States. Bureau of Land Management.','Oregon : Stinkingwater Mountains : 1:100 000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4-2:38102-A 1-TM-100/2000','ANZ-2122','United States. Bureau of Land Management.','Colorado : Lamar : 1:100,000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4-2:38108-E 1-TM-100/2000','ANZ-2119','United States. Bureau of Land Management.','Colorado : Delta : 1:100,000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:38108-E 1-TM-100/2000','ANZ-2118','United States. Bureau of Land Management.','Colorado : Delta : 1:100,000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4-2:32105-A 1-TM-100/2000','ANZ-2116','United States. Bureau of Land Management.','New Mexico : Crow Flats : New Mexico : 1:100,000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:32105-A 1-TM-100/2000','ANZ-2115','United States. Bureau of Land Management.','New Mexico : Crow Flats : 1:100,000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4-2:43117-E 1-TM-100/999','ANZ-2114','United States. Bureau of Land Management.','Oregon : Vale : 1:100 000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:43117-E 1-TM-100/999','ANZ-2113','United States. Bureau of Land Management.','Oregon : Vale : 1:100 000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4-2:43104-E 1-TM-100/999','ANZ-2111','United States. Bureau of Land Management.','Wyoming : Newcastle : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','HE242.A15 T73','ANZ-0575','','Trends in the transport sector /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:43104-E 1-TM-100/999','ANZ-2110','United States. Bureau of Land Management.','Wyoming : Newcastle : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','LB2846 .E247','ANZ-0540','Education at a glance (Paris, France)','Education at a glance, OECD indicators /');
INSERT INTO new_titles VALUES ('2000/10/12','M1804 .E383 1995','ANZ-0390','','The education of a singer at the Beijing Opera');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:39109-E 1-TM-100/999','ANY-9154','United States. Bureau of Land Management.','Utah : Seep Ridge : 1:100,000-scale topographic map of Blanding : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:36117-E 1-TM-100/999','ANY-8978','United States. Bureau of Land Management.','California Desert District : Saline Valley : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:34114-E 1-TM-100/999','ANY-8977','United States. Bureau of Land Management.','California Desert District : Needles : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','BF1779.F4 W935 2000','ANY-4381','Wydra, Nancilee.','Feng shui goes to the office : how to thrive from 9 to 5 /');
INSERT INTO new_titles VALUES ('2000/10/10','HD62.5 .N47 2000','ANY-4412','Nesheim, John L., 1942-','High tech start-up : the complete handbook for creating successful new high tech companies /');
INSERT INTO new_titles VALUES ('2000/10/10','N6447 .L67 2000','ANY-4361','Lorente, Jess Pedro.','Cathedrals of urban modernity : the first museums of contemporary art, 1800-1930 /');
INSERT INTO new_titles VALUES ('2000/10/10','HG221.3 .P52 1997','ANY-4355','Phillips, Michael, 1938-','The seven laws of money /');
INSERT INTO new_titles VALUES ('2000/10/10','HF5382.7 .P68 1999','ANY-4350','Post, Peggy, 1945-','Emily Post\'s The etiquette advantage in business : personal skills for professional success /');
INSERT INTO new_titles VALUES ('2000/10/10','SB434 .P4733 2000','ANY-4122','','Perennials.');
INSERT INTO new_titles VALUES ('2000/10/10','T19 .L56 2000','ANY-3494','Lindsay, David, 1957-','House of invention : the secret life of everyday products /');
INSERT INTO new_titles VALUES ('2000/10/10','RC628 .I48 1974','ANY-2781','International Congress on Obesity (1st : 1974 : London)','Recent advances in obesity research I : proceedings of the 1st International Congress on Obesity /');
INSERT INTO new_titles VALUES ('2000/10/10','TX633 .F5184 1988','ANY-2032','Fisher, M. F. K. (Mary Frances Kennedy), 1908-','How to cook a wolf /');
INSERT INTO new_titles VALUES ('2000/10/10','TX723.5.S6 G35 2000','ANY-2021','Glov-Lorinc, Sylvia.','The best of Slovak cooking /');
INSERT INTO new_titles VALUES ('2000/10/10','QD381.8 .I53 1996','ANY-1846','Inagaki, N.','Plasma surface modification and plasma polymerization /');
INSERT INTO new_titles VALUES ('2000/10/10','BJ1012 .S515 1999','ANY-1651','Skorupski, John, 1946-','Ethical explorations /');
INSERT INTO new_titles VALUES ('2000/10/10','SB439.6 .F67 2000','ANY-1602','Forster, R. Roy.','The woodland garden : planting in harmony with nature /');
INSERT INTO new_titles VALUES ('2000/10/10','QA76.76.O63 N395 2000','ANY-1012','Nebbett, Gary.','Windows NT/2000 native API reference /');
INSERT INTO new_titles VALUES ('2000/10/10','QC495 .C78 2000','ANY-1008','Cooper, Mimi.','Color smart : how to use color to enhance your business and personal life /');
INSERT INTO new_titles VALUES ('2000/10/10','DA533 .H63 2000','ANY-0659','','History, religion, and culture : British intellectual history, 1750-1950 /');
INSERT INTO new_titles VALUES ('2000/10/10','HC123 .A3 2000','ANY-0642','Adams, Francis.','Dollar diplomacy : United States economic assistance to Latin America /');
INSERT INTO new_titles VALUES ('2000/10/10','T 22.44/2:1219/2000','ANX-7678','','A Community service that can work for you.');
INSERT INTO new_titles VALUES ('2000/10/10','HC107.A13 P696 2000','ANX-7549','','Poverty or development? : global restructuring and regional transformations in the U.S. South and the Mexican South /');
INSERT INTO new_titles VALUES ('2000/10/10','QE862.D5 H22 2000','ANX-7322','Haines, Tim.','Walking with dinosaurs : a natural history /');
INSERT INTO new_titles VALUES ('2000/10/10','HT167 .U7534 2000','ANX-7243','','Urban space and representation /');
INSERT INTO new_titles VALUES ('2000/10/10','ML3921.2 .B53 1999','ANX-7129','Blackwell, Albert L.','The sacred in music /');
INSERT INTO new_titles VALUES ('2000/10/10','HD30.28 .I79 2000','ANX-7154','Irwin, David.','On target : achieving best business performance /');
INSERT INTO new_titles VALUES ('2000/10/10','F3444 .B733 2000','ANX-6951','Bradley, Peter T., 1943-','Habsburg Peru : images, imagination and memory /');
INSERT INTO new_titles VALUES ('2000/10/10','RC488.5 .C6435 2000','ANX-6788','','Couples on the fault line : new directions for therapists /');
INSERT INTO new_titles VALUES ('2000/10/10','RC455.2.P85 I46 1999','ANX-6787','','The image of madness : the public facing mental illness and psychiatric treatment /');
INSERT INTO new_titles VALUES ('2000/10/10','BF323.S63 S735 2000','ANX-6747','','Stereotypes and prejudice : essential readings /');
INSERT INTO new_titles VALUES ('2000/10/10','TH6021 .I272 1999','ANX-4018','IAQ and Energy 98 : (1998 : New Orleans, La.)','IAQ and energy 98 : using ASHRAE standards 62 and 90.1 /');
INSERT INTO new_titles VALUES ('2000/10/10','TD 8.2:C 15/2000/PACK.','ANX-1632','','Campaign Safe & Sober Program Planner 22, June - October 2000, (Package)');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:25640/2000','ANX-1628','United States Coast Survey.','West Indies, Puerto Rico and Virgin Islands /');
INSERT INTO new_titles VALUES ('2000/10/10','LC 30.2:H 71/2000','ANX-1629','','MARC 21, Format For Holdings Data Including Guidelines For Content Designation, 2000 Edition, January 2000');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:12277/2000','ANX-1627','United States Coast Survey.','United States--east coast, Maryland--Delaware--New Jersey, Chesapeake and Delaware Canal /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:12230/2000','ANX-1626','United States Coast Survey.','United States--east coast, Maryland--Virginia, Chesapeake Bay, Smith Point to Cove Point /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:12211/2000','ANX-1625','United States Coast Survey.','United States--east coast, Delaware, Maryland and Virginia, Fenwick Island to Chincoteague Inlet /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:11368/2000','ANX-1624','United States Coast Survey.','United States--Gulf coast, Louisiana, New Orleans harbor, Chalmette slip to Southport /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:11013/2000','ANX-1623','United States Coast Survey.','Atlantic coast, Straits of Florida and approaches /');
INSERT INTO new_titles VALUES ('2000/10/10','TA664 .O343 1999','ANW-3359','Oehlers, Deric J.','Elementary behaviour of composite steel and concrete structural members /');
INSERT INTO new_titles VALUES ('2000/10/10','SF487 .P694 1999','ANS-1940','Poultry Science Symposium (25th : 1997 : University of Bristol)','Poultry meat science /');
INSERT INTO new_titles VALUES ('2000/10/10','SB615.D6 S17 1998','ANS-1358','Salt, David T.','Insects on dock plants /');
INSERT INTO new_titles VALUES ('2000/10/10','PL833.I7 Z6984 2000','ANS-1935','Nathan, John, 1940-','Mishima : a biography /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:13318/2000','ANR-9760','United States Coast Survey.','United States--east coast, Maine, Frenchman Bay and Mount Desert Island /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:13292/2000','ANR-9759','United States Coast Survey.','United States--east coast, Maine, Portland Harbor and vicinity /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:12278/2000','ANR-9758','United States Coast Survey.','United States--east coast, Maryland, Chesapeake Bay, approaches to Baltimore Harbor /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:11475/2000','ANR-9756','United States Coast Survey.','United States--east coast, Florida, Fort Pierce Harbor /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:11488/2000','ANR-9757','United States Coast Survey.','United States--east coast, Florida, Amelia Island to St Augustine /');
INSERT INTO new_titles VALUES ('2000/10/10','SSA 1.2/15:B 61/2000','ANR-7345','','Social Security, If You Are Blind Or Have Low Vision--How We Can Help, March 2000');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:25681/2000','ANR-7343','United States Coast Survey.','West Indies, Puerto Rico--south coast, Bahia de Guayanilla and Bahia de Tallaboa /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:13218/2000','ANR-7342','United States Coast Survey.','United States--east coast, Massachusetts--Rhode Island, Martha\'s Vineyard to Block Island /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:12341/2000','ANR-7341','United States Coast Survey.','United States--east coast, New York--New Jersey, Hudson River, Days Point George Washington Bridge /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:12335/2000','ANR-7340','United States Coast Survey.','United States--east coast, New York and New Jersey, Hudson and East rivers, Governors Island to 67th Street /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:12253/2000','ANR-7339','United States Coast Survey.','United States--east coast, Virginia, Norfolk Harbor and Elizabeth River /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:11474/2000','ANR-7338','United States Coast Survey.','United States--east coast, Florida, Bethel Shoal to Jupiter Inlet /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:11325/2000','ANR-7337','United States Coast Survey.','United States--Gulf coast, Texas, Houston Ship Channel, Carpenter Bayou to Houston /');
INSERT INTO new_titles VALUES ('2000/10/10','TA418.9.T45 S77 1999','ANR-3552','Strojny, Angela.','Mechanical characterization of thin films using nanoindentation techniques /');
INSERT INTO new_titles VALUES ('2000/10/10','I 53.2:H 41/KING','ANQ-8409','','King Top Herd Management Area.');
INSERT INTO new_titles VALUES ('2000/10/10','I 49.44/2:B 82/2','ANQ-8419','','Browns Park National Wildlife Refuge : summary of the comprehensive conservation plan.');
INSERT INTO new_titles VALUES ('2000/10/10','QK745 .R44 1996','ANQ-3243','','Regulation of plant growth and development by light : proceedings, 18th annual Riverside Symposium in Plant Physiology,');
INSERT INTO new_titles VALUES ('2000/10/10','I19.81:33080-E 4TF-024/994','ANP-8894','Geological Survey (U.S.)','Saint Paul quadrangle, South Carolina, 1994 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/10','TP155.5 .B75 1999','ANO-7203','Britton, Laurence G., 1951-','Avoiding static ignition hazards in chemical operations /');
INSERT INTO new_titles VALUES ('2000/10/10','Y 4.IN 8/16:R 27/13','ANO-7041','','106-2 Joint Committee Print: Annual Report International Religious Freedom 1999, February 2000');
INSERT INTO new_titles VALUES ('2000/10/10','QP519.9.E433 B69 1998','ANK-7227','Boutchard, Clare Louise.','Electron paramagnetic resonance and optical studies of plant and animal purple acid phosphatases /');
INSERT INTO new_titles VALUES ('2000/10/10','PM 1.10:RI 75-4/999','ANE-3327','','Information for retirees about the Federal Employees Health Benefits Program.');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:11370/999','ANE-3325','United States Coast Survey.','Louisiana, Mississippi River, New Orleans to Baton Rouge /');
INSERT INTO new_titles VALUES ('2000/10/10','C 55.418/7:13274/999','ANE-3326','United States Coast Survey.','Maine--New Hampshire, Massachusetts, Portsmouth Harbor to Boston Harbor /');
INSERT INTO new_titles VALUES ('2000/10/10','KD1125 .L38 1999','ANE-1545','','Law, policy and development in the rural environment /');
INSERT INTO new_titles VALUES ('2000/10/10','KF3030.1 .L44 1998','ANB-0443','Lehman, Bruce A.','The Conference on Fair Use : an interim report to the Commissioner /');
INSERT INTO new_titles VALUES ('2000/10/10','SK325.T8 C58 1996','AMP-3446','Clancy, Gary.','Wild turkey /');
INSERT INTO new_titles VALUES ('2000/10/10','HT241 .C56 1999','AMS-3817','','Cities and the environment : new approaches for eco-societies /');
INSERT INTO new_titles VALUES ('2000/10/02','TS1300 .C53','AHZ-2141','','Chemical fibers international.');
INSERT INTO new_titles VALUES ('2000/10/02','TK7874 .W46 1993','AFR-3448','Weste, Neil H. E.','Principles of CMOS VLSI design : a systems perspective /');
INSERT INTO new_titles VALUES ('2000/10/02','SB354 .S732','AFV-6203','','Handbook of citrus insect control /');
INSERT INTO new_titles VALUES ('2000/10/02','RM1 .A3','AGE-9522','','Inflammation research : official journal of the European Histamine Research Society ... [et al.].');
INSERT INTO new_titles VALUES ('2000/10/02','TS1300 .I668','AFP-7353','','International journal of clothing science and technology.');
INSERT INTO new_titles VALUES ('2000/10/02','S401.U6 A15','AFP-9282','Food and Agriculture Organization of the United Nations. Conference.','Work of FAO.');
INSERT INTO new_titles VALUES ('2000/09/28','E601 .B645 2000','ANY-3594','','Blood : stories of life and death from the Civil War /');
INSERT INTO new_titles VALUES ('2000/09/28','DU28.3 .R45 2000','ANY-3591','','Remembrance of Pacific pasts : an invitation to remake history /');
INSERT INTO new_titles VALUES ('2000/09/28','D804.3 .H6478 2000','ANY-3534','','Holocaust : origins, implementation, aftermath /');
INSERT INTO new_titles VALUES ('2000/09/28','E185 .R22 2000','ANY-3514','','Race and justice /');
INSERT INTO new_titles VALUES ('2000/09/28','E183.8.C5 R52 2000','ANY-3512','Riccards, Michael P.','The presidency and the Middle Kingdom : China, the United States, and executive leadership /');
INSERT INTO new_titles VALUES ('2000/09/28','TR647 .L43 1979','ANY-2756','Institute of Contemporary Art (Boston, Mass.)','Nathan Lerner, a photographic retrospective, 1932-1979.');
INSERT INTO new_titles VALUES ('2000/09/28','QR115 .M45 vol. 6','ANY-2263','International Commission on Microbiological Specifications for Foods.','Microbial ecology of food commodities /');
INSERT INTO new_titles VALUES ('2000/09/28','KF1620.F66 A95 1998','ANY-2029','Altman, Tracy A.','FDA and USDA nutrition labeling guide : decision diagrams, checklists, and regulations /');
INSERT INTO new_titles VALUES ('2000/09/28','TX553.A3 C37 1990','ANY-1488','Cassens, Robert G. (Robert Gene), 1937-','Nitrite-cured meat : a food safety issue in perspective /');
INSERT INTO new_titles VALUES ('2000/09/28','TX518.G65 A3 1996','ANY-1487','Goldblith, Samuel A.','Appetite for life : an autobiography /');
INSERT INTO new_titles VALUES ('2000/09/28','QP86 .P684 1991','ANY-1483','','The Potential for nutritional modulation of aging processes : proceedings of an international conference /');
INSERT INTO new_titles VALUES ('2000/09/28','TX556.M4 S54 1987','ANY-1482','','The Science of meat and meat products /');
INSERT INTO new_titles VALUES ('2000/09/28','PR9396.9.F3 G54 1999','ANY-1063','Farah, Nuruddin, 1945-','Gifts /');
INSERT INTO new_titles VALUES ('2000/09/28','PR9396.9.F3 M3 1999','ANY-1057','Farah, Nuruddin, 1945-','Maps /');
INSERT INTO new_titles VALUES ('2000/09/28','TK5105.875.I57 K54 2000','ANY-1011','Kim, Amy Jo.','Community building on the Web /');
INSERT INTO new_titles VALUES ('2000/09/28','F548.54.D34 C64 2000','ANY-1004','Cohen, Adam (Adam Seth)','American pharaoh : Mayor Richard J. Daley : his battle for Chicago and the nation /');
INSERT INTO new_titles VALUES ('2000/09/28','U163 .V5713 2000','ANY-1002','Virilio, Paul.','The information bomb /');
INSERT INTO new_titles VALUES ('2000/09/28','E185.615 .P43 2000','ANY-0705','Perkins, Spencer, 1954-','More than equals : racial healing for the sake of the gospel /');
INSERT INTO new_titles VALUES ('2000/09/28','E443 .M37 2000','ANY-0673','Martin, Joan Marie.','More than chains and toil : a Christian work ethic of enslaved women /');
INSERT INTO new_titles VALUES ('2000/09/28','F2191.E27 R36 2000','ANY-0667','Ramdin, Ron.','Arising from bondage : a history of the Indo-Caribbean people /');
INSERT INTO new_titles VALUES ('2000/09/28','DA510 .C73 2000','ANY-0666','Conway, Stephen, 1957-','The British Isles and the War of American Independence /');
INSERT INTO new_titles VALUES ('2000/09/28','E169.12 .P59 2000','ANY-0665','Podhoretz, Norman.','My love affair with America : the cautionary tale of a cheerful conservative /');
INSERT INTO new_titles VALUES ('2000/09/28','F549.L87 C48 2000','ANY-0662','Cha-Jua, Sundiata Keita, 1953-','America\'s first Black town : Brooklyn, Illinois, 1830-1915 /');
INSERT INTO new_titles VALUES ('2000/09/29','KFN7596 .A25 2000','ANX-5875','North Carolina. General Assembly. Legislative Research Commission. Committee on State Tort Liability and Immunity.','State tort liability and immunity : report to the 2000 session of the 1999 General Assembly of North Carolina /');
INSERT INTO new_titles VALUES ('2000/10/02','& Span AJJ-7748','ADT-0878','','');
INSERT INTO new_titles VALUES ('2000/09/29','KFN7695 .A25 2000','ANX-5840','North Carolina. General Assembly. Legislative Research Commission. Transportation Finance Committee.','Transportation Finance Committee : report to the 2000 session of the 1999 General Assembly of North Carolina /');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-7234','Berger,Joathan','Landscape Patterns');
INSERT INTO new_titles VALUES ('2000/10/10','L 38.20/2:','AMP-0503','Coal. Underground fatalities (Beckley, W. Va.)','Coal.');
INSERT INTO new_titles VALUES ('2000/10/10','L 38.20/5:','AMF-8105','','Coal ... surface and underground fatalities /');
INSERT INTO new_titles VALUES ('2000/10/10','HE6183.I48 I57 1998','AMF-9174','','Insects & spiders classic collection.');
INSERT INTO new_titles VALUES ('2000/10/10','HD9135 .T63 1940','AMB-6277','','The Tobacco Premier Manufactures, Ltd. offer quality gifts with quality cigarettes & tobacco.');
INSERT INTO new_titles VALUES ('2000/10/10','TL725.3.B8 A87 1929','ALE-9272','Austin Company (Cleveland, OH)','Airports and aviation buildings.');
INSERT INTO new_titles VALUES ('2000/10/10','HD9759.P33 P33 1924','ALE-9273','','Pacific Spruce Corporation and subsidiaries : C.D. Johnson Lumber Company, Manary Logging Company, Pacific Spruce Northe');
INSERT INTO new_titles VALUES ('2000/10/10','SF533 .G85 1933','ALE-9234','Gulf Coast Bee Co.','Why pay cash, 1933.');
INSERT INTO new_titles VALUES ('2000/10/10','TF203 .A85 1915','ALE-9269','Atlas Portland Cement Company.','Concrete in railroad construction; a treatise on concrete for railroad engineers and contractors.');
INSERT INTO new_titles VALUES ('2000/10/10','TS2270 .P84','ALE-9231','','Puffs devoted to the greater enjoyment of pipe smoking.');
INSERT INTO new_titles VALUES ('2000/10/04','D 103.53/7:99/53','AMD-1920','','Technical review of the economic development conveyance for Red River Army Depot, Texas');
INSERT INTO new_titles VALUES ('2000/10/10','SF533 .A22 1918','ALE-9230','A.I. Root Company.','Catlogo ilustrado de los enseres de root para apicultores.');
INSERT INTO new_titles VALUES ('2000/10/10','TS2260 .M55 1895','ALE-9223','Miller, DuBrul & Peters Mfg. Co.','The Miller, DuBrul and Peters Mfg. Co. : manufacturers of cigar molds and cigar machinery.');
INSERT INTO new_titles VALUES ('2000/09/29','KFN7718.5 .A25 2000','ANX-5839','North Carolina. General Assembly. Legislative Research Commission. Telephone Solicitation Committee.','Telephone Solicitation Committee : report to the 2000 session of the 1999 General Assembly of North Carolina /');
INSERT INTO new_titles VALUES ('2000/10/04','MF NC DOCS J3 9:P69e','ALS-0816','','North Carolina plan to prevent heart disease & stroke, 1999-2003 executive summary /');
INSERT INTO new_titles VALUES ('2000/10/04','MF NC DOCS C27 2:Y122','ALS-0812','','Basinwide wetlands and riparian restoration plan for the Yadkin-Pee Dee River Basin');
INSERT INTO new_titles VALUES ('2000/09/29','HF5549.5.G7 N67 2000','ANX-5837','North Carolina. General Assembly. Legislative Research Commission. Committee on Administrative Process for State Employee Grievances.','Administrative process for state employee grievances : report to the 2000 session of the 1999 General Assembly of North');
INSERT INTO new_titles VALUES ('2000/09/29','HG9387 .N67 2000','ANX-5833','North Carolina. General Assembly. Legislative Research Commission. Committee on Mental Health and Chemical Dependency Parity.','Mental health and chemical dependency parity : report to the 2000 session of the 1999 General Assembly of North Carolina');
INSERT INTO new_titles VALUES ('2000/09/29','RC684.E4 N67 2000','ANX-5829','North Carolina. General Assembly. Legislative Research Commission. Committee on Defibrillators--Use and Liability.','Defibrillators--use and liability : report to the 2000 session of the 1999 General Assembly of North Carolina /');
INSERT INTO new_titles VALUES ('2000/09/29','KFN7726 .A25 2000','ANX-5415','North Carolina. General Assembly. Joint Legislative Health Care Oversight Committee.','Joint Legislative Health Care Oversight Committee : report to the 1999 General Assembly (2000 regular session).');
INSERT INTO new_titles VALUES ('2000/09/29','TG24.N82 C2 2000','ANX-5276','','Cabarrus County bridge no. 264 on SR 1745 (Oakwood Ave.) over Branch of Irish Buffalo Creek, federal aid project no. BRS');
INSERT INTO new_titles VALUES ('2000/09/29','TG24.N82 W2 2000b','ANX-5268','','Wake County SR 1108 bridge no. 337 over Norfolk Southern Railway, federal-aid project no. BRZ-1108(5), state project no.');
INSERT INTO new_titles VALUES ('2000/09/29','BL265.M4 N48 1999','ANX-4285','','Neuroscience and the person : scientific perspectives on divine action /');
INSERT INTO new_titles VALUES ('2000/09/29','QA76.87 .B37 2000','ANX-4312','','Basic algorithms and operators /');
INSERT INTO new_titles VALUES ('2000/09/29','GF26 .P43 2000','ANX-4284','','Pedagogy of the earth : education for a sustainable future /');
INSERT INTO new_titles VALUES ('2000/10/02','QL1 .S62','ACO-3024','','Belgian journal of zoology');
INSERT INTO new_titles VALUES ('2000/10/02','RC110 .R47','ACQ-4050','','Clinical infectious diseases : an official publication of the Infectious Diseases Society of America');
INSERT INTO new_titles VALUES ('2000/10/02','&span AJJ 7747','ADS-8973','','');
INSERT INTO new_titles VALUES ('2000/10/02','&span AJG5093','ADT-0851','','');
INSERT INTO new_titles VALUES ('2000/10/02','QK745 .P38','ACL-1545','','PGRSA quarterly');
INSERT INTO new_titles VALUES ('2000/10/02','QH581 .J6','ACM-9923','','Journal of structural biology');
INSERT INTO new_titles VALUES ('2000/10/02','TS1540 .I4','ACN-5934','','International fiber journal');
INSERT INTO new_titles VALUES ('2000/10/02','LA226 .L5','ACO-1252','','Lingua franca');
INSERT INTO new_titles VALUES ('2000/10/02','TS1465 .I55','ACI-3355','','Boletn Intexter del Instituto de Investigacin Textil y de Cooperacin Industrial');
INSERT INTO new_titles VALUES ('2000/10/02','TT490 .B63','ACJ-1083','Bobbin (Columbia, S.C. : 1987)','Bobbin');
INSERT INTO new_titles VALUES ('2000/10/02','[Reference desk] JK2403 .S78','ACK-1059','','State yellow book');
INSERT INTO new_titles VALUES ('2000/10/02','QC851 .A732','ACH-2064','','Theoretical and applied climatology');
INSERT INTO new_titles VALUES ('2000/10/02','SD399.5 .T725','ACG-0221','','Tree physiology');
INSERT INTO new_titles VALUES ('2000/10/02','TP156.P6 J61','ACE-9972','','Journal of polymer science.');
INSERT INTO new_titles VALUES ('2000/10/02','TS1512.5 .F56','ACC-1415','','Flock');
INSERT INTO new_titles VALUES ('2000/10/02','TA418 .G46','ACC-2090','','Geotextiles and geomembranes');
INSERT INTO new_titles VALUES ('2000/10/02','TJ260 .H388','ACB-7855','','Heat and technology Calore e tecnologia.');
INSERT INTO new_titles VALUES ('2000/10/02','QC19.2 .J6','ACB-5679','','Journal of geometry and physics');
INSERT INTO new_titles VALUES ('2000/10/02','RM281 .V33','ABZ-2781','','Vaccine');
INSERT INTO new_titles VALUES ('2000/10/02','SF995 .W43','ABZ-2785','Western Poultry Disease Conference.','Proceedings of the ... Western Poultry Disease Conference');
INSERT INTO new_titles VALUES ('2000/10/02','QC173.96 .C53','ABZ-2696','','Classical and quantum gravity');
INSERT INTO new_titles VALUES ('2000/10/02','QC1 .P391','ABY-1068','','Physica scripta.');
INSERT INTO new_titles VALUES ('2000/10/02','QA76.9.S65 I5','ABY-5533','','IEEE software');
INSERT INTO new_titles VALUES ('2000/10/02','HC103.7 .R398','ABX-4754','','Renewable resources journal');
INSERT INTO new_titles VALUES ('2000/10/02','TS1772 .C284','ABX-8245','','Carpet & floorcoverings review.');
INSERT INTO new_titles VALUES ('2000/10/02','HD9999.C48 A46','ABW-9101','','American drycleaner');
INSERT INTO new_titles VALUES ('2000/10/02','SB4 .A27','ABX-0597','Annual report (Scottish Crop Research Institute)','Annual report /');
INSERT INTO new_titles VALUES ('2000/10/02','QH573 .I49','ABW-4154','','International journal of tissue reactions');
INSERT INTO new_titles VALUES ('2000/10/02','QA273.A1 P76','ABW-2163','Probability and mathematical statistics (Instytut Matematyczny (Polska Akademia Nauk))','Probability and mathematical statistics');
INSERT INTO new_titles VALUES ('2000/10/02','SD59 .R47','ABU-4418','','Revue analytique des publications Analytical review of publications / Department of Forest Research.');
INSERT INTO new_titles VALUES ('2000/10/02','SD15 .M39','ABS-6945','Publicacin (Mexico. Direccin General del Inventario National Forestal)','Publicacin');
INSERT INTO new_titles VALUES ('2000/10/02','QE601 .T392','ABT-7323','Tectonics (Washington, D.C.)','Tectonics');
INSERT INTO new_titles VALUES ('2000/10/02','QC851 .R69','ABQ-4019','','Quarterly journal of the Royal Meteorological Society');
INSERT INTO new_titles VALUES ('2000/10/02','Z7204.A6 P959','ABR-3065','','Psycscan.');
INSERT INTO new_titles VALUES ('2000/10/02','TS1767 .I45','ABR-5773','Interior (Amsterdam, Netherlands)','Interior');
INSERT INTO new_titles VALUES ('2000/10/02','R857.M3 B568','ABQ-1290','','Biomaterials');
INSERT INTO new_titles VALUES ('2000/10/02','QH541.5.S3 M26','ABP-1784','','Marine ecology progress series');
INSERT INTO new_titles VALUES ('2000/10/02','SB951 .N69','ABO-7911','','North Carolina agricultural chemicals manual');
INSERT INTO new_titles VALUES ('2000/10/02','HD9940.U3 A60','ABO-0626','','Apparel industry magazine');
INSERT INTO new_titles VALUES ('2000/10/02','HD9940.N45 A66','ABO-5997','Apparel (Auckland, N.Z.)','Apparel');
INSERT INTO new_titles VALUES ('2000/10/02','S15 .P58','ABM-8794','Pesquisa agropecuria brasileira (Braslia, Brazil : 1977)','Pesquisa agropecuria brasileira');
INSERT INTO new_titles VALUES ('2000/10/02','SF971 .A450','ABM-4561','American Association of Swine Practitioners.','Proceedings - American Association of Swine Practitioners');
INSERT INTO new_titles VALUES ('2000/10/02','LC3993.9 .J68','ABK-6438','','Journal for the education of the gifted publication of the Association for the Gifted.');
INSERT INTO new_titles VALUES ('2000/10/02','[Reference Desk] JK1010 .C68','ABJ-4611','','Congressional yellow book');
INSERT INTO new_titles VALUES ('2000/10/02','TS1300 .I52','ABI-4444','Industrie textile (Paris, France)','L\'Industrie textile');
INSERT INTO new_titles VALUES ('2000/10/02','S912 .F6','ABG-8652','Fontana Conservation Roundup.','Proceedings');
INSERT INTO new_titles VALUES ('2000/10/02','SF105 .P750','ABG-1068','Proceedings of the annual meeting (Society for Theriogenology (U.S.)).','Proceedings of the annual meeting');
INSERT INTO new_titles VALUES ('2000/10/02','QM1 .J68','ABC-0224','','Journal of anatomy');
INSERT INTO new_titles VALUES ('2000/10/02','HD101 .C35','ABC-0309','Canadian Agricultural Economics Society. Workshop.','Report of the ... Canadian Agricultural Economics Society Workshop');
INSERT INTO new_titles VALUES ('2000/10/02','AI1 .H8','ABC-0126','','Humanities index.');
INSERT INTO new_titles VALUES ('2000/10/02','TT490 .B62a','ABC-0103','','Body fashions/Intimate apparel');
INSERT INTO new_titles VALUES ('2000/10/02','QE500 .G37','AAZ-2077','','Geophysical research letters');
INSERT INTO new_titles VALUES ('2000/10/02','TA593.A2 P5','ABB-9968','','Photogrammetric engineering and remote sensing');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.13:RCED/AIMD-00-2','ANE-3170','United States. General Accounting Office.','Forest Service a framework for improving accountability : report to the Subcommittee on Interior Related Agencies, Commi');
INSERT INTO new_titles VALUES ('2000/10/02','QD71 .R44','AAZ-1801','','Reviews in analytical chemistry.');
INSERT INTO new_titles VALUES ('2000/10/02','QR360 .J68','AAZ-1333','','Journal of virology');
INSERT INTO new_titles VALUES ('2000/10/02','QC175 .J65','AAZ-1351','','Journal of statistical physics');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.13:AIMD-99-190 R','ANE-2925','United States. General Accounting Office. Accounting and Information Management Division.','Year 2000 computing crisis actions needed to ensure continued delivery of veterans benefits and health care services /');
INSERT INTO new_titles VALUES ('2000/09/29','QA76.76.H94 S74 2000','ANB-9412','Navarro, Ann.','HTML by example /');
INSERT INTO new_titles VALUES ('2000/09/29','GA 1.13:LCD-78-333','AKV-4992','United States. General Accounting Office.','New Senate office building : escalated costs and delayed completion : report to the Congress /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.88:PNW-GTR-488','ANW-5002','Thysell, David R.','Effects of forest management on understory and overstory vegetation : a retrospective study /');
INSERT INTO new_titles VALUES ('2000/10/18','HD58.5 .J66 1999','ANS-5004','Jonash, Ronald S.','The innovation premium : how next generation companies are achieving peak performance and profitability /');
INSERT INTO new_titles VALUES ('2000/10/18','PT401 .B47 2000','ANS-4122','Bernstein, Michael Andr, 1947-','Five portraits : modernity and the imagination in twentieth-century German writing /');
INSERT INTO new_titles VALUES ('2000/10/18','QK315 .T87 1993','ANS-1368','Turland, N. J. (Nick J.)','Flora of the Cretan area : annotated checklist & atlas /');
INSERT INTO new_titles VALUES ('2000/10/18','QL555.G7 S62 1997','ANS-1361','Smith, F. H. N. (Frank H. N.), 1924-','The moths and butterflies of Cornwall and the Isles of Scilly /');
INSERT INTO new_titles VALUES ('2000/10/18','[DVD] PN1993.5.I829 P79 1998','ANR-4663','','Professor');
INSERT INTO new_titles VALUES ('2000/10/18','QL555.G7 D47 1996','ANS-1360','Dennis, R. L. H.','Butterflies on British and Irish offshore islands : ecology and biogeography /');
INSERT INTO new_titles VALUES ('2000/10/18','[DVD] PN1993.5.I829 C58 1998','ANR-4654','','C.I.D.');
INSERT INTO new_titles VALUES ('2000/10/18','[DVD] PN1993.5.I829 M45 1999','ANR-4660','','Mehndi');
INSERT INTO new_titles VALUES ('2000/10/18','[DVD] PN1993.5.I829 A247 1999','ANR-4646','','Aap ki khatir');
INSERT INTO new_titles VALUES ('2000/10/18','[DVD] PN1993.5.I829 A248 1998','ANR-4649','','Aap ki parchhaiyan');
INSERT INTO new_titles VALUES ('2000/10/18','[DVD] PN1993.5.I829 E49 2000','ANR-4634','','Ek yaad Rafi ke baad');
INSERT INTO new_titles VALUES ('2000/10/18','[DVD] PN1993.5.I829 N66 1998','ANR-4636','','Non stop Kajol-Karishma');
INSERT INTO new_titles VALUES ('2000/10/18','[DVD] PN1993.5.I829 P385 1998','ANR-4622','','Patita');
INSERT INTO new_titles VALUES ('2000/10/18','TA418.9.L3 A16 1999','AND-7704','','3-D textile reinforcements in composite materials /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-509','ANC-9393','Weigand, James F.','Composition, volume, and prices for major softwood lumber types in western Oregon and Washington, 1971-2020');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-506','ANB-8326','','A pilot experiment of forest fertilization during an outbreak of the western spruce budworm in northeastern Oregon');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-505','ANB-3316','Mead, Bert R.','Phytomass in southeast Alaska');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.79:PNW-RN-525','ANB-2742','Cochran, P. H.','Examples of mortality and reduced annual increments of white fir induced by drought, insects, and disease at different s');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-504','ANB-2482','Amaranthus, Michael P.','Soil compaction after yarding of small-diameter Douglas-Fir with a small tractor in southwest Oregon');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-503','ANB-2133','Cochran, P. H.','Lodgepole pine development after early spacing in the Blue Mountains of Oregon');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-501','ANA-0086','Werner, Richard A. (Richard Allen), 1936-','Dispersal of the spruce beetle, Dendroctonus rufipennis, and the engraver beetle, Ips perturbatus, in Alaska');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-502','AMZ-9140','Cochran, P. H.','Thirty-five-year growth of thinned and unthinned ponderosa pine in the Methow Valley of northern Washington');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-484','AMZ-5974','','Historical patterns of western spruce budworm and Douglas-fir tussock moth outbreaks in the northern Blue Mountains, Ore');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-490','AMZ-4676','Miller, Richard E.','Ammonium nitrate, urea, and biuret fertilizers increase volume growth of 57-year-old Douglas-fir trees within a gradient');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-497','AMZ-4274','Bull, Evelyn L.','Tailed frogs distribution, ecology, and association with timber harvest in northeastern Oregon /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-492','AMZ-1496','Schmidt, Fred H.','Instar discrimination of field-collected larvae through analysis of frequency distribution curves of head capsule widths');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-498','AMZ-1357','Willson, Mary F.','Variation in salmonid life histories patterns and perspectives /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-499','AMY-7833','Ferguson, Sue A.','A climate-change scenario for the Columbia River Basin');
INSERT INTO new_titles VALUES ('2000/09/29','DA47.9.I73 S65 2000','ANX-4233','Smith, Jeremy, 1965-','Britain and Ireland : from home rule to independence /');
INSERT INTO new_titles VALUES ('2000/09/29','PK2098.39.M49939 S26 1999','ANX-3620','Simha, Punni, 1939-','Saharana /');
INSERT INTO new_titles VALUES ('2000/09/29','QH87.3 .H86 2000','ANX-0479','Hunt, William F.','Designing stormwater wetlands for small watersheds /');
INSERT INTO new_titles VALUES ('2000/09/29','TS1120.5 .A93 1999','ANX-0287','','Availability, performance, and cost of recycled paper /');
INSERT INTO new_titles VALUES ('2000/09/29','TD899.F585 F34 2000','ANX-0275','','A fact sheet for licensed garbage feeders.');
INSERT INTO new_titles VALUES ('2000/09/29','TD899.F585 F345 1999','ANX-0276','','A fact sheet for managing food materials.');
INSERT INTO new_titles VALUES ('2000/09/29','F254 .N964 1998','ANX-0260','','[North Carolina information sheet].');
INSERT INTO new_titles VALUES ('2000/09/29','TG24.N82 A7 2000','ANX-0238','Williams, John L. (John Lawrence), 1968-','Ashe County bridge no. 38 on SR 1603 over Cranberry Creek, federal project MABRZ-1603(1), state project 8.2711201, TIP n');
INSERT INTO new_titles VALUES ('2000/09/29','TG24.N82 W2 2000','ANX-0229','Orthner, Karen T.','Wake County bridge no. 124 on SR 2006 over Perry Creek, federal project BRZ-2006 (1), state project 8.2406901, TIP no. B');
INSERT INTO new_titles VALUES ('2000/09/29','TG24.N82 W5 2000','ANX-0217','Orthner, Karen T.','Watauga County bridge no. 209 on SR 1508 over Laurel Creek, federal project BRZ-1508 (2), state project 8.2751501, TIP n');
INSERT INTO new_titles VALUES ('2000/09/29','TD 2.30:00-085','ANW-9381','','Key findings from LTPP analysis, 1990-1999');
INSERT INTO new_titles VALUES ('2000/09/29','TG24.N82 D4 2000','ANW-9653','Pipkin, Dennis','Davidson County, bridge no. 135 on NC 109 over Abbott\'s Creek federal aid project no. BRZNHS-109(2), state project no. 8');
INSERT INTO new_titles VALUES ('2000/09/29','Y 3.P 31:2 C 29','ANW-9367','','Herding cats multiparty mediation in a complex world /');
INSERT INTO new_titles VALUES ('2000/09/28','Course Shelf','ANZ-4705','','HI597 Vincent readings: Week 8: Quentin Skinner. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/09/28','Course Shelf','ANZ-4703','','HI597 Vincent readings: Week 8: Roland Stromberg. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/09/28','','ANZ-4699','McGee, Lynn','Communication Channels Used by Technical Writers Throughout the Documentation Process');
INSERT INTO new_titles VALUES ('2000/09/28','Course Shelf','ANZ-4701','','HI597 Vincent readings, Week 8: Keith Baker. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/09/28','','ANZ-4697','Kent-Drury, Roxanne','Bridging Boundaries, Negotiating Differences: The Nature of Leadership in Cross-functional Proposal-writing Groups');
INSERT INTO new_titles VALUES ('2000/09/28','','ANZ-4695','Marchwinski, Theresa and Karen Mandziuk','Technical Communicator\'s Role in Initiating Cross-functional Teams');
INSERT INTO new_titles VALUES ('2000/09/28','Desk File','ANZ-4691','','MA351 Hartwig notebook. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/09/28','','ANZ-4693','Robey, Daniel et al','Situated Learning in Cross-functional Virtual Teams');
INSERT INTO new_titles VALUES ('2000/09/28','','ANZ-4683','Marie de France','Yonec');
INSERT INTO new_titles VALUES ('2000/09/28','Course Shelf','ANZ-4681','','HI597 Vincent readings, Week #7: Article by Clifford Geertz. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/09/28','Course Shelf','ANZ-4678','','HI597 Vincent readings, Week #7: Article by Roger Chartier. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/09/28','Desk File','ANZ-4675','','MAE435 Ro notebook. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/09/28','Course Shelf','ANZ-4673','Katz, Daniel.','Social psychology of organization, Chapter 2. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/04','MF NC DOCS C27 2:W582','ALS-0810','','Basinwide wetlands and riparian restoration plan for the White Oak River Basin');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-488','AMY-7606','Hoyer, Gerald E.','Levels-of-growing-stock cooperative study in Douglas-fir');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-489','AMY-7538','McKenzie, Donald.','Predicting the effect of fire on large-scale vegetation patterns in North America');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-486','AMY-3285','','Smoke emissions from prescribed burning of southern California chaparral');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-491','AMY-1288','Beardsley, Debby.','Old growth in northwestern California national forests');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-494','AMY-3150','','Soil compaction and organic matter affect conifer seeding nonmycorrhizal and ectomycorrhizal root tip abundance and dive');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-496','AMY-0014','Meehan, William R.','Influence of riparian canopy on macroinvertebrate composition and food habits of juvenile salmonids in several Oregon st');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-495','AMX-8292','','The Forest and Agricultural Sector Optimization Model (FASOM) model structure and policy applications /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-493','AMY-0012','','The Pacific Northwest region vegetation and inventory monitoring system');
INSERT INTO new_titles VALUES ('2000/10/18','RC451.4.P68 B74 1998','AMX-2363','','Breaking the rules : women in prison and feminist therapy /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-485','AMV-7811','Curtis, Robert O.','Extended rotations and culmination age of coast Douglas-fir old studies speak to current issues /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-483','AMT-7250','Cochran, P. H.','Growth and mortality of ponderosa pine poles thinned to various densities in the Blue Mountains of Oregon');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-473','AMS-9716','Stein, William I.','Ten-year development of Douglas-fir and associated vegetation after different site preparation on Coast Range clearcuts');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-482','AMS-9714','Miller, Richard E.','Stand characteristics of 65-year-old planted and naturally regenerated stands near Sequim, Washington');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-480','AMS-9712','Harmon, Janice M.','Seed rain and seed bank of third- and fifth-order streams on the western slope of the Cascade Range');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-477','AMS-0362','Mead, Bert R.','Plant biomass in the Tanana River basin, Alaska');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-481','AMS-0336','Little, Susan N.','Biomass and nutrient distributions in central Oregon second-growth Ponderosa pine ecosystems');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-478','AMS-0114','Raettig, Terry L.','Hardwood supply in the Pacific Northwest a policy perspective /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-464','AMR-0321','Castellano, Michael A.','Ecological impacts of using chloropicrin to control laminated root rot in northwest conifer forests growth and mycorrhiz');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-469','AMR-0059','Grimble, David G.','New lepidoptera records for the Blue Mountains of eastern Oregon');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-475','AMQ-9450','Curtis, Robert O.','Levels-of-growing-stock cooperative study in Douglas-fir');
INSERT INTO new_titles VALUES ('2000/10/18','TL23 .H65 1991','AMQ-2114','Holder, William G., 1937-','American muscle cars /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-479','AMQ-8449','','Using expert opinion to evaluate a habitat effectiveness model for elk in western Oregon and Washington');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-476','AMP-7049','Sohngen, Brent L.','The \"great\" price spike of \'93 an analysis of lumber and stumpage prices in the Pacific Northweat /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-474','AMP-6869','Reaves, Jimmy L.','In vitro interactions among species of Trichoderma with inference toward biological control');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-472','AMP-6861','Sorensen, Frank C.','Genetic variation and seed transfer guidelines for ponderosa pine in central Oregon');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-471','AMO-0766','Curtis, Robert O.','Some simulation estimates of mean annual increment of Douglas-fir results, limitations, and implications for management');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-470','AMO-0764','Sohngen, Brent L.','Hardwood price reporting');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-468','AMM-9368','Sorensen, Frank C.','Genetic variation and seed transfer guidelines for ponderosa pine in the Ochoco and Malheur National Forests of central');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-466','AMM-8026','Holsten, Edward H.','Effectiveness of polyethtylene sheeting in controlling spruce beetles (Coleoptera: Scolytidae) in infested stacks of spr');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-465','AMM-7072','Werner, Richard A. (Richard Allen), 1936-','Response of the engraver beetle, Ips Perturbatus, to semiochemicals in white spruce stands of interior Alaska');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-463','AMM-4527','Campbell, Robert W.','Population dynamics of the major North American needle-eating budworms');
INSERT INTO new_titles VALUES ('2000/10/18','I 19.42/4:90-4161','AMI-7883','Mack, Thomas J.','Geohydrology and water quality of stratified-drift aquifers in the Bellamy, Cocheco, and Salmon Falls river basins, sout');
INSERT INTO new_titles VALUES ('2000/10/18','I 19.42/4:90-4085','AMI-7187','Cline, Denzel R.','Ground-water pumpage from the Columbia Plateau, Washington and Oregon, 1945 to 1984 /');
INSERT INTO new_titles VALUES ('2000/10/18','L 2.121/13:C 43/','AMD-5711','','Occupational compensation survey--pay and benefits.');
INSERT INTO new_titles VALUES ('2000/10/18','L 2.121/9:M 58/','AME-0301','','Occupational compensation survey--pay only.');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-451-462','AMI-0277','Lopushinsky, W.','Early survival and height growth of Douglas-fir and lodgepole pine seedlings and variations in site factors following tr');
INSERT INTO new_titles VALUES ('2000/10/18','[Microfiche] L 2.121/9:M 58/','ALM-9068','','Area wage survey.');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-327-349','ALI-3164','Dale, Virginia H.','CLIMACS : a computer model of forest stand development for western Oregon and Washington /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-326','ALI-3162','Farr, Wilbur A.','Site index and height growth curves for unmanaged even-aged stands of western hemlock and sitka spruce in southeast Alas');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-325','ALI-3160','','Growth and yield of sitka spruce and western hemlock at Cascade Head Experimental Forest, Oregon /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-321','ALG-7130','Howard, James O., 1915-','Estimators and characteristics of logging residue in Montana /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-320','ALG-7128','Plank, Marlin E.','Lumber recovery from insect-killed lodgepole pine in the northern Rocky Mountains /');
INSERT INTO new_titles VALUES ('2000/10/02','RC321 .J865','AAZ-1326','','Journal of the neurological sciences');
INSERT INTO new_titles VALUES ('2000/10/02','SD14.N6 A3','AAZ-1062','Bulletin (Nova Scotia. Dept. of Lands and Forests)','Bulletin /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-310','ALG-3690','Seidel, Kenneth W.','Regeneration in mixed conifer partial cuttings in the Blue Mountains of Oregon and Washington /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-322','ALE-7920','Waddell, Dale R.','Estimating tree bole and log weights from green densities measured with the Bergstrom xylodensimeter /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-318','ALE-7918','Aho, Paul E.','Losses associated with Douglas-fir and true fir tops killed by western spruce budworm in eastern Washington /');
INSERT INTO new_titles VALUES ('2000/10/18','ML63 .K44 2000','AOE-6752','Kelly, Thomas Forrest.','First nights : five musical premieres /');
INSERT INTO new_titles VALUES ('2000/10/18','TJ246 .I55 2000','AOE-5457','International Conference on Fluid Sealing (16th : 2000 : Brugge, Belgium)','16th International Conference on Fluid Sealing : papers presented at the 16th International Conference on Fluid Sealing,');
INSERT INTO new_titles VALUES ('2000/10/18','TJ1045 .B38 2000','AOE-5436','Bath Workshop on Power Transmission and Motion Control (2000 : Centre for Power Transmission and Motion Control, University of Bath)','Bath Workshop on Power Transmission and Motion Control : (PTMC 2000) /');
INSERT INTO new_titles VALUES ('2000/10/18','[Sound cass.] HC79.E5 M395 1999','AOE-5103','McKibben, Bill.','Livable cities creating sustainable urban environments /');
INSERT INTO new_titles VALUES ('2000/10/18','[Sound cass.] TJ808 .N33 1999','AOE-5098','Nader, Ralph.','Renewable energy');
INSERT INTO new_titles VALUES ('2000/10/18','[Sound cass.] HC79.E5 S42 1996','AOE-5087','Shiva, Vandana.','\"The Recovery of the commons\"');
INSERT INTO new_titles VALUES ('2000/10/18','[Sound cass.] HC79.E5 N66 1999','AOE-5081','Norberg-Hodge, Helena.','\"Resisting monoculture, rebuilding community\"');
INSERT INTO new_titles VALUES ('2000/10/18','PN1997.B764 S6 1974','AOC-5306','Sontag, Susan, 1933-','Brother Carl; a filmscript /');
INSERT INTO new_titles VALUES ('2000/10/18','LB1025.3 .T438 2000','ANZ-5169','','Teaching practices and student achievement : report of first-year findings from the \"Mosaic\" study of systemic initiativ');
INSERT INTO new_titles VALUES ('2000/10/18','HD39.5 .S95 2000','ANZ-4920','Szuprowicz, Bohdan O., 1931-','Supply chain management for e-business infrastructures /');
INSERT INTO new_titles VALUES ('2000/10/18','HF5548.32 .P53 2000','ANZ-4918','Pickering, Chris.','E-business success strategies : achieving business and IT alignment /');
INSERT INTO new_titles VALUES ('2000/10/18','HF5548.32 .C347 2000','ANZ-4916','Cameron, Debra.','Reengineering business for success in the Interent age : business-to-business E-commerce strategies /');
INSERT INTO new_titles VALUES ('2000/10/18','HF5548.32 .C345 2000','ANZ-4917','Callaway, Erin.','ERP--the next generation : ERP is web enabled for e-business /');
INSERT INTO new_titles VALUES ('2000/10/18','QA76.9.D37 K56 2000','ANZ-4915','King, Elliot, 1953-','Data warehousing and data mining : implementing strategic knowledge management /');
INSERT INTO new_titles VALUES ('2000/10/18','HF5548.32 .S97 1999','ANZ-4914','Szuprowicz, Bohdan O., 1931-','E-commerce : implementing global marketing strategies /');
INSERT INTO new_titles VALUES ('2000/10/18','HD30.28 .C347 1999','ANZ-4911','Callaway, Erin.','Enterprise resource planning : integrating applications and business processes across the enterprise /');
INSERT INTO new_titles VALUES ('2000/10/18','GB1025.P4 B35 1996','ANZ-4774','Balmer, Wayne T.','Groundwater resources of Delaware County, Pennsylvania /');
INSERT INTO new_titles VALUES ('2000/10/18','NA1353.A83 A84 2000','ANZ-4613','','Atelier 5 /');
INSERT INTO new_titles VALUES ('2000/10/18','NA735.N5 S49 2000','ANZ-4577','Silver, Nathan.','Lost New York /');
INSERT INTO new_titles VALUES ('2000/10/18','NA2708 .C66 2001','ANZ-4592','Cooper, Douglas, 1946-','Drawing and perceiving : life drawing for students of architecture and design /');
INSERT INTO new_titles VALUES ('2000/10/18','NA4850 .H57 2000','ANZ-4527','Hiscock, Nigel, 1940-','The wise master builder : Platonic geometry in plans of medieval abbeys and cathedrals /');
INSERT INTO new_titles VALUES ('2000/10/18','NA1011.5.R53 C49 2000','ANZ-3925','Chramosta, Walter M., 1956-','Helmut Richter : buildings and projects = Bauten und Projekte /');
INSERT INTO new_titles VALUES ('2000/10/18','NA3310 .B76 2000','ANZ-3889','Brolin, Brent C.','Architectural ornament : banishment and return /');
INSERT INTO new_titles VALUES ('2000/10/18','B945.R524 R673 2000','ANZ-3858','','Rorty and his critics /');
INSERT INTO new_titles VALUES ('2000/10/18','PS153.N5 A335 2000','ANZ-3840','','African American literary theory : a reader /');
INSERT INTO new_titles VALUES ('2000/10/18','KF4749 .M39 2000','ANZ-3845','McAffee, Thomas B., 1952-','Inherent rights, the written constitution, and popular sovereignty : the founders\' understanding /');
INSERT INTO new_titles VALUES ('2000/10/18','PS3561.E3755 Z89 2000','ANZ-3836','Songer, Marcia, 1936-','Garrison Keillor : a critical companion /');
INSERT INTO new_titles VALUES ('2000/10/18','PN849.U43 G65 2000','ANZ-3835','','Going global : the transnational reception of Third World women writers /');
INSERT INTO new_titles VALUES ('2000/10/18','PR9387.9.A3 T52398 2000','ANZ-3832','Egar, Emmanuel Edame.','The rhetorical implications of Chinua Achebe\'s Things fall apart /');
INSERT INTO new_titles VALUES ('2000/10/18','HT608 .R46 2000','ANZ-3396','','Renewing class analysis /');
INSERT INTO new_titles VALUES ('2000/10/18','E89.5 .E84 2000','ANZ-3378','','Here first : autobiographical essays by Native American writers /');
INSERT INTO new_titles VALUES ('2000/10/18','D809.U45 D96 2000','ANZ-3152','Dyczok, Marta, 1963-','The Grand Alliance and Ukrainian refugees /');
INSERT INTO new_titles VALUES ('2000/10/18','CC72.4 .C43 2000','ANZ-3150','','Gender and material history in archaeological perspective /');
INSERT INTO new_titles VALUES ('2000/10/18','DR1282 .P37 2000','ANZ-3149','Pavkovic, Aleksandar.','The fragmentation of Yugoslavia : nationalism and war in the Balkans /');
INSERT INTO new_titles VALUES ('2000/10/18','JC261 .P37 2000','ANZ-3148','Patton, Paul.','Deleuze and the political /');
INSERT INTO new_titles VALUES ('2000/10/18','JN33.5 .A7 2000','ANZ-3146','','At the heart of the Union : studies of the European Commission /');
INSERT INTO new_titles VALUES ('2000/10/18','QC173.98 .D83 2000','ANZ-3143','Duck, Ian, 1933-','100 years of Planck\'s Quantum /');
INSERT INTO new_titles VALUES ('2000/10/17','Desk File','AOE-7489','','ENG221//FL221 Gross readings. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7466','Bonnell, Victoria E.','Emergence of Staliniana / Ch.6: The Apotheosis of Stalinist Political Art');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7458','Fitzgerald, Robert, trans.','Fateful Haven (Book 1)');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7461','Fitzgerald, Robert, trans.','How They Took the City (Book 2)');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7464','Fitzgerald, Robert, trans.','Passion of the Queen (Book 4)');
INSERT INTO new_titles VALUES ('2000/10/17','LT4210.H37 F37 2000','AOE-7422','Farr, Roger C.','Collections. a Harcourt reading ; language arts program.');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7385','Lewis, Ricki','Genomics (Ch.21)');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7380','Lewis, Ricki','Reproductive Technologies (Ch.20)');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7377','Lewis, Ricki','Agricultural Biotechnology (Ch.19)');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7371','Lewis, Ricki','Gene Therapy and Genetic Counseling (Ch.18)');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7369','Lewis, Ricki','Genetic Engineering (Ch.17)');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7364','Ahern, Jack','Integration of Landscape Ecology and Landscape Design: an Evolutionary Process');
INSERT INTO new_titles VALUES ('2000/10/17','I 19.81:38077-B 4-TF-024/999','AOE-7340','Geological Survey (U.S.)','Guinea quadrangle, Virginia : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/17','I 19.81:38077-B 2-TF-024/999','AOE-7339','Geological Survey (U.S.)','Port Royal quadrangle, Virginia : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/17','[Microfiche] Y 3.F 31/8:2 B 22/7/','AOE-7329','','Trust assets of banks and trust companies.');
INSERT INTO new_titles VALUES ('2000/10/17','Y 3.F 31/8:23/','AOE-7330','Federal Deposit Insurance Corporation.','Trust assets of insured commercial banks.');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7279','Carolan, Trevor','About The Translators.');
INSERT INTO new_titles VALUES ('2000/10/17','LT4210.H37 F37 2000','AOE-7295','Farr, Roger C.','Collections. a Harcourt reading ; language arts program.');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7275','Stewart, Bruce','Broken Arse.');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7273','Wongar, B.','The Family.');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7271','Situmorang, Sitor.','Holy Communion.');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7258','Krailat, Kon.','In The Mirror.');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7262','Tien, Nhat','In The Footsteps of a Water Buffalo.');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7266','Lim, Catherine.','The English Language Teacher\'s Secret.');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7237','Yang, Bo','Dragon-Eye Rice Gruel.');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7239','Jose, F.Sionil','Progress.');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7242','Lim, Shirley Geok-lin','Mr.Tang\'s Girls.');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7229','Carolan, Trevor','Introduction');
INSERT INTO new_titles VALUES ('2000/10/17','','AOE-7234','O Chong-Hui','Chinatown.');
INSERT INTO new_titles VALUES ('2000/10/17','I 19.81:34077-E 3-TF-024/997','AOE-6675','Geological Survey (U.S.)','New River Inlet quadrangle, North Carolina--Onslow Co., 1997 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/17','I 19.81:33080-G 7-TF-024/994','AOE-6673','Geological Survey (U.S.)','Gadsden quadrangle, South Carolina : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/17','I 19.81:35081-B 1-TF-024/997','AOE-6672','Geological Survey (U.S.)','Belmont quadrangle, North Carolina--South Carolina : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/17','I 19.81:38077-B 3-TF-024/994','AOE-6670','Geological Survey (U.S.)','Rappahannock Academy quadrangle, Virginia /');
INSERT INTO new_titles VALUES ('2000/10/17','RC521 .A33 2000','AOE-6225','','Advances in dementia research /');
INSERT INTO new_titles VALUES ('2000/10/17','TA405 .M888 2000','AOE-6209','','Multiscale phenomena in materials : experiments and modeling : symposium held November 30-December 2, 1999, Boston, Mass');
INSERT INTO new_titles VALUES ('2000/10/17','[sound cass.] GE180 .B85 1992','AOE-5113','Bullard, Robert.','Environmental racism');
INSERT INTO new_titles VALUES ('2000/10/17','[sound cass.] GE180 .B76 1993','AOE-5108','Brower, David J.','\"Visions of the environmental movement\"');
INSERT INTO new_titles VALUES ('2000/10/17','C 55.418/7:12339/2000','AOE-4867','','United States - East Coast, New York, East River, Tallman Island To Queensboro Bridge, 12339, July 15, 2000');
INSERT INTO new_titles VALUES ('2000/10/17','C 55.418/7:11323/2000','AOE-4866','','United States - Gulf Coast, Texas, Approaches To Galveston Bay, 11323, Loran-C, June 24, 2000');
INSERT INTO new_titles VALUES ('2000/10/17','PREX 3.10/4:W 89/51','AOE-4825','','Political Map of the World, 802683AI R00349), April 2000');
INSERT INTO new_titles VALUES ('2000/10/17','C 55.418/7:11300/2000','AOE-4865','','United States - Gulf Coast, Galveston To Rio Grande, 11300, Loran-C, June 24, 2000');
INSERT INTO new_titles VALUES ('2000/10/17','PREX 3.10/4:W 89/50','AOE-4824','','Standard Time Zones of The World, 802700AI (R02183), April 2000');
INSERT INTO new_titles VALUES ('2000/10/17','PREX 3.10/4:W 89/49','AOE-4822','','Physical Map of the World, 802701AI (R00349), April 2000');
INSERT INTO new_titles VALUES ('2000/10/17','PREX 3.10/4:OC 2/9','AOE-4821','','Oceania, 802697AI (R02111), April 2000');
INSERT INTO new_titles VALUES ('2000/10/17','PREX 3.10/4:D 39/3','AOE-4820','','Central Africa, 802693AI (R02414), April 2000');
INSERT INTO new_titles VALUES ('2000/10/17','PREX 3.10/4:C 33 A 21','AOE-4819','','Central America and The Caribbean, 802686AI (R02068), April 2000');
INSERT INTO new_titles VALUES ('2000/10/17','HH 1.2:B 86/17','AOE-4818','','Awards Best Practices 2000');
INSERT INTO new_titles VALUES ('2000/10/17','D 114.19:AR 7','AOE-4817','','Eyes of Artillery, The Origins of Modern U.S. Army Aviation in World War II, Army Historical Series, 2000');
INSERT INTO new_titles VALUES ('2000/10/17','C 55.22/2:ST 7/997','AOE-4815','National Geophysical Data Center.','The most intense tropical storms of 1997');
INSERT INTO new_titles VALUES ('2000/10/17','C 55.22/2:ST 7/998','AOE-4816','National Geophysical Data Center.','The most intense tropical storms of 1998');
INSERT INTO new_titles VALUES ('2000/10/17','I 19.42/4:99-4240','AOE-4814','','Sediment Accumulation and Water Volume in Loch Raven Reservoir, Baltimore County, Maryland, U.S. Geological Survey, Wat');
INSERT INTO new_titles VALUES ('2000/10/17','QA241 .A43 2000','AOD-5459','','Algorithmic number theory : 4th international symposium, ANTS-IV, Leiden, the Netherlands, July 2-7, 2000 : proceedings');
INSERT INTO new_titles VALUES ('2000/10/17','R723 .P455 2000','AOC-3124','','The philosophy of medicine : framing the field /');
INSERT INTO new_titles VALUES ('2000/10/17','[DVD] PN1993.5.I829 S24 2000','AOB-9055','','Safar');
INSERT INTO new_titles VALUES ('2000/10/17','QC176.8.M46 S58 1999','AOC-3105','Sitges Conference on Statistical Mechanics (16th : Spain : 1999)','Statistical and dynamical aspects of mesoscopic systems : proceedings of the XVI Sitges Conference on Statistical Mechan');
INSERT INTO new_titles VALUES ('2000/10/17','HN380.7.Z9 C69 2000','AOA-4426','World Bank.','Rural, environment, and social development strategies for the Eastern Europe and Central Asia region : Prague, June 29,');
INSERT INTO new_titles VALUES ('2000/10/17','HC244 .W667 2000','ANZ-5243','World Bank.','Making transition work for everyone : poverty and inequality in Europe and Central Asia.');
INSERT INTO new_titles VALUES ('2000/10/17','HC244.Z9 E59 2000','ANZ-5239','World Bank.','Natural resource management strategy : Eastern Europe and Central Asia.');
INSERT INTO new_titles VALUES ('2000/10/17','JN96.A56 C62 2000','ANZ-5238','','Anticorruption in transition : a contribution to the policy debate.');
INSERT INTO new_titles VALUES ('2000/10/17','RA395.A4 C238 2000','ANZ-5134','','California health report /');
INSERT INTO new_titles VALUES ('2000/10/17','HC59.72.P6 C79 2000','ANZ-5125','','Crying out for change : voices of the poor /');
INSERT INTO new_titles VALUES ('2000/10/17','HC240.25.E852 T35 2000','ANZ-5124','Tang, Helena, 1958-','Progress towards the unification of Europe /');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5366','Soroos, Marvin','Revised Syllabus');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5362','The Nature Conservancy','The Nature Conservancy preserve directory');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5359','Barbercheck, Mary.','Mixed Messages: Men and Women in Advertisements in Science.');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5357','USDA, NRCS','Ponds : planning, design, construction');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5354','Woodlanders, Inc.','Woodlander\'s descriptive catalog no. 2');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5352','Biggs, Walter C., Jr. and James F. Parnell','State parks of North Carolina');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5347','Wharton, Charles H.','The natural environments of Georgia');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5349','Roe, Charles E.','A directory to North Carolina\'s natural areas');
INSERT INTO new_titles VALUES ('2000/10/10','','AOE-5341','Perry, Ruth.','Engendering Environmental Thinking: A Feminist Analysis of the Present Crisis.');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4502','Toperoff, Sam','Tarantula');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4504','Tagore, Rabindranath','Postmaster');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4506','Wright, Richard','Bright and Morning Star');
INSERT INTO new_titles VALUES ('2000/10/09','Desk File','AOE-4498','','MA107 Williams notebook. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4500','Leiner, Marvin','Homosexual in the Revolution (Ch.2)');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4493','National Geographic','Water');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4491','Reid, George K.','Pond life');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4487','Papanek, Victor','The green imperative');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4485','Earley, Lawrence S., ed.','North Carolina wild places');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4482','Schafale, Michael P. and Alan S. Weakley','Classification of the natural communities of North Carolina : third approximation');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4479','Wrightsman, Lawrence S.','Insanity and Competency (Ch.10)');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4476','VanDeVeer, Donald and Christine Pierce','Prologue: World Scientists\' warning to Humanity');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4467','NC Travel and Tourism Divison','North Carolina camping and outdoors directory');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4473','Godfrey, Michael A.','Field guide to the Piedmont');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4455','Eysenck, Hans J.','Future of Psychology (Ch.15)');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4422','Schumann, Marguerite','The living land');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4425','Tishler, William, ed.','American landscape architecture : designers and places');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4416','Reece, William S. and Russell S. Sobel.','Diagrammatic Approach to Capacity-Constrained Price Discrimination.');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4412','Chichilinisky, Graciela and Geoffrey Heal.','Managing Unknown Risks.');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4414','Gavious, Arieh.','Transfer Pricing Under Capcity Constraints.');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4407','Bodily, S. E. and L. R. Weaterford.','Perishable-Asset Revenue Management: Generic and Multiple-Price Yield Management with Diversion.');
INSERT INTO new_titles VALUES ('2000/10/09','SF395.8.A1 P67 vol. 121 1990','AOE-4391','','A guide for fly control around swine facilities /');
INSERT INTO new_titles VALUES ('2000/10/09','LD3921 For. C438','AOE-4321','Chen, Jui-Chi, 1968-','Forecasting method applications to recreation and tourism demand /');
INSERT INTO new_titles VALUES ('2000/10/09','LD3921 Zool. C635','AOE-4320','Collins, Kenneth Paul, 1966-','Investigation of the phylogenetic relationships within the eremoneura (Diptera:Brachycera) based on DNA sequence data /');
INSERT INTO new_titles VALUES ('2000/10/09','LD3921 Physics. B74','AOE-4319','Brown, Jeffrey David, 1972-','Ultraviolet photodetectors and imaging arrays based on III-V nitride heterostructures /');
INSERT INTO new_titles VALUES ('2000/10/09','LD3921 Physics. A93','AOE-4318','Ayars, Eric James, 1968-','Near-field Raman spectroscopy /');
INSERT INTO new_titles VALUES ('2000/10/09','LD3921 Entom. N351','AOE-4317','Nalyanya, Godfrey Wabomba, 1968-','Strategies for behavioral manipulation of German cockroach (Dictyoptera:Blattellidae) populations /');
INSERT INTO new_titles VALUES ('2000/10/09','LD3921 Mech. & Aerospace Eng. W3243','AOE-4316','Wang, Xiangfu.','An experimental and numerical investigation of the machining of anisotropic materials including wood and a wood composit');
INSERT INTO new_titles VALUES ('2000/10/09','LD3921 Vet. Medical Sciences. N671','AOE-4315','Norford, Derek C. (Derek Charles), 1957-','Mechanisms of mucin stimulation in response to inflammatory mediators in human airway epithelial cells in vitro /');
INSERT INTO new_titles VALUES ('2000/10/09','LD3921 Stat. Z49','AOE-4314','Zhu, Lei.','Statistical decoding and designing of pooling experiments based on chemical structure /');
INSERT INTO new_titles VALUES ('2000/10/09','LD3921 Toxicol. W48','AOE-4313','Wetmore, Barbara Anne, 1967-','Herbicide alachlor nasal carcinogenicity and hepatotoxicity involve site-specific bioactivation and oxidative stress /');
INSERT INTO new_titles VALUES ('2000/10/09','LD3921 Toxicol. W36','AOE-4312','Wang, Hui Qin, 1967-','Overexpression of protein kinase C-a in the epidermis of transgenic mice results in striking alterations in phorbol este');
INSERT INTO new_titles VALUES ('2000/10/09','SF395.8.A1 P67 vol. 111 1987','AOE-4309','','Management and nutrition of the newly weaned pig /');
INSERT INTO new_titles VALUES ('2000/10/09','Desk File','AOE-4197','','NTR415 Croom lesson 17. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/09','Desk File','AOE-4212','','NTR415 Croom lesson 16. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/09','SF395.8.A1 P67 vol. 20 1983','AOE-4289','','Starting purchased feeder pigs /');
INSERT INTO new_titles VALUES ('2000/10/09','Desk File','AOE-4189','','NTR415 Croom lesson 15. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/09','I 19.3:1368/A-B-1369','AOE-4155','Detterman, Robert L.','Surficial deposits of the Iliamna quadrangle, Alaska,');
INSERT INTO new_titles VALUES ('2000/10/09','I 19.3:1313-A-E','AOE-4150','Zohdy, Adel A. R., 1935-','Variable azimuth Schlumberger resistivity sounding and profiling near a vertical contact,');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4146','Haskell, Thomas.','Objectivity is Not Neutrality (Ch.6)');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4149','McKinney, Thearon.','Evaluating the Impact of Your CES Programs.');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4142','Stone, Lawrence.','The Revival of Narrative: Reflections on a New Old History.');
INSERT INTO new_titles VALUES ('2000/10/09','I 19.3:996-A-E','AOE-4137','Hunt, Charles Butler, 1906-','Pleistocene-Recent boundary in the Rocky Mountain region /');
INSERT INTO new_titles VALUES ('2000/10/09','','AOE-4134','Megill, Allan.','Recounting the Past: Description, Explanation, and Narrative in Historiography.');
INSERT INTO new_titles VALUES ('2000/10/09','NMB 1.1:','AOE-4064','United States. Board of Mediation.','Annual report of the United States Board of Mediation.');
INSERT INTO new_titles VALUES ('2000/10/09','QB500.267 .U9 2000','AOD-5997','','UV, optical, and IR space telescopes and instruments : 29-31 March 2000, Munich, Germany /');
INSERT INTO new_titles VALUES ('2000/10/09','TA1637 .O675 1999','AOD-5995','','Optoelectronic and hybrid optical/digital systems for image and signal processing : 21-24 September 1999, Lviv, Ukraine');
INSERT INTO new_titles VALUES ('2000/10/09','QA76.9.C65 E53 2000','AOD-5993','','Enabling technology for simulation science IV : 25-27 April, 2000, Orlando, USA /');
INSERT INTO new_titles VALUES ('2000/10/09','QB84.5 .T44 2000','AOD-5990','','Telescope structures, enclosures, controls, assembly/integration/validation, and commissioning : 27-31 March 2000, Munic');
INSERT INTO new_titles VALUES ('2000/10/09','TA1775 .X76 2000','AOD-5989','','X-ray optics, instruments, and missions III : 27-29 March 2000, Munich, Germany /');
INSERT INTO new_titles VALUES ('2000/10/09','LT4210.S33 L57 2000 vol. 1','AOC-3330','','Scholastic literacy place, Kindergarten /');
INSERT INTO new_titles VALUES ('2000/10/09','TL589.4 .E452 2000','AOC-3127','','Enhanced and synthetic vision 2000 : 24-25 April, 2000, Orlando, USA /');
INSERT INTO new_titles VALUES ('2000/10/09','QB88 .D57 2000','AOC-3126','','Discoveries and research prospects from 8- to 10-meter-class telescopes : 30-31 March 2000, Munich, Germany /');
INSERT INTO new_titles VALUES ('2000/10/09','QB88 .A383 2000','AOC-3125','','Advanced telescope and instrumentation control software : 29-30 March 2000, Munich, Germany /');
INSERT INTO new_titles VALUES ('2000/10/09','QB479.2 .R33 2000','AOC-3122','','Radio telescopes : 27-30 March 2000, Munich, Germany /');
INSERT INTO new_titles VALUES ('2000/10/09','TA1632 .V558 2000','AOC-3121','','Visual information processing IX : 25 April, 2000, Orlando, USA /');
INSERT INTO new_titles VALUES ('2000/10/09','TJ211.415 .U56 2000','AOC-3120','','Unmanned ground vehicle technology II : 24-25 April, 2000, Orlando, USA /');
INSERT INTO new_titles VALUES ('2000/10/09','TK9006 .I476249 2000','ANZ-4803','International Conference on Nuclear Engineering (8th : 2000 : Baltimore, Md.)','Proceedings of the 8th International Conference on Nuclear Engineering 2000, ICONE-8 : presented at 8th International Co');
INSERT INTO new_titles VALUES ('2000/10/09','QA164.8 .L58 1999','ANZ-2748','Liu, Yanpei, 1939-','Enumerative theory of maps /');
INSERT INTO new_titles VALUES ('2000/10/09','SB951.3 .T48 2000','ANZ-2416','Thomson, W. T. (William Thomas)','Agricultural chemicals, book IV : fungicides /');
INSERT INTO new_titles VALUES ('2000/10/09','SB351.C3 C37 2000','ANZ-0532','','Carottes = Carrots.');
INSERT INTO new_titles VALUES ('2000/10/17','HD1920.7 .C76 2000','ANZ-5120','Cski, Csaba.','Rural development strategy : Eastern Europe and Central Asia /');
INSERT INTO new_titles VALUES ('2000/10/17','RA652.2.M3 S76 2000','ANZ-4761','','Stochastic epidemic models and their statistical analysis /');
INSERT INTO new_titles VALUES ('2000/10/17','QD715 .S66 2000','ANZ-4767','','Solid state and surface photochemistry /');
INSERT INTO new_titles VALUES ('2000/10/17','NA9031 .B74 2000','ANZ-4610','','Breathing cities : the architecture of movement /');
INSERT INTO new_titles VALUES ('2000/10/17','TR267 .G66 2000','ANZ-4593','Gookin, Dan.','Digital scanning and photography /');
INSERT INTO new_titles VALUES ('2000/10/17','NA2500 .H235 2000','ANZ-4609','Hale, Jonathan A.','Building ideas : an introduction to architectural theory /');
INSERT INTO new_titles VALUES ('2000/10/17','NA2705 .L38 2001','ANZ-4587','Laseau, Paul, 1937-','Graphic thinking for architects & designers /');
INSERT INTO new_titles VALUES ('2000/10/17','[videocassette] HG3290.6.A8 G7388 1997','ANZ-4547','','The women\'s bank of Bangladesh');
INSERT INTO new_titles VALUES ('2000/10/17','[videocassette] HQ1726.5 .H67 1999','ANZ-4545','','Honorable murder');
INSERT INTO new_titles VALUES ('2000/10/17','[videocassette] HQ1784 .B496 2000','ANZ-4546','','Beyond borders-- Arab feminists talk about their lives-- East and West /');
INSERT INTO new_titles VALUES ('2000/10/17','[videocassette] HQ1236 .S45 1999','ANZ-4544','','Shackled women');
INSERT INTO new_titles VALUES ('2000/10/17','[videocassette] HF1379 .G585 2000','ANZ-4542','','Globalization winner[s] and losers.');
INSERT INTO new_titles VALUES ('2000/10/17','Y 3.F 31/8:23/','ANZ-4352','','Trust assets of financial institutions');
INSERT INTO new_titles VALUES ('2000/10/17','[DVD] PN1993.5.I829 V37 2000','ANZ-3945','','Vashu Bhagnani\'s Tera jadoo chal gayaa a magical love story /');
INSERT INTO new_titles VALUES ('2000/10/17','[DVD] PN1993.5.I829 R494 2000','ANZ-3943','','Refugee');
INSERT INTO new_titles VALUES ('2000/10/17','NA1121.V4 Q55 2000','ANZ-3921','Quill, Sarah.','Ruskin\'s Venice : the stones revisited /');
INSERT INTO new_titles VALUES ('2000/10/17','NA5453 .C76 2000','ANZ-3882','Crook, John.','The architectural setting of the cult of saints in the early Christian West, c.300-1200 /');
INSERT INTO new_titles VALUES ('2000/10/17','B2430.S33 T736 2000','ANZ-3857','Priest, Stephen.','The subject in question : Sartre\'s critique of Husserl in The transcendence of the ego /');
INSERT INTO new_titles VALUES ('2000/10/17','SB123.57 .G48 2000','ANZ-3197','','Genetically modified pest-protected plants : science and regulation /');
INSERT INTO new_titles VALUES ('2000/10/17','Q175 .K952 2000','ANZ-3161','Kukla, Andr, 1942-','Social constructivism and the philosophy of science /');
INSERT INTO new_titles VALUES ('2000/10/17','LB775 .A255 2000','ANZ-3147','Acker, Victor, 1940-','Clestin Freinet /');
INSERT INTO new_titles VALUES ('2000/10/17','TA1570 .J43 2000','ANZ-3153','Jha, Asu Ram.','Infrared technology : applications to electrooptics, photonic devices, and sensors /');
INSERT INTO new_titles VALUES ('2000/10/17','TK7816 .S57 2000','ANZ-3140','Slone, G. Randy.','TAB electronics guide to understanding electricity and electronics /');
INSERT INTO new_titles VALUES ('2000/10/17','QA403 .T62 2000','ANZ-3141','','Topics in analysis and its applications : selected theses /');
INSERT INTO new_titles VALUES ('2000/10/17','BF121 .P765 2001','ANZ-3134','','Psychobabble & biobunk : using psychology to think critically about issues in the news : opinion essays and book reviews');
INSERT INTO new_titles VALUES ('2000/10/17','QD75.4.Q34 R43 2000','ANZ-3136','','Reference materials in analytical chemistry : a guide for selection and use /');
INSERT INTO new_titles VALUES ('2000/10/17','DS646.32.D9 O77 1999','ANZ-3111','Orpa Sari, Riska.','Riska : memories of a Dayak girlhood /');
INSERT INTO new_titles VALUES ('2000/10/17','QA3 .S62525 2000','ANZ-3126','Smale, Stephen, 1930-','The collected papers of Stephen Smale /');
INSERT INTO new_titles VALUES ('2000/10/17','D811.A2 K513 2000','ANZ-3106','Kike wadatsumi no koe. English.','Listen to the voices from the sea : writings of the fallen Japanese students /');
INSERT INTO new_titles VALUES ('2000/10/17','QC174.12 .A95 2000','ANZ-3070','Auletta, Gennario.','Foundations and interpretation of quantum mechanics : in the light of a critical-historical analysis of the problems and');
INSERT INTO new_titles VALUES ('2000/10/17','HQ1413.G34 B73 2000','ANZ-3069','Brammer, Leila R., 1966-','Excluded from suffrage history : Matilda Joslyn Gage, nineteenth century American feminist /');
INSERT INTO new_titles VALUES ('2000/10/17','QA76.76.D47 B69 2000','ANZ-3050','Bosch, Jan.','Design and use of software architectures : adopting and evolving a product-line approach /');
INSERT INTO new_titles VALUES ('2000/10/17','QA76.76.H94 A99 2000','ANZ-3054','Ayesh, Aladdin, 1972-','Essential dynamic HTML fast : developing an interactive web site /');
INSERT INTO new_titles VALUES ('2000/10/17','QA278.2 .D64 2000','ANZ-3048','Dodge, Yadolah, 1944-','Adaptive regression /');
INSERT INTO new_titles VALUES ('2000/10/17','E169.04 .C65 2001','ANZ-3049','','Common culture : reading and writing about American popular culture /');
INSERT INTO new_titles VALUES ('2000/10/17','HM1121 .S63 2000','ANZ-3022','','Social conflicts and collective identities /');
INSERT INTO new_titles VALUES ('2000/10/17','TK3307 .D35 2000','ANZ-3020','Deb, Anjan K.','Power line ampacity system : theory, modeling, and applications /');
INSERT INTO new_titles VALUES ('2000/10/17','JC311 .T86 2000','ANZ-3021','Tuminez, Astrid S., 1964-','Russian nationalism since 1856 : ideology and the making of foreign policy /');
INSERT INTO new_titles VALUES ('2000/10/17','JN94.A979 B37 2000','ANZ-3000','Bartolini, Stefano.','The political mobilization of the European left, 1860-1980 : the class cleavage /');
INSERT INTO new_titles VALUES ('2000/10/17','PR3633 .A4 2000','ANZ-2930','Pope, Alexander, 1688-1744.','Alexander Pope : selected letters /');
INSERT INTO new_titles VALUES ('2000/10/17','JQ1758.A92 C58 2000','ANZ-2931','','Citizenship and the state in the Middle East : approaches and applications /');
INSERT INTO new_titles VALUES ('2000/10/17','E99.O3 B483 2000','ANZ-2909','','The Black Elk reader /');
INSERT INTO new_titles VALUES ('2000/10/17','C 55.418/7:25665/2000','ANZ-2489','','West Indies, Puerto Rico, Punta Lima To Cayo Batata, 25665, May 20, 2000');
INSERT INTO new_titles VALUES ('2000/10/17','QA76.9.A96 T33 2000','ANZ-2645','TABLEAUX 2000 (2000 : St. Andrews, Scotland)','Automated reasoning with analytic tableaux and related methods : international conference, TABLEAUX 2000, St Andrews, Sc');
INSERT INTO new_titles VALUES ('2000/10/17','C 55.418/7:13309/2000','ANZ-2488','','United States - East Coast, Maine, Penobscot River, 13309, June 17, 2000');
INSERT INTO new_titles VALUES ('2000/10/17','C 55.418/7:12274/2000','ANZ-2486','','United States - East Coast, Maryland, Head of Chesapeake Bay, 12274, July 1, 2000');
INSERT INTO new_titles VALUES ('2000/10/17','C 55.418/7:12333/2000','ANZ-2487','','United States - East Coast, New York - New Jersey, Kill Van Kull and Northern Part of Arthur Kill, 12333, June 17, 2000');
INSERT INTO new_titles VALUES ('2000/10/17','C 55.418/7:11466/2000','ANZ-2485','','United States -- East Coast Florida, Jupiter Inlet to Fowey Rocks, 11466, Loran-C, June 3, 2000');
INSERT INTO new_titles VALUES ('2000/10/17','C 55.418/7:11361/2000','ANZ-2484','','United States - Gulf Coast, Louisiana, Mississippi River Delta, 11361, Loran-C, May 20, 2000');
INSERT INTO new_titles VALUES ('2000/10/17','C 55.418/7:11357/2000','ANZ-2483','','United States - Gulf Coast, Louisiana, Timbalier and Terrebonne Bays, 11357, Loran-C, June 3, 2000');
INSERT INTO new_titles VALUES ('2000/10/17','C 55.418/7:11329/2000','ANZ-2482','','United States - Gulf Coast, Texas, Houston Ship Channel, Alexander Island to Carpenter Bayou, 11329, April 1, 2000');
INSERT INTO new_titles VALUES ('2000/10/17','QA76.9.D3 W325 2000','ANZ-2412','WAIM 2000 (2000 : Shanghai, China)','Web-age information management : first international conference, WAIM 2000, Shanghai, China, June 21-23, 2000 : proceedi');
INSERT INTO new_titles VALUES ('2000/10/17','QA76.76.R44 A33 2000','ANZ-2411','Ada-Europe International Conference on Reliable Software Technologies (5th : 2000 : Potsdam, Germany)','Reliable software technologies Ada Europe 2000 : 5th Ada-Europe International Conference, Potsdam, Germany, June 26-30 2');
INSERT INTO new_titles VALUES ('2000/10/17','QA76.9.D3 D3645 2000','ANZ-2406','','Databases in telecommunications : international workshop co-located with VLDB-99, Edinburgh, Scotland, UK, September 6th');
INSERT INTO new_titles VALUES ('2000/10/17','QA150 .A42 2000','ANZ-1566','','Algebra and its applications : international conference, Algebra and its Applications, March 25-28, 1999, Ohio Universit');
INSERT INTO new_titles VALUES ('2000/10/17','HJ2323.O33 T39 2000','ANZ-0535','','Tax burdens : alternative measures /');
INSERT INTO new_titles VALUES ('2000/10/17','LC1037.8.O43 F76 2000','ANZ-0539','','From initial education to working life : making transitions work /');
INSERT INTO new_titles VALUES ('2000/10/17','RA410.55.O43 S97 2000','ANZ-0530','','A system of health accounts : Version 1.0.');
INSERT INTO new_titles VALUES ('2000/10/17','HG3881 .G57319 2000','ANZ-0522','','Global finance from a Latin American viewpoint /');
INSERT INTO new_titles VALUES ('2000/10/17','LB3058.O43 M43 2000','ANZ-0528','','Measuring student knowledge and skills : the PISA 2000 assessment of reading, mathematical and scientific literacy.');
INSERT INTO new_titles VALUES ('2000/10/17','BT102 .H336 2000','ANZ-0418','Hallett, Garth.','A middle way to God /');
INSERT INTO new_titles VALUES ('2000/10/17','HQ76.3.U5 B688 2000','ANZ-0441','','Brave journeys : profiles in gay and lesbian courage /');
INSERT INTO new_titles VALUES ('2000/10/17','K950 .R44 2000','ANZ-0412','','Reform of civil nuclear liability = Rforme de la responsabilit civile nuclaire : international symposium, Budapest,Hu');
INSERT INTO new_titles VALUES ('2000/10/17','KJS3220 .C53 1999','ANZ-0406','Clark, John W., 1938-','Competition law and policy in the Baltic Countries.');
INSERT INTO new_titles VALUES ('2000/10/17','TK9202 .R465 2000','ANZ-0408','','Reduction of capital costs of nuclear power plants.');
INSERT INTO new_titles VALUES ('2000/10/17','LB3209 .A67 2000','ANZ-0404','','The appraisal of investments in educational facilities /');
INSERT INTO new_titles VALUES ('2000/10/17','UA646 .A9723 2000','ANZ-0394','Aybet, Glnur.','A European security architecture after the Cold War : questions of legitimacy /');
INSERT INTO new_titles VALUES ('2000/10/17','UG447 .P34 1999','ANZ-0398','Pearson, Graham S., 1935-','The UNSCOM saga : chemical and biological weapons non-proliferation /');
INSERT INTO new_titles VALUES ('2000/10/17','GN805 .B8699 2000','ANZ-0392','Burl, Aubrey.','The stone circles of Britain, Ireland, and Brittany /');
INSERT INTO new_titles VALUES ('2000/10/17','TD171.5.H9 E58 2000','ANZ-0098','','Environmental performance reviews.');
INSERT INTO new_titles VALUES ('2000/10/17','KNC705 .C66 1999','ANZ-0350','','Comparative Asian environmental law anthology /');
INSERT INTO new_titles VALUES ('2000/10/17','KF5076.C57 M35 2000','ANZ-0353','Malti-Douglas, Fedwa.','The Starr report disrobed /');
INSERT INTO new_titles VALUES ('2000/10/17','E77 .H588 2000','ANY-9336','Hirschfelder, Arlene B.','Native Americans /');
INSERT INTO new_titles VALUES ('2000/10/17','LC65 .I586 2000','ANZ-0057','','Investing in education : Analysis of the 1999 world education indicators.');
INSERT INTO new_titles VALUES ('2000/10/17','CB245 .B365 2000','ANY-9327','Barzun, Jacques, 1907-','From dawn to decadence : 500 years of western cultural life,1500 to the present /');
INSERT INTO new_titles VALUES ('2000/10/17','F273 .R48 2000','ANY-9317','Rhett, Robert Barnwell, 1800-1876.','A fire-eater remembers : the Confederate memoir of Robert Barnwell Rhett /');
INSERT INTO new_titles VALUES ('2000/10/17','Y 1.1/8:106-628','ANY-9127','United States. Congress. House. Committee on Veterans\' Affairs.','Veterans and Dependents Millennium Education Act : report (to accompany H.R. 4268) (including cost estimate of the Congr');
INSERT INTO new_titles VALUES ('2000/10/17','Y 1.1/8:106-634','ANY-9039','United States. Congress. House. Committee on Commerce.','Cardiac Arrest Survival Act of 2000 : report (to accompany H.R. 2498).');
INSERT INTO new_titles VALUES ('2000/10/17','Y 1.1/8:106-633','ANY-9038','United States. Congress. House. Committee on Resources.','Lewis and Clark Rural Water System Act of 2000 : report together with additional views (to accompany H.R. 297) (includin');
INSERT INTO new_titles VALUES ('2000/10/17','Y 1.1/8:106-626','ANY-9035','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 4475, transportation and related agencies appropriations for the fiscal year end');
INSERT INTO new_titles VALUES ('2000/10/17','Y 1.1/5:106-301','ANY-9026','United States. Congress. Senate. Committee on Commerce, Science, and Transportation.','Oceans Act of 2000 : report of the Committee on Commerce, Science, and Transportation on S. 2327.');
INSERT INTO new_titles VALUES ('2000/10/17','Y 1.1/5:106-300','ANY-9024','United States. Congress. Senate. Committee on Commerce, Science, and Transportation.','Coast Guard Authorization Act : report of the Committee on Commerce, Science, and Transportation on S. 1089.');
INSERT INTO new_titles VALUES ('2000/10/17','Y 1.1/5:106-299','ANY-9022','United States. Congress. Senate. Committee on the Judiciary.','The Pain Relief Promotion Act : report together with minority views (to accompany H.R. 2260).');
INSERT INTO new_titles VALUES ('2000/10/17','TS171.4 .H425 2000','ANY-7399','Heath, Adrian.','300 years of industrial design : function, form, technique, 1700-2000 /');
INSERT INTO new_titles VALUES ('2000/10/17','[videocassette] HD5307 .O54 1999','ANY-5964','','One day longer the story of the Frontier strike /');
INSERT INTO new_titles VALUES ('2000/10/17','HD30.37 .C65 2000','ANY-4477','Cohan, Peter S., 1957-','E-profit : high payoff strategies for capturing the e-commerce edge /');
INSERT INTO new_titles VALUES ('2000/10/17','HG181 .R46 2000','ANY-4411','','Restructuring regulation and financial institutions /');
INSERT INTO new_titles VALUES ('2000/10/17','HD30.37 .E97 2000','ANY-4466','Ezor, Jonathan.','Clicking through : a survival guide for bringing your company online /');
INSERT INTO new_titles VALUES ('2000/10/17','SB455.3 .L34 2000','ANY-4121','Lacy, Allen, 1935-','In a green shade : writings from homeground /');
INSERT INTO new_titles VALUES ('2000/10/17','SB439 .C85 2000','ANY-4118','Cullina, William.','The New England Wild Flower Society guide to growing and propagating wildflowers of the United States and Canada /');
INSERT INTO new_titles VALUES ('2000/10/17','QL638.S2 C75 2000','ANY-3610','Crisp, D. T. (D. Trevor)','Trout and salmon : ecology, conservation and rehabilitation /');
INSERT INTO new_titles VALUES ('2000/10/17','QH51 .C63 2000','ANY-3580','Cobern, William W.','Everyday thoughts about nature : a worldview investigation of important concepts students use to make sense of nature wi');
INSERT INTO new_titles VALUES ('2000/10/17','QH450.2 .W34 2000','ANY-3578','Wagner, Rolf, 1948-','Transcription regulation in prokaryotes /');
INSERT INTO new_titles VALUES ('2000/10/17','F184.C37 H64 2000','ANY-3524','Hoffman, Ronald, 1941-','Princes of Ireland, planters of Maryland : a Carroll saga, 1500-1782 /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-317','ALE-7916','Stein, William I.','Wrenching Douglas-fir seedlings in August : immediate but no lasting effects /');
INSERT INTO new_titles VALUES ('2000/10/17','E51 .U55 5th','ANY-3511','MacCauley, Clay, 1843-1925.','The Seminole Indians of Florida /');
INSERT INTO new_titles VALUES ('2000/10/17','HF5549.5.T7 H635 2000','ANY-2015','Horton, William K. (William Kendall)','Designing Web-based training : how to teach anyone anything anywhere anytime /');
INSERT INTO new_titles VALUES ('2000/10/17','JC599.U5 B593 2000','ANY-1074','Borsook, Paulina.','Cyberselfish : a critical romp through the terribly libertarian culture of high tech /');
INSERT INTO new_titles VALUES ('2000/10/17','QL801 .E67 vol. 152','ANY-1599','Eckstein, F. (Felix), 1964-','Effects of joint incongruity on articular pressure distribution and subchondral bone remodelling /');
INSERT INTO new_titles VALUES ('2000/10/17','ML3795 .D356 2000','ANY-0920','Des Pres, Josquin.','Creative careers in music /');
INSERT INTO new_titles VALUES ('2000/10/17','DF212.E82 M33 2000','ANY-0672','MacGillivray, Joseph Alexander, 1953-','Minotaur : Sir Arthur Evans and the archaeology of the Minoan myth /');
INSERT INTO new_titles VALUES ('2000/10/17','QL362.85 .T43 1995','ANX-8001','','Techniques in fish immunology : immunological and pathological techniques of aquatic invertebrates /');
INSERT INTO new_titles VALUES ('2000/10/17','GT2853.G7 W39 2000','ANY-0671','Warde, Alan.','Eating out : social differentiation, consumption, and pleasure /');
INSERT INTO new_titles VALUES ('2000/10/17','HF1359 .C87 2000','ANX-7614','Curry, Jeffrey E., 1953-','A short course in international economics : understanding the dynamics of the international marketplace /');
INSERT INTO new_titles VALUES ('2000/10/17','ML3521 .W75 1999','ANX-7230','','Write me a few of your lines : a blues reader /');
INSERT INTO new_titles VALUES ('2000/10/17','HB172 .W673 1999','ANX-7548','Wolfstetter, Elmar, 1945-','Topics in microeconomics : industrial organization, auctions, and incentives /');
INSERT INTO new_titles VALUES ('2000/10/17','HG9396 .P383 1999','ANX-7195','Pauly, Mark V., 1941-','Pooling health insurance risks /');
INSERT INTO new_titles VALUES ('2000/10/17','HD58.9 .S67 2000','ANX-7187','Sonnichsen, Richard C.','High impact internal evaluation : a practitioner\'s guide to evaluating and consulting inside organizations /');
INSERT INTO new_titles VALUES ('2000/10/17','BL980.G7 J46 1999','ANX-4220','Jenkins, Timothy, 1952-','Religion in English everyday life : an ethnographic approach /');
INSERT INTO new_titles VALUES ('2000/10/17','QR41.2 .A843 1995','ANX-2184','Atlas, Ronald M., 1946-','Principles of microbiology /');
INSERT INTO new_titles VALUES ('2000/10/17','TD193 .V36 2000','ANX-3945','VanLoon, Gary W.','Environmental chemistry : a global perspective /');
INSERT INTO new_titles VALUES ('2000/10/17','E 1.84:0415','ANX-1743','','CLEAN COAL TECHNOLOGY... DOE/FE-0415... U.S. DEPARTMENT OF ENERGY... APRIL 2000');
INSERT INTO new_titles VALUES ('2000/10/17','Y 4.AP 6/1:D 63/2000/PT.1-','ANX-1719','United States. Congress. House. Committee on Appropriations. Subcommittee on District of Columbia Appropriations.','District of Columbia appropriations for 2000 : hearings before a subcommittee of the Committee on Appropriations, House');
INSERT INTO new_titles VALUES ('2000/10/17','QC881.2.T75 T73 2000','ANX-1359','','Transport and chemical transformation of pollutants in the troposphere : an overiew of the work of EUROTRAC /');
INSERT INTO new_titles VALUES ('2000/10/17','ND553.M3 A76 2000','ANX-0353','','The shock of the nude Manet\'s Olympia /');
INSERT INTO new_titles VALUES ('2000/10/17','RC186.T7 C37 1998','ANW-9843','Casadevall, Arturo, 1957-','Cryptococcus neoformans /');
INSERT INTO new_titles VALUES ('2000/10/17','Y 1.1/8:106-627','ANW-9275','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 4392, the Intelligence Authorization Act for Fiscal Year 2001 : report (to accom');
INSERT INTO new_titles VALUES ('2000/10/17','Y 1.1/8:106-624','ANW-9272','United States. Congress. House. Committee on Rules.','Providing for the further consideration of H.R. 4205, the National Defense Authorization Act for Fiscal Year 2001 : repo');
INSERT INTO new_titles VALUES ('2000/10/17','Y 1.1/8:106-617','ANW-9265','','Report on the suballocation of budget allocations for fiscal year 2001 /');
INSERT INTO new_titles VALUES ('2000/10/17','Y 1.1/8:106-623','ANW-9271','','Report on the revised suballocation of budget allocations for fiscal year 2001 /');
INSERT INTO new_titles VALUES ('2000/10/17','Y 1.1/5:106-298','ANW-9243','United States. Congress. Senate. Committee on Appropriations.','Department of Defense appropriation bill, 2001 : report (to accompany S. 2593).');
INSERT INTO new_titles VALUES ('2000/10/17','Y 1.1/5:106-295','ANW-9240','United States. Congress. Senate. Committee on Environment and Public Works.','Disaster Mitigation Act of 1999 : report (to accompany S. 1691) (including cost estimate of the Congressional Budget Off');
INSERT INTO new_titles VALUES ('2000/10/09','HE242 .I544 2000','ANZ-0531','','Integration of European inland transport markets /');
INSERT INTO new_titles VALUES ('2000/10/09','HE5614.5.E8 S34 2000','ANZ-0526','','Safety in road traffic for vulnerable users.');
INSERT INTO new_titles VALUES ('2000/10/09','KPA3272 .R44 2000','ANZ-0529','','Regulatory reform in Korea.');
INSERT INTO new_titles VALUES ('2000/10/09','HG1601 .I475 2000','ANZ-0525','','Improving access to bank information for tax purposes /');
INSERT INTO new_titles VALUES ('2000/10/09','HD9502.C6 C497 2000','ANZ-0524','','China\'s worldwide quest for energy security /');
INSERT INTO new_titles VALUES ('2000/10/09','E185.86 .B374 2000','ANZ-0426','Barnes, Annie S.','Say it loud : middle-class Blacks talk about racism and what to do about it /');
INSERT INTO new_titles VALUES ('2000/10/09','DS247.K88 T48 2000','ANZ-0423','Ttreault, Mary Ann, 1942-','Stories of democracy : politics and society in contemporary Kuwait /');
INSERT INTO new_titles VALUES ('2000/10/09','BL240.2 .B384 2000','ANZ-0415','Barnes, Michael Horace.','Stages of thought : the co-evolution of religious thought and science /');
INSERT INTO new_titles VALUES ('2000/10/09','E185.615 .M94 2000','ANZ-0407','Myers, Jim, 1941-','Afraid of the dark : what whites and Blacks need to know about each other /');
INSERT INTO new_titles VALUES ('2000/10/09','JK516 .G493 2000','ANZ-0400','Gergen, David R. (David Richmond), 1942-','Eyewitness to power : the essence of leadership : Nixon to Clinton /');
INSERT INTO new_titles VALUES ('2000/10/09','QL84 .M35 1999','ANZ-0079','Manning, Phillip, 1936-','Islands of hope /');
INSERT INTO new_titles VALUES ('2000/10/09','HD2098 .A38 2000','ANZ-0059','','The agro-food processing sector in China : developments and policy challenges /');
INSERT INTO new_titles VALUES ('2000/10/09','HD9581.A7852 S68 1999','ANZ-0058','','South East Asia gas study /');
INSERT INTO new_titles VALUES ('2000/10/09','HD87.5 .W34 2000','ANZ-0009','','Waging the global war on poverty : strategies and case studies /');
INSERT INTO new_titles VALUES ('2000/10/09','NA6245.I82 R66 1961','ANY-9506','Bocca, Alessandro.','Il palazzo del Banco di Roma : storia, cronaca, aneddoti /');
INSERT INTO new_titles VALUES ('2000/10/09','N5070.B7 P6 1965','ANY-9504','','Poelzig, Endell, Moll und die Breslauer Kunstakademie, 1911-1932; eine Ausstellung der Akademie der Knste und des Stdt');
INSERT INTO new_titles VALUES ('2000/10/09','NA7126 .D45 1980','ANY-9503','Deilmann, Harald.','Wohnungsbau : Nutzungstypen, Grundrisstypen, Wohnungstypen, Gebudetypen = The dwelling : use-types, plan-types, dwellin');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-7222','Rowan, Brian.','Organizational Design of Schools. Chapter 1.');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-7232','Selman , Paul,H','LandUse: Some Techniques for environmental planning');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-7203','Bacon, Matt','No strings attached : the inside story of Jim Henson\'s Creature Shop');
INSERT INTO new_titles VALUES ('2000/10/04','Course Shelf','AOB-7211','Pond, W. G. et al.','Basic Animal Nutrition and Feeding. 4th ed. c1995.');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-7192','Bartlett, Sheridan','\"Kids aren\'t like they used to be\" : nostalgia and reality in neighborhood life[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-7190','Boyer, Ernest L.','The sixth step : neighborhoods for learning[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-7188','Marcus, Clare Cooper and Carolyn Francis','Growing up in a danger zone : how modernization efforts can improve the environment of childhood in public housing[Photo');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-3927','Forman, Richard T.T.','Foundations (Ch 1).');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-7184','Gaster, Sanford','Historical changes in children\'s access[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-3822','Forman, Richard T.T. and Michel Gordon.','Landscape and Principles (Ch 1).');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-3707','Steiner, Frederick.','Suitability Analysis (Ch 5).');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-3649','Brooks, R.Gene.','Mapping: The Method of Inventory (Ch 4).');
INSERT INTO new_titles VALUES ('2000/10/04','NAS 1.15:209282','AOB-3656','DeLombard, Richard.','SAMS acceleration measurements on Mir from May 1997 to June 1998 (NASA increments 5, 6, and 7)');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-3605','Simpson, John.','Prospect.');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-3594','Steinitz, Carl.','Some Components of Context (and other titles)');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-3523','Steiner, Frederick.','Inventory and Analysis of the Biophysical Environment (Ch 3)pt.2');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-3514','Steiner, Frederick.','Inventory and Analysis of the Biophysical Environment (Ch 3) part.1');
INSERT INTO new_titles VALUES ('2000/10/04','SSA 1.19:R 31/4','AOB-3015','','When you retire from your own business : what Social Security needs to know.');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-0091','Jones, Sabrina','Work as a second language');
INSERT INTO new_titles VALUES ('2000/10/04','','AOB-0093','Jones, Sabrina','Restructuring\'s human cost');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-9017','Sagan, Carl and Ann Druyan','What Thin Partitions... (Ch.2)');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-9015','Hilgard, Ernest R.','Forward: A Personal View of the 20th-Century Psychology: With an Eye to the 21st Century');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-9013','Pojman, Louis','Water Pollution, Pesticides, and Hazardous Waste (Ch.14)');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-9011','Pojman, Louis','Air Pollution, the Greenhouse Effect, and Ozone Depletion (Ch.13)');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-8984','World Bank and Lester Brown','Will Future Generations Have Enough to Eat? Yes and No Responses (Issue 4)');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-8736','Rosenberg, Richard S.','Computers are Everywhere (Ch.1)');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-8941','Brown, Lester','Challenges of the New Century (Ch.1)');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-6321','Millman, Mayer and John G. U. Adams','Children\'s freedom and safety[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-6316','Jeavons, Mary','Children\'s activity in the everyday landscape of the suburb[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-6319','Huttenmoser, Marco','Children and their living surroundings[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-6313','Moore, Robin and Donald Young','Childhood outdoors: toward a social ecology of the landscape[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-6279','Moore, Robin C.','Streets as playgrounds[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-6264','Woodard, Arthur E.','Liquid Crystalline Polymers (Ch.7)');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-6219','Cantor, David and Terence Lee, eds.','Patterns of activity in time and space: the ecology of a neighbourhood playground[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-6215','Moore, Robin C.','The power of nature[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-5986','Olwig, Kenneth Robert','Harmony, \'quintessence,\' and children\'s acquisition of concern for the \'natural environment[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-5984','Schiavo, R. Steven','Age differences in assessment and use of a suburban neighborhood among children and adolescents[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-5982','Moore, Robin C.','Collaborating with young people to assess their landscape values[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-3569','Cameron, Trudy Ann.','New Paradigm for Valuing Non-Market Goods Using Referendum Data: Maximum Likelihood Estimation by Censored Logistic Regr');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-3447','Hanemann, W. Michael.','Welfare Evaluations in Contingent Valuation Experiments with Discrete Responses.');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-3390','Herriges, Joseph A. and Catherine L. Kling.','Nonlinear Income Effects in Random Utility Models.');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-3352','Kling, Catherine L.','Reliability of Estimates of Environmental Benefits from Recreation Demand Models.');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-3248','Shonkwiler, J. S. and W. Douglass Shaw.','Hurdle Count-Data Models in Recreation Demand Analysis.');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-3031','Smith, V. Kerry.','Option Value: A Conceptual Overview.');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-3073','Larson, Douglas M. and Paul R. Flacco.','Measuring Option Prices from Market Behavior.');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-2984','Bishop, Richard C.','Option Value: An Exposition and Extension.');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-2881','Larson, Douglas M.','Recovering Weakly Complemntary Preferences.');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-2884','Larson, Douglas M.','Further Results on Willingness to Pay for NonMarket Goods.');
INSERT INTO new_titles VALUES ('2000/10/03','I 19.76:99-448','AOA-2283','McGimsey, Robert G.','1997 volcanic activity in Alaska and Kamchatka : summary of events and response of the Alaska Volcano Observatory /');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-2240','Offen, Karen.','Defining Feminism: A Comparative Historical Approach.');
INSERT INTO new_titles VALUES ('2000/10/03','I 19.76:99-183','AOA-2168','Bruce, Breton W.','Hydrologic and water-quality data for surface water, ground water and springs in North-Central Park County, Colorado, Ap');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-2069','Scott, Joan.','Women\'s History.');
INSERT INTO new_titles VALUES ('2000/10/03','DG552.8.G2 A2 1889','AOA-2010','Garibaldi, Giuseppe, 1807-1882.','Autobiography of Giuseppe Garibaldi.');
INSERT INTO new_titles VALUES ('2000/10/03','','AOA-2013','Soroos, Marvin','Atmosphere and Global Public Policy (Ch.1)');
INSERT INTO new_titles VALUES ('2000/10/03','SF996 .T39 1977','AOA-2000','Taylor, David, 1934-','Zoo vet : adventures of a wild animal doctor /');
INSERT INTO new_titles VALUES ('2000/10/03','I 19.76:99-218','AOA-1017','','Vegetative resistance to flow in south Florida : summary of vegetation sampling at sites NESRS3 and P33, Shark River Slo');
INSERT INTO new_titles VALUES ('2000/10/03','I 19.76:99-219','AOA-1015','','Chesapeake Bay habitat criteria scores and the distribution of submersed aquatic vegetation in the tidal Potomac River a');
INSERT INTO new_titles VALUES ('2000/10/03','I 19.76:99-247','AOA-1013','Plummer, L. Niel.','Data on the crystal growth of calcite from calcium bicarbonate solutions at 340C and CO2 partial pressures of 0.101, 0.0');
INSERT INTO new_titles VALUES ('2000/10/03','I 19.76:99-302','AOA-1008','','Publications of the Western Geologic Mapping Team 1997-1998');
INSERT INTO new_titles VALUES ('2000/10/03','I 19.76:99-252','AOA-1011','Izuka, Scot K.','Summary of ground-water data for Tutuila and Aunuu, American Samoa, for October 1987 through September 1997 /');
INSERT INTO new_titles VALUES ('2000/10/03','I 19.76:99-211','AOA-1003','Hortness, Jon E.','Stream channel cross sections for a reach of the Boise River in Ada County, Idaho /');
INSERT INTO new_titles VALUES ('2000/10/03','I 19.76:99-204','ANZ-9777','Cressler, Alan M.','Ground-water conditions in Georgia, 1998 /');
INSERT INTO new_titles VALUES ('2000/10/03','I 19.76:99-207','AOA-0997','Grady, Stephen J.','A plan for assessing the occurrence and distribution of methyl tert-butyl ether and other volatile organic compounds in');
INSERT INTO new_titles VALUES ('2000/10/03','I 19.76:99-202','ANZ-9775','','Water quality and habitat conditions in upper midwest streams relative to riparian vegetation and soil characteristics,');
INSERT INTO new_titles VALUES ('2000/10/03','I 19.76:99-201','ANZ-9774','Rankin, Dale R.','Plan of study to define hydrogeologic characteristics of the Madera Limestone in the east mountain area of central New M');
INSERT INTO new_titles VALUES ('2000/10/03','I 19.76:99-193','ANZ-9666','','New reporting procedures based on long-term method detection levels and some considerations for interpretations of water');
INSERT INTO new_titles VALUES ('2000/10/03','I 19.76:99-199','ANZ-9668','Lyford, Forest P.','Estimated hydraulic properties for the surficial-and bedrock-aquifer system, Meddybemps, Maine /');
INSERT INTO new_titles VALUES ('2000/10/03','I 19.76:99-190','ANZ-9662','Berndt, Marian P.','Water-quality and discharge data for St. Joseph Bay, Florida, 1997-98 /');
INSERT INTO new_titles VALUES ('2000/10/03','I 19.76:99-192','ANZ-9664','Kimbrough, Robert A.','Water-quality and bottom-sediment-chemistry data for Left Hand Valley Reservoir, Boulder County, Colorado, January-Augus');
INSERT INTO new_titles VALUES ('2000/10/03','','ANZ-9401','Phaneuf, Daniel J. et al.','Estimation and Welfare Calculations in a Generalized Corner Soltion Model with an Application to Recreation Demand.');
INSERT INTO new_titles VALUES ('2000/10/03','ED 1.76:GEN-97-14','ANZ-9382','','Summary: increasing aggregate loan limits for certain health professions students affected by the phaseout of the Health');
INSERT INTO new_titles VALUES ('2000/10/03','D 101.20/2:8-267-30-MTP','ANZ-9393','','Mission training plan for the Medical Company, Main Support Battalion, airborne/air assault light infantry divisions');
INSERT INTO new_titles VALUES ('2000/10/03','ED 1.76:GEN-97-1','ANZ-9380','','Student Financial Assistance Programs ... Enclosed is a calendar setting forth some of the significant products ...');
INSERT INTO new_titles VALUES ('2000/10/03','Desk Shelf','ANZ-9376','Herriges, Joseph A. and Catherine L. King.eds.','Valuing Recreation and the Environment. c1999.');
INSERT INTO new_titles VALUES ('2000/10/03','ED 1.76:ANN-98-1','ANZ-9378','','Student Financial Assistance Programs ... We are pleased to announce a major expansion of the services & information ava');
INSERT INTO new_titles VALUES ('2000/10/03','ED 1.76:ANN-98-6','ANZ-9372','','Student Financial Assistance Programs ...');
INSERT INTO new_titles VALUES ('2000/10/03','ED 1.76:ANN-98-7','ANZ-9374','','Student Financial Assistance Programs ...');
INSERT INTO new_titles VALUES ('2000/10/03','QA931 .L283 1986b','ANZ-4808','Landau, L. D. (Lev Davidovich), 1908-1968.','Theory of elasticity /');
INSERT INTO new_titles VALUES ('2000/10/03','RA778.4.H57 L38 1999','ANZ-5276','','Latina reproductive health in North Carolina : demographics, health status, and programs /');
INSERT INTO new_titles VALUES ('2000/10/03','QB84.5 .O67 2000','ANZ-4799','','Optical design, materials, fabrication, and maintenance : 27-29 March 2000, Munich, Germany /');
INSERT INTO new_titles VALUES ('2000/10/03','TK7874 .L2975 2000','ANZ-4797','','Laser applications in microelectronic and optoelectronic manufacturing V : 24-26 January, 2000, San Jose, California /');
INSERT INTO new_titles VALUES ('2000/10/03','R857.L37 L3744 1999','ANZ-4796','','Laser Florence \'99 : a window on the laser medicine world : 28-31 October 1999, Florence, Italy /');
INSERT INTO new_titles VALUES ('2000/10/03','TK7874 .E54 2000','ANZ-4793','','Emerging lithographic technologies IV : 28 February-1 March, 2000, Santa Clara, [California], USA /');
INSERT INTO new_titles VALUES ('2000/10/03','HC412 .A748 2000','ANZ-4778','','Asian regionalism /');
INSERT INTO new_titles VALUES ('2000/10/03','TA418.9.C6 A2892 1999','ANZ-4779','','Advances in ceramic-matrix composites V /');
INSERT INTO new_titles VALUES ('2000/10/03','Q174 .B67 vol. 208','ANZ-4773','Hanzel, Igor.','The concept of scientific law in the philosophy of science and epistemology : a study of theoretical reason /');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-483','ANC-6691','Cole, David N.','Trends in wilderness visitors and visits Boundary Waters Canoe Area, Shining Rock, and Desolation wildernesses /');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-497','ANB-2484','Cole, David N.','Experimental evaluations of two leave-no-trace techniques removing boots and using geotextile groundcloths /');
INSERT INTO new_titles VALUES ('2000/10/20','QL84.5.N35 M35 1998','ANA-4925','Majupuria, Trilok Chandra.','Wildlife, national parks & reserves : resources, management & wildlife safaris /');
INSERT INTO new_titles VALUES ('2000/10/20','PS3552.E7496 A79 2000','ANA-4846','Berry, Venise T.','All of me : a voluptuous tale /');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-495','AMZ-4169','Arno, Stephen F.','Old growth ponderosa pine and western larch stand structures influences of pre-1900 fires and fire exclusion /');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-486','AMZ-4167','Ketcheson, Gary.','Sediment production and downslope sediment transport from forest roads in granite watersheds');
INSERT INTO new_titles VALUES ('2000/10/09','NA997.L76 C6 1981','ANY-9502','Coe, Peter.','Lubetkin and Tecton : architecture and social commitment : a critical study /');
INSERT INTO new_titles VALUES ('2000/10/09','N6831.5.C8 C47 1992','ANY-9497','Cesky kubismus. English.','Czech cubism : architecture, furniture, and decorative arts, 1910-1925 /');
INSERT INTO new_titles VALUES ('2000/10/09','NA997.S7 S75 1961','ANY-9496','Stroud, Dorothy.','The architecture of Sir John Soane.');
INSERT INTO new_titles VALUES ('2000/10/09','NA997.M3 A4 1968','ANY-9492','Mackintosh, Charles Rennie, 1868-1928.','Charles Rennie Mackintosh (1868-1928) : architecture, design and painting : [catalogue of] an exhibition arranged by the');
INSERT INTO new_titles VALUES ('2000/10/09','NA7756.F7 L4 1929','ANY-9486','Lensi, Alfredo.','Palazzo vecchio /');
INSERT INTO new_titles VALUES ('2000/10/09','NK2550.C48 R46 1954','ANY-9491','Herbst, Ren.','Pierre Chareau');
INSERT INTO new_titles VALUES ('2000/10/09','NA1088.T38 G53 1963','ANY-9483','','Die Glserne Kette : visionre Architekturen aus dem Kreis um Bruno Taut, 1919-1920 : Ausstellung im Museum Leverkusen,');
INSERT INTO new_titles VALUES ('2000/10/09','NA7860 .C57 1984','ANY-9480','Cocchioni, Cristina, 1946-','La casa popolare a Roma : trent\'anni di attivit dell\'I.C.P. /');
INSERT INTO new_titles VALUES ('2000/10/04','MF NC DOCS C27 2:N492','ALS-0806','','Basinwide wetlands and riparian restoration plan for the Neuse River Basin');
INSERT INTO new_titles VALUES ('2000/10/04','MF NC DOCS C27 2:L952','ALS-0805','','Basinwide wetlands and riparian restoration plan for the Lumber River Basin');
INSERT INTO new_titles VALUES ('2000/10/04','MF NC DOCS C27 2:C352','ALS-0803','','Basinwide wetlands and riparian restoration plan for the Catawba River Basin');
INSERT INTO new_titles VALUES ('2000/10/04','MF NC DOCS C12 202:I63s','ALS-0801','Bridle, Kenneth A.','Inventory of natural heritage of Stokes County, North Carolina');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-6848','Jauss, David','From Long Shots to X-Rays: Distance & Point of View in Fiction Writing');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-6846','Elbow, Peter','Embracing Contraries in the Teaching Process');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-6844','Wood, Nancy','Argument and Literature (Ch.9)');
INSERT INTO new_titles VALUES ('2000/10/06','Desk File','AOD-6840','Mitchell, William J.','Intention and Artifice. Ch. 3 [Photocopy].');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-6842','Wood, Nancy','Rogerian Argument and Common Ground (Ch.8)');
INSERT INTO new_titles VALUES ('2000/10/06','Desk File','AOD-6836','Mitchell, William J.','How to Do Things With Pictures. Ch. 9 [Photocopy].');
INSERT INTO new_titles VALUES ('2000/10/06','Desk File','AOD-6834','Mitchell, William J.','Beginnings. Ch. 1 [Photocopy].');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-6832','Mitchell, William J.','Nascent Medium. Ch. 2 [Photocopy].');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-6237','Lind, Mary R.','Gender Impact of Temporary Virtual Work Groups');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-6074','Stanfield, John H','Ethics Modeling in Quantitative Research(Ch 10)');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-6055','Sparks, Barabara','Methodological and Epistemological Considerations of Doing Cross Cultural Research in Adult Education');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-3544','Miller, G. Tyler, Jr.','Changes in Ecosystem: What Can Happen to Ecosystems?(Ch 6)');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-3410','Miller, G. Tyler, Jr','Ecosystem Function: How do cosystems Work?(ch5)');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-3408','Miller, G. Tyler, Jr.','Ecosystems Structure: What is an Ecosystem?(Ch 4)');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-3406','Miller, G. Tyler, Jr.','Some Concepts of Ecology(Part Two)');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-3402','Hunt, Lynn','Introduction: History, Culture and Text');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-3404','Miller, G. Tyler, Jr.',' Impact on The Earth(ch2)');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-3400','Foucault, Michel','Michel Foucault: Beyond Structuralism and Hermeneutics');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-2932','Hutton, Patrick H.','The Foucault Phenomenon And Contemporary French Historiography');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-2696','Toews, John .','Intellectual History After the Linguistic Turn: The Autonomy of Meaning and the Irreducibilty of Experience.');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-2530','Jay, Martin.','Should Intellectual History Take a Linguistic Turn? Reflections on the Habermas-Gadamer Debate (Ch 3).');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-2478','Speigel, Gabrielle M.','History, Historicism, and the Social Logic of the Text in the Middle Ages.');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-2431','Wineburg, Robert.','The Reverend and Me: Faith Communities and Public Welfare (Ch.11)');
INSERT INTO new_titles VALUES ('2000/10/06','','AOD-2423','Stoesz, David.','The Interim Director: Leadership and Administrative Style (Ch 5)');
INSERT INTO new_titles VALUES ('2000/10/06','LT4250.S33 S33 2001, v. 1','AOD-2242','','Scholastic read XL');
INSERT INTO new_titles VALUES ('2000/10/06','GA 1.5/A-2:B-165384','AOD-1200','United States. General Accounting Office.','[Comments on former Navy member\'s relief from liability and request for reimbursement for refund of erroneous diving pay');
INSERT INTO new_titles VALUES ('2000/10/06','GA 1.5/A-2:B-165072','AOD-1197','United States. General Accounting Office.','[Comments on former Navy employee\'s claim for interest on severance pay]');
INSERT INTO new_titles VALUES ('2000/10/06','GA 1.5/A-2:B-161939','AOD-1196','United States. General Accounting Office.','[Influence of public affairs organizations on information and advertising programs]');
INSERT INTO new_titles VALUES ('2000/10/06','GA 1.5/A-2:B-160452','AOD-1191','United States. General Accounting Office.','[Comments on Army employee\'s claim for additional per diem and travel expenses]');
INSERT INTO new_titles VALUES ('2000/10/06','GA 1.5/A-2:B-160178','AOD-1190','United States. General Accounting Office.','[Comments on Army employee\'s compensation claim]');
INSERT INTO new_titles VALUES ('2000/10/06','GA 1.5/A-2:B-157179','AOD-1187','United States. General Accounting Office.','[Comments on availability of unspent FY 1970 grant funds for new grantee to complete unfinished project]');
INSERT INTO new_titles VALUES ('2000/10/02','LB1028 .E320','AAZ-0766','Educational researcher (American Educational Research Association : 1972)','Educational researcher');
INSERT INTO new_titles VALUES ('2000/10/02','QE581 .S43','AAY-9957','','Sedimentology');
INSERT INTO new_titles VALUES ('2000/10/02','QL700 .S39','AAY-9913','','Sugetierkundliche Mitteilungen');
INSERT INTO new_titles VALUES ('2000/10/02','QK600 .P4','AAY-9568','','Persoonia');
INSERT INTO new_titles VALUES ('2000/10/02','SB481.A1 P39','AAY-9545','Parks & recreation (New York, N.Y.)','Parks & recreation official publication of the National Recreation and Park Association.');
INSERT INTO new_titles VALUES ('2000/10/02','QC770 .N853','AAY-9425','','Nuclear physics.');
INSERT INTO new_titles VALUES ('2000/09/28','HC256.4 .Z94 2000','ANY-0636','Zweiniger-Bargielowska, Ina.','Austerity in Britain : rationing, controls, and consumption, 1939-1955 /');
INSERT INTO new_titles VALUES ('2000/09/28','Y 4.EN 2:S.HRG.106-507','ANX-8979','United States. Congress. Senate. Committee on Energy and Natural Resources. Subcommittee on Forests and Public Land Management.','Amend the Mineral Leasing Act : hearing before the Subcommittee on Forests and Public Land Management of the Committee o');
INSERT INTO new_titles VALUES ('2000/09/28','Y 4.ED 8/1:106-91','ANX-8971','United States. Congress. House. Committee on Education and the Workforce. Subcommittee on Oversight and Investigations.','Charter schools : successes and challenges : hearing before the Subcommittee on Oversight and Investigations of the Comm');
INSERT INTO new_titles VALUES ('2000/09/28','B1 .P5 v. 43 suppl.','ANX-8045','','Extending the horizons of continental philosophy /');
INSERT INTO new_titles VALUES ('2000/09/28','K721.5 .P76 2000','ANX-7997','','Property and values : alternatives to public and private ownership /');
INSERT INTO new_titles VALUES ('2000/09/28','QA1 .A413 2000 issue 2','ANX-7980','Dezin, A. A. (Aleksei Alekseevich)','Differential operator equations : a method of model operators in the theory of boundary value problems /');
INSERT INTO new_titles VALUES ('2000/09/28','HD58.7 .O7313 1997','ANX-7551','','Organizational behaviour : integrated readings /');
INSERT INTO new_titles VALUES ('2000/09/28','HC462.9 .H73 1999','ANX-7545','Hsu, Robert C.','The MIT encyclopedia of the Japanese economy /');
INSERT INTO new_titles VALUES ('2000/09/28','QP551 .A14 1999','ANX-7323','','2-D proteome analysis protocols /');
INSERT INTO new_titles VALUES ('2000/09/28','HG173 .C865 1999','ANX-7294','','Current topics in quantitative finance /');
INSERT INTO new_titles VALUES ('2000/09/28','HC240.25.M4 P53 1999','ANX-7290','Pierros, Filippos.','Bridges and barriers : the European Union\'s Mediterranean policy, 1961-1998 /');
INSERT INTO new_titles VALUES ('2000/09/28','HF5548.32 .A43 1999','ANX-7285','Aldrich, Douglas F.','Mastering the digital marketplace : practical strategies for competitiveness in the new economy /');
INSERT INTO new_titles VALUES ('2000/09/28','HD30.3 .A73 1998','ANX-7273','Argenti, Paul A.','Corporate communication /');
INSERT INTO new_titles VALUES ('2000/09/28','HD62.7 .S5263 1997','ANX-7271','Sherman, Andrew J.','The complete guide to running and growing your business /');
INSERT INTO new_titles VALUES ('2000/09/28','HF5845 .B337 1997','ANX-7272','Barr, Vilma.','Stores : retail display and design /');
INSERT INTO new_titles VALUES ('2000/09/28','HD69.C6 C63 1997','ANX-7270','Connor, Richard A.','Marketing your consulting and professional services /');
INSERT INTO new_titles VALUES ('2000/09/28','HD6475.A1 F88 1997','ANX-7262','','The future of trade unionism : international perspectives on emerging union structures /');
INSERT INTO new_titles VALUES ('2000/09/28','HC120.E5 C67 1999','ANX-7255','Copeland, Grant.','Acts of balance : profits, people and place /');
INSERT INTO new_titles VALUES ('2000/09/28','HF1021 .I57 1997','ANX-7211','','Interdependent and uneven development : global-local perspectives /');
INSERT INTO new_titles VALUES ('2000/09/28','HD62.7 .Z55 1998','ANX-7217','Zimmerer, Thomas.','Essentials of entrepreneurship and small business management /');
INSERT INTO new_titles VALUES ('2000/09/28','KF6369.3 .M3 1999','ANX-7198','McNulty, John K.','Federal income taxation of individuals in a nutshell /');
INSERT INTO new_titles VALUES ('2000/09/28','TS57 .S54 2000','ANX-7164','Skeens, Nick.','Future present : it just takes one good idea /');
INSERT INTO new_titles VALUES ('2000/09/28','HD30.28 .R834 1999','ANX-7151','Rubenstein, Herb.','Breakthrough Inc : high-growth strategies for entrepreneurial organizations /');
INSERT INTO new_titles VALUES ('2000/09/28','DS558.2 .G63 1998','ANX-6962','Godmilow, Jill.','What Farocki taught');
INSERT INTO new_titles VALUES ('2000/09/28','HG4636 .C37 2000','ANX-7144','Cataldo, Anthony J.','The January effect and other seasonal anomalies : a common theoretical framework /');
INSERT INTO new_titles VALUES ('2000/09/28','DS919.3 .W45 1999','ANX-6798','Whiting, Charles, 1926-','Battleground Korea : the British in Korea /');
INSERT INTO new_titles VALUES ('2000/09/28','RC455.4.E8 H36 2000','ANX-6797','','Handbook of multicultural mental health : assessment and treatment of diverse populations /');
INSERT INTO new_titles VALUES ('2000/09/28','F474.I23 A54 1999','ANX-6780','Andrews, Gregg.','Insane sisters, or, The price paid for challenging a company town /');
INSERT INTO new_titles VALUES ('2000/09/28','DA1 .P37 2000','ANX-6768','Parker, Christopher, 1941-','The English idea of history from Coleridge to Collingwood /');
INSERT INTO new_titles VALUES ('2000/09/28','DT433.54 .M63 2000','ANX-6760','','Modern Kenya : social issues and perspectives /');
INSERT INTO new_titles VALUES ('2000/09/28','E184.G3 T65 2000','ANX-6758','Tolzmann, Don Heinrich, 1945-','The German-American experience /');
INSERT INTO new_titles VALUES ('2000/09/28','E511.5 16th .S63 2000','ANX-6752','Small, Abner Ralph, 1836-1910.','The road to Richmond : the Civil War memoirs of Major Abner R. Small of the Sixteenth Maine Volunteers : together with t');
INSERT INTO new_titles VALUES ('2000/09/28','KFN7640 .A25 2000','ANX-6192','','North Carolina & federal requirements for pesticide record keeping /');
INSERT INTO new_titles VALUES ('2000/09/28','D137 .V57 1999','ANX-4225','','The visigoths from the migration period to the seventh century : an ethnographic perspective /');
INSERT INTO new_titles VALUES ('2000/09/28','HQ1064.U6 I6487 2000','ANX-4135','Klaus, Carl H.','Taking retirement : a beginners\'s diary /');
INSERT INTO new_titles VALUES ('2000/09/28','BR520 .S44 1999','ANX-4223','Seeman, Erik R.','Pious persuasions : laity and clergy in eighteenth-century New England /');
INSERT INTO new_titles VALUES ('2000/09/28','LC5805 .C75 1999','ANX-4133','Criscito, Pat, 1953-','Barron\'s guide to distance learning : degrees, certificates, courses /');
INSERT INTO new_titles VALUES ('2000/09/28','UA943 .E47 2000','ANX-4009','','Employing commercial satellite communications : wideband investment options for the Department of Defense /');
INSERT INTO new_titles VALUES ('2000/09/28','TP156.R45 .T36 2000','ANX-3884','Tanner, Roger I.','Engineering rheology /');
INSERT INTO new_titles VALUES ('2000/09/28','A 13.78:PNW-RP-522','ANX-2878','','Forest cover dynamics in the Pacific Northwest west side : regional trends and projections /');
INSERT INTO new_titles VALUES ('2000/09/28','A 13.80:NC-196','ANX-2468','Schmidt, Thomas L.','Indiana\'s forests in 1998 /');
INSERT INTO new_titles VALUES ('2000/09/28','A 13.88:PNW-GTR-469','ANX-1155','Boggs, Keith, 1955-','Classification of community types, successional sequences, and landscapes of the Copper River Delta, Alaska /');
INSERT INTO new_titles VALUES ('2000/09/28','TG24.N82 G7 2000','ANX-0235','','[Replacement of bridge no. 198 on SR 1445 over Spewmarrow Creek in Granville County].');
INSERT INTO new_titles VALUES ('2000/09/28','QR46 .M5365 1996','ANW-9826','','Microbe hunters, then and now /');
INSERT INTO new_titles VALUES ('2000/09/28','PR9199.3.O5 A84 2000','ANW-9771','Ondaatje, Michael, 1943-','Anil\'s ghost /');
INSERT INTO new_titles VALUES ('2000/09/28','TD 4.8/5:8082-11','ANW-9332','','Inspection authorization knowledge test guide');
INSERT INTO new_titles VALUES ('2000/09/28','C 13.58:6481','ANW-9380','','Molecular dynamics study of tethered chains');
INSERT INTO new_titles VALUES ('2000/09/28','C 13.58:6506','ANW-9330','','Preparation and characterization of polymer/dendrimer blends final report /');
INSERT INTO new_titles VALUES ('2000/09/28','EP 1.23/6:600/R-99/108','ANW-9325','','New perspectives in electrofishing');
INSERT INTO new_titles VALUES ('2000/09/28','TD 4.8/5:8082-9','ANW-9319','','Flight engineer knowledge test guide');
INSERT INTO new_titles VALUES ('2000/09/28','C 55.13/2:NMFS-NE-128','ANW-9324','','Essential fish habitat source document.');
INSERT INTO new_titles VALUES ('2000/09/28','TD 4.8/5:8082-7','ANW-9318','','Flight and ground instructor knowledge test guide');
INSERT INTO new_titles VALUES ('2000/09/28','TD 4.8/5:8082-1','ANW-9315','','Airline transport pilot, aircraft dispatcher, and flight navigator knowledge test guide');
INSERT INTO new_titles VALUES ('2000/09/28','A 13.79:FPL-RN-0275','ANW-8979','DeGroot, Rodney C.','Distribution of borates around point source injections in wood members exposed outside');
INSERT INTO new_titles VALUES ('2000/09/28','HE308 .V83 1999','ANW-6975','Vuchic, Vukan R.','Transportation for livable cities /');
INSERT INTO new_titles VALUES ('2000/09/28','Y 4.AR 5/2 A:999-2000/6','ANW-8153','United States. Congress. House. Committee on Armed Services. Military Personnel Subcommittee.','Hearings on National Defense Authorization Act for fiscal year 2000--H.R. 1401 and oversight of previously authorized pr');
INSERT INTO new_titles VALUES ('2000/09/28','NA9105 .T9 1992','ANW-6523','','20/20 vision managing for a livable urban habitat /');
INSERT INTO new_titles VALUES ('2000/09/28','TK7885.7 .B47 2000','ANW-6012','Bergeron, Janick.','Writing testbenches : functional verification of HDL models /');
INSERT INTO new_titles VALUES ('2000/09/28','QC19.2 .I575 1999','ANW-4668','International Workshop on Contemporary Problems in Mathematical Physics (1st : 1999 : Cotonou, Benin)','Proceedings of the first International Workshop on Contemporary Problems in Mathematical Physics : Cotonou, Republic of');
INSERT INTO new_titles VALUES ('2000/09/28','PR6069.H4575 Z4614 1999','ANW-3751','Sheridan, Peter, 1952-','44 Dublin made me /');
INSERT INTO new_titles VALUES ('2000/09/28','PE1408 .A577 2000','ANW-3743','Anderson, Chris, 1955-','A forest of voices : conversations in ecology /');
INSERT INTO new_titles VALUES ('2000/09/28','PA3133 .G64 2000','ANW-3735','','Greek drama /');
INSERT INTO new_titles VALUES ('2000/09/28','PR5684 .K44 1999','ANW-3742','Trollope, Anthony, 1815-1882.','Kept in the dark /');
INSERT INTO new_titles VALUES ('2000/10/04','MF NC DOCS C12 202:I63i','ALS-0800','Frye, Christopher T.','Natural areas inventory for Iredell County, North Carolina');
INSERT INTO new_titles VALUES ('2000/10/04','MF NC DOCS C12 202:I63f','ALS-0797','Bridle, Kenneth A.','Inventory of natural heritage of Forsyth County, North Carolina');
INSERT INTO new_titles VALUES ('2000/10/04','I 1.98:J 13/2/','ALR-4611','United States. Bureau of Land Management. Rio Puerco Resource Area.','Final environmental impact statement for the Jackpile-Paguate Uranium Mine Reclamation Project : Laguna Indian Reservati');
INSERT INTO new_titles VALUES ('2000/10/04','I 1.98:L 14 m/3/draft/','ALI-0855','','Lake Mead National Recreation Area, Arizona-Nevada : draft environmental impact statement.');
INSERT INTO new_titles VALUES ('2000/10/04','MF NC DOCS B71 9:U56','ALF-1292','','Analysis of the unemployment insurance trust fund');
INSERT INTO new_titles VALUES ('2000/10/04','I 1.98:K 12','AKQ-5183','United States. Bureau of Land Management.','Final environmental impact statement : proposed Kaiparowits Project /');
INSERT INTO new_titles VALUES ('2000/10/06','GA 1.5/A-2:B-149372','AOD-1185','United States. General Accounting Office.','[Comments on false travel authorization for presidential transition team members]');
INSERT INTO new_titles VALUES ('2000/10/06','GA 1.5/A-2:B-139733','AOD-1183','United States. General Accounting Office.','[Comments on Commerce employees\' claims for foreign travel expenses]');
INSERT INTO new_titles VALUES ('2000/09/28','Y 4.R 31/3:106-61','ANZ-4664','United States. Congress. House. Committee on Resources. Subcommittee on Forests and Forest Health.','Oversight hearing on Herger-Feinstein Quincy Library Group Forest Recovery Act : oversight hearing before the Subcommitt');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-693','AMQ-8440','Auchmoody, L. R.','Planting northern red oak acorns is size and planting depth important? /');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-692','AMQ-8435','Smith, H. Clay.','Closure of logging wounds after 10 years');
INSERT INTO new_titles VALUES ('2000/10/26','EP 1.23/6:620/R-99/001 B','AMQ-5592','','EMAP information management plan 1998-2001 /');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-686','AMP-8754','Fincher, James.','A discriminant-function approach to ecological site classification in northern New England');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-687','AMP-6853','Houston, David R., 1932-','Sapstreak disease of sugar maple development over time and space /');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-695','AMP-6142','Wiedenbeck, Janice K.','Data bank for short-length red oak lumber');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-688','AMP-1821','Solomon, Dale S.','Migration of tree species in New England based on elevational and regional analyses');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-682','AMN-6167','','Effects of forest disturbance and soil depth on digestible energy for moose and white-tailed deer');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-689','AMP-5310','Schuler, Thomas M.','Survival, growth, and juvenile-mature correlations in a West Virginia sugar maple provenance test 25 years after establi');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-685','AMO-0760','Daigle, John J.','National forest trail users planning for recreation opportunities /');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-679','AMN-5715','Walters, Russell S.','Protecting red oak seedlings with tree shelters in northwestern Pennsylvania');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-681','AMN-3312','Wharton, Eric H.','Methods to estimate total forest biomass for extensive forest inventories applications in the northeastern U.S. /');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-680','AMN-1590','L. R. Auchmoody.','Acorn production in northern red oak stands in northwestern Pennsylvania');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-684','AMN-1558','Schuler, Thomas M.','Survival and growth of white ash families and provenances 15 years after establishment in West Virginia');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-678','AML-5074','Auchmoody, L. R.','Survival of northern red oak acorns after fall burning');
INSERT INTO new_titles VALUES ('2000/10/26','D 101.11:9-2320-272-24-2','AML-4939','','Unit, direct support, and general support maintenance manual for truck, 5-ton, 6x6, M939, M939A1, M939A2 series trucks (');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-669','AMJ-2556','Gatchell, Charles J.','1992 data bank for red oak lumber');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-666','AMJ-6913','Hoff, Kristen G.','Graphic model of the processes involved in the production of casegood furniture');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-670','AMI-9549','Yaussy, Daniel A.','Method for estimating potential tree-grade distributions for northeastern forest species');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-668','AMI-9127','Glass, Ronald J.','Satisfaction, valuation, and views toward allocation of Vermont goose hunting opportunities');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-671','AMI-7602','','Computerized technique for recording board defect data');
INSERT INTO new_titles VALUES ('2000/10/26','[Microfiche] J 16.1:','AMI-3534','United States. Bureau of Prisons.','State of the Bureau /');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-667','AMI-1152','','Millipede damage to germinating acorns of northern red oak');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-672','AMI-6320','Smith, H. Clay.','Development of Red Oak seedlings using plastic shelters on hardwood sites in West Virginia');
INSERT INTO new_titles VALUES ('2000/10/26','[videocassette] HD9993.E452 G36 2000','AMH-2793','','Game over gender, race & violence in video games /');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-655','AMD-0996','Lamson, Neil I.','Stand development and yields of Appalachian hardwood stands managed with single-tree selection for at least 30 years /');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-665','AMI-1150','Layton, Deborah A.','Cost estimators for construction of forest roads in central Appalachians');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-621-645','AMB-9283','Glass, Ronald J.','Habitat improvement costs on state-owned wildlife management areas in New York /');
INSERT INTO new_titles VALUES ('2000/10/26','[Microfiche] J 16.1:','ALN-7856','United States. Bureau of Prisons.','Report.');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-RP-596-620','ALT-0979','','The Northern hardwood forest ecosystem : ten years of recovery from clearcutting /');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-567-595','ALL-6119','Wade, Gary L.','Success of trees and shrubs in an 18-year-old planting on mine spoil /');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-451-475','AKZ-7284','Zisa, Robert P.','Establishment and early growth of conifers on compact soils in urban areas /');
INSERT INTO new_titles VALUES ('2000/10/26','A93.11/2:','ALF-2324','','Feed situation and outlook yearbook.');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-501-533','ALA-3678','Patric, James H., 1922-','Erosion on very stony forest soil during phenomenal rain in Webster County, West Virginia /');
INSERT INTO new_titles VALUES ('2000/10/26','[Media] PN1997.99 .H399 1998','AJY-0144','','He got game');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.28:M 34/20','AKW-1808','United States. Forest Service. Eastern Region.','Mark Twain National Forest : Ava, Cassville, and Willow Springs ranger districts /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 9076','AJS-8094','James, Peter, 1961-','Domain mapping of Ca dependent membrane proteins /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 12638','AJS-5438','Vulava, Vijay Mohan, 1970-','Cation competition in soil materials : adsorption equilibria and transport /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 12591','AJS-5436','Durner, Roland Alexander, 1966-','Feast and starvation : accumulation of bioplastic in Pseudomonas oleovorans /');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-446','AMY-9277','United States. Congress. House. Committee on Resources.','Miwaleta Park Expansion Act : report (to accompany H.R. 1725) (including cost estimate of the Congressional Budget Offic');
INSERT INTO new_titles VALUES ('2000/09/28','PS225 .M67 2000','ANW-3329','Moran, Joe, 1970-','Star authors : literary celebrity in America /');
INSERT INTO new_titles VALUES ('2000/09/28','HB241 .P65 1999','ANW-3071','Pokrovski, Vladimir N.','Physical principles in the theory of economic growth /');
INSERT INTO new_titles VALUES ('2000/09/28','HB172.5 .B475 1999','ANW-3073','','Beyond the representative agent /');
INSERT INTO new_titles VALUES ('2000/09/28','HB135 .P88 1997','ANS-4928','Puu, Tnu, 1936-','Nonlinear economic dynamics /');
INSERT INTO new_titles VALUES ('2000/09/28','LB2333 .G46 1999','ANS-3271','George, Judith W.','A handbook of techniques for formative evaluation : mapping the student\'s learning experience /');
INSERT INTO new_titles VALUES ('2000/09/28','TE24.N82 M6 1999h','ANS-2974','','[Pavement rehabilitation of I-77 from SR 2213 to north of SR 2004 in Mecklenburg County, TIP project no. I-4024, state p');
INSERT INTO new_titles VALUES ('2000/09/28','Y 3.N 88:25/6672/V.','ANS-2143','','Reexamination of spent fuel shipment risk estimates');
INSERT INTO new_titles VALUES ('2000/09/28','Y 3.AD 9/12:2 C 73','ANS-2118','United States Advisory Commission on Public Diplomacy.','Publics and diplomats in the global communications age United States Advisory Commission on Public Diplomacy 1998 report');
INSERT INTO new_titles VALUES ('2000/09/28','TD 2.30:99-138','ANS-2085','Bruce, Donald A.','An introduction to the deep soil mixing methods as used in geotechnical applications');
INSERT INTO new_titles VALUES ('2000/09/28','HM251 .I47 1998','ANS-1282','','Inside social life : readings in sociological psychology and microsociology /');
INSERT INTO new_titles VALUES ('2000/09/28','Y 4.AP 6/1:IN 8/6/2001/PT.1-','ANR-9770','United States. Congress. House. Committee on Appropriations. Subcommittee on Dept. of the Interior and Related Agencies.','Department of the Interior and related agencies appropriations for 2001 : hearings before a subcommittee of the Committe');
INSERT INTO new_titles VALUES ('2000/09/28','DS922.27 .F36 1987','ANR-3365','','Family and home');
INSERT INTO new_titles VALUES ('2000/09/28','SH336.A57 W45 1998','ANR-3581','Weilmeier, Denise Minerva, 1966-','Understanding the antioxidant properties of phosphates during storage of raw and cooked fish muscle /');
INSERT INTO new_titles VALUES ('2000/09/28','TA418.9.C6 S35 1996','ANR-2211','Salim, Hani A., 1966-','Modeling and application of thin-walled composite beams in bending and torsion /');
INSERT INTO new_titles VALUES ('2000/09/28','ML3534 .R54 1998','ANR-2075','','Righteous babes');
INSERT INTO new_titles VALUES ('2000/09/28','GN484 .W352 1993','ANR-2077','','Warrior marks');
INSERT INTO new_titles VALUES ('2000/09/28','[videocassette] HV6626.2 .B73 1997','ANR-2073','','Breaking the rule of thumb a documentary /');
INSERT INTO new_titles VALUES ('2000/09/28','QM601 .P69 1996','ANR-2027','','Prenatal development a life in the making /');
INSERT INTO new_titles VALUES ('2000/09/28','[videocassette] E185.86 .B53 1999','ANR-2019','','Black, bold & beautiful Black women\'s hair /');
INSERT INTO new_titles VALUES ('2000/09/28','QA280 .O95 1998','ANR-2000','Owsley, Lane M. D.','Classification of transient events in time series /');
INSERT INTO new_titles VALUES ('2000/09/28','C 13.10:831/999','ANQ-8485','Hyer, Charles W.','Directory of professional/trade organization laboratory accreditation/designation programs');
INSERT INTO new_titles VALUES ('2000/09/28','PN2881.5 .W66 1998','ANQ-5509','','Women theater activists of India an educational video /');
INSERT INTO new_titles VALUES ('2000/09/28','PK1658 .S56 1986','ANQ-2964','Simha, Udaya Narayana.','A bibliography of Bengali linguistics /');
INSERT INTO new_titles VALUES ('2000/09/28','HF6146.I58 K46 1999','ANQ-1165','Kent, Peter, 1957-','Poor Richard\'s Internet marketing and promotions : how to promote yourself, your business, your ideas online /');
INSERT INTO new_titles VALUES ('2000/09/28','KF3775.A7 A53 1999','ANK-7637','','Environmental protection : law and policy /');
INSERT INTO new_titles VALUES ('2000/09/28','P95.82.Y8 T48 1999','ANE-0707','Thompson, Mark, 1959-','Forging war : the media in Serbia, Croatia, Bosnia and Hercegovina /');
INSERT INTO new_titles VALUES ('2000/09/28','A 13.78:FPL-RP-515','AMH-4189','Wacker, James P.','Field performance of timber bridges');
INSERT INTO new_titles VALUES ('2000/09/28','A 13.78:FPL-RP-518','AMI-8594','','Measurement of flake alignment in flakeboard with grain angle indicator /');
INSERT INTO new_titles VALUES ('2000/09/28','I 1.98:C 99/3/v.1-2','AMD-0436','United States. National Park Service. Southeast Regional Office.','Big Cypress National Preserve, Florida : general management plan, final environmental impact statement.');
INSERT INTO new_titles VALUES ('2000/09/28','I 1.98:C 84/v.1-2','ALY-6833','United States. Bureau of Land Management. Craig District.','Craig District (White River, Kremmling, and Little Snake resource areas) : final wilderness environmental impact stateme');
INSERT INTO new_titles VALUES ('2000/09/28','BL1138.26 .V37 1998','ALT-4250','Varma, Ram Lal, 1926-','Inspiring tales from the Mahabharata /');
INSERT INTO new_titles VALUES ('2000/09/28','RJ506.H9 A336 1999','ALN-1633','','ADHD : research, practice and opinion /');
INSERT INTO new_titles VALUES ('2000/09/28','A 13.78:FPL-471','ALM-6802','Wolfe, Ronald W.','Strength and stiffness of light-frame sloped trusses /');
INSERT INTO new_titles VALUES ('2000/09/28','I 1.98:C 63/3/final/supp./v.1-2','ALJ-0260','','Final environmental impact statement supplement for the Federal Coal Management Program /');
INSERT INTO new_titles VALUES ('2000/09/28','I 1.98:B 86/draft 2/v.1-2','ALE-3984','','Second draft resource management plan and draft environmental impact statement for the Buffalo Resource Area, Casper Dis');
INSERT INTO new_titles VALUES ('2000/09/28','I 1.98:D 54/3/final/v.1-2','ALC-3758','','Proposed Diapir Field lease offering, June 1984 : final environmental impact statement, June 1984 /');
INSERT INTO new_titles VALUES ('2000/09/28','I 1.98:B 38/3/v.1-2','AKY-2887','United States. Bureau of Land Management.','Proposed Federal/State oil and gas lease sale : Beaufort Sea /');
INSERT INTO new_titles VALUES ('2000/09/28','I 1.98:C 63/6/pt.1-2','AKX-8344','United States. Dept. of the Interior.','Development of coal resources in central Utah /');
INSERT INTO new_titles VALUES ('2000/09/28','I 1.98:B 38/3/draft/v.1-2','AKX-6570','United States. Bureau of Land Management.','Proposed Federal/State oil and gas lease sale : Beaufort Sea /');
INSERT INTO new_titles VALUES ('2000/09/28','HE 20.6210/2:','AKC-9410','','Where to write for vital records.');
INSERT INTO new_titles VALUES ('2000/09/28','HE 20.6210:','AKC-9389','','Vital statistics of the United States.');
INSERT INTO new_titles VALUES ('2000/09/28','[DVD] PN1993.5.I829 A733 1998','AJM-8710','','Ardhangini');
INSERT INTO new_titles VALUES ('2000/09/28','[DVD] PN1993.5.I829 M87 1998','AJM-6288','','Muqaddar ka sikandar');
INSERT INTO new_titles VALUES ('2000/09/28','[DVD] PN1993.5.I829 S45 1998','AJM-0013','','Sharaabi');
INSERT INTO new_titles VALUES ('2000/09/28','[DVD] PN1993.5.I829 G87 1998','AJL-9943','','Gupt');
INSERT INTO new_titles VALUES ('2000/09/28','[DVD] PN1993.5.I829 S43 1998','AJL-9988','','Seema');
INSERT INTO new_titles VALUES ('2000/09/28','[DVD] PN1993.5.I829 R34 1998','AJL-9925','','Raja hindustani');
INSERT INTO new_titles VALUES ('2000/09/28','[DVD] PN1993.5.I829 K46 1998','AJL-7973','','Khalnayak [The villain].');
INSERT INTO new_titles VALUES ('2000/09/28','[DVD] PN1993.5.I829 N44 1999','AJL-7972','','Neel kamal');
INSERT INTO new_titles VALUES ('2000/09/28','AS30 .C48','AIU-8118','Civilization (New York, N.Y.)','Civilization : the magazine of the Library of Congress.');
INSERT INTO new_titles VALUES ('2000/09/28','[DVD] PN1993.5.I829 A58 1999','AIT-9989','','Anupama');
INSERT INTO new_titles VALUES ('2000/09/28','[DVD] DS421 .M68 1998','AIG-8515','','Mother India');
INSERT INTO new_titles VALUES ('2000/09/28','SF395.8.A1 P67 vol. 124 1995','AIG-9658','Jacobson, Larry D.','Heat exchangers in swine facilities /');
INSERT INTO new_titles VALUES ('2000/09/28','[DVD] PN1993.5.I829 H46 1998','AIG-8212','','Henna');
INSERT INTO new_titles VALUES ('2000/09/28','QL76.5.U62 N66','AIE-0907','','Inside tracks.');
INSERT INTO new_titles VALUES ('2000/09/28','[DVD] PN1993.5.I829 B37 1998','AIG-8026','','Barsaat');
INSERT INTO new_titles VALUES ('2000/09/28','SF395.8.A1 P67 vol. 82 1995','AIB-7633','','Porcine pleuropneumoniae : Actinobacillus pleuropneumoniae, APP, Haemophilus pleuropneumoniae, HPP /');
INSERT INTO new_titles VALUES ('2000/09/28','SF395.8.A1 P67 vol. 98 1995','AGH-3780','','Porcine proliferative enteritis : (intestinal adenomatosis, necroproliferative enteropathy, proliferative ileitis) /');
INSERT INTO new_titles VALUES ('2000/09/28','CB245 .B76 1992','AFY-4424','Browder, Anthony T. (Anthony Tony)','Nile valley contributions to civilization /');
INSERT INTO new_titles VALUES ('2000/09/28','SF395.8.A1 P67 vol. 130 1993','AFT-8967','Dubey, J. P.','Toxoplasmosis in pigs /');
INSERT INTO new_titles VALUES ('2000/09/28','S15 .P47','AFS-0456','Publicao (Comisso de Combate s Pragas da Cana de Acar no Estado de Pernambuco)','Publicao.');
INSERT INTO new_titles VALUES ('2000/09/28','S15 .P48','AFR-5648','Boletn tcnico (Peru. Servicio de Investigacin y Promocin Agraria)','Boletn tecnico.');
INSERT INTO new_titles VALUES ('2000/09/28','SB290 .K845','AFP-5422','','Planters\' bulletin of the Rubber Research Institute of Malaya.');
INSERT INTO new_titles VALUES ('2000/09/28','SF395.8.A1 P67 vol. 99 1991','ACR-6677','Payeur, Janet B.','Mycobacteriosis (tuberculosis) in swine /');
INSERT INTO new_titles VALUES ('2000/09/28','SF395.8.A1 P67 vol. 103 1991','ACR-6675','Murrell, K. Darwin.','Trichinosis /');
INSERT INTO new_titles VALUES ('2000/09/28','S15 .P455','ACQ-0242','Publicacin tcnica (Estacin Experimental Agropecuaria Pergamino : 1987)','Publicacin tcnica');
INSERT INTO new_titles VALUES ('2000/09/28','TA501 .A643','ACN-7029','','Surveying and land information systems : journal of American Congress on Surveying and Mapping');
INSERT INTO new_titles VALUES ('2000/09/28','SB273 .F673','ACL-2158','Flue cured tobacco calendar and production ideas (Georgia, Florida edition)','Flue cured tobacco calendar and production ideas /');
INSERT INTO new_titles VALUES ('2000/09/28','SB290 .C64','ACA-8199','','Communications of the Research Institute of the S.P.A.');
INSERT INTO new_titles VALUES ('2000/09/28','SD110 .A33','ABZ-2590','Bulletin (Australia. Forestry and Timber Bureau)','Bulletin');
INSERT INTO new_titles VALUES ('2000/09/28','SB290 .K83','ABV-8871','','Annual report of the Rubber Research Institute of Malaya');
INSERT INTO new_titles VALUES ('2000/09/28','TA4 .J214','ABU-7159','','Japanese journal of applied physics.');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-478','AMY-9271','United States. Congress (106th, 1st session : 1999)','Ticket to Work and Work Incentives Improvement Act of 1999 : conference report (to accompany H.R. 1180)');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-474','AMY-9254','United States. Congress. House. Committee on Government Reform.','Government Waste Corrections Act of 1999 : report (to accompany H.R. 1827) (including cost estimate of the Congressional');
INSERT INTO new_titles VALUES ('2000/09/28','D16 .J67 2000','ANY-0647','Jordanova, L. J.','History in practice /');
INSERT INTO new_titles VALUES ('2000/09/28','QK445 .F565 2000','ANY-0655','','Supplement to Flora of New South Wales, Volume 1 /');
INSERT INTO new_titles VALUES ('2000/09/28','DC178 .K45 2000','ANY-0658','Kennedy, Michael L.','The Jacobin clubs in the French Revolution, 1793-1795 /');
INSERT INTO new_titles VALUES ('2000/09/28','CC79.5.A5 A54 2000','ANY-0638','','Animal bones, human societies /');
INSERT INTO new_titles VALUES ('2000/09/28','DA20 .S53 n.s., no. 20','ANY-0645','','Roman fortresses and their legions /');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-4227','Williams, Laurie A. and Robert R. Kessler.','All I Really Know About Programming I Learned in Kindergarten.');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RMRS-RP-1','ANA-0753','Regan, Claudia M.','Vegetation of the Glacier Lakes Ecosystem Experiments Site');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RMRS-RP-2','ANA-0034','','A nonparametric analysis of plot basal area growth using tree based models');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-RP-321','AMY-9611','Wallace, G. N.','Visitor perceptions about grazing on a Forest Service cattle allotment');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-RP-331','AMZ-9193','Ueng, C. Y.','Robust regression analysis of growth in basal area of natural pine stands in Georgia and Alabama, 1962-72 and 1972-82');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-RP-323','AMY-7536','Mills, Todd R.','Evaluation of a habitat capability model for nongame birds in the Black Hills, South Dakota');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-RP-330','AMY-8707','Baisan, Christopher H.','Interactions of fire regimes and land use in the central Rio Grande Valley');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-RP-325','AMY-7843','','Water chemistry of Rocky Mountain Front Range aquatic ecosystems');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-RP-328','AMY-0016','Markstrom, Donald C.','Three-P cubic volume/weight scaling of Black Hills sawtimber');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-RP-329','AMY-0022','Ouyang, Zhao.','Finite population corrections of the Horvitz-Thompson estimator and their application in estimating the variance of regr');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-RP-322','AMY-0020','','Feasibility of a random quadrat study design to estimate changes in density of Mexican spotted owls');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-RP-326','AMX-5800','Williams, Michael S.','Identifying changes in tree form for harvested ponderosa pine in the Black Hills');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-430','AMY-9222','United States. Congress. House. Committee on Rules.','Agreeing to the conference requested by the Senate on H.R. 2990, Quality Care for the Uninsured Act of 1999 : report (to');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-416','AMY-9216','United States. Congress. House. Committee on Resources.','Monument to honor those who have served the nation\'s civil defense and emergency management programs : report (to accomp');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-464','AMY-9183','United States. Congress (106th, 1st session : 1999)','Intellectual Property and Communications Omnibus Reform Act of 1999 : conference report (to accompany H.R. 1554).');
INSERT INTO new_titles VALUES ('2000/10/11','DS62.4 .I73 2000','ANY-9318','','Iran and beyond : essays in Middle Eastern history in honor of Nikki R. Keddie /');
INSERT INTO new_titles VALUES ('2000/10/11','HF3128 .W654 2000','ANY-4687','Wong, John.','Sino-US trade accord and China\'s accession to the World Trade Organization /');
INSERT INTO new_titles VALUES ('2000/10/11','HF5438.35 .H45 2000','ANY-4482','Helmstetter, Greg, 1967-','Affiliate selling : building revenue on the web /');
INSERT INTO new_titles VALUES ('2000/10/11','RC268.45 .F68 1997','ANY-4428','','Food, nutrition and the prevention of cancer : a global perspective /');
INSERT INTO new_titles VALUES ('2000/10/11','HF5547 .K434 2000','ANY-4415','Kanarek, Lisa.','101 home office success secrets /');
INSERT INTO new_titles VALUES ('2000/10/11','HF5549.5.R3 L367 1994','ANY-4414','Latham, Gary P.','Increasing productivity through performance appraisal /');
INSERT INTO new_titles VALUES ('2000/10/11','HG1552.R8 F47 1998','ANY-4384','Ferguson, Niall.','The house of Rothschild /');
INSERT INTO new_titles VALUES ('2000/10/11','Z679.2.U54 M33 1999','ANY-4363','McCarthy, Richard C. (Richard Charles), 1955-','Designing better libraries : selecting and working with building professionals /');
INSERT INTO new_titles VALUES ('2000/10/04','A 13.88:NE-266','AKN-0816','U.S. Department of Agriculture Interagency Research Forum on Gypsy Moth and Other Invasive Species (10th : 1999 : Annapolis, Md.)','Proceedings, U.S. Department of Agriculture Interagency Research Forum on Gypsy Moth and Other Invasive Species, 1999 Ja');
INSERT INTO new_titles VALUES ('2000/10/04','PK2199.J5 A6 1980z','AJX-3731','Jigar Muradabadi, 1890-1960.','Kulliyat-i Jigar /');
INSERT INTO new_titles VALUES ('2000/10/04','PK1723 .S28 1981','AJW-6841','Tagore, Rabindranath, 1861-1941.','Sanjog /');
INSERT INTO new_titles VALUES ('2000/10/04','HM136 .E4613 1991','AIV-9617','Elias, Norbert.','The society of individuals /');
INSERT INTO new_titles VALUES ('2000/10/04','QE351 .P55','AIT-9262','','Plinius.');
INSERT INTO new_titles VALUES ('2000/10/04','HD9049.W3 W58','AFQ-2632','','World grain statistics.');
INSERT INTO new_titles VALUES ('2000/10/04','SB472.55 .N67','AFV-0142','North Carolina Landscape Contractors\' Registration Board.','Roster /');
INSERT INTO new_titles VALUES ('2000/10/04','TS1550 .A6','ACP-0121','','Hojas de divulgacin');
INSERT INTO new_titles VALUES ('2000/10/11','SB413.B2 B46 2000','ANY-4120','Bell, Michael, 1939-','The gardener\'s guide to growing temperate bamboos /');
INSERT INTO new_titles VALUES ('2000/10/11','J 28.2:C 86/22/','ANY-4012','','Criminal justice 2000.');
INSERT INTO new_titles VALUES ('2000/09/28','Z7882 .S20','ABU-3900','Saragoni, H.','Liste des publications sur le tabac : inventaire, par rubrique et auteur, des titres publis par (et pour) le Service Ta');
INSERT INTO new_titles VALUES ('2000/10/11','Y 4.SM 1/2:S.HRG.106-516','ANY-3997','United States. Congress. Senate. Committee on Small Business.','Swindling small businesses : toner-phoner schemes and other office supply scams : hearing before the Committee on Small');
INSERT INTO new_titles VALUES ('2000/09/28','QL392 .C3','ABR-9549','','Folia parasitologica /');
INSERT INTO new_titles VALUES ('2000/09/28','HD268.N5 N326','ABP-4342','New York City Housing Authority.','Real property inventory, city of New York, borough of Manhattan; residential report,');
INSERT INTO new_titles VALUES ('2000/09/28','SD12 .A2','ABN-7544','Alabama. State Commission of Forestry.','Annual report /');
INSERT INTO new_titles VALUES ('2000/09/28','SK461 .W47','ABN-6236','','West Virginia wildlife research');
INSERT INTO new_titles VALUES ('2000/09/28','SF293.M8 M67','ABC-0586','','The Morgan horse');
INSERT INTO new_titles VALUES ('2000/09/28','LD3921 Entom. T38','ABB-9463','Tatman, Robert Lockwood, 1951-','Aedes salt marsh mosquito production in man-made depressions /');
INSERT INTO new_titles VALUES ('2000/09/28','TK7872.S4 S46','AAY-6133','','Solid state technology');
INSERT INTO new_titles VALUES ('2000/09/28','BF11 .U54','AAZ-0291','','Ume psychological reports');
INSERT INTO new_titles VALUES ('2000/09/28','SB13 .P72','AAX-7249','','Vedeck prce strednho vyzkumnho stavu rostlinn vyroby v Praze-Ruzyni');
INSERT INTO new_titles VALUES ('2000/09/28','HD9890.1 .W615','AAX-5895','','Wool science review');
INSERT INTO new_titles VALUES ('2000/09/28','QP501 .F43','AAX-3718','','FEBS letters');
INSERT INTO new_titles VALUES ('2000/09/28','S69 .E74','AAV-6081','Technical bulletin (Life Sciences and Agriculture Experiment Station)','Technical bulletin /');
INSERT INTO new_titles VALUES ('2000/09/28','D101.22550-59/2 Angola a country study','','','');
INSERT INTO new_titles VALUES ('2000/09/29','E441 .H89','ABF-9330','Huggins, Nathan Irvin, 1927-','Black odyssey : the Afro-American ordeal in slavery /');
INSERT INTO new_titles VALUES ('2000/10/03','Q174 .B67 vol. 212','ANZ-4772','Metchnikoff, Elie, 1845-1916.','The evolutionary-biology papers of Elie Metchnikoff /');
INSERT INTO new_titles VALUES ('2000/10/03','Q174 .B67 vol. 210','ANZ-4770','','Knowledge, language, and logic : questions for Quine /');
INSERT INTO new_titles VALUES ('2000/10/03','QK96 .I62 2000','ANZ-4284','','International code of botanical nomenclature (St. Louis Code) : adopted by the Sixteenth International Botanical Congres');
INSERT INTO new_titles VALUES ('2000/10/03','TS198.3.F5 .P65 2000','ANZ-3754','Polymers, Laminations, and Coatings Conference (2000 : Chicago, Ill.)','2000 TAPPI Polymers, Laminations, & Coatings Conference : August 27-31, 2000 ; Westin Hotel ; Chicago, IL.');
INSERT INTO new_titles VALUES ('2000/10/03','RA644.T7 T57 2000','ANZ-3399','Institute of Medicine (U.S.). Committee on the Elimination of Tuberculosis in the United States.','Ending neglect : the elimination of tuberculosis in the United States /');
INSERT INTO new_titles VALUES ('2000/10/03','I 49.1/7:','ANZ-3239','U.S. Fish and Wildlife Service. Division of Law Enforcement.','Annual report /');
INSERT INTO new_titles VALUES ('2000/10/03','SF604 .J896','ANZ-3254','','Journal of veterinary science.');
INSERT INTO new_titles VALUES ('2000/10/03','RA638 .R675 1998','ANZ-1177','Rosen, Shara.','Vaccine trends & developments worldwide /');
INSERT INTO new_titles VALUES ('2000/10/03','HC800 .R425 2000','ANZ-0574','','Reform and growth in Africa /');
INSERT INTO new_titles VALUES ('2000/10/03','QA76.76.O63 M8455 2000','ANY-7409','','Multi-operating system networking : living with Unix, Netware, and NT /');
INSERT INTO new_titles VALUES ('2000/10/03','HQ1064.U6 N463 2000','ANY-7379','Freidenberg, Judith.','Growing old in El Barrio /');
INSERT INTO new_titles VALUES ('2000/10/03','RA410 .H35 2000','ANY-7404','','Handbook of health economics /');
INSERT INTO new_titles VALUES ('2000/10/03','TK5105.5 .N4654 2000','ANY-7341','','Network design : principles and applications /');
INSERT INTO new_titles VALUES ('2000/10/03','T58.64 .E68 2000','ANY-7333','','Enterprise systems integration /');
INSERT INTO new_titles VALUES ('2000/10/03','QH671 .C39 2000','ANY-7330','','Cell death : the role of poly (ADP-ribose) polymerase /');
INSERT INTO new_titles VALUES ('2000/10/03','TD794.5 .M397 2001','ANY-7302','','The McGraw-Hill recycling handbook /');
INSERT INTO new_titles VALUES ('2000/10/03','QA76.9.C55 S38 2000','ANY-7308','','Server management /');
INSERT INTO new_titles VALUES ('2000/10/03','HD9000.6 .J585 1999','ANY-5794','Johnson, Charles S.','Ensuring global food security /');
INSERT INTO new_titles VALUES ('2000/10/03','[videocassette] HN90.V5 V5 1996','ANY-6178','','Violence an American tradition / Produced by Kunhardt Production for Home Box Office.');
INSERT INTO new_titles VALUES ('2000/10/03','[DVD] PN1997.99 .M968 1999','ANY-4926','','My son the fanatic');
INSERT INTO new_titles VALUES ('2000/10/03','TR680 .D429 2000','ANY-4793','Demarchelier, Patrick.','Patrick Demarchelier : glamour.');
INSERT INTO new_titles VALUES ('2000/10/03','NX652.G38 H36 2000','ANY-4790','Hammond, Harmony.','Lesbian art in America : a contemporary history /');
INSERT INTO new_titles VALUES ('2000/10/03','PN1993.5.I8 C5 2000','ANY-4750','Chowdhry, Prem.','Colonial India and the making of empire cinema : image, ideology and identity /');
INSERT INTO new_titles VALUES ('2000/10/03','NA997.P38 S83 2000','ANY-4720','Sudjic, Deyan, 1952-','John Pawson works /');
INSERT INTO new_titles VALUES ('2000/10/03','T58.62 .N49 2000','ANY-4684','','New frontiers of decision making for the information technology era /');
INSERT INTO new_titles VALUES ('2000/10/03','QC176.8.M5 I58 1998','ANY-4348','International Microprocesses and Nanotechnology Conference (1998 : Kyongju-si, Korea)','Microprocesses and Nanotechnology \'98 : digest of papers : 1998 International Microprocesses and Nanotechnology Conferen');
INSERT INTO new_titles VALUES ('2000/10/03','SD399.7 .P66 1995','ANX-7318','','Population genetics and genetic conservation of forest trees /');
INSERT INTO new_titles VALUES ('2000/10/03','KFN7628 .L39 2000','ANX-6042','Lawrence, David M.','Economic development law for North Carolina local governments /');
INSERT INTO new_titles VALUES ('2000/10/03','KFN7734 .A25 2000','ANX-5836','North Carolina. General Assembly. Legislative Research Commission. Committee on State Employees and Teachers Compensation.','State employees and teachers compensation : report to the 2000 session of the 1999 General Assembly of North Carolina /');
INSERT INTO new_titles VALUES ('2000/10/03','KFN7976.6 .A25 2000','ANX-5433','North Carolina. General Assembly. Legislative Research Commission. Bail Bond Laws Committee.','Legislative Research Commission, Bail Bond Laws Committee : report to the 2000 session of the 1999 General Assembly of N');
INSERT INTO new_titles VALUES ('2000/10/02','RC870 .J68','AAY-8936','','The Journal of urology');
INSERT INTO new_titles VALUES ('2000/10/03','PS3557.U814 I8 1997','ANX-2129','Gurganus, Allan, 1947-','It had wings : a story /');
INSERT INTO new_titles VALUES ('2000/10/03','TA418.9.P6 M45 1999','ANX-4116','','Metal foams and porous metal structures /');
INSERT INTO new_titles VALUES ('2000/10/02','QH301 .B7','AAY-8865','','The Journal of experimental biology');
INSERT INTO new_titles VALUES ('2000/10/02','TP156.P6 J55','AAY-8821','','Journal of applied polymer science');
INSERT INTO new_titles VALUES ('2000/10/02','QR1 .I35','AAY-8642','','Infection and immunity');
INSERT INTO new_titles VALUES ('2000/10/02','TS1300 .I95','AAY-8752','International textiles (Amsterdam, Netherlands)','International textiles');
INSERT INTO new_titles VALUES ('2000/10/02','TA419.A1 H64','AAY-8485','','Holzforschung');
INSERT INTO new_titles VALUES ('2000/10/02','QH91.A1 M35','AAY-5982','Marine biology (Berlin, Germany)','Marine biology');
INSERT INTO new_titles VALUES ('2000/10/02','QL1 .L6','AAY-3603','','The Journal of the Linnean Society.');
INSERT INTO new_titles VALUES ('2000/10/02','TN269 .G4','AAX-3902','Geophysical prospecting (Hague, Netherlands)','Geophysical prospecting');
INSERT INTO new_titles VALUES ('2000/10/02','RC475 .P7','AAX-5803','Psychotherapy (Chicago, Ill.)','Psychotherapy');
INSERT INTO new_titles VALUES ('2000/10/02','QD281.P6 E8','AAX-3630','','European polymer journal');
INSERT INTO new_titles VALUES ('2000/10/02','RC799 .G29','AAX-3867','','Gastroenterology official journal of the American Gastroenterological Association.');
INSERT INTO new_titles VALUES ('2000/10/02','RC681.A1 C6','AAX-2140','Circulation (New York, N.Y. : 1950)','Circulation');
INSERT INTO new_titles VALUES ('2000/10/02','RM1 .E86','AAX-3629','','European journal of pharmacology');
INSERT INTO new_titles VALUES ('2000/10/02','RC261 .C22','AAX-1988','','Cancer');
INSERT INTO new_titles VALUES ('2000/10/02','RC261 .C34','AAX-1992','','Cancer research');
INSERT INTO new_titles VALUES ('2000/10/02','SF995 .A26','AAW-8152','','Avian diseases');
INSERT INTO new_titles VALUES ('2000/10/02','TS1300 .C25','AAX-1984','','Canadian textile journal.');
INSERT INTO new_titles VALUES ('2000/10/02','HE368 .A9','AAW-8139','','Australian road research');
INSERT INTO new_titles VALUES ('2000/10/02','RD1 .S850','AAW-4086','Surgical forum (American College of Surgeons).','Surgical forum');
INSERT INTO new_titles VALUES ('2000/10/06','GA 1.5/A-2:B-276050.2','AOD-1180','United States. General Accounting Office.','[Request for recommendation for Army Corps of Engineers payment of protest costs]');
INSERT INTO new_titles VALUES ('2000/10/02','RB1 .A4','AAW-4062','','The American journal of pathology');
INSERT INTO new_titles VALUES ('2000/10/06','GA 1.5/A-2:B-276040','AOD-1172','United States. General Accounting Office.','[Protest of DISA modification of contract for satellite communications services]');
INSERT INTO new_titles VALUES ('2000/10/06','GA 1.5/A-2:B-276030.2','AOD-1168','United States. General Accounting Office.','[Request for reimbursement of protest preparation costs]');
INSERT INTO new_titles VALUES ('2000/10/06','GA 1.5/A-2:B-27999.4','AOD-1166','United States. General Accounting Office.','[Protest of Army rejection of bid for equipment maintenance]');
INSERT INTO new_titles VALUES ('2000/10/06','GA 1.5/A-2:B-276012','AOD-1163','United States. General Accounting Office.','[Protest of GSA solicitation for security guard services]');
INSERT INTO new_titles VALUES ('2000/10/06','GA 1.5/A-2:B-275803','AOD-1162','United States. General Accounting Office.','[Protest of GSA solicitation for leased space]');
INSERT INTO new_titles VALUES ('2000/10/06','GA 1.5/A-2:B-275725.3','AOD-1160','United States. General Accounting Office.','[Protest of Coast Guard decision to reopen discussions under solicitation for repair services]');
INSERT INTO new_titles VALUES ('2000/10/06','E 1.38/5:','AOC-2963','','Wind energy program overview');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-4200','Lemonick, Michael D. and Andrea Dorfman','Amazing Vikings');
INSERT INTO new_titles VALUES ('2000/10/06','Y 1.1/8:106-686','AOB-7451','','Report on the revised suballocation of budget allocations for fiscal year 2001 /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 12590','AJS-5435','Ciglic, Mauro Igor Alexander, 1969-','Folding, form, function evolutionary aspects of bovine seminal ribonuclease /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 12573','AJS-5434','Bertschy, Catherine, 1960-','Diversified cassava agroecosystems : chemically mediated searching behaviour of parasitoids /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 12568','AJS-5433','Schwank, Silvia Annamaria, 1968-','Novel methods to study antibiotic activity in in-vitro simulations of infectious diseases involving bacterial biofilms /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 12553','AJS-5431','Nebel, Sibylle F., 1965-','The role of DNA mismatch repair in drug resistance /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 12549','AJS-5430','Carenini, Stefano, 1970-','Functional roles of cell membrane proteins in the formation and maintenance of peripheral myelin /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 12543','AJS-5429','Zipper, Christian 1966-','Microbial degradation and environmental fate of chiral phenoxyalkanoic acid herbicides /');
INSERT INTO new_titles VALUES ('2000/10/26','MF 162 no. 12542','AJS-5282','Arnold, Cedric Georges 1969-','Triorganotin compounds in natural waters and sediments : aqueous speciation and sorption mechanismus /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 12526','AJS-5280','Kaufmann, Peter 1967-','Applied genetics and molecular identification of bifidobacteria /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 12507','AJS-5278','Mittendorf, Elke 1966-','Data corruption and information retrieval /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 11448','AJS-5167','Mhlebach, Stephan Markus.','The creatine kinase isoenzyme family : Mi[subscript a]-CK gene structure, expression during embryonic development and ev');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 12500','AJS-5276','Monnard, Peirre-Alain Michel 1969-','Preparation and properties of DNA containing liposomes /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 11450','AJS-5165','Wilhalm, Thomas.','Clonal growth and fragmentation in the alpine tussock-forming grass Poa alpina /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 11574','AJS-5163','Stadler, Daniele Claudio.','Water and solute dynamics in frozen forest soils measurement and modelling /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 11579','AJS-5161','Pellegrini, Luca.','Structure of serum response factor core bound to DNA /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 11618','AJS-5160','Mller, Matthias.','Function of tumor necrosis factor and lymphotoxin a in the murine immune system : evidence from knockout mice /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 11627','AJS-5159','Schraff, Christoph H.','Data assimilation and mesoscale weather prediction : a study with a forecast model for the Alpine region /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 10479','AJS-5125','Krachi, Norbert.','Modelling forest succession as influenced by a changing environment /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 10504','AJS-5101','Ponti, Charly.','Improvement of the aerobic thermophilic sludge treatment at pilot plant scale/');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 10502','AJS-5100','Ferrero-Grassi, Andrea Eugenio.','Fluidised bed reactors for the industrial cultivation of CHO cells producing a human gonadotropin /');
INSERT INTO new_titles VALUES ('2000/10/26','Mf 162 no. 10423','AJS-5099','Piani, Daniela.','Immune-mediated cytotoxicity in the central nervous system /');
INSERT INTO new_titles VALUES ('2000/10/26','QA11 .Q32 1998','AJQ-3316','','Qualitative research methods in mathematics education /');
INSERT INTO new_titles VALUES ('2000/10/26','TK5103.2 .Y36 1998','AJO-2157','Yang, Samuel C.','CDMA RF system engineering /');
INSERT INTO new_titles VALUES ('2000/10/26','TX601 .V36 1994','AIV-5038','VanGarde, Shirley J.','Food preservation and safety : principles and practices /');
INSERT INTO new_titles VALUES ('2000/10/26','NA200 .F63 1996','AIP-9236','Fletcher, Banister, Sir, 1866-1953.','Sir Banister Fletcher\'s a history of architecture.');
INSERT INTO new_titles VALUES ('2000/10/26','Z5937 .A7','AID-3452','','Art index');
INSERT INTO new_titles VALUES ('2000/10/26','TR145 .L66 1994','AIB-6172','London, Barbara, 1936-','Photography /');
INSERT INTO new_titles VALUES ('2000/10/26','HT391 .B83 1996','AIO-0982','Bush, David M.','Living by the rules of the sea /');
INSERT INTO new_titles VALUES ('2000/10/26','QL681 .B62 1992','AGB-5181','','The Birds of North America : life histories for the 21st century /');
INSERT INTO new_titles VALUES ('2000/10/26','QC665.E4 R36 1994','AFV-6575','Ramo, Simon.','Fields and waves in communication electronics /');
INSERT INTO new_titles VALUES ('2000/10/26','QA11 .N29 1991','ACP-1221','National Council of Teachers of Mathematics. Commission on Teaching Standards for School Mathematics.','Professional standards for teaching mathematics /');
INSERT INTO new_titles VALUES ('2000/10/26','PS3545.O337 Z8633 1985','ACB-1553','','Thomas Wolfe interviewed, 1929-1938 /');
INSERT INTO new_titles VALUES ('2000/10/26','TL240 .C23','ACJ-5039','','Car styling');
INSERT INTO new_titles VALUES ('2000/10/26','GV181.5 .C84 1986','ACD-7701','Culkin, David F.','Managing human resources in recreation, parks, and leisure services /');
INSERT INTO new_titles VALUES ('2000/10/26','QC21.2 .B474 vol. 2','ABY-3954','Purcell, Edward M.','Electricity and magnetism /');
INSERT INTO new_titles VALUES ('2000/10/26','PN86 .L53 1984','ABY-5428','','Literature criticism from 1400 to 1800 : excerpts from criticism of the works of fifteenth, sixteenth, seventeenth, and');
INSERT INTO new_titles VALUES ('2000/10/26','RL1 .D39','ABV-6351','','Dermatologic clinics');
INSERT INTO new_titles VALUES ('2000/10/26','N11 .A7','ABP-3832','Art bulletin (College Art Association of America)','The Art bulletin');
INSERT INTO new_titles VALUES ('2000/10/26','PS3525.A282 L80 1922','ABP-9099','McNeill, John Charles, 1874-1907.','Lyrics from cotton land /');
INSERT INTO new_titles VALUES ('2000/10/26','NA1428 .G8','ABM-8589','Gusti, Gustav.','Arhitectura n Romnia. Architecture in Romania.');
INSERT INTO new_titles VALUES ('2000/10/26','PS3545.O337 C7580 1919a','ABM-5520','Wolfe, Thomas, 1900-1938.','The crisis in industry /');
INSERT INTO new_titles VALUES ('2000/10/26','PS3545.O337 C7590','ABM-5521','Walser, Richard Gaither, 1908-','Prolegomena to Thomas Wolfe\'s A crisis in industry /');
INSERT INTO new_titles VALUES ('2000/10/26','PS3545.O337 Z934','ABJ-2105','Walser, Richard Gaither, 1908-','The Wolfe family in Raleigh /');
INSERT INTO new_titles VALUES ('2000/10/26','PS3525.A282 P6 1977','ABI-0346','McNeill, John Charles, 1874-1907.','Possums and persimmons : newly collected poems /');
INSERT INTO new_titles VALUES ('2000/10/26','PA445.E5 C6','ABH-4026','','The classic Greek dictionary; Greek-English and English-Greek,');
INSERT INTO new_titles VALUES ('2000/10/26','Z5935 .L64','AAZ-2124','','Artbibliographies modern.');
INSERT INTO new_titles VALUES ('2000/10/26','NA2795 .V36 1977','ABD-5768','Van Zanten, David, 1943-','The architectural polychromy of the 1830\'s /');
INSERT INTO new_titles VALUES ('2000/10/26','NA4 .D6','ABB-2120','','Domus');
INSERT INTO new_titles VALUES ('2000/10/26','RD34 .S85','AAY-6005','','The Surgical clinics of North America');
INSERT INTO new_titles VALUES ('2000/10/26','GR110.N8 B47','AAY-2482','Betts, Leonidas.','Gateway to North Carolina folklore /');
INSERT INTO new_titles VALUES ('2000/10/26','N1 .A78','AAX-4962','Arts magazine (New York, N.Y.)','Arts magazine');
INSERT INTO new_titles VALUES ('2000/10/26','NA4 .C3','AAX-2015','','Casabella');
INSERT INTO new_titles VALUES ('2000/10/26','QL402 .R13','AAX-0968','Rafinesque, C. S. (Constantine Samuel), 1783-1840.','The complete writings of Constantine Smaltz Rafinesque, on recent & fossil conchology.');
INSERT INTO new_titles VALUES ('2000/10/26','PS2649.P5 Z63','AAU-7834','Arnett, Ethel Stephens.','O. Henry from Polecat Creek; a memorial edition for William Sydney Porter,');
INSERT INTO new_titles VALUES ('2000/10/26','PE1628 .F65 1927','AAS-5069','Fowler, H. W. (Henry Watson), 1858-1933.','A dictionary of modern English usage,');
INSERT INTO new_titles VALUES ('2000/10/26','NA645 .H55','AAR-7736','Hitchcock, Henry Russell, 1903-','Architecture: nineteenth and twentieth centuries.');
INSERT INTO new_titles VALUES ('2000/10/26','PS1999.H473 Z9','AAR-4316','Walser, Richard Gaither, 1908-','The black poet; being the remarkable story (partly told my [sic] himself) of George Moses Horton, a North Carolina slave');
INSERT INTO new_titles VALUES ('2000/10/26','NA1035 .W53','AAQ-9156','','Die Wiener Ringstrasse, Bild einer Epoche; die Erweiterung der inneren Stadt Wien unter Kaiser Franz Joseph.');
INSERT INTO new_titles VALUES ('2000/10/26','NA680 .W7','AAK-9446','Wright, Frank Lloyd, 1867-1959.','The future of architecture.');
INSERT INTO new_titles VALUES ('2000/10/26','PS3569.M5376 L3 1968','AAJ-9622','Smith, Lee, 1944-','The last day the dogbushes bloomed /');
INSERT INTO new_titles VALUES ('2000/10/26','PS3545.O337 Z863','AAE-5443','','Thomas Wolfe and the glass of time.');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-490','AMZ-3852','McEwen, Douglas N.','Campsite impacts in four wildernesses in the South-Central United States /');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-488','AMZ-1532','Cole, David N.','Wilderness recreation use trends, 1965 through 1994');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-496','AMZ-1310','','High-use destinations in wilderness social and biophysical impacts, visitor responses, and management options /');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-491','AMY-6792','','Elk and domestic sheep interactions in a north-central Utah aspen ecosystem');
INSERT INTO new_titles VALUES ('2000/10/20','QA440 .J64','AMY-6167','','Journal for geometry and graphics.');
INSERT INTO new_titles VALUES ('2000/10/06','QA267 .I23 2000','AOA-5726','ICALP 2000 Conference (2000 : Geneva, Switzerland)','Automata, languages and programming : 27th international colloquium, ICALP 2000, Geneva, Switzerland, July 9-15, 2000 ;');
INSERT INTO new_titles VALUES ('2000/10/06','QR201.D4 C54 2000','AOA-5725','','Clostridium difficile /');
INSERT INTO new_titles VALUES ('2000/10/06','TA450 .S87 2000','AOA-5724','','Surface-active processes in materials /');
INSERT INTO new_titles VALUES ('2000/10/06','QC793.5.N4627 I55 1999','AOA-5723','International Symposium on Capture Gamma-Ray Spectroscopy and Related Topics (10th : 1999 : Santa Fe, N.M.)','Capture gamma-ray spectroscopy and related topics : 10th international symposium : Santa Fe, New Mexico, 30 August-3 Sep');
INSERT INTO new_titles VALUES ('2000/10/06','Q325.5 .L43 2000','ANZ-5236','','Learning classifier systems : from foundations to applications /');
INSERT INTO new_titles VALUES ('2000/10/06','QA76.63 .I57 2000','ANZ-5237','International Workshop on Logic Program Synthesis and Transformation (9th : 1999 : Venice, Italy)','Logic-based program synthesis and transformation : 9th International Workshop, LOPSTR \'99, Venice, Italy, September 22-2');
INSERT INTO new_titles VALUES ('2000/10/06','UA23 .A663527 2000','ANZ-0399','','America\'s strategic choices /');
INSERT INTO new_titles VALUES ('2000/10/06','DA510 .G68 2000','ANY-9515','Gould, Eliga H.','The persistence of empire : British political culture in the age of the American Revolution /');
INSERT INTO new_titles VALUES ('2000/10/06','NA1191 .D66 1956','ANY-9507','Dmochowski, Zbigniew, 1906-','The architecture of Poland : an historical survey /');
INSERT INTO new_titles VALUES ('2000/10/06','NA1020 .M47 1965','ANY-9493','Mernyi, Ferenc.','1867-1965, cento anni architettura ungherese : appunti per una storia dell\'architettura contemporanea ungherese /');
INSERT INTO new_titles VALUES ('2000/10/06','NA1117 .J6 1985','ANY-9490','Jodice, Romano.','L\'architettura del ferro : l\'Italia (1796-1914) /');
INSERT INTO new_titles VALUES ('2000/10/06','NA1088.S3 K36 1981','ANY-9488','','Karl Friedrich Schinkel /');
INSERT INTO new_titles VALUES ('2000/10/06','NA1088.S3 A2 1979','ANY-9485','Schinkel, Karl Friedrich, 1781-1841.','Karl Friedrich Schinkel : Reisen nach Italien : Tagebcher, Briefe, Zeichnungen, Aquarelle /');
INSERT INTO new_titles VALUES ('2000/10/06','NA1123.P2 M67 1973','ANY-9484','','Mostra del Palladio. Vicenza, Basilica Palladiana /');
INSERT INTO new_titles VALUES ('2000/10/06','DA375 .S55 2000','ANY-9425','Sharpe, Kevin (Kevin M.)','Reading revolutions : the politics of reading in early modern England /');
INSERT INTO new_titles VALUES ('2000/10/06','F319.M6 L48 2000','ANY-9423','Levine, Robert M.','Cuban Miami /');
INSERT INTO new_titles VALUES ('2000/10/06','F376 .H66 2000','ANY-9417','Honigsberg, Peter Jan.','Crossing Border Street : a civil rights memoir /');
INSERT INTO new_titles VALUES ('2000/10/06','DA47.65 .F65 2000','ANY-9395','Folly, Martin H., 1957-','Churchill, Whitehall, and the Soviet Union, 1940-45 /');
INSERT INTO new_titles VALUES ('2000/10/06','E666 .H44 2000','ANY-9316','Hearn, Chester G.','The impeachment of Andrew Johnson /');
INSERT INTO new_titles VALUES ('2000/10/06','Y 1.1/8:106-704','ANY-9277','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 4461, the Agriculture, Rural Development, Food and Drug Administration, and Rela');
INSERT INTO new_titles VALUES ('2000/10/06','Y 1.1/8:106-708','ANY-9276','United States. Congress. House. Committee on Rules.','Providing for the consideration of a concurrent resolution for the adjournment of the House and Senate for the Independe');
INSERT INTO new_titles VALUES ('2000/10/11','Y 4.P 96/10:S.HRG.106-504','ANY-3996','','106-1 Hearings: Habitat Conservation Plans, S. Hrg. 106-504, July 20, 1999, July 21, 1999, October 19, 1999, November 3,');
INSERT INTO new_titles VALUES ('2000/10/11','Y 4.L 11/4:S.HRG.106-509','ANY-3995','United States. Congress. Senate. Committee on Health, Education, Labor, and Pensions.','Reauthorization of the Ryan White Care Act : hearing before the Committee on Health, Education, Labor, and Pensions, Uni');
INSERT INTO new_titles VALUES ('2000/10/11','Y 4.L 11/4:S.HRG.106-502','ANY-3994','','106-2 Joint Hearing: Medical Errors: Administration Response And Other Perspectives, S. Hrg. 106-502, February 22, 2000,');
INSERT INTO new_titles VALUES ('2000/10/11','Y 4.J 89/2:S.HRG.106-517','ANY-3993','','106-1 Hearing: Combating Hate Crimes: Promoting A Responsive And Responsible Role For The Federal Government, S. Hrg. 10');
INSERT INTO new_titles VALUES ('2000/09/30','NX454.5.M63 C48 2000','ANY-7396','Childs, Peter, 1962-','Modernism /');
INSERT INTO new_titles VALUES ('2000/09/30','NA737.G95 G84 2000','ANX-5769','','Gwathmey Siegel : buildings and projects 1965-2000 /');
INSERT INTO new_titles VALUES ('2000/09/30','C 61.48:','AJH-8982','','U.S. industry & trade outlook.');
INSERT INTO new_titles VALUES ('2000/09/30','BL624 .H377 1997','ANW-1659','Hayward, Jeremy W.','Letters to Vanessa : on love, science, and awareness in an enchanted world /');
INSERT INTO new_titles VALUES ('2000/09/30','QA75.5 .C34','AID-0954','','Chicago journal of theoretical computer science');
INSERT INTO new_titles VALUES ('2000/09/30','NC139.M4 A4 1991','AFW-3081','Mead, Syd.','Kronolog the art of Syd Mead /');
INSERT INTO new_titles VALUES ('2000/09/30','SB21 .N7','ABT-1231','Western New York Horticultural Society.','Proceedings of the ... annual meeting');
INSERT INTO new_titles VALUES ('2000/09/30','SB824.G4 A3','ABQ-9392','Bulletin (Georgia. State Board of Entomology)','Bulletin');
INSERT INTO new_titles VALUES ('2000/09/30','SB401.A1 N82','ABJ-9518','Nut Growers Society of Oregon, Washington & British Columbia.','Proceedings of the Nut Growers Society of Oregon, Washington & British Columbia');
INSERT INTO new_titles VALUES ('2000/09/30','S399 .E49','ABA-1735','Research report (Hawaii Agricultural Experiment Station)','Research report /');
INSERT INTO new_titles VALUES ('2000/09/30','t40.e9b3 cop.2 oliver evans','','','');
INSERT INTO new_titles VALUES ('2000/09/30','QH90.A1 M45','AAZ-1780','','Meteor Forschungsergebnisse.');
INSERT INTO new_titles VALUES ('2000/10/09','AM7 .K37 2000','ANY-9410','Kavanagh, Gaynor.','Dream spaces : memory and the museum /');
INSERT INTO new_titles VALUES ('2000/10/09','DC125 .B45 2000','ANY-9390','Beik, William, 1941-','Louis XIV and absolutism : a brief study with documents.');
INSERT INTO new_titles VALUES ('2000/10/09','HD9696.63.U64 M533 2001','ANY-7420','Brinkley, Joel, 1952-','U.S. v. Microsoft /');
INSERT INTO new_titles VALUES ('2000/10/09','G155.A1 T58936 2000','ANY-7418','','Tourism and national parks : issues and implications /');
INSERT INTO new_titles VALUES ('2000/10/09','QA329 .K54 2000','ANY-7419','Klement, E. P. (Erich Peter)','Triangular norms /');
INSERT INTO new_titles VALUES ('2000/10/09','HT861 .T87 2000','ANY-7416','Turley, David, 1941-','Slavery /');
INSERT INTO new_titles VALUES ('2000/10/09','NX688.A4 W66 2000','ANY-7398','','Women, patronage, and self-representation in Islamic societies /');
INSERT INTO new_titles VALUES ('2000/10/09','PR6045.O72 Z898 2000','ANY-7389','West, Ruth, 1948-','Virginia Woolf /');
INSERT INTO new_titles VALUES ('2000/10/09','NA6230 .Y43 2000','ANY-7367','Yeang, Ken, 1948-','Service cores /');
INSERT INTO new_titles VALUES ('2000/10/09','HM133 .S33 2000','ANY-7356','Scannell, Edward E.','Human resource development : the new trainer\'s guide /');
INSERT INTO new_titles VALUES ('2000/10/09','LB2367.6 .M37 2000','ANY-7340','','Master the MAT /');
INSERT INTO new_titles VALUES ('2000/10/09','NA730.N8 F37 1997','ANY-4903','','Far fetched and dear bought four architects who changed North Carolina /');
INSERT INTO new_titles VALUES ('2000/10/09','TK7872.S8 S795 2000','ANY-4656','','Superconducting materials : advances in technology and applications : International Advanced School Leonardo Da Vinci, 1');
INSERT INTO new_titles VALUES ('2000/10/09','QA76.9.D3 L3645 2000','ANY-4559','Langer, Maria.','FileMaker Pro 5 companion /');
INSERT INTO new_titles VALUES ('2000/10/09','QP534 .C585 2000','ANY-4569','','Clinical nutrition of the essential trace elements and minerals : the guide for health professionals /');
INSERT INTO new_titles VALUES ('2000/10/09','TH7222 .L48 2000','ANY-4503','Levy, Sidney M.','MEP databook /');
INSERT INTO new_titles VALUES ('2000/10/09','HF5548.32 .R67 2000','ANY-4475','Rosen, Anita.','The E-commerce question and answer book : a survival guide for business managers /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:34115-E 1-TM-100/999','ANY-8976','United States. Bureau of Land Management.','California Desert District : Amboy : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:35116-E 1-TM-100/999','ANY-8975','United States. Bureau of Land Management.','California Desert District : Owlshead Mountain : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:36117-A 1-TM-100/999','ANY-8974','United States. Bureau of Land Management.','California Desert District : Darwin Hills : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:34114-A 1-TM-100/998','ANY-8971','United States. Bureau of Land Management.','Arizona [California] Desert District : Parker : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','[DVD] PN1997.99 .E23 2000','ANY-4116','','East is East');
INSERT INTO new_titles VALUES ('2000/10/12','SF757.2 .T59 2000','ANY-7297','Tizard, Ian R.','Veterinary immunology : an introduction /');
INSERT INTO new_titles VALUES ('2000/10/12','Y 3.C 76/3:11/12/2000','ANY-4039','','Fireworks Publication #12, July 21, 2000');
INSERT INTO new_titles VALUES ('2000/10/12','PREX 26.2:SU 4','ANY-4038','','You Can Help.');
INSERT INTO new_titles VALUES ('2000/10/12','PREX 23.14:H 99','ANY-4037','','An Integrated Assessment HYPOXIA In The Northern Gulf Of Mexico, May 2000');
INSERT INTO new_titles VALUES ('2000/10/12','L 2.132:2000-13','ANY-4036','','Labor supply in a tight labor market.');
INSERT INTO new_titles VALUES ('2000/10/12','J 28.24/3:V 81','ANY-4035','Tjaden, Patricia Godeke.','Extent, nature, and consequences of intimate partner violence /');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.42/4:00-4067','ANY-4031','Trainer, Frank W. (Frank Wilson), 1921-','Geothermal hydrology of Valles Caldera and the southwestern Jemez Mountains, New Mexico /');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.42/4:00-4064','ANY-4030','','Regional Equations For Estimating Mean Annual And Mean Seasonal Runoff For Natural Basins In Texas, Base Period 1961-90,');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.42/4:00-4062','ANY-4029','','Phosphorus And E. Coli In The Fanno And Bronson Creek Sub-Basins Of The Tualatin River Basin, Oregon, During Summer Low-');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.42/4:00-4005','ANY-4028','','Pesticides In Surface Waters Of The Upper Colorado River Basin, Colorado, 1996-98, U.S. Geological Survey, Water-Resourc');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.127:190-99','ANY-4027','','History of landslides at the base of Bare Mountain, Tully Valley, Onondage County, New York.');
INSERT INTO new_titles VALUES ('2000/10/12','I 49.44/2:SA 5/8/2000','ANY-4026','','Sand Lake, national wildlife refuge & wetland management district.');
INSERT INTO new_titles VALUES ('2000/10/12','I 49.44/2:D 45/2/2000','ANY-4025','','Birds Of Desert National Wildlife Range, Nevada, July 2000');
INSERT INTO new_titles VALUES ('2000/10/09','TK5105 .P385 2000','ANY-4472','Patten, Karen, 1947-','Data networking made easy : the small business guide to getting wired for success /');
INSERT INTO new_titles VALUES ('2000/10/09','HD30.37 .P68 2000','ANY-4467','Pottruck, David S., 1948-','Clicks and mortar : passion-driven growth in an internet-driven world /');
INSERT INTO new_titles VALUES ('2000/10/09','HF5548.32 .E97 2000','ANY-4435','','Executive\'s guide to e-business : from tactics to strategy /');
INSERT INTO new_titles VALUES ('2000/10/09','QL83.2 .C85 1998','ANY-4124','Cuny, Lynn Marie, 1951-','Through animals\' eyes : true stories from a wildlife sanctuary /');
INSERT INTO new_titles VALUES ('2000/10/09','DA1 .P53 2000','ANY-3600','Phillips, Mark, 1946-','Society and sentiment : genres of historical writing in Britain, 1740-1820 /');
INSERT INTO new_titles VALUES ('2000/10/09','DR2087 .C48 1999','ANY-3529','Chomsky, Noam.','The new military humanism : lessons from Kosovo /');
INSERT INTO new_titles VALUES ('2000/10/09','F1787.5 .A6975 2000','ANY-3527','Ameringer, Charles D., 1926-','The Cuban democratic experience : the autntico years, 1944-1952 /');
INSERT INTO new_titles VALUES ('2000/10/09','RM333.5 .N47 2000','ANY-3519','','Neurotransmitter receptors in actions of antipsychotic medications /');
INSERT INTO new_titles VALUES ('2000/10/09','LB1715 .R42 2000','ANY-2254','','Research on effective models for teacher education /');
INSERT INTO new_titles VALUES ('2000/10/09','TX601 .C64313 1999','ANY-2248','Conserves naturelles des quatre saisons. English.','Keeping food fresh : old-world techniques & recipes : the gardeners and farmers of Terre Vivante.');
INSERT INTO new_titles VALUES ('2000/10/09','QP801.P636 P49 1998','ANY-2030','','Phytochemicals : a new paradigm /');
INSERT INTO new_titles VALUES ('2000/10/09','TK6678 .T46 1999','ANY-2007','Thomas, Jeffrey L.','Digital basics for cable television systems /');
INSERT INTO new_titles VALUES ('2000/10/09','QR41.2 .B77 2000','ANY-1649','Madigan, Michael T., 1949-','Brock biology of microorganisms /');
INSERT INTO new_titles VALUES ('2000/10/09','QH585.5.F56 F585 2000','ANY-1606','','Flow cytometry : a practical approach /');
INSERT INTO new_titles VALUES ('2000/10/09','HN373.5 .R43 2000','ANY-0937','','Recasting European welfare states /');
INSERT INTO new_titles VALUES ('2000/10/09','QR183.6 .L66 1999','ANY-1594','Loos, C. M. van der.','Immunoenzyme multiple staining methods /');
INSERT INTO new_titles VALUES ('2000/10/09','DC137.1 .L4813 2000','ANY-0697','Lever, Evelyne.','Marie Antoinette : the last queen of France /');
INSERT INTO new_titles VALUES ('2000/10/09','PA8595.W454 A115 2000','ANX-9491','Westonia, Elizabetha Johanna, 1582-1612.','Collected writings /');
INSERT INTO new_titles VALUES ('2000/10/09','QA1 .A647 vol. 140','ANX-9296','Cherkaev, Andrej, 1950-','Variational methods for structural optimization /');
INSERT INTO new_titles VALUES ('2000/10/09','HC440.P6 I53 2000','ANX-8030','','India : reducing poverty, accelerating development /');
INSERT INTO new_titles VALUES ('2000/10/04','QA76.8.I1015 P38','ACF-3453','PC magazine (New York, N.Y.)','PC magazine');
INSERT INTO new_titles VALUES ('2000/10/09','TK5105.35 .D37 1996','ANX-7788','Frame Relay Forum. Technical Committee.','Data compression over frame relay implementation agreement /');
INSERT INTO new_titles VALUES ('2000/10/04','S303 .T84','ACC-2061','','Tokai Kinki Nogyo Shikenjo tokubetsu hokoku, Saibai Dai 1-bu = Special bulletin of the First Agronomy Division, Tokai-Ki');
INSERT INTO new_titles VALUES ('2000/10/04','SB921 .A28','ABT-8161','','Division of Entomology annual report');
INSERT INTO new_titles VALUES ('2000/10/04','QE282 .A23','ABZ-7792','','Ser. C.');
INSERT INTO new_titles VALUES ('2000/10/04','NA737.K32 P450','ABJ-0531','Pennsylvania Academy of the Fine Arts','The travel sketches of Louis I. Kahn : an exhibition ... 1978-1979 /');
INSERT INTO new_titles VALUES ('2000/10/04','S583 .E53','ABP-9834','','Energia nuclear e agricultura.');
INSERT INTO new_titles VALUES ('2000/10/11','Y 4.F 49:S.HRG.106-510','ANY-3992','United States. Congress. Senate. Committee on Finance. Subcommittee on International Trade.','Agriculture negotiations in the WTO after Seattle : hearing before the Subcommittee on International Trade of the Commit');
INSERT INTO new_titles VALUES ('2000/10/11','Y 4.R 31/3:106-72','ANY-3991','United States. Congress. House. Committee on Resources. Subcommittee on National Parks and Public Lands.','Hearing on H.R. 834, a bill to extend the authorization for the National Historic Preservation Fund, and for other purpo');
INSERT INTO new_titles VALUES ('2000/10/11','Y 4.J 89/1:106/49','ANY-3990','','106-1 Hearing: First Amendment And Restrictions On Political Speech, Serial No. 49, May 5, 1999');
INSERT INTO new_titles VALUES ('2000/10/11','Y 4.C 73/8:106-101','ANY-3989','United States. Congress. House. Committee on Commerce. Subcommittee on Health and the Environment.','National implementation of the Reformulated Gasoline Program : hearing before the Subcommittee on Health and Environment');
INSERT INTO new_titles VALUES ('2000/10/11','Y 4.C 73/8:106-100','ANY-3988','United States. Congress. House. Committee on Commerce. Subcommittee on Finance and Hazardous Materials.','Accounting for business combinations : should pooling be eliminated? : hearing before the Subcommittee on Finance and Ha');
INSERT INTO new_titles VALUES ('2000/10/11','Y 4.C 73/8:106-99','ANY-3987','','106-2 Hearing: Saving Lives: The Cardiac Arrest Survival Act, Serial No. 106-99, May 9, 2000,');
INSERT INTO new_titles VALUES ('2000/10/11','Y 4.IN 8/16:H 81/12','ANY-3986','','106-1 Markup: Markup Of H.R. 3244, H. Con. Res. 165, H. Res. 169, H. Con. Res. 206, H. Con Res. 222, H. Con. Res. 211, A');
INSERT INTO new_titles VALUES ('2000/10/11','Y 4.ED 8/1:106-95','ANY-3985','United States. Congress. House. Committee on Education and the Workforce. Subcommittee on Employer-Employee Relations.','A more secure retirement for workers : proposals for ERISA reform : hearing before the Subcommittee on Employer-Employee');
INSERT INTO new_titles VALUES ('2000/10/11','Y 4.B 22/1:106-49','ANY-3984','','106-2 Hearing: H.R. 3591 - To Honor Ronald And Nancy Reagan With The Congressional Gold Medal, Serial No. 106-49, March');
INSERT INTO new_titles VALUES ('2000/10/11','D570 .G74 2000','ANY-3609','','The Great War reader /');
INSERT INTO new_titles VALUES ('2000/10/11','GN666 .H44 1999','ANY-3612','Hegarty, Ruth.','Is that you, Ruthie? /');
INSERT INTO new_titles VALUES ('2000/10/11','DK258 .C3713 2000','ANY-3603','Carrre d\'Encausse, Hlne.','Nicholas II : the interrupted transition/');
INSERT INTO new_titles VALUES ('2000/10/11','QH361 .R874 2000','ANY-3574','Ruse, Michael.','The evolution wars : a guide to the debates /');
INSERT INTO new_titles VALUES ('2000/10/11','DC397 .I46 2000','ANY-3588','Images de la France de Vichy. English','Collaboration and resistance : images of life in Vichy France, 1940-1944 /');
INSERT INTO new_titles VALUES ('2000/10/11','DG78 .M22 2000','ANY-3525','Maas, Michael, 1951-','Readings in late antiquity : a sourcebook /');
INSERT INTO new_titles VALUES ('2000/10/11','DT2405.A44 M38 2000','ANY-3539','Mathabane, Miriam, 1969-','Miriam\'s song : a memoir /');
INSERT INTO new_titles VALUES ('2000/10/11','RC628 .I48 1996','ANY-3487','International Congress on Obesity (7th : 1994 : Toronto, Ont.)','Progress in obesity research: 7 /');
INSERT INTO new_titles VALUES ('2000/10/11','DS155 .M293 1999','ANY-3502','Ma, John.','Antiochos III and the cities of Western Asia Minor /');
INSERT INTO new_titles VALUES ('2000/10/11','DS126.5 .S292 1998','ANQ-4720','Schroeter, Daniel J.','Israel : an illustrated history /');
INSERT INTO new_titles VALUES ('2000/10/11','GB2597 .A48 1998','ANQ-1197','','Antarctic sea ice : physical processes, interactions, and variability /');
INSERT INTO new_titles VALUES ('2000/10/11','QP519 .L2 vol 27','ANP-6181','Ishikawa, Eiji, 1933-','Ultrasensitive and rapid enzyme immunoassay /');
INSERT INTO new_titles VALUES ('2000/10/11','EP 1.17:530-F-99-022 D','ANP-4758','','Leisure World, Laguna Hills, California 50% waste reduction rate.');
INSERT INTO new_titles VALUES ('2000/10/11','F129.B7 W56 2000','ANY-2269','Wilder, Craig Steven.','A covenant with color : race and social power in Brooklyn /');
INSERT INTO new_titles VALUES ('2000/10/11','TX769 .W638 1999','ANY-2252','Wing, Daniel, 1948-','The bread builders : hearth loaves and masonry ovens /');
INSERT INTO new_titles VALUES ('2000/10/11','TK5101 .G55 2000','ANY-2039','Gilder, George F., 1939-','Telecosm : how infinite bandwidth will revolutionize our world /');
INSERT INTO new_titles VALUES ('2000/10/11','TP418 .D4 1999','ANY-2033','De Rovira, Dolf A.','The dictionary of flavors : and general guide for those training in the art and science of flavor chemistry /');
INSERT INTO new_titles VALUES ('2000/10/11','TK7888.4 .C435 1999','ANY-2005','Chang, K. C. (Kou-Chuan), 1957-','Digital systems design with VHDL and synthesis : an integrated approach /');
INSERT INTO new_titles VALUES ('2000/10/11','TK7868.D5 T62 1998','ANY-2004','Tocci, Ronald J.','Digital systems : principles and applications /');
INSERT INTO new_titles VALUES ('2000/10/11','RM666.A555 P33 1999','ANY-1859','Packer, Lester.','The antioxidant miracle : put lipoic acid, pycnogenol, and vitamins E and C to work for you /');
INSERT INTO new_titles VALUES ('2000/10/11','QL737.P98 A43 2000','ANY-1017','Alexander, Shana.','The astonishing elephant /');
INSERT INTO new_titles VALUES ('2000/10/11','TD796.5 .D45 2000','ANY-1009','Del Porto, David.','The composting toilet system book : a practical guide to choosing, planning and maintaining composting toilet systems, a');
INSERT INTO new_titles VALUES ('2000/10/11','E184.7 .M36 1999','ANY-0643','','Mapping African America : history, narrative formation, and the production of knowledge /');
INSERT INTO new_titles VALUES ('2000/10/11','HG151 .D54 1997','ANX-7572','','A dictionary of finance and banking.');
INSERT INTO new_titles VALUES ('2000/10/11','HG173 .M398 2000','ANX-7250','Melicher, Ronald W.','Finance : introduction to institutions, investments, and management /');
INSERT INTO new_titles VALUES ('2000/10/11','HD30.255 .M34 2000','ANX-7186','Manno, Jack.','Privileged goods : commoditization and its impact on environment and society /');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-RP-324','AMX-7505','Shepperd, Wayne D.','Response of aspen root suckers to regeneration methods and post-harvest protection');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-RP-320','AMW-0346','Rumble, Mark A.','Evaluating the habitat capability model for Merriam\'s turkeys');
INSERT INTO new_titles VALUES ('2000/10/12','HE 20.7808:P 69','ANY-4024','','A Quick Guide To Plague, Prairie Dogs Can Harbor Fleas Infected With Plague Bacteria.');
INSERT INTO new_titles VALUES ('2000/10/12','HE 20.302:P 69','ANY-4023','','Plague Dloo Binaalniih, Navajo Area Indian Health Service');
INSERT INTO new_titles VALUES ('2000/10/12','ED 1.328/4:ST 9/4','ANY-4022','','Youth-Service-Learning And Community Service Among 6th Through 12th-Grade Students In The United States: 1996 And 1999,');
INSERT INTO new_titles VALUES ('2000/10/12','HE 20.3861:D 54/2000','ANY-4021','','Dealing with diabetes /');
INSERT INTO new_titles VALUES ('2000/10/12','EP 1.2:EN 8/39','ANY-4020','','Supplemental Environmental Projects, Protecting And Enhancing Public, Health And The Environment, July 2000');
INSERT INTO new_titles VALUES ('2000/10/12','FEM 1.2:R 31/4','ANY-4018','','Federal response plan.');
INSERT INTO new_titles VALUES ('2000/10/12','A 13.36/2:-6:R 8-RG 40/2000','ANY-4017','United States. Forest Service. Southern Region.','Black Creek, De Soto National Forest, Mississippi : Black Creek and Leaf Wilderness, national scenic river, national rec');
INSERT INTO new_titles VALUES ('2000/10/12','TD 8.8:P 21/2000','ANY-4015','','A parent\'s guide to booster seats.');
INSERT INTO new_titles VALUES ('2000/10/12','T 22.2/15:9931','ANY-4014','','IRS Employee Assistance Program : counseling, worklife and dependent care services.');
INSERT INTO new_titles VALUES ('2000/10/12','L 1.2:Y 8','ANY-4013','','Report On The Youth Labor Force, June 2000');
INSERT INTO new_titles VALUES ('2000/10/12','J 26.30:M 52','ANY-4011','','Emerging judicial strategies for the mentally ill in the criminal caseload : mental health courts in Fort Lauderdale, Se');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.42/4:00-4071','ANY-4009','','Effects Of Hypothetical Management Scenarios On Simulated Water Temperatures, Etc., U.S. Geological Survey, Water-Resour');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.127:106-99','ANY-4008','','The National Hydrography Dataset, U.S. Geological Survey, USGS Fact Sheet 106-99, May 1999');
INSERT INTO new_titles VALUES ('2000/10/12','I 49.44/2:M 23/7','ANY-4006','','McNary National Wildlife Refuge.');
INSERT INTO new_titles VALUES ('2000/10/12','I 19.127:090-00','ANY-4007','','Availability Of Ground-Water Data For California, Water Year 1999, U.S. Geological Survey, USGS Fact Sheet 090-00, July');
INSERT INTO new_titles VALUES ('2000/10/12','SSA 1.6:EM 7','ANY-4005','','Social Security, Employee Verification Service [EVS], Verification Of Names & Social Secruity Numbers, Employer & Third-');
INSERT INTO new_titles VALUES ('2000/10/12','EP 1.2:W 28/53','ANY-4002','','Moving Toward Sustainability, Waste Wise Update, March 2000');
INSERT INTO new_titles VALUES ('2000/10/12','EP 1.2:SO 1','ANY-4001','','Social Aspects Of Siting RCRA Hazardous Waste Facilities, April 2000');
INSERT INTO new_titles VALUES ('2000/10/12','FEM 1.2:D 63/2','ANY-4000','','Flood: Are You Protected From The Next Disaster? (May 2000)');
INSERT INTO new_titles VALUES ('2000/10/12','FEM 1.102:T 27','ANY-3999','','Emergency response to terrorism : job aid.');
INSERT INTO new_titles VALUES ('2000/10/12','A 57.2:P 83','ANY-3998','','Conservation On Private Lands, Life Here... Affects Living There, It Benefits Everyone, Slightly Revised June 2000');
INSERT INTO new_titles VALUES ('2000/10/12','NA730.L8 M37 1989','ANX-5582','Martin, F. Lestar.','Folk and styled architecture in North Louisiana /');
INSERT INTO new_titles VALUES ('2000/10/12','LT4310.I56 L57 1998 vol.4','ANW-9346','LaRocco, Christine Bideganeta.','British & world literature for life and work /');
INSERT INTO new_titles VALUES ('2000/10/12','LT4310.I56 L57 1998 vol.3','ANW-9343','Johnson, Elaine Bowe.','American literature for life and work /');
INSERT INTO new_titles VALUES ('2000/10/12','N5305 .B32 1998','ANW-6295','Barton, Leonard S.','The American Library compendium and index of world art /');
INSERT INTO new_titles VALUES ('2000/10/12','LT4310.I56 L57 1998','ANW-9339','LaRocco, Christine Bideganeta.','Literature for life and work /');
INSERT INTO new_titles VALUES ('2000/10/12','QK625.A1 K5413 2000','ANW-5839','Kiffer, E.','The Deuteromycetes, mitosporic fungi : classification and generic keys /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:35114-E 1-TM-100/999','ANP-3211','United States. Bureau of Land Management.','Nevada : Boulder City : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:47118-E 1-TM-100/999','ANP-3207','United States. Bureau of Land Management.','Washington : Coulee Dam : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4-2:47118-E 1-TM-100/999','ANP-3204','United States. Bureau of Land Management.','Washington : Coulee Dam : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4-2:41109-A 1-TM-100/999','ANP-3196','United States. Bureau of Land Management.','Wyoming : Firehole Canyon : 1:100,000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4-2:37103-E 1-TM-100/999','ANP-3178','United States. Bureau of Land Management.','Colorado : La Junta : 1:100,000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:37109-E 1-TM-100/998','ANP-3172','United States. Bureau of Land Management.','Utah : Blanding : 1:100,000-scale topographic map of Blanding : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4-2:37109-E 1-TM-100/998','ANP-3170','United States. Bureau of Land Management.','Utah : Blanding : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4-2:47106-A 1-TM-100/999','ANP-3160','United States. Bureau of Land Management.','Montana : Jordan : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','[Microfiche] I 27.1:','AMY-5645','United States. Bureau of Reclamation.','Annual report');
INSERT INTO new_titles VALUES ('2000/10/12','QC176.8.E9 A44 2000','AMW-9551','Amerongen, Herbert van.','Photosynthetic excitons /');
INSERT INTO new_titles VALUES ('2000/10/12','L 2.121/40:C 38/','AMP-3966','','National compensation survey.');
INSERT INTO new_titles VALUES ('2000/10/12','HG4515.3 .R67 1999','AMQ-5783','Ross, Sheldon M.','An introduction to mathematical finance : options and other topics /');
INSERT INTO new_titles VALUES ('2000/10/12','[Microfiche] TD 1.101:','AMM-9520','United States. National Transportation Safety Board.','Annual report to Congress.');
INSERT INTO new_titles VALUES ('2000/10/12','PREX 2.8/5:','AML-0537','United States. Office of Management and Budget.','Budget of the United States Government.');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:44100-E 1-TM-100/998','AMH-2528','United States. Bureau of Land Management.','South Dakota : Onida : 1:100 000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4-2:44100-E 1-TM-100/998','AMH-2526','United States. Bureau of Land Management.','South Dakota : Onida : 1:100 000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4-2:37102-A 1-TM-100/998','AMH-2522','United States. Bureau of Land Management.','Colorado : Springfield : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','I 53.11/4:37102-A 1-TM-100/998','AMH-2518','United States. Bureau of Land Management.','Colorado : Springfield : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/12','JU 10.21/2:','AMC-1648','','Statistical tables for the federal judiciary.');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-RP-319','AMT-7252','Bevenger, Gregory S.','A pebble count procedure for assessing watershed cumulative effects');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-318','AMS-0310','Sturges, David L.','High-elevation watershed response to sagebrush control in southcentral Wyoming');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-459','AMY-9181','United States. Congress. House. Committee on the Judiciary.','United States Marshals Service Improvement Act of 1999 : report (to accompany H.R. 2336) (including cost estimate of the');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-458','AMY-9179','United States. Congress. House. Committee on Resources.','Resources Reports Restoration Act : report (to accompany H.R. 3002) (including cost estimate of the Congressional Budget');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-483/PT.','AMY-9152','United States. Congress. House. Committee on Banking and Financial Services.','Debt Relief for Poverty Reduction Act of 1999 : report together with additional and dissenting views (to accompany H.R.');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-472/PT.1-','AMY-9150','United States. Congress. House. Committee on Science.','Networking and Information Technology Research and Development Act : report together with additional view (to accompany');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-456/PT.1-','AMY-9148','United States. Congress. House. Committee on Education and the Workforce.','Welfare-to-Work Amendments of 1999 : report together with additional views (to accompany H.R. 3172) (including cost esti');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-466','AMY-9117','United States. Congress. House. Committee on Rules.','Waiving a requirement of clause 6(a) of rule XIII with respect to the same day consideration of certain resolutions repo');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-411/PT.1-','AMY-9131','United States. Congress. House. Committee on the Judiciary.','Antitrust Technical Corrections Act of 1999 : report (to accompany H.R. 1801) (including cost estimate of the Congressio');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/7:106-80','AMY-8912','United States. President (1993- : Clinton)','A report on the situation in Kosovo : communication from the President of the United States transmitting a report to Con');
INSERT INTO new_titles VALUES ('2000/10/25','TD 7.8:R 29/','AMT-4240','United States. Federal Transit Administration.','Reporting manual for the ... section 15 report year /');
INSERT INTO new_titles VALUES ('2000/10/25','E185.97.R93 L49 2000','AMY-2781','Levine, Daniel, 1934-','Bayard Rustin and the civil rights movement /');
INSERT INTO new_titles VALUES ('2000/10/25','RJ506.M87 R44 1999','AMQ-7792','','Refusal to speak : treatment of selective mutism in children /');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-465','AMQ-5686','United States. Congress. House. Committee on Rules.','Providing for the consideration of motions to suspend the rules : report (to accompany H. Res. 374).');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-461','AMQ-5687','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.J. Res. 76, waiving certain enrollment requirements for the remainder of the 106th');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-462','AMQ-5685','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 1714, Electronic Signatures in Global and National Commerce Act : report (to acc');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-409','AMQ-5684','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 2260, Pain Relief Promotion Act of 1999 : report (to accompany H. Res. 339).');
INSERT INTO new_titles VALUES ('2000/10/25','Y 1.1/8:106-408','AMQ-5683','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 2300, the Academic Achievement for All Act : report (to accompany H.R. 338) (inc');
INSERT INTO new_titles VALUES ('2000/10/29','','AOF-5441','Van Den Haag, Ernest.','Refuting Reiman and Nathanson.');
INSERT INTO new_titles VALUES ('2000/10/04','QC1 .B7','AAZ-0634','','Journal of physics. D,');
INSERT INTO new_titles VALUES ('2000/10/04','SB123.A1 N6','ABE-1081','','Nogyo Gijutsu Kenkyujo hokoku. Bulletin of the National Institute of Agricultural Sciences.');
INSERT INTO new_titles VALUES ('2000/10/03','[videocassette] HD6250.5 .S76 2000','ANW-8699','','Stolen futures child labor, sweat shops, forced labor.');
INSERT INTO new_titles VALUES ('2000/10/03','NA6212 .P75 1989','ANW-7068','','Princeton Forrestal Village mixed use suburban town center, Plainsboro, NJ /');
INSERT INTO new_titles VALUES ('2000/10/03','NA7570 .N49 2000','ANW-7067','','New suburbia');
INSERT INTO new_titles VALUES ('2000/10/03','HT111 .B33 1991','ANW-7054','','Babylon to Bombay, the city through time');
INSERT INTO new_titles VALUES ('2000/10/03','RE938 .I57 1998','ANR-6686','International Conference on Myopia (7th : 1998 : Taipei, Taiwan)','Myopia updates II : proceedings of the 7th International Conference on Myopia, 1998 /');
INSERT INTO new_titles VALUES ('2000/10/03','QD509.M65 G43 1997','ANR-3486','Ghaskadvi, Rajesh Sadanand, 1968-','Shear mechanical properties of Langmuir monolayers /');
INSERT INTO new_titles VALUES ('2000/10/03','QA76.9.D3 S2538 2000','ANE-4016','Sanders, Roger.','DB2 universal database SQL developer\'s guide.');
INSERT INTO new_titles VALUES ('2000/10/03','SF996 .I57 1999','ANA-4456','International Symposium on Diseases in Zoo Animals (39th : 1999 : Vienna, Austria)','Erkrankungen der Zootiere : Verhandlungsbericht des 39. Internationalen Symposiums ber die Erkrankungen der Zoo- und Wi');
INSERT INTO new_titles VALUES ('2000/10/03','QK315 .F56 1997','AMY-8358','','Flora Hellenica /');
INSERT INTO new_titles VALUES ('2000/10/03','TD1050.C57 H43 1986','AMX-0474','','Hazardous wastes from homes /');
INSERT INTO new_titles VALUES ('2000/10/03','HF5415.2 .D86 1998','AMQ-6093','Dunn, Theodore F.','1998 ARF/AMA marketing research industry survey : a tracking survey of marketing researchers and marketers /');
INSERT INTO new_titles VALUES ('2000/10/03','HE 20.3612/3-8:','ALZ-2464','National Library of Medicine (U.S.)','Medical subject headings.');
INSERT INTO new_titles VALUES ('2000/10/03','Y 4.V 64/3:106-8','AMH-2536','United States. Congress. House. Committee on Veterans\' Affairs. Subcommittee on Benefits.','Oversight on the Veterans Benefits Administration : hearing before the Subcommittee on Benefits of the Committee on Vete');
INSERT INTO new_titles VALUES ('2000/10/03','Y 4.AP 6/2:S.HRG.106-145','ALS-3224','United States. Congress. Senate. Committee on Appropriations. Subcommittee on Commerce, Justice, State, the Judiciary, and Related Agencies.','Counterterrorism and infrastructure protection : hearing before a subcommittee of the Committee on Appropriations, Unite');
INSERT INTO new_titles VALUES ('2000/10/03','Y 4.AP 6/2:S.HRG.106-147','ALS-1384','United States. Congress. Senate. Committee on Appropriations. Subcommittee on Commerce, Justice, State, the Judiciary, and Related Agencies.','Departments of Commerce, Justice, and State, the judiciary, and related agencies appropriations for fiscal year 2000 : h');
INSERT INTO new_titles VALUES ('2000/10/03','Y 4.IN 2/11:S.HRG.106-146','ALO-5296','United States. Congress. Senate. Committee on Indian Affairs (1993- )','Trust fund reform : joint hearing before the Committee on Indian Affairs, United States Senate and the Committee on Ener');
INSERT INTO new_titles VALUES ('2000/10/03','Y 4.IN 2/11:S.HRG.106-119','ALO-5295','United States. Congress. Senate. Committee on Indian Affairs (1993- )','Chippewa Cree Tribe of the Rocky Boy\'s Reservation Indian Reserved Water Rights Settlement Act : hearing before the Comm');
INSERT INTO new_titles VALUES ('2000/10/03','Y 4.IN 2/11:S.HRG.106-117','ALN-0376','United States. Congress. Senate. Committee on Indian Affairs (1993- )','National Gambling Impact Study Commission final report : hearing before the Committee on Indian Affairs, United States S');
INSERT INTO new_titles VALUES ('2000/10/03','I 19.53/2:VA-','ALM-4999','','Water resources data.');
INSERT INTO new_titles VALUES ('2000/10/03','Y 4.IN 2/11:S.HRG.106-107','ALN-0375','United States. Congress. Senate. Committee on Indian Affairs (1993- )','Indian youth activities and initiatives : hearing before the Committee on Indian Affairs, United States Senate, One Hund');
INSERT INTO new_titles VALUES ('2000/10/03','P 1.2:Ol 9','ALH-8829','Hoobing, Robert.','The 1984 Olympics : Sarajevo and Los Angeles /');
INSERT INTO new_titles VALUES ('2000/10/03','I 1.98:G 76 j/draft and maps 1-5','ALH-5589','','Resource management plan and environmental impact statement, Grand Junction Resource Area, Grand Junction, Colorado /');
INSERT INTO new_titles VALUES ('2000/10/03','KF3959 .P465','ALD-8494','','Defending pesticides in litigation.');
INSERT INTO new_titles VALUES ('2000/10/03','TA682.43 .U56 1914','ALE-9271','Universal Portland Cement Company. Information Bureau.','Concreting in cold weather /');
INSERT INTO new_titles VALUES ('2000/10/03','I 1.98:G 95/3/final/','ALD-6140','','Proposed Gulf of Alaska/Cook Inlet lease sale 88 : final environmental impact statement /');
INSERT INTO new_titles VALUES ('2000/10/03','P 1.2:St 2/11/980','AKZ-8820','United States Postal Service.','A collection of stamps and stationery issued for the 1980 Olympic Games /');
INSERT INTO new_titles VALUES ('2000/10/03','HT394.W3 A49 1972','AKM-9651','United States. National Capital Planning Commission.','The urban river; a staff proposal for waterfront development in the District of Columbia.');
INSERT INTO new_titles VALUES ('2000/10/03','I 1.98:En 2/final/','AKL-3921','','Final environmental impact statement on the Energy Transportation Systems Inc. coal slurry pipeline transportation proje');
INSERT INTO new_titles VALUES ('2000/10/03','CC 1.12/3:','AKC-8618','United States. Federal Communications Commission.','FCC record : a comprehensive compilation of decisions, reports, public notices, and other documents of the Federal Commu');
INSERT INTO new_titles VALUES ('2000/10/03','Y 1.1/5:106-6','AKC-5069','United States. Congress. Senate. Committee on Small Business.','Small Business Investment Improvement Act of 1999 : report (to accompany S. 364).');
INSERT INTO new_titles VALUES ('2000/10/12','I 27.1/4:','AMA-1812','United States. Bureau of Reclamation.','Summary statistics.');
INSERT INTO new_titles VALUES ('2000/10/12','MF NC DOCS C27 2:T172','ALS-0809','','Basinwide wetlands and riparian restoration plan for the Tar-Pamlico River Basin N.C. Wetlands Restoration Program, Divi');
INSERT INTO new_titles VALUES ('2000/10/12','MF NC DOCS G36.9 502:I61','ALO-3245','Wing, Stephen B.','Intensive livestock operations, health and quality of life among eastern North Carolina residents');
INSERT INTO new_titles VALUES ('2000/10/12','I 27.1/4-2:','ALN-1681','United States. Bureau of Reclamation.','Summary statistics.');
INSERT INTO new_titles VALUES ('2000/10/12','MF NC DOCS B123 9:N53','ALH-2302','','A new way of doing business preliminary report of the E-Commerce Work Group of the Information Resource Management Commi');
INSERT INTO new_titles VALUES ('2000/10/12','HT168.W3 U52 1995','AKM-9652','United States. National Capital Planning Commission.','Extending the legacy : planning America\'s capital for the 21st century.');
INSERT INTO new_titles VALUES ('2000/10/12','QD31 .R8 1878','AKE-5881','Roscoe, Henry E. (Henry Enfield), 1833-1915.','A treatise on chemistry /');
INSERT INTO new_titles VALUES ('2000/10/12','M1473.R65 S26 1992','AKB-6795','Rolnick, Neil B.','Sanctus Balkanization ; ReRebong ; Macedonian AirDrumming /');
INSERT INTO new_titles VALUES ('2000/10/12','M284.E4 S76 1990','AKB-6678','Stockhausen, Karlheinz, 1928-','Mantra');
INSERT INTO new_titles VALUES ('2000/10/12','M3.1 .S76 1992','AKB-6506','Stone, Carl, 1953-','Mom\'s');
INSERT INTO new_titles VALUES ('2000/10/12','M485 .M68 1991','AKB-6467','','Movin\' on');
INSERT INTO new_titles VALUES ('2000/10/12','M1473 .L36 1994','AKB-6444','Lansky, Paul, 1944-','More than idle chatter');
INSERT INTO new_titles VALUES ('2000/10/12','HV89 .A55','AJR-7152','','Public human services directory /');
INSERT INTO new_titles VALUES ('2000/10/12','HC60 .I535b','AJR-7640','World Bank research program (1986)','The World Bank research program : abstracts of current studies.');
INSERT INTO new_titles VALUES ('2000/10/03','Y 1.1/5:106-44','AKC-5068','United States. Congress. Senate. Committee on Banking, Housing, and Urban Affairs.','Financial Services Modernization Act of 1999 : report of the Committee on Banking, Housing, and Urban Affairs, United St');
INSERT INTO new_titles VALUES ('2000/10/03','Y 1.1/5:106-43','AKC-5020','United States. Congress. Senate. Committee on Foreign Relations.','Foreign Relations Authorization Act, Fiscal Years 2000-2001 : report together with minority views (to accompany S. 886).');
INSERT INTO new_titles VALUES ('2000/10/03','Y 1.1/5:106-10','AKC-0908','United States. Congress. Senate. Committee on Commerce, Science, and Transportation.','Year 2000 (Y2K) Act : report of the Committee on Commerce, Science, and Transportation on S. 96, together with minority');
INSERT INTO new_titles VALUES ('2000/10/04','QH1 .L88','AAY-9025','','The Proceedings of the Linnean Society of New South Wales');
INSERT INTO new_titles VALUES ('2000/10/03','T223.V4 A27','AJX-7425','Trademark register (Washington, D.C. : 1997)','The Trademark register.');
INSERT INTO new_titles VALUES ('2000/10/03','PK2167 .H26 1993','AJX-3733','Hali, Khvajah Altaf Husain, 1837-1914.','Muqaddamah-yi sh\'er o sha\'iri /');
INSERT INTO new_titles VALUES ('2000/10/04','QH1 .C442','AAU-8875','','Natural history miscellanea');
INSERT INTO new_titles VALUES ('2000/10/04','SF1 .R65','AAY-3656','','Annali dell\'Istituto sperimentale zootecnico di Roma');
INSERT INTO new_titles VALUES ('2000/10/06','Y 1.1/8:106-707','ANY-9275','United States. Congress. House. Committee on Rules.','Waiving a requirement of clause 6(a) of rule XIII with respect to the same day consideration of certain resolutions repo');
INSERT INTO new_titles VALUES ('2000/10/06','M1473 .E413 1994','ANY-8115','','Electro acoustic music.');
INSERT INTO new_titles VALUES ('2000/10/06','NA680 .J45 2000','ANY-4787','Jencks, Charles.','Architecture 2000 and beyond : success in the art of prediction /');
INSERT INTO new_titles VALUES ('2000/10/06','HF5548.32 .M378 2000','ANY-4474','McLaren, Constance H.','E-commerce : business on the Internet /');
INSERT INTO new_titles VALUES ('2000/10/06','HF5549.5.T7 W46 1991','ANY-4413','Wexley, Kenneth N., 1943-','Developing and training human resources in organizations /');
INSERT INTO new_titles VALUES ('2000/10/06','HF5547.15 .H449 1998','ANY-4383','Hemphill, Barbara.','Taming the paper tiger at work /');
INSERT INTO new_titles VALUES ('2000/10/06','HF5736 .D673 1994','ANY-4380','Dorff, Pat.','File-- don\'t pile! : for people who write : handling the paper flow in the workplace or home office /');
INSERT INTO new_titles VALUES ('2000/10/06','HF5547 .E46 1998','ANY-4379','Eisenberg, Ronni.','Organize your office! : simple routines for managing your workspace /');
INSERT INTO new_titles VALUES ('2000/10/06','Y 4.R 31/3:106-66','ANY-4082','','H.R. 2918, Dakota Water Resources Act Of 1999... Hearing... Serial No. 106-66... Committee On Resources, House Of Repres');
INSERT INTO new_titles VALUES ('2000/10/06','Y 3.F 31/8:1-2/999','ANY-3968','','STATISTICS ON BANKING... A STATISTICAL PROFILE OF THE UNITED STATES BANKING INDUSTRY... FEDERAL DEPOSIT INSURANCE CORPO');
INSERT INTO new_titles VALUES ('2000/10/06','TD 2.30:00-110','ANY-3967','','Geotechnical laboratory geosynthetic bridge.');
INSERT INTO new_titles VALUES ('2000/10/06','Y 1.1/8;106-690','ANY-3966','','FLOYD H. FLAKE FEDERAL BUILDING... REPORT 106-690... HOUSE OF REPRESENTATIVES... 106TH CONGRESS, 2D SESSION');
INSERT INTO new_titles VALUES ('2000/10/06','Y 1.1/8:106-710','ANY-3965','United States. Congress (106th, 2d session : 2000)','Making appropriations for military construction, family housing, and base realignment and closure for the Department of');
INSERT INTO new_titles VALUES ('2000/10/06','Y 1.1/8:106-709','ANY-3964','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 1304, the Quality Health-Care Coalition Act of 2000 : report (to accompany H. Re');
INSERT INTO new_titles VALUES ('2000/10/06','Y 1.1/8:106-706/PT.1','ANY-3961','','NEW MARKETS INITIATIVE ACT OF 1999... REPT. 106-706, PART 1... HOUSE OF REPRESENTATIVES... 106TH CONGRESS, 2D SESSION');
INSERT INTO new_titles VALUES ('2000/10/06','Y 1.1/8:106-705','ANY-3960','','PROVIDING FOR THE CONSIDERATION OF H.R. 4680, THE MEDICARE RX 2000 ACT... REPORT 106-705... HOUSE OF REPRESENTATIVES...');
INSERT INTO new_titles VALUES ('2000/10/06','Y 1.1/8:106-703/PT.1','ANY-3958','','MEDICARE RX 2000 ACT... REPT. 106-703, PART 1... HOUSE OF REPRESENTATIVES... 106TH CONGRESS, 2D SESSION');
INSERT INTO new_titles VALUES ('2000/10/06','Y 1.1/8:106-696/PT.1','ANY-3957','','DEPARTMENT OF ENERGY SECURITY OVERSIGHT IMPROVEMENT ACT OF 2000... REPT. 106-696, PART 1 ... HOUSE OF REPRESENTATIVES..');
INSERT INTO new_titles VALUES ('2000/10/06','Y 1.1/8:106-689','ANY-3956','','JAMES H. QUILLEN UNITED STATES COURTHOUSE... REPORT 106-689... HOUSE OF REPRESENTATIVES... 106TH CONGRESS, 2D SESSION');
INSERT INTO new_titles VALUES ('2000/10/06','SB439 .W367 2000','ANY-3628','Wasowski, Andy, 1939-','The landscaping revolution : garden with mother nature, not against her /');
INSERT INTO new_titles VALUES ('2000/10/06','DS122.8.J83 M33 2000','ANY-3602','Mader, Gottfried.','Josephus and the politics of historiography : apologetic and impression management in the Bellum Judaicum /');
INSERT INTO new_titles VALUES ('2000/10/06','F158.9.I6 G35 2000','ANY-3593','Gallman, J. Matthew (James Matthew)','Receiving Erin\'s children : Philadelphia, Liverpool, and the Irish famine migration, 1845-1855 /');
INSERT INTO new_titles VALUES ('2000/10/06','F497.W5 V57 2000','ANY-3538','','Visions of the Western Reserve : public and private documents of northeastern Ohio, 1750-1860 /');
INSERT INTO new_titles VALUES ('2000/10/06','F457.K3 E45 2000','ANY-3592','Ellis, William E. (William Elliott), 1940-','The Kentucky River /');
INSERT INTO new_titles VALUES ('2000/10/06','DS554.83.H56 A3 2000','ANY-3526','Him, Chanrithy, 1965-','When broken glass floats : growing up under the Khmer Rouge, a memoir /');
INSERT INTO new_titles VALUES ('2000/10/06','DA356 .D678 2000','ANY-3521','Doran, Susan.','Elizabeth I and foreign policy, 1558-1603 /');
INSERT INTO new_titles VALUES ('2000/10/06','LB1044.88 .T445 2000','ANY-2260','','Teaching with technology : seventy-five professors from eight universities tell their stories /');
INSERT INTO new_titles VALUES ('2000/10/06','QC670 .I5 1999','ANY-2040','Inan, Umran S.','Engineering electromagnetics /');
INSERT INTO new_titles VALUES ('2000/10/06','PR9396.9.F3 S9 1992','ANY-1857','Farah, Nuruddin, 1945-','Sweet & sour milk /');
INSERT INTO new_titles VALUES ('2000/10/06','TP443 .P75 1997','ANY-2028','','Processing vegetables : science and technology /');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-4188','Heaney, Seamus','Introduction / Beowulf');
INSERT INTO new_titles VALUES ('2000/10/20','MF NC DOCS G27 2:M92','ALH-1719','Mountain Water Resources Research Conference (1999 : Asheville, N.C.)','Mountain water resources research and management : proceedings of the 1999 Mountain Water Resources Research Conference.');
INSERT INTO new_titles VALUES ('2000/10/20','Mf 162 no. 11643','AJS-5143','Kania, Thomas, 1963-','Identification and analysis of flowering promoting factors in Sinapis alba and Arabidopis thaliana /');
INSERT INTO new_titles VALUES ('2000/10/20','Mf 162 no. 11650','AJS-5142','Zimmermann, Gabriela, 1966.','Toxicological aspects PCBS in the aquatic ecosystem /');
INSERT INTO new_titles VALUES ('2000/10/20','QL673 .W29 1998','AJQ-6989','Waldbauer, Gilbert.','The birder\'s bug book /');
INSERT INTO new_titles VALUES ('2000/10/20','Mf 162 no. 10804','AJK-7672','Rautenkranz, Andreas A. F.','Transport of ascorbic and dehydroscrobic acids across membrances of Barley (Hordeum vulgare L., cv Gerbel) mesophyll cel');
INSERT INTO new_titles VALUES ('2000/10/20','SB472 .M68 1991','ACN-4758','Motloch, John L.','Introduction to landscape design /');
INSERT INTO new_titles VALUES ('2000/10/20','ED 1.109:','ABB-9965','','The condition of education.');
INSERT INTO new_titles VALUES ('2000/10/20','HC79.T4 D5 1978','ABI-5651','Dick, Trevor J. O.','An economic theory of technological change : the case of patents and the United States railroads, 1871-1950 /');
INSERT INTO new_titles VALUES ('2000/10/20','TD7.2: D62 DIRCETORY OF REGULARLY SCHED','','','');
INSERT INTO new_titles VALUES ('2000/10/19','PQ7389.N65 N44 1997','AKC-3331','Novs Calvo, Lino, 1905-','Pedro blanco, el negrero /');
INSERT INTO new_titles VALUES ('2000/10/19','A 67.18:WP','AKB-7075','Wood products, international trade and foreign markets (1995)','Wood products, international trade and foreign markets /');
INSERT INTO new_titles VALUES ('2000/10/19','HD30.26 .G47 1997','AJV-7280','Ghemawat, Pankaj.','Games businesses play : cases and models /');
INSERT INTO new_titles VALUES ('2000/10/19','Mf 162 no. 11413','AJS-5948','Brschweiler, Beat J. 1965-','Cytotoxity and interactions of organotins and heavy metals with cytochrome P4501A in fish hepatoma cells /');
INSERT INTO new_titles VALUES ('2000/10/19','Mf 162 no. 11411','AJS-5947','Weidenhaupt, Marianne. 1967-','In the search for new NifA-dependent genes and their function in Bradyrhizobium japonicum /');
INSERT INTO new_titles VALUES ('2000/10/19','Mf 162 no. 11400','AJS-5946','Perreten, Vincent. 1965-','Distribution, molecular characterization and genetic mobilization of antibiotic resistance genes in enterococci, staphyl');
INSERT INTO new_titles VALUES ('2000/10/19','Mf 162 no. 11397','AJS-5945','Malinowski, Dariusz. 1966-','Rhizomatous ecotypes and symbiosis with endophytes as new possibilities of improvement in competitive ability of meadow');
INSERT INTO new_titles VALUES ('2000/10/19','TP248.65.C55 A67 1997','AJR-2309','','Applications of Chitin and Chitosan /');
INSERT INTO new_titles VALUES ('2000/10/19','SB123.3 .G474 1991','AJH-7295','','Genetic diversity, and crop strategies for roots and tubers /');
INSERT INTO new_titles VALUES ('2000/10/19','HF5415.1265 .H34 1997','AIR-0541','Hagel, John.','Net gain : expanding markets through virtual communities /');
INSERT INTO new_titles VALUES ('2000/10/19','TL240 .A83','AIQ-8467','','Automotive & transportation interiors.');
INSERT INTO new_titles VALUES ('2000/10/19','BF77 .B87 1996','AIM-3701','Buskist, William.','Preparing for graduate study in psychology : 101 questions and answers /');
INSERT INTO new_titles VALUES ('2000/10/19','HD9284 .W5','AIK-6608','','Who\'s who in the egg and poultry industries in the United States and Canada.');
INSERT INTO new_titles VALUES ('2000/10/19','S930 .M38 1995','AIJ-9386','','Materials and the environment wood as a global resource /');
INSERT INTO new_titles VALUES ('2000/10/19','[DVD] PN1993.5.I829 K353 2000','AIH-3653','','Kala Paani');
INSERT INTO new_titles VALUES ('2000/10/19','QA22 .J67 1992','AFV-4222','Joseph, George Gheverghese.','The crest of the peacock : non-European roots of mathematics /');
INSERT INTO new_titles VALUES ('2000/10/19','& span AJK1383','AFA-1736','','');
INSERT INTO new_titles VALUES ('2000/10/19','QC446.2 .B69 1992','ACP-5633','Boyd, Robert W., 1948-','Nonlinear optics /');
INSERT INTO new_titles VALUES ('2000/10/19','QK745 .P38','ACL-1545','','PGRSA quarterly');
INSERT INTO new_titles VALUES ('2000/10/19','HC107.N8 T85 1989','ACL-0904','Tullos, Allen, 1950-','Habits of industry : white culture and the transformation of the Carolina Piedmont /');
INSERT INTO new_titles VALUES ('2000/10/19','HV4711 .A56 1989','ACL-0509','','Animal rights and human obligations /');
INSERT INTO new_titles VALUES ('2000/10/19','QR188 .C58','ACG-1595','','Immunology and allergy clinics of North America');
INSERT INTO new_titles VALUES ('2000/10/19','NA737.W7 F84 1984','ACC-0933','Wright, Frank Lloyd, 1867-1959.','Frank Lloyd Wright /');
INSERT INTO new_titles VALUES ('2000/10/19','QD421.A1 A43','ABY-9750','Alkaloids (New York, N.Y.)','The Alkaloids');
INSERT INTO new_titles VALUES ('2000/10/19','S399 .E49','ABV-6353','Research report (Hawaii Institute of Tropical Agriculture and Human Resources)','Research report /');
INSERT INTO new_titles VALUES ('2000/10/19','KF4119 .W45','ABV-1786','','West\'s education law reporter.');
INSERT INTO new_titles VALUES ('2000/10/19','S184 .A34','ABT-9794','Bermuda Islands. Dept. of Agriculture and Fisheries.','Report for the year ...');
INSERT INTO new_titles VALUES ('2000/10/19','S399 .E49','ABT-6442','Technical progress report (Hawaii Agricultural Experiment Station)','Technical progress report /');
INSERT INTO new_titles VALUES ('2000/10/19','TP370 .B817','ABT-5864','','Scientific and technical surveys');
INSERT INTO new_titles VALUES ('2000/10/19','S592.3 .H54','ABQ-6509','Hillel, Daniel.','Fundamentals of soil physics /');
INSERT INTO new_titles VALUES ('2000/10/19','BR1 .C5','ABQ-0126','Christian century (Chicago, Ill. : 1902)','The Christian century');
INSERT INTO new_titles VALUES ('2000/10/19','PR4229 .S7','ABB-9868','','Studies in Browning and his circle');
INSERT INTO new_titles VALUES ('2000/10/19','SB413.G5 N6','ABK-4417','Bulletin (North American Gladiolus Council)','Bulletin /');
INSERT INTO new_titles VALUES ('2000/10/19','QA1 .P332','AAY-9513','','Rendiconti del Seminario matematico della Universit di Padova');
INSERT INTO new_titles VALUES ('2000/10/19','Q11 .N26','AAX-7475','','Proceedings of the National Academy of Sciences');
INSERT INTO new_titles VALUES ('2000/10/19','RD1 .J6420','AAY-8828','','Journal of bone and joint surgery.');
INSERT INTO new_titles VALUES ('2000/10/19','E185.8 .B58','AAP-7109','','Black enterprise');
INSERT INTO new_titles VALUES ('2000/10/19','RD701 .C550','AAX-2161','','Clinical orthopaedics and related research');
INSERT INTO new_titles VALUES ('2000/10/19','TP890 .C67','AAX-3082','','Colourage.');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-315','ALE-7914','','Some effects of predaceous birds and ants on the western spruce budworm on conifer seedlings /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-319','ALE-5498','','The value of roaded, multiple-use areas as recreation sites in three national forests of the Pacific Northwest /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-316','ALE-5496','Pong, W. Y.','Characteristics of residues in a cable-logged area of old-growth Douglas-fir /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-314','ALE-3491','Seidel, Kenneth W.','Regeneration in mixed conifer and Douglas-fir shelterwood cuttings in the Cascade Range of Washington /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-313','ALD-1789','DeBell, Dean S.','Influence of red alder on chemical properties of a clay loam soil in western Washington /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-307','ALD-1787','Foote, M. Joan.','Classification, description, and dynamics of plant communities after fire in the taiga of interior Alaska /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-312','ALC-5953','Hanley, Thomas A.','Seasonal changes in chemical composition and nutritive value of native forages in a spruce-hemlock forest, southeastern');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-306','ALC-8620','Schallau, Con H.','Considering departures from current timber harvesting policies : case studies of four communities in the Pacific Northwe');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-311','ALC-5951','Barrett, James W. (James Willis), 1922-','Growth of ponderosa pine poles thinned to different stocking levels in central Oregon /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-309','ALB-9364','Norum, Rodney A.','Wind adjustment factors for predicting fire behavior in three fuel types in Alaska /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-308','ALC-5949','Sampson, George Roger, 1936-','Potential for economical recovery of fuel from land clearing residue in interior Alaska /');
INSERT INTO new_titles VALUES ('2000/10/06','PR9396.9.F3 S2 1992','ANY-1855','Farah, Nuruddin, 1945-','Sardines /');
INSERT INTO new_titles VALUES ('2000/10/06','PR9396.9.F3 C4 1992','ANY-1854','Farah, Nuruddin, 1945-','Close sesame /');
INSERT INTO new_titles VALUES ('2000/10/06','QA76.6 .P464 1993','ANY-1679','Perry, Greg M.','Absolute beginner\'s guide to programming /');
INSERT INTO new_titles VALUES ('2000/10/06','QL638.9 .A438 1999','ANY-1597','Allen, Thomas B.','The shark almanac /');
INSERT INTO new_titles VALUES ('2000/10/06','BS2685.6.S37 H68 1999','ANY-1616','Hove, Richard, 1957-','Equality in Christ? : Galatians 3:28 and the gender dispute /');
INSERT INTO new_titles VALUES ('2000/10/06','MF NC DOCS Y4 S45:1 1999','ANY-1064','North Carolina Sentencing and Policy Advisory Commission.','North Carolina Sentencing and Policy Advisory Commission report on proposed legislation pursuant to G.S. 164-43 submitte');
INSERT INTO new_titles VALUES ('2000/10/06','Z6207.E8 N64 1997','ANY-0476','Noffsinger, James Philip.','World War I aviation : a bibliography of books in English, French, German, and Italian : with a price list supplement /');
INSERT INTO new_titles VALUES ('2000/10/06','HD9743.G48 G74 1998','ANY-0472','Gregor, Neil, 1969-','Daimler-Benz in the Third Reich /');
INSERT INTO new_titles VALUES ('2000/10/06','HD30.28 .F64 1994','ANY-0470','Fogg, C. Davis.','Team-based strategic planning : a complete guide to structuring, facilitating, and implementing the process /');
INSERT INTO new_titles VALUES ('2000/10/06','TA174 .M529 1998','ANY-0403','Middendorf, William H.','Design of devices and systems /');
INSERT INTO new_titles VALUES ('2000/10/01','Desk Shelf','ANZ-5067','Chang, Henry. et al.','Surviving the SOC Revolution. c1999.');
INSERT INTO new_titles VALUES ('2000/10/01','Desk Shelf','ANZ-5065','Keating, Michael.','Reuse Methodology Manual for System-On-A-Chip Designs. c1998.');
INSERT INTO new_titles VALUES ('2000/10/01','Desk File','ANZ-5035','','ECE422/592Q Kauffman Notebook.[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/01','E187 .C78 2000','ANY-7354','Copeland, David A., 1951-','Debating the issues in colonial newspapers : primary documents on events of the period /');
INSERT INTO new_titles VALUES ('2000/10/01','QD281.P6 C656 2000','ANY-7332','','Controlled/living radical polymerization : progress in ATRP, NMP, and RAFT /');
INSERT INTO new_titles VALUES ('2000/10/01','ML54.6.J76 F74 2000','ANY-7315','Johnson, Graham, 1950-','A French song companion /');
INSERT INTO new_titles VALUES ('2000/10/01','TK5105.888. W3738 2000','ANY-7311','','Web-to-host connectivity /');
INSERT INTO new_titles VALUES ('2000/10/01','HD75 .S42 2000','ANY-7310','Seavoy, Ronald E.','Subsistence and economic development /');
INSERT INTO new_titles VALUES ('2000/10/01','HD59 .A97 2001','ANY-7309','Austin, Erica Weintraub.','Strategic public relations management : planning and managing effective communication programs /');
INSERT INTO new_titles VALUES ('2000/10/01','TK5105.73 .E437 2000','ANY-7301','','Electronic messaging /');
INSERT INTO new_titles VALUES ('2000/10/01','& Span AJJ-7748','ADT-0878','','');
INSERT INTO new_titles VALUES ('2000/10/01','QH541.15.S5 A78 2000','ANY-7299','','Artificial neuronal networks : application to ecology and evolution /');
INSERT INTO new_titles VALUES ('2000/10/01','PR6013.R367 Z65 1982','ABV-1657','Cevasco, G. A. (George A.)','John Gray /');
INSERT INTO new_titles VALUES ('2000/10/01','S593 .N6','ACL-0524','Welch, C. D.','Fertility status of North Carolina soils /');
INSERT INTO new_titles VALUES ('2000/10/01','BS2665.2 .S86 1981','ABS-7507','Stowers, Stanley Kent.','The diatribe and Paul\'s letter to the Romans /');
INSERT INTO new_titles VALUES ('2000/10/01','HD70.G7 M28','ABO-7519','','Management thought in Great Britain /');
INSERT INTO new_titles VALUES ('2000/10/01','QA276.A1 J59','ABG-8334','','Journal of statistical planning and inference');
INSERT INTO new_titles VALUES ('2000/10/01','HB171.5 .S67 1977','ABF-9805','Spencer, Milton H.','Contemporary economics /');
INSERT INTO new_titles VALUES ('2000/10/01','QC770 .N853','AAY-9425','','Nuclear physics.');
INSERT INTO new_titles VALUES ('2000/10/01','QL738 .C73','AAU-4236','Crandall, Lee S. (Lee Saunders), 1887-1969.','A zoo man\'s notebook,');
INSERT INTO new_titles VALUES ('2000/10/01','PR4772 .T3','AAS-9049','Hazlitt, William, 1778-1830.','Table talk; essays on men and manners,');
INSERT INTO new_titles VALUES ('2000/10/01','QD1 .A52','AAT-9112','','The Journal of the American Chemical Society.');
INSERT INTO new_titles VALUES ('2000/10/01','QA564 .W35','AAL-3337','Walker, Robert John, 1909-','Algebraic curves.');
INSERT INTO new_titles VALUES ('2000/10/01','E457.91 1953','AAI-4170','Lincoln, Abraham, 1809-1865.','Collected works.');
INSERT INTO new_titles VALUES ('2000/10/01','GN4 .E7 1936','AAJ-7920','','Essays in anthropology presented to A. L. Kroeber in celebration of his sixtieth birthday, June 11, 1936.');
INSERT INTO new_titles VALUES ('2000/10/01','PZ3.N524 Ca','AAG-5182','Nicholson, Meredith, 1866-1947.','The cavalier of Tennessee,');
INSERT INTO new_titles VALUES ('2000/10/01','PZ3.S87872 Pr','AAD-7145','Stone, Irving, 1903-','The President\'s lady; a novel about Rachel and Andrew Jackson.');
INSERT INTO new_titles VALUES ('2000/10/01','hv98.n8w3 1973 cop2 help for the citizen','','','');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-61','AKB-2696','United States. Congress. House. Committee on Transportation and Infrastructure.','Authorizing the use of the Capitol grounds for a bike rodeo to be conducted by the Earth Force Youth Bike Summit : repor');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-4186','Bartholomew, W.','Causal Argument (student example): A Decline in Academic Performence.');
INSERT INTO new_titles VALUES ('2000/10/02','S49 .E35','AAU-9042','','Agricultural economics mimeo report.');
INSERT INTO new_titles VALUES ('2000/10/02','QL801 .A60','AAV-0882','','Anatomy and embryology');
INSERT INTO new_titles VALUES ('2000/10/03','QA76 .A63','AJL-4364','','Annual reviews in control.');
INSERT INTO new_titles VALUES ('2000/10/03','PK1723 .K48 1995','AJX-0169','Tagore, Rabindranath, 1861-1941.','Khamosh husn /');
INSERT INTO new_titles VALUES ('2000/10/02','QD1 .A52','AAT-9112','','The Journal of the American Chemical Society.');
INSERT INTO new_titles VALUES ('2000/10/02','SF961 .B6850','AAT-7767','','The Bovine practitioner.');
INSERT INTO new_titles VALUES ('2000/10/02','dg657.75 k45 v.2 dispatches of milanese','','','');
INSERT INTO new_titles VALUES ('2000/10/02','QD271 .C54','AAP-4844','','Chromatographia');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-317','AMQ-0157','Duffield, John W.','Economic value of instream flow in Montana\'s Big Hole and Bitterroot rivers');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-316','AMQ-8442','Czaplewski, Raymond L.','Variance approximations for assessments of classification accuracy');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:PNW-RP-401-416','AMF-4323','Yarie, John.','Twig and foliar biomass estimation equations for major plant species in the Tanana River Basin of interior Alaska');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-292-299, 301-315','AMB-7909','Van Haverbeke, David F., 1928-','Genetic variation in Great Plains juniperus /');
INSERT INTO new_titles VALUES ('2000/10/28','A 17.27/2:','AMA-5864','','Animal Welfare Information Center newsletter.');
INSERT INTO new_titles VALUES ('2000/10/28','D 208.209:','ALS-6889','','Naval War College review.');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-271-290','ALN-8979','Alexander, Robert R.','Forest vegetation of the Medicine Bow National Forest in southeastern Wyoming : a habitat type classification /');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-251-270','ALG-7132','Kaufmann, Merrill R.','Effects of weather and physiographic conditions on temperature and humidity in subalpine watersheds of the Fraser Experi');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-193-205','AKY-0904','Hinds, Thomas E.','Growth and decay losses in Colorado aspen /');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-224','AKL-5890','Mathiasen, Robert L.','Taxonomy and effects of dwarf mistletoe on Bristlecone pine on the San Francisco Peaks, Arizona /');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RM-206-223','AKK-3844','Dawson, K. L.','Numerical simulation of jet roof geometry for snow cornice control /');
INSERT INTO new_titles VALUES ('2000/10/28','D 301.26/24:','AKE-0197','','Airpower journal.');
INSERT INTO new_titles VALUES ('2000/10/28','C 59.11:','AKD-4203','','Survey of current business /');
INSERT INTO new_titles VALUES ('2000/10/28','A 13.78:RMRS-RP-17','AKD-1145','Markstrom, Donald C.','Service life of fence posts treated by double-diffusion methods /');
INSERT INTO new_titles VALUES ('2000/10/28','CC 1.12/3:','AKC-8618','United States. Federal Communications Commission.','FCC record : a comprehensive compilation of decisions, reports, public notices, and other documents of the Federal Commu');
INSERT INTO new_titles VALUES ('2000/10/28','C 21.5:','AKA-7734','','Official gazette of the United States Patent and Trademark Office.');
INSERT INTO new_titles VALUES ('2000/10/28','S583 .A379','ACR-3326','','Bioscience, biotechnology, and biochemistry.');
INSERT INTO new_titles VALUES ('2000/10/28','RA1190 .M42','ACN-2555','','Drug safety');
INSERT INTO new_titles VALUES ('2000/10/28','RA773 .H43','ACQ-8578','Health (San Francisco, Calif.)','Health');
INSERT INTO new_titles VALUES ('2000/10/28','RC110 .R47','ACQ-4050','','Clinical infectious diseases : an official publication of the Infectious Diseases Society of America');
INSERT INTO new_titles VALUES ('2000/10/28','RA1190 .C475','ACH-7124','','Chemical research in toxicology.');
INSERT INTO new_titles VALUES ('2000/10/28','TT520 .Z35 1987','ACH-9091','Zamkoff, Bernard.','Basic pattern skills for fashion design /');
INSERT INTO new_titles VALUES ('2000/10/28','NK1160 .A94','ACH-8692','Axis (Tokyo, Japan)','Axis');
INSERT INTO new_titles VALUES ('2000/10/28','S494.5.D3 C7','ACB-1047','','Computers and electronics in agriculture');
INSERT INTO new_titles VALUES ('2000/10/03','QC173.45 .E86','AJJ-9693','','The European physical journal.');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-69','AKB-2456','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 4, declaration of policy of the United States concerning national missile defens');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-62','AKB-2453','United States. Congress. House. Committee on Transportation and Infrastructure.','Authorizing the 1999 District of Columbia special olympics law Enforcement torch run to be run through the Capitol groun');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-52','AKB-2450','United States. Congress. House. Committee on Ways and Means.','Measures relating to steel imports : adverse report together with additional and dissenting views (to accompany H.R. 975');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-63','AKB-2449','United States. Congress. House. Committee on Transportation and Infrastructure.','Authorizing the use of the east front of the Capitol grounds for performances sponsored by the John F. Kennedy Center fo');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-59','AKB-2444','United States. Congress. House. Committee on Transportation and Infrastructure.','Authorizing the use of the Capitol grounds for the Greater Washington Soap Box Derby : report (to accompany H. Con. Res.');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-47','AKB-2210','United States. Congress. House. Committee on Small Business.','Women\'s Business Center Amendments Act of 1999 : report (to accompany H.R. 774) (including cost estimate of the Congress');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-38','AKB-2209','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 661, Conditionally prohibiting the operation of supersonic aircraft : report (to');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-50','AKB-2207','United States. Congress. House. Committee on Government Reform.','A citizen\'s guide on using the Freedom of Information Act and the Privacy Act of 1974 to request government records : fi');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-57','AKB-2173','United States. Congress. House. Committee on Transportation and Infrastructure.','Edward N. Cahn Federal Building and United States Courthouse : report (to accompany H.R. 751) (including cost estimate o');
INSERT INTO new_titles VALUES ('2000/09/27','[GIS Cabinet] HA201 1980h','AJX-5410','','CensusCD 1980');
INSERT INTO new_titles VALUES ('2000/09/27','PK2200.B338 A63 1994','AJX-3711','Basheshar Pardip, 1925-','Abhi to dard baqi hai /');
INSERT INTO new_titles VALUES ('2000/09/27','PK2200.P3459 S23 1995','AJX-1280','Parvin Shakir.','Sad barg /');
INSERT INTO new_titles VALUES ('2000/09/27','PK2199.A5 Z73 1983','AJX-1240','Mahdi, Sughra, 1937-','Akbar Allahabadi /');
INSERT INTO new_titles VALUES ('2000/09/27','S188.S26 A38','AJW-0655','','Agro de Cuyo.');
INSERT INTO new_titles VALUES ('2000/09/27','U55.M554 A33 1997','AJX-1217','Mohammad Khan, 1914-','Basalamat ravi /');
INSERT INTO new_titles VALUES ('2000/09/27','[Media] Q180.3 .I58 2000','AIR-2400','','Institutional citation report, 1981-1999, with citing papers.');
INSERT INTO new_titles VALUES ('2000/09/27','TT679 .K75','AIR-2209','','American sportswear & knitting times.');
INSERT INTO new_titles VALUES ('2000/09/27','NB553.L55 A4 1996','AIP-9231','Wilkinson, Alan G., 1941-','The sculpture of Jacques Lipchitz : a catalogue raisonn /');
INSERT INTO new_titles VALUES ('2000/09/27','&span AII-5557','AID-5555','','');
INSERT INTO new_titles VALUES ('2000/09/27','SF395.8.A1 P67 vol. 47 1996','AIJ-2868','','Transmissible gastroenteritis (TGE) /');
INSERT INTO new_titles VALUES ('2000/09/27','S121 .E28','AHZ-4970','Report (Vermont Resources Research Center)','Report.');
INSERT INTO new_titles VALUES ('2000/09/27','SF395.8.A1 P67 vol. 50 1993','AFT-1799','Straw, Barbara E.','Atrophic rhinitis /');
INSERT INTO new_titles VALUES ('2000/09/27','PS3557.R5355 C47 1994','AGC-3335','Grisham, John.','The chamber /');
INSERT INTO new_titles VALUES ('2000/09/27','S544.3.N8 N643','ACR-9782','','4-H L');
INSERT INTO new_titles VALUES ('2000/09/27','SB290 .K845','AFP-5422','','Planters\' bulletin of the Rubber Research Institute of Malaya.');
INSERT INTO new_titles VALUES ('2000/09/27','T55.4 .N67','ACQ-2296','','NCSU technical report');
INSERT INTO new_titles VALUES ('2000/09/27','SF395.8.A1 P67 vol. 56 1986','ACR-1876','','Swine dysentery (bloody scours, vibrionic dysentery, black scours) /');
INSERT INTO new_titles VALUES ('2000/09/27','S338.R45 A39','ACQ-1365','Zambia. Dept. of Agriculture. Research Branch.','Annual report of the Research Branch');
INSERT INTO new_titles VALUES ('2000/09/27','S539.7 .R48','ACO-0450','Research Center Administrators Society.','Proceedings of the Research Center Administrators Society, Southern Region');
INSERT INTO new_titles VALUES ('2000/09/27','S217.A2 A32','ACJ-7528','Annual report (Agricultural and Food Research Council (Great Britain). Letcombe Laboratory)','Annual report /');
INSERT INTO new_titles VALUES ('2000/09/27','S303 .N66','ACJ-6133','','Journal of the National Agricultural Experiment Station');
INSERT INTO new_titles VALUES ('2000/09/27','S55 .E18','ACE-8103','Bulletin (University of Illinois at Urbana-Champaign. Agricultural Experiment Station)','Bulletin /');
INSERT INTO new_titles VALUES ('2000/09/27','TP1 .E9','ABR-2965','','Europa Chemie.');
INSERT INTO new_titles VALUES ('2000/09/27','SD15 .M39','ABS-6945','Publicacin (Mexico. Direccin General del Inventario National Forestal)','Publicacin');
INSERT INTO new_titles VALUES ('2000/09/27','S217.A2 A32','ABG-0366','Annual report (Agricultural Research Council (Great Britain). Letcombe Laboratory)','Annual report /');
INSERT INTO new_titles VALUES ('2000/09/27','PN43 .D5','ABE-6817','Disraeli, Isaac, 1766-1848.','Curiosities of literature.');
INSERT INTO new_titles VALUES ('2000/09/27','QC451 .S63','ABC-5038','','Spectroscopy /');
INSERT INTO new_titles VALUES ('2000/09/27','S19 .S36','ABD-0227','','Samaru miscellaneous paper');
INSERT INTO new_titles VALUES ('2000/09/27','BF11 .U54','AAZ-0291','','Ume psychological reports');
INSERT INTO new_titles VALUES ('2000/09/27','RM214 .J6','AAZ-1179','','The Journal of nutrition');
INSERT INTO new_titles VALUES ('2000/09/27','Q4 .B94','AAZ-1435','','Bulletin of the Kyushu Institute of Technology.');
INSERT INTO new_titles VALUES ('2000/09/27','Q11 .O5','AAY-9451','','Proceedings of the Oklahoma Academy of Science');
INSERT INTO new_titles VALUES ('2000/09/27','[Law Alcove] JK1 .C66','AAX-3164','','Congressional quarterly almanac.');
INSERT INTO new_titles VALUES ('2000/09/27','RB1 .A3','AAW-4161','','American journal of clinical pathology official publication, the American Society of Clinical Pathologists.');
INSERT INTO new_titles VALUES ('2000/09/27','DP66 .M47','AAI-7832','Merriman, Roger Bigelow, 1876-1945.','The rise of the Spanish Empire in the Old World and in the New.');
INSERT INTO new_titles VALUES ('2000/09/27','QB351 .H26','AAC-4977','Hagihara, Yusuke, 1897-','Celestial mechanics.');
INSERT INTO new_titles VALUES ('2000/10/03','PN2860 .T35 1995','AIS-9773','','Taking a ride on the clay cart dynamics of Sanskrit theatre /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-301','ALB-6942','Barrett, James W. (James Willis), 1922-','Twenty-year growth of ponderosa pine saplings thinned to five spacings in central Oregon /');
INSERT INTO new_titles VALUES ('2000/10/03','TP248.13 .C87','AIP-7390','','Current opinion in biotechnology.');
INSERT INTO new_titles VALUES ('2000/10/03','PS3569.M5376 S66 1971','AIE-5171','Smith, Lee, 1944-','Something in the wind.');
INSERT INTO new_titles VALUES ('2000/10/03','TK8300 .A38','AGD-9923','','Advances in imaging and electron physics.');
INSERT INTO new_titles VALUES ('2000/10/03','QD1 .F32','AIC-9204','','Faraday discussions.');
INSERT INTO new_titles VALUES ('2000/10/03','QC717.6 .P392','AFT-9320','','Physics of plasmas.');
INSERT INTO new_titles VALUES ('2000/10/03','HD9049.W3 W58','AFQ-2632','','World grain statistics.');
INSERT INTO new_titles VALUES ('2000/10/03','QH1 .L75','AFQ-1121','','Transactions of the Linnean Society.');
INSERT INTO new_titles VALUES ('2000/09/27','Course Shelf','ANZ-4063','','Readings for HI300 Jackson. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-4171','Franklin, V.P.','Education for Life: Adult Education Program for African Americans in Northern Cities, 1900-1942. Chapter 7.');
INSERT INTO new_titles VALUES ('2000/09/27','Desk File','ANZ-4061','','MA341 Garoutte notebook. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/09/27','Y 4.T 68/2:106-42','ANZ-4049','United States. Congress. House. Committee on Transportation and Infrastructure. Subcommittee on Ground Transportation','The future of the Woodrow Wilson Bridge : hearing before the Subcommittee on Ground Transportation of the Committee on T');
INSERT INTO new_titles VALUES ('2000/09/27','Y 4.T 68/2:106-27','ANZ-4048','United States. Congress. House. Committee on Transportation and Infrastructure. Subcommittee on Water Resources and Environment.','Estuaries and coastal water quality legislation : hearing before the Subcommittee on Water Resources and Environment of');
INSERT INTO new_titles VALUES ('2000/09/27','Y 4.F 76/2:S.HRG.106-500','ANZ-4046','United States. Congress. Senate. Committee on Foreign Relations.','The war in Chechnya : Russia\'s conduct, the humanitarian crisis, and United States policy : hearing before the Committee');
INSERT INTO new_titles VALUES ('2000/09/27','SF395.8.A1 P67 vol. 34 1982','ANZ-4009','Miller, Elwyn R.','Baby pig anemia /');
INSERT INTO new_titles VALUES ('2000/09/27','SF395.8.A1 P67 vol. 29 1985','ANZ-4010','Hogg, Alex.','Mycoplasmal diseases of swine /');
INSERT INTO new_titles VALUES ('2000/09/27','SF395.8.A1 P67 vol. 43 1979','ANZ-4008','Bergeland, Martin.','Edema disease (gut edema; E. coli enterotoxemia) /');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3983','Minchin, T.J.','Eight');
INSERT INTO new_titles VALUES ('2000/09/27','SF395.8.A1 P67 vol. 59 1985','ANZ-4007','Leman, Allen D., 1944-','Infectious swine reproductive diseases /');
INSERT INTO new_titles VALUES ('2000/09/27','A 1.76:73/955','ANZ-3956','Sherwood, Gerald E.','Wood-frame house construction /');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3948','Wadlinger, R., et al.','Immigrant Worker and American Labor: Challenge...or Disaster');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3884','Reed Jr., Adolph.','The Allure of Malcom X and the Changing Character of Black Politics (Ch 7).');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3880','Reed Jr., Adolph.','The Underclass as Myth and Symbol: The Poverty of Discourse about Poverty (Ch 6).');
INSERT INTO new_titles VALUES ('2000/09/27','SF395.8.A1 P67 vol. 50 1986','ANZ-3808','Wohlgemuth, Kurt.','Atrophic rhinitis /');
INSERT INTO new_titles VALUES ('2000/09/27','SF395.8.A1 P67 vol. 47 1983','ANZ-3794','Haelterman, E. O.','Transmissible gastroenteritis (TGE) /');
INSERT INTO new_titles VALUES ('2000/09/27','SF395.8.A1 P67 vol. 44 1994','ANZ-3681','Stewart, T. Bonner','Internal parasites in swine /');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3687','Various.','Contemporary Critical Reception. Pt. 2 of 2.');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3674','Jacobus, Mary.','Tess: The Making of a Pure Woman.');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3679','Various.','Contemporary Critical Reception. Pt. 1 of 2.');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.88:NE-263','ANZ-3673','Bragg, Don C.','Annotated bibliography on \"birdseye\" figured grain /');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:PSW-RP-237','ANZ-3672','','Effectiveness of esfenvalerate, cyfluthrin, and carbaryl in protecting individual lodgepole pines and ponderosa pines fr');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.88:SRS-21','ANZ-3671','Diamond, David Daniel, 1956-','An old-growth definition for southwestern subtropical upland forests /');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:PSW-RP-235','ANZ-3670','McDonald, Philip M.','Combining silviculture and landscape architecture to enhance the roadside view /');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.88:PNW-GTR-500','ANZ-3666','Linking Healthy Forests and Communities Through Alaska Value-Added Forest Products (1999 : Sitka, Alaska)','Proceedings : linking healthy forests and communities through Alaska value-added forest products : Sitka, Alaska, Septem');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.88:NC-205','ANZ-3665','Symposium on Systems Analysis in Forest Resources (7th : 1997 : Traverse City, Mich.)','Seventh Symposium on Systems Analysis in Forest Resources : Traverse City, Michigan, USA, May 28-31, 1999 /');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:FPL-450','ANZ-3621','Schaffer, Erwin L.','Structural fire design : wood /');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3658','Tanner, Tony.','Colour and Movement in Hardy\'s Tess of the D\'Urbervilles.');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:FPL-427','ANZ-3604','','Influence of chuck design on spin-out torque in softwood veneer peeling blocks.');
INSERT INTO new_titles VALUES ('2000/09/27','SF395.8.A1 P67 vol. 40 1987','ANZ-3597','McKean, James, 1946-','External parasite control /');
INSERT INTO new_titles VALUES ('2000/09/27','SF395.8.A1 P67 vol. 40 1992','ANZ-3594','McKean, James, 1946-','External parasite control /');
INSERT INTO new_titles VALUES ('2000/09/27','Course Shelf','ANZ-3589','','Readings of PHI598 Auerbach[Photocopy]');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3584','Meier, Kenneth','Bureaucratic Power and Its Causes');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3586','Smith, Jane I.','Women and Islam');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3582','Caiden, Gerald E. and naomi J. Caiden','Administrative Corruption');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3580','Lindblom, Charles E.','The Science of \"Muddling Through\"');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3578','Vest, Michael J., Fabius P. O\'Brien, and Jusanne Meltzer Vest','Explaining Rights Arbitrator Willingness to Accept Public Sector iInterest Arbitration Cases');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3576','Perry, Ronald W. and N. Joseph Cayer','Factors Affecting Municipal satisfaction with Health Care Plans');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3572','Pickett, Les','Competencies and Managerial Effectiveness: Putting Competencies to Work');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3574','Segerstrale, Ullica','Negotiating \"Sound Science\": Expert Disagreement about the Risks of Release of Genetically Engineered Micro-Organizisms');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3571','Roberts, Gary E.','Developmental Performance Appraisal in Municipal Government');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3569','Sims, Ronald R. and Serbrenia J. Sims','Improving Training in the Public Sector');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3567','Singer, Jerome L. and Peter Salovey','Organized Knowledge Structures and Personality: Person Schemas, Self Schemas, Prototypes, and Scripts');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3565','Pyne, Joan','What Public Employee Relation Boards and the Courts Are Deciding');
INSERT INTO new_titles VALUES ('2000/09/27','','ANZ-3563','Douglas, Joel M.','State Civil Service and Collective Bargaining: Systems in Conflict');
INSERT INTO new_titles VALUES ('2000/09/27','PREX 3.10/4:W 89/46','ANZ-3428','United States. Central Intelligence Agency.','[Political map of the world].');
INSERT INTO new_titles VALUES ('2000/09/27','SB472.7 .A47 1961','ANZ-3419','','Agricultural landscape design : a pilot project /');
INSERT INTO new_titles VALUES ('2000/09/27','A 13.78:FPL-402','ANZ-3411','','Wood joist floors : probabilistic analysis of joist stiffness measured at retail lumberyards.');
INSERT INTO new_titles VALUES ('2000/09/27','RE86 .O64 2000','ANZ-2718','','Ophthalmic technologies X : 22-23 January 2000, San Jose, USA /');
INSERT INTO new_titles VALUES ('2000/09/27','TA418.9.S62 S49 2000h','ANZ-2717','','Smart structures and materials 2000. 7-9 March, 2000, Newport Beach, USA /');
INSERT INTO new_titles VALUES ('2000/09/27','TA418.9.S62 S49 2000g','ANZ-2716','','Smart structures and materials 2000.');
INSERT INTO new_titles VALUES ('2000/09/27','TA418.9.S62 S49 2000c','ANZ-2714','','Smart structures and materials 2000. 6-9 March, 2000, Newport Beach, USA /');
INSERT INTO new_titles VALUES ('2000/09/27','R857.L37 L3747 2000','ANZ-2713','','Laser-tissue interaction XI : photochemical, photothermal, and photomechanical : 22-27 January 2000, San Jose, USA /');
INSERT INTO new_titles VALUES ('2000/09/27','TA418.9.S62 S49 2000d','ANZ-2711','','Smart structures and materials 2000.');
INSERT INTO new_titles VALUES ('2000/09/27','TA418.9.S62 S49 2000i','ANZ-2708','','Smart structures and materials 2000. 6-9 March, 2000, Newport Beach, USA /');
INSERT INTO new_titles VALUES ('2000/09/27','SF973 .C47 2000','ANZ-2456','','Classical swine fever and emerging diseases in Southeast Asia : [proceedings of an international workshop] Vientiane, La');
INSERT INTO new_titles VALUES ('2000/09/27','QK898.T2 T36 2000','ANZ-2455','','Tannins in livestock and human nutrition : proceedings of an international workshop, Adelaide, Australia, May 31-June 2,');
INSERT INTO new_titles VALUES ('2000/09/27','TA418.9.S62 S49 2000f','ANZ-2383','','Smart structures and materials 2000. 6-8 March, 2000, Newport Beach, USA /');
INSERT INTO new_titles VALUES ('2000/09/27','TA418.9.S62 S49 2000e','ANZ-2380','','Smart structures and materials 2000. 6-8 March 2000, Newport Beach, USA /');
INSERT INTO new_titles VALUES ('2000/09/27','TA1632 .H82 2000','ANZ-2376','','Human vision and electronic imaging V : 24-27 January, 2000, San Jose, USA /');
INSERT INTO new_titles VALUES ('2000/09/27','LD3921 Marine, Earth & Atm. Sci. S697','ANZ-2310','Springer, Jeffrey John.','Interactions between two commercially imporatant species of bivalve molluscs and the toxic estuarine dinoflagellate, Pfi');
INSERT INTO new_titles VALUES ('2000/09/27','LD3921 For. S316','ANZ-2194','Scherrer, Elizabeth.','Using microtopography to restore wetland plant communities in eastern North Carolina /');
INSERT INTO new_titles VALUES ('2000/09/27','LD3921 Marine, Earth & Atm. Sci. N452','ANZ-2172','Nelson, Dena Renee, 1974-','Analysis of ammonia emissions from agriculture and ammonium concentrations in the Southeastern United States /');
INSERT INTO new_titles VALUES ('2000/09/27','LD3921 Marine, Earth & Atm. Sci. M58','ANZ-2167','Mitchem, Jamie D., 1976-','The role of dual cold fronts aloft in the generation of a major tornado outbreak /');
INSERT INTO new_titles VALUES ('2000/09/27','Y 4.G 74/7:R 32/2','ANZ-2092','United States. Congress. House. Committee on Government Reform. Subcommittee on Government Management, Information, and Technology.','Oversight of Internal Revenue Service\'s fiscal year 1998 finanacial statements : hearing before the Subcommittee on Gove');
INSERT INTO new_titles VALUES ('2000/09/27','HC79.C3 B795 2000','ANZ-1800','Bubnova, Nina, 1974-','Governance impact on private investment : evidence from the international patterns of infrastructure bond risk pricing /');
INSERT INTO new_titles VALUES ('2000/09/27','S619.S24 H55 2000','ANZ-1776','Hillel, Daniel.','Salinity management for sustainable irrigation : integrating science, environment, and economics /');
INSERT INTO new_titles VALUES ('2000/09/27','SH171 .T43 1993','ANZ-1563','','Techniques in fish immunology /');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-484','AMY-3235','Keane, Robert E.','FIRE-BGC--a mechanistic ecological process model for simulating fire succession on coniferous forest landscapes of the n');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-493','AMY-3144','Welch, Bruce L. (Bruce Leigh), 1943-','Effects of humidity on storing big sagebrush seed');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-489','AMX-7501','Harrington, Michael G.','Fall rates of prescribed fire-killed ponderosa pine');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-485','AMY-0010','Welch, Bruce L. (Bruce Leigh), 1943-','Strutting sounds and strutting posturing of two Utah sage grouse populations');
INSERT INTO new_titles VALUES ('2000/10/20','TD794.5 .V47 1986','AMX-0464','Vesilind, P. Aarne.','Resource recovery options for North Carolina : are there alternatives to landfills? /');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-482','AMW-9701','Cole, Dennis M.','Managing lodgepole pine to yield merchantable thinning products and attain sawtimber rotations');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-492','AMW-9215','','Response of a depleted sagebrush steppe riparian system to grazing control and woody plantings');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-494','AMW-9179','Bentz, Barbara J.','Localized spatial and temporal attack dynamics of the mountain pine beetle in lodgepole pine /');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-481','AMS-1959','Arno, Stephen F.','Age-class structure of old growth Ponderosa pine/Douglas fir stands and its relationship to fire history');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-477','AMQ-8959','','Managing coarse woody debris in forests of the Rocky Mountains');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-479','AMQ-9105','Bartos, Dale L.','Effects of thinning on temperature dynamics and mountain pine beetle activity in a lodgepole pine stand');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-478','AMQ-8689','Mueggler, W. F.','Sixty years of change in tree numbers and basal area in central Utah aspen stands');
INSERT INTO new_titles VALUES ('2000/10/19','','AOE-8693','Ford, Edward R.','The details of modern architecture');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-476','AMP-1819','Sloan, John P.','Root dipping of conifer seedlings shows little benefit in the northern Rocky Mountains');
INSERT INTO new_titles VALUES ('2000/10/19','','AOE-8681','Stokes,Samuel N.,et al.','Rural Conservation Through Local Government (ch 4)');
INSERT INTO new_titles VALUES ('2000/10/19','','AOE-8656','Forman,Richard T.T.','Land Planning and Management (ch.13)');
INSERT INTO new_titles VALUES ('2000/09/27','BV631 .R35 2000','ANY-9985','','Religion and democracy /');
INSERT INTO new_titles VALUES ('2000/09/27','Y 1.1/8:106-73','ANZ-0324','United States. Congress. House. Committee on the Budget.','Concurrent resolution on the budget - fiscal year 2000 : report ... to accompany H. Con. Res. 68, establishing the congr');
INSERT INTO new_titles VALUES ('2000/10/19','A 13.79:INT-387','AOE-8652','Reinhardt, Elizabeth D.','Eight-year tree growth following prescribed underburning in a western Montana Douglas-fir/western larch stand /');
INSERT INTO new_titles VALUES ('2000/10/19','','AOE-8618','Ludwig,John A.','Disturbance and Landscapes:The Little Things Count');
INSERT INTO new_titles VALUES ('2000/10/19','Desk File','AOE-8591','','NTR415 Croom lesson 18. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/19','','AOE-8601','Lyle, John Tillman','Location Impact prediction (ch.15)');
INSERT INTO new_titles VALUES ('2000/09/27','NA1510.8.N42 K374 1997','ANY-8519','Gutschow, Niels.','The Nepalese caitya : 1500 years of Buddhist votive architecture in the Kathmandu Valley /');
INSERT INTO new_titles VALUES ('2000/10/28','R850.A1 B72','ABU-7017','','Brazilian journal of medical and biological research');
INSERT INTO new_titles VALUES ('2000/10/28','QA403.5 .T74 1983','ABW-0821','Triebel, Hans.','Theory of function spaces /');
INSERT INTO new_titles VALUES ('2000/09/27','BF175.4.C68 C66 2000','ANY-7412','Cooper, Steven H., 1951-','Objects of hope : exploring possibility and limit in psychoanalysis /');
INSERT INTO new_titles VALUES ('2000/10/27','T357 .L53','AAO-1539','Lincoln Electric Company.','How to read shop drawings, with special reference to welding and welding symbols. Welding symbols as standardized by the');
INSERT INTO new_titles VALUES ('2000/10/27','BH39 .E4 1939','AAR-2083','Edman, Irwin, 1896-1954.','Arts and the man; a short introduction to aesthetics');
INSERT INTO new_titles VALUES ('2000/10/28','HQ796 .J624','ABR-6024','','The Journal of early adolescence');
INSERT INTO new_titles VALUES ('2000/10/28','S15 .P58','ABM-8794','Pesquisa agropecuria brasileira (Braslia, Brazil : 1977)','Pesquisa agropecuria brasileira');
INSERT INTO new_titles VALUES ('2000/10/28','E865 .H37','ABP-9549','Hartmann, Robert Trowbridge, 1917-','Palace politics : an insider\'s account of the Ford years /');
INSERT INTO new_titles VALUES ('2000/10/28','LB1705 .T41','ABP-3857','','The Teacher educator');
INSERT INTO new_titles VALUES ('2000/10/28','DK651.W2 C5','ABH-4516','Ciborowski, Adolf.','Warszawa odbudowana /');
INSERT INTO new_titles VALUES ('2000/10/28','HD9577.A42 S3413 1977','ABG-3056','Schliephake, Konrad.','Oil and regional development : examples from Algeria and Tunisia /');
INSERT INTO new_titles VALUES ('2000/10/28','SF221 .C96','ABF-1163','','Cultured dairy products journal : CDP');
INSERT INTO new_titles VALUES ('2000/10/28','AE 2.108/2:','AAZ-1736','United States government manual (Washington, D.C. : 1973)','The United States government manual.');
INSERT INTO new_titles VALUES ('2000/10/28','RC423.A1 B68','AAZ-1951','','Brain and language');
INSERT INTO new_titles VALUES ('2000/10/28','DK553 .G62','AAX-6685','Gosling, Nigel.','Leningrad; history, art, architecture.');
INSERT INTO new_titles VALUES ('2000/10/28','RC799 .G29','AAX-3867','','Gastroenterology official journal of the American Gastroenterological Association.');
INSERT INTO new_titles VALUES ('2000/10/28','RC321 .A63','AAW-7631','','Archives of general psychiatry');
INSERT INTO new_titles VALUES ('2000/10/27','bf467.m513','','','');
INSERT INTO new_titles VALUES ('2000/10/27','H41 .E6','AAG-0973','','Encyclopaedia of the social sciences,');
INSERT INTO new_titles VALUES ('2000/10/28','RC321 .A52','AAW-4169','','The American journal of insanity');
INSERT INTO new_titles VALUES ('2000/10/28','RC321 .A52','AAW-4184','','The American journal of psychiatry');
INSERT INTO new_titles VALUES ('2000/10/28','HE6371 .D4','AAV-7018','Foley, Rae, 1900-','America\'s silent investigators; the story of the postal inspectors who protect the United States mail.');
INSERT INTO new_titles VALUES ('2000/10/28','PQ6033 .T5','AAW-1802','Ticknor, George, 1791-1871.','History of Spanish literature.');
INSERT INTO new_titles VALUES ('2000/10/28','D7 .C9','AAV-6185','Creighton, M. (Mandell), 1843-1901.','Historical lectures and addresses;');
INSERT INTO new_titles VALUES ('2000/10/28','QB351 .H26','AAC-4977','Hagihara, Yusuke, 1897-','Celestial mechanics.');
INSERT INTO new_titles VALUES ('2000/10/28','S590 .G46','AAT-2038','','Geoderma');
INSERT INTO new_titles VALUES ('2000/10/03','S544.3.N8 N643','ACR-9782','','4-H L');
INSERT INTO new_titles VALUES ('2000/10/03','TK7874 .I586','ACR-5492','','The International journal of microcircuits and electronic packaging');
INSERT INTO new_titles VALUES ('2000/10/03','BF39 .O24 1992','ACP-8390','','Objective measurement : theory into practice /');
INSERT INTO new_titles VALUES ('2000/10/03','TS1109 .T445','ACJ-6145','','TAPPI test methods.');
INSERT INTO new_titles VALUES ('2000/10/03','SB273 .F674','ACK-1054','','Flue cured tobacco production ideas');
INSERT INTO new_titles VALUES ('2000/10/03','SB21 .M42','ACH-2027','Massachusetts Horticultural Society.','Annual report for the year ..');
INSERT INTO new_titles VALUES ('2000/10/03','T12 .M3','ACE-4033','MacRae\'s blue book (New York, N.Y.)','MacRae\'s blue book');
INSERT INTO new_titles VALUES ('2000/10/03','HF5415 .B53 1986','ACC-1626','Boone, Louis E.','Contemporary marketing /');
INSERT INTO new_titles VALUES ('2000/10/03','SB273 .F67','ACB-8536','Flue-cured tobacco ... calendar (Virginia, North & South Carolina edition)','Flue-cured tobacco ... calendar');
INSERT INTO new_titles VALUES ('2000/10/03','S539.I4 B33','ACB-6722','','U.A.S. miscellaneous series');
INSERT INTO new_titles VALUES ('2000/10/03','S111 .A32','ABX-7423','','Annual report of the commissioner of agriculture, commerce and immigration of the state of South Carolina.');
INSERT INTO new_titles VALUES ('2000/10/03','S441 .N674','ABX-7377','','North central regional publication');
INSERT INTO new_titles VALUES ('2000/10/03','TJ759 .J8 1932','ABQ-2863','Judge, Arthur William, 1887-','The testing of high speed internal combustion engines, with special reference to automobile and aircraft types and to th');
INSERT INTO new_titles VALUES ('2000/10/03','RA421 .R6','ABN-7931','Rockefeller Foundation. International Health Division.','Annual report /');
INSERT INTO new_titles VALUES ('2000/10/03','JX1977 .A53','ABN-4599','United Nations. Dept. of Political and Security Council Affairs.','Repertoire of the practice of the Security Council.');
INSERT INTO new_titles VALUES ('2000/10/03','SH11 .F64','ABM-7332','','Summary of Florida commercial marine landings');
INSERT INTO new_titles VALUES ('2000/10/03','HC59.7 .W659','ABK-9131','','World development report.');
INSERT INTO new_titles VALUES ('2000/10/03','QE77 .G84','ABM-2609','','Guide to U. S. government maps, geologic and hydrologic maps');
INSERT INTO new_titles VALUES ('2000/10/19','A 13.78:INT-241-256','AOE-8471','Lowery, David P.','Preservation of dead lodgepole pine posts and poles /');
INSERT INTO new_titles VALUES (NULL,NULL,NULL,NULL,'eric');
INSERT INTO new_titles VALUES ('2000/10/04','Y4.F76/1:N15/4 1981 US POLICY TOWARDS','','','');
INSERT INTO new_titles VALUES ('2000/10/03','TK3001 .A44','ABI-9682','Allerton Conference on Communication, Control, and Computing.','Proceedings - Annual Allerton Conference on Communication, Control, and Computing');
INSERT INTO new_titles VALUES ('2000/10/03','HC271 .O7','ABH-6599','','OECD economic surveys.');
INSERT INTO new_titles VALUES ('2000/10/03','QA1 .N525a','ABH-7786','Nihon Gakushiin.','Proceedings of the Japan Academy.');
INSERT INTO new_titles VALUES ('2000/10/03','TS1975 .M430','ABH-2214','','Meat and poultry inspection directory');
INSERT INTO new_titles VALUES ('2000/10/03','QA276.4 .A43a','ABG-2105','American Statistical Association. Statistical Computing Section.','Proceedings of the Statistical Computing Section');
INSERT INTO new_titles VALUES ('2000/10/03','PR4147 .B47','ABG-6845','','Blake');
INSERT INTO new_titles VALUES ('2000/10/03','HG2613.S4 F43','ABD-8197','Economic review (Federal Reserve Bank of San Francisco)','Economic review.');
INSERT INTO new_titles VALUES ('2000/10/03','QP36 .M54 1977','ABD-4767','Memmler, Ruth Lundeen.','Structure and function of the human body /');
INSERT INTO new_titles VALUES ('2000/10/03','QH301 .A372','ABD-0820','','Biological papers of the University of Alaska');
INSERT INTO new_titles VALUES ('2000/10/03','QC791 .N83','AAY-9422','','Nuclear fusion');
INSERT INTO new_titles VALUES ('2000/10/03','Z731 .A53','ABD-0779','','American library directory');
INSERT INTO new_titles VALUES ('2000/10/03','RC60 .M4','AAY-9104','','The Medical clinics of North America');
INSERT INTO new_titles VALUES ('2000/10/03','QE119 .A2','AAY-9061','Report of the State Geologist (Maine Geological Survey)','Report of the State Geologist');
INSERT INTO new_titles VALUES ('2000/10/03','TS300 .S75','AAY-8640','Industry week (Cleveland, Ohio)','Industry week');
INSERT INTO new_titles VALUES ('2000/10/03','N5970 .D8','AAX-3384','','Dumbarton Oaks papers');
INSERT INTO new_titles VALUES ('2000/10/03','QL461 .E714','AAX-3574','','The Entomologist\'s monthly magazine');
INSERT INTO new_titles VALUES ('2000/10/03','TK146 .G65 1946','AAY-2645','Graham, Frank Duncan, 1875-','Audels handy book of practical electricity with wiring diagrams; ready reference for professional electricians, students');
INSERT INTO new_titles VALUES ('2000/10/03','QR1 .A42','AAW-2414','','Advances in microbial physiology');
INSERT INTO new_titles VALUES ('2000/10/03','DT1 .A113','AAW-2469','','Africa contemporary record');
INSERT INTO new_titles VALUES ('2000/10/03','TJ981 .C7','AAX-3128','','Compressed air');
INSERT INTO new_titles VALUES ('2000/10/03','QH71.V6 A2','AAV-0953','','Report of the Provincial Museum of Natural History');
INSERT INTO new_titles VALUES ('2000/10/03','RC488.5.A1 F3','AAU-4491','','Family process');
INSERT INTO new_titles VALUES ('2000/10/03','QH506 .P48','AAU-0423','Phillips, D. C. (David Chilton), 1924-','Atlas of molecular structures in biology /');
INSERT INTO new_titles VALUES ('2000/10/03','SF961 .B6850','AAT-7767','','The Bovine practitioner.');
INSERT INTO new_titles VALUES ('2000/10/03','TP9 .C49','AAN-9300','','Chemical and process technology encyclopedia.');
INSERT INTO new_titles VALUES ('2000/10/03','QC173 .J65','AAT-0101','','Journal of molecular structure.');
INSERT INTO new_titles VALUES ('2000/10/03','Y4.G74/9: S.HRG. 105-614 HEARING BEFORE','','','');
INSERT INTO new_titles VALUES ('2000/10/03','DT25 .D3 1959a','AAJ-1744','Davidson, Basil, 1914-','The lost cities of Africa /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-304','ALA-5751','Aho, Paul E.','Logging damage in thinned, young-growth true fir stands in California and recommendations for prevention /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-303','AKP-7189','Fahey, Thomas D. (Thomas Davin), 1947-','Product recovery from hemlock \"pulpwood\" from Alaska /');
INSERT INTO new_titles VALUES ('2000/10/18','Mf 267','AKN-3915','zel, Tugrul, 1967-','Investigation of high speed flat end milling process-prediction of chip formation, cutting forces, tool stresses and tem');
INSERT INTO new_titles VALUES ('2000/10/18','L 2.121/13:C 43/','AKN-2285','','National compensation survey.');
INSERT INTO new_titles VALUES ('2000/10/18','L 2.121/9:M 58/','AKN-1891','','National compensation survey.');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-508','AKC-8008','Cochran, P. H.','Growth of ponderosa pine thinned to different stocking levels in central Oregon 30-year results /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-516','AKC-5232','Beardsley, Debby.','Old-growth forests in the Sierra Nevada by type in 1945 and 1993 and ownership in 1993 /');
INSERT INTO new_titles VALUES ('2000/10/18','[Microfiche] TD 12.15/2:','AKC-3751','','Air carrier traffic statistics monthly');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-510','AKB-9677','','Electronic (fenceless) control of livestock');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.79:PNW-RN-539','AKB-9665','Bull, Evelyn L.','Effect of fuels reduction on American martens and their prey');
INSERT INTO new_titles VALUES ('2000/10/18','Mf 162 no. 11316','AJS-5938','Bauer-Messmer, Bettina, 1968-','Remote sensing of severe hailstorms /');
INSERT INTO new_titles VALUES ('2000/10/18','Mf 162 no. 11311','AJS-5937','Tencalla, Francesca. 1968-','Toxicity of cyanobacterial peptide toxins to fish /');
INSERT INTO new_titles VALUES ('2000/10/18','Mf 162 no. 11301','AJS-5933','Hess, Hans-Dieter, 1966-','Grazing selectivity and ingestive behaviour of steers on improved tropical pastures in the eastern plains of Colombia /');
INSERT INTO new_titles VALUES ('2000/10/18','Mf 162 no. 11298','AJS-5932','Mehmann, Brigitta, 1965-','Molecular identification of ectomycorrhizae of Picea abies /');
INSERT INTO new_titles VALUES ('2000/10/18','Mf 162 no. 9811','AJK-7794','Lang, Jeffrey Alan, 1964-','Evaluation of a flat plate membrane reactor for secondary metabolite production using plant cell culture /');
INSERT INTO new_titles VALUES ('2000/10/18','Mf 162 no. 9730','AJK-7790','Fahmy, Mona Khalil.','Treatment of sulphite pulp bleaching effluents in anaerobic aerobic fluidized bioflim reactors /');
INSERT INTO new_titles VALUES ('2000/10/18','DK510 .R87','AIQ-4572','Russkoe proshloe (Saint Petersburg, Russia : 1991)','Russkoe proshloe.');
INSERT INTO new_titles VALUES ('2000/10/18','HE 20.3559:SUPP.','AIK-3288','','Environmental health perspectives.');
INSERT INTO new_titles VALUES ('2000/10/18','[DVD] PN1993.5.I829 K353 2000','AIH-3653','','Kala Paani');
INSERT INTO new_titles VALUES ('2000/10/18','NK4005 .N37','ABV-4727','','NCECA journal /');
INSERT INTO new_titles VALUES ('2000/10/18','SB21 .P4','AFS-6717','State Horticultural Association of Pennsylvania.','Proceedings of the State Horticultural Association of Pennsylvania.');
INSERT INTO new_titles VALUES ('2000/10/18','QA1 .A652','ABT-2068','','Archimedes : tijdschrift voor allen de lagare Wiskunde beoefenen');
INSERT INTO new_titles VALUES ('2000/10/18','HE371.N75 N67a','ABD-7085','','Highway traffic statistics.');
INSERT INTO new_titles VALUES ('2000/10/18','SF97 .P35','ABK-0295','','Commercial feed, fertilizer and liming materials report');
INSERT INTO new_titles VALUES ('2000/10/18','S960 .A47','AAZ-0764','Africana (Nairobi, Kenya)','Africana');
INSERT INTO new_titles VALUES ('2000/10/18','SD97.M2 M25','AAX-7514','','Malayan forest records');
INSERT INTO new_titles VALUES ('2000/10/18','QA47 .T7','AAY-0289','','Tracts for computers');
INSERT INTO new_titles VALUES ('2000/10/18','DS796.H7.A33 1979','','','');
INSERT INTO new_titles VALUES ('2000/10/18','SH221 .A84','AAS-7813','Atlantic States Marine Fisheries Commission.','Annual report of the Atlantic States Marine Fisheries Commission');
INSERT INTO new_titles VALUES ('2000/10/29','','AOF-5437','Nathanson, Stephen.','Does It Matter if the Death Penalty is Arbitrarily Administered?');
INSERT INTO new_titles VALUES ('2000/10/29','','AOF-5435','Simmons, John A. et al. eds.','Justice, Civilization and the Death Penalty.');
INSERT INTO new_titles VALUES ('2000/10/29','','AOF-5431','Menninger, Karl. M.D.','Love Against Hate. Chapter 10.');
INSERT INTO new_titles VALUES ('2000/10/29','','AOF-5425','Greenwood, Peter.','Concept of Selective Incapacitation.');
INSERT INTO new_titles VALUES ('2000/10/29','','AOF-5433','Von Hirsch, Andrew.','Retribution:Desert.');
INSERT INTO new_titles VALUES ('2000/10/29','','AOF-5429','Menninger, Karl. M.D.','Injustice of Justice. Chapter 1.');
INSERT INTO new_titles VALUES ('2000/10/29','','AOF-5427','Cullen, Francis T. and Lawrence Travis.','Criminal Justice Theories and Ideologies.');
INSERT INTO new_titles VALUES ('2000/10/29','QL371 .S66 1999','ANQ-8267','','Sponges');
INSERT INTO new_titles VALUES ('2000/10/29','SF395.8.A1 P67 vol. 4 1983','AOE-4399','','On farm feed processing /');
INSERT INTO new_titles VALUES ('2000/10/29','QP624.75.P74 F76 1997','ANQ-8263','','From DNA to protein');
INSERT INTO new_titles VALUES ('2000/10/29','QL375 .C55 1999','ANQ-8265','','Cnidarians');
INSERT INTO new_titles VALUES ('2000/10/29','SF395.8.A1 P67 vol. 10 1987','AKJ-9857','Muehling, Arthur J., 1928-','Swine farrowing units /');
INSERT INTO new_titles VALUES ('2000/10/29','SF395.8.A1 P67 vol. 22 1991','ACR-6791','','Combining swine housing units into a system of buildings /');
INSERT INTO new_titles VALUES ('2000/10/29','A 93.11/2:','AKH-8934','','Feed outlook & situation /');
INSERT INTO new_titles VALUES ('2000/10/29','JX1974.7 .U38 1985','ACC-2175','','Unilateral nuclear disarmament measures.');
INSERT INTO new_titles VALUES ('2000/10/29','SF395.8.A1 P67 vol. 11 1991','ACR-1870','','Swine growing-finishing units /');
INSERT INTO new_titles VALUES ('2000/10/29','LD3921 Econ. & Business. B76','ACB-8753','Brown, Alvin Blake, 1959-','Economic consequences of increasing genetic potential for growth in beef cattle /');
INSERT INTO new_titles VALUES ('2000/10/29','TJ163.2 .R53 1982','ABV-2102','Ridgeway, James, 1936-','Powering civilization : the complete energy reader /');
INSERT INTO new_titles VALUES ('2000/10/29','SB191.R5 S660','ABP-9312','Soomrith, Boriboon.','Genetic analysis of traits related to grain characteristics and quality in two crosses of rice /');
INSERT INTO new_titles VALUES ('2000/10/29','KFN7963.Z9 U50 1978','ABK-6610','University of North Carolina at Chapel Hill. Institute of Government.','Punishment chart for crimes : of general interest in the superior courts of North Carolina /');
INSERT INTO new_titles VALUES ('2000/10/29','S471.U5 M3','ABF-3068','McMaster, D. N. (David Newcombe)','A subsistence crop geography of Uganda,');
INSERT INTO new_titles VALUES ('2000/10/29','PS551 .W5','ABG-7755','','White trash : an anthology of contemporary Southern poets /');
INSERT INTO new_titles VALUES ('2000/10/29','PR6052.O5 Z9 1976','ABA-4600','Scharine, Richard G.','The plays of Edward Bond /');
INSERT INTO new_titles VALUES ('2000/10/29','QH529 .B80','AAZ-3884','Burnet, F. M. (Frank Macfarlane), Sir, 1899-1985.','The biology of ageing /');
INSERT INTO new_titles VALUES ('2000/10/29','QA871 .M67','AAT-8742','Morrill, Bernard.','Mechanical vibrations.');
INSERT INTO new_titles VALUES ('2000/10/29','SF601 .V4','AAX-0531','','The British veterinary journal');
INSERT INTO new_titles VALUES ('2000/10/29','G601 .A33','AAW-2279','','Acta arctica');
INSERT INTO new_titles VALUES ('2000/10/29','QL549 .M3','AAT-5199','Macy, Ralph William, 1905-','Butterflies; a handbook of the butterflies of the United States, complete for the region north of the Potomac and Ohio r');
INSERT INTO new_titles VALUES ('2000/10/29','DC143 .L4','AAT-1578','Lefebvre, Georges, 1874-1959.','tudes sur la Rvolution franaise.');
INSERT INTO new_titles VALUES ('2000/10/29','LB775.T35 M8','AAO-8040','Mukherjee, Himangshu Bhushan, 1913-','Education for fulness; a study of the educational thought and experiment of Rabindranath Tagore.');
INSERT INTO new_titles VALUES ('2000/10/29','PR4453.C4 Z529','AAO-0170','Barker, Dudley.','G. K. Chesterton; a biography.');
INSERT INTO new_titles VALUES ('2000/10/29','QL58 .S5 1960','AAL-7863','Simpson, George Gaylord, 1902-','Quantitative zoology');
INSERT INTO new_titles VALUES ('2000/10/29','GV1783 .R8 1968','AAJ-7300','Russell, Joan.','Modern dance in education.');
INSERT INTO new_titles VALUES ('2000/10/29','HQ35 .P84','AAJ-3082','Public Affairs Committee.','Teen love, teen marriage,');
INSERT INTO new_titles VALUES ('2000/10/29','BT135 .V55','AAH-1683','Viner, Jacob, 1892-1970.','The role of providence in the social order; an essay in intellectual history.');
INSERT INTO new_titles VALUES ('2000/10/29','PA6274 .A2','AAJ-1791','Catullus, Gaius Valerius.','The poems of Catullus,');
INSERT INTO new_titles VALUES ('2000/10/29','HF5381.5 .T55','AAF-2858','Tiedeman, David V.','Career development: choice and adjustment; differentiation and integration in career development,');
INSERT INTO new_titles VALUES ('2000/10/29','DK755 .D63 1970','AAC-7939','Dobell, Peter, 1772-1852.','Travels in Kamtchatka and Siberia.');
INSERT INTO new_titles VALUES ('2000/10/29','S473.U35 J34 1970','AAD-4181','Jameson, J. D.','Agriculture in Uganda.');
INSERT INTO new_titles VALUES ('2000/10/28','QC233 .R49','AAS-5020','Richardson, Edward Gick, 1896-','Technical aspects of sound.');
INSERT INTO new_titles VALUES ('2000/10/28','HD9464.C22 N43','AAC-1567','Cell, Gillian T.','English enterprise in Newfoundland 1577-1660');
INSERT INTO new_titles VALUES ('2000/10/09','TK5105.35 .F736 1994','ANX-7784','Frame Relay Forum.','Frame relay PVC multicast service and protocol description implementation agreement /');
INSERT INTO new_titles VALUES ('2000/10/09','TK5105.35 .F737 1994','ANX-7782','Frame Relay Forum. Technical Committee.','Frame relay service customer network management implementation agreement /');
INSERT INTO new_titles VALUES ('2000/10/09','TK5105.35 .F735 2000','ANX-7778','Frame Relay Forum. Technical Committee.','Frame relay multiprotocol encapsulation implementation agreement /');
INSERT INTO new_titles VALUES ('2000/10/09','HD31 .P559 2000','ANX-7583','Pohlman, Randolph.','Value driven management : how to create and maximize value over time for organizational success /');
INSERT INTO new_titles VALUES ('2000/10/09','DS145 .L585 2000','ANX-7567','Lindemann, Albert S.','Anti-semitism before the Holocaust /');
INSERT INTO new_titles VALUES ('2000/10/09','HD57.7 .P46 2000','ANX-7248','Perkins, Dennis N. T., 1942-','Leading at the edge : leadership lessons from the extraordinary saga of Shackleton\'s Antarctic expedition /');
INSERT INTO new_titles VALUES ('2000/10/09','HD45 .G579 2000','ANX-7246','Good, David J., 1950-','Strategic, organizational, and managerial impacts of business technologies /');
INSERT INTO new_titles VALUES ('2000/10/09','HJ4653.F7 P37 1998','ANX-7122','Parker, R. Andrew.','Taxation of employee fringe benefits : a guide for state and local government employers /');
INSERT INTO new_titles VALUES ('2000/10/09','RC480 .F5568 2000','ANX-6786','','Six therapists and one client /');
INSERT INTO new_titles VALUES ('2000/10/09','DS735 .H25 2000','ANX-6777','Hansen, Valerie, 1958-','The open empire : a history of China to 1600 /');
INSERT INTO new_titles VALUES ('2000/10/09','DA447.N63 A3 2000','ANX-5690','North, Roger, 1653-1734.','Notes of me : the autobiography of Roger North /');
INSERT INTO new_titles VALUES ('2000/10/09','PN1995 .M54813 2000','ANX-5692','Mitry, Jean.','Semiotics and the analysis of film /');
INSERT INTO new_titles VALUES ('2000/10/09','KFN7481 .T56 2000','ANX-5404','Thornburg, Thomas H.','An introduction to law for North Carolinians /');
INSERT INTO new_titles VALUES ('2000/10/09','RA399.A3 M362 2000','ANX-5106','','Managed care and the evaluation and adoption of emerging medical technologies : executive summary /');
INSERT INTO new_titles VALUES ('2000/10/09','SH335 .M367 2000','ANX-4282','','Marine & freshwater products handbook /');
INSERT INTO new_titles VALUES ('2000/10/09','BT715 M75 2000','ANX-4251','Moroney, Stephen K., 1962-','The noetic effects of sin : a historical and contemporary exploration of how sin affects our thinking /');
INSERT INTO new_titles VALUES ('2000/10/09','BR252 .R35 2000','ANX-4217','','Reform and renewal in the Middle Ages and the Renaissance : studies in honor of Louis Pascoe /');
INSERT INTO new_titles VALUES ('2000/10/09','HD8039.D52 G84 1999','ANX-4023','Sambrook, Pamela.','The country house servant /');
INSERT INTO new_titles VALUES ('2000/10/09','PN4071 .B37','ANX-3858','','Basic course communication annual.');
INSERT INTO new_titles VALUES ('2000/10/09','F2175 .G545 2000','ANX-3955','Gilmore, John, 1956-','Faces of the Caribbean /');
INSERT INTO new_titles VALUES ('2000/10/09','QC611.8.L68 L69 2000','ANX-2238','','Low-dimensional systems : interactions and transport properties : lectures of a workshop held in Hamburg, Germany, July');
INSERT INTO new_titles VALUES ('2000/10/10','NA7208 .C46 1920','ALE-9219','Central Lumber Company.','Central\'s book of homes /');
INSERT INTO new_titles VALUES ('2000/10/10','TS2260 .R22 1889','ALE-9218','','R. W. Tansill & Co.');
INSERT INTO new_titles VALUES ('2000/10/10','QP84.6 .S63 1999','AKN-4698','Soave, Orland A.','Animal rhythms /');
INSERT INTO new_titles VALUES ('2000/10/10','TD 2.8:IN 2','AKN-1051','','Indian reservation roads program, transportation planning, procedures and guidelines.');
INSERT INTO new_titles VALUES ('2000/10/10','I 29.2:Z 6/4','AKN-1047','','Hiking the Zion Narrows, An Orientation, July 1999');
INSERT INTO new_titles VALUES ('2000/10/10','I 19.2:F 79/999','AKN-1045','Edwards, Lucy E.','Fossils, rocks, and time /');
INSERT INTO new_titles VALUES ('2000/10/10','ED 1.2:ST 9/24','AKN-1040','','Access America for students : strategic plan.');
INSERT INTO new_titles VALUES ('2000/10/10','NA9127.W2 J33 1980','AKM-9659','Jackson, Donald E.','L\'Enfant\'s Washington : an architect\'s view /');
INSERT INTO new_titles VALUES ('2000/10/10','M1473.B53 M6 199-','AKB-7112','','Berio/Maderna');
INSERT INTO new_titles VALUES ('2000/10/10','TC774 .B49 1915','AJX-7354','Bennett, Ira E. (Ira Elbert), 1868-1957.','History of the Panama Canal; its construction and builders,');
INSERT INTO new_titles VALUES ('2000/10/10','M1473.T93 R28 1998','AKB-7079','Tudor, David, 1926-','Rainforest--version I Sliding pitches in the rainforest in the field /');
INSERT INTO new_titles VALUES ('2000/10/10','SF259 .H8 1949','AIC-4190','Hunziker, Otto Frederick, b. 1873.','Condensed milk and milk powder,');
INSERT INTO new_titles VALUES ('2000/10/10','S16 .H8 G63','AFY-6613','Tudomnyos rtesto (Gdlloi Agrrtudomnyi Egyetem)','Tudomnyos rtesto.');
INSERT INTO new_titles VALUES ('2000/10/10','NA737.W7 C54x','AFT-3880','Burnham Library of Architecture.','Buildings by Frank Lloyd Wright : in six middle western states: Illinois, Indiana, Iowa, Michigan, Minnesota, Wisconsin.');
INSERT INTO new_titles VALUES ('2000/10/10','S16 .H8 G63','AFY-6612','','Az Agrrtudomnyi Egyetem tudomnyos rtestoje.');
INSERT INTO new_titles VALUES ('2000/10/10','S15 .P48','AFR-5650','Boletn tcnico (Peru. Direccin General de Investigacin Agraria)','Boletn tcnico /');
INSERT INTO new_titles VALUES ('2000/10/10','TA1 .E649','AFP-8008','Engineering Symposium (Brigham Young University)','Proceedings of the ... annual Engineering Symposium.');
INSERT INTO new_titles VALUES ('2000/10/10','QE1 .G84','AFQ-2156','Field trip guidebook (Gulf Coast Association of Geological Societies)','Field trip guidebook /');
INSERT INTO new_titles VALUES ('2000/10/10','S39 .A4','AFP-4588','California State Agricultural Society.','Transactions of the California State Agricultural Society.');
INSERT INTO new_titles VALUES ('2000/10/10','T55.4 .N67','ACQ-2296','','NCSU technical report');
INSERT INTO new_titles VALUES ('2000/10/10','QE173 .A2','AFP-4576','Bulletin (Virginia. Division of Mineral Resources)','Bulletin /');
INSERT INTO new_titles VALUES ('2000/10/10','TP368 .I383 1984','ACM-2081','','Ift 84 program & abstracts : 44th Annual IFT meeting : Anaheim, June 10-13, 1984.');
INSERT INTO new_titles VALUES ('2000/10/10','TP368 .I383 1985','ACM-1412','','Ift 85 program & abstracts : 45th Annual Ift meeting : Atlanta, June 9-12, 1985 /');
INSERT INTO new_titles VALUES ('2000/10/10','QR115 .P57 1985','ACF-1213','Pitt, John I.','Fungi and food spoilage /');
INSERT INTO new_titles VALUES ('2000/10/10','S55 .E18','ACE-8103','Bulletin (University of Illinois at Urbana-Champaign. Agricultural Experiment Station)','Bulletin /');
INSERT INTO new_titles VALUES ('2000/10/10','CT9410 .D5','ABX-9713','','Directory of statisticians in Japan');
INSERT INTO new_titles VALUES ('2000/10/10','QR115 .C66 1984','ACA-8803','','Compendium of methods for the microbiological examination of foods /');
INSERT INTO new_titles VALUES ('2000/10/10','QR115 .D54 1982','ABX-3674','DiLiello, Leo R.','Methods in food and dairy microbiology /');
INSERT INTO new_titles VALUES ('2000/10/10','S441 .N674','ABX-7377','','North central regional publication');
INSERT INTO new_titles VALUES ('2000/10/10','QR115 .B34 1981','ABU-8730','Banwart, George J.','Basic food microbiology /');
INSERT INTO new_titles VALUES ('2000/10/10','QR48 .F69','ABU-3993','Fox, J. Carl.','Sewage organisms : a color atlas /');
INSERT INTO new_titles VALUES ('2000/10/10','QP351 .J65','ABQ-8654','','The Journal of neuroscience');
INSERT INTO new_titles VALUES ('2000/10/10','SB21 .N7','ABT-0036','New York State Horticultural Society. Meeting.','Proceedings of the ... annual meeting /');
INSERT INTO new_titles VALUES ('2000/10/10','SB13 .N69','ABQ-2240','','Novedades horticolas');
INSERT INTO new_titles VALUES ('2000/10/10','SH159 .M38130 1979','ABQ-6785','Matsui, Isao, 1910-','Theory and practice of eel culture = Yomanho no riron to jissai /');
INSERT INTO new_titles VALUES ('2000/10/10','SF253 .M54 1959','ABO-5465','Milk Industry Foundation (U.S.)','Laboratory manual; methods of analysis of milk and its products.');
INSERT INTO new_titles VALUES ('2000/10/10','S401.U6 A11','ABO-2558','','Activities of FAO under the expanded technical assistance program');
INSERT INTO new_titles VALUES ('2000/10/10','SB354 .M52','ABM-3618','Bulletin (Missouri State Fruit Experiment Station, Mountain Grove)','Bulletin');
INSERT INTO new_titles VALUES ('2000/10/10','QR115 .F53','ABL-5521','Fields, Marion L.','Fundamentals of food microbiology /');
INSERT INTO new_titles VALUES ('2000/10/10','SH328 .N67 1977','ABL-3880','North Carolina Governor\'s Conference on Fishery Management under Extended Jurisdiction (1977 : Raleigh, N.C.).','Extended fishery jurisdiction : problems and progress, 1977 : proceedings of the North Carolina Governor\'s Conference on');
INSERT INTO new_titles VALUES ('2000/10/10','HD9052.U5 F42','ABL-2236','','Feedstuffs reference issue.');
INSERT INTO new_titles VALUES ('2000/10/10','QL664.H4 F55','ABL-2757','Fowler, Henry Weed, 1878-1965.','Fishes of Hawaii, Johnston Island, and Wake Island,');
INSERT INTO new_titles VALUES ('2000/10/10','S544.3.M4 M323','ABK-2120','Extension circular (Massachusetts Agricultural College. Extension Service)','Extension circular /');
INSERT INTO new_titles VALUES ('2000/10/10','QE147 .A2 vol. 2','ABI-7422','Smith, Hugh McCormick, 1865-1941.','The fishes of North Carolina,');
INSERT INTO new_titles VALUES ('2000/10/10','SF253 .W34','ABH-3869','Webb, Bryon Horton, 1903-','Fundamentals of dairy chemistry.');
INSERT INTO new_titles VALUES ('2000/10/10','SH380.62.U6 M2 1972','ABH-5266','McCoy, Edward G.','Dynamics of North Carolina commercial shrimp populations');
INSERT INTO new_titles VALUES ('2000/10/10','SF263 .H8 1940','ABH-3814','Hunziker, Otto Frederick, b. 1873.','The butter industry,');
INSERT INTO new_titles VALUES ('2000/10/10','QK1 .B214','ABD-7382','','Blyttia');
INSERT INTO new_titles VALUES ('2000/10/10','QP601 .E650','ABE-7562','','Enzymes : use and control in foods : 1976 IFT short course /');
INSERT INTO new_titles VALUES ('2000/10/10','QK1 .B21','ABD-7181','','Blumea.');
INSERT INTO new_titles VALUES ('2000/10/10','QP36 .M54 1977','ABD-4767','Memmler, Ruth Lundeen.','Structure and function of the human body /');
INSERT INTO new_titles VALUES ('2000/10/10','SF259 .B85','ABD-1941','Burke, A. D. (Arthur Devries), b. 1893.','Practical manufacture of cultured milks and kindred products; a complete and practical treatise on the manufacture of co');
INSERT INTO new_titles VALUES ('2000/10/10','Z731 .A53','ABD-0779','','American library directory');
INSERT INTO new_titles VALUES ('2000/10/10','QR71 .D50 1953','ABD-0109','Difco Laboratories.','Difco manual of dehydrated culture media and reagents for microbiological and clinical laboratory procedures.');
INSERT INTO new_titles VALUES ('2000/10/10','Z682.3 .A79','ABA-2575','Association of Research Libraries.','ARL annual salary survey');
INSERT INTO new_titles VALUES ('2000/10/10','SF257 .K6','ABB-3444','Klein, Louis A. (Louis Amos), 1871-','Principles and practice of milk hygiene,');
INSERT INTO new_titles VALUES ('2000/10/10','QD75 .Y6 1969','ABA-0863','Youden, W. J. (William John), 1900-1971.','Statistical techniques for collaborative tests /');
INSERT INTO new_titles VALUES ('2000/10/10','SF259 .I50','AAZ-8838','International Dairy Federation.','IDF monograph on UHT milk /');
INSERT INTO new_titles VALUES ('2000/10/10','QE39 .M46','AAZ-1888','','Meteor Forschungsergebnisse.');
INSERT INTO new_titles VALUES ('2000/10/10','R11 .P74','AAY-9677','','Postgraduate medicine.');
INSERT INTO new_titles VALUES ('2000/10/10','QE163 .A4','AAZ-0065','Report of investigations (South Dakota Geological Survey)','Report of investigations');
INSERT INTO new_titles VALUES ('2000/10/10','SD111.N3 N3','AAY-9335','Research note (New South Wales. Forestry Commission)','Research note /');
INSERT INTO new_titles VALUES ('2000/10/09','QC176.8.E4 E376 2000','ANX-2237','','Electronic structure and physical properties of solids : the uses of the LMTO method /');
INSERT INTO new_titles VALUES ('2000/10/09','TC405 .U5 no. 78 1998','ANX-0129','','Guidelines and manual on the protection and rehabilitation of contaminated rivers /');
INSERT INTO new_titles VALUES ('2000/10/09','GF13 .M39 2000','ANW-9773','McNeill, J. R.','Something new under the sun : an environmental history of the twentieth-century world /');
INSERT INTO new_titles VALUES ('2000/10/09','SF991 .N67 1997','ANW-9454','Norsworthy, Gary D.','Ask the vet : questions & answers for dog owners /');
INSERT INTO new_titles VALUES ('2000/10/09','PR3683 .S56 1986','ANW-6951','','Sheridan\'s 18th century England');
INSERT INTO new_titles VALUES ('2000/10/09','SF985 .N667 1997','ANW-8910','Norsworthy, Gary D.','Ask the vet : questions & answers for cat owners /');
INSERT INTO new_titles VALUES ('2000/10/09','HD8039.M61 U49 2000','ANW-6623','Rodda, Jeanette.','Go ye and study the beehive : the making of a western working class /');
INSERT INTO new_titles VALUES ('2000/10/09','BF323.S63 P69 1999','ANW-6602','Powers, Richard B.','An alien among us : a diversity game /');
INSERT INTO new_titles VALUES ('2000/10/09','SB375 .I58 1998','ANW-4630','International Pineapple Symposium (3rd : 1998 : Pattaya, Thailand)','Proceedings of the Third International Pineapple Symposium : Pattaya, Thailand, 17-20 November 1998 /');
INSERT INTO new_titles VALUES ('2000/10/09','SB398.2 .S96 1997','ANW-4626','Symposium international sur la physiologie de la vigne (5th : 1997 : Jerusalem, Israel)','Proceedings of the Fifth International Symposium on Grapevine Physiology : Jerusalem, Israel, 25-30 May 1997 /');
INSERT INTO new_titles VALUES ('2000/10/09','LC1201 .J26 2000','ANW-3140','Janney, Rachel.','Modifying schoolwork /');
INSERT INTO new_titles VALUES ('2000/10/09','BT82.2 .B39 1997b','ANS-3757','Bawer, Bruce, 1956-','Stealing Jesus : how fundamentalism betrays Christianity /');
INSERT INTO new_titles VALUES ('2000/10/09','NA1510.C6 A4 2000','ANR-8032','Correa, Charles, 1930-','Housing and urbanisation /');
INSERT INTO new_titles VALUES ('2000/10/09','QL691.I4 K39 2000','ANR-7991','Kazmierczak, Krys.','A field guide to the birds of the Indian subcontinent /');
INSERT INTO new_titles VALUES ('2000/10/09','HD1698.I4 W38 1999','ANR-2059','','Water and water resource management /');
INSERT INTO new_titles VALUES ('2000/10/09','RS201.E87 H36 2000','ANQ-7887','','Handbook of pharmaceutical excipients /');
INSERT INTO new_titles VALUES ('2000/10/09','ED 1.310/2:419309','ANQ-4600','','Comprehensive examination of barriers to employment among persons with who are blind or visually impaired');
INSERT INTO new_titles VALUES ('2000/10/09','DS12 .E53 1999','ANQ-3478','','Encyclopedia of Asian culture /');
INSERT INTO new_titles VALUES ('2000/10/09','NA963 .A73 1999','ANQ-2961','Archer, Lucy.','Architecture in Britain and Ireland, 600-1500 /');
INSERT INTO new_titles VALUES ('2000/10/09','PT2625.A44 Z763 1999','ANP-9973','Picart, Caroline Joan, 1966-','Thomas Mann and Friedrich Nietzsche : eroticism, death, music, and laughter /');
INSERT INTO new_titles VALUES ('2000/10/09','HV9104 .E448 1998','ANP-6704','Elliott, Delbert S.','Youth violence : children at risk : congressional seminar, June 17, 1997 /');
INSERT INTO new_titles VALUES ('2000/10/09','T690.B1 D38 1999','ANP-1406','Davis, John R., 1965-','The Great Exhibition /');
INSERT INTO new_titles VALUES ('2000/10/09','TP266.5 .F574 1998','ANM-0156','Fire Retardant Chemicals Association (U.S.). Fall Conference (1998 : Newport, R.I.)','Flame retardant polymerics -- electrical/electronic applications : papers presented at Double Tree Islander Hotel, Newpo');
INSERT INTO new_titles VALUES ('2000/10/09','TA480.T54 I55 1998','ANF-3284','International Symposium on Fatigue Behavior of Titanium Alloys (1998 : Chicago, Ill.)','Fatigue behavior of titanium alloys : proceedings of an international symposium : held at the TMS Fall Meeting\'98 in Chi');
INSERT INTO new_titles VALUES ('2000/10/09','[Microfiche] TD 2.72:','AMY-0062','','Corps connection FHWA/state/youth corps partnerships.');
INSERT INTO new_titles VALUES ('2000/10/09','BQ7940 .G7313 1999','ANE-0776','Grasdorff, Gilles van.','Hostage of Beijing : the abduction of the Panchen Lama /');
INSERT INTO new_titles VALUES ('2000/10/09','SB472.8 .U55 1996','AMX-0316','United States. Dept. of the Interior.','The Secretary of the Interior\'s standards for the treatment of historic properties with guidelines for the treatment of');
INSERT INTO new_titles VALUES ('2000/10/09','I 1.98:R 73/3/FINAL/V.1-2','AMW-9099','United States. Bureau of Land Management. Roswell Resource Area.','Proposed resource management plan, final environmental impact statement, for the Roswell Resource Area, Roswell, New Mex');
INSERT INTO new_titles VALUES ('2000/10/09','Y 3.F 76/3:1/','AMU-8354','United States. Foreign Claims Settlement Commission.','Semiannual report to the Congress - Foreign Claims Settlement Commission of the United States.');
INSERT INTO new_titles VALUES ('2000/10/09','[Microfiche] D 1.97:','AMU-5468','United States. Dept. of Defense.','Defense environmental cleanup program annual report to Congress for fiscal year ...');
INSERT INTO new_titles VALUES ('2000/10/09','[Microfiche] D 1.97:','AMP-8211','United States. Dept. of Defense.','Defense environmental restoration program annual report to Congress.');
INSERT INTO new_titles VALUES ('2000/10/09','[Microfiche] Y 3.N 21/29:16-1/','AMO-9504','National Civilian Community Corps (AmeriCorps)','Biennial report');
INSERT INTO new_titles VALUES ('2000/10/09','[Microfiche] TD 4.52:','AMI-6426','United States. Federal Aviation Administration.','FAA organizational directory');
INSERT INTO new_titles VALUES ('2000/10/09','[Microfiche] J 1.1/6:','AMF-9971','United States. Foreign Claims Settlement Commission.','Yearbook');
INSERT INTO new_titles VALUES ('2000/10/09','NMB 1.1:','AMF-6833','United States. National Mediation Board.','Annual report of the National Mediation Board.');
INSERT INTO new_titles VALUES ('2000/10/09','L 2.120/2:','ALT-0250','','News.');
INSERT INTO new_titles VALUES ('2000/10/09','Y 3.F 76/3:1/','AMF-6776','United States. Foreign Claims Settlement Commission.','Annual report to the Congress for the period ... /');
INSERT INTO new_titles VALUES ('2000/10/09','I 19.2:W 29/42/PT.1-2','ALQ-1791','Brice, James Coble, 1920-','Studies in Water Resources Division report writing : organization, introductions, and abstracts /');
INSERT INTO new_titles VALUES ('2000/10/09','A 13.78:PNW-RP-371-385','ALP-6061','','Louisiana\'s forest products industry : performance and contribution to the state\'s economy, 1970 to 1980 /');
INSERT INTO new_titles VALUES ('2000/10/09','I 19.2:M 66/9/v.1-3','ALO-9208','Rabbitt, Mary C.','Minerals, lands, and geology for the common defense and general welfare : a history of public lands, federal science and');
INSERT INTO new_titles VALUES ('2000/10/09','HC79.W4 K36 1999','ALN-1624','Kapstein, Ethan B.','Sharing the wealth : workers and the world economy /');
INSERT INTO new_titles VALUES ('2000/10/09','I 1.98:N 42 m/2/v.1-4/revised','ALM-2470','United States. Bureau of Land Management. New Mexico State Office.','New Mexico statewide wilderness study.');
INSERT INTO new_titles VALUES ('2000/10/09','J 1.1/6:','ALL-1644','United States. Foreign Claims Settlement Commission.','Annual report /');
INSERT INTO new_titles VALUES ('2000/10/09','I 1.98:Or 3/draft/v.1-4','ALI-7301','','Oregon wilderness : environmental impact statement /');
INSERT INTO new_titles VALUES ('2000/10/09','I 1.98:Oi 5/22/draft/v.1-2','ALJ-9962','','Proposed 5-year outer continental shelf oil and gas leasing program, January 1987-December 1991 : draft environmental im');
INSERT INTO new_titles VALUES ('2000/10/09','I 1.98:St 2 g/2/v.1-2/final','ALI-0867','','Proposed St. George Basin sale 89 : final environmental impact statement /');
INSERT INTO new_titles VALUES ('2000/10/09','I 1.98:Ut 1/2/final/v.1-4','ALD-2931','','Utah combined hydrocarbon leasing regional final EIS /');
INSERT INTO new_titles VALUES ('2000/10/09','I 1.98:P 69/draft/v.1-2','ALC-9839','','Resource management plan/environmental impact statement for the Platte River Resource Area, Casper, Wyoming /');
INSERT INTO new_titles VALUES ('2000/10/09','I 1.98:So 8/7/final/v.1-2','ALC-3786','','Proposed Southern California lease offering, April, 1984 : final environmental impact statement /');
INSERT INTO new_titles VALUES ('2000/10/09','I 1.98:Oi 5/21/final/v.1-2','ALA-6784','','Proposed 1983 Outer Continental Shelf oil and gas lease sale offshore central California : OCS sale no. 73 /');
INSERT INTO new_titles VALUES ('2000/10/09','I 1.98:Oi 5/4/979/v.1-4','AKX-0375','United States. Bureau of Land Management.','Final environmental statement : OCL sale no. 48 : proposed 1979 outer continental shelf oil and gas lease sale offshore');
INSERT INTO new_titles VALUES ('2000/10/09','I 1.98:Oi 5/2/979/v.1-2','AKV-5136','United States. New York Outer Continental Shelf Office.','Final environmental impact statement : proposed 1979 OCS oil and gas lease sale offshore the Mid-Atlantic States.');
INSERT INTO new_titles VALUES ('2000/10/09','I 1.98:M 66/2/v.1-2','AKS-2962','Geological Survey (U.S.)','Proposed plan of mining and reclamation, East Decker and North Extension mines, Decker Coal Company, Big Horn County, Mo');
INSERT INTO new_titles VALUES ('2000/10/09','I 19.13:2175/v.1-2','AKO-5590','','Measurement and computation of streamflow /');
INSERT INTO new_titles VALUES ('2000/10/09','I 1.98:Oi 5/6/982-86/v.1-2/supp.','AKK-8371','','Proposed five-year OCS oil and gas lease sale schedule, January 1982-December 1986 /');
INSERT INTO new_titles VALUES ('2000/10/09','QD450 .P45','AJX-5332','','Physical chemistry chemical physics.');
INSERT INTO new_titles VALUES ('2000/10/09','QD478 .S636','AKB-4685','','Solid state sciences.');
INSERT INTO new_titles VALUES ('2000/10/09','QR46 .M425 1999','AJW-8247','','Manual of clinical microbiology /');
INSERT INTO new_titles VALUES ('2000/10/09','QA76 .B24','AJV-4610','','BIT.');
INSERT INTO new_titles VALUES ('2000/10/09','AM231 .M28 1999','AJR-9061','Martin, Paul, 1959-','Popular collecting and the everyday self : the reinvention of museums? /');
INSERT INTO new_titles VALUES ('2000/10/09','F251 .S67','AJK-1976','','North Carolina archaeology.');
INSERT INTO new_titles VALUES ('2000/10/09','BF175.5.D74 T38 1998','AJP-6642','Taylor, Jeremy, 1943-','The living labyrinth : exploring universal themes in myths, dreams, and the symbolism of waking life /');
INSERT INTO new_titles VALUES ('2000/10/09','QD271 .J689','AJI-8137','','Journal of chromatography.');
INSERT INTO new_titles VALUES ('2000/10/09','HD62.5 .B764 1997','AIP-0407','Broussard, Cheryl D.','Sister CEO : the Black woman\'s guide to starting her own business /');
INSERT INTO new_titles VALUES ('2000/10/09','SF395.8.A1 P67 vol. 134 1995','AIG-9660','Glahn, James F.','Bird management at swine facilities /');
INSERT INTO new_titles VALUES ('2000/10/09','SF395.8.A1 P67 vol. 133 1995','AIG-9659','','Disposing of dead swine /');
INSERT INTO new_titles VALUES ('2000/10/09','Z683.2.U6 L53 1995','AID-0479','','Library fundraising : models for success /');
INSERT INTO new_titles VALUES ('2000/10/09','Q77 .T63','AID-0294','','Memoirs of Faculty of Engineering, Tokyo Metropolitan University.');
INSERT INTO new_titles VALUES ('2000/10/09','QD1 .F32','AIC-9204','','Faraday discussions.');
INSERT INTO new_titles VALUES ('2000/10/09','QD505 .C383','AHZ-6462','','Catalysis letters.');
INSERT INTO new_titles VALUES ('2000/10/09','LB1028.43 .S56','AIC-2952','','SIGCUE outlook.');
INSERT INTO new_titles VALUES ('2000/10/09','QD505 .J672','AHZ-1053','','Journal of molecular catalysis.');
INSERT INTO new_titles VALUES ('2000/10/09','Q77 .T6','AFV-8614','','Memoirs of the Metropolitan Technical College, Tokyo, Japan.');
INSERT INTO new_titles VALUES ('2000/10/09','SF395.8.A1 P67 vol. 131 1993','AFT-8966','Cole, John R., 1938-','Salmonella choleraesuis in pigs /');
INSERT INTO new_titles VALUES ('2000/10/09','QD241 .J68','AFS-1412','','Russian journal of organic chemistry.');
INSERT INTO new_titles VALUES ('2000/10/09','SF395.8.A1 P67 vol. 111 1992','AFT-1800','','Management and nutrition of the newly weaned pig /');
INSERT INTO new_titles VALUES ('2000/10/09','S83 .A3','AFR-2795','','Report of the Bureau of Agriculture Labor and Industry of the State of Montana.');
INSERT INTO new_titles VALUES ('2000/10/09','S15 .P47','AFS-0456','Publicao (Comisso de Combate s Pragas da Cana de Acar no Estado de Pernambuco)','Publicao.');
INSERT INTO new_titles VALUES ('2000/10/09','SF262 .M5','AFQ-2134','Milk Industry Foundation (U.S.)','Convention proceedings /');
INSERT INTO new_titles VALUES ('2000/10/09','SF521 .N38','ACR-1951','Nevada. State Apiary Commission.','Biennial report of the State Apiary Commission /');
INSERT INTO new_titles VALUES ('2000/10/09','QD505 .A661','ACQ-9772','','Applied catalysis.');
INSERT INTO new_titles VALUES ('2000/10/09','SF395.8.A1 P67 vol. 20 1991','ACR-1874','','Starting purchased feeder pigs /');
INSERT INTO new_titles VALUES ('2000/10/09','S15 .P45','ACQ-0175','Informe tcnico (Estacin Experimental Agropecuaria Pergamino : 1987)','Informe tcnico');
INSERT INTO new_titles VALUES ('2000/10/09','TS1300 .A516','ACG-7612','','America\'s textiles international.');
INSERT INTO new_titles VALUES ('2000/10/09','QL1 .S62','ACO-3024','','Belgian journal of zoology');
INSERT INTO new_titles VALUES ('2000/10/09','S55 .E18','ACE-8103','Bulletin (University of Illinois at Urbana-Champaign. Agricultural Experiment Station)','Bulletin /');
INSERT INTO new_titles VALUES ('2000/10/09','S211 .M44','ACF-5441','Memoria (Fondo Nacional de Investigaciones Agropecuarias (Venezuela))','Memoria /');
INSERT INTO new_titles VALUES ('2000/10/09','QH344 .G59','ACE-2070','','Global biogeochemical cycles');
INSERT INTO new_titles VALUES ('2000/10/09','S19 .N68','ACE-6146','','Samaru research bulletin');
INSERT INTO new_titles VALUES ('2000/10/09','SB921 .A28','ACC-5920','Biennial report (Commonwealth Scientific and Industrial Research Organization (Australia). Division of Entomology)','Biennial report /');
INSERT INTO new_titles VALUES ('2000/10/09','S303 .T84','ACC-2061','','Tokai Kinki Nogyo Shikenjo tokubetsu hokoku, Saibai Dai 1-bu = Special bulletin of the First Agronomy Division, Tokai-Ki');
INSERT INTO new_titles VALUES ('2000/10/09','S15 .P455','ACB-8567','Publicacin tcnica (Estacin Experimental Regional Agropecuaria Pergamino)','Publicacin tcnica');
INSERT INTO new_titles VALUES ('2000/10/09','HB31 .W3','ACA-3920','Bulletin (State College of Washington. Bureau of Economic and Business Research)','Bulletin');
INSERT INTO new_titles VALUES ('2000/10/09','S187 .E62','ACA-0378','Boletn (Estacin Experimental Agro-Industrial \"Obispo Colombres\")','Boletin /');
INSERT INTO new_titles VALUES ('2000/10/09','TA174 .D46a','ABX-4810','ACM IEEE Design Automation Conference.','Proceedings /');
INSERT INTO new_titles VALUES ('2000/10/09','QA273.A1 P76','ABW-2163','Probability and mathematical statistics (Instytut Matematyczny (Polska Akademia Nauk))','Probability and mathematical statistics');
INSERT INTO new_titles VALUES ('2000/10/09','HF5410 .M39','ABU-8744','Marketing science (Providence, R.I.)','Marketing science.');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.2:AIMD-00-111 R','ANX-1800','','FEDERALLY CHARTERED CORPORATION: REVIEW OF THE FINANCIAL STATEMENT AUDIT REPORT FOR THE CATHOLIC WAR VETERANS FOR FY 19');
INSERT INTO new_titles VALUES ('2000/10/05','GA 1.2:AIMD-00-110 R','ANX-1799','','FEDERALLY CHARTERED CORPORATION: REVIEW OF THE FINANCIAL STATEMENT AUDIT REPORT FOR THE BOY SCOUTS OF AMERICA FOR FY 19');
INSERT INTO new_titles VALUES ('2000/10/05','T 70.2:AL 1/7','ANX-1794','','Alcohol & tobacco newsletter.');
INSERT INTO new_titles VALUES ('2000/10/05','L 29.2:2000/4','ANX-1790','United States and European Union Seminar on the Social Dimension of Economic Integration (1999 : Washington, D.C.)','Summary of the United States and European Union Seminar on the Social Dimension of Economic Integration');
INSERT INTO new_titles VALUES ('2000/10/05','TD 4.32/26:8740-52','ANX-1787','','The silent emergency (pneumatic system malfunction)');
INSERT INTO new_titles VALUES ('2000/10/05','FEM 1.209/40:450130/ETC./2000/V.1-','ANW-8459','','Flood insurance study Lexington County, South Carolina and incorporated areas.');
INSERT INTO new_titles VALUES ('2000/10/05','NA6343.C3 R43 1999','ANW-6509','','Recycling city space [videorecording]');
INSERT INTO new_titles VALUES ('2000/10/05','HV5292 .A3853 1998','ANW-3676','','Alcohol use/abuse among Latinos : issues and examples of culturally competent services /');
INSERT INTO new_titles VALUES ('2000/10/05','Y 4.G 74/7-10:','ANS-2209','United States. Congress. House. Committee on Government Reform.','Rules of the Committee on Government Reform, House of Representatives, together with selected rules of the House of Repr');
INSERT INTO new_titles VALUES ('2000/10/05','PN1997 .S6335','ANS-1652','Sontag, Susan, 1933-','Duet for cannibals; a screenplay.');
INSERT INTO new_titles VALUES ('2000/10/05','Y 4.AP 6/1:IN 8/6/2001/PT.1-','ANR-9770','United States. Congress. House. Committee on Appropriations. Subcommittee on Dept. of the Interior and Related Agencies.','Department of the Interior and related agencies appropriations for 2001 : hearings before a subcommittee of the Committe');
INSERT INTO new_titles VALUES ('2000/10/05','TJ211 .Z53 1997','ANR-3650','Zhang, Yanwei.','Design, simulation, fabrication and testing of microprobes for a new MEMS wafer probe card /');
INSERT INTO new_titles VALUES ('2000/10/05','LT4410.S36 F62 1998 te','ANR-0553','','Focus on algebra : an integrated approach /');
INSERT INTO new_titles VALUES ('2000/10/05','Y 4.AP 6/2:S.HRG.106-410','ANQ-8490','United States. Congress. Senate. Committee on Appropriations. Subcommittee on Departments of Labor, Health and Human Services, Education, and Related Agencies.','Funding AIDS research and services : hearing before a subcommittee of the Committee on Appropriations, United States Sen');
INSERT INTO new_titles VALUES ('2000/10/05','Y 4.R 86/1:EX 3','ANQ-7075','United States. Congress. House. Committee on Rules. Subcommittee on Legislative and Budget Process.','Executive orders : hearing before the Subcommittee on Legislative and Budget Process of the Committee on Rules, House of');
INSERT INTO new_titles VALUES ('2000/10/05','Y 4.AP 6/2:S.HRG.106-412','ANQ-6979','United States. Congress. Senate. Committee on Appropriations. Subcommittee on Departments of Labor, Health and Human Services, Education, and Related Agencies.','Donated organ allocation policy : hearing before a subcommittee of the Committee on Appropriations, United States Senate');
INSERT INTO new_titles VALUES ('2000/10/05','Y 4.AP 6/2:S.HRG.106-409','ANQ-6367','United States. Congress. Senate. Committee on Appropriations. Subcommittee on Departments of Labor, Health and Human Services, Education, and Related Agencies.','Federally funded native Hawaiian programs : hearing before a subcommittee of the Committee on Appropriations, United Sta');
INSERT INTO new_titles VALUES ('2000/10/05','Y 4.AP 6/1:L 52/2001/PT.1-','ANP-1607','United States. Congress. House. Committee on Appropriations. Subcommittee on Legislative.','Legislative branch appropriations for 2001 : hearings before a subcommittee of the Committee on Appropriations, House of');
INSERT INTO new_titles VALUES ('2000/10/05','FEM 1.209/40:450043','ANP-0560','','Flood insurance study town of Ravenel, South Carolina, Charleston County.');
INSERT INTO new_titles VALUES ('2000/10/05','FEM 1.209/40:450037','ANP-0559','','Flood insurance study town of Hollywood, South Carolina, Charleston County.');
INSERT INTO new_titles VALUES ('2000/10/05','FEM 1.209/33:370317','ANP-0558','','Flood insurance study town of Leggett, North Carolina, Edgecombe County.');
INSERT INTO new_titles VALUES ('2000/10/05','VA 1.55:','ANB-0688','United States. Dept. of Veterans Affairs. Office of Inspector General.','Semiannual report to the Congress /');
INSERT INTO new_titles VALUES ('2000/10/05','E 3.29:','ANA-6224','','Inventory of electric utility power plants in the United States.');
INSERT INTO new_titles VALUES ('2000/10/05','[Microfiche] A 68.1/3:','AMS-5275','','Statistical report.');
INSERT INTO new_titles VALUES ('2000/10/05','[Microfiche] A 68.1/3:','AME-6885','','Statistical report.');
INSERT INTO new_titles VALUES ('2000/10/05','A 110.11/2:','ALK-5824','United States. Food Safety and Inspection Service.','Meat and poultry inspection : report of the Secretary of Agriculture to the U.S. Congress.');
INSERT INTO new_titles VALUES ('2000/10/05','TH4965 .A44 1890','ALE-9277','American Steel & Wire Co.','American fences.');
INSERT INTO new_titles VALUES ('2000/10/05','TH1501 .A85 1915','ALE-9270','Atlas Portland Cement Company.','Reinforced concrete in factory construction.');
INSERT INTO new_titles VALUES ('2000/10/05','SB599 .R68','AKN-3983','','Annals of agricultural sciences.');
INSERT INTO new_titles VALUES ('2000/10/05','C 55.416/13:CD-12/','AKM-8007','United States. National Ocean Service.','World aeronautical chart.');
INSERT INTO new_titles VALUES ('2000/10/05','C 55.416/13:CG-20/','AKM-8006','United States. National Ocean Service.','World aeronautical chart.');
INSERT INTO new_titles VALUES ('2000/10/05','C 55.416/13:CG-18/','AKM-8003','United States. National Ocean Service.','World aeronautical chart.');
INSERT INTO new_titles VALUES ('2000/10/05','S542.G72 A377a','AJQ-9909','','IGER innovations.');
INSERT INTO new_titles VALUES ('2000/10/05','ML49.P8 B87 2000','AKB-1780','Purcell, Henry, 1659-1695.','Henry Purcell\'s operas : the complete texts /');
INSERT INTO new_titles VALUES ('2000/10/05','QK1 .Z8','AJQ-5278','','Bulletin of the Geobotanical Institute ETH.');
INSERT INTO new_titles VALUES ('2000/10/05','[Business Alcove] HG8943 .B3','AJP-6987','','Best\'s insurance reports.');
INSERT INTO new_titles VALUES ('2000/10/05','TA160.4 .R47','AJP-9318','Research projects (North Carolina State University. College of Engineering)','Research projects /');
INSERT INTO new_titles VALUES ('2000/10/05','S540.A2 I57','AJP-5055','Institute of Arable Crops Research (Great Britain)','IACR report for ... /');
INSERT INTO new_titles VALUES ('2000/10/05','SD1 .F69','AJJ-9527','','T`ai-wan lin yeh k`o hseh.');
INSERT INTO new_titles VALUES ('2000/10/05','[Reference Desk] Z674.82.O15 O13a','AIK-2456','OCLC.','OCLC participating institutions.');
INSERT INTO new_titles VALUES ('2000/10/05','BD236 .O27 1993','AIR-1789','Oderberg, David S.','The metaphysics of identity over time /');
INSERT INTO new_titles VALUES ('2000/10/05','BS491.2 .N484 1994','AID-9928','','The New Interpreter\'s Bible : general articles & introduction, commentary, & reflections for each book of the Bible, inc');
INSERT INTO new_titles VALUES ('2000/10/05','SD356.54.S7 I58','ACR-7763','','Investigacin agraria.');
INSERT INTO new_titles VALUES ('2000/10/05','QL681 .B62 1992','AGB-5181','','The Birds of North America : life histories for the 21st century /');
INSERT INTO new_titles VALUES ('2000/10/05','SB273.A2 L35','ACQ-1983','Ttigkeitsbericht (Landesanstalt fr Pflanzenbau Forchheim)','Ttigkeitsbericht');
INSERT INTO new_titles VALUES ('2000/10/05','SF604 .R47','ACQ-1941','','Brazilian journal of veterinary research and animal science /');
INSERT INTO new_titles VALUES ('2000/10/05','SF199.S6 A45','ACN-2135','','Sire summary');
INSERT INTO new_titles VALUES ('2000/10/05','S15 .L28','ACA-9062','Revista de la Facultad de Agronoma (La Plata, Argentina)','Revista de la Facultad de Agronoma');
INSERT INTO new_titles VALUES ('2000/10/05','HG41 .Q33','ABZ-7384','','Financial statistics of Japan');
INSERT INTO new_titles VALUES ('2000/10/05','SF995 .W43','ABZ-2785','Western Poultry Disease Conference.','Proceedings of the ... Western Poultry Disease Conference');
INSERT INTO new_titles VALUES ('2000/10/05','Z253.5 .P840','ABX-1333','','Publication design annual');
INSERT INTO new_titles VALUES ('2000/10/05','PN761 .N56','ABT-9762','','Nineteenth-century literature criticism');
INSERT INTO new_titles VALUES ('2000/10/05','QH71.C75 A1','ABR-8972','Annual report (Colorado Museum of Natural History)','Annual report /');
INSERT INTO new_titles VALUES ('2000/10/05','HT405.F3 A45','ABR-5887','Farm Foundation (Chicago, Ill.)','Annual report.');
INSERT INTO new_titles VALUES ('2000/10/05','QE1 .B6437','ABO-8964','','Brigham Young University geology studies');
INSERT INTO new_titles VALUES ('2000/10/05','HD28 .P36','ABP-9622','Paper (Krannert Graduate School of Management. Institute for Research in the Behavioral, Economic, and Management Sciences)','Paper');
INSERT INTO new_titles VALUES ('2000/10/05','[Law Alcove] KFN7430 1961 .A24','ABO-4285','North Carolina.','Advance legislative service to the General statutes of North Carolina');
INSERT INTO new_titles VALUES ('2000/10/05','LB1771 .R48','ABM-3625','','Requirements for certification');
INSERT INTO new_titles VALUES ('2000/10/05','QL1 .D7','ABL-8583','','Faunistische Abhandlungen /');
INSERT INTO new_titles VALUES ('2000/10/05','PN771 .G27','ABK-9757','Gale Research Company.','Twentieth-century literary criticism');
INSERT INTO new_titles VALUES ('2000/10/05','S278.F6 T26','ABD-9078','','Chung-hua nung yeh yen chiu');
INSERT INTO new_titles VALUES ('2000/10/05','T178 .I4','ABH-7610','','Summary of engineering research');
INSERT INTO new_titles VALUES ('2000/10/05','HD9130.3 .T55','ABB-6165','','World tobacco directory');
INSERT INTO new_titles VALUES ('2000/10/05','PN451 .S6','AAZ-0051','','Something about the author');
INSERT INTO new_titles VALUES ('2000/10/05','S19 .U83','AAX-7244','','Utsunomiya Daigaku Nogakubu gakujutsu hokoku');
INSERT INTO new_titles VALUES ('2000/10/05','S583 .D69','AAX-3376','Down to earth (Midland, Mich.)','Down to earth.');
INSERT INTO new_titles VALUES ('2000/10/05','PN771 .C583','AAX-3180','','Contemporary authors');
INSERT INTO new_titles VALUES ('2000/10/05','QH1 .C28','AAX-1889','','Caldasia');
INSERT INTO new_titles VALUES ('2000/10/05','Q11 .C7','AAX-3081','','The Journal of the Colorado-Wyoming Academy of Science');
INSERT INTO new_titles VALUES ('2000/10/09','SB921 .A28','ABT-8161','','Division of Entomology annual report');
INSERT INTO new_titles VALUES ('2000/10/09','QD410 .O733','ABS-6456','','Organometallics.');
INSERT INTO new_titles VALUES ('2000/10/09','QD1 .C57','ABS-0154','','Annual reports on the progress of chemistry.');
INSERT INTO new_titles VALUES ('2000/10/09','RC467 .P776','ABP-7842','','Psycscan.');
INSERT INTO new_titles VALUES ('2000/10/09','TS1525 .I5','ABP-9191','','International textile machinery : ITM');
INSERT INTO new_titles VALUES ('2000/10/09','TS1828 .D53','ABO-9103','','Disposables and nonwovens');
INSERT INTO new_titles VALUES ('2000/10/09','RA421 .R6','ABN-7931','Rockefeller Foundation. International Health Division.','Annual report /');
INSERT INTO new_titles VALUES ('2000/10/09','SH11 .F64','ABM-7332','','Summary of Florida commercial marine landings');
INSERT INTO new_titles VALUES ('2000/10/09','HG1 .J683','ABM-2340','','The Journal of financial research');
INSERT INTO new_titles VALUES ('2000/10/09','SF601 .V523','ABM-3303','','The Veterinary clinics of North America.');
INSERT INTO new_titles VALUES ('2000/10/09','Q1 .N38','ABL-8683','','Transactions of the Nebraska Academy of Sciences and affiliated societies');
INSERT INTO new_titles VALUES ('2000/10/09','HD9688.U53 N62','ABL-4203','North Carolina. Rural Electrification Authority.','Annual progress report of rural electrification in North Carolina');
INSERT INTO new_titles VALUES ('2000/10/09','QH301 .L54','ABL-2287','','Journal of natural products.');
INSERT INTO new_titles VALUES ('2000/10/09','T14 .H57','ABF-0942','','History of technology');
INSERT INTO new_titles VALUES ('2000/10/09','QE1 .G392','ABI-7272','','Proceedings volume of the Geological Society of America for ...');
INSERT INTO new_titles VALUES ('2000/10/09','PR1 .O42','ABD-0100','','Old English newsletter');
INSERT INTO new_titles VALUES ('2000/10/09','Q69 .A530','ABF-0289','','Analele Universitatii Bucuresti.');
INSERT INTO new_titles VALUES ('2000/10/06','C 13.58:6359','AMQ-6647','Linteris, Gregory T.','Flame inhibition by ferrocene, carbon dioxide, and trifluoromethane blends synergistic and antagonistic effects /');
INSERT INTO new_titles VALUES ('2000/10/06','C 55.13/2:ERL GLERL-114','AMQ-6646','Reid, David F.','Proceedings of the workshop, the environmental implications of cargo sweeping in the Great Lakes');
INSERT INTO new_titles VALUES ('2000/10/06','C 55.13/2:ERL AOML-94','AMQ-6645','Palmer, David R.','Parabolic approximations for global acoustic propagation modeling');
INSERT INTO new_titles VALUES ('2000/10/06','FEM 1.2:L 89/SUM.','AMQ-5630','','Loss-reduction provisions of a federal earthquake insurance program final report summary /');
INSERT INTO new_titles VALUES ('2000/10/06','FEM 1.2:L 89/FINAL','AMQ-5629','','Loss-reduction provisions of a federal earthquake insurance program final report /');
INSERT INTO new_titles VALUES ('2000/10/06','D 101.11:9-2815-237-34','ALR-6252','','Direct support and general support, maintenance : engine, diesel, 8 cylinder, naturally aspirated, fuel-injected, water');
INSERT INTO new_titles VALUES ('2000/10/06','A 88.6/4:M 34/999','AMQ-5600','','Fruit and vegetable market news users guide');
INSERT INTO new_titles VALUES ('2000/10/06','L 36.401:','ALR-5316','United States. Employment Standards Administration. Office of Workers\' Compensation Programs.','OWCP annual report to Congress');
INSERT INTO new_titles VALUES ('2000/10/06','HD4904.25 .S87 1999','ALN-1618','Strober, Myra H.','The road winds uphill all the way : gender, work, and family in the United States and Japan /');
INSERT INTO new_titles VALUES ('2000/10/06','HD4901 .O93 1999','ALN-1599','','The Oxford book of work /');
INSERT INTO new_titles VALUES ('2000/10/06','[Microfiche] A 13.52/12:','AKE-0180','','Forest insect and disease conditions.');
INSERT INTO new_titles VALUES ('2000/10/06','PQ7081.A1 T47','ABD-0080','','Texto crtico');
INSERT INTO new_titles VALUES ('2000/10/06','TN1 .S67','AFU-7342','','The South east miner.');
INSERT INTO new_titles VALUES ('2000/10/07','','AOE-1763','Browder, Anthony T.','Historical Accomplishments of Kemet (Ch.3) [Part 2 of 2]');
INSERT INTO new_titles VALUES ('2000/10/07','','AOE-1761','Browder, Anthony T.','Historical Accomplishmetns of Kemet (Ch.3) [Part 1 of 2]');
INSERT INTO new_titles VALUES ('2000/10/07','','AOE-1759','Ohaegbulam, Festus Ugboaja','Black Experience (Ch.2)');
INSERT INTO new_titles VALUES ('2000/10/07','Course Shelf','AOE-1757','','Readings for FCTL2000 Clayton. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/07','','AOE-1755','Bourne, Randolph','War and the Intellectuals');
INSERT INTO new_titles VALUES ('2000/10/07','','AOE-1745','Jackson, Lisa Ann','Rhetoric of Design: Implications for Corporate Intranets');
INSERT INTO new_titles VALUES ('2000/10/07','','AOE-1743','Allen, Nancy J.','Ethics and Visual Rhetorics: Seeing\'s Not Believing Anymore');
INSERT INTO new_titles VALUES ('2000/10/07','Course Shelf','AOE-1740','Lincoln, C.Eric.','Avenue, Clayton City. 1996.');
INSERT INTO new_titles VALUES ('2000/10/07','Course Shelf','AOE-1732','Martin, James Kirby et al','America and its peoples: a mosaic in the making.Vol.1-to 1877. 3d ed. 1997.');
INSERT INTO new_titles VALUES ('2000/10/07','Course Shelf','AOE-1730','Friedan, Betty','Feminine mystique. 1974.');
INSERT INTO new_titles VALUES ('2000/10/07','NA673 .A12','ANY-8175','2G (Barcelona, Spain)','2G.');
INSERT INTO new_titles VALUES ('2000/10/07','F1545.3.J48 J33 1998','ANY-7393','','Jade in ancient Costa Rica /');
INSERT INTO new_titles VALUES ('2000/10/07','GT615 .M38 1998','ANY-7391','Martin, Richard (Richard Harrison)','American ingenuity : sportswear, 1930s-1970s /');
INSERT INTO new_titles VALUES ('2000/10/07','TK5103.2 .S65237 2000','ANY-7360','Smith, Clint.','LMDS /');
INSERT INTO new_titles VALUES ('2000/10/07','BF173.J85 K577 2000','ANY-7358','Kirsch, Thomas.','The Jungians : a comparative and historical perspective /');
INSERT INTO new_titles VALUES ('2000/10/07','LC245.G7 M67 2000','ANY-7344','Morris, Paul, 1952 June 20-','A practical guide to fund-raising in schools /');
INSERT INTO new_titles VALUES ('2000/10/07','D804.18 .H57 2000','ANY-7336','','History, religion, and meaning : American reflections on the Holocaust and Israel /');
INSERT INTO new_titles VALUES ('2000/10/07','TA660.T34 A83 2000','ANY-7328','Carter, Will J.','ASME Section VIII Div. 1 pressure vessels /');
INSERT INTO new_titles VALUES ('2000/10/07','Course Shelf','ANW-7175','DuBois, W.E.B.','Souls of black folks. c1997');
INSERT INTO new_titles VALUES ('2000/10/07','QE701 .H55','AIP-4387','','Historical biology.');
INSERT INTO new_titles VALUES ('2000/10/07','LB1028.5 .N15','ACD-0717','','Performance & instruction');
INSERT INTO new_titles VALUES ('2000/10/07','LD3921 Physiol. L38','ABY-9864','Laverty, Jeanne Grim, 1958-','Mastitis-reproduction interrelationships /');
INSERT INTO new_titles VALUES ('2000/10/07','PQ2637.I53 Z46913 1984','ABY-5914','Simenon, Georges, 1903-','Intimate memoirs : including Marie-Jo\'s book /');
INSERT INTO new_titles VALUES ('2000/10/07','QE841 .K45 1982','ABV-5425','Kemp, T. S. (Thomas Stainforth)','Mammal-like reptiles and the origin of mammals /');
INSERT INTO new_titles VALUES ('2000/10/07','PN710 .J3 1981','ABT-7788','James, Henry, 1843-1916.','Selected literary criticism /');
INSERT INTO new_titles VALUES ('2000/10/07','HB151 .B23','ABQ-5008','Barbon, Nicholas, d. 1698.','Nicholas Barbon on A discourse of trade. 1690.');
INSERT INTO new_titles VALUES ('2000/10/07','TJ213.7 .F73','ABP-4547','','Frequency-response methods in control systems /');
INSERT INTO new_titles VALUES ('2000/10/07','[Law Alcove] KFN7430 1961 .A24','ABO-4285','North Carolina.','Advance legislative service to the General statutes of North Carolina');
INSERT INTO new_titles VALUES ('2000/10/07','QE169 .A33','ABO-4229','Circular (Utah Geological and Mineralogical Survey)','Circular');
INSERT INTO new_titles VALUES ('2000/10/07','QE169 .A3 no. 46','ABL-0344','Stokes, William Lee, 1915-','Uranium-vanadium deposits of the Thompsons area, Grand County, Utah, with emphasis on the origin of carnotite ores.');
INSERT INTO new_titles VALUES ('2000/10/07','TA157 .N4','ABJ-2116','','Professional engineer income and salary survey');
INSERT INTO new_titles VALUES ('2000/10/07','F119 .E447','ABK-3967','Ellis, David Maldwyn.','New York, state and city /');
INSERT INTO new_titles VALUES ('2000/10/07','DF229.T5 C7 1951','ABG-9160','Thucydides.','The complete writings of Thucydides: The Peloponnesian War.');
INSERT INTO new_titles VALUES ('2000/10/07','JK6 .F45','ABE-2868','','Federal yellow book');
INSERT INTO new_titles VALUES ('2000/10/07','DK753 .M3913','ABF-4174','Max, Alfred.','The Siberian challenge /');
INSERT INTO new_titles VALUES ('2000/10/07','QK603 .P54','ABD-6569','Pilat, Albert, 1903-','Mushrooms,');
INSERT INTO new_titles VALUES ('2000/10/07','PL2357 .D6 1976b','ABD-5681','Dolby, A. W. E.','A history of Chinese drama /');
INSERT INTO new_titles VALUES ('2000/10/07','QH197 .A78','ABD-1597','','Australian journal of ecology.');
INSERT INTO new_titles VALUES ('2000/10/07','QA154.2 .B37 manual','ABC-1330','Barnett, Raymond A.','Instructor\'s manual to accompany College algebra with trigonometry /');
INSERT INTO new_titles VALUES ('2000/10/07','D111 .I58','AAZ-1358','','International medieval bibliography');
INSERT INTO new_titles VALUES ('2000/10/07','E195 .S556','ABB-5426','Wood, George Arthur, 1878-','William Shirley, governor of Massachusetts, 1741-1756; a history by George Arthur Wood.');
INSERT INTO new_titles VALUES ('2000/10/07','QH301 .J65','AAZ-1334','','Journal of natural history.');
INSERT INTO new_titles VALUES ('2000/10/07','QD501 .J68','AAZ-1273','','Journal of catalysis.');
INSERT INTO new_titles VALUES ('2000/10/07','QD411 .J69','AAZ-1309','','Journal of organometallic chemistry');
INSERT INTO new_titles VALUES ('2000/10/07','QH301 .H8','AAY-0676','','Hydrobiologia');
INSERT INTO new_titles VALUES ('2000/10/07','Z1035.A1 B55','AAX-0438','','Book review index');
INSERT INTO new_titles VALUES ('2000/10/07','GV1601 .K5','AAU-7635','Kinney, Troy, 1871-1938.','The dance; its place in art and life,');
INSERT INTO new_titles VALUES ('2000/10/07','PL2384 .S5','AAW-9539','Shih, Chung-wen, 1922-','The golden age of Chinese drama, Yan tsa-ch /');
INSERT INTO new_titles VALUES ('2000/10/07','[Reference desk] JS342.A2 I5','AAU-0355','','The Municipal year book');
INSERT INTO new_titles VALUES ('2000/10/07','F5 .T34','AAU-3051','Taft, Lewis A.','Profile of old New England; Yankee legends, tales, and folklore,');
INSERT INTO new_titles VALUES ('2000/10/07','QC173 .J65','AAT-0101','','Journal of molecular structure.');
INSERT INTO new_titles VALUES ('2000/10/07','HD6483 .R65','AAS-4513','Rose, Arnold Marshall, 1918-1968.','Union solidarity; the internal cohesion of a labor union.');
INSERT INTO new_titles VALUES ('2000/10/07','BF311 .H42','AAP-5768','Heisel, Dorelle.','The kairos dimension.');
INSERT INTO new_titles VALUES ('2000/10/07','QH324 .A548','AAL-7770','Biological Sciences Curriculum Study.','Biological science: interaction of experiments and ideas.');
INSERT INTO new_titles VALUES ('2000/10/07','TP451.E3 P55','AAN-7347','Pintauro, Nicholas, 1918-','Edible coatings and soluble packaging');
INSERT INTO new_titles VALUES ('2000/10/07','HE151 .N35','AAL-5512','National Research Council (U.S.). Highway Research Board.','Statewide transportation planning--needs and requirements.');
INSERT INTO new_titles VALUES ('2000/10/07','QK617 .T6813','AAL-4187','Tosco, Uberto.','Mushrooms & toadstools: how to find and identify them');
INSERT INTO new_titles VALUES ('2000/10/07','QL706 .B96','AAL-3570','Burns, Eugene.','The sex life of wild animals; a North American study.');
INSERT INTO new_titles VALUES ('2000/10/07','QK617 .C47','AAK-0635','Christensen, Clyde Martin, 1905-','Common edible mushrooms,');
INSERT INTO new_titles VALUES ('2000/10/07','TK451 .M3','AAJ-0495','Martin, Thomas Commerford, 1856-1924.','Forty years of Edison service, 1882-1922; outlining the growth and development of the Edison system in New York City.');
INSERT INTO new_titles VALUES ('2000/10/07','PZ3.M3184 Ro7','AAG-6660','Mann, Thomas, 1875-1955.','Royal highness;');
INSERT INTO new_titles VALUES ('2000/10/07','QA95 .G32','AAE-6376','Gardner, Martin, 1914-','Sixth book of mathematical games from Scientific American.');
INSERT INTO new_titles VALUES ('2000/10/07','RM315 .I6','AAC-7941','','An Introduction to psychopharmacology.');
INSERT INTO new_titles VALUES ('2000/10/08','QE147 .A27','AAY-3684','Bulletin (North Carolina. Geological Survey)','Bulletin /');
INSERT INTO new_titles VALUES ('2000/10/08','TJ981 .C7','AAX-3128','','Compressed air');
INSERT INTO new_titles VALUES ('2000/10/08','QP355 .C27','AAK-3789','Campbell, Herbert James.','Correlative physiology of the nervous system');
INSERT INTO new_titles VALUES ('2000/10/09','Q22 .A343','ABB-2183','','Acta cientfica venezolana');
INSERT INTO new_titles VALUES ('2000/10/09','QA276.A1 C66','ABC-6241','','Communications in statistics:');
INSERT INTO new_titles VALUES ('2000/10/09','QD549 .J6','AAZ-1961','','Journal of colloid and interface science.');
INSERT INTO new_titles VALUES ('2000/10/09','QH91.A1 J65','AAZ-1337','','Journal of experimental marine biology and ecology');
INSERT INTO new_titles VALUES ('2000/10/09','S322.F6 J6','AAZ-1250','','Plant industry series');
INSERT INTO new_titles VALUES ('2000/10/09','SB921 .A28','AAZ-0989','Annual report (Commonwealth Scientific and Industrial Research Organization (Australia). Division of Entomology)','Annual report');
INSERT INTO new_titles VALUES ('2000/10/09','TX341 .Z355','AAZ-0493','','Zeitschrift fr Ernhrungswissenschaft.');
INSERT INTO new_titles VALUES ('2000/10/09','[Business Alcove] T12 .T6','AAZ-0227','','Thomas register of American manufacturers and Thomas register catalog file.');
INSERT INTO new_titles VALUES ('2000/10/09','RD701 .O793','AAY-9494','','The Orthopedic clinics of North America');
INSERT INTO new_titles VALUES ('2000/10/09','QL700 .S39','AAY-9913','','Sugetierkundliche Mitteilungen');
INSERT INTO new_titles VALUES ('2000/10/09','HD5701 .U65','AAY-9123','','Methods for manpower analysis');
INSERT INTO new_titles VALUES ('2000/10/09','QC851 .J63','AAY-8931','','Journal of the atmospheric sciences');
INSERT INTO new_titles VALUES ('2000/10/09','QE701 .J6','AAY-8900','','Journal of paleontology');
INSERT INTO new_titles VALUES ('2000/10/09','TA710 .G45','AAY-8379','','Gotechnique.');
INSERT INTO new_titles VALUES ('2000/10/09','QH301 .D48','AAY-6343','','Developmental biology');
INSERT INTO new_titles VALUES ('2000/10/09','QH301 .L3','AAY-6156','Life sciences (Oxford, England)','Life sciences.');
INSERT INTO new_titles VALUES ('2000/10/09','QH324 .M27','AAY-3657','','Mathematical biosciences.');
INSERT INTO new_titles VALUES ('2000/10/09','SB251.P13 P43','AAY-4710','','The Pakistan cottons');
INSERT INTO new_titles VALUES ('2000/10/09','Q1 .S25','AAY-0699','Science (Washington, D.C. : Weekly)','Science.');
INSERT INTO new_titles VALUES ('2000/10/09','[Reference desk (side counter)] Z1215 .P972','AAY-0358','','Books in print');
INSERT INTO new_titles VALUES ('2000/10/09','QE1 .J8','AAX-7588','','The Journal of geology');
INSERT INTO new_titles VALUES ('2000/10/09','QD262 .S95','AAX-5972','','Synthetic communications');
INSERT INTO new_titles VALUES ('2000/10/09','BF11 .A67','AAX-5990','American Psychological Association.','Directory');
INSERT INTO new_titles VALUES ('2000/10/09','QE500 .G4','AAX-3903','','Geophysics');
INSERT INTO new_titles VALUES ('2000/10/09','QE1 .G38','AAX-3897','','Geological Society of America bulletin.');
INSERT INTO new_titles VALUES ('2000/10/09','QD516 .C72','AAX-3089','','Combustion science and technology');
INSERT INTO new_titles VALUES ('2000/10/09','TP1 .C67','AAX-2072','','Chemical engineering science.');
INSERT INTO new_titles VALUES ('2000/10/09','QD1 .C41','AAX-2076','','Chemical reviews.');
INSERT INTO new_titles VALUES ('2000/10/09','QD471 .B6','AAX-0411','','Biopolymers');
INSERT INTO new_titles VALUES ('2000/10/09','TA1001 .T684','AAV-1870','','Transportation research circular');
INSERT INTO new_titles VALUES ('2000/10/09','S45 .E24','AAV-9350','Bulletin (University of Delaware. Agricultural Experiment Station)','Bulletin /');
INSERT INTO new_titles VALUES ('2000/10/09','SB824.C2 A16','AAU-5521','','Forest pest conditions in California : Official report of the California Forest Pest Control Action Council');
INSERT INTO new_titles VALUES ('2000/10/09','E195 .P43','AAT-3842','Peckham, Howard Henry, 1910-','The colonial wars, 1689-1762.');
INSERT INTO new_titles VALUES ('2000/10/09','GC1 .P7','AAT-2341','','Progress in oceanography');
INSERT INTO new_titles VALUES ('2000/10/09','QH573 .I5','AAQ-7233','','International review of cytology');
INSERT INTO new_titles VALUES ('2000/10/09','QH301 .B42','AAP-9893','','Biological journal of the Linnean Society');
INSERT INTO new_titles VALUES ('2000/10/09','QD510 .T54','AAP-6181','','Thermochimica acta');
INSERT INTO new_titles VALUES ('2000/10/09','PN6319 .L3 1904','AAC-3215','Latham, Edward.','Famous sayings and their authors; a collection of historical sayings in English, French, German, Greek, Italian, and Lat');
INSERT INTO new_titles VALUES ('2000/10/17','Y 1.1/5:106-294','ANW-9236','United States. Congress. Senate. Committee on Health, Education, Labor, and Pensions.','Ryan White CARE Act Amendments of 2000 : report (to accompany S. 2311).');
INSERT INTO new_titles VALUES ('2000/10/17','Y 1.1/5:106-296','ANW-8528','','ALLOCATION TO SUBCOMMITTEES OF BUDGET TOTALS FROM THE CONCURRENT RESOLUTION FOR FISCAL YEAR 2001... REPORT 106-296... S');
INSERT INTO new_titles VALUES ('2000/10/17','EP 4.2:C 17/9','ANW-8506','','CARBON DIOXIDE AS A FIRE SUPPRESSANT: EXAMINING THE RISKS... U.S. ENVIRONMENTAL PROTECTION AGENCY... FEBRUARY 2000');
INSERT INTO new_titles VALUES ('2000/10/17','EP 4.2:P 76/16','ANW-8507','','NATIONAL EMISSION STANDARDS FOR HAZARDOUS AIR POLLUTANTS (NESHAP): POLYMERS AND RESINS (GROUP I AND IV)... SUMMARY OF P');
INSERT INTO new_titles VALUES ('2000/10/17','EP 5.8:L 47','ANW-8505','','THE LEAN AND GREEN SUPPLY CHAIN: A PRACTICAL GUIDE FOR MATERIALS MANAGERS AND SUPPLY CHAIN MANAGERS TO REDUCE COSTS AND');
INSERT INTO new_titles VALUES ('2000/10/17','EP 5.8:EM 3/5','ANW-8504','','EMERGENCY PLANNING AND COMMUNITY RIGHT-TO-KNOW ACT SECTION 313... EPCRA/TRI TRAINING MATERIALS: SPRING 2000, TWO-DAY WO');
INSERT INTO new_titles VALUES ('2000/10/17','EP 1.23/6:600/F-00/004','ANW-8503','','1999 SCIENCE TO ACHIEVE RESULTS (STAR) GRADUATE FELLOWSHIP CONFERENCE PROCEEDINGS, JULY 18-20, 1999..., EPA/600/F-00/00');
INSERT INTO new_titles VALUES ('2000/10/17','BF637.L4 P42 1999','ANW-6616','Pearman, Roger R., 1956-','Enhancing leadership effectiveness through psychological type : a development guide for using psychological type with ex');
INSERT INTO new_titles VALUES ('2000/10/17','RL74 .B36 2000','ANW-3133','Barone, Eugene J.','Skin disorders /');
INSERT INTO new_titles VALUES ('2000/10/17','JZ1734 .W36 1999','ANW-3415','Wang, Gungwu.','China and Southeast Asia : myths, threats, and culture /');
INSERT INTO new_titles VALUES ('2000/10/17','Z675.S3 I54 1999','ANS-1578','','Information skills : K-12 standard course of study /');
INSERT INTO new_titles VALUES ('2000/10/17','HJ9449 .H86 2000','ANS-5730','','Hungary: modernizing the subnational government system /');
INSERT INTO new_titles VALUES ('2000/10/17','RD120.8 .G78 1998','ANR-0176','','Grabb\'s encyclopedia of flaps /');
INSERT INTO new_titles VALUES ('2000/10/17','Y 4.AP 6/1:IN 8/6/2001/PT.1-','ANR-9770','United States. Congress. House. Committee on Appropriations. Subcommittee on Dept. of the Interior and Related Agencies.','Department of the Interior and related agencies appropriations for 2001 : hearings before a subcommittee of the Committe');
INSERT INTO new_titles VALUES ('2000/10/17','JS231 .K58 2000','ANQ-2486','Klitgaard, Robert E.','Corrupt cities : a practical guide to cure and prevention /');
INSERT INTO new_titles VALUES ('2000/10/17','I 19.81:C 87/994/35077-A 1--A 2','AMY-4947','Geological Survey (U.S.)','[Croatan National Forest, N.C. and other adjacent forest areas], 1994 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/17','A 57.38/28:W 27/NORTH/PT.1-2','AMQ-5616','Slusser, Steve.','Soil survey of Washoe County, Nevada, North Part /');
INSERT INTO new_titles VALUES ('2000/10/17','A 1.68:1671','AMD-1994','','Not all alien invaders are from outer space the invasion has begun, record numbers of uninvited species are destroying o');
INSERT INTO new_titles VALUES ('2000/10/17','TD 12.15:','ALS-1221','','Air carrier industry scheduled service traffic statistics');
INSERT INTO new_titles VALUES ('2000/10/17','LC 4.2:M46','ALT-2485','Library of Congress.','Medieval and Renaissance manuscript books in the Library of Congress : a descriptive catalog /');
INSERT INTO new_titles VALUES ('2000/10/17','CSA 1.10:[FY]-53','AKQ-8025','United States. Community Services Administration.','Federal outlays in summary.');
INSERT INTO new_titles VALUES ('2000/10/17','L 2.121/13:C 43/','AKN-2285','','National compensation survey.');
INSERT INTO new_titles VALUES ('2000/10/17','[Microfiche] TD 10.9/3:','AKC-3751','','Air carrier traffic statistics monthly');
INSERT INTO new_titles VALUES ('2000/10/17','Mf 162 no. 11283','AJS-5700','Escher, Beate Isabella 1965-','The relationship between membrane-water partitioning, uncoupling, and inhibitory activity of subsituted phenols in chrom');
INSERT INTO new_titles VALUES ('2000/10/17','Mf 162 no. 11282','AJS-5697','Foletti, Davide, 1966-','Plasma membrane and endoplasmic reticulum CA2+ATPases : subcellular targeting of chimeric and mutant proteins /');
INSERT INTO new_titles VALUES ('2000/10/17','[Reference Desk] LA201 .E456','AJP-4010','','Education statistics of the United States.');
INSERT INTO new_titles VALUES ('2000/10/17','LB3044 .N79','AIG-6317','North Carolina. Dept. of Public Instruction. Information Technology Evaluation Services.','Infotech /');
INSERT INTO new_titles VALUES ('2000/10/17','DS383.5.A2 B87 1990','AFT-6083','Burke, S. M.','Pakistan\'s foreign policy : an historical analysis /');
INSERT INTO new_titles VALUES ('2000/10/17','NA7840 .R47 1992','AFR-4073','','Restaurant design /');
INSERT INTO new_titles VALUES ('2000/10/17','QL463 .E59 1796','ACP-4160','','Entomologisches Taschenbuch : fr die Anfnger und Liebhaber dieser Wissenschaft auf das Jahr 1796 /');
INSERT INTO new_titles VALUES ('2000/10/17','HD72 .H85','ACO-3816','','Human development report');
INSERT INTO new_titles VALUES ('2000/10/17','SB409 .W793 1988','ACJ-6979','Withner, Carl L. (Carl Leslie)','The Cattleyas and their relatives /');
INSERT INTO new_titles VALUES ('2000/10/17','B812 .F67 1986','ACH-8236','Fontaine, Petrus Franciscus Maria.','The light and the dark : a cultural history of dualism /');
INSERT INTO new_titles VALUES ('2000/10/17','DU99 .K54','ABU-6969','King, Philip Parker, 1793-1856.','Narrative of a survey of the intertropical and western coasts of Australia : performed between the years 1818 and 1822 /');
INSERT INTO new_titles VALUES ('2000/10/17','QC173.98 .M44','ABT-9053','Mehra, Jagdish.','The historical development of quantum theory /');
INSERT INTO new_titles VALUES ('2000/10/17','TE175 .A553','ABI-5007','American Association of State Highway Officials.','A policy on landscape development for the national system of interstate and defense highways, 1961.');
INSERT INTO new_titles VALUES ('2000/10/17','PN4700 .J7','ABD-0977','','The Journalism quarterly.');
INSERT INTO new_titles VALUES ('2000/10/17','HD9710.U5 W3','ABB-8861','','Ward\'s automotive yearbook');
INSERT INTO new_titles VALUES ('2000/10/17','T12 .T6','AAZ-0227','','Thomas register of American manufacturers and Thomas register catalog file.');
INSERT INTO new_titles VALUES ('2000/10/17','PN451 .S6','AAZ-0051','','Something about the author');
INSERT INTO new_titles VALUES ('2000/10/17','TH4763 .S83 1975','AAY-7166','','Swimming pools, a guide to their planning, design, and operation : a project of the Council for National Cooperation in');
INSERT INTO new_titles VALUES ('2000/10/17','QK600 .M8','AAY-0323','','Mycologia');
INSERT INTO new_titles VALUES ('2000/10/17','[Business Alcove] HG4961 .M7237','AAY-6098','','Moody\'s OTC industrial manual.');
INSERT INTO new_titles VALUES ('2000/10/17','QL468 .G599 1685','AAQ-3306','Goedaert, Johannes, 1617-1668.','Johannes Goedartivs De insectis, in methodum redactus; cum notularum additione. Oper M. Lister. Item Appendicis ad Hist');
INSERT INTO new_titles VALUES ('2000/10/16','DT14 .A37434 2000','ANZ-4755','','African visions : literary images, political change, and social struggle in contemporary Africa /');
INSERT INTO new_titles VALUES ('2000/10/16','BJ352 .M39 2000','ANZ-3856','McDowell, Banks.','Ethics and excuses : the crisis in professional responsibility /');
INSERT INTO new_titles VALUES ('2000/10/16','PS3555.H58 S25 2000','ANZ-3180','Ehn, Erik.','The saint plays /');
INSERT INTO new_titles VALUES ('2000/10/16','HD9539.R284 M38 2000','ANZ-3175','Litt, Paul.','Isotopes and innovation : MDS Nordion\'s first fifty years, 1946-1996 /');
INSERT INTO new_titles VALUES ('2000/10/16','HQ1121 .R45 2000','ANZ-3157','','Representations of gender from prehistory to the present /');
INSERT INTO new_titles VALUES ('2000/10/16','HB87 .M337 2001','ANZ-3155','McCarty, Marilu Hurt.','The Nobel laureates : how the world\'s greatest economic minds shaped modern thought /');
INSERT INTO new_titles VALUES ('2000/10/16','HQ1075 .G459 2000','ANZ-3151','','Gender and material culture in historical perspective /');
INSERT INTO new_titles VALUES ('2000/10/16','RA790.6 .S38 2000','ANZ-3144','Savin, Howard A., 1946-','Accountable systems of behavioral health care : a provider\'s guide /');
INSERT INTO new_titles VALUES ('2000/10/16','QA76.73.C15 S35334 2000','ANZ-3125','Schildt, Herbert.','C/C++ programmer\'s reference /');
INSERT INTO new_titles VALUES ('2000/10/16','BF175.4.C84 W46 2000','ANZ-3115','','Whose Freud? : the place of psychoanalysis in contemporary culture /');
INSERT INTO new_titles VALUES ('2000/10/16','JQ1981 .J85 2000','ANZ-3114','Jung, Courtney Elizabeth.','Then I was Black : South African political identitites in transition /');
INSERT INTO new_titles VALUES ('2000/10/16','P94.5.A372 U557 2000','ANZ-3109','Jacobs, Ronald N.','Race, media, and the crisis of civil society : from Watts to Rodney King /');
INSERT INTO new_titles VALUES ('2000/10/16','PQ2152.A38 Z8454 2000','ANZ-3107','Bolster, Richard.','Marie d\'Agoult : the rebel countess /');
INSERT INTO new_titles VALUES ('2000/10/16','SB608.C28 M37 2000','ANZ-3105','McPartland, J. M. (John Michael)','Hemp diseases and pests : management and biological control : an advanced treatise /');
INSERT INTO new_titles VALUES ('2000/10/16','QP572.S6 G764 2000','ANZ-3104','','Growth hormone in adults : physiological and clinical aspects /');
INSERT INTO new_titles VALUES ('2000/10/16','QL737.C432 R49 2000','ANZ-3101','Reynolds, John Elliott, 1952-','The bottlenose dolphin : biology and conservation /');
INSERT INTO new_titles VALUES ('2000/10/16','QL673 .S98 2000','ANZ-3100','Symanski, Richard.','Blackhearts : ecology in outback Australia /');
INSERT INTO new_titles VALUES ('2000/10/16','DS126.6.R32 A87 2000','ANZ-3099','','The assassination of Yitzhak Rabin /');
INSERT INTO new_titles VALUES ('2000/10/16','HC681 .W54 2000','ANZ-3084','Wiegersma, Nancy.','US economic development policies towards the Pacific rim : successes and failures of US aid /');
INSERT INTO new_titles VALUES ('2000/10/16','QP255 .E87 2000','ANZ-3083','European Workshop on Molecular and Cellular Endocrinology of the Testis (11th : 2000 : Saint-Malo, France)','Testis, epididymis, and technologies in the year 2000 /');
INSERT INTO new_titles VALUES ('2000/10/16','JC585 .M43 2000','ANZ-3082','Macfarlane, Alan.','The riddle of the modern world : of liberty, wealth and equality /');
INSERT INTO new_titles VALUES ('2000/10/16','QA76.9.A25 B78 2000','ANZ-3081','Brown, Keith, 1967 Mar. 16-','Programming Windows security /');
INSERT INTO new_titles VALUES ('2000/10/16','JN6699.A15 A43 2000','ANZ-3080','Alexander, James, 1964-','Political culture in post-communist Russia : formlessness and recreation in a traumatic transition /');
INSERT INTO new_titles VALUES ('2000/10/16','QC174.17.S9 M35 2000','ANZ-3074','','The many faces of the superworld : Yuri Golfand memorial volume /');
INSERT INTO new_titles VALUES ('2000/10/16','QA76.73.J38 C478 2000','ANZ-3073','Chen, Zhiqun, 1969-','Java Card technology for Smart Cards : architecture and programmer\'s guide /');
INSERT INTO new_titles VALUES ('2000/10/16','QA76.76.O63 W559 2000','ANZ-3066','Willis, Will, 1971-','Windows 2000 system administration handbook /');
INSERT INTO new_titles VALUES ('2000/10/16','TD899.U73 T78 2000','ANZ-3063','','Turning a problem into a resource : remediation and waste management at the Sillame site, Estonia /');
INSERT INTO new_titles VALUES ('2000/10/16','HM1041 .B37 2000','ANZ-3061','Bar-Tal, Daniel.','Shared beliefs in a society : social psychological analysis /');
INSERT INTO new_titles VALUES ('2000/10/16','QP187.3.M64 P75 2000','ANZ-3060','','Principles of molecular regulation /');
INSERT INTO new_titles VALUES ('2000/10/16','GE160.A35 L63 2000','ANZ-3058','','Local environmental change and society in Africa /');
INSERT INTO new_titles VALUES ('2000/10/16','TK5105.875.I57 C65 2000','ANZ-3056','Comer, Douglas.','The Internet book : everything you need to know about computer networking and how the Internet works /');
INSERT INTO new_titles VALUES ('2000/10/16','TA168 .S887 2000','ANZ-3005','','Systems, experts, and computers : the systems approach in management and engineering, World War II and after /');
INSERT INTO new_titles VALUES ('2000/10/16','QA370 .S87 2000','ANZ-3047','','Surveys on solution methods for inverse problems /');
INSERT INTO new_titles VALUES ('2000/10/16','QH351 .P58 2000','ANZ-2999','','Phylogenetic analysis of morphological data /');
INSERT INTO new_titles VALUES ('2000/10/16','QH470.M52 P38 2000','ANZ-2998','','Pathology of genetically engineered mice /');
INSERT INTO new_titles VALUES ('2000/10/16','E99.C6 M35 2000','ANZ-2997','McNally, Michael.','Ojibwe singers : hymns, grief, and a native culture in motion /');
INSERT INTO new_titles VALUES ('2000/10/16','JQ1516 .F86 2000','ANZ-2996','Fung, Edmund S. K.','In search of Chinese democracy : civil opposition in Nationalist China, 1929-1949 /');
INSERT INTO new_titles VALUES ('2000/10/16','HM756 .M37 2000','ANZ-2991','Mason, Andrew, 1959-','Community, solidarity, and belonging : levels of community and their normative significance /');
INSERT INTO new_titles VALUES ('2000/10/16','LA184 .S42 2000','ANZ-2988','Smart, John C.','Academic disciplines : Holland\'s theory and the study of college students and faculty /');
INSERT INTO new_titles VALUES ('2000/10/16','JL339.A45 S74 2000','ANZ-2941','Stewart, David Kenney, 1962-','Quasi-democracy? : parties and leadership selection in Alberta /');
INSERT INTO new_titles VALUES ('2000/10/16','JC423 .D393 2000','ANZ-2915','','Democracy and cultural diversity /');
INSERT INTO new_titles VALUES ('2000/10/16','JC421 .D48 2000','ANZ-2916','DeWiel, Boris, 1956-','Democracy : a history of ideas /');
INSERT INTO new_titles VALUES ('2000/10/16','DG63 .S73 2000','ANZ-2907','Staccioli, Romolo Augusto','Ancient Rome : past and present /');
INSERT INTO new_titles VALUES ('2000/10/16','PS3519.E27 A17 1988','ANZ-2897','Jeffers, Robinson, 1887-1962.','The collected poetry of Robinson Jeffers /');
INSERT INTO new_titles VALUES ('2000/10/16','PREX 3.10/4:W 89/47','ANZ-2481','','World Political Map, Robinson Projection, Scale 1:175,000,000, 802702AI (R00350), June 2000');
INSERT INTO new_titles VALUES ('2000/10/16','C 55.418/7:13281/2000','ANZ-2479','','United States - East Coast, Massachusetts, Gloucester Harbor and Annisquam River, 13281, May 20, 2000');
INSERT INTO new_titles VALUES ('2000/10/16','C 55.418/7:12312/2000','ANZ-2478','','United States - East Coast, Delaware - Pennsylvania - New Jersey, Delaware River, Wilmington to Philadelphia, 12312, Ju');
INSERT INTO new_titles VALUES ('2000/10/16','TK4058 .B4513 1999','ANZ-1404','Bonal, Jean.','Variable speed electric drives.');
INSERT INTO new_titles VALUES ('2000/10/16','C 55.418/7:12273/2000','ANZ-2477','','United States - East Coast, Maryland, Chesapeake Bay, Sandy Point to Susquehanna River, 12273, Loran-C, January 3, 2000');
INSERT INTO new_titles VALUES ('2000/10/16','R856.A1 A573','ANZ-0897','','Annual review of biomedical engineering.');
INSERT INTO new_titles VALUES ('2000/10/16','NA735.N5 F73 1994','ANZ-0796','Frampton, Kenneth.','The 20th century architecture and urbanism : New York /');
INSERT INTO new_titles VALUES ('2000/10/16','NA1121.M6 D35 1991','ANZ-0794','Dal Co, Francesco, 1945-','The 20th century architecture and urbanism : Milano /');
INSERT INTO new_titles VALUES ('2000/10/16','NA737.W665 A4 1991','ANZ-0793','Woods, Lebbeus.','Lebbeus Woods : Terra Nova, 1988-1991 = Rebeusu Uzzu : Tera Nova 1988-1991 /');
INSERT INTO new_titles VALUES ('2000/10/16','NA1153.H47 A4 1991','ANZ-0792','Hertzberger, Herman.','Herman Hertzberger, 1959-1990 = Heruman Herutsuberuha 1959-1990 /');
INSERT INTO new_titles VALUES ('2000/10/16','NA7205 .P58 1989','ANZ-0788','Plummer, Henry, 1946-','Kanosei no jutaku : Amerika jukyo no sanseiki = The potential house : three centuries of American dwelling /');
INSERT INTO new_titles VALUES ('2000/10/16','NA997.R64 A4 1988','ANZ-0785','Rogers, Richard George.','Richado Rojas = Richard Rogers : 1978-1988 /');
INSERT INTO new_titles VALUES ('2000/10/16','NA680 .G2124 no.1','ANZ-0775','Ando, Tadao, 1941-','Tadao Ando /');
INSERT INTO new_titles VALUES ('2000/10/16','JV6098 .G56 2000','ANZ-0403','','Globalisation, migration and development : OECD proceedings /');
INSERT INTO new_titles VALUES ('2000/10/16','N5078.S8 S8 nr. 75','ANY-9498','Moderna museet (Stockholm, Sweden)','Vladimir Tatlin : moderna museet, Stockholm, juli-september, 1968 /');
INSERT INTO new_titles VALUES ('2000/10/16','F786.B54 G37 2000','ANY-9330','Garrett, Pat F. (Pat Floyd), 1850-1908.','Pat F. Garrett\'s The authentic life of Billy, the Kid /');
INSERT INTO new_titles VALUES ('2000/10/16','Y 1.1/8:106-664','ANY-9250','United States. Congress. House. Committee on Government Reform.','Providing that the School Governance Charter Amendment Act of 2000 shall take effect upon the date such act is ratified');
INSERT INTO new_titles VALUES ('2000/10/16','Y 1.1/8:106-662','ANY-9249','United States. Congress. House. Committee on Commerce.','Noncommercial Broadcasting Freedom of Expression Act of 2000 : report together with minority views (to accompany H.R. 42');
INSERT INTO new_titles VALUES ('2000/10/16','Y 1.1/8:106-661','ANY-9248','United States. Congress (106th, 2nd session : 2000)','Electronic Signatures in Global and National Commerce Act : conference report (to accompany S. 761).');
INSERT INTO new_titles VALUES ('2000/10/16','Y 3.N 88:25/0200/V.- /REV.6','ANY-9241','','SCALE, a modular code system for performing standardized computer analyses for licensing evaluation /');
INSERT INTO new_titles VALUES ('2000/10/16','Y 1.1/8:106-674','ANY-9222','United States. Congress. House. Committee on Appropriations.','Departments of Veterans Affairs and Housing and Urban Development, and independent agencies appropriations bill, 2001 :');
INSERT INTO new_titles VALUES ('2000/10/16','PQ7389.C263 R413 1989','ANY-6335','Carpentier, Alejo, 1904-','The kingdom of this world /');
INSERT INTO new_titles VALUES ('2000/10/16','HF5548.32 .B66 2000','ANY-4481','Bonnett, Kendra.','An IBM guide to doing business on the Internet /');
INSERT INTO new_titles VALUES ('2000/10/16','LC5053.C46 S35 1995','ANY-4899','Schied, Fred M.','Learning in social context : workers and adult education in nineteenth century Chicago /');
INSERT INTO new_titles VALUES ('2000/10/16','HF5548.32 .F56 2000','ANY-4434','Fingar, Peter, 1946-','Enterprise e-commerce : the software component breakthrough for business-to-business commerce /');
INSERT INTO new_titles VALUES ('2000/10/16','E161.5 .A43 2000','ANY-3606','','America in an Arab mirror : images of America in Arabic travel literature : an anthology, 1895-1995 /');
INSERT INTO new_titles VALUES ('2000/10/16','F2520.1.Y3 E29 2000','ANY-3605','Early, John D.','The Xilixana Yanomami of the Amazon : history, social structure, and population dynamics / James D. Early, John F. Peter');
INSERT INTO new_titles VALUES ('2000/10/16','DA452 .C87 2000','ANY-3589','Cruickshanks, Eveline.','The Glorious Revolution /');
INSERT INTO new_titles VALUES ('2000/10/16','QH541.28 .S68 2000','ANY-3583','Southwood, Richard, Sir.','Ecological methods /');
INSERT INTO new_titles VALUES ('2000/10/16','F1234 .B465 2000','ANY-3531','Benjamin, Thomas, 1952-','La Revolucin : Mexico\'s great revolution as memory, myth, and history /');
INSERT INTO new_titles VALUES ('2000/10/16','RB127 .W355 2000','ANY-3520','Wall, Patrick D. (Patrick David), 1925-','Pain : the science of suffering /');
INSERT INTO new_titles VALUES ('2000/10/16','DT515.45.O33 O48 1998','ANY-1853','','Ogoni\'s agonies : Ken Saro-Wiwa and the crisis in Nigeria /');
INSERT INTO new_titles VALUES ('2000/10/16','HN90.E4 B76 2000','ANY-1056','Brooks, David, 1961-','Bobos in paradise : the new upper class and how they got there /');
INSERT INTO new_titles VALUES ('2000/10/16','PG3476.S5713 A27 1999','ANX-9144','Slutskii, Boris, 1919-','Things that happened /');
INSERT INTO new_titles VALUES ('2000/10/16','NA737.W43 A4 1998','ANY-0922','Wells, Malcolm.','The earth-sheltered house : an architect\'s sketchbook /');
INSERT INTO new_titles VALUES ('2000/10/16','HC470.2 .E25 1999','ANX-7274','Eberstadt, Nick, 1955-','The end of North Korea /');
INSERT INTO new_titles VALUES ('2000/10/16','HN373.5 .N49 1998','ANX-7153','','New Europe : transformation and environmental issues /');
INSERT INTO new_titles VALUES ('2000/10/16','PZ73 .A4 1999','ANX-5293','Alberti, Rafael, 1902-1999.','Rafael Alberti : para nios /');
INSERT INTO new_titles VALUES ('2000/10/16','D843 .S547 2000','ANX-6753','Smith, Joseph, 1945-','Historical dictionary of the Cold War /');
INSERT INTO new_titles VALUES ('2000/10/16','PZ73 .G369 1999','ANX-5292','Garca Lorca, Federico.','Federico Garca Lorca : para nios /');
INSERT INTO new_titles VALUES ('2000/10/16','QP552.G76 S57 2000','ANX-4192','','Skeletal growth factors /');
INSERT INTO new_titles VALUES ('2000/10/16','F1008 .C315 2000','ANX-4211','','Canada and the United States : differences that count /');
INSERT INTO new_titles VALUES ('2000/10/16','QC670 .K693 2000','ANX-3960','Kovetz, Attay.','Electromagnetic theory /');
INSERT INTO new_titles VALUES ('2000/10/16','Y 1.1/8:106-658','ANX-1782','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 8, the Death Tax Elimination Act of 2000 : report (to accompany H. Res. 519).');
INSERT INTO new_titles VALUES ('2000/10/16','Y 1.1/8:106-657','ANX-1781','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 4577, the Departments of Labor, Health and Human Services, and Education, and Re');
INSERT INTO new_titles VALUES ('2000/10/16','Y 1.1/8:106-655/PT.1-','ANX-1780','United States. Congress. House. Committee on the Judiciary.','Internet Gambling Prohibition Act of 2000 : report together with additional and dissenting views (to accompany H.R. 3125');
INSERT INTO new_titles VALUES ('2000/10/16','Y 1.1/8:106-654','ANX-1779','','PROVIDING FOR THE CONSIDERATION OF H.R. 3605, THE SAN RAFAEL WESTERN LEGACY DISTRICT AND NATIONAL CONSERVATION ACT... R');
INSERT INTO new_titles VALUES ('2000/10/16','Y 1.1/8:106-653','ANX-1778','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 4577, the Departments of Labor, Health and Human Services, and Education, and Re');
INSERT INTO new_titles VALUES ('2000/10/16','Y 1.1/8:106-652','ANX-1777','United States. Congress. House. Committee on Rules.','Providing for the consideration of H.R. 4576, the Department of Defense Appropriations Act, 2001 : report (to accompany');
INSERT INTO new_titles VALUES ('2000/10/16','Y 1.1/8:106-651','ANX-1776','United States. Congress. House. Committee on Ways and Means.','Death Tax Elimination Act of 2000 : report (to accompany H.R. 8) (including cost estimate of the Congressional Budget Of');
INSERT INTO new_titles VALUES ('2000/10/16','Y 1.1/8:106-649','ANX-1775','','STUDY OF KEALIA POND NATIONAL WILDLIFE REFUGE, HAWAII... REPORT 106-649... HOUSE OF REPRESENTATIVES... 106TH CONGRESS,');
INSERT INTO new_titles VALUES ('2000/10/16','Y 1.1/8:106-648','ANX-1774','United States. Congress. House. Committee on Resources.','Clarification of boundaries of coastal barrier resources system unit NC01 : report (to accompany H.R. 4435) (including c');
INSERT INTO new_titles VALUES ('2000/10/16','Y 1.1/8:106-647','ANX-1773','','SAN RAFAEL WESTERN LEGACY DISTRICT AND NATIONAL CONSERVATION ACT... REPORT 106-647... HOUSE OF REPRESENTATIVES... 106TH');
INSERT INTO new_titles VALUES ('2000/10/16','Y 1.1/8:106-644','ANX-1772','','DEPARTMENT OF DEFENSE APPROPRIATIONS BILL, 2001... REPORT OF THE COMMITTEE ON APPROPRIATIONS... REPORT 106-644... HOUSE');
INSERT INTO new_titles VALUES ('2000/10/16','Y 4.V 64/3:106-27','ANX-1757','United States. Congress. House. Committee on Veterans\' Affairs. Subcommittee on Oversight and Investigations.','Hearing V on Year 2000 readiness in the Department of Veterans Affairs : hearing before the Subcommittee [i.e. on] Overs');
INSERT INTO new_titles VALUES ('2000/10/16','E 1.48:IG-0462','ANX-1752','','NATIONAL LOW-LEVEL WASTE MANAGEMENT PROGRAM... AUDIT REPORT... U.S. DEPARTMENT OF ENERGY... FEBRUARY 2000');
INSERT INTO new_titles VALUES ('2000/10/16','E 1.48:IG-0461','ANX-1751','','GROUNDWATER MONITORING ACTIVITIES AT DEPARTMENT OF ENERGY FACILITIES... AUDIT REPORT... U.S. DEPARTMENT OF ENERGY... FE');
INSERT INTO new_titles VALUES ('2000/10/16','E 1.48:IG-0459','ANX-1750','','UNCLASSIFIED COMPUTER NETWORK SECURITY AT SELECTED FIELD SITES... AUDIT REPORT... U.S. DEPARTMENT OF ENERGY... FEBRUARY');
INSERT INTO new_titles VALUES ('2000/10/16','E 1.48:IG-0453','ANX-1749','','WASTE INCINERATION AT THE SAVANNAH RIVER SITE... AUDIT REPORT... U.S. DEPARTMENT OF ENERGY... OCTOBER 1999');
INSERT INTO new_titles VALUES ('2000/10/16','E 1.48:IG-0424','ANX-1747','','ARCHITECT AND ENGINEERING COSTS AT LOS ALAMOS AND SANDIA NATIONAL LABORATORIES... DOE/IG-0424... U.S. DEPARTMENT OF ENE');
INSERT INTO new_titles VALUES ('2000/10/16','E 1.48:IG-0423','ANX-1746','','REVIEW OF THE U.S. DEPARTMENT OF ENERGY\'S INFORMATION MANAGEMENT SYSTEMS... AUDIT REPORT... DOE/IG-0423... U.S. DEPARTM');
INSERT INTO new_titles VALUES ('2000/10/16','E 1.48:ER-B-99-01','ANX-1745','','DECONTAMINATION AND DECOMMISSIONING AT THE EAST TENNESSEE TECHNOLOGY PARK... AUDIT REPORT... ER-B-99-01... U.S. DEPARTM');
INSERT INTO new_titles VALUES ('2000/10/16','E 1.84:11','ANX-1744','','Commercial-scale demonstration of the liquid phase methanol (LPMEOH) process a report on a project conducted jointly und');
INSERT INTO new_titles VALUES ('2000/10/16','C 13.10/3-3:16/2000','ANX-1742','','NATIONAL CONFERENCE ON WEIGHTS AND MEASURES... COMMITTEE REPORTS FOR THE 85TH ANNUAL MEETING JULY 16-20, 2000..., NCWM');
INSERT INTO new_titles VALUES ('2000/10/16','C 13.58:6447','ANX-1741','Williams, Maureen Elizabeth.','The reactions of zinc vapor with Zircaloy-4 and pure zirconium');
INSERT INTO new_titles VALUES ('2000/10/16','C 13.58:6398','ANX-1740','','Spot test kits for detecting lead in household paints a laboratory evaluation /');
INSERT INTO new_titles VALUES ('2000/10/16','C 55.13/2:OAR CMDL-15','ANX-1739','Nelson, Donald W.','The NOAA Climate Monitoring and Diagnostic Laboratory Solar Radiation Facility');
INSERT INTO new_titles VALUES ('2000/10/16','C 55.13/2:NOS NCCOSCCMA 141','ANX-1738','','MAGNITUDE AND EXTENT OF CHEMICAL CONTAMINATION AND TOXICITY IN SEDIMENTS OF BISCAYNE BAY AND VICINITY..., NOAA TECH. ME');
INSERT INTO new_titles VALUES ('2000/10/16','A 77.15:155','ANX-1736','','Annotated list of the flora of the Beltsville Agricultural Research Center, Beltsville, Maryland');
INSERT INTO new_titles VALUES ('2000/10/16','Y 4.AP 6/1:L 11/2001/PT.1-','ANX-1716','United States. Congress. House. Committee on Appropriations. Subcommittee on the Departments of Labor, Health and Human Services, Education, and Related Agencie','Departments of Labor, Health and Human Services, Education, and related agencies appropriations for 2001 : hearings befo');
INSERT INTO new_titles VALUES ('2000/10/16','PZ73 .S515 2000','ANW-5441','','Si ves un monte de espumas y otros poemas : antologa de poesa infantil hispanoamericana /');
INSERT INTO new_titles VALUES ('2000/10/16','PZ73 .C845 2000','ANW-5438','Cueto, Milio Rodrguez.','Mim al volante /');
INSERT INTO new_titles VALUES ('2000/10/16','PZ73 .R39 2000','ANW-5440','Ray, Miquel.','El camino del faro /');
INSERT INTO new_titles VALUES ('2000/10/16','RM666.M83 I58 1998','ANW-3037','International Moxifloxacin Symposium (1st : 1998 : Berlin, Germany)','Proceedings of the First International Moxifloxacin Symposium /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.111/A:998/R 27','ANQ-6836','Geological Survey (U.S.)','The national atlas of the United States of America.');
INSERT INTO new_titles VALUES ('2000/10/16','PZ73 .B605 1999','ANQ-2842','Bermejo, Amalia.','La literatura infantil en Espaa /');
INSERT INTO new_titles VALUES ('2000/10/16','TK5103 .B36 2000','ANQ-1164','Banks, Michael A.','The modem reference guide : the complete guide to PC communications /');
INSERT INTO new_titles VALUES ('2000/10/16','TS1138 .T36 1999','ANQ-0589','','1999 TAPPI/FBA corrugated productivity and waste survey report /');
INSERT INTO new_titles VALUES ('2000/10/16','I 53.11/4:35106-E 1-TM-100/999','ANP-3209','United States. Bureau of Land Management.','New Mexico : Los Alamos : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 53.11/4:32104-E 1-TM-100/999','ANP-3169','United States. Bureau of Land Management.','New Mexico : Artesia : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','[Microfiche] E 1.38/5:','ANP-3090','','Wind power today ... wind energy program highlights.');
INSERT INTO new_titles VALUES ('2000/10/16','I 53.11/4:34109-E 1-TM-100/999','ANP-1579','United States. Bureau of Land Management.','Arizona : Saint Johns : 1:100,000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 53.11/4:34113-E 1-TM-100/999','ANP-1578','United States. Bureau of Land Management.','Arizona : Bagdad : 1:100,000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 53.11/4:33111-A 1-TM-100/999','ANP-1576','United States. Bureau of Land Management.','Arizona : Mesa : 1:100,000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 53.11/4-2:45118-E 1-TM-100/999','ANP-1564','United States. Bureau of Land Management.','Oregon : Pendleton : 1:100,000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 53.11/4:45118-E 1-TM-100/999','ANP-1562','United States. Bureau of Land Management.','Oregon : Pendleton : 1:100 000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 53.11/4-2:48117-A 1-TM-100/998','ANP-1547','United States. Bureau of Land Management.','Washington : Chewelah : 1:100 000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 53.11/4:48117-A 1-TM-100/998','ANP-1019','United States. Bureau of Land Management.','Washington : Chewelah : 1:100 000-scale topographic map : 30 X 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','PF3640 .C64 1999','ANO-7626','','Collins German-English, English-German dictionary: unabridged /');
INSERT INTO new_titles VALUES ('2000/10/16','GV888.25 .W48 2000','ANO-7145','Wetzel, Dan.','Sole influence : basketball, corporate greed, and the corruption of America\'s youth /');
INSERT INTO new_titles VALUES ('2000/10/16','I 53.11/4:39108-A 1-TM-100/999','ANF-5172','United States. Bureau of Land Management.','Colorado : Grand Junction : 1:100,000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/11','EP 1.17:530-F-99-022','ANP-4757','','COMPLEX RECYCLING ISSUES... STRATEGIES FOR RECORD-SETTING WASTE REDUCTION IN MULTI-FAMILY DWELLINGS... EPA-530-F-99-022');
INSERT INTO new_titles VALUES ('2000/10/11','C 13.58:6472','ANP-4755','','ELECTRONICS AND ELECTRICAL ENGINEERING LABORATORY, STRATEGIC PLAN FOR FISCAL YEARS 2000-2005... NISTIR 6472... U.S. DEP');
INSERT INTO new_titles VALUES ('2000/10/11','C 13.58:6430','ANP-4754','','SEMICONDUCTOR ELECTRONICS DIVISION... PROGRAMS, ACTIVITIES, AND ACCOMPLISHMENTS... NISTIR 6430... U.S. DEPARTMENT OF CO');
INSERT INTO new_titles VALUES ('2000/10/11','Y 3.N 88:25/6665','ANP-4751','Parks, C. V.','Review and prioritization of technical issues related to burnup credit for LWR fuel');
INSERT INTO new_titles VALUES ('2000/10/11','Y 3.N 88:25/6649','ANP-4750','Ludwigsen, John S.','Posttest analysis of the steel containment vessel model /');
INSERT INTO new_titles VALUES ('2000/10/11','Y 3.N 88:25/5679','ANP-4749','','Design, instrumentation, and testing of a steel containment vessel model');
INSERT INTO new_titles VALUES ('2000/10/11','Y 3.N 88:10/0800/REV.3/SEC.2.5.1','ANP-4746','','STANDARD REVIEW PLAN... 2.5.1 BASIC GEOLOGIC AND SEISMIC INFORMATION... NUREG-0800, REV. 3... U.S. NUCLEAR REGULATORY C');
INSERT INTO new_titles VALUES ('2000/10/11','EP 1.43/2:99/001','ANP-4734','Azadpour-Keeley, Ann.','Microbial processes affecting monitored natural attenuation of contaminants in the subsurface');
INSERT INTO new_titles VALUES ('2000/10/11','EP 1.17:530-F-99-022 H','ANP-4733','','Syracuse, New York, public housing 20% waste reduction rate at Toomey Abbott Tower.');
INSERT INTO new_titles VALUES ('2000/10/11','EP 1.17:530-F-99-022 F','ANP-4732','','San Jose, California 25% waste reduction rate in multi-family dwellings.');
INSERT INTO new_titles VALUES ('2000/10/11','EP 1.17:530-F-99-022 C','ANP-4731','','East Orange, New Jersey 22% waste reduction rate in multi-family dwellings.');
INSERT INTO new_titles VALUES ('2000/10/11','EP 1.17:530-F-99-022 B','ANP-4730','','Commodore Club condominiums, Key Biscayne, Florida 59% waste reduction rate.');
INSERT INTO new_titles VALUES ('2000/10/11','EP 1.17:530-F-99-022 A','ANP-4729','','Blossom Hill Estates, San Jose, California 50% and 65% waste reduction rate.');
INSERT INTO new_titles VALUES ('2000/10/11','EP 1.17:530-F-99-017 R','ANP-4728','','Worcester, Massachusetts 54% residential waste reduction.');
INSERT INTO new_titles VALUES ('2000/10/11','C 13.58:6465','ANP-4726','','New approaches to the development of fire-safe materials');
INSERT INTO new_titles VALUES ('2000/10/11','C 13.58:6457','ANP-4725','','Non-intrusive scanning technology for construction status determination');
INSERT INTO new_titles VALUES ('2000/10/11','C 13.58:6455','ANP-4724','Persily, Andrew K.','A modeling study of ventilation in manufactured houses');
INSERT INTO new_titles VALUES ('2000/10/11','C 13.58:6452','ANP-4723','Schneeman, Richard D.','SIMnet design and Internet deployment guide');
INSERT INTO new_titles VALUES ('2000/10/11','C 13.58:6446','ANP-4722','','A comparison of CFAST predictions to USCG real-scale fire tests');
INSERT INTO new_titles VALUES ('2000/10/11','C 13.58:6443','ANP-4721','','Formalizing the NIST 4-D/RCS reference model architecture using an architectural description language');
INSERT INTO new_titles VALUES ('2000/10/11','C 13.58:6440','ANP-4720','Gladhill, Robert L.','NVCASE Program handbook procedures for obtaining NIST recognition as an accreditor');
INSERT INTO new_titles VALUES ('2000/10/11','C 13.58:6413','ANP-4719','Saunders, Bonita V.','Using numerical grid generation to facilitate 3D visualization of complicated mathematical functions');
INSERT INTO new_titles VALUES ('2000/10/11','C 13.58:6243','ANP-4718','Rumminger, Marc D.','Numerical modeling of counterflow diffusion flames inhibited by iron pentacarbonyl');
INSERT INTO new_titles VALUES ('2000/10/11','C 13.58:5090','ANP-4717','','OPTOELECTRONICS DIVISION... PROGRAMS, ACTIVITIES, AND ACCOMPLISHMENTS... NISTIR 5090... U.S. DEPARTMENT OF COMMERCE');
INSERT INTO new_titles VALUES ('2000/10/11','C 55.13/2:NMFS-NE-124','ANP-4715','','Essential fish habitat source document.');
INSERT INTO new_titles VALUES ('2000/10/11','C 3.223/27:38','ANP-4714','Hollmann, Frederick W. (Frederick William)','Methodology and assumptions for the population projections of the United States 1999-2010 /');
INSERT INTO new_titles VALUES ('2000/10/11','A 57.2:N 21/5','ANP-4713','Trn, Huong N.','Natural resources conservation laws a report on 17 states and their selected counties and townships /');
INSERT INTO new_titles VALUES ('2000/10/11','Y 1.1/7:106-169','ANP-4659','United States. President (1993- : Clinton)','6-month periodic report with respect to the Taliban : communication from the President of the United States transmitting');
INSERT INTO new_titles VALUES ('2000/10/11','Y 1.1/7:106-167','ANP-4657','','PROCEEDINGS OF THE DISABLED AMERICAN VETERANS 1999 NATIONAL CONVENTION, AUGUST 21-25, 1999, ORLANDO, FLORIDA... HOUSE D');
INSERT INTO new_titles VALUES ('2000/10/11','Y 1.1/7:106-166','ANP-1724','United States. President (1993- : Clinton)','Statement of justification : communication from the President of the United States transmitting a statement of justifica');
INSERT INTO new_titles VALUES ('2000/10/11','Y 1.1/7:106-177','ANP-1675','United States. President (1993- : Clinton)','6-month periodic report on the national emergency declared by Executive Order 12808 : communication from the President o');
INSERT INTO new_titles VALUES ('2000/10/11','Y 1.1/7:106-176','ANP-1672','United States. President (1993- : Clinton)','Continuation of national emergency in Libya : communication from the President of the United States transmitting notific');
INSERT INTO new_titles VALUES ('2000/10/11','Y 1.1/7:106-174','ANP-1668','United States. President (1993- : Clinton)','6-month periodic review of the national emergency declared by Executive Order 12924 : communication from the President o');
INSERT INTO new_titles VALUES ('2000/10/11','Y 1.1/7:106-163','ANP-1665','United States. President (1993- : Clinton)','A report on Iraq\'s compliance with the U.N. : communication from the President of the United States transmitting the rep');
INSERT INTO new_titles VALUES ('2000/10/11','Y 1.1/7:106-168','ANP-1634','United States. Congressional Budget Office.','Final sequestration report for fiscal year 2000 : communication from the director, the Congressional Budget Office, tran');
INSERT INTO new_titles VALUES ('2000/10/11','Y 1.1/7:106-172','ANP-1621','United States. President (1993- : Clinton)','Emergency budget requests : communication from the President of the United States transmitting designating the emergency');
INSERT INTO new_titles VALUES ('2000/10/11','Y 1.1/7:106-175','ANP-1619','United States. President (1993- : Clinton)','6-month report on the national emergency in Libya : communication from the President of the United States transmitting a');
INSERT INTO new_titles VALUES ('2000/10/11','Y 1.1/7:106-165','ANP-1587','United States. President (1993- : Clinton)','Department of Defense budget request : communication from the President of the United States transmitting the designatio');
INSERT INTO new_titles VALUES ('2000/10/11','Y 1.1/7:106-160','ANP-1585','United States. President (1993- : Clinton)','State of the union message : communication from the President of the United States transmitting a report on the state of');
INSERT INTO new_titles VALUES ('2000/10/11','Y 1.1/7:106-170','ANP-1584','United States. President (1993- : Clinton)','Appropriations transfer of funds : communication from the President of the United States transmitting the request to tra');
INSERT INTO new_titles VALUES ('2000/10/11','Y 1.1/7:106-173','ANP-1575','United States. President (1993- : Clinton)','Department of Defense budget request : communication from the President of the United States transmitting Department of');
INSERT INTO new_titles VALUES ('2000/10/11','Y 1.1/7:106-171','ANP-1574','United States. President (1993- : Clinton)','Department of Defense budget request : communication from the President of the United States transmitting the Department');
INSERT INTO new_titles VALUES ('2000/10/11','TA169.5 .M67 2000','ANK-7546','Mostia, William L.','Troubleshooting : a technician\'s guide.');
INSERT INTO new_titles VALUES ('2000/10/11','PREX 2.8/12:','ANA-5877','','The budget system and concepts of the United States government.');
INSERT INTO new_titles VALUES ('2000/10/11','PR2357 .B76 1999','ANE-5939','Brown, Richard Danson.','The new poet : novelty and tradition in Spenser\'s Complaints /');
INSERT INTO new_titles VALUES ('2000/10/11','D 208.109:','AMV-5174','United States Naval Academy.','Annapolis, United States Naval Academy catalog.');
INSERT INTO new_titles VALUES ('2000/10/11','LC 3.4/2:SL-7/996','AMV-3028','','New short forms now available /');
INSERT INTO new_titles VALUES ('2000/10/19','A 13.78:INT-229-240','AOE-8462','','Pinyon-juniper woodlands of the Great Basin : distribution, flora, vegetal cover /');
INSERT INTO new_titles VALUES ('2000/10/19','A 13.78:INT-179-190','AOE-8428','Arola, Rodger A.','Debarking chipped logging residues : technique and potential impact /');
INSERT INTO new_titles VALUES ('2000/10/19','HE 20.6210/a: V.2/Sec.4','AOE-8423','','Vital statistics of the United States.');
INSERT INTO new_titles VALUES ('2000/10/19','A 13.78:INT-156-166','AOE-8416','Megahan, Walter F.','Erosion over time on severely disturbed granitic soils : a model /');
INSERT INTO new_titles VALUES ('2000/10/19','A 13.78:ITF-20','AOE-8411','Little, Elbert Luther, 1907-','Trees of the Caribbean National Forest, Puerto Rico /');
INSERT INTO new_titles VALUES ('2000/10/19','[sound cassette] HC110.E5 S495 1998','AOE-7352','Shuman, Michael.','Going local self-relaint communities /');
INSERT INTO new_titles VALUES ('2000/10/19','JA71 .V63 2000','AOE-6831','','Vocations of political theory /');
INSERT INTO new_titles VALUES ('2000/10/19','HM881 .S45 2000','AOE-6829','','Self, identity, and social movements /');
INSERT INTO new_titles VALUES ('2000/10/19','QH442.2 .H875 2000','AOE-6821','','Human cloning : science, ethics, and public policy /');
INSERT INTO new_titles VALUES ('2000/10/19','HQ76.3.U52 C67 2000','AOE-6754','Russell, Glenda Marie.','Voted out : the psychological consequences of anti-gay politics /');
INSERT INTO new_titles VALUES ('2000/10/19','E98.F39 N37 2001','AOE-6753','Axtell, James.','Natives and newcomers : the cultural origins of North America /');
INSERT INTO new_titles VALUES ('2000/10/19','SD421.34.A8 F57 2000','AOE-6401','','Fire and sustainable agricultural and forestry development in eastern Indonesia and northern Australia : proceedings of');
INSERT INTO new_titles VALUES ('2000/10/19','QD382.C66 E444 2000','AOE-6239','','Electroactive polymers (EAP) : symposium held November 29-December 1, 1999, Boston, Massachusetts, U.S.A. /');
INSERT INTO new_titles VALUES ('2000/10/19','TK5105.888 .K46 2000','AOE-6135','Kent, Peter, 1957-','Poor Richard\'s web site : geek-free, commonsense advice on building a low cost web site /');
INSERT INTO new_titles VALUES ('2000/10/19','PR5638 .H342 2000','AOE-5889','Harden, Edgar F.','Thackeray the writer : from Pendennis to Denis Duval /');
INSERT INTO new_titles VALUES ('2000/10/19','GE180 .M67 1988','AOE-5180','Morris, David J.','Ecocrisis');
INSERT INTO new_titles VALUES ('2000/10/19','[sound cassette] GF49 .C354 1992','AOE-5178','Caldicott, Helen.','The fate of the earth');
INSERT INTO new_titles VALUES ('2000/10/19','[sound cassette] GF49 .C356 1993','AOE-5177','Caldicott, Helen.','If you love the planet');
INSERT INTO new_titles VALUES ('2000/10/19','[sound cassette] GF49 .C358 1996','AOE-5176','Caldicott, Helen.','Technology, spirituality & the future of the planet');
INSERT INTO new_titles VALUES ('2000/10/19','[sound cassette] GF49 .C353 1997','AOE-5174','Caldicott, Helen.','Ecology and the human spirit');
INSERT INTO new_titles VALUES ('2000/10/19','QH75 .S55 1997','AOE-5136','Shiva, Vandana.','Democracy and biodiversity :');
INSERT INTO new_titles VALUES ('2000/10/19','K1519.B54 S53 1997','AOE-5130','Shiva, Vandana.','Biopiracy the plunder of nature and knowledge /');
INSERT INTO new_titles VALUES ('2000/10/19','TD793.3 .R39 1992','AOE-5124','Rathje, William L.','Rubbish what garbage tells us about ourselves');
INSERT INTO new_titles VALUES ('2000/10/19','TJ163.3 .L69 1989','AOE-5121','Lovins, Amory B., 1947-','Energy efficiency :');
INSERT INTO new_titles VALUES ('2000/10/19','[sound cassette] QL84.2 .F67 1997','AOE-5063','Foreman, David, 1946-','In defense of the wild');
INSERT INTO new_titles VALUES ('2000/10/19','TH439 .S77 2000','AOE-4120','Structural Engineering Institute.','Guideline for structural condition assessment of existing buildings.');
INSERT INTO new_titles VALUES ('2000/10/19','BS531 .L33 1999','AOC-2971','','The labour of reading : desire, alienation, and biblical interpretation /');
INSERT INTO new_titles VALUES ('2000/10/19','RA410.55.E852 L49 2000','ANZ-5122','Lewis, Maureen A., 1952-','Who is paying for health care in Eastern Europe and Central Asia? /');
INSERT INTO new_titles VALUES ('2000/10/19','NA680 .T5413 1999','ANZ-4529','Tietz, Jrgen, 1964-','The story of architecture of the 20th century /');
INSERT INTO new_titles VALUES ('2000/10/19','NK1510 .L38 2000','ANZ-3927','Lauer, David A.','Design basics /');
INSERT INTO new_titles VALUES ('2000/10/19','BJ1289 .H37 2000','ANZ-3855','Harvey, Peter (Brian Peter)','An introduction to Buddhist ethics : foundations, values, and issues /');
INSERT INTO new_titles VALUES ('2000/10/19','HN380.7.A8 D46 2000','ANZ-3848','','Democratic and capitalist transitions in Eastern Europe : lessons for the social sciences /');
INSERT INTO new_titles VALUES ('2000/10/19','HD9743.U6 S54 2000','ANZ-3377','Silverstein, Ken.','Private warriors /');
INSERT INTO new_titles VALUES ('2000/10/19','HQ1190 .F427 2000','ANZ-3847','','Feminism and the body /');
INSERT INTO new_titles VALUES ('2000/10/19','DS385.B44 A65 2000','ANZ-3182','Akhund, Iqbal.','Trial and error : the advent and eclipse of Benazir Bhutto /');
INSERT INTO new_titles VALUES ('2000/10/19','TK5102.9. V37 2000','ANZ-3145','Vaseghi, Saeed V.','Advanced digital signal processing and noise reduction /');
INSERT INTO new_titles VALUES ('2000/10/19','TK5104 .L84 2000','ANZ-3137','Lutz, E. (Erich), 1950-','Satellite systems for personal and broadband communications /');
INSERT INTO new_titles VALUES ('2000/10/19','QD79.I5 T76 2000','ANZ-3127','Trojanowicz, Marek.','Flow injection analysis : instrumentation and applications /');
INSERT INTO new_titles VALUES ('2000/10/19','TA1637 .I42 2000','ANZ-3072','','Image and video databases : restoration, watermarking, and retrieval /');
INSERT INTO new_titles VALUES ('2000/10/19','HV713 .A544 2000','ANZ-3103','Altstein, Howard.','Does family preservation serve a child\'s best interests? /');
INSERT INTO new_titles VALUES ('2000/10/19','TA1677 .R63 2000','ANZ-3012','Robieux, Jean.','High power laser interactions /');
INSERT INTO new_titles VALUES ('2000/10/19','QP552.C42 I83 2000','ANZ-2969','Isacke, Clare.','The adhesion molecule /');
INSERT INTO new_titles VALUES ('2000/10/19','SB741.A7 A76 2000','ANZ-2950','','Armillaria root rot : biology and control of honey fungus /');
INSERT INTO new_titles VALUES ('2000/10/19','GV721.5 .L42 2000','ANZ-2937','Lenskyj, Helen Jefferson, 1943-','Inside the Olympic industry : power, politics, and activism /');
INSERT INTO new_titles VALUES ('2000/10/19','HV875 .A26 2000','ANZ-2929','','Abandoned children /');
INSERT INTO new_titles VALUES ('2000/10/19','[videocassette] DS481.G3 I65 2000','ANZ-2292','','India defying the crown /');
INSERT INTO new_titles VALUES ('2000/10/19','SF761 .A17 2000','ANZ-2893','','300 questions and answers in anatomy and physiology for veterinary nurses /');
INSERT INTO new_titles VALUES ('2000/10/11','SF523 .P5518 1990','AMG-2037','Philippe, Jean M.','Guia del apicultor /');
INSERT INTO new_titles VALUES ('2000/10/11','D 208.109:','AMG-4219','United States Naval Academy.','Catalog /');
INSERT INTO new_titles VALUES ('2000/10/11','SF523 .B6718 1998','AMG-2022','Bonney, Richard E.','Apicultura : gestin y mantenimiento de las colmenas /');
INSERT INTO new_titles VALUES ('2000/10/11','A 13.78:PNW-417-435','AMC-2092','Seidel, Kenneth W.','The influence of cattle grazing and grass seeding on coniferous regeneration after shelterwood cutting in eastern Oregon');
INSERT INTO new_titles VALUES ('2000/10/11','I 19.15/3:M 31','ALO-6909','Geological Survey (U.S.)','Department of the Interior Geological Survey manual.');
INSERT INTO new_titles VALUES ('2000/10/11','HE8700.72.U6 L56 1999','ALN-1622','Linder, Laura R.','Public access television : America\'s electronic soapbox /');
INSERT INTO new_titles VALUES ('2000/10/11','I 19.42/4:84-4074/pt.A-B','ALE-6458','','Drought-related impacts on municipal and major self-supplied industrial water withdrawals in Tennessee, parts A and B /');
INSERT INTO new_titles VALUES ('2000/10/11','E 1.23:','ALA-8104','','Materials & components in fossil energy applications /');
INSERT INTO new_titles VALUES ('2000/10/11','QR186.7 .I36 1998','AKN-7245','','Ig superfamily molecules in the nervous system /');
INSERT INTO new_titles VALUES ('2000/10/11','A 13.78:PSW-124-140','AKY-0892','Nord, Eamor C.','Low-volume and slow-burning vegetation for planting on clearings in California chaparral /');
INSERT INTO new_titles VALUES ('2000/10/11','A 13.78:PSW-141-160','AKJ-9992','Oliver, William W.','Fifteen-year growth patterns after thinning a ponderosa-Jeffrey pine plantation in northeastern California /');
INSERT INTO new_titles VALUES ('2000/10/11','LT5110.M37 R38 1999','AKE-3508','Raven, Peter H.','Biology /');
INSERT INTO new_titles VALUES ('2000/10/11','TD756.5 .C65 1997','AJI-0810','','Constructed wetlands for the management of stormwater runoff');
INSERT INTO new_titles VALUES ('2000/10/11','TA660.P6 P553 1998','AJO-8286','','Plate bending analysis with boundary elements /');
INSERT INTO new_titles VALUES ('2000/10/11','PN3373 .S386','ACI-9210','','Short story criticism');
INSERT INTO new_titles VALUES ('2000/10/11','[Business Alcove] HF53 .M37','ACO-6044','','Market share reporter.');
INSERT INTO new_titles VALUES ('2000/10/11','E185.96 .W47','AID-7087','','Who\'s who among African Americans.');
INSERT INTO new_titles VALUES ('2000/10/11','HC103 .C26 1996','AII-4846','','The Cambridge economic history of the United States /');
INSERT INTO new_titles VALUES ('2000/10/11','QC702 .I5','ACD-2536','International Conference on Phenomena in Ionized Gases.','International Conference on Phenomena in Ionized Gases');
INSERT INTO new_titles VALUES ('2000/10/11','QE1 .J67','ACB-0936','','Irish journal of earth sciences');
INSERT INTO new_titles VALUES ('2000/10/11','SB273.A2 B8','ACB-5271','','Buletinul cultivarei si fermentarei tutunului.');
INSERT INTO new_titles VALUES ('2000/10/11','QE201 .M32','ABM-2500','Anales (Universidad Nacional Autnoma de Mxico. Instituto de Geologa)','Anales');
INSERT INTO new_titles VALUES ('2000/10/11','QL1 .D7','ABL-8583','','Faunistische Abhandlungen /');
INSERT INTO new_titles VALUES ('2000/10/11','HG3881 .I626','AAY-8706','','International financial statistics');
INSERT INTO new_titles VALUES ('2000/10/11','Q21 .N3','AAY-2285','National Research Council of Canada.','Annual report of the National Research Council containing the report of the president and financial statement');
INSERT INTO new_titles VALUES ('2000/10/11','QH1 .F46','AAV-8337','','Contributions of the Florida State Museum.');
INSERT INTO new_titles VALUES ('2000/10/11','HC10 .E34','AAX-3426','','Economic bulletin for Europe /');
INSERT INTO new_titles VALUES ('2000/10/11','QC173 .J65','AAT-0101','','Journal of molecular structure.');
INSERT INTO new_titles VALUES ('2000/10/11','[Reference desk] PN161 .W83','AAV-2818','','The Writer\'s market');
INSERT INTO new_titles VALUES ('2000/10/10','SF271 .V28','AAX-4907','Van Slyke, Lucius L. (Lucius Lincoln), 1859-1931.','Cheese; a treatise on the manufacture of American Cheddar cheese and some other varieties--intended as a text book for t');
INSERT INTO new_titles VALUES ('2000/10/11','TK9180 .H37','AAN-9679','Harrer, Joseph M.','Nuclear power reactor instrumentation systems handbook.');
INSERT INTO new_titles VALUES ('2000/10/10','S631 .E7','AAX-3596','','Die Ernhrung der Pflanze');
INSERT INTO new_titles VALUES ('2000/10/10','S83 .E4','AAW-1148','Circular (Montana Agricultural Experiment Station)','Circular.');
INSERT INTO new_titles VALUES ('2000/10/10','SF604 .A230','AAW-2345','','Acta veterinaria scandinavica');
INSERT INTO new_titles VALUES ('2000/10/10','SK351 .F46','AAV-6665','','Game publication');
INSERT INTO new_titles VALUES ('2000/10/10','SB599 .F6','AAV-4437','Plant pathology circular (Florida. Division of Plant Industry)','Plant pathology circular');
INSERT INTO new_titles VALUES ('2000/10/10','GB459.4 .H57','AAV-3429','','A Historical review of some of North Carolina\'s coastal inlets /');
INSERT INTO new_titles VALUES ('2000/10/10','Q11 .K3','AAU-4085','','Transactions of the Kansas Academy of Science');
INSERT INTO new_titles VALUES ('2000/10/10','QR115 .S7','AAU-3065','Stumbo, C. R. (Charles Raymond), 1914-','Thermobacteriology in food processing');
INSERT INTO new_titles VALUES ('2000/10/10','TD930 .C66 1973','AAS-7480','Cornell University Conference on Agricultural Waste Management (5th : 1973 : Syracuse, N.Y.)','Food processing waste management; [proceedings.');
INSERT INTO new_titles VALUES ('2000/10/10','QK629.P7 S55','AAN-7133','Singer, Rolf.','Die Rhrlinge.');
INSERT INTO new_titles VALUES ('2000/10/10','QR115 .W38','AAP-2157','Weiser, Harry H. (Harry Howard)','Practical food microbiology and technology.');
INSERT INTO new_titles VALUES ('2000/10/10','QC490 .G34','AAM-7659','','Gamma irradiation in Canada.');
INSERT INTO new_titles VALUES ('2000/10/10','F1230 .P963 1873','AAK-3736','Prescott, William Hickling, 1796-1859.','History of the conquest of Mexico,');
INSERT INTO new_titles VALUES ('2000/10/10','SF263 .H8 1927','AAH-5763','Hunziker, Otto Frederick, b. 1873.','The butter industry, prepared for factory, school, and laboratory.');
INSERT INTO new_titles VALUES ('2000/10/10','SF275.A1 W4 1970','AAC-8460','Webb, Byron Horton, 1903-','Byproducts from milk.');
INSERT INTO new_titles VALUES ('2000/10/10','G1019 .G371 1970','AAC-8162','General Drafting Company, inc.','Man\'s domain, a thematic atlas of the world.');
INSERT INTO new_titles VALUES ('2000/10/10','HF5437 .B36','AAB-5112','Barlow, C. Wayne (Clinton Wayne), 1922-','Purchasing for the newly appointed buyer');
INSERT INTO new_titles VALUES ('2000/10/10','CT104.E3 V. 1 MEN OF POWER','','','');
INSERT INTO new_titles VALUES ('2000/10/10','QR115 .T47','AAB-0345','Thatcher, Fred S.','Microorganisms in foods: their significance and methods of enumeration;');
INSERT INTO new_titles VALUES ('2000/10/19','JN450.R38 D47 2000','ANZ-0587','','Designing performance appraisals : assessing needs and designing performance management systems in the public sector /');
INSERT INTO new_titles VALUES ('2000/10/19','JZ5588 .R38 2000','ANZ-0365','','Rational choice and security studies : Stephen Walt and his critics /');
INSERT INTO new_titles VALUES ('2000/10/19','NA1305 .N54 1989','ANY-9481','Nieto Alcaide, Vctor Manuel.','Arquitectura del renacimiento en Espaa, 1488-1599 /');
INSERT INTO new_titles VALUES ('2000/10/19','DS146.U6 B55 2000','ANY-9388','Blakeslee, Spencer, 1935-','The death of American antisemitism /');
INSERT INTO new_titles VALUES ('2000/10/19','PR478.W65 W66 2000','ANY-9374','','Women\'s writing of the First World War : an anthology /');
INSERT INTO new_titles VALUES ('2000/10/19','DG571.A2 P75 2000','ANY-9338','','A primer of Italian fascism /');
INSERT INTO new_titles VALUES ('2000/10/19','QD549 .P38 2000','ANY-6386','Perkowitz, S.','Universal foam : from Cappuccino to the cosmos /');
INSERT INTO new_titles VALUES ('2000/10/19','QA76.76.I59 D75 2000','ANY-7415','Driemeyer, Thomas.','Rendering with mental ray /');
INSERT INTO new_titles VALUES ('2000/10/19','QD321 .L56 2000','ANY-4769','Lindhorst, Thisbe K.','Essentials of carbohydrate chemistry and biochemistry /');
INSERT INTO new_titles VALUES ('2000/10/19','TK454 .N36 1988b','ANY-3877','Nasar, S. A.','Schaum\'s 3000 solved problems in electric circuits /');
INSERT INTO new_titles VALUES ('2000/10/19','F443.G7 W55 2000','ANY-3523','Brown, Margaret Lynn.','The wild east : a biography of the Great Smoky Mountains /');
INSERT INTO new_titles VALUES ('2000/10/19','DA592 .F34 2000','ANY-3513','Fairclough, Norman, 1941-','New Labour, new language? /');
INSERT INTO new_titles VALUES ('2000/10/19','TX357 .G574 1999','ANY-3477','Goldberg, Jake, 1943-','Food : the struggle to sustain the human community /');
INSERT INTO new_titles VALUES ('2000/10/19','GB661.2 .B35 2000','ANY-3471','Ball, Philip, 1962-','Life\'s matrix : a biography of water /');
INSERT INTO new_titles VALUES ('2000/10/19','TK3221 .S48 2000','ANY-0933','Shoemaker, Thomas M., 1921-','Lineman\'s and cableman\'s field manual /');
INSERT INTO new_titles VALUES ('2000/10/19','TR647 .L43 1976','ANY-1497','Lerner, Nathan, 1913-','Nathan Lerner : [photographs, 1935-1945]');
INSERT INTO new_titles VALUES ('2000/10/19','HD58.8 .S728 1998','ANY-0471','Stein, Martin.','Macrologistics management : a catalyst for organizational change /');
INSERT INTO new_titles VALUES ('2000/10/19','RC1130 .R59 2000','ANX-9118','','Review of NASA\'s Biomedical Research Program /');
INSERT INTO new_titles VALUES ('2000/10/19','HC240 .E8177 1999','ANX-7546','','Europe in the international economy 1500 to 2000 /');
INSERT INTO new_titles VALUES ('2000/10/19','HD30.4 .D38 2000','ANX-7590','Davis, Duane, 1950-','Business research for decision making /');
INSERT INTO new_titles VALUES ('2000/10/19','HD5765.A6 P47 2000','ANX-7543','Perry, Matt, 1967-','Bread and work : social policy and the experience of unemployment, 1918-39 /');
INSERT INTO new_titles VALUES ('2000/10/19','BL241 .B76 1998','ANX-7315','Brooke, John Hedley.','Reconstructing nature : the engagement of science and religion /');
INSERT INTO new_titles VALUES ('2000/10/19','R723 .A95 1998','ANX-7310','Azzone, G. F.','Medicine from art to science : the role of complexity and evolution /');
INSERT INTO new_titles VALUES ('2000/10/19','HF1414 .C6617 1999','ANX-7305','','Competition policy, deregulation, and modernization in Latin America /');
INSERT INTO new_titles VALUES ('2000/10/19','I 72.2:ST 8/2000-05','ANW-8525','United States. Minerals Management Service.','Strategic plan, Minerals Management Service fy 2000 - fy 2005.');
INSERT INTO new_titles VALUES ('2000/10/19','EP 1.8:B 12','ANW-8521','','Better backyard a citizen\'s resource guide to beneficial landscaping and habitat restoration in the Chesapeake Bay water');
INSERT INTO new_titles VALUES ('2000/10/19','EP 1.2:G 82/11','ANW-8519','','PAINTING THE TOWN GREEN, ABERDEEN PROVING GROUND\'S PAINT PILOT PROJECT... ENVIRONMENTALLY PREFERABLE PURCHASING PROGRAM');
INSERT INTO new_titles VALUES ('2000/10/19','HE 20.3218:SM 7/4','ANW-8466','','Facts about heart disease and women kicking the smoking habit.');
INSERT INTO new_titles VALUES ('2000/10/19','HE 20.3202:W 89/6','ANW-8465','','Asian American and Pacific Islander workshops summary report on cardiovascular health');
INSERT INTO new_titles VALUES ('2000/10/19','EP 4.2:C 76/7','ANW-8464','','Energy Star homes');
INSERT INTO new_titles VALUES ('2000/10/19','EP 1.8:EM 4/7','ANW-8463','','A guide to the emissions certification procedures for alternative fuel aftermarket conversions');
INSERT INTO new_titles VALUES ('2000/10/19','EP 1.2:L 95/2000/1','ANW-8462','','Low-impact development an integrated design approach /');
INSERT INTO new_titles VALUES ('2000/10/19','EP 1.2:L 95/2000','ANW-8461','','Low-impact development hydrologic analysis companion document to The low-impact development design strategies /');
INSERT INTO new_titles VALUES ('2000/10/19','A 101.10/2:91-55-054','ANW-8460','','NATIONAL POULTRY IMPROVEMENT PLAN AND AUXILIARY PROVISIONS... APHIS 91-55-054... U.S. DEPARTMENT OF AGRICULTURE... MARC');
INSERT INTO new_titles VALUES ('2000/10/16','I 53.11/4-2:39108-A 1-TM-100/999','ANF-5171','United States. Bureau of Land Management.','Colorado : Grand Junction : 1:100,000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 53.11/4-2:39107-E 1-TM-100/999','ANF-5170','United States. Bureau of Land Management.','Colorado : Glenwood Springs : 1:100,000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 53.11/4:39107-E 1-TM-100/999','ANF-5169','United States. Bureau of Land Management.','Colorado : Glenwood Springs : 1:100,000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 53.11/4-2:39106-E 1-TM-100/999','ANF-5166','United States. Bureau of Land Management.','Colorado : Vail : 1:100,000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 53.11/4:39106-E 1-TM-100/999','ANF-5165','United States. Bureau of Land Management.','Colorado : Vail : 1:100,000-scale topographic map : 30 x 60 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','SF396.3 .A53 1995a','ANE-0297','Andersen, Merete.','Particle movements in mechanically ventilated piggeries /');
INSERT INTO new_titles VALUES ('2000/10/16','HB1335 .R644 2000','ALN-1641','Rogers, Richard G.','Living and dying in the USA : behavioral, health, and social differentials of adult mortality /');
INSERT INTO new_titles VALUES ('2000/10/16','QL494 .I5','AMK-0832','','Arthropod structure & development.');
INSERT INTO new_titles VALUES ('2000/10/16','A 13.78:PSW-128','AKY-0898','Powers, Robert F.','Site classification of ponderosa pine stands under stocking control in California /');
INSERT INTO new_titles VALUES ('2000/10/16','S618 .P67 1999','AKN-4703','Postel, Sandra.','Pillar of sand : can the irrigation miracle last? /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.16:1386-B etc.','AKC-9429','','Satellite image atlas of glaciers of the world /');
INSERT INTO new_titles VALUES ('2000/10/16','[Census Area] C 3.266:','AKC-9412','','Federal expenditures by state for fiscal year ... : a report prepared pursuant to the Consolidated Federal Funds Report');
INSERT INTO new_titles VALUES ('2000/10/16','TE24.N82 C8 1998g','AKB-7956','Robinson, Beverly Grate.','Hope Mills bypass from SR 1141 (Bingham Drive) to SR 1132 (Legion Road) Hope Mills, Cumberland County, federal aid proje');
INSERT INTO new_titles VALUES ('2000/10/16','M1473 .C64 1992','AKB-6660','','Cologne - WDR : early electronic music');
INSERT INTO new_titles VALUES ('2000/10/16','M1473.P39 C79 1991','AKB-6708','Payne, Maggi.','Crystal');
INSERT INTO new_titles VALUES ('2000/10/16','HG4521 .B768 1997','AKA-2609','Buffett, Mary.','Buffettology : the previously unexplained techniques that have made Warren Buffett the world\'s most famous investor /');
INSERT INTO new_titles VALUES ('2000/10/16','E185.97.B23 W66 1999','AJW-7068','Woodard, Komozi.','A nation within a nation : Amiri Baraka (LeRoi Jones) and Black power politics /');
INSERT INTO new_titles VALUES ('2000/10/16','S542.G72 A377a','AJQ-9909','','IGER innovations.');
INSERT INTO new_titles VALUES ('2000/10/16','S97 .E28 no. 174 1966','AJS-6644','Aycock, Robert, 1919-','Stem rot and other diseases caused by Sclerotium rolfsii : or the status of Rolfs\' fungus after 70 years /');
INSERT INTO new_titles VALUES ('2000/10/16','TA160.4 .R47','AJP-9318','Research projects (North Carolina State University. College of Engineering)','Research projects /');
INSERT INTO new_titles VALUES ('2000/10/16','SD1 .F69','AJJ-9527','','T`ai-wan lin yeh k`o hseh.');
INSERT INTO new_titles VALUES ('2000/10/16','LC3719 .E85 1998','AJL-9447','','Ethnic identity and power : cultural contexts of political action in school and society /');
INSERT INTO new_titles VALUES ('2000/10/16','K3876 .L47 1997','AJH-7379','Leskien, Dan.','Intellectual property rights and plant genetic resources : options for a sui generis system /');
INSERT INTO new_titles VALUES ('2000/10/16','SB123.3 .A23 1996','AJH-7282','','Access to plant genetic resources and the equitable sharing of benefits : a contribution to the debate on systems for th');
INSERT INTO new_titles VALUES ('2000/10/16','QK981.7 .M56 1995','AJH-7279','','Molecular genetic techniques for plant genetic resources : report of an IPGRI workshop, 9-11 October 1995, Rome, Italy /');
INSERT INTO new_titles VALUES ('2000/10/16','BF692.5 .P78 1996','AIR-6780','','The psychology of men : psychoanalytic perspectives /');
INSERT INTO new_titles VALUES ('2000/10/16','QH671 .C395','AIP-4577','','Cell death and differentiation.');
INSERT INTO new_titles VALUES ('2000/10/16','HD259 .G53 1996','AIJ-4694','Glink, Ilyce R., 1964-','10 steps to home ownership : a workbook for first time buyers /');
INSERT INTO new_titles VALUES ('2000/10/16','BX830 1962 .H55 1995','AIJ-0439','','History of Vatican II /');
INSERT INTO new_titles VALUES ('2000/10/16','HG4028.V3 D353 1996','AIE-2659','Damodaran, Aswath.','Investment valuation : tools and techniques for determining the value of any asset /');
INSERT INTO new_titles VALUES ('2000/10/16','HC103 .C26 1996','AII-4846','','The Cambridge economic history of the United States /');
INSERT INTO new_titles VALUES ('2000/10/16','QH611 .Z43','AIC-7395','','Histochemistry and cell biology.');
INSERT INTO new_titles VALUES ('2000/10/16','QA76.9.A73 P377 1996','AIE-1983','Patterson, David A.','Computer architecture : a quantitative approach /');
INSERT INTO new_titles VALUES ('2000/10/16','TT679 .W5','AIA-7113','','Maschen Industrie.');
INSERT INTO new_titles VALUES ('2000/10/16','QD471 .M34','AHZ-9740','','Macromolecular rapid communications.');
INSERT INTO new_titles VALUES ('2000/10/16','QH445.2 .G47','AHZ-6470','','Genomics.');
INSERT INTO new_titles VALUES ('2000/10/16','QH541.5.R27 U85 1995','AHZ-6981','','The Tropical rain forest utilization & destruction /');
INSERT INTO new_titles VALUES ('2000/10/16','QP121.A1 A48','AGD-8786','','American journal of respiratory cell and molecular biology : an official journal of the American Thoracic Society, medic');
INSERT INTO new_titles VALUES ('2000/10/16','QR1 .A35','AGC-3265','','Acta microbiologica et immunologica Hungarica.');
INSERT INTO new_titles VALUES ('2000/10/16','QC760.52 .P76 1993','AFZ-8606','','Problems and solutions on electromagnetism /');
INSERT INTO new_titles VALUES ('2000/10/16','HT392 .S740','AFW-6074','State planning issues (Washington, D.C.)','State planning issues.');
INSERT INTO new_titles VALUES ('2000/10/16','HV5825 .W381264 1994','AFV-9048','Walters, Glenn D.','Drugs and crime in lifestyle perspective /');
INSERT INTO new_titles VALUES ('2000/10/16','QD549 .C632','AFP-4430','','Colloids and surfaces.');
INSERT INTO new_titles VALUES ('2000/10/16','& span AJK1383','AFA-1736','','');
INSERT INTO new_titles VALUES ('2000/10/16','QD471 .J634','ACQ-9183','','Journal of macromolecular science.');
INSERT INTO new_titles VALUES ('2000/10/16','E185.97.K5 A2 1992','ACQ-8824','King, Martin Luther, Jr., 1929-1968.','The papers of Martin Luther King, Jr. /');
INSERT INTO new_titles VALUES ('2000/10/16','SB273.A2 L35','ACQ-1983','Ttigkeitsbericht (Landesanstalt fr Pflanzenbau Forchheim)','Ttigkeitsbericht');
INSERT INTO new_titles VALUES ('2000/10/16','TP1101 .B73','ACP-0467','','Polymer international');
INSERT INTO new_titles VALUES ('2000/10/16','TP1 .P84','ACO-0385','','Process safety and environmental protection : transactions of the Institution of Chemical Engineers, Part B');
INSERT INTO new_titles VALUES ('2000/10/16','SF199.S6 A45','ACN-2135','','Sire summary');
INSERT INTO new_titles VALUES ('2000/10/16','QD71 .Z3','ACN-3245','','Fresenius\' journal of analytical chemistry');
INSERT INTO new_titles VALUES ('2000/10/16','TS1300 .B27','ACM-5026','','Band- und Flechtindustrie');
INSERT INTO new_titles VALUES ('2000/10/16','QH540 .E279','ACL-8200','','Ecological economics : the journal of the International Society for Ecological Economics');
INSERT INTO new_titles VALUES ('2000/10/16','[Business Alcove] HD2721 .I57','ACL-0021','','International directory of company histories /');
INSERT INTO new_titles VALUES ('2000/10/16','QL1 .I5','ACH-8615','International Congress of Zoology.','Proceedings');
INSERT INTO new_titles VALUES ('2000/10/16','QH426 .G466','ACG-7203','','Genes & development');
INSERT INTO new_titles VALUES ('2000/10/16','QP187.3.M64 M63','ACF-6112','Molecular endocrinology (Baltimore, Md.)','Molecular endocrinology.');
INSERT INTO new_titles VALUES ('2000/10/16','QL507.1 .O78','ACF-4776','','Orthoptera of Western North America subfamily Acridinae, technical bulletin');
INSERT INTO new_titles VALUES ('2000/10/16','Z678 .L37','ACF-3561','','Library administration & management');
INSERT INTO new_titles VALUES ('2000/10/16','S543.R6 A23','ACC-8467','Report for ... (Rothamsted Experimental Station)','Report for ... /');
INSERT INTO new_titles VALUES ('2000/10/16','QH506 .B363','ACA-9098','','Bioessays');
INSERT INTO new_titles VALUES ('2000/10/16','S15 .L28','ACA-9062','Revista de la Facultad de Agronoma (La Plata, Argentina)','Revista de la Facultad de Agronoma');
INSERT INTO new_titles VALUES ('2000/10/16','HG41 .Q33','ABZ-7384','','Financial statistics of Japan');
INSERT INTO new_titles VALUES ('2000/10/16','PR2965 .S43 1984','ABZ-4047','','Shakespearean criticism : excerpts from the criticism of William Shakespeare\'s plays and poetry, from the first publishe');
INSERT INTO new_titles VALUES ('2000/10/16','HD5725.N8 N67','ABV-3373','','North Carolina preliminary civilian labor force estimates.');
INSERT INTO new_titles VALUES ('2000/10/16','QH506 .E46','ABU-8712','','The EMBO journal');
INSERT INTO new_titles VALUES ('2000/10/16','QH545.A1 E594','ABU-2105','','Environmental toxicology and chemistry /');
INSERT INTO new_titles VALUES ('2000/10/16','QD1 .P64','ABT-1358','','Polyhedron');
INSERT INTO new_titles VALUES ('2000/10/16','HT405.F3 A45','ABR-5887','Farm Foundation (Chicago, Ill.)','Annual report.');
INSERT INTO new_titles VALUES ('2000/10/16','QL671 .C28','ABS-8712','','Abstract of the proceedings of the Delaware Valley Ornithological Club of Philadelphia');
INSERT INTO new_titles VALUES ('2000/10/16','JA1.A1 R47','ABQ-9562','','International review of administrative sciences.');
INSERT INTO new_titles VALUES ('2000/10/16','HD28 .P36','ABP-9622','Paper (Krannert Graduate School of Management. Institute for Research in the Behavioral, Economic, and Management Sciences)','Paper');
INSERT INTO new_titles VALUES ('2000/10/16','QE1 .B6437','ABO-8964','','Brigham Young University geology studies');
INSERT INTO new_titles VALUES ('2000/10/16','QK1 .O7','ABO-2077','','Oregon State monographs.');
INSERT INTO new_titles VALUES ('2000/10/16','QE169 .A33','ABO-4229','Circular (Utah Geological and Mineralogical Survey)','Circular');
INSERT INTO new_titles VALUES ('2000/10/16','QH301 .B37t','ABN-9985','','Biological abstracts/RRM');
INSERT INTO new_titles VALUES ('2000/10/16','HD9969.H6 H6','ABN-7522','','Knitting international');
INSERT INTO new_titles VALUES ('2000/10/16','TS1828 .N680','ABM-4272','','Nonwovens report international');
INSERT INTO new_titles VALUES ('2000/10/16','TP986.A1 M5','ABM-3573','','Modern plastics.');
INSERT INTO new_titles VALUES ('2000/10/16','RC583 .S67','ABK-8785','','Springer seminars in immunopathology');
INSERT INTO new_titles VALUES ('2000/10/16','QD380 .P6365','ABM-1524','Polymer bulletin (Berlin, Germany)','Polymer bulletin');
INSERT INTO new_titles VALUES ('2000/10/16','TS1828 .N66','ABJ-6051','','Nonwovens industry');
INSERT INTO new_titles VALUES ('2000/10/16','TS1300 .J37','ABK-0340','','JTN');
INSERT INTO new_titles VALUES ('2000/10/16','QK1 .C29','ABC-0321','','Canadian journal of botany');
INSERT INTO new_titles VALUES ('2000/10/16','T178 .I4','ABH-7610','','Summary of engineering research');
INSERT INTO new_titles VALUES ('2000/10/16','TP156.P6 P6','ABB-9241','','Polymer');
INSERT INTO new_titles VALUES ('2000/10/16','T58.A2 I43','ABB-9151','Industrial management (Chicago, Ill.)','Industrial management');
INSERT INTO new_titles VALUES ('2000/10/16','RC633.A1 T47','ABB-8075','','Thrombosis and haemostasis');
INSERT INTO new_titles VALUES ('2000/10/16','HD9130.3 .T55','ABB-6165','','World tobacco directory');
INSERT INTO new_titles VALUES ('2000/10/16','QH601 .J65','AAZ-2259','','The Journal of membrane biology');
INSERT INTO new_titles VALUES ('2000/10/16','QR1 .J6','AAZ-2316','','Journal of bacteriology');
INSERT INTO new_titles VALUES ('2000/10/16','F206 .S643','AAZ-2205','Southern exposure (Atlanta, Ga.)','Southern exposure');
INSERT INTO new_titles VALUES ('2000/10/16','RM301 .D75','AAZ-1437','','Drug metabolism and disposition : a publication of the American Society for Pharmacology and Experimental Therapeutics');
INSERT INTO new_titles VALUES ('2000/10/16','QE1 .O7','AAZ-1131','','Oregon State monographs.');
INSERT INTO new_titles VALUES ('2000/10/16','QR360 .J68','AAZ-1333','','Journal of virology');
INSERT INTO new_titles VALUES ('2000/10/16','RB1 .N32','AAZ-0583','','Naunyn-Schmiedeberg\'s archives of pharmacology');
INSERT INTO new_titles VALUES ('2000/10/16','SF601 .V45','AAZ-0355','','The Veterinary record the official journal of the National Veterinary Medical Association of Great Britain and Ireland.');
INSERT INTO new_titles VALUES ('2000/10/16','QD71 .T3','AAZ-0174','Talanta (London, England)','Talanta');
INSERT INTO new_titles VALUES ('2000/10/16','TL151 .S62','AAY-9911','','SAE handbook');
INSERT INTO new_titles VALUES ('2000/10/16','TP890 .S6','AAZ-0033','','Journal of the Society of Dyers and Colourists.');
INSERT INTO new_titles VALUES ('2000/10/16','HG136 .P7','AAY-9694','','Essays in international finance');
INSERT INTO new_titles VALUES ('2000/10/16','QC721 .P43','AAY-9607','','Physical review.');
INSERT INTO new_titles VALUES ('2000/10/16','QL494 .I5','AAY-8721','','International journal of insect morphology & embryology.');
INSERT INTO new_titles VALUES ('2000/10/16','QH431 .H43','AAY-8454','','Heredity');
INSERT INTO new_titles VALUES ('2000/10/16','QD71 .A47','AAY-6215','','Analytica chimica acta');
INSERT INTO new_titles VALUES ('2000/10/16','QL1 .L6','AAY-3603','','The Journal of the Linnean Society.');
INSERT INTO new_titles VALUES ('2000/10/16','QH301 .B8','AAX-9203','','Bulletins of marine ecology');
INSERT INTO new_titles VALUES ('2000/10/16','QL403 .J65','AAX-7501','','Johnsonia');
INSERT INTO new_titles VALUES ('2000/10/16','R11 .N48','AAX-5757','','The New England journal of medicine');
INSERT INTO new_titles VALUES ('2000/10/16','S964.U6 N35','AAX-5751','','National wildlife');
INSERT INTO new_titles VALUES ('2000/10/16','Q1 .N2','AAX-5606','Nature (London, England)','Nature.');
INSERT INTO new_titles VALUES ('2000/10/16','QH301 .C4','AAX-2052','','Ceylon journal of science.');
INSERT INTO new_titles VALUES ('2000/10/16','QH581 .E9','AAX-3661','','Experimental cell research');
INSERT INTO new_titles VALUES ('2000/10/16','QL671 .C28','AAX-2018','','Cassinia');
INSERT INTO new_titles VALUES ('2000/10/16','RD78.3 .A54','AAW-4331','','Anesthesia and analgesia');
INSERT INTO new_titles VALUES ('2000/10/16','RD79.A1 A6','AAW-4332','Anesthesiology (American Society of Anesthesiologists).','Anesthesiology the journal of the American Society of Anesthesiologists, Inc.');
INSERT INTO new_titles VALUES ('2000/10/16','QD71 .A52','AAW-4326','','Analytical chemistry.');
INSERT INTO new_titles VALUES ('2000/10/16','RE1 .A4','AAW-4176','','American journal of ophthalmology');
INSERT INTO new_titles VALUES ('2000/10/16','RC60 .A64','AAW-4173','','The American journal of medicine');
INSERT INTO new_titles VALUES ('2000/10/16','QH431.A2 A5','AAW-4168','','The American journal of human genetics');
INSERT INTO new_titles VALUES ('2000/10/16','KF4502 .D63','AAV-3322','','The Documentary history of the ratification of the Constitution /');
INSERT INTO new_titles VALUES ('2000/10/16','RA1190 .C24','AAV-0878','','CRC critical reviews in toxicology');
INSERT INTO new_titles VALUES ('2000/10/16','QD471 .M17','AAU-3259','','Macromolecules.');
INSERT INTO new_titles VALUES ('2000/10/16','QK564 .I5','AAU-5237','International Seaweed Symposium.','Proceedings of the International Seaweed Symposium');
INSERT INTO new_titles VALUES ('2000/10/16','QC612.S4 W5','AAH-3698','Willardson, Robert K.','Semiconductors and semimetals /');
INSERT INTO new_titles VALUES ('2000/10/19','RC684.C48 K38 1999','ANW-7330','Khan, M. I. Gabriel.','Cardiac drug therapy /');
INSERT INTO new_titles VALUES ('2000/10/19','RC530 .H65 1999','ANS-3300','Horney, Karen, 1885-1952.','Neurosis and human growth : the struggle toward self-realization /');
INSERT INTO new_titles VALUES ('2000/10/19','RC623 .S73 1999','ANS-3296','Stekel, Wilhelm, 1868-1940.','Conditions of nervous anxiety and their treatment /');
INSERT INTO new_titles VALUES ('2000/10/19','TS1480 .C34 1989','ANS-1672','Cahill, Neil.','Move to world class spinning industry worldwide /');
INSERT INTO new_titles VALUES ('2000/10/19','RJ506.C65 G373 1999','ANR-6613','Gardner, Richard A.','Psychotherapy of antisocial behavior and depression in adolescense /');
INSERT INTO new_titles VALUES ('2000/10/19','[DVD] PN1993.5.I829 E49 2000','ANR-4634','','Ek yaad Rafi ke baad');
INSERT INTO new_titles VALUES ('2000/10/19','[DVD] PN1993.5.I829 P385 1998','ANR-4622','','Patita');
INSERT INTO new_titles VALUES ('2000/10/19','[DVD] PN1993.5.I829 S444 2000','ANR-4631','','Shaheed-e-mohabbat Boota Singh (a true story) /');
INSERT INTO new_titles VALUES ('2000/10/19','[DVD] PN1993.5.I829 S2848 1998','ANR-4591','','Satya the other side of truth /');
INSERT INTO new_titles VALUES ('2000/10/19','DS146.U6 Z35 2000','ANQ-7158','Zakim, Leonard P.','Confronting anti-semitism : a practical guide /');
INSERT INTO new_titles VALUES ('2000/10/19','HQ1822 .C377 1999','ANQ-1094','','Carrying the banner : women, leadership and activism in Australia /');
INSERT INTO new_titles VALUES ('2000/10/19','[sound cassette] SF203 .N87 1998','ANE-0546','','Nutrafacts on tape biotin supplementation in dairy cattle for optimum hoof health /');
INSERT INTO new_titles VALUES ('2000/10/19','NK2047.6.C65 J66 1989','AND-7661','Jones, Chester.','Colefax & Fowler : the best in English interior decoration /');
INSERT INTO new_titles VALUES ('2000/10/19','TX715 .B487 1999','AMX-2325','','The best recipe /');
INSERT INTO new_titles VALUES ('2000/10/19','A 13.78:INT-456-469','AMH-0778','Moeur, Melinda.','Baseline demographics of late successional western hemlock/western redcedar stands in northern Idaho research natural ar');
INSERT INTO new_titles VALUES ('2000/10/19','A 13.78:INT-411-435','AMC-0337','Latham, Don J.','Ignition probabilities of wildland fuels based on simulated lightning discharges /');
INSERT INTO new_titles VALUES ('2000/10/19','A 13.78:INT-436-455','AMB-9653','Clayton, James L. (James Lindow), 1942-','Soil disturbance resulting from skidding logs on granitic soils in central Idaho /');
INSERT INTO new_titles VALUES ('2000/10/19','I 29.86/2:','ALS-0592','','CRM [bulletin].');
INSERT INTO new_titles VALUES ('2000/10/19','A 13.78:INT-386-410','ALQ-9913','Hoff, R. J. (Raymond J.)','Susceptibility of ponderosa pine to the needle cast fungus Lophodermium baculiferum /');
INSERT INTO new_titles VALUES ('2000/10/19','A 13.78:INT-351-385','ALJ-9364','Benson, Robert Earl, 1931-','Costs of managing nontimber resources when harvesting timber in the northern Rockies /');
INSERT INTO new_titles VALUES ('2000/10/19','MF NC DOCS G67 2:P96 1999','ALH-1721','North Carolina Water Resources Research Conference (1999 : Raleigh, N.C.)','North Carolina resources water quality trends and enhancement : proceedings of the annual North Carolina Water Resources');
INSERT INTO new_titles VALUES ('2000/10/19','A 13.78:INT-320-350','ALB-9360','Schuster, Ervin G.','Evaluating nonindustrial private landowners for forestry assistance programs : a logistic regression approach /');
INSERT INTO new_titles VALUES ('2000/10/19','A 13.78:INT-206-215','AKZ-9948','Albini, F. A. (Frank A.)','Predicting slash depth for fire modeling /');
INSERT INTO new_titles VALUES ('2000/10/19','A 13.78:ITF-23','AKZ-7282','Whitmore, Jacob L.','Mahogany (Swietenia) hybrids /');
INSERT INTO new_titles VALUES ('2000/10/19','A 13.78:ITF-22','AKZ-7280','Crow, Thomas R.','Tree growth in a moist tropical forest of Puerto Rico /');
INSERT INTO new_titles VALUES ('2000/10/19','QL737.C4 W442 1999','AKW-1770','','Whales, dolphins and porpoises /');
INSERT INTO new_titles VALUES ('2000/10/19','A 13.78:INT-216-228','AKL-5852','Kelsey, Rick G.','A search for phytotoxins influencing germination and early growth of ponderosa pine /');
INSERT INTO new_titles VALUES ('2000/10/18','','AOE-8407','Ulmer, Jeffrey T. and John H. Kramer','The Use and Transformation of Formal Decision-Making Criteria: Sentencing Guidelines, Organizational Contexts, and Case');
INSERT INTO new_titles VALUES ('2000/10/18','','AOE-8401','Packer, Herbert L.','Two Models of the Criminal Process');
INSERT INTO new_titles VALUES ('2000/10/18','','AOE-8403','Cole, George F.','The Decision to Prosecute');
INSERT INTO new_titles VALUES ('2000/10/18','','AOE-8405','Hagan, John','Why is there so little Criminal Justice Theory: Neglected Macro- and Micro-Level Links Between Organization and Power');
INSERT INTO new_titles VALUES ('2000/10/18','','AOE-8399','Mazur, Beth','Revisiting Plain Language');
INSERT INTO new_titles VALUES ('2000/10/18','','AOE-8397','Zimmerman, Beverly B. and Jessica R. Schultz','Study of the Effectiveness of Information Design Principles Applied to Clinical Research Questionnaires');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:ITF-10-18','AOE-8342','Chudnoff, Martin.','Preservative treatments and service life of fence posts in Puerto Rico : 1969 progress report /');
INSERT INTO new_titles VALUES ('2000/10/18','','AOE-8395','Redish, Janice C. (Ginny)','What Is Information Design?');
INSERT INTO new_titles VALUES ('2000/10/18','HD9750.1 .R33','AOE-8340','','Random lengths international.');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:ITF-1-9','AOE-8330','Chudnoff, Martin.','Preservative treatments and service life of fence posts in Puerto Rico /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:LS-11-21','AOE-8316','MacAloney, Harvey John, 1896-','Identification of hardwood insects by type of tree injury, north-central region');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:LS-1-10','AOE-8304','Roe, Eugene I. (Eugene Irving), 1904-','Seed stored in cones of some jack pine stands, northern Minnesota /');
INSERT INTO new_titles VALUES ('2000/10/18','LT4210.S37 M38 2000 vol. 1','AOE-8243','','McGraw-Hill reading.');
INSERT INTO new_titles VALUES ('2000/10/18','','AOE-8135','Steiner, Fredrick','Plan and Design Implementation(Ch 10) - Part II');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-487','AOE-8225','Miller, Richard E.','Initial and continued effects of a release spray in a coastal Oregon Douglas-fir plantation /');
INSERT INTO new_titles VALUES ('2000/10/18','','AOE-8132','Steiner, Fredrick','Plan and Design Implementation (Ch 10) - Part I');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-RP-436-450','AOE-8130','Haynes, Richard W.','Monthly stumpage prices for the Pacific Northwest /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-350-370','AOE-8126','Schallau, Con H.','Economic impacts of interregional competition in the forest products industry during the 1970\'s : the South and the Paci');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-324','AOE-8119','Nystrom, Michael Nels.','Development of young growth western redcedar stands /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-323','AOE-8117','Williamson, Richard L.','Levels-of-growing-stock cooperative study in Douglas-fir.');
INSERT INTO new_titles VALUES ('2000/10/18','Y 3.N 88:58/0182','AOE-8077','Seul, K. W.','Application of RELAP5/MOD3.2 to the loss-of-residual-heat-removal event under shutdown condition');
INSERT INTO new_titles VALUES ('2000/10/18','Y 3.N 88:10/1700','AOE-8076','Pittiglio, C. L.','Standard review plan for evaluating nuclear power reactor license termination plans final report /');
INSERT INTO new_titles VALUES ('2000/10/13','HD9502.A2 I577','ABM-1233','International Energy Agency.','Energy policies and programmes of IEA countries.');
INSERT INTO new_titles VALUES ('2000/10/13','NA9 .L6','ABG-3260','','Lotus international.');
INSERT INTO new_titles VALUES ('2000/10/13','HD9688.U53 N62','ABL-4203','North Carolina. Rural Electrification Authority.','Annual progress report of rural electrification in North Carolina');
INSERT INTO new_titles VALUES ('2000/10/13','SH1 .Y4','ABD-2762','','Yearbook of fishery statistics');
INSERT INTO new_titles VALUES ('2000/10/13','SH334 .O74','AAZ-2264','','Review of fisheries in OECD member countries');
INSERT INTO new_titles VALUES ('2000/10/13','QP141.A1 W59','AAZ-0453','World review of nutrition and dietetics (New York, N.Y.).','World review of nutrition and dietetics');
INSERT INTO new_titles VALUES ('2000/10/13','PR2986 .S52','AAY-9970','Shakespeare Jahrbuch (Weimar, Germany)','Shakespeare-Jahrbuch');
INSERT INTO new_titles VALUES ('2000/10/13','NA1 .P3','AAX-5794','Perspecta (New Haven, Conn.).','Perspecta');
INSERT INTO new_titles VALUES ('2000/10/13','RD701 .C550','AAX-2161','','Clinical orthopaedics and related research');
INSERT INTO new_titles VALUES ('2000/10/13','QL461 .A45','AAW-4109','','Contributions of the American Entomological Institute');
INSERT INTO new_titles VALUES ('2000/10/12','QA76.58 .P49 1998','AJI-8480','Pfister, Gregory F.','In search of clusters /');
INSERT INTO new_titles VALUES ('2000/10/12','[Business Alcove] HG9655 .B5','AJP-9817','','Best\'s insurance reports.');
INSERT INTO new_titles VALUES ('2000/10/12','GC535 .S27 1995','AIN-5392','','The Sargasso Sea : ocean desert');
INSERT INTO new_titles VALUES ('2000/10/12','QH95.55.G7 G74 1995','AIN-5398','','The Great Barrier Reef');
INSERT INTO new_titles VALUES ('2000/10/12','[Metal Cabinet-Ask at Ref Desk] TL162 .K44','AII-4450','','Kelley blue book.');
INSERT INTO new_titles VALUES ('2000/10/12','QE282 .A22','AFY-6282','','Ser. Ba.');
INSERT INTO new_titles VALUES ('2000/10/12','PN661 .C42','ACI-9602','','Classical and medieval literature criticism');
INSERT INTO new_titles VALUES ('2000/10/12','QL5 .H67 1901','ACH-2536','Horvth, Gza, 1847-1937.','Zichy Jeno grof harmadik azsiai utazasanak allattani eredmenyei /');
INSERT INTO new_titles VALUES ('2000/10/12','S533 .V47','ACE-9938','','Veterinary medical school admission requirements in the United States and Canada /');
INSERT INTO new_titles VALUES ('2000/10/12','HC10 .W66','ACE-4586','','World resources.');
INSERT INTO new_titles VALUES ('2000/10/12','Z682.3 .A42','ACA-0384','','ALA survey of librarian salaries');
INSERT INTO new_titles VALUES ('2000/10/12','HC240.A1 U47','ABW-4718','Economic survey of Europe in ... (Geneva, Switzerland : 1953)','Economic survey of Europe in ... /');
INSERT INTO new_titles VALUES ('2000/10/12','HD6504 .D64','ABV-9991','','Directory of U.S. labor organizations');
INSERT INTO new_titles VALUES ('2000/10/12','[Law Alcove] KFN7430 1981 .A26','ABT-7162','North Carolina.','Advance annotation service to the general statutes of North Carolina');
INSERT INTO new_titles VALUES ('2000/10/12','QK527 .M66 1855','ABQ-1817','Moore, Thomas, 1821-1887.','The ferns of Great Britain and Ireland.');
INSERT INTO new_titles VALUES ('2000/10/12','SB612.A2 N62','ABL-3226','','Proceedings of the ... annual meeting of the Northeastern Weed Science Society');
INSERT INTO new_titles VALUES ('2000/10/12','[Reference Desk] L112 .A35','ABG-5901','','Digest of education statistics.');
INSERT INTO new_titles VALUES ('2000/10/12','[Business Alcove] HG4905 .M815','ABE-7856','','Moody\'s handbook of common stocks');
INSERT INTO new_titles VALUES ('2000/10/12','QE1 .J35','ABB-9143','','Japanese journal of geology and geography');
INSERT INTO new_titles VALUES ('2000/10/12','HG1626 .T4910','ABB-8595','','The Thorndike encyclopedia of banking and financial tables.');
INSERT INTO new_titles VALUES ('2000/10/12','QD516 .S92','ABA-8701','Symposium (International) on Combustion.','Symposium (International) on Combustion [papers]');
INSERT INTO new_titles VALUES ('2000/10/12','HD9820.3 .I57','AAZ-2219','','International pulp & paper directory');
INSERT INTO new_titles VALUES ('2000/10/12','Z1000 .B75','AAX-0444','','Bookman\'s price index');
INSERT INTO new_titles VALUES ('2000/10/12','QE81 .A11','AAW-4012','Monograph (Geological Survey of Alabama)','Monograph /');
INSERT INTO new_titles VALUES ('2000/10/12','Q4 .A3','AAW-2244','','Revista de la Academia colombiana de ciencias exactas, fsicas y naturales.');
INSERT INTO new_titles VALUES ('2000/10/12','LB2338 .G72','AAV-7650','','The Grants register');
INSERT INTO new_titles VALUES ('2000/10/12','BF698.5 .B87','AAC-0423','Buros, Oscar Krisen, 1905-','Personality tests and reviews : including an index to The mental measurements yearbooks /');
INSERT INTO new_titles VALUES ('2000/10/18','Y 3.N 88:10/1600/2000','AOE-8075','U.S. Nuclear Regulatory Commission.','General statement of policy and procedure for NRC enforcement actions enforcement policy, May 1, 2000.');
INSERT INTO new_titles VALUES ('2000/10/18','','AOE-8016','Steiner,Fredrick','Landscape Plans(Ch 7)');
INSERT INTO new_titles VALUES ('2000/10/18','','AOE-8023','Daniels, Tom','Managing Growth in Fringe Countryside(Ch 10)');
INSERT INTO new_titles VALUES ('2000/10/18','','AOE-7942','Porter,Douglas R.','Growth Management:What it is and What it Does(ch.1)');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW 177-193','AOE-8010','Fahey, Thomas D. (Thomas Daniel), 1935-','Lumber recovery from second-growth Douglas-fir /');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-165-176','AOE-7930','Miller, Richard E.','Seven-year response of 35-year-old Douglas-fir to nitrogen fertilizer /');
INSERT INTO new_titles VALUES ('2000/10/18','Desk File','AOE-7926','','Microbial Genetics. Lecture #23[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-210-228','AOE-7847','Williamson, Richard L.','Levels-of-growing-stock cooperative study in Douglas-fir.');
INSERT INTO new_titles VALUES ('2000/10/18','A 13.78:PNW-151-164','AOE-7878','','New timber cruising grades for coast douglas-fir /');
INSERT INTO new_titles VALUES ('2000/10/18','L 2.121/13:C 43/','AOE-7503','','Occupational compensation survey--pay and benefits.');
INSERT INTO new_titles VALUES ('2000/10/18','L 2.121/9:M 58/','AOE-7591','','Occupational compensation survey--pay and benefits.');
INSERT INTO new_titles VALUES ('2000/10/18','PS3553.O514255 W4 2000','AOE-6849','Connor, Joan.','We who live apart : stories /');
INSERT INTO new_titles VALUES ('2000/10/18','PS3558.E4762 Z47 2000','AOE-6841','Heller, Michael, 1937-','Living root : a memoir /');
INSERT INTO new_titles VALUES ('2000/10/18','P291 .K36 2000','AOE-6842','Kayne, Richard S.','Parameters and universals /');
INSERT INTO new_titles VALUES ('2000/10/18','E467.1.J73 R58 2000','AOE-6840','Roland, Charles Pierce, 1918-','Jefferson Davis\'s greatest general : Albert Sidney Johnston /');
INSERT INTO new_titles VALUES ('2000/10/18','PR6019.O9 Z535 2000','AOE-6838','Burns, Christy L.','Gestural politics : stereotype and parody in Joyce /');
INSERT INTO new_titles VALUES ('2000/10/18','PS325 .B35 2000','AOE-6839','Baker, David, 1954-','Heresy and the ideal : on contemporary poetry /');
INSERT INTO new_titles VALUES ('2000/10/18','PR4556 .W45 2000','AOE-6834','Welsh, Alexander.','Dickens redressed : the art of Bleak house and Hard times /');
INSERT INTO new_titles VALUES ('2000/10/18','BF720.V57 A85 2000','AOE-6833','Atkinson, Janette.','The developing visual brain /');
INSERT INTO new_titles VALUES ('2000/10/18','PR5908.L5 G53 2000','AOE-6794','Gibson, Matthew, 1967-','Yeats, Coleridge, and the romantic sage /');
INSERT INTO new_titles VALUES ('2000/10/18','P291 .H246 2001','AOE-6787','','The handbook of contemporary syntactic theory /');
INSERT INTO new_titles VALUES ('2000/10/18','PS374.S35 S333 2000','AOE-6770','','Science fiction, critical frontiers /');
INSERT INTO new_titles VALUES ('2000/10/16','Desk File','AOE-7010','','ENG111 Colby readings. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/16','','AOE-6749','Berger, Arthur Asa','Sex as Symbol in Fashion Advertising and Analyzing Signs and Sign Systems');
INSERT INTO new_titles VALUES ('2000/10/16','','AOE-6745','Solomon, Jack','Masters of Desire: The Culture of American Advertising');
INSERT INTO new_titles VALUES ('2000/10/16','','AOE-6747','Williamson, Judith','Introduction: \'Meaning and Ideology\'');
INSERT INTO new_titles VALUES ('2000/10/16','','AOE-6741','Chartier, Roger','Text, Symbols. amd Frenchness');
INSERT INTO new_titles VALUES ('2000/10/16','','AOE-6739','Geertz, Clifford','Thick Description: Toward an Interpretive Theory of Culture (Ch.1)');
INSERT INTO new_titles VALUES ('2000/10/16','LT4210.H37 F37 2000','AOE-6664','Farr, Roger C.','Collections. a Harcourt reading ; language arts program.');
INSERT INTO new_titles VALUES ('2000/10/16','LD3921 Elec. & Computer Eng. W425','AOE-6610','Weintraub, Chad Everett, 1972-','Investigation of charge pumping techniques for advanced gate dielectrics /');
INSERT INTO new_titles VALUES ('2000/10/16','LD3921 Ind. Eng. U559','AOE-6609','Unnanon, Kittinan, 1968-','Adaptive slicing for the 3D Plotting rapid prototyping process /');
INSERT INTO new_titles VALUES ('2000/10/16','LD3921 Tex. Eng., Chem. & Sci. S697','AOE-6608','Sood, Vikas Kumar, 1968-','Research into the effect of ultrasound in dyeing of cotton fabrics with reactive dyes /');
INSERT INTO new_titles VALUES ('2000/10/16','LD3921 Food Sci. V371','AOE-6607','Vardhanabhuti, Bongkosh, 1967-','Polymerized whey protein isolates : characterization, rheological and gelation properties /');
INSERT INTO new_titles VALUES ('2000/10/16','','AOE-6500','Pastalan, Leon A. and Valerie Polakow','Life Space Over the Life Span');
INSERT INTO new_titles VALUES ('2000/10/16','','AOE-6498','Korosec-Serfaty, Perla','Home From Attic to Cellar');
INSERT INTO new_titles VALUES ('2000/10/16','Multimedia','AOE-6491','','LCD #2');
INSERT INTO new_titles VALUES ('2000/10/16','Multimedia','AOE-6495','','LCD #3');
INSERT INTO new_titles VALUES ('2000/10/16','Multimedia','AOE-6487','','LCD #1');
INSERT INTO new_titles VALUES ('2000/10/16','','AOE-6489','Feldman, Martha S.','Introduction (1) and Conclusion (6)');
INSERT INTO new_titles VALUES ('2000/10/16','','AOE-6485','Strauss, Anselm L.','Introduction (Ch.1)');
INSERT INTO new_titles VALUES ('2000/10/16','','AOE-6483','Downing, Frances','Image Banks: Dialogues Between the Past and the Future');
INSERT INTO new_titles VALUES ('2000/10/16','','AOE-6458','Jongman, Rob. H.G.','Landscape Ecology in Land Use Planning');
INSERT INTO new_titles VALUES ('2000/10/16','','AOE-6481','Brenner, Michael et al','Introduction');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.16:1177-B/986','AOE-6446','Dolan, Robert.','The Outer Banks of North Carolina /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:34084-D 1-TF-024/997','AOE-6445','Geological Survey (U.S.)','Dawsonville quadrangle, Georgia : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:33084-H 4-TF-024/997','AOE-6443','Geological Survey (U.S.)','Sandy Springs quadrangle, Georgia : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:30086-D 6-TF-024/994','AOE-6442','Geological Survey (U.S.)','Mary Esther quadrangle, Florida--Okaloosa Co., 1994 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:30086-D 8-TF-024/994','AOE-6440','Geological Survey (U.S.)','Holley quadrangle, Florida, 1994 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:30086-D 5-TF-024/994','AOE-6439','Geological Survey (U.S.)','Fort Walton Beach quadrangle, Florida--Okaloosa Co., 1994 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:30087-F 3-TF-024/994','AOE-6438','Geological Survey (U.S.)','Molino quadrangle, Florida, 1994 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:34077-A 8-TF-024/997','AOE-6437','Geological Survey (U.S.)','Carolina Beach quadrangle, North Carolina : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:36080-D 3-TF-024/997','AOE-6435','Geological Survey (U.S.)','Hanging Rock quadrangle, North Carolina--Stokes Co. : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:36079-A 1-TF-024/997','AOE-6434','Geological Survey (U.S.)','Hillsborough quadrangle, North Carolina--Orange Co., 1993 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:35078-G 6-TF-024/993','AOE-6433','Geological Survey (U.S.)','Raleigh West quadrangle, North Carolina--Wake Co., 1993 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:32079-H 8-TF-024/998','AOE-6432','Geological Survey (U.S.)','North Charleston quadrangle, South Carolina : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:38078-C 5-TF-024/997','AOE-6429','Geological Survey (U.S.)','Swift Run Gap quadrangle, Virginia /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:35085-D 6-TF-024/997','AOE-6431','Geological Survey (U.S.)','Altamont quadrangle, Tennessee--Grundy Co., 1997 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:37080-C 1-TF-024/994','AOE-6428','Geological Survey (U.S.)','Salem quadrangle, Virginia /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:37077-C 8-TF-024/994','AOE-6427','Geological Survey (U.S.)','Amelia Court House quadrangle, Virginia, 1994 /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:38078-A 6-TF-024/997','AOE-6426','Geological Survey (U.S.)','Crozet quadrangle, Virginia /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:38078-A 7-TF-024/997','AOE-6425','Geological Survey (U.S.)','Waynesboro East quadrangle, Virginia /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:36077-G 7-TF-024/997','AOE-6424','Geological Survey (U.S.)','Lawrenceville quadrangle, Virginia--Brunswick Co. /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:38077-D 8-TF-024/994','AOE-6422','Geological Survey (U.S.)','Culpeper East quadrangle, Virginia /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:38078-D 4-TF-024/997','AOE-6423','Geological Survey (U.S.)','Elkton East quadrangle, Virginia /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:38077-D 1-TF-024/997','AOE-6421','Geological Survey (U.S.)','Culpeper West quadrangle, Virginia /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:38078-B 7-TF-024/997','AOE-6420','Geological Survey (U.S.)','Crimora quadrangle, Virginia /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:38081-D 6-TF-024/994','AOE-6419','Geological Survey (U.S.)','Pocatalico quadrangle, West Virginia : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:38079-G 5-TF-024/995','AOE-6417','Geological Survey (U.S.)','Whitmer quadrangle, West Virginia, 1995 : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','I 19.81:34084-B 6-TF-024/997','AOE-6416','Geological Survey (U.S.)','Allatoona Dam quadrangle, Georgia : 7.5 minute series (topographic) /');
INSERT INTO new_titles VALUES ('2000/10/16','C 55.13/2:NMFS-NE-132','AOE-6389','','Essential fish habitat source document');
INSERT INTO new_titles VALUES ('2000/10/16','LA217.2 .F54 1994','AOE-6162','','The fifty million dollar gamble');
INSERT INTO new_titles VALUES ('2000/10/16','SF986.S55 F46','AOE-6144','Guagure, ric.','A practical guide to feline dermatology /');
INSERT INTO new_titles VALUES ('2000/10/16','LC311 .S43 1993','AOE-6161','','The search for values');
INSERT INTO new_titles VALUES ('2000/10/16','TK5105.585 .C66 2000','AOE-5901','Comer, Douglas.','Internetworking with TCP/IP /');
INSERT INTO new_titles VALUES ('2000/10/16','LB2806.17 .S36','AOE-6052','School executive (Philadelphia, Pa.)','School executive.');
INSERT INTO new_titles VALUES ('2000/10/16','PN451 .D54 vol. 228','AOC-2960','','Twentieth-century American dramatists.');
INSERT INTO new_titles VALUES ('2000/10/16','QA3 .L360 no. 1737','ANZ-4787','Wakabayashi, Seiichiro, 1948-','Classical microlocal analysis in the space of hyperfunctions /');
INSERT INTO new_titles VALUES ('2000/10/15','GB451.2 .K6813 2000','AOE-4123','Kos\'ian, R. D. (Ruben Derenikovich)','Coastal processes in tideless seas /');
INSERT INTO new_titles VALUES ('2000/10/15','QD708.2 .O64 2000','AOD-5508','','Organic, physical, and materials photochemistry /');
INSERT INTO new_titles VALUES ('2000/10/15','QA76.9.A25 A279 2000','AOC-3112','ACISP \'2000 (2000 : Brisbane, Qld.)','Information security and privacy : 5th Australasian Conference, ACISP \'2000, Brisbane, Australia, July 10-12, 2000 : pro');
INSERT INTO new_titles VALUES ('2000/10/15','QA76.9.D3 B75 2000','AOC-3111','British National Conference on Databases (17th : 2000 : Exeter, England)','Advances in databases : 17th British National Conference on Databases, BNCOD 17, Exeter, UK, July 3-5, 2000 : proceeding');
INSERT INTO new_titles VALUES ('2000/10/15','QA267 .R48 2000','AOC-3110','','Rewriting techniques and applications : 11th international conference, RTA 2000, Norwich, UK, July 10-12, 2000 : proceed');
INSERT INTO new_titles VALUES ('2000/10/15','QA76.76.I58 C53 2000','AOC-3109','CIA 2000 (2000 : Boston, Mass.)','Cooperative information agents IV : the future of information agents in cyberspace : 4th International Workshop, CIA 200');
INSERT INTO new_titles VALUES ('2000/10/15','QA76.6 .I5535 2000','AOC-3108','International Conference on the Mathematics of Program Construction (2000 : Ponte do Lima, Portugal)','Mathematics of program construction : 5th International Conference, MPC 200, Ponte de Lima, Portugal, July 200 : proceed');
INSERT INTO new_titles VALUES ('2000/10/15','QA76.9.H85 V67 2000','AOC-2961','VW 2000 (2000 : Paris, France)','Virtual worlds : Second International Conference, VW 2000, Paris, France, July 2000 : proceedings /');
INSERT INTO new_titles VALUES ('2000/10/15','JK2391.R39 N38 2000','ANZ-3178','Navarro, Armando, 1941-','La Raza Unida Party : a Chicano challenge to the U.S. two-party dictatorship /');
INSERT INTO new_titles VALUES ('2000/10/15','PS3555.S66 H43 2000','ANZ-3174','Essbaum, Jill Alexander.','Heaven /');
INSERT INTO new_titles VALUES ('2000/10/15','LB2822.84.C2 F56 2000','ANZ-3173','Fink, Dean, 1936-','Good schools/real schools : why school reform doesn\'t last /');
INSERT INTO new_titles VALUES ('2000/10/15','JC421 .G59 2000','ANZ-3172','','Globalization, power, and democracy /');
INSERT INTO new_titles VALUES ('2000/10/15','HQ76.25 .T775 2000','ANZ-3171','Turner, William B. (William Benjamin), 1964-','A genealogy of queer theory /');
INSERT INTO new_titles VALUES ('2000/10/15','PQ7082.N7 S35 2000','ANZ-3170','Santana, Mario, 1960-','Foreigners in the homeland : the Spanish American new novel in Spain, 1962-1974 /');
INSERT INTO new_titles VALUES ('2000/10/15','JN96.A58 J36 2000','ANZ-3169','Janos, Andrew C.','East Central Europe in the modern world : the politics of the borderlands from pre- to postcommunism /');
INSERT INTO new_titles VALUES ('2000/10/15','QL520.2.U6 D87 2000','ANZ-3168','Dunkle, Sidney W., 1940-','Dragonflies through binoculars : a field guide to dragonflies of North America /');
INSERT INTO new_titles VALUES ('2000/10/15','D58 .H36 2000','ANZ-3167','Harrison, Thomas J., 1955-','Divinity and history : the religion of Herodotus /');
INSERT INTO new_titles VALUES ('2000/10/15','HV696.F6 K56 2000','ANZ-3166','King, Ronald Frederick, 1949-','Budgeting entitlements : the politics of food stamps /');
INSERT INTO new_titles VALUES ('2000/10/15','Q175.55 .B49 2000','ANZ-3165','','Beyond the science wars : the missing discourse about science and society /');
INSERT INTO new_titles VALUES ('2000/10/15','DP302.B467 B38 1999','ANZ-3164','','Basque cultural studies /');
INSERT INTO new_titles VALUES ('2000/10/15','TJ930 .W66 2000','ANZ-3124','Woods, Glynn E.','ASME B31.3, process piping : (covering the 1999 Code edition) /');
INSERT INTO new_titles VALUES ('2000/10/15','HV9104 .Y685 2000','ANZ-3096','','Youth on trial : a developmental perspective on juvenile justice /');
INSERT INTO new_titles VALUES ('2000/10/15','QA27.5 .M88 2000','ANZ-3095','Murray, Margaret Anne Marie.','Women becoming mathematicians : creating a professional identity in post-World War II America /');
INSERT INTO new_titles VALUES ('2000/10/15','JN96.A91 C65 2000','ANZ-3094','Colomer, Josep Maria.','Strategic transitions : game theory and democratization /');
INSERT INTO new_titles VALUES ('2000/10/15','HT1523 .N63 2000','ANZ-3091','Nobles, Melissa.','Shades of citizenship : race and the census in modern politics / Melissa Nobles.');
INSERT INTO new_titles VALUES ('2000/10/15','HT168.L6 R44 2000','ANZ-3090','','Regions that work : how cities and suburbs can grow together /');
INSERT INTO new_titles VALUES ('2000/10/15','JK2316 .J36 2000','ANZ-3089','James, Scott C., 1955-','Presidents, parties, and the state : a party system perspective on Democratic regulatory choice, 1884-1936 /');
INSERT INTO new_titles VALUES ('2000/10/15','JA71 .P6314 2000','ANZ-3088','','Political theory and partisan politics /');
INSERT INTO new_titles VALUES ('2000/10/15','QC151 .G32 2000','ANZ-3087','Gad-el-Hak, M.','Flow control : passive, active, and reactive flow management /');
INSERT INTO new_titles VALUES ('2000/10/15','LB2395 .B77 2001','ANZ-3046','Browne, M. Neil, 1944-','Striving for excellence in college : tips for active learning /');
INSERT INTO new_titles VALUES ('2000/10/15','QC173.65 .G76 2000','ANZ-3045','Grssing, Gerhard, 1957-','Quantum cybernetics : towards a unification of relativity and quantum theory via circularly causal modeling /');
INSERT INTO new_titles VALUES ('2000/10/15','LB2341 .B49 2000','ANZ-3044','Birnbaum, Robert.','Management fads in higher education : where they come from, what they do, why they fail /');
INSERT INTO new_titles VALUES ('2000/10/15','TK5105.5 .S422 2000','ANZ-2983','','Self-similar network traffic and performance evaluation /');
INSERT INTO new_titles VALUES ('2000/10/15','GV1746 .B49 2000','ANZ-2981','Best, Amy L., 1970-','Prom night : youth, schools, and popular culture /');
INSERT INTO new_titles VALUES ('2000/10/15','TP1180.P6 P65 2000','ANZ-2980','','Polymers from renewable resources : biopolyesters and biocatalysis /');
INSERT INTO new_titles VALUES ('2000/10/15','JA81 .D43 2000','ANZ-2979','Deneen, Patrick J., 1964-','The odyssey of political theory : the politics of departure and return /');
INSERT INTO new_titles VALUES ('2000/10/15','QC808.5 .M48 2000','ANZ-2961','','Methods and applications of inversion /');
INSERT INTO new_titles VALUES ('2000/10/15','QE33.2.S82 G43 2000','ANZ-2954','','Geomatic methods for the analysis of data in the earth sciences /');
INSERT INTO new_titles VALUES ('2000/10/15','QA76.9.D3 D3683 2000','ANZ-2953','Date, C. J.','Foundation for future database systems : the third manifesto : a detailed study of the impact of type theory on the rel');
INSERT INTO new_titles VALUES ('2000/10/15','PS3575.E46 W48 2000','ANZ-2949','Yellow Robe, William S., 1960-','Where the pavement ends : five Native American plays /');
INSERT INTO new_titles VALUES ('2000/10/15','LC151 .W43 2000','ANZ-2948','','What counts as literacy? : challenging the school standard /');
INSERT INTO new_titles VALUES ('2000/10/15','LC173 .C34 2000','ANZ-2947','Caesar, Terry.','Traveling through the boondocks : in and out of academic hierarchy /');
INSERT INTO new_titles VALUES ('2000/10/15','BF204.7 .T72 2000','ANZ-2946','','Transpersonal knowing : exploring the horizon of consciousness /');
INSERT INTO new_titles VALUES ('2000/10/15','HV6626.2.U5 S37 2000','ANZ-2945','Sattler, Cheryl L.','Teaching to transcend : educating women against violence /');
INSERT INTO new_titles VALUES ('2000/10/15','P309 .S68 2000','ANZ-2943','','The spoken language translator /');
INSERT INTO new_titles VALUES ('2000/10/15','HE2791.C67 V46 1999','ANZ-2942','Veenendaal, A. J.','The Saint Paul & Pacific Railroad : an empire in the making, 1862-1879 /');
INSERT INTO new_titles VALUES ('2000/10/15','JK516 .G49 2001','ANZ-2940','Genovese, Michael A.','The power of the American presidency : 1789-2000 /');
INSERT INTO new_titles VALUES ('2000/10/15','D511 .C626 2000','ANZ-2939','Copeland, Dale C., 1960-','The origins of major war /');
INSERT INTO new_titles VALUES ('2000/10/15','BF204.7 .B33 2000','ANZ-2914','Bache, Christopher Martin.','Dark night, early dawn : steps to a deep ecology of mind /');
INSERT INTO new_titles VALUES ('2000/10/15','HN90.S6 W66 2000','ANZ-2912','Wood, Mark David, 1959-','Cornel West and the politics of prophetic pragmatism /');
INSERT INTO new_titles VALUES ('2000/10/15','JZ1252 .S39 2000','ANZ-0358','Skalnes, Lars S., 1959-','Politics, markets, and grand strategy : foreign economic policies as strategic instruments /');
INSERT INTO new_titles VALUES ('2000/10/15','HF5547.2 .E37 2000','ANY-4377','Eisenberg, Ronni.','Organize your home office : simple routines for setting up an office at home /');
INSERT INTO new_titles VALUES ('2000/10/15','RC347.5 .N483 1999','ANO-7680','','Neurotoxicology /');
INSERT INTO new_titles VALUES ('2000/10/15','K4602.2 1997','ANY-0650','Jackson, John Howard, 1932-','The world trading system : law and policy of international economic relations /');
INSERT INTO new_titles VALUES ('2000/10/15','QH545.A1 C48','ACI-9070','','Chemistry and ecology');
INSERT INTO new_titles VALUES ('2000/10/15','NK1535.L63 A4 1979','ABO-9757','Lewitt, Sol, 1928-','Geometric figures & color /');
INSERT INTO new_titles VALUES ('2000/10/15','QK1 .A57','AAW-4381','','Annals of botany');
INSERT INTO new_titles VALUES ('2000/10/15','L11 .S92','AAX-7228','','Studies in philosophy and education : SPE');
INSERT INTO new_titles VALUES ('2000/10/15','K .J33 1967','AAQ-0328','Jackson, R. M. (Richard Meredith), 1903-','The machinery of justice in England,');
INSERT INTO new_titles VALUES ('2000/10/15','PR6013 .R44 1970','AAC-6876','Greene, Graham, 1904-','The collected edition.');
INSERT INTO new_titles VALUES ('2000/10/15','QD476 .B715','AAL-6775','Breslow, Ronald.','Organic reaction mechanisms; an introduction.');
INSERT INTO new_titles VALUES ('2000/10/15','KF352.D5 1970','AAC-3081','Dillon, John Forrest, 1831-1914.','The laws and jurisprudence in England and America.');
INSERT INTO new_titles VALUES ('2000/10/21','QP360 .B487 2000','AOE-6835','Benton, Arthur Lester, 1909-','Exploring the history of neuropsychology : selected papers /');
INSERT INTO new_titles VALUES ('2000/10/21','E29.B35 B37 1999','AOE-6815','','The Basque diaspora = La dispora vasca /');
INSERT INTO new_titles VALUES ('2000/10/21','QH585.2 .A55 2000','AOE-6814','','Animal cell culture : a practical approach /');
INSERT INTO new_titles VALUES ('2000/10/21','QE882.U7 S35 2000','AOE-6813','Semonin, Paul, 1936-','American monster : how the nation\'s first prehistoric creature became a symbol of national identity /');
INSERT INTO new_titles VALUES ('2000/10/21','QA76.3 .M3234 2000','AOE-6793','Maginnis, Tobin.','SAIR Linux and GNU certification level I : system administration /');
INSERT INTO new_titles VALUES ('2000/10/21','QA279 .R64 2000','AOE-6792','Robinson, G. K.','Practical strategies for experimenting /');
INSERT INTO new_titles VALUES ('2000/10/21','RA777.8 .L83 2000','AOE-6791','Luck, Mike.','Men\'s health : perspectives, diversity, and paradox /');
INSERT INTO new_titles VALUES ('2000/10/21','BF109.F74 B74 2000','AOE-6786','Breger, Louis, 1931-','Freud : darkness in the midst of vision /');
INSERT INTO new_titles VALUES ('2000/10/21','TS235 .F35 2000','AOE-6785','','Foseco ferrous foundryman\'s handbook /');
INSERT INTO new_titles VALUES ('2000/10/21','QC173.454 .F54 2000','AOE-6783','','Field theories for low-dimensional condensed matter systems : spin systems and strongly correlated electrons /');
INSERT INTO new_titles VALUES ('2000/10/21','HD58.7 .E436 2000','AOE-6781','','Emotion in organizations /');
INSERT INTO new_titles VALUES ('2000/10/21','TJ919 .T89 2000','AOE-6778','Tuzson, John.','Centrifugal pump design /');
INSERT INTO new_titles VALUES ('2000/10/21','TH7466.5 .H67 2000','AOE-6779','Hordeski, Michael F.','Control and instrumentation technology in HVAC : PCs and environmental control /');
INSERT INTO new_titles VALUES ('2000/10/21','QC535 .D82 2000','ANZ-3131','Dubin, D. A.','Mathematical aspects of Weyl quantization and phase /');
INSERT INTO new_titles VALUES ('2000/10/21','QA76.73.J38 W554 2000','ANZ-3130','Wilson, Steve.','Java platform performance : strategies and tactics /');
INSERT INTO new_titles VALUES ('2000/10/21','LC1044 .V62 2000','ANQ-2491','','Vocational education and training reform : matching markets and budgets /');
INSERT INTO new_titles VALUES ('2000/10/21','TA365 .L6','ABJ-3499','Lord, P. (Peter)','Noise measurement and control.');
INSERT INTO new_titles VALUES ('2000/10/21','PS3501.R64 Z65','AAO-5920','Eckley, Wilton.','Harriette Arnow.');
INSERT INTO new_titles VALUES ('2000/10/21','TL5 .A665','ABA-8728','','Auto');
INSERT INTO new_titles VALUES ('2000/10/21','HC106 .H57 1973','AAN-0035','Hill, James Jerome, 1838-1916.','Highways of progress.');
INSERT INTO new_titles VALUES ('2000/10/21','QK484.P4 L5','AAM-3781','Li, Hui-Lin, 1911-','Trees of Pennsylvania: the Atlantic States and the Lake States.');
INSERT INTO new_titles VALUES ('2000/10/21','DS485.N7 S7 1972','AAK-4694','Stein, Aurel, Sir, 1862-1943.','On Alexander\'s track to the Indus; personal narrative of explorations on the north-west frontier of India carried out un');
INSERT INTO new_titles VALUES ('2000/10/21','DP171 .L92 1964','AAG-0629','Lynch, John, 1927-','Spain under the Habsburgs.');
INSERT INTO new_titles VALUES ('2000/10/21','LB2329 .K56','AAE-1655','Klotsche, J. Martin.','The urban university and the future of our cities');
INSERT INTO new_titles VALUES ('2000/10/20','','AOE-9053','Trevor, William','Piano Tuner\'s Wives');
INSERT INTO new_titles VALUES ('2000/10/21','E233 .D57','AAC-2683','Digby, William, fl. 1776.','The British invasion from the north; Digby\'s journal of the campaigns of generals Carleton and Burgoyne from Canada, 177');
INSERT INTO new_titles VALUES ('2000/10/20','','AOE-9050','Gurganus, Allan','It Had Wings');
INSERT INTO new_titles VALUES ('2000/10/20','','AOE-9047','Moore, Lorrie','How to Be an Other Woman');
INSERT INTO new_titles VALUES ('2000/10/20','','AOE-9049','Evans, Sterling.','Oro Verde! Ecotourism for Economic Growth.');
INSERT INTO new_titles VALUES ('2000/10/20','','AOE-9045','Moore, Lorrie','How to Become a Writer');
INSERT INTO new_titles VALUES ('2000/10/20','','AOE-9043','Martin, Joe','Sister Holy Ghost and the Fourth of July');
INSERT INTO new_titles VALUES ('2000/10/20','','AOE-9039','Evans, Sterling.','Costa Rican Uniqueness Factor.');
INSERT INTO new_titles VALUES ('2000/10/20','','AOE-8951','Weastman, Walter E.','Ecological Impact Assessment as a Discipline(ch 1)');
INSERT INTO new_titles VALUES ('2000/10/20','A 13.78:INT-RP-487','AOE-8750','','Bark beetle and wood borer infestation in the Greater Yellowstone Area during four postfire years /');
INSERT INTO new_titles VALUES ('2000/10/20','LD3921 Math. B422','AOE-8490','Beeler, Scott Colvin.','Modeling and control of thin film growth in a chemical vapor deposition reactor');
INSERT INTO new_titles VALUES ('2000/10/20','LD3921 Matls. Sci. & Eng. H368','AOE-7428','Hartman, Jeffrey David, 1970-','Charaterization of the growth of aluminum nitride and gallium nitride thin films on hydrogen etched and/or cleaned 6H-Si');
INSERT INTO new_titles VALUES ('2000/10/20','LD3921 Nutrit. W43','AOE-7412','Webber, Kelly Harmon, 1971-','The applicability of the transtheoretical model of behavior change to the eastern band of Cherokee Indians for use in di');
INSERT INTO new_titles VALUES ('2000/10/20','LD3921 Tex. Eng., Chem. & Sci. G63','AOE-7411','Godara, Hemant, 1973-','Study of water-repellent denim /');
INSERT INTO new_titles VALUES ('2000/10/20','LD3921 Graph. Des. C67','AOE-7410','Corker, George R., III.','Inter [facet] faces : interfaces that respond to Howard Gardner\'s theory of multiple intelligences /');
INSERT INTO new_titles VALUES ('2000/10/20','LD3921 Agr. & Exten. Educ. W55','AOE-7407','Wilson, Elizabeth Bundy.','Factors related to the intent of agricultural educators to adopt integrated agricultural biotechnology curriculum /');
INSERT INTO new_titles VALUES ('2000/10/20','LD3921 Math. & Sci. Educ. S46','AOE-7406','Sechler, Phares Coleman (Phares Lochiel Coleman), 1934-','Relationship among science teacher personality characteristics and degree of teacher classroom implementation after in-s');
INSERT INTO new_titles VALUES ('2000/10/20','LD3921 Micro-biol. B5308','AOE-7405','Black, Jonathan Alan, 1963-','Development of an in vitro assay to study Bordetella avium adherence and partial characterization of the pilin gene /');
INSERT INTO new_titles VALUES ('2000/10/20','NX456.5.S57 K39 2000','AOE-7003','Kaye, Nick.','Site specific art : performance, place, and documentation /');
INSERT INTO new_titles VALUES ('2000/10/20','TR681.P67 .M38 2000','AOE-7002','Matthews, Sandra.','Pregnant pictures /');
INSERT INTO new_titles VALUES ('2000/10/20','TR675 .F56 2000','AOE-7001','Finn, David, 1921-','Nude sculpture : 5,000 years /');
INSERT INTO new_titles VALUES ('2000/10/20','N520 .A7178 1986','AOE-6998','Museum of Fine Arts, Boston.','Masterpiece paintings from the Museum of Fine Arts, Boston /');
INSERT INTO new_titles VALUES ('2000/10/20','N6953.E82 A4 2000','AOE-6997','Escher, M. C. (Maurits Cornelis), 1898-1972.','The magic of M.C. Escher /');
INSERT INTO new_titles VALUES ('2000/10/20','TR681.F3 G37 2000','AOE-6996','Garrett, Murray.','Hollywood candid : a photographer remembers /');
INSERT INTO new_titles VALUES ('2000/10/20','NB1875 .D38 2000','AOE-6994','Davies, Penelope J. E., 1964-','Death and the emperor : Roman imperial funerary monuments, from Augustus to Marcus Aurelius /');
INSERT INTO new_titles VALUES ('2000/10/20','D2009 .S54 2000','AOE-6852','Shore, Cris, 1959-','Building Europe : the cultural politics of European integration /');
INSERT INTO new_titles VALUES ('2000/10/20','HV12 .B53 2000','AOE-6851','','The Blackwell encyclopaedia of social work /');
INSERT INTO new_titles VALUES ('2000/10/20','HD8039.C662 U644 2000','AOE-6828','Holley, Donald, 1940-','The second great emancipation : the mechanical cotton picker, Black migration, and how they shaped the modern South /');
INSERT INTO new_titles VALUES ('2000/10/20','PR21 .P67 1999','AOE-6827','','Post-theory : new directions in criticism /');
INSERT INTO new_titles VALUES ('2000/10/20','DS935.5 .N673 2000','AOE-6826','','North Korea : through the looking glass /');
INSERT INTO new_titles VALUES ('2000/10/20','PN68 .D36 2000','AOE-6824','Damrosch, David.','Meetings of the mind /');
INSERT INTO new_titles VALUES ('2000/10/20','E184.F4 B66 2000','AOE-6823','Bonus, Rick, 1962-','Locating Filipino Americans : ethnicity and the cultural politics of space /');
INSERT INTO new_titles VALUES ('2000/10/20','D530 .G68 1999','AOE-6820','','Great War, total war : combat and mobilization on the Western Front, 1914-1918 /');
INSERT INTO new_titles VALUES ('2000/10/20','PS3511.I9 Z6139 2000','AOE-6819','','F. Scott Fitzgerald : new perspectives /');
INSERT INTO new_titles VALUES ('2000/10/20','DP302.B55 B28 1999','AOE-6816','','Basque politics and nationalism on the eve of the millennium /');
INSERT INTO new_titles VALUES ('2000/10/20','TK7868.P7 M38 2000','AOE-6807','Marks, Leonard, 1932-','Printed circuit assembly design /');
INSERT INTO new_titles VALUES ('2000/10/20','Q175.55 .T73 2000','AOE-6809','Trachtman, Leon E., 1925-','Science under siege? : interest groups and the science wars /');
INSERT INTO new_titles VALUES ('2000/10/20','QA47 .J38 2000','AOE-6801','Jeffrey, Alan.','Handbook of mathematical formulas and integrals /');
INSERT INTO new_titles VALUES ('2000/10/20','QA387 .H39 2000','AOE-6798','Hawkins, Thomas, 1938-','Emergence of the theory of Lie groups : an essay in the history of mathematics, 1869-1926 /');
INSERT INTO new_titles VALUES ('2000/10/20','QA312 .A55 2000','AOE-6776','','Almgren\'s big regularity paper : Q-valued functions minimizing Dirichlet\'s integral and the regularity of area-minimizin');
INSERT INTO new_titles VALUES ('2000/10/20','NA4411 .U55 2000','AOE-6775','','The United States Capitol : designing and decorating a national icon /');
INSERT INTO new_titles VALUES ('2000/10/20','NA2750 .B864 2000','AOE-6772','Burden, Ernest E., 1934-','Elements of architectural design : a photographic sourcebook /');
INSERT INTO new_titles VALUES ('2000/10/20','TA418.9.C6 A2891 1999','AOE-6398','','Advances in ceramic matrix composites IV /');
INSERT INTO new_titles VALUES ('2000/10/20','TK7871.15.G5 E44 1999','AOE-6399','','Electrochemistry of glass and ceramics /');
INSERT INTO new_titles VALUES ('2000/10/20','QC244.2 .I57 1999','AOE-6397','International Symposium on Nonlinear Acoustics (15th : 1999 : Gttingen, Germany)','Nonlinear acoustics at the turn of the millennium : ISNA 15, 15th International Symposium on Nonlinear Acoustics, Gttin');
INSERT INTO new_titles VALUES ('2000/10/20','R724 .E7879 2000','AOE-6229','','Ethical issues in health care on the frontiers of the twenty-first century /');
INSERT INTO new_titles VALUES ('2000/10/20','TA190 .A54 2000','AOE-4124','American Society of Civil Engineers.','Quality in the constructed project : a guide for owners, designers, and constructors.');
INSERT INTO new_titles VALUES ('2000/10/20','NA680 .A734 2000','ANZ-4620','','Architects of the new millennium.');
INSERT INTO new_titles VALUES ('2000/10/20','TA1001 .I35','AOE-4109','','IEEE transactions on intelligent transportation systems.');
INSERT INTO new_titles VALUES ('2000/10/20','N332.B38 F5413 2000','ANZ-4612','Fiedler, Jeannine.','Bauhaus /');
INSERT INTO new_titles VALUES ('2000/10/20','E607 .B49 2000','ANZ-3872','','Beyond the battlefield : the ordinary life and extraordinary times of the Civil War soldier /');
INSERT INTO new_titles VALUES ('2000/10/20','HD9743.U6 S54 2000','ANZ-3377','Silverstein, Ken.','Private warriors /');
INSERT INTO new_titles VALUES ('2000/10/20','QA76.76.I59 P76 2000','ANZ-3260','','Programming mental ray /');
INSERT INTO new_titles VALUES ('2000/10/20','N33 .L353 2000','ANZ-3123','Langmuir, Erika.','The Yale dictionary of art and artists /');
INSERT INTO new_titles VALUES ('2000/10/20','NA9053.S6 F67 2000','ANZ-3121','Ford, Larry.','The spaces between buildings /');
INSERT INTO new_titles VALUES ('2000/10/20','N8217.G437 R63 2000','ANZ-3122','Rogoff, Irit.','Terra infirma : geography\'s visual culture /');
INSERT INTO new_titles VALUES ('2000/10/20','N6370 .G76 2000','ANZ-3118','','The Grove dictionary of art.');
INSERT INTO new_titles VALUES ('2000/10/20','NA2542.35 .M445 2000','ANZ-3119','Mendler, Sandra.','The HOK guidebook to sustainable design /');
INSERT INTO new_titles VALUES ('2000/10/20','N6946 .G76 2000','ANZ-3117','','The Grove dictionary of art.');
INSERT INTO new_titles VALUES ('2000/10/20','N6490 .G7243 2000','ANZ-3116','','The Grove dictionary of art.');
INSERT INTO new_titles VALUES ('2000/10/20','TA357.5.M85 T73 2000','ANZ-3062','','Transient phenomena in multiphase and multicomponent systems : research report /');
INSERT INTO new_titles VALUES ('2000/10/20','QP114.C65 T39 2000','ANZ-3043','Tawara, S. (Sunao), 1873-1952.','The conduction system of the Mammalian heart : an anatomico-histological study of the atrioventricular bundle and the pu');
INSERT INTO new_titles VALUES ('2000/10/20','PS615 .N383 2000','ANZ-0431','','The new American poets /');
INSERT INTO new_titles VALUES ('2000/10/20','ND1329.3.I53 C74 2000','ANZ-3030','Creighton, Jeff, 1953-','Indian summers : Washington State College and the Nespelem Art Colony, 1937-41 /');
INSERT INTO new_titles VALUES ('2000/10/20','Z1003 .H194 2000','ANZ-0430','Hamilton, John Maxwell.','Casanova was a book lover : and other naked truths and provocative curiosities about the writing, selling, and reading o');
INSERT INTO new_titles VALUES ('2000/10/20','D860 .G654 2000','ANZ-0425','','Globalization and the challenges of a new century : a reader /');
INSERT INTO new_titles VALUES ('2000/10/20','KF1890.H53 B87 2001','ANZ-0351','Burgunder, Lee B., 1955-','Legal aspects of managing technology /');
INSERT INTO new_titles VALUES ('2000/10/20','K644 .G59 2000','ANZ-0348','','Global critical race feminism : an international reader /');
INSERT INTO new_titles VALUES ('2000/10/20','DS135.R92 A7289 1998','ANY-9438','Altshuler, Mordechai.','Soviet Jewry on the eve of the Holocaust : a social and demographic profile /');
INSERT INTO new_titles VALUES ('2000/10/20','DS485.D25 A47 1999','ANY-9412','Aitken, Bill.','Divining the Deccan : a motorbike to the heart of India /');
INSERT INTO new_titles VALUES ('2000/10/20','D810.W7 W545 2000','ANY-9435','Winfield, Pamela.','Melancholy baby : the unplanned consequences of the G.I.s\' arrival in Europe for World War II /');
INSERT INTO new_titles VALUES ('2000/10/20','DA47.65 .O84 2000','ANY-9409','Osborn, Patrick R., 1966-','Operation Pike : Britain versus the Soviet Union, 1939-1941 /');
INSERT INTO new_titles VALUES ('2000/10/20','E476.52 .F87 2000','ANY-9408','Furgurson, Ernest B., 1929-','Not war but murder : Cold Harbor, 1864 /');
INSERT INTO new_titles VALUES ('2000/10/20','TK5102.3.E85 O52 2000','ANY-7413','','On the way to information society : five years of European ACTS research on intelligence in services and networks /');
INSERT INTO new_titles VALUES ('2000/10/20','M2003.R62 C8 1986b','ANY-7180','Robinson, Earnestine Rodgers.','The crucifixion : an oratorio according to the Holy Scriptures /');
INSERT INTO new_titles VALUES ('2000/10/20','BQ7640 .N47 1999','ANY-6394','Newland, Guy.','Appearance and reality : the two truths in four Buddhist systems /');
INSERT INTO new_titles VALUES ('2000/10/20','PR9440.9.S42 C56 1999','ANY-6338','Selvadurai, Shyam, 1965-','Cinnamon gardens /');
INSERT INTO new_titles VALUES ('2000/10/20','D164.A3 C56 2000','ANY-6368','','Contemporary sources for the Fourth Crusade /');
INSERT INTO new_titles VALUES ('2000/10/20','DA950.1 .I74 2000','ANY-4225','','Ireland in the nineteenth century : regional identity /');
INSERT INTO new_titles VALUES ('2000/10/20','Z703.5 .T84 1999','ANY-4340','Tucker, Dennis C.','Library relocations and collection shifts /');
INSERT INTO new_titles VALUES ('2000/10/20','TP371.8 .S28 1996','ANY-3483','Satin, Morton.','Food irradiation : a guidebook /');
INSERT INTO new_titles VALUES ('2000/10/20','TL269 .I575 2000','ANY-3294','International Conference on Brakes 2000 (2000 : Leeds, UK)','The International Conference on Brakes 2000 : Automotive Braking Technologies for the 21st Century /');
INSERT INTO new_titles VALUES ('2000/10/20','HF5548.85 .D46 1996','ANY-2234','Dempcy, Mary, 1936-','Dear job stressed : answers for the overworked, overwrought, and overwhelmed /');
INSERT INTO new_titles VALUES ('2000/10/20','HD42 .H57 1996','ANY-2013','Hirsh, Sandra Krebs.','Work it out : clues for solving people problems at work /');
INSERT INTO new_titles VALUES ('2000/10/20','TJ223.M53 G74 1992','ANY-2223','Greenfield, Joseph D., 1930-','The 68HC11 microcontroller /');
INSERT INTO new_titles VALUES ('2000/10/20','TK9956 .M378 1993','ANY-1665','McCormick, Anita Louise.','Shortwave radio listening for beginners /');
INSERT INTO new_titles VALUES ('2000/10/20','HG6049 .F467 1998','ANY-1642','Ferris, John N.','Agricultural prices and commodity market analysis /');
INSERT INTO new_titles VALUES ('2000/10/20','TX653 .P56 1995','ANY-0926','Plante, Ellen M.','The American kitchen, 1700 to the present : from hearth to highrise /');
INSERT INTO new_titles VALUES ('2000/10/20','N8217.H78 C37 2000','ANY-1076','Carman, Charles H.','Images of humanist ideals in Italian Renaissance art /');
INSERT INTO new_titles VALUES ('2000/10/20','QA9.58 .B47 2000','ANY-1078','Berlinski, David, 1942-','The advent of the algorithm : the idea that rules the world /');
INSERT INTO new_titles VALUES ('2000/10/20','Q125 .K569 1998','ANX-7309','Knight, David M.','Science in the romantic era /');
INSERT INTO new_titles VALUES ('2000/10/20','HB139 .C644 1997','ANX-7562','','Computational approaches to economic problems /');
INSERT INTO new_titles VALUES ('2000/10/20','HG1202 .H33 1999','ANX-7295','Habibullah, Muzafar Shah.','Divisia monetary aggregates and economic activities in Asian developing economies /');
INSERT INTO new_titles VALUES ('2000/10/20','KF6450 .A92 1999','ANX-7205','Abrams, Howard E., 1955-','Essentials of United States taxation /');
INSERT INTO new_titles VALUES ('2000/10/20','HD30.3 .S43 1997','ANX-7213','Seeger, Matthew W. (Matthew Wayne), 1957-','Ethics and organizational communication /');
INSERT INTO new_titles VALUES ('2000/10/20','HB849.3 .I43 1997','ANX-3321','','India : directory of population experts, directory of population institutions.');
INSERT INTO new_titles VALUES ('2000/10/20','HD7262 .S84 2000','ANX-1535','Sutherland, Valerie J.','The management of safety : the behavioural approach to changing organizations /');
INSERT INTO new_titles VALUES ('2000/10/20','H97 .P785 2000','ANW-6439','','Public policy and statistics : case studies from RAND /');
INSERT INTO new_titles VALUES ('2000/10/20','B1498 .F46 2000','ANW-3730','','Feminist interpretations of David Hume /');
INSERT INTO new_titles VALUES ('2000/10/20','PT7090 .N674 1999','ANP-0485','','Norse romance /');
INSERT INTO new_titles VALUES ('2000/10/20','PS3563.O8749 P373 1999','ANE-2100','Tally, Justine.','Toni Morrison\'s (Hi)stories and truths /');
INSERT INTO new_titles VALUES ('2000/10/20','PR9387.9.S27 Z57 2000','ANE-1979','','Before I am hanged : Ken Saro-Wiwa--literature, politics, and dissent /');
INSERT INTO new_titles VALUES ('2000/10/14','FEM 1.209/33:370307/ETC./V.','AOB-3103','','Flood insurance study Davidson County, North Carolina, and incorporated areas.');
INSERT INTO new_titles VALUES ('2000/10/14','I 49.1/7:','ANZ-3239','U.S. Fish and Wildlife Service. Division of Law Enforcement.','Annual report /');
INSERT INTO new_titles VALUES ('2000/10/14','C 13.46:1518','ANZ-2117','Grosvenor, Chriss A.','Design and testing of NFRad--a new noise measurement system /');
INSERT INTO new_titles VALUES ('2000/10/14','I 49.2:SO 8/3','ANY-4093','Dahl, Thomas E.','South Carolina\'s wetlands status and trends, 1982-1989 /');
INSERT INTO new_titles VALUES ('2000/10/14','C 13.46:1500-8','ANY-4091','Vigliotti, D. P.','Recommended practice installing, maintaining, and verifying your Charpy impact machine /');
INSERT INTO new_titles VALUES ('2000/10/14','C 55.49/3:17','ANY-4092','','Flux and sources of nutrients in the Mississippi-Atchafalaya River Basin topic 3, report for the integrated assessment o');
INSERT INTO new_titles VALUES ('2000/10/14','C 13.58:6510','ANY-4089','Madrzykowski, Daniel.','Simulation of the dynamics of the fire at 3146 Cherry Road NE, Washington D.C., May 30, 1999');
INSERT INTO new_titles VALUES ('2000/10/14','C 13.58:6540','ANY-4090','Leight, Walter G.','Report on NIST-NACLA MOU Workshop on June 20, 2000');
INSERT INTO new_titles VALUES ('2000/10/14','C 13.58:6501','ANY-4088','Chapman, Robert E.','Benefits and costs of research a case study of construction systems integration and automation technologies in industria');
INSERT INTO new_titles VALUES ('2000/10/14','C 13.58:6489','ANY-4087','Watson, C. I.','Distortion-tolerant filter for elastic-distorted fingerprint matching');
INSERT INTO new_titles VALUES ('2000/10/14','A 13.80:NC-176/CORR.','ANY-4085','','Kansas Timber Industry - An Assessment Of Timber Product Output And Use, 1993... Resource Bulletin NC-176 U.S. Departmen');
INSERT INTO new_titles VALUES ('2000/10/14','C 13.58:6265','ANY-4086','Bentz, Dale P.','A hard core/soft shell microstructural model for studying percolation and transport in three-dimensional composite media');
INSERT INTO new_titles VALUES ('2000/10/14','Y 3.N 88:25/6625','ANY-4054','Henson, Ivan Hendrix.','Automated seismic event monitoring system');
INSERT INTO new_titles VALUES ('2000/10/14','I 53.59:C 26/V./DRAFT','ANX-1762','United States. Bureau of Land Management. Medford District.','Draft management plan and environmental statement for the Cascade Siskiyou Ecological Emphasis Area');
INSERT INTO new_titles VALUES ('2000/10/14','I 19.76:99-516','ANP-4711','','SEDIMENT MAGNETIC DATA AND THERMOMAGNETIC DETERMINATIONS OF HOLOCENE AND PLEISTOCENE SOILS AND THEIR PARENT MATERIALS F');
INSERT INTO new_titles VALUES ('2000/10/14','I 19.76:99-366','ANP-4709','','PB ISOTOPES AND TOXIC METAL ABUNDANCES IN THE FLOODPLAIN AND STREAM SEDIMENTS FROM THE VOLTURNO RIVER BASIN (CAMPANIA,');
INSERT INTO new_titles VALUES ('2000/10/14','I 19.76:99-367 A','ANP-4710','','ANALYTICAL RESULTS AND SAMPLE LOCALITY MAPS FOR ROCK, STREAM-SEDIMENT, AND SOIL SAMPLES, JOSHUA TREE NATIONAL PARK, RIV');
INSERT INTO new_titles VALUES ('2000/10/14','I 19.76:99-365','ANP-4708','','A GEOCHEMICAL AND ISOTOPIC (ND-PB) COMPARISON OF VOLCANIC ROCKS ERUPTED DURING THE LAST 3,550 YRS. B.P. OF INTERPLINIAN');
INSERT INTO new_titles VALUES ('2000/10/14','I 19.76:99-360','ANP-4706','','CRUISE REPORT, \"RV COASTAL SURVEYOR CRUISE C1-99\", MULTIBEAM MAPPING OF THE LONG BEACH, CALIFORNIA CONTINENTAL FIELD GA');
INSERT INTO new_titles VALUES ('2000/10/14','I 19.76:99-352','ANP-4705','','STRATIGRAPHY, TEPHROCHRONOLOGY, AND STRUCTURAL SETTING OF MIOCENE SEDIMENTARY ROCKS IN THE COBBLE CUESTA AREA, WEST-CEN');
INSERT INTO new_titles VALUES ('2000/10/14','I 19.76:99-350','ANP-4701','','STRATIGRAPHY, TEPHROCHRONOLOGY, AND STRUCTURAL SETTINGS OF MIOCENE SEDIMENTARY ROCKS IN THE MIDDLEGATE AREA, WEST CENTR');
INSERT INTO new_titles VALUES ('2000/10/14','I 19.76:99-348','ANP-4700','','ANALYTICAL RESULTS AND CONCEPTUAL MODEL OF MINE DRAINAGE AT THE HOLDEN MINE, CHELAN COUNTY, WASHINGTON KILBURN, J. E.,');
INSERT INTO new_titles VALUES ('2000/10/14','I 19.76:99-343','ANP-4697','','PROBABILISTIC METHOD FOR SUBDIVIDING PETROLEUM RESOURCES INTO DEPTH SLICES CROVELLI, ROBERT A.');
INSERT INTO new_titles VALUES ('2000/10/14','I 19.76:99-344 A','ANP-4699','','DIGITAL ANALYTICAL DATA FROM MINERAL RESOURCE ASSESSMENTS OF NATIONAL FOREST LANDS IN WASHINGTON BOLENEUS, D.E., CHASE,');
INSERT INTO new_titles VALUES ('2000/10/14','A 13.78:FPL-RP-581','ANO-6871','','Performance of back-primed and factory-finished hardboard lap siding in southern Florida');
INSERT INTO new_titles VALUES ('2000/10/14','A 1.38:1487/999','ANO-6869','','Careers in APHIS an investment in your future.');
INSERT INTO new_titles VALUES ('2000/10/14','A 1.38:1562','ANO-6870','','Advisory and assistance for aquaculture and aquatic animal health');
INSERT INTO new_titles VALUES ('2000/10/14','R118.4.U6 M37','AJG-5873','','Medical and health information directory.');
INSERT INTO new_titles VALUES ('2000/10/14','[Law Alcove] KF6276.558.A19 U53','AJV-7699','United States.','The complete Internal Revenue Code.');
INSERT INTO new_titles VALUES ('2000/10/14','SB21 .N5','AFT-7645','New Jersey State Horticultural Society.','Proceedings of the annual meeting /');
INSERT INTO new_titles VALUES ('2000/10/14','QH426 .N4','AHZ-4379','','Nature genetics.');
INSERT INTO new_titles VALUES ('2000/10/14','SB21 .N5','AFT-7644','New Jersey State Horticultural Society.','Proceedings of the New Jersey State Horticultural Society at its ... annual meeting in ...');
INSERT INTO new_titles VALUES ('2000/10/14','SB21 .O73','AFQ-1344','Oregon Horticultural Society. Meeting.','Annual report ... annual meeting /');
INSERT INTO new_titles VALUES ('2000/10/14','QL463 .H86','ACG-6138','Howard, L. O. (Leland Ossian), 1857-1950.','The insect book : a popular account of the bees, wasps, ants, grasshoppers, flies and other North American insects exclu');
INSERT INTO new_titles VALUES ('2000/10/14','PR6045.I5 Z74 1983','ABX-4627','Hadfield, Alice Mary.','Charles Williams : an exploration of his life and work /');
INSERT INTO new_titles VALUES ('2000/10/14','HV553 .P47 1984','ABY-3009','Perry, Ronald W.','Disaster management : warning response and community relocation /');
INSERT INTO new_titles VALUES ('2000/10/14','QH506 .M63','ABQ-9270','','Molecular and cellular biology.');
INSERT INTO new_titles VALUES ('2000/10/14','BL65.M4 H77 1983','ABX-2067','Hsu, Francis L. K., 1909-','Exorcising the trouble makers : magic, science, and culture /');
INSERT INTO new_titles VALUES ('2000/10/14','BL65.M4 M42','ABP-0173','','Medicine and religion ; strategies of care /');
INSERT INTO new_titles VALUES ('2000/10/14','Q158.5 .C66 1979','ABL-7040','Congressional Quarterly, inc.','Editorial research reports on advances in science : timely reports to keep journalists, scholars, and the public abreast');
INSERT INTO new_titles VALUES ('2000/10/14','QR41 .B55 1962','ABG-9088','Bisset, Kenneth Alexander.','Bacteria.');
INSERT INTO new_titles VALUES ('2000/10/14','QH442 .G420','ABI-1594','','Gene');
INSERT INTO new_titles VALUES ('2000/10/14','HV1553 .H35','ABL-2661','','Directory of grants for organizations serving people with disabilities.');
INSERT INTO new_titles VALUES ('2000/10/14','TL504 .A3556','ABG-8705','Aeronautical Society of India.','The Journal of the Aeronautical Society of India');
INSERT INTO new_titles VALUES ('2000/10/14','SF995 .B3','ABG-8963','Barger, Edgar Hugh.','Diseases and parasites of poultry,');
INSERT INTO new_titles VALUES ('2000/10/14','S399 .E45','ABA-6140','Technical bulletin (Hawaii Agricultural Experiment Station)','Technical bulletin.');
INSERT INTO new_titles VALUES ('2000/10/14','BF161 .R9','AAZ-4383','Ryle, Gilbert, 1900-1976.','The concept of mind.');
INSERT INTO new_titles VALUES ('2000/10/14','QH611 .H53','AAY-8463','','The Histochemical journal');
INSERT INTO new_titles VALUES ('2000/10/14','QH573 .J58','AAY-8830','','Journal of cell science.');
INSERT INTO new_titles VALUES ('2000/10/14','SB599 .S7','AAZ-0132','Meddelande (Statens vxtskyddsanstalt (Sweden))','Meddelande /');
INSERT INTO new_titles VALUES ('2000/10/14','HJ4181.A1 J68','AAZ-1889','','The Journal of real estate taxation');
INSERT INTO new_titles VALUES ('2000/10/14','SB21 .U83','AAX-1288','Utah State Horticultural Society.','Proceedings of the ... annual convention of the Utah State Horticultural Society');
INSERT INTO new_titles VALUES ('2000/10/14','TA1 .A5','AAW-4274','','Transactions of the American Society of Civil Engineers');
INSERT INTO new_titles VALUES ('2000/10/14','F279.H25 R79','AAV-8442','Rutledge, Archibald Hamilton, 1883-1973.','God\'s children');
INSERT INTO new_titles VALUES ('2000/10/14','F279.H25 R83','AAV-0068','Rutledge, Archibald Hamilton, 1883-1973.','The world around Hampton.');
INSERT INTO new_titles VALUES ('2000/10/14','TC187 .H43','AAV-8035','Herbich, John B.','Coastal & deep ocean dredging /');
INSERT INTO new_titles VALUES ('2000/10/14','F1030.1 .B6','AAU-7065','Bishop, Morris, 1893-1973.','Champlain, the life of fortitude.');
INSERT INTO new_titles VALUES ('2000/10/14','PR8790 .F38','AAS-9809','Fay, Gerard.','The Abbey Theatre, cradle of genius.');
INSERT INTO new_titles VALUES ('2000/10/14','QH506 .M66','AAP-5488','Molecular biology (New York, N.Y. : 1967)','Molecular biology.');
INSERT INTO new_titles VALUES ('2000/10/14','DT351.S9 F3 1974','AAP-2961','Farwell, Byron.','The man who presumed; a biography of Henry M. Stanley.');
INSERT INTO new_titles VALUES ('2000/10/14','QD15 .C55 1963','AAL-5174','Clements, Richard, scientist.','Modern chemical discoveries.');
INSERT INTO new_titles VALUES ('2000/10/14','E203 .W26','AAJ-4825','Warren, James, 1726-1808.','A study in dissent: the Warren-Gerry correspondence, 1776-1792.');
INSERT INTO new_titles VALUES ('2000/10/14','BT301.9 .A5','AAI-5550','Anderson, Hugh, 1920-','Jesus.');
INSERT INTO new_titles VALUES ('2000/10/14','QL487 .H43','AAH-3964','Healy, Anthony, 1934-','Australian insects in colour');
INSERT INTO new_titles VALUES ('2000/10/14','DT351.S9 A6','AAH-4891','Anstruther, Ian.','Dr. Livingstone, I presume?');
INSERT INTO new_titles VALUES ('2000/10/14','E302 .M19','AAH-3692','Madison, James, 1751-1836.','Papers.');
INSERT INTO new_titles VALUES ('2000/10/14','ND619.T9 C283','AAE-9861','Carli, Enzo, 1910-','Italian primitives; panel painting of the twelfth and thirteenth centuries.');
INSERT INTO new_titles VALUES ('2000/10/14','PR8789 .R6','AAD-3647','Robinson, Lennox, 1886-1958.','The Irish theatre; lectures delivered during the Abbey Theatre festival held in Dublin in August 1938.');
INSERT INTO new_titles VALUES ('2000/10/14','E449 .G245','AAD-1400','Garrison, William Lloyd, 1805-1879.','The letters of William Lloyd Garrison.');
INSERT INTO new_titles VALUES ('2000/10/14','bl2400.z28','','','');
INSERT INTO new_titles VALUES ('2000/10/14','DS62.8 .A2','AAB-5083','Abboushi, W. F., 1931-','Political systems of the Middle East in the 20th century');
INSERT INTO new_titles VALUES ('2000/10/27','','AOF-4445','Welton, Michael','Social revolutionary Learning');
INSERT INTO new_titles VALUES ('2000/10/27','','AOF-4243','Travis, Shirley S','Families and formal networks. ch.22forma');
INSERT INTO new_titles VALUES ('2000/10/27','','AOF-3992','Belksy J.K.','Sensing and responding to the Environment(Ch.3)');
INSERT INTO new_titles VALUES ('2000/10/27','','AOF-1987','Belsky, J.K.','Sterotypes,realities:The Psychological Study of Later life,(ch.1)');
INSERT INTO new_titles VALUES ('2000/10/27','','AOF-1918','Kart, C.S., E.K.Metress, and S.P.Metress','Age-Associated Changes in Vision and hearing(ch.7)');
INSERT INTO new_titles VALUES ('2000/10/27','','AOF-1845','Lavinge,Victor D., and Gordon E. Finley','Memory in Middle Aged Adults');
INSERT INTO new_titles VALUES ('2000/10/27','LT4210.M37 M38 2001 vol. 7','AOF-1497','','McGraw-Hill reading.');
INSERT INTO new_titles VALUES ('2000/10/27','LT4210.M37 M38 2001 vol. 6','AOF-1496','','McGraw-Hill reading.');
INSERT INTO new_titles VALUES ('2000/10/27','A 13.105/2:R 10-MB-413','AOF-1416','','Responding to the market demand for Tongass Timber : using adaptive management to implement Sec. 101 of the 1990 Tongass');
INSERT INTO new_titles VALUES ('2000/10/27','I 29.2:P 69/4/2000','AOF-1411','','Native plants for parks : cost-effective programs for resource management, revegetation with native plants, threatened o');
INSERT INTO new_titles VALUES ('2000/10/27','L 2.120:2000-165','AOF-1398','','Employment situation of Vietnam-era veterans.');
INSERT INTO new_titles VALUES ('2000/10/27','LD3921 Matls. Sci. & Eng. L5829','AOF-1390','Liu, Wei, 1962-','Growth of oriented diamond on nickel wafers and thin films /');
INSERT INTO new_titles VALUES ('2000/10/27','LD3921 Bot. L35','AOF-1388','Langley, Susan Kathleen.','History, presettl[e]ment vegetation, and natural fire regimes of Uwharrie National Forest, Montgomery County, North Caro');
INSERT INTO new_titles VALUES ('2000/10/27','D 301.82/7:W 72/2/CD','AOF-1373','','Active Air Force wings as of 1 October 1995 ; USAF active flying, space, and missile squadrons as of 1 October 1995');
INSERT INTO new_titles VALUES ('2000/10/27','LT4210.M37 M38 2001 vol. 5','AOF-0824','','McGraw-Hill reading.');
INSERT INTO new_titles VALUES ('2000/10/27','Z253 .C59 1999','AOF-0240','Clair, Kate.','A typographic workbook : a primer to history, techniques, and artistry /');
INSERT INTO new_titles VALUES ('2000/10/27','TK7870 .C415 2000','AOF-0148','','Chemical processing of dielectrics, insulators, and electronic ceramics : Symposium held November 29-December 1, 1999, B');
INSERT INTO new_titles VALUES ('2000/10/27','TA418.9.S62 M377 2000','AOF-0147','','Materials for smart systems III : symposium held November 30-December 2, 1999, Boston, Massachusetts, U.S.A. /');
INSERT INTO new_titles VALUES ('2000/10/27','PR4588 .N45 2000','AOF-0142','Newsom, Robert, 1944-','Charles Dickens revisited /');
INSERT INTO new_titles VALUES ('2000/10/27','QA612.23 .D44 2000','AOF-0131','Dehornoy, Patrick.','Braids and self-distributivity /');
INSERT INTO new_titles VALUES ('2000/10/27','QC794.6.M85 P38 2000','AOF-0095','','Particle production spanning MeV and TeV energies /');
INSERT INTO new_titles VALUES ('2000/10/27','R857.C4 M56 2000','AOE-9735','','Mineralization in natural and synthetic biomaterials : symposium held November 29-December 1, 1999, Boston, Massachusett');
INSERT INTO new_titles VALUES ('2000/10/27','QA76.9.L63 C65 2000','AOE-9734','CL 2000 (2000 : London, England)','Computational logic--CL 2000 : First International Conference, London, UK, July 2000 : proceedings /');
INSERT INTO new_titles VALUES ('2000/10/27','TA1750 .S835 2000','AOE-9295','','Subsurface sensing technologies and applications II : 19-21 July 1999, Denver, Colorado /');
INSERT INTO new_titles VALUES ('2000/10/27','TK7874 .M3439 2000','AOE-9718','','Materials issues and modeling for device nanofabrication : symposia held November 29-December 2, 1999, Boston, Massachus');
INSERT INTO new_titles VALUES ('2000/10/27','G70.212 .A88 2000','AOE-9290','','Automated geo-spatial image and data exploitation : 24 April 2000, Orlando, USA /');
INSERT INTO new_titles VALUES ('2000/10/27','UG486 .L37 2000','AOE-9289','','Laser weapons technology : 24-25 April, 2000, Orlando, [Florida] USA /');
INSERT INTO new_titles VALUES ('2000/10/27','PA2365.E5 C53 1938','AOE-8897','','The classic Latin dictionary : Latin-English and English-Latin : compiled from the best authories of both languages : wi');
INSERT INTO new_titles VALUES ('2000/10/27','A 13.78:PNW-RP-443','AOE-8134','Youngblood, Andrew P.','Dispersal of white spruce seed on Willow Island in interior Alaska /');
INSERT INTO new_titles VALUES ('2000/10/27','A 13.78:PNW-RP-442','AOE-8131','Curtis, Robert O.','Levels-of-growing-stock cooperative study in douglas-fir : report no. 11--Stampede Creek : a 20-year progress report /');
INSERT INTO new_titles VALUES ('2000/10/27','A 13.78:PNW-RP-436','AOE-8130','Haynes, Richard W.','Monthly stumpage prices for the Pacific Northwest /');
INSERT INTO new_titles VALUES ('2000/10/27','TL725 .I54 2000','AOE-7219','International Air Transportation Conference (26th : 2000 : San Francisco, Calif.)','The 2020 vision of air transportation : emerging issues and innovative solutions : proceedings of the 26th International');
INSERT INTO new_titles VALUES ('2000/10/27','TC332 .S25 2000','AOE-7217','','Sand rights \'99 : bringing back the beaches : conference proceedings : September 23-26, 1999, Holiday Inn Ventura Resort');
INSERT INTO new_titles VALUES ('2000/10/27','TA410 .D78 2000','AOE-7211','','Durability 2000 : accelerated and outdoor weathering testing /');
INSERT INTO new_titles VALUES ('2000/10/27','TA654.6 .C464 2000','AOE-7146','','Chi-Chi, Taiwan, earthquake of September 21, 1999 : lifeline performance /');
INSERT INTO new_titles VALUES ('2000/10/27','TD886.5 .T74 2000','AOE-7139','','Transportation planning and air quality IV : persistent problems and promising solutions : conference proceedings, Novem');
INSERT INTO new_titles VALUES ('2000/10/27','QH75 .G59 2000','AOE-6892','','Global perspectives on river conservation : science, policy, and practice /');
INSERT INTO new_titles VALUES ('2000/10/27','PS3558.O34775 K58 2000','AOE-6822','Holden, Jonathan.','Knowing : new and selected poems /');
INSERT INTO new_titles VALUES ('2000/10/27','TC173 .I497 2000','AOE-5441','International Conference on Jetting Technology (15th : 2000 : Ronneby, Sweden)','15th International Conference on Jetting Technology : papers presented at the 15th International Conference on Jetting T');
INSERT INTO new_titles VALUES ('2000/10/27','DS919 .L44 2000','AOE-4543','Ballenger, Lee.','The outpost war. the U.S. Marines in Korea /');
INSERT INTO new_titles VALUES ('2000/10/27','A 13.78:PNW-RP-429','AOE-4420','Weber, John C.','Effects of stratification and temperature on seed germination speed and uniformity in central Oregon ponderosa pine (Pin');
INSERT INTO new_titles VALUES ('2000/10/27','A 13.78:PNW-RP-420','AOE-4419','Max, Timothy A.','Statistical estimators for monitoring spotted owls in Oregon and Washington in 1987 /');
INSERT INTO new_titles VALUES ('2000/10/27','DS135.I8 L6813 2000','AOD-6029','Loy, Rosetta, 1931-','First words : a childood in Fascist Italy /');
INSERT INTO new_titles VALUES ('2000/10/27','HF5679 .A34 2000','AOD-5613','Romney, Marshall B.','Accounting information systems /');
INSERT INTO new_titles VALUES ('2000/10/27','QA1 .A413 2000 suppl. issue 1','ANZ-5150','','Control in dynamic systems.');
INSERT INTO new_titles VALUES ('2000/10/27','QK568.B55 A53 2000','AOB-3929','Anderson, Norman D.','Algae : a sourcebook for teaching about harmful algal blooms /');
INSERT INTO new_titles VALUES ('2000/10/27','HD30.255 .F74 2000','AOD-5362','Freeman, R. Edward, 1951-','Environmentalism and the new logic of business : how firms can be profitable and leave our children a living planet /');
INSERT INTO new_titles VALUES ('2000/10/27','TR675 .N85 2000','ANZ-4573','','Nudes : index.');
INSERT INTO new_titles VALUES ('2000/10/27','NA1455.F53 A223 1996','ANZ-4624','Aalto, Alvar, 1898-1976.','Alvar Aalto : elmlle herkempi rakenne = a gentler structure for life = eine sensiblere Struktur fr das Leben = una st');
INSERT INTO new_titles VALUES ('2000/10/27','TR654 .F663 1993','ANZ-4129','','Frame of mind : viewpoints on photography in contemporary Canadian art /');
INSERT INTO new_titles VALUES ('2000/10/27','HV4505 .W27 1999','ANZ-4512','','The way home : ending homelessness in America /');
INSERT INTO new_titles VALUES ('2000/10/27','E99.N3 M515 1989','ANZ-4110','McAuley, Skeet.','Sign language : contemporary Southwest native America /');
INSERT INTO new_titles VALUES ('2000/10/27','NK9112 .P54 1994','ANZ-4081','Pierce, Sue.','Art quilts : playing with a full deck /');
INSERT INTO new_titles VALUES ('2000/10/27','NK9110 .V5 1990','ANZ-4077','','Visions : quilts of a new decade : eighty-three quilts from the exhibition, Visions--a new decade /');
INSERT INTO new_titles VALUES ('2000/10/27','NK9112 .V568 1998','ANZ-4072','','Visions : quilt expressions /');
INSERT INTO new_titles VALUES ('2000/10/27','NK9298.S8 A4 1999','ANZ-4070','','Threads of light : Chinese embroidery from Suzhou and the photography of Robert Glenn Ketchum /');
INSERT INTO new_titles VALUES ('2000/10/27','NK3649.5 .T33 1989','ANZ-4069','','The Tactile vessel : new basket forms : an exhibition of works from the collection of the Erie Art Museum /');
INSERT INTO new_titles VALUES ('2000/10/27','NK9112 .M46 1989','ANZ-4066','','Memories of childhood /');
INSERT INTO new_titles VALUES ('2000/10/27','NK2980 .I58 1990','ANZ-4064','','International Tapestry Network : exhibit 1 /');
INSERT INTO new_titles VALUES ('2000/10/27','NK9112 .Q5 1987','ANZ-4060','Quilt National (1987 : Athens, Ohio)','Fiber expressions, the contemporary quilt : Quilt National.');
INSERT INTO new_titles VALUES ('2000/10/27','NK3007.85 .E93 1992','ANZ-4059','','Exhibit 2, ITNET : ITNET & the Anchorage Museum of History and Art : sponsored by Alaska State Council on the Arts ... [');
INSERT INTO new_titles VALUES ('2000/10/27','TR28 .B48 1990','ANZ-4054','','Between worlds : contemporary Mexican photography /');
INSERT INTO new_titles VALUES ('2000/10/27','TR645.W182 C673 1991','ANZ-4051','','Changing reality : recent Soviet photography /');
INSERT INTO new_titles VALUES ('2000/10/27','TR681.W6 C66 1990','ANZ-4047','','Compaeras de Mxico : women photograph women.');
INSERT INTO new_titles VALUES ('2000/10/27','TR647 .S43 1997','ANZ-4039','Sekula, Allan.','Geography lesson : Canadian notes /');
INSERT INTO new_titles VALUES ('2000/10/27','TR645.W472 N673 1990','ANZ-4042','Weber, Bruce, 1951-','Fact & fiction : the state of Florida photography /');
INSERT INTO new_titles VALUES ('2000/10/27','F867 .D43 1992','ANZ-4029','Deal, Joe, 1947-','Joe Deal : southern California photographs, 1976-86 /');
INSERT INTO new_titles VALUES ('2000/10/27','RA1000.3 .H67 1996','ANZ-4034','','Hospice : a photographic inquiry /');
INSERT INTO new_titles VALUES ('2000/10/27','NX584.Z9 M672 1998','ANZ-4028','Mori, Mariko, 1967-','Mariko Mori /');
INSERT INTO new_titles VALUES ('2000/10/27','TR646.G72 E352 1990','ANZ-4025','Brittain, David.','New Scottish photography : a critical review of the work of seventeen photographers /');
INSERT INTO new_titles VALUES ('2000/10/27','TR680 .T56 1998','ANZ-4012','Townsend, Chris.','Vile bodies : photography and the crisis of looking /');
INSERT INTO new_titles VALUES ('2000/10/27','TR647 .M3924 1999','ANZ-4013','McCartney, Linda.','Wide open /');
INSERT INTO new_titles VALUES ('2000/10/27','NA1088.V66 G53 2000','ANZ-3924','Gerkan, Meinhard von, 1935-','Von Gerkan, Marg und Partner : architecture 1997-1999 /');
INSERT INTO new_titles VALUES ('2000/10/27','TR647 .D637 1993','ANZ-4011','Doherty, Willie.','Willie Doherty.');
INSERT INTO new_titles VALUES ('2000/10/27','NA1995 .W38 2000','ANZ-3914','Wasserman, Barry L.','Ethics and the practice of architecture /');
INSERT INTO new_titles VALUES ('2000/10/27','NA2728 .C62 2000','ANZ-3900','Cohen, Jonathan, 1948-','Communication and design with the Internet /');
INSERT INTO new_titles VALUES ('2000/10/27','NA2750 .D68 2000','ANZ-3895','Downing, Frances.','Remembrance and the design of place /');
INSERT INTO new_titles VALUES ('2000/10/27','GV1113.L44 M54 2000','ANZ-3852','Miller, Davis.','The Tao of Bruce Lee : a martial arts memoir /');
INSERT INTO new_titles VALUES ('2000/10/27','F1391.P6 A48 2000','ANZ-3868','Altman, Ida.','Transatlantic ties in the Spanish empire : Brihuega, Spain, and Puebla, Mexico, 1560-1620 / c Ida Altman.');
INSERT INTO new_titles VALUES ('2000/10/27','Q141 .T39 2001','ANZ-3159','Taylor, Peter Lane.','Science at the extreme : scientists on the cutting edge of discovery /');
INSERT INTO new_titles VALUES ('2000/10/27','DD862 .B436 2000','ANZ-3382','','Berlin : a century of change = Die Gesichter des Jahrhunderts /');
INSERT INTO new_titles VALUES ('2000/10/27','TA333 .S76 1999','ANZ-3138','Stothard, Dave.','Science and mathematics for engineering : intermediate GNVQ workbook /');
INSERT INTO new_titles VALUES ('2000/10/27','Q172.5.C45 B35 2000','ANZ-3133','Baladi, Viviane.','Positive transfer operators and decay of correlations /');
INSERT INTO new_titles VALUES ('2000/10/27','TT557 .S53 1994','ANZ-0697','Shaeffer, Claire B.','Claire Shaeffer\'s fabric sewing guide.');
INSERT INTO new_titles VALUES ('2000/10/27','GN666 .A23 2000','ANZ-2987','','Aboriginal women by degrees : their stories of the journey towards academic achievement /');
INSERT INTO new_titles VALUES ('2000/10/27','HD7091 .W67 2000','ANY-9402','','World labour report 2000 : income security and social protection in a changing world /');
INSERT INTO new_titles VALUES ('2000/10/27','HF5381 .S542 2000','ANZ-0659','Shenk, Ellen.','Outdoor careers : exploring occupations in outdoor fields /');
INSERT INTO new_titles VALUES ('2000/10/27','DS646.15.S76 K34 1999','ANY-9378','Kahin, Audrey.','Rebellion to integration : West Sumatra and the Indonesian polity, 1926-1998 /');
INSERT INTO new_titles VALUES ('2000/10/27','NAS 1.86:UN 3/3/CD','ANY-8213','','\"Viewing The Violent Universe\" (CD-ROM)');
INSERT INTO new_titles VALUES ('2000/10/27','HE 20.7602:T 55/4/CD-ROM','ANY-8211','','Reducing Tobacco Use, A Report Of The Surgeon General, 2000, (CD-ROM)');
INSERT INTO new_titles VALUES ('2000/10/27','I 19.76:99-430','ANY-8212','','Public Review Draft-Digital Cartographic Standard For Geological Map Symbolization, U.S. Geological Survey, Open-File Re');
INSERT INTO new_titles VALUES ('2000/10/27','NA730.N8 F37 1997','ANY-4903','','Far fetched and dear bought four architects who changed North Carolina /');
INSERT INTO new_titles VALUES ('2000/10/27','NF 3.2:F 11','ANY-4307','','Extending the reach : faculty research grants to historically black, Hispanic-serving, and tribal colleges and universit');
INSERT INTO new_titles VALUES ('2000/10/27','SE 1.2:EX 1/2','ANY-4308','','Opportunities for examiners with the SEC.');
INSERT INTO new_titles VALUES ('2000/10/27','L 36.114/3:2000-04','ANY-4305','','Women Of Hispanic Origin In The Labor Force, Facts On Working Women, No. 00-04, April 2000');
INSERT INTO new_titles VALUES ('2000/10/27','NF 3.2:B 56','ANY-4306','','Extending the reach : institutional grants to historically black, Hispanic-serving, and tribal colleges and universities');
INSERT INTO new_titles VALUES ('2000/10/27','L 36.114/3:2000-03','ANY-4304','','Hot Jobs For The 21st Century, Facts On Working Women, No. 00-03, April 2000');
INSERT INTO new_titles VALUES ('2000/10/27','L 36.114/3:2000-02','ANY-4303','','Women At The Millennium, Accomplishments And Challenges Ahead, Facts On Working Women, No. 00-02, March 2000');
INSERT INTO new_titles VALUES ('2000/10/27','L 36.108:W 84/4','ANY-4301','','Women, Work And Wages, How To Get The Job And Pay You Want, Facts On Working Women, August 1, 2000');
INSERT INTO new_titles VALUES ('2000/10/27','L 36.114/3:2000-01','ANY-4302','','20 Facts On Women Workers, Facts On Working Women, 00-01, March 2000');
INSERT INTO new_titles VALUES ('2000/10/27','L 36.102:W 84/15','ANY-4300','','Tools For Employers, Making Equal Pay A Reality In Your Workplace, Facts On Working Women, August 1, 2000');
INSERT INTO new_titles VALUES ('2000/10/27','L 36.102:W 84/14','ANY-4299','','Women\'s Bureau Publications, Facts On Working Women, August 1, 2000');
INSERT INTO new_titles VALUES ('2000/10/27','L 36.102:W 84/13','ANY-4298','United States. Women\'s Bureau.','Women\'s Bureau, U.S. Department of Labor.');
INSERT INTO new_titles VALUES ('2000/10/27','I 19.127:080-00','ANY-4296','Zapler, Mike.','Flood of July 8, 1999, in Las Vegas Valley, southern Nevada /');
INSERT INTO new_titles VALUES ('2000/10/27','I 19.127:078-00','ANY-4295','Verstraeten, I. M. (Ingrid Maria)','Minimizing the risk of herbicide transport into public water supplies : a Nebraska case study /');
INSERT INTO new_titles VALUES ('2000/10/27','HH 1.6/6:H 00-12','ANY-4294','','Procedures For Preparing, Submitting & Reviewing Rent Comparability Studies, Notice H 00-12, Issued June 29, 2000, Expir');
INSERT INTO new_titles VALUES ('2000/10/27','HH 1.6/3:IN 7/4','ANY-4293','','Making Davis-Bacon work : a practical guide for state, Indian tribes and local agencies.');
INSERT INTO new_titles VALUES ('2000/10/27','HH 1.6/3:C 76/4/2000','ANY-4292','','Making Davis-Bacon work : a contractor\'s guide to prevaling wage requirements for federally-assisted construction projec');
INSERT INTO new_titles VALUES ('2000/10/27','HH 1.2:W 12/2/SPANISH','ANY-4291','','Sus derechos al salario predominante como trabajador de la construccin en proyectos respaldados por HUD estn cubiertos');
INSERT INTO new_titles VALUES ('2000/10/27','HH 1.2:W 12/2','ANY-4290','','Your rights to prevailing wages as a construction worker on HUD-assisted projects covered by Davis-Bacon.');
INSERT INTO new_titles VALUES ('2000/10/27','HH 1.2:W 12/SPANISH','ANY-4289','','Sus derechos al salario predominante como trabajador de mantenimiento en la vivienda pblica y de los Indios.');
INSERT INTO new_titles VALUES ('2000/10/27','HH 1.2:AW 1','ANY-4287','','The Secretary\'s opportunity and empowerment award.');
INSERT INTO new_titles VALUES ('2000/10/27','HH 1.2:W 12','ANY-4288','','Your rights to prevailing wages as a maintenance worker on public and Indian housing projects.');
INSERT INTO new_titles VALUES ('2000/10/27','HE 20.3326:D 54/7','ANY-4286','','Prevent diabetes problems : keep your nervous system healthy.');
INSERT INTO new_titles VALUES ('2000/10/27','HE 20.3326:D 54/5','ANY-4284','','Prevent diabetes problems : keep your kidneys healthy.');
INSERT INTO new_titles VALUES ('2000/10/27','HE 20.3326:D 54/6','ANY-4285','','Prevent diabetes problems : keep your diabetes under control.');
INSERT INTO new_titles VALUES ('2000/10/27','HE 20.3326:D 54/4','ANY-4283','','Prevent diabetes problems : keep your eyes healthy.');
INSERT INTO new_titles VALUES ('2000/10/27','HE 20.3326:D 54/2','ANY-4281','','Prevent diabetes problems : keep your teeth and gums healthy.');
INSERT INTO new_titles VALUES ('2000/10/27','HE 20.3326:D 54/3','ANY-4282','','Prevent diabetes problems : keep your feet and skin healthy.');
INSERT INTO new_titles VALUES ('2000/10/27','HE 20.3326:D 54','ANY-4280','','Prevent diabetes problems : keep your heart and blood vessels healthy.');
INSERT INTO new_titles VALUES ('2000/10/27','D 103.8:44/2000','ANY-4278','','Port of Toledo, Ohio /');
INSERT INTO new_titles VALUES ('2000/10/27','D 103.8:49/2000','ANY-4279','','The ports of Duluth, MN, and Superior, WI : Taconite Harbor, Silver Bay, and two harbors, MN, and Ashland, WI /');
INSERT INTO new_titles VALUES ('2000/10/27','D 101.43/2:237/2000','ANY-4276','','Army adventure : tank on patrol.');
INSERT INTO new_titles VALUES ('2000/10/27','D 103.8:43/2000','ANY-4277','','Port of Cleveland, Ohio /');
INSERT INTO new_titles VALUES ('2000/10/27','J 29.13:D 84/6','ANY-4274','Wilson, Doris James.','Drug use, testing, and treatment in jails /');
INSERT INTO new_titles VALUES ('2000/10/27','S 20.2:T 91','ANY-4272','','20th century Americans.');
INSERT INTO new_titles VALUES ('2000/10/27','T 22.44/2:1275/2000','ANY-4273','','A Rainbow Of Opportunities, Volunteer Brighten Your Community, Publication 1275, Revised May 2000');
INSERT INTO new_titles VALUES ('2000/10/27','PREX 2.2:AC 1/2/NO.16','ANY-4271','','Amendments To Accounting For Property, Plant, And Equipment Etc., Number 16, September 3, 1999,');
INSERT INTO new_titles VALUES ('2000/10/27','LC 3.4/2:38 B/2000','ANY-4270','','Highlights of copyright amendments contained in the Uruguay Round Agreements Act (URAA).');
INSERT INTO new_titles VALUES ('2000/10/27','L 36.8:AU 2','ANY-4269','','Conducting audits in small unions : a guide for trustees.');
INSERT INTO new_titles VALUES ('2000/10/27','I 53.2:Al 1/6/2000','ANY-4266','','BLM in Alaska.');
INSERT INTO new_titles VALUES ('2000/10/27','I 19.42/4:00-4044','ANY-4263','','Sedimentation Survey Of Lago Guajataca, Puerto Rico, January 1999, U.S. Geological Survey, Water-Resources Investigation');
INSERT INTO new_titles VALUES ('2000/10/27','I 49.44/2:EA 7/3/2000','ANY-4262','','Eastern Neck National Wildlife Refuge : deer hunt regulations.');
INSERT INTO new_titles VALUES ('2000/10/27','SSA 1.2:N 73/2000','ANY-4257','','Social Security, Supplemental Security Income For Non-Citizens, July 2000');
INSERT INTO new_titles VALUES ('2000/10/27','SSA 1.2:AW 1','ANY-4256','','Office of Systems Requirements, Associate Commissioner\'s : honor awards ceremony.');
INSERT INTO new_titles VALUES ('2000/10/27','ED 1.341:ED 8','ANY-4255','','Educational attainment.');
INSERT INTO new_titles VALUES ('2000/10/27','FEM 1.108:J 98/2','ANY-4252','Gaynor, Jessica, Dd 1949-','Juvenile firesetter intervention handbook /');
INSERT INTO new_titles VALUES ('2000/10/27','ED 1.2:P 94/10/2000','ANY-4254','','The inside scoop for borrowers : the master promissory note for direct loan borrowers.');
INSERT INTO new_titles VALUES ('2000/10/27','TJ211 .C636 1999','ANY-2041','Conrad, James M.','Stiquito for beginners : an introduction to robotics /');
INSERT INTO new_titles VALUES ('2000/10/27','TX541 .I572 1997','ANY-2034','International Conference on Food Science and Technology (3rd : 1997 : University of California, Davis).','Food for health in the Pacific Rim : 3rd International Conference of [i.e. on] Food Science and Technology /');
INSERT INTO new_titles VALUES ('2000/10/27','K561 .H365 2000','ANY-1080','','Handbook of global legal policy /');
INSERT INTO new_titles VALUES ('2000/10/27','HD9696.65.U64 M535 1999','ANY-1075','Lewis, T. G. (Theodore Gyle), 1941-','Microsoft rising--and other tales of Silicon Valley /');
INSERT INTO new_titles VALUES ('2000/10/27','HD87 .H363 2000','ANY-0939','','Handbook of global economic policy /');
INSERT INTO new_titles VALUES ('2000/10/27','TK5105.585 .K66 1998','ANY-1034','Komar, Brian.','SAMS teach yourself TCP/IP network administration in 21 days /');
INSERT INTO new_titles VALUES ('2000/10/27','BF575.L8 M29 2000','ANX-6775','Magno, Joseph.','Self-love : the heart of healing /');
INSERT INTO new_titles VALUES ('2000/10/27','HG4355.N8 N67 2000','ANX-5880','North Carolina. General Assembly. Legislative Research Commission. Committee on Nondepository Trust Companies and Family Trust Companies.','Nondepository trust companies and family trust companies : report to the 2000 session of the 1999 General Assembly of No');
INSERT INTO new_titles VALUES ('2000/10/27','QL434 .A78 1999','ANQ-8262','','Arthropods');
INSERT INTO new_titles VALUES ('2000/10/27','QK514.P65 C793 1996','ANS-1626','','Cryptogamous plants in the forest communities of Bialowieza National Park.');
INSERT INTO new_titles VALUES ('2000/10/27','QL673 .B57 1995','ANQ-8258','','Birds characterics & adaptations /');
INSERT INTO new_titles VALUES ('2000/10/27','QP91 .B56 1997','ANQ-8256','','Blood and immunity');
INSERT INTO new_titles VALUES ('2000/10/27','QA76.76.A65 B457 1999','ANQ-2295','Benage, Don.','Building enterprise solutions with Visual Studio 6 /');
INSERT INTO new_titles VALUES ('2000/10/27','BR1463.G5 M49 1999','ANO-7466','Meyer, Birgit.','Translating the Devil : religion and modernity among the Ewe in Ghana /');
INSERT INTO new_titles VALUES ('2000/10/27','QP81.5 .M43 2000','AMH-2890','Mealey, Linda Jeanne.','Sex differences : development and evolutionary strategies /');
INSERT INTO new_titles VALUES ('2000/10/27','A 13.78:PNW-RP-427','AMD-3249','Eng, Helge.','Financial analysis of early stand treatments in southwest Oregon /');
INSERT INTO new_titles VALUES ('2000/10/27','A 13.78:PNW-RP-429','AMC-2470','Willits, Susan.','Lumber recovery from dead ponderosa pine in the Colorado Front Range /');
INSERT INTO new_titles VALUES ('2000/10/27','A 93.11/2:','ALJ-1817','','Feed outlook and situation report /');
INSERT INTO new_titles VALUES ('2000/10/27','NK2113.5 .K64 2000','ALF-5008','Koenig, Peter A.','Design graphics : drawing techniques for design professionals /');
INSERT INTO new_titles VALUES ('2000/10/27','Mf 162 no. 9115','AJS-8090','Cadisch, Georg, 1955-','Influence of phosphorus and potassium on growth and symbiotic N2 fixation of Centrosema spp. and other tropical forage l');
INSERT INTO new_titles VALUES ('2000/10/27','Mf 162 no. 11386','AJS-5943','Weiss, Martina A.,','Identification and characterization of sulfur-regulated genes in Escherichia coli MC4100 /');
INSERT INTO new_titles VALUES ('2000/10/27','Mf 162 no. 11383','AJS-5942','Alzeer, Jawad, 1963-','Towards oligosaccharide analogues of cellulose /');
INSERT INTO new_titles VALUES ('2000/10/27','Mf 162 no. 11329','AJS-5941','Kos, Jiri, 1966-','Smoking and dietary habits : the influence of nnicotinic and non-nicotinic factors /');
INSERT INTO new_titles VALUES ('2000/10/27','Mf 162 no. 11321','AJS-5940','Quadroni, Manfredo, 1967-','Characterisation of phosphorylated forms of calmodulin and the development of new techniques for analysing cell proteins');
INSERT INTO new_titles VALUES ('2000/10/27','Mf 162 no. 11319','AJS-5939','Sourlier, David Michael, 1959-','Three dimensional feature independent bestfit in coordinate metrology /');
INSERT INTO new_titles VALUES ('2000/10/27','Mf 162 no. 11310','AJS-5936','Pan, Bin, 1963-','Overexpression and functional characterisation of three isoforms of plasma membrane Ca2+-ATPase /');
INSERT INTO new_titles VALUES ('2000/10/27','Mf 162 no. 11307','AJS-5935','Genini, Michele, 1967-','Isolation and characterization of candidate tumor suppressor genes. Cloning of DRAL, a novel LIM domain protein down-reg');
INSERT INTO new_titles VALUES ('2000/10/27','Mf 162 no. 11302','AJS-5934','Schrott, Martin Franz, 1960-','Function and expression studies of PosF21, a bZIP protein in Arabidopsis thaliana /');
INSERT INTO new_titles VALUES ('2000/10/27','Mf 162 no. 11289','AJS-5931','Iwato, Tomoko, 1966-','The sodium-calcium exchanger of the heart plasma membrane : overexpression using the vaccinia virus system, cloning and');
INSERT INTO new_titles VALUES ('2000/10/27','Mf 162 no. 11284','AJS-5701','Ritz, Daniel, 1964-','Genetic and biochemical studies on the proteins encoded by the cycHJKL gene cluster, essential for the biogenesis of c-t');
INSERT INTO new_titles VALUES ('2000/10/27','Mf 162 no. 11254','AJS-5691','Vellani, Fausto Eros, 1966-','P-type ATPases from yeast to man /');
INSERT INTO new_titles VALUES ('2000/10/27','Mf 162 no. 12563','AJS-5432','Gebert, Stefan, 1967-','Effects of microbial phytase and vitamin E in fat supplemented diets for growing pigs and laying hens on performance, nu');
INSERT INTO new_titles VALUES ('2000/10/27','Mf 162 no. 12023','AJS-5210','Natsch, Andreas, 1968','Fate and ecological impact of Pseudomonas fluorescens in soil : biosafety implications for field-release of genetically-');
INSERT INTO new_titles VALUES ('2000/10/27','[microfiche] Mf 162 no. 11074','AJS-5111','Kertesz-Chaloupkov, Katerina, 1967-','Regulation of turion formation in Spirodela polyrrhiza L. /');
INSERT INTO new_titles VALUES ('2000/10/27','[microfiche] Mf 162 no. 11076','AJS-5110','Dammann, Reinhard H., 1965-','Chromatin structures and transcription of rDNA in yeast Saccharomyces cerevisiae /');
INSERT INTO new_titles VALUES ('2000/10/27','[microfiche] Mf 162 no. 11104','AJS-5105','Wernli, R. Manuela, 1957-','Investigations on the quality of spinach and on its change during cold storage /');
INSERT INTO new_titles VALUES ('2000/10/27','TK7874 .J65 1997','AJQ-9168','Johns, David, 1958-','Analog integrated circuit design /');
INSERT INTO new_titles VALUES ('2000/10/27','HF5805 .C720','AJL-6706','Black book photography (New York, N.Y. : 1998)','Black book photography.');
INSERT INTO new_titles VALUES ('2000/10/27','TS1309 .F34 1996','AIF-0799','','Fairchild\'s dictionary of textiles /');
INSERT INTO new_titles VALUES ('2000/10/27','QA76.758 .H857 1995','AIA-2119','Humphrey, Watts S., 1927-','A discipline for software engineering /');
INSERT INTO new_titles VALUES ('2000/10/27','E312.72 1987b','ACJ-2138','Washington, George, 1732-1799.','The papers of George Washington.');
INSERT INTO new_titles VALUES ('2000/10/27','QA76.9.D3 K67 1991','ACO-8325','Korth, Henry F.','Database system concepts /');
INSERT INTO new_titles VALUES ('2000/10/27','HF5439.H82 B87 1985','ACC-0406','Butterfield, Stephen.','Amway, the cult of free enterprise /');
INSERT INTO new_titles VALUES ('2000/10/27','NA1996 .A734','ABY-4612','','Architectural technology /');
INSERT INTO new_titles VALUES ('2000/10/27','NA2599.9 .D47','ABX-1543','','Design book review DBR.');
INSERT INTO new_titles VALUES ('2000/10/27','HD9715.U5 .B765','ABU-2009','Builder (Washington, D.C. : 1981)','Builder');
INSERT INTO new_titles VALUES ('2000/10/27','TH1 .M27','ABM-4340','','Building construction');
INSERT INTO new_titles VALUES ('2000/10/27','BF531 .E49 1982','ABU-1879','','Emotion in the human face /');
INSERT INTO new_titles VALUES ('2000/10/27','NA6 .A7','ABJ-9500','','Arkitektur DK');
INSERT INTO new_titles VALUES ('2000/10/27','TH3401 .A890','ABD-0803','Newsletter (Association for Preservation Technology : 1972)','Newsletter /');
INSERT INTO new_titles VALUES ('2000/10/27','TH3401 .A890','ABD-0802','Communiqu (Association for Preservation Technology)','Communiqu');
INSERT INTO new_titles VALUES ('2000/10/27','QC494 .C63','ABC-0295','','Color research and application');
INSERT INTO new_titles VALUES ('2000/10/27','NA4 .A65','ABA-8761','Architettura (Milan, Italy : 1955)','L\'Architettura');
INSERT INTO new_titles VALUES ('2000/10/27','AY67.N5 W7','AAZ-0441','','The World almanac & book of facts.');
INSERT INTO new_titles VALUES ('2000/10/27','NA6 .A7','AAW-7662','Arkitektur (Copenhagen, Denmark)','Arkitektur');
INSERT INTO new_titles VALUES ('2000/10/27','TH3401 .A87a','AAY-8202','','Bulletin of the Association for Preservation Technology.');
INSERT INTO new_titles VALUES ('2000/10/27','NA6 .A57','AAW-4478','','Architektonika themata. Architecture in Greece');
INSERT INTO new_titles VALUES ('2000/10/27','S920 .C64','AAR-2675','','Conservation directory');
INSERT INTO new_titles VALUES ('2000/10/27','DA689.G3 S35','AAW-1653','Scott, Walter Sidney, 1900-','Green retreats; the story of Vauxhall Gardens, 1661-1859.');
INSERT INTO new_titles VALUES ('2000/10/26','Course Shelf','AOF-1479','','Readings for MDS497E Brookins. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/26','','AOF-1455','Hawken, Paul','Teasing Irony (Ch.1)');
INSERT INTO new_titles VALUES ('2000/10/26','Desk File','AOF-1477','','ENG112 Prewitt readings. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/26','','AOF-1440','Hardin, Garrett','Extensions of \"The Tragedy of the Commons\"');
INSERT INTO new_titles VALUES ('2000/10/26','Course Shelf','AOF-1422','','Readings for ENG376 Kessel. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/26','LD3921 Oc. Educ. J56','AOF-1389','Johnson, Gwendolyn Sandra, 1952-','An elementary career awareness and exploration instructional model for Rowland Hill Latham Elementary School in Winston-');
INSERT INTO new_titles VALUES ('2000/10/26','LD3921 Vet. Medical Sciences. S85','AOF-1387','Suksawat, Jiraporn, 1966-','Serologic and molecular characterization of Ehrlichia species infecting dogs /');
INSERT INTO new_titles VALUES ('2000/10/26','','AOF-1297','Berg, Stig','Aging, Behavior, and Terminal Decline (ch.18)');
INSERT INTO new_titles VALUES ('2000/10/26','','AOF-1304','Belsky, J.K.','Cognitive Processes: Memory and creativity (ch.6)');
INSERT INTO new_titles VALUES ('2000/10/26','','AOF-1285','Fozard, James L.','Vision and Hearing in Aging');
INSERT INTO new_titles VALUES ('2000/10/26','','AOF-1292','Schaie, K. Warner','Intellectual Development in Adulthood (ch.15)');
INSERT INTO new_titles VALUES ('2000/10/26','','AOF-1254','Ihde, Don','Introduction: Entry Level');
INSERT INTO new_titles VALUES ('2000/10/26','LD3921 Soil Sci. S538','AOF-1231','Silva, Ivo Ribeiro da, 1970-','Aluminum rhizotoxicity in soybean : a physiological approach to cellular location, tolerance mechanisms and alleviation');
INSERT INTO new_titles VALUES ('2000/10/26','LD3921 Vet. Medical Sciences. M86','AOF-1230','Musser, Jeffrey Morgan Bridges, 1957-','Disposition and residue potential of benzylpenicillin in dairy calves fed milk containing benzylpenicillin /');
INSERT INTO new_titles VALUES ('2000/10/26','PE1591 .R7 1909','AOF-1080','Roget, Peter Mark, 1779-1869.','Thesaurus of English words and phrases, classified and arranged so as to facilitate the expression of ideas and assist i');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-691','AOF-1050','Sendak, Paul E.','Timber management and use-value assessment /');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-701','AOF-1071','Glass, Ronald J.','Recreation use of upper Pemigewasset and Swift River drainages, New Hampshire /');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-676','AOF-1027','','Test of four stand growth simulators for the northeastern United States /');
INSERT INTO new_titles VALUES ('2000/10/26','','AOF-0994','Petroski,Henry.','H.D. Thoreau,Engineer.');
INSERT INTO new_titles VALUES ('2000/10/26','','AOF-0990','Wellman,Judith','THe Seneca Falls Women\'s Rights Convention:A Study of Social Networks.');
INSERT INTO new_titles VALUES ('2000/10/26','','AOF-0935','Hartmann,Betsy','China-\"GOLD BABIES\" and Disappearing Girls.(Chapter 9)');
INSERT INTO new_titles VALUES ('2000/10/26','HE 20.3601:','AOF-0838','National Library of Medicine (U.S.)','Programs and services.');
INSERT INTO new_titles VALUES ('2000/10/26','LT4210.M37 M38 2001 vol. 4','AOF-0826','','McGraw-Hill reading');
INSERT INTO new_titles VALUES ('2000/10/26','HE 20.3601:','AOF-0837','National Library of Medicine (U.S.)','Annual report for the fiscal year /');
INSERT INTO new_titles VALUES ('2000/10/26','','AOF-0793','Cleveland, William S.','Residuals');
INSERT INTO new_titles VALUES ('2000/10/26','','AOF-0795','Cleveland, William S.','Loess');
INSERT INTO new_titles VALUES ('2000/10/26','Desk Shelf','AOF-0791','Cleveland, William S.','Elements of Graphing Data');
INSERT INTO new_titles VALUES ('2000/10/26','LD3921 Soc. S69','AOF-0295','Spann, M. Graham (Milton Graham), 1968-','A critical analysis of the relationship between ways of knowing and sense of community /');
INSERT INTO new_titles VALUES ('2000/10/26','LD3921 Adult Educ. T26','AOF-0294','Taperek, Paul S. (Paul Stephen)','Attitudes toward experiential education : a study of teachers of students with behavioral disorders /');
INSERT INTO new_titles VALUES ('2000/10/26','GV191.72 .C66 1992','AOF-0191','Cooper, Rollin B.','Campground management : how to establish and operate your campground /');
INSERT INTO new_titles VALUES ('2000/10/26','QA699 .A13 1992','AOF-0233','Abbott, Edwin Abbott, 1838-1926.','Flatland : a romance of many dimensions /');
INSERT INTO new_titles VALUES ('2000/10/26','QP121 .O887 1999','AOF-0172','','Oxygen transport to tissue XXI /');
INSERT INTO new_titles VALUES ('2000/10/26','RJ216 .S4636 2000','AOF-0170','','Short and long term effects of breast feeding on child health /');
INSERT INTO new_titles VALUES ('2000/10/26','QP188.M3 B56 2000','AOF-0168','','Biology of the mammary gland /');
INSERT INTO new_titles VALUES ('2000/10/26','B1247 .C66 2000','AOF-0143','Condren, Conal.','Thomas Hobbes /');
INSERT INTO new_titles VALUES ('2000/10/26','HF5548.32 .S46 2000','AOF-0146','','SEMPER--secure electronic marketplace for Europe /');
INSERT INTO new_titles VALUES ('2000/10/26','QA76.63 .I52 2000','AOF-0130','ILP 2000 (London, England)','Inductive logic programming : 10th International Conference, ILP 2000, London, UK, July 2000 : proceedings /');
INSERT INTO new_titles VALUES ('2000/10/26','QA75.5. C549 2000','AOF-0129','COCOON 2000 (2000 : Sydney, N.S.W.)','Computing and combinatorics : 6th annual international conference, COCOON 2000, Sydney, Australia, July 26-28, 2000 : pr');
INSERT INTO new_titles VALUES ('2000/10/26','QA75.5 .S27 2000','AOF-0114','SARA 2000 (2000 : Lake LBJ, Tex.)','Abstraction, reformulation, and approximation : 4th international symposium, SARA 2000, Horseshoe Bay, USA, July 26-29,');
INSERT INTO new_titles VALUES ('2000/10/26','QC611.8.A44 S45 2000','AOF-0094','','Self-organized processes in semiconductor alloys : symposium held November 29-December 2, 1999, Boston, Massachusetts, U');
INSERT INTO new_titles VALUES ('2000/10/26','TK7867.5 .N627 2000','AOF-0093','','Noise, oscillators, and algebraic randomness : from noise in communication systems to number theory : lectures of a scho');
INSERT INTO new_titles VALUES ('2000/10/26','PN451 .D54 vol. 230','AOE-9722','','Australian literature, 1788-1914 /');
INSERT INTO new_titles VALUES ('2000/10/26','QB51.3.I45 L37 2000','AOE-9719','','Laser guide star adaptive optics for astronomy /');
INSERT INTO new_titles VALUES ('2000/10/26','QP562.T7 T79 1999','AOE-9721','','Tryptophan, serotonin, and melatonin : basic aspects and applications /');
INSERT INTO new_titles VALUES ('2000/10/26','PN451 .D54 vol. 227','AOE-9705','','American novelists since World War II.');
INSERT INTO new_titles VALUES ('2000/10/26','J 16.1:','AOE-9361','United States. Bureau of Prisons.','Federal offenders : a review of the work of the Federal Bureau of Prisons during the year ending ... including statistic');
INSERT INTO new_titles VALUES ('2000/10/26','TA418.9.N35 C66 2000','AOE-9298','','Complex mediums : 30 July-1 August 2000, San Diego, USA /');
INSERT INTO new_titles VALUES ('2000/10/26','TA1570 .T38 2000','AOE-9297','','Targets and backgrounds VI : characterization, visualization, and the detection process : 24-26 April, 2000, Orlando, [F');
INSERT INTO new_titles VALUES ('2000/10/26','UG590 .D54 2000','AOE-9293','','Digitization of the battlespace V : and Battlefield biomedical technologies II : 24, 26-27 April, 2000, Orlando, [Florid');
INSERT INTO new_titles VALUES ('2000/10/26','QB81 .O28 2000','AOE-9288','','Observatory operations to optimize scientific return II : 27-28 March 2000, Munich, Germany /');
INSERT INTO new_titles VALUES ('2000/10/26','TK5102.5 .S54 2000','AOE-9287','','Signal processing, sensor fusion, and target recognition IX : 24-26 April, 2000, Orlando, [Florida] USA /');
INSERT INTO new_titles VALUES ('2000/10/26','GB1203.2 .W64 2000','AOE-9274','Wohl, Ellen E., 1962-','Mountain rivers /');
INSERT INTO new_titles VALUES ('2000/10/26','TK7876 .I54 2000','AOE-9283','','Intense microwave pulses VII : 24-25 April, 2000, Orlando, [Florida] USA /');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:PNW-360','AOE-8128','Hankin, David G.','Sampling designs for estimating the total number of fish in small streams /');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:PNW-350','AOE-8126','Schallau, Con H.','Economic impacts of interregional competition in the forest products industry during the 1970\'s : the South and the Paci');
INSERT INTO new_titles VALUES ('2000/10/26','QD905.2 .C83 2000','AOE-7163','','Crystallographic groups and their generalizations : workshop, Katholieke Universiteit Leuven Campus Kortrijk, Belgium, M');
INSERT INTO new_titles VALUES ('2000/10/26','NK4640.C6 Z9 2000','AOE-7005','Carpenter, Thomas H.','Summary guide to Corpus vasorum antiquorum /');
INSERT INTO new_titles VALUES ('2000/10/26','QA76.9.S88 K85 2000','AOE-6987','Kulak, Daryl, 1963-','Use cases : requirements in context /');
INSERT INTO new_titles VALUES ('2000/10/26','TA418.78 .T78 2000','AOE-6986','','Traffic and granular flow \'99 : social, traffic, and granular dynamics /');
INSERT INTO new_titles VALUES ('2000/10/26','TA660.B3 S94 2000','AOE-6985','Svetlitsky, V. A. (Valery A.), 1927-','Statics of rods /');
INSERT INTO new_titles VALUES ('2000/10/22','','AOE-9149','Boshier, Roger and John B. Collins.','Houle Typology After Twenty-Two Years: a Large-Scale Empirical Test.');
INSERT INTO new_titles VALUES ('2000/10/22','','AOE-9147','Quigley, B. Allan.','Hidden Logic: Reproduction and Resistance in Adult Literacy and Adult Basic Education.');
INSERT INTO new_titles VALUES ('2000/10/22','','AOE-9145','Courtenay, Bradley C.','Are Psychological Models of Adult Development Still Important for the Practice of Adult Education?');
INSERT INTO new_titles VALUES ('2000/10/22','','AOE-9143','Bonham, L. Adrianne.','Learning Style Instruments: Let the Buyer Beware.');
INSERT INTO new_titles VALUES ('2000/10/22','','AOE-9141','Merriam, Sharan B. and Rosemary S. Caffarella.','Characteristics and Objectives of Learners. Chapter 4.');
INSERT INTO new_titles VALUES ('2000/10/22','','AOE-9139','Brown, John Seely, et al.','Situated Cognition and the Culture of Learning.');
INSERT INTO new_titles VALUES ('2000/10/22','','AOE-9137','Hickcox, Leslie K.','Learning Styles: A Survey of Adult Learning Style Inventory Models. Chapter 2.');
INSERT INTO new_titles VALUES ('2000/10/22','','AOE-9133','Houle, Cyril O.','Two Educations. Chapter 1.');
INSERT INTO new_titles VALUES ('2000/10/22','','AOE-9135','Flannery, Daniele D.','Changing Dominant Understandings of Adults as Learners.');
INSERT INTO new_titles VALUES ('2000/10/22','','AOE-9131','Luttrell, Wendy.','Working-Class Women\'s Ways of Knowing: Effects of Gender, Race, and Class.');
INSERT INTO new_titles VALUES ('2000/10/22','','AOE-9129','Harrison,Algea O.','Black Working Women: Introduction to a Life Span Perspective.');
INSERT INTO new_titles VALUES ('2000/10/22','','AOE-9127','Schied, Fred M.','Learning in Social Context: Radical German-American Workers and Education. Chapter 3.');
INSERT INTO new_titles VALUES ('2000/10/22','HG3881 .B67913 2000','AOE-6784','Briys, Eric.','The fisherman and the rhinoceros /');
INSERT INTO new_titles VALUES ('2000/10/22','N6490 .D2385 2000','ANZ-4576','Danto, Arthur Coleman, 1924-','The Madonna of the future : essays in a pluralistic art world /');
INSERT INTO new_titles VALUES ('2000/10/22','NA2728 .U54 2000','ANZ-3896','Maher, Mary Lou.','Understanding virtual design studios /');
INSERT INTO new_titles VALUES ('2000/10/22','NA2795 .S93 2000','ANZ-3892','Swirnoff, Lois.','The color of cities : an international perspective /');
INSERT INTO new_titles VALUES ('2000/10/22','K1401 .C679 1999','ANZ-0352','Correa, Carlos Mara.','Intellectual property rights, the WTO, and developing countries : the TRIPS agreement and policy options /');
INSERT INTO new_titles VALUES ('2000/10/22','K600 .P75 2000','ANZ-0346','','Private law and social inequality in the industrial age : comparing legal cultures in Britain, France, Germany, and the');
INSERT INTO new_titles VALUES ('2000/10/22','DS127 .G28 2000','ANY-9431','Gawrych, George Walter.','The albatross of decisive victory : war and policy between Egypt and Israel in the 1967 and 1973 Arab-Israeli wars /');
INSERT INTO new_titles VALUES ('2000/10/22','BJ1533.F8 C42 2000','ANY-8467','','The challenge to friendship in modernity /');
INSERT INTO new_titles VALUES ('2000/10/22','TK7885.54 K38 2000','ANY-1048','Katz, Jon.','Geeks : how two lost boys rode the Internet out of Idaho /');
INSERT INTO new_titles VALUES ('2000/10/22','HF1531.Z4 E184 1999','ANX-7289','Dent, Christopher M., 1965-','The European Union and East Asia : an economic relationship /');
INSERT INTO new_titles VALUES ('2000/10/22','TD433 .S6','AAM-0731','Spiegler, K. S.','Salt-water purification.');
INSERT INTO new_titles VALUES ('2000/10/22','HD2117 .D4','AAD-5812','De Wilde, John C. (John Charles), 1910-','Experiences with agricultural development in tropical Africa,');
INSERT INTO new_titles VALUES ('2000/10/22','HEARING:Y4J892:S.HRG.105-366','','','');
INSERT INTO new_titles VALUES ('2000/10/26','E184.P85 P47 2000','AOE-6983','Prez y Gonzlez, Mara, 1965-','Puerto Ricans in the United States /');
INSERT INTO new_titles VALUES ('2000/10/26','LB1050.2 .F79 2000','AOE-6984','Fry, Edward Bernard, 1925-','The reading teacher\'s book of lists /');
INSERT INTO new_titles VALUES ('2000/10/26','BF367 .F675 2000','AOE-6982','Forrester, Michael A.','Psychology of the image /');
INSERT INTO new_titles VALUES ('2000/10/26','JA71 .P6332 2000','AOE-6981','','Political theory in transition /');
INSERT INTO new_titles VALUES ('2000/10/26','QA808.2 .M85 2000','AOE-6980','','Multifield problems : state of the art /');
INSERT INTO new_titles VALUES ('2000/10/26','HT169.G7 I56 2000','AOE-6978','','Introduction to planning practice /');
INSERT INTO new_titles VALUES ('2000/10/26','PQ149 .F66 2000','AOE-6941','Finch, Alison.','Women\'s writing in nineteenth-century France /');
INSERT INTO new_titles VALUES ('2000/10/26','PC3941.P63 P7513 2000','AOE-6939','Porcel, Baltasar.','Springs and autumns /');
INSERT INTO new_titles VALUES ('2000/10/26','Q183.9 .I52 2000','AOE-6929','','Intelligent data analysis in science /');
INSERT INTO new_titles VALUES ('2000/10/26','D58 .T46 2000','AOE-6927','Thomas, Rosalind, 1959-','Herodotus in context : ethnography, science, and the art of persuasion /');
INSERT INTO new_titles VALUES ('2000/10/26','SH219.6 .B64 2000','AOE-6925','Bogue, Margaret Beattie, 1924-','Fishing the Great Lakes : an environmental history, 1783-1933 /');
INSERT INTO new_titles VALUES ('2000/10/26','JS2061 .G73 2000','AOE-6924','Grindle, Merilee Serrill.','Audacious reforms : institutional invention and democracy in Latin America /');
INSERT INTO new_titles VALUES ('2000/10/26','E513.5 7th .R63 2000','AOE-6902','Robbins, Rufus, 1830?-1862?','Through ordinary eyes : the Civil War correspondence of Rufus Robbins, private, 7th Regiment, Massachusetts Volunteers /');
INSERT INTO new_titles VALUES ('2000/10/26','QC807.5 .H36 1999','AOE-6879','Handwerker, Mark J.','Ready-to-use earth & astronomical science activities for grades 5-12 /');
INSERT INTO new_titles VALUES ('2000/10/26','HT166 .L426 2000','AOE-6877','','Learning, innovation and urban evolution /');
INSERT INTO new_titles VALUES ('2000/10/26','BF175.4.S65 S73 1999','AOE-6876','Stavrakakis, Yannis.','Lacan and the political /');
INSERT INTO new_titles VALUES ('2000/10/26','QA76.73.J38 M39 2000','AOE-6875','McLaughlin, Brett.','Java and XML /');
INSERT INTO new_titles VALUES ('2000/10/26','PN1991.8.I57 B43 2000','AOE-6874','Beaman, Jim, 1959-','Interviewing for radio /');
INSERT INTO new_titles VALUES ('2000/10/26','TK7871.85 .H3335 2000','AOE-6873','','Handbook of semiconductor manufacturing technology /');
INSERT INTO new_titles VALUES ('2000/10/26','PN1993.5.A1 G54 2001','AOE-6872','Giannetti, Louis.','Flashback : a brief history of film /');
INSERT INTO new_titles VALUES ('2000/10/26','QA76.73.J38 H347 2001','AOE-6870','Halter, Steven L.','Enterprise Java performance /');
INSERT INTO new_titles VALUES ('2000/10/26','QA76.625. S63 2000','AOE-6869','Snader, Jon C., 1944-','Effective TCP/IP programming : 44 tips to improve your network programming /');
INSERT INTO new_titles VALUES ('2000/10/26','PN83 .B785 2001','AOE-6864','Browne, M. Neil, 1944-','Asking the right questions : a guide to critical thinking /');
INSERT INTO new_titles VALUES ('2000/10/26','NC1883.3.S74 M35 2000','AOE-6773','McKnight-Trontz, Jennifer.','For the record : the life and work of Alex Steinweiss /');
INSERT INTO new_titles VALUES ('2000/10/26','TS171 .E54 2000','AOE-5459','Engineering & Product Design Education Conference (2000 : Brighton, UK)','Integrating design education beyond 2000 : proceedings of the 22nd SEED Annual Design Conference and 7th National confer');
INSERT INTO new_titles VALUES ('2000/10/26','GR111.M49 C37 2000','AOE-4524','Castro, Rafaela, 1943-','Dictionary of Chicano folklore /');
INSERT INTO new_titles VALUES ('2000/10/26','HQ1236.5.U6 C55 2000','AOD-6046','Clift, Eleanor.','Madam President : shattering the last glass ceiling /');
INSERT INTO new_titles VALUES ('2000/10/26','E444.J17 A3 2000b','AOD-6025','Jacobs, Harriet A. (Harriet Ann), 1813-1897.','Incidents in the life of a slave girl /');
INSERT INTO new_titles VALUES ('2000/10/26','D804.3 .F567 2000','AOD-6022','Finkelstein, Norman G.','The Holocaust industry : reflections on the exploitation of Jewish suffering /');
INSERT INTO new_titles VALUES ('2000/10/26','F128.52 .A75 2000','AOD-5985','','Arguing the world : the New York intellectuals in their own words /');
INSERT INTO new_titles VALUES ('2000/10/26','HF5389 .H63 2000','AOD-5446','Hodge, Sheida.','Global smarts : the art of communicating and deal making anywhere in the world /');
INSERT INTO new_titles VALUES ('2000/10/26','HD1542 .B73 2000','AOD-5204','Brass, Tom, 1946-','Peasants, populism, and postmodernism : the return of the agrarian myth /');
INSERT INTO new_titles VALUES ('2000/10/26','PZ7.B327 Oz 1989','ANZ-4940','Baum, L. Frank (Lyman Frank), 1856-1919.','Ozma of Oz : a record of her adventures ... /');
INSERT INTO new_titles VALUES ('2000/10/26','TP893 .C598 1999','ANZ-4732','Colour Science \'98 (1998 : University of Leeds)','Colour Science \'98 : proceedings of the international conference & exhibition, Harrogate, April 1-3, 1998.');
INSERT INTO new_titles VALUES ('2000/10/26','N6494.B63 A773 2000','ANZ-4614','','The artist\'s body /');
INSERT INTO new_titles VALUES ('2000/10/26','NA2500 .B48 2000','ANZ-4619','Betsky, Aaron.','Architecture must burn /');
INSERT INTO new_titles VALUES ('2000/10/26','NA737.K32 L62 2000','ANZ-4611','Lobell, John.','Between silence and light : spirit in the architecture of Louis I. Kahn /');
INSERT INTO new_titles VALUES ('2000/10/26','NA109.E9 A25 1998','ANZ-3923','','Abitare la storia : le dimore storiche-museo : restauro, sicurezza, didattica, comunicazione : atti del convegno /');
INSERT INTO new_titles VALUES ('2000/10/26','PA3014.N37 L69 2000','ANZ-3875','Lowe, N. J.','The classical plot and the invention of Western narrative /');
INSERT INTO new_titles VALUES ('2000/10/26','DS558 .H83 2000','ANZ-3871','','The human tradition in the Vietnam era /');
INSERT INTO new_titles VALUES ('2000/10/26','B935 .A44 2000','ANZ-3863','','American continental philosophy : a reader /');
INSERT INTO new_titles VALUES ('2000/10/26','HQ1190 .M393 2000','ANZ-3850','McNay, Lois.','Gender and agency : reconfiguring the subject in feminist and social theory /');
INSERT INTO new_titles VALUES ('2000/10/26','KZ4028 .T47 2000','ANZ-3846','Terrett, Steve.','The dissolution of Yugoslavia and the Badinter Arbitration Commission : a contextual study of peace-making efforts in th');
INSERT INTO new_titles VALUES ('2000/10/26','QA11 .C483 1998','ANZ-3474','Chinn, Stephen J.','Mathematics for dyslexics : a teaching handbook /');
INSERT INTO new_titles VALUES ('2000/10/26','QC793.5.E627 I545 2000','ANZ-3129','','Insertion devices for synchrotron radiation and free electron laser /');
INSERT INTO new_titles VALUES ('2000/10/26','QA331.5 .B88 2000','ANZ-2985','Butnariu, Dan.','Totally convex functions for fixed points computation and infinite dimensional optimization /');
INSERT INTO new_titles VALUES ('2000/10/26','ML197 .S545 2000','ANZ-0444','Sharma, Bhesham R., 1961-','Music and culture in the age of mechanical reproduction /');
INSERT INTO new_titles VALUES ('2000/10/26','F1789.N3 P47 2000','ANZ-0438','','Afro-Cuban voices : on race and identity in contemporary Cuba /');
INSERT INTO new_titles VALUES ('2000/10/26','E183.8.C5 T283 2000','ANZ-0427','','Taiwan Strait dilemmas : China-Taiwan-U.S. policies in the new century /');
INSERT INTO new_titles VALUES ('2000/10/26','BT709.5 .M66 2000','ANZ-0419','Montgomery, Marion.','Making : the proper habit of our being : essays speculative, reflective, argumentative /');
INSERT INTO new_titles VALUES ('2000/10/26','D857 .H63 2000','ANY-9436','Hobsbawm, E. J. (Eric J.), 1917-','On the edge of the new century /');
INSERT INTO new_titles VALUES ('2000/10/26','DS119.76 .M57 2000','ANY-9426','Mishal, Shaul, 1945-','The Palestinian Hamas : vision, violence, and coexistence /');
INSERT INTO new_titles VALUES ('2000/10/26','QA279 .D467 1999','ANY-9398','Dey, Aloke.','Fractional factorial plans /');
INSERT INTO new_titles VALUES ('2000/10/26','Y 1.1/4:106-26','ANY-9012','Bolivia.','Investment treaty with Bolivia : message from the President of the United States transmitting Treaty between the Governm');
INSERT INTO new_titles VALUES ('2000/10/26','RC142.5 .L85 2000','ANY-9357','','Lymphatic filariasis /');
INSERT INTO new_titles VALUES ('2000/10/26','HD61 .P76 2000','ANY-8568','','The professional\'s handbook of financial risk management /');
INSERT INTO new_titles VALUES ('2000/10/26','QL688.C9 G38 2000','ANY-7378','Garrido, Orlando H.','Field guide to the birds of Cuba /');
INSERT INTO new_titles VALUES ('2000/10/26','DS394.73.I4 J33 2000','ANY-8540','Jacques, Kathryn, 1957-','Bangladesh, India, and Pakistan : international relations and regional tensions in South Asia /');
INSERT INTO new_titles VALUES ('2000/10/26','TK7874.76 .A313 1998','ANY-5192','','Advanced metallization and interconnect systems for ULSI applications in 1997 : proceedings of the conference held Septe');
INSERT INTO new_titles VALUES ('2000/10/26','DS463 .R385 1999','ANY-5069','Raychaudhuri, Tapan.','Perceptions, emotions, sensibilities : essays on India\'s colonial and post-colonial experiences /');
INSERT INTO new_titles VALUES ('2000/10/26','SB324.3 .C64 1999','ANY-3639','Coleman, Eliot, 1938-','Four-season harvest : organic vegetables from your home garden all year around /');
INSERT INTO new_titles VALUES ('2000/10/26','RL243 .A866 2000','ANY-5013','','Atopic dermatitis : the epidemiology, causes, and prevention of atopic eczema /');
INSERT INTO new_titles VALUES ('2000/10/26','TK7874.76 .A312 1997','ANY-3468','','Advanced metallization and interconnect systems for ULSI applications in 1996 : proceedings of the conference held Octob');
INSERT INTO new_titles VALUES ('2000/10/26','QC670 .R4 1993','ANY-2101','Reitz, John R.','Foundations of electromagnetic theory /');
INSERT INTO new_titles VALUES ('2000/10/26','TX546 .D47 1997','ANY-2256','','Descriptive sensory analysis in practice /');
INSERT INTO new_titles VALUES ('2000/10/26','TP683 .K5713 1998','ANY-2036','Kiritsakis, Apostolos K. (Apostolos Konstantinoy)','Olive oil : from the tree to the table /');
INSERT INTO new_titles VALUES ('2000/10/26','QR121 .M37 1998','ANY-2035','Marth, Elmer H.','Dairy foods safety, 1995-1996 : a compendium of edited summaries from the world\'s literature /');
INSERT INTO new_titles VALUES ('2000/10/26','HD9685.A2 P48 1999','ANY-1671','Philipson, Lorrin, 1945-','Understanding electric utilities and de-regulation /');
INSERT INTO new_titles VALUES ('2000/10/26','TX360.U6 R65 1982','ANY-2020','','The Role of food product development in implementing dietary guidelines : proceedings of an international conference /');
INSERT INTO new_titles VALUES ('2000/10/26','TK5105.585 .C37 1998','ANY-1043','Casad, Joe, 1958-','Sams teach yourself TCP/IP in 24 hours /');
INSERT INTO new_titles VALUES ('2000/10/26','HD66 .M354 1997','ANY-0406','','Managing team performance : evaluation, measurement, rewards /');
INSERT INTO new_titles VALUES ('2000/10/26','QA76.6 .P4644 1998','ANY-1033','Perry, Greg M.','Sams teach yourself beginning programming in 24 hours /');
INSERT INTO new_titles VALUES ('2000/10/26','ML410.B1 W793 2000','ANY-0401','Wolff, Christoph.','Johann Sebastian Bach : the learned musician /');
INSERT INTO new_titles VALUES ('2000/10/26','HD38.5 .R675 1998','ANX-7570','Ross, David Frederick, 1948-','Competing through supply chain management : creating market-winning strategies through supply chain partnerships /');
INSERT INTO new_titles VALUES ('2000/10/26','HG5422 .L46 1998','ANX-7296','Lemmen, Jan, 1966-','Integrating financial markets in the European Union /');
INSERT INTO new_titles VALUES ('2000/10/26','ML3556 .R3 2000','ANX-7227','Ramsey, Frederic, 1915-','Been here and gone /');
INSERT INTO new_titles VALUES ('2000/10/26','BF39.4 .C76 2000','ANX-6773','Crossley, Michele L., 1969-','Introducing narrative psychology : self, trauma, and the construction of meaning /');
INSERT INTO new_titles VALUES ('2000/10/26','HB145 .W32 1997','ANX-7214','Walker, Donald A. (Donald Anthony), 1934-','Advances in general equilibrium theory /');
INSERT INTO new_titles VALUES ('2000/10/26','Y 1.1/5:106-304','ANW-9245','United States. Congress. Senate. Committee on Appropriations.','Legislative branch appropriations, 2001 : report (to accompany S. 2603).');
INSERT INTO new_titles VALUES ('2000/10/26','Y 1.1/5:106-291','ANW-9230','United States. Congress. Senate. Committee on Appropriations.','Foreign operations, export financing, and related programs appropriation bill, 2001 : report (to accompany S. 2522).');
INSERT INTO new_titles VALUES ('2000/10/26','Y 1.1/5:106-290','ANW-9227','United States. Congress. Senate. Committee on Appropriations.','Military construction appropriation bill, 2001 : report (to accompany S. 2521).');
INSERT INTO new_titles VALUES ('2000/10/26','Y 1.1/5:106-289','ANW-9222','United States. Congress. Senate. Committee on Small Business.','Small Business Innovation Research Program Reauthorization Act of 2000 : report (to accompany H.R. 2392).');
INSERT INTO new_titles VALUES ('2000/10/26','Y 1.1/5:106-297','ANW-9052','United States. Congress. Senate. Committee on Agriculture, Nutrition, and Forestry.','Animal Welfare Act amendments : report (to accompany S. 345).');
INSERT INTO new_titles VALUES ('2000/10/26','Y 1.1/5:106-279/CORR.','ANW-9050','United States. Congress. Senate. Select Committee on Intelligence.','Authorizing appropriations for fiscal year 2001 for the intelligence activities of the United States government and the');
INSERT INTO new_titles VALUES ('2000/10/26','I 19.76:99-95','ANW-8307','','NOTES ON NUMERICAL RELIABILITY OF SEVERAL STATISTICAL ANALYSIS PROGRAMS LANDWEHR, J.M., ET AL.');
INSERT INTO new_titles VALUES ('2000/10/26','I 19.76:99-587','ANW-8306','','PRELIMINARY REPORT ON DEPOSIT MODELS FOR SAND AND GRAVEL IN THE CACHE LA POUDRE RIVER VALLEY LANGER, WILLIAM H., LINDSE');
INSERT INTO new_titles VALUES ('2000/10/26','I 19.76:99-584','ANW-8305','','GEOCHEMICAL DATA FOR STREAM-SEDIMENT, HEAVY-MINERAL-CONCENTRATE, AND ROCK SAMPLES COLLECTED FROM THE FORTYSEVEN CREEK G');
INSERT INTO new_titles VALUES ('2000/10/26','I 19.76:99-555','ANW-8303','','THE SILENT CANYON CALDERA COMPLEX - A THREE DIMENSIONAL MODEL BASE ON DRILL-HOLE STRATIGRAPHY AND GRAVITY INVERSION MC');
INSERT INTO new_titles VALUES ('2000/10/26','I 19.76:99-570','ANW-8304','','A SEISMIC-REFLECTION INVESTIGATION OF GAS HYDRATES AND SEA-FLOOR FEATURES OF THE UPPER CONTINENTAL SLOPE OF THE GARDEN');
INSERT INTO new_titles VALUES ('2000/10/26','I 19.76:99-537','ANW-8302','','ANALYTICAL RESULTS FOR 35 MINE-WASTE TAILINGS CORES AND SIX BED-SIDIMENT SAMPLES, AND AN ETIMATE OF THE VOLUME OF CONTA');
INSERT INTO new_titles VALUES ('2000/10/26','I 19.76:99-504','ANW-8301','Roberts, Sebastian.','Landslides in Alameda County, California, a digital database extracted from preliminary photointerpretation maps of surf');
INSERT INTO new_titles VALUES ('2000/10/26','I 19.76:99-414 A','ANW-8300','Boleneus, D. E.','Geologic datasets for weights of evidence analysis in northeast Washington.');
INSERT INTO new_titles VALUES ('2000/10/26','I 19.76:99-390','ANW-8299','','Digital geologic map of the Wallace 1:100,000 quadrangle, Idaho');
INSERT INTO new_titles VALUES ('2000/10/23','','AOE-9568','Myers, Helen, ed.','Theory and Method: Organology');
INSERT INTO new_titles VALUES ('2000/10/23','','AOE-9562','McKeachie, Wilbert J.','Peer Learning, Collaborative Learning, Cooperative Learning (Ch.14)');
INSERT INTO new_titles VALUES ('2000/10/23','Desk File','AOE-9555','','NTR415 Croom lesson 21. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/23','Desk File','AOE-9553','','NTR415 Croom lesson 20. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/23','Desk File','AOE-9551','','NTR415 Croom lesson 19. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/23','Desk File','AOE-9549','','NTR415 Croom lesson 18. [Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/23','','AOE-9545','Rice, James A. et al.','Growth Rate Variation and Larval Survival Inferences From an Individual-Based Size-Dependent Predation Model.');
INSERT INTO new_titles VALUES ('2000/10/23','','AOE-9543','Brown, K.S.','New Model Charts Swings in Crab Populations.');
INSERT INTO new_titles VALUES ('2000/10/23','','AOE-9511','Barber, John and Mark Harrison','Social Order (Ch.6) / Tables');
INSERT INTO new_titles VALUES ('2000/10/23','','AOE-9531','Getty, J.Arch and Oleg V. Naumov','Conclusion');
INSERT INTO new_titles VALUES ('2000/10/23','','AOE-9541','Kerr, Richard A.','Dueling Models: Future U.S. Climate Uncertain.');
INSERT INTO new_titles VALUES ('2000/10/23','','AOE-9481','Barber, John and Mark Harrison','Costs of Victory / Mobilization (Ch.4)');
INSERT INTO new_titles VALUES ('2000/10/23','','AOE-9407','ARC 543 Students','Analysis of precedents');
INSERT INTO new_titles VALUES ('2000/10/23','SH335 .S45 1972','AOE-9413','Seminar on Mechanical Recovery and Utilization of Fish Flesh (1st : 1972 : Washington','First Technical Seminar on Mechanical Recovery and Utilization of Fish Flesh, Washington, D. C. , September 21-22, 1972');
INSERT INTO new_titles VALUES ('2000/10/23','PREX 3.10/4:W 89/44','AOE-9351','United States. Central Intelligence Agency.','[Political map of the world].');
INSERT INTO new_titles VALUES ('2000/10/23','D 305.24:7','AOE-9272','Reynolds, Rosalind R.','Nuclear proliferation the diplomatic role of non-weaponized programs /');
INSERT INTO new_titles VALUES ('2000/10/23','D 305.24:8','AOE-9270','Roberts, Guy B.','Five minutes past midnight the clear and present danger of nuclear weapons grade fissile materials /');
INSERT INTO new_titles VALUES ('2000/10/23','Course Shelf','AOE-9263','Geertz, Clifford.','Interpretation of Cultures: Selected Essays.');
INSERT INTO new_titles VALUES ('2000/10/23','Course Shelf','AOE-9261','Tsing, Anna Lowenhaupt.','In the Realm of the Diamond Queen: Marginality in an Out-of-the-Way Place.');
INSERT INTO new_titles VALUES ('2000/10/23','Course Shelf','AOE-9257','Shostak, Marjorie.','Nisa: the Life and Words of a !Kung Woman.');
INSERT INTO new_titles VALUES ('2000/10/23','LD3921 Zool. L53','AOE-9251','Lichstein, Jeremy William.','Landscape effects on breeding songbird abundance in managed southern Appalachian forests');
INSERT INTO new_titles VALUES ('2000/10/23','LD3921 Civil Eng. D2455','AOE-9249','Das, Satrajit, 1966-','Seismic design of vertically irregular reinforced concrete structures');
INSERT INTO new_titles VALUES ('2000/10/23','Course Shelf','AOE-9246','Barley, Nigel.','Innocent Anthropologist: Notes From a Mud Hut.');
INSERT INTO new_titles VALUES ('2000/10/23','I 28.160:','AOE-9199','','Gallium in ...');
INSERT INTO new_titles VALUES ('2000/10/23','PrEx 10.24:N 81 c/1967','AOE-9221','','Summary of federal programs : a report of federal program impact on the local community, FY 1967 /');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-96-114','AOE-9180','Sturos, John A.','Theoretical methods for estimating moments of inertia of trees and boles /');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.151/5:RMRS-P-12','AOE-9037','North American Science Symposium (1998 : Guadalajara, Mexico)','North American Science Symposium : toward a unified framework for inventorying and monitoring forest ecosystem resources');
INSERT INTO new_titles VALUES ('2000/10/23','A 53.2:N 21/5','AOE-9004','Trn, Huong, N.','Natural resources conservation laws : a report on 17 states and their selected counties and townships /');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.105/2:R8-MB-85B','AOE-8973','','Draft environmental impact statement for the revised land and resource management plan : Croatan National Forest, Carter');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.151/5:RMRS-P-6','AOE-8923','International Union of Forest Research Organizations : Group 6.06.00 Workshop (1998 : Qubec, Qubec)','Cooperative strategies for forest science management and leadership in an increasingly complex and globalized world : pr');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.88:NC-209','AOE-8922','International Boreal Forest Research Association. Meeting (6th : 1997 : Duluth, Minn.)','Disturbance in boreal forest ecosystems : human impacts and natural processes : proceedings of the International Boreal');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.88: PNW-GTR-494','AOE-8814','','Alternatives to clearcutting in the old-growth forests of southeast Alaska : study plan and establishment report /');
INSERT INTO new_titles VALUES ('2000/10/23','LT4210.M37 M38 2001 vol. 1','AOE-8243','','McGraw-Hill reading.');
INSERT INTO new_titles VALUES ('2000/10/23','JC181.K4 F585 2000','AOE-6912','Flikschuh, Katrin.','Kant and modern political philosophy /');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:PNW-324','AOE-8119','Nystrom, Michael Nels.','Development of young growth western redcedar stands /');
INSERT INTO new_titles VALUES ('2000/10/23','GE180 .N68 2000','AOE-6903','Novotny, Patrick.','Where we live, work and play : the environmental justice movement and the struggle for a new environmentalism /');
INSERT INTO new_titles VALUES ('2000/10/23','D421 .R47 2000','AOE-6901','Richards, Michael D.','Term paper resource guide to twentieth-century world history /');
INSERT INTO new_titles VALUES ('2000/10/23','QA76.73.P22 W35 2000','AOE-6899','Wall, Larry.','Programming Perl /');
INSERT INTO new_titles VALUES ('2000/10/23','LB2822.82 .R45 2000','AOE-6900','','Restructuring education : innovations and evaluations of alternative systems /');
INSERT INTO new_titles VALUES ('2000/10/23','QA76.73.J38 H37 2000','AOE-6897','Harold, Elliotte Rusty.','Java network programming /');
INSERT INTO new_titles VALUES ('2000/10/23','QA76.76.H94 M875 2000','AOE-6895','Musciano, Chuck.','HTML and XHTML, the definitive guide /');
INSERT INTO new_titles VALUES ('2000/10/23','QA76.624. C93 2000','AOE-6891','Czarnecki, Krzysztof.','Generative programming : methods, tools, and applications /');
INSERT INTO new_titles VALUES ('2000/10/23','QA47 .J38 2000','AOE-6801','Jeffrey, Alan.','Handbook of mathematical formulas and integrals /');
INSERT INTO new_titles VALUES ('2000/10/23','PQ6085 .U75 2000','AOE-6402','Ura Maqua, Isabel.','Panorama crtico del mester de clereca /');
INSERT INTO new_titles VALUES ('2000/10/23','QA76.9.D37 D62 2000','AOE-6782','Dodge, Gary, 1951-','Essential Oracle8i data warehousing : designing, building, and managing Oracle data warehouses /');
INSERT INTO new_titles VALUES ('2000/10/23','HQ1075.5.E852 G35 2000','AOA-5916','Gal, Susan, 1949-','The politics of gender after socialism : a comparative-historical essay /');
INSERT INTO new_titles VALUES ('2000/10/23','TR350 .C66 2000','ANZ-4601','','Coming into focus : a step-by-step guide to alternative photographic printing processes /');
INSERT INTO new_titles VALUES ('2000/10/23','NA682.O73 .W56 2000','ANZ-4582','Wines, James, 1932-','Green architecture /');
INSERT INTO new_titles VALUES ('2000/10/23','N6953.S65 A4 1999','ANZ-4531','Smit, Robert, 1941-','Robert Smit : empty house = leeres Haus = casa vuota.');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.88:NC-213','ANZ-3669','Forest Inventory and Analysis Symposium (1st : 1999 : San Antonio, Tex.)','Proceedings of the 1st annual Forest Inventory and Analysis Symposium : November 2-3, 1999, San Antonio Airport Hilton,');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.88:RMRS-GTR-53','ANZ-3668','Loftus, Andrew J.','Fish and other aquatic resource trends in the United States : a technical document supporting the 2000 USDA Forest Servi');
INSERT INTO new_titles VALUES ('2000/10/23','PT2525.Z5 R34 2000','ANZ-3375','Ragg-Kirkby, Helena.','Adalbert Stifter\'s late prose : the mania for moderation /');
INSERT INTO new_titles VALUES ('2000/10/23','BX1491.A2 L56 2000','ANZ-2883','Lingard, John, 1771-1851.','The letters of Dr. John Lingard to Mrs. Thomas Lomax : (1835-51) /');
INSERT INTO new_titles VALUES ('2000/10/23','LT4210.H37 F37 2000','ANZ-1770','Farr, Roger C.','Collections. a Harcourt reading ; language arts program.');
INSERT INTO new_titles VALUES ('2000/10/23','BD214 .C535 2000','ANZ-0434','Clark, Austen.','A theory of sentience /');
INSERT INTO new_titles VALUES ('2000/10/23','JC423 .M7363 2000','ANZ-0360','Mouffe, Chantal.','The democratic paradox /');
INSERT INTO new_titles VALUES ('2000/10/23','D765 .H45 2000','ANY-9411','Hempel, Andrew.','Poland in World War II : an illustrated military history /');
INSERT INTO new_titles VALUES ('2000/10/23','PK2198.G4 Z835 2000','ANY-9393','Prigarina, Natal\'ia Il\'inichna.','Mirza Ghalib : a creative biography /');
INSERT INTO new_titles VALUES ('2000/10/23','DD257.25 .A57 2000','ANY-9372','Alter, Peter.','The German question and Europe : a history /');
INSERT INTO new_titles VALUES ('2000/10/23','CB351 .P41413 2000','ANY-9366','Pernoud, Rgine, 1909-','Those terrible Middle Ages : debunking the myths /');
INSERT INTO new_titles VALUES ('2000/10/23','T27.J3 C85 2000','ANY-9365','','Culture and technology in modern Japan /');
INSERT INTO new_titles VALUES ('2000/10/23','Y 4.AP 6/1:V 64/4/2001/PT.-','ANY-9053','United States. Congress. House. Committee on Appropriations. Subcommittee on VA, HUD, and Independent Agencies.','Departments of Veterans Affairs and Housing and Urban Development, and independent agencies appropriations for 2001 : he');
INSERT INTO new_titles VALUES ('2000/10/23','[videocass.] DS421 .M34 1998','ANY-6316','','Maharajah Burger');
INSERT INTO new_titles VALUES ('2000/10/23','SF774.5 .B729 1999','ANY-7296','','BSAVA manual of advanced veterinary nursing /');
INSERT INTO new_titles VALUES ('2000/10/23','T175 .B83 2000','ANY-3495','Buderi, Robert.','Engines of tomorrow : how the world\'s best companies are using their research labs to win the future /');
INSERT INTO new_titles VALUES ('2000/10/23','TK7895.M4 S36 2000','ANY-3492','Scott, J. F. (James Floyd), 1942-','Ferroelectric memories /');
INSERT INTO new_titles VALUES ('2000/10/23','PR9387.9.S27 S68 1994','ANY-1587','Saro-Wiwa, Ken, 1941-','Sozaboy : a novel in rotten English /');
INSERT INTO new_titles VALUES ('2000/10/23','LC5800 .T87 2000','ANY-1259','Turlington, Shannon R.','The unofficial guide to distance learning /');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.88:PNW-GTR-449','ANX-4683','DeForest, Christopher E.','Watershed restoration, jobs-in-the-woods, and community assistance : Redwood National Park and the Northwest Forest Plan');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.88:PNW-GTR-453','ANX-4680','Horne, Amy L.','Developing measures of socioeconomic resiliency in the interior Columbia Basin /');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.88:PNW-GTR-459','ANX-4678','','Influence of stream characteristics and grazing intensity on stream temperatures in eastern Oregon /');
INSERT INTO new_titles VALUES ('2000/10/23','BL624 .L45 2000','ANX-0358','Lerner, Michael, 1943-','Spirit matters /');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:FPL-RP-584','ANW-8588','','Role of construction debris in release of copper, chromium, and arsenic from treated wood structures');
INSERT INTO new_titles VALUES ('2000/10/23','TS169 .S76 1998','ANW-1610','Stock, James R.','Development and implementation of reverse logistics programs /');
INSERT INTO new_titles VALUES ('2000/10/23','RC530 .A3 1999','ANS-3303','Adler, Alfred, 1870-1937.','Alfred Adler : problems of neurosis : a book of case histories /');
INSERT INTO new_titles VALUES ('2000/10/23','QK514.P65 C79 1997','ANS-1776','','Cryptogamous plants in the forest communities of Bialowieza National Park.');
INSERT INTO new_titles VALUES ('2000/10/23','Y 4.AP 6/1:IN 8/6/2001/PT.1-','ANR-9770','United States. Congress. House. Committee on Appropriations. Subcommittee on Dept. of the Interior and Related Agencies.','Department of the Interior and related agencies appropriations for 2001 : hearings before a subcommittee of the Committe');
INSERT INTO new_titles VALUES ('2000/10/23','Y 1.1/7:106-195','ANQ-8423','United States. President (1993- : Clinton)','Report concerning emigration laws and policies of Albania : message from the President of the United States transmitting');
INSERT INTO new_titles VALUES ('2000/10/23','Y 1.1/7:106-196','ANQ-8422','United States. President (1993- : Clinton)','Appropriations for Health and Human Services : communication from the President of the United States transmitting the re');
INSERT INTO new_titles VALUES ('2000/10/23','Y 1.1/7:106-190','ANQ-8421','United States. President (1993- : Clinton)','Six month periodic reports on terrorists who threaten the Middle East peace process : message from the President of the');
INSERT INTO new_titles VALUES ('2000/10/23','Y 1.1/7:106-194','ANQ-8420','United States. President (1993- : Clinton)','Rescissions and deferrals of budget authority : message from the President of the United States transmitting a report of');
INSERT INTO new_titles VALUES ('2000/10/23','Y 1.1/7:106-198','ANQ-6995','United States. President (1993- : Clinton)','Supplemental appropriations for fiscal year 2000 : communication from the President of the United States transmitting su');
INSERT INTO new_titles VALUES ('2000/10/23','Y 1.1/7:106-199','ANQ-6993','United States. President (1993- : Clinton)','Budget program revisions for the Commodity Credit Corporation for fiscal year 2000 and fiscal year 2001 : communication');
INSERT INTO new_titles VALUES ('2000/10/23','Y 1.1/7:106-193','ANQ-6945','United States. President (1993- : Clinton)','Appropriations for the Federal Emergency Management Agency : communication from the President of the United States trans');
INSERT INTO new_titles VALUES ('2000/10/23','I 53.59:B 54/DRAFT','ANP-4791','United States. Bureau of Land Management. Glasgow Field Station.','Bitter Creek and Mountain Plover areas of critical environmental concern resource management plan amendment and environm');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.88:PNW-GTR-468','ANP-4790','','Biological characteristics and population status of anadromous salmon in southeast Alaska');
INSERT INTO new_titles VALUES ('2000/10/23','Y 1.1/7:106-187','ANP-4776','','PROCEEDINGS OF 81ST NATIONAL CONVENTION OF THE AMERICAN LEGION... HOUSE DOCUMENT 106-187... 106TH CONGRESS, 2D SESSION');
INSERT INTO new_titles VALUES ('2000/10/23','Y 1.1/7:106-181','ANP-4773','United States. President (1993- : Clinton)','Potential threats facing NATO : message from the President of the United States transmitting a report on potential threa');
INSERT INTO new_titles VALUES ('2000/10/23','Y 1.1/7:106-180','ANP-4772','United States. President (1993- : Clinton)','A report on the Cyprus question : communication from the President of the United States transmitting progress toward a n');
INSERT INTO new_titles VALUES ('2000/10/23','Y 1.1/7:106-182','ANP-3115','United States. Office of Management and Budget.','OMB final sequestration report for fiscal year 2000 : communication from the director, the Office of Management and Budg');
INSERT INTO new_titles VALUES ('2000/10/23','Y 1.1/7:106-179','ANP-1722','United States. President (1993- : Clinton)','Supplemental report on peacekeeping efforts in Kosovo : communication from the President of the United States transmitti');
INSERT INTO new_titles VALUES ('2000/10/23','Y 1.1/7:106-189','ANP-1636','Latvia.','U.S. and Republic of Latvia fishing agreement : message from the President of the United States transmitting an agreemen');
INSERT INTO new_titles VALUES ('2000/10/23','Y 1.1/7:106-178','ANP-1620','United States. President (1993- : Clinton)','6-month periodic report on the national emergency declared by Executive Order 13047 : communication from the President o');
INSERT INTO new_titles VALUES ('2000/10/23','Y 1.1/7:106-183','ANP-1586','United States. President (1993- : Clinton)','Budget request for Health and Human Services : communication from the President of the United States transmitting the bu');
INSERT INTO new_titles VALUES ('2000/10/23','LT4410.H42 L37 2001 vol. 1','ANE-1700','','McDougal Littell Algebra 1 /');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-332','AND-0627','Schmidt, Thomas L.','The forest resources of Nebraska');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-331','AND-0875','Ostry, Michael E.','Interactions of insects, woodpeckers, and hypoxylon canker on aspen');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-330','ANB-2738','Davis, Alaina.','Site preparation treatments and browse protection affect establishment and growth of northern white-cedar');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-328','AMY-9400','Davis, Alaina.','Site preparation treatments and their effects on establishment and growth of tamarack');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-326','AMV-9189','Buech, Richard R.','Biomass of food available to beavers on five Minnesota shrubs');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-325','AMT-8977','Buech, Richard R.','Biomass relations for components of five Minnesota shrubs');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-322','AMT-1268','Sturos, John A.','Performance of a logging truck with a central tire inflation system');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-317','AMR-1346','Bragg, Don C.','Field identification of birdseye in sugar maple (Acer saccharum Marsh.)');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-316','AMR-1342','Ponder, Felix.','Leguminous ground covers could reduce herbicide use in forestry');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-312','AMR-0325','Mattson, James A.','Tree-section harvesting of northern hardwood thinnings');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-304','AMQ-9674','','Regional impacts of technical change the case of structural particleboard in the United States /');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-320','AMQ-8702','','Field performance of Populus in short-rotation intensive culture plantations in the north-central U.S.');
INSERT INTO new_titles VALUES ('2000/10/23','GP 3.30/3:','AMP-4462','Federal Depository Library Conference.','Proceedings of the ... annual Federal Depository Library Conference ... and Regional Federal Depository Seminar.');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-318','AMP-1997','','Southern pulpwood harvesting productivity and cost changes between 1979 and 1987');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-314','AMN-3314','Perala, Donald A.','Allometric biomass estimators for Aspen-dominated ecosystems in the upper Great Lakes');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-315','AMN-2600','','Soil and vegetation response to soil compaction and forest floor removal after aspen harvesting');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-303','AMM-5230','Wiberg-Carlson, Dawn.','Modeling and mapping urban bicyclists\' preferences for trail environments');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-313','AML-8117','Schroeder, Herbert W.','Visual quality of human-made clearings in central Michigan conifers');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-302','AMM-5160','Strong, Terry F.','Response of three Populus species to drought');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-308','AMH-8017','','Ground-application trial of hexazinone on the Ottawa National Forest');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-309','AMI-8356','Hansen, Edward.','Mid-rotation yields of biomass plantations in the north central United States');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-305','AMG-2957','Harris, A. Ray.','Ion movement in acidified, low base saturated sand soils');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-310','AMH-4369','Brand, Gary J.','Synecological coordinates as indicators of variation in red pine productivity among TWINSPAN classes a case study /');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-307','AMG-0956','Rogers, Lynn L.','Estimation of shrub leaf biomass available to white-tailed deer');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-301','AMF-7425','Benyus, Janine M.','Wildlife in the upper Great Lakes region a community profile /');
INSERT INTO new_titles VALUES ('2000/10/23','SF601 .A675','ALT-4536','Annual report (British Veterinary Association)','Annual report /');
INSERT INTO new_titles VALUES ('2000/10/23','[Microfiche] D 103.24/19:','AMD-9822','','EIRS bulletin');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-270-300','ALL-8281','Mech, L. David.','Wolf population in the Central Superior National Forest, 1967-1985 /');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:PNW-330-331','ALJ-7128','Barrett, James W. (James Willis), 1922-','Response of dwarf mistletoe-infested ponderosa pine to thinning.');
INSERT INTO new_titles VALUES ('2000/10/23','C 21.9/2:','ALH-0927','','Attorneys and agents registered to practice before the U.S. Patent and Trademark Office.');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:PNW-291','AKN-8387','Stednick, John D.','Precipitation and streamwater chemistry in an undisturbed watershed in southwest Alaska /');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-241-269','ALD-1779','Phipps, Howard.','Pre-plant soaking of dormant populus hardwood cuttings /');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-200','AKL-0716','Arola, Rodger A.','Harvesting wood for energy /');
INSERT INTO new_titles VALUES ('2000/10/23','Mf 270','AKN-5426','International Microgravity Combustion Workshop (4th : 1997 : Cleveland, Ohio)','Fourth International Microgravity Combustion Workshop : proceedings of a workshop');
INSERT INTO new_titles VALUES ('2000/10/23','Mf 268','AKA-7489','Battelle Memorial Institute. Defense Metals Information Center.','DMIC collection UPDATA.');
INSERT INTO new_titles VALUES ('2000/10/23','A 13.78:NC-205','AKJ-9974','Rietveld, W. J.','Lifting date affects black walnut planting stock quality /');
INSERT INTO new_titles VALUES ('2000/10/23','Mf 269','AJZ-1201','Frame, Jo Arnold.','Moving toward a staff development model for computer learning /');
INSERT INTO new_titles VALUES ('2000/10/23','SF745 .M93 1920','AJY-3774','Moussu, Gustave, 1864-','Diseases of cattle, sheep, goats and swine /');
INSERT INTO new_titles VALUES ('2000/10/23','Mf 162 11568','AJS-5677','Wrbel, Hanno, 1963-','Stereotypies in the laboratory mouse developmental and functional aspects /');
INSERT INTO new_titles VALUES ('2000/10/23','Mf 162 11454','AJS-5676','Aichele, Peter, 1963-','Peptide-specific manipulation of the immune system : T cell priming versus T cell tolerance /');
INSERT INTO new_titles VALUES ('2000/10/23','Mf 162 no. 11442','AJS-5675','Wnn, Joachim, 1964-','Genetic transformation of rice (Oryza sativa L.) with cry genes from Bacillus thuringiensis to confer resistance to Lepi');
INSERT INTO new_titles VALUES ('2000/10/23','Mf 162 no. 11437','AJS-5674','Altenbach, Beat Werner, 1965.','Determination of substituted benzene- and naphthalenesulfonates in waste water and their behaviour in sewage treatment /');
INSERT INTO new_titles VALUES ('2000/10/23','','AJS-5205','Binder, Claudia R.','The early recognition of environmental impacts of human activities in developing countries /');
INSERT INTO new_titles VALUES ('2000/10/23','Mf 162 no. 11970','AJS-5209','Forstner, Michael, 1967-','Structure and structural dynamics of creatine kinase /');
INSERT INTO new_titles VALUES ('2000/10/23','Mf 162 11735','AJS-5204','Durrer, Stephan, 1963-','Parasite load and assemblages of bumblebee species /');
INSERT INTO new_titles VALUES ('2000/10/23','Mf 162 no. 11694','AJS-5141','Widmer, Alexander, 1969-','Aspects of the molecular ecology of Bombus (Hymenoptera: Apidae) in Europe /');
INSERT INTO new_titles VALUES ('2000/10/23','Mf 162 no. 11698','AJS-5140','Wolf, Martin Peter, 1965-','The measurement of the oxygenation status of the newborn infant /');
INSERT INTO new_titles VALUES ('2000/10/23','Mf 162 no. 11702','AJS-5139','Weisbach, Carina, 1964-','Regulation of oxygene permability in indeterminate root modules /');
INSERT INTO new_titles VALUES ('2000/10/23','Mf 162 no. 11726','AJS-5138','Gyamtsho, Pema, 1961-','Assessment of the condition and potential for improvement of high altitude rangelands of Bhutan /');
INSERT INTO new_titles VALUES ('2000/10/23','HC60 .I535b','AJR-7640','World Bank research program (1986)','The World Bank research program : abstracts of current studies.');
INSERT INTO new_titles VALUES ('2000/10/23','HV89 .A55','AJR-7152','','Public human services directory /');
INSERT INTO new_titles VALUES ('2000/10/23','QP501 .C65','AJP-5028','','Comparative biochemistry and physiology.');
INSERT INTO new_titles VALUES ('2000/10/23','Mf 162 no. 11573','AJQ-1283','Burkhardt, Peter, 1963-','Genetic engineering towards [beta]-carotene biosynthesis in rice (Oryza sativa L.) endosperm /');
INSERT INTO new_titles VALUES ('2000/10/23','QL461 .J86','AJG-9597','','Journal of Hymenoptera research.');
INSERT INTO new_titles VALUES ('2000/10/23','QK1 .P62','AIR-6261','Fiziologiia rastenii. English.','Russian journal of plant physiology.');
INSERT INTO new_titles VALUES ('2000/10/23','QK901 .V3','AIS-2495','','Plant ecology.');
INSERT INTO new_titles VALUES ('2000/10/23','B20.6 .G73','AIQ-2792','','Grazer philosophische Studien.');
INSERT INTO new_titles VALUES ('2000/10/23','QP501 .B566','AIP-7156','','Biological & pharmaceutical bulletin.');
INSERT INTO new_titles VALUES ('2000/10/23','QP356.2 .N48','AIP-4514','Neuron (Cambridge, Mass.)','Neuron.');
INSERT INTO new_titles VALUES ('2000/10/23','QP535.C2 C42','AIK-0151','','Cell calcium.');
INSERT INTO new_titles VALUES ('2000/10/23','QP623 .R55','AIA-2587','','RNA.');
INSERT INTO new_titles VALUES ('2000/10/23','QA166 .W43 1996','AIG-1393','West, Douglas Brent.','Introduction to graph theory /');
INSERT INTO new_titles VALUES ('2000/10/23','RC268.42 .O48','AHZ-9945','','Oncogene.');
INSERT INTO new_titles VALUES ('2000/10/23','QH541.5.S24 S22','AHZ-6731','','The Salt marsh a question of values /');
INSERT INTO new_titles VALUES ('2000/10/23','QA11.A1 U5','AFX-3240','','UMAP modules.');
INSERT INTO new_titles VALUES ('2000/10/23','RC261.A1 C55','AGJ-5739','','Clinical cancer research : an official journal of the American Association for Cancer Research.');
INSERT INTO new_titles VALUES ('2000/10/23','QL496 .J65','AFU-8652','','Journal of insect behavior.');
INSERT INTO new_titles VALUES ('2000/10/23','TN24.P4 P4','AFT-1976','','Mineral Industries Experiment Station circular.');
INSERT INTO new_titles VALUES ('2000/10/23','QD601 .O78','AFR-3417','','Annual report of the Radiation Center of Osaka Prefecture.');
INSERT INTO new_titles VALUES ('2000/10/23','QL1 .K72','AFQ-0239','Zeszyty naukowe Uniwersytetu Jagiellonskiego. Prace zoologiczne.','Prace zoologiczne.');
INSERT INTO new_titles VALUES ('2000/10/23','QH541.5.E8 A54 no.92-10, etc.','ACR-8611','','Watershed planning in the Albemarle-Pamlico estuarine system.');
INSERT INTO new_titles VALUES ('2000/10/23','QL351 .S9','ACR-6037','','Systematic biology');
INSERT INTO new_titles VALUES ('2000/10/23','[Reference Desk] JN1 .E85','ACL-8103','','The Europa world year book');
INSERT INTO new_titles VALUES ('2000/10/23','Q181.A1 J5','ACL-5228','','Journal of elementary science education');
INSERT INTO new_titles VALUES ('2000/10/23','JA3 .P2','ACL-5165','','Political science & politics : PS');
INSERT INTO new_titles VALUES ('2000/10/23','GC58 .C67','ACK-3646','University of North Carolina Sea Grant Program.','Proposal for institutional support');
INSERT INTO new_titles VALUES ('2000/10/23','QL757 .Z35','ACH-3498','','Parasitology research');
INSERT INTO new_titles VALUES ('2000/10/23','QR74 .M65','ACH-7185','','Molecular microbiology');
INSERT INTO new_titles VALUES ('2000/10/23','HG3881 .I5','ACG-2122','International Bank for Reconstruction and Development.','The World Bank annual report');
INSERT INTO new_titles VALUES ('2000/10/23','SF95 .A69','ACG-0776','Animal science research report (Stillwater, Okla.)','Animal science research report.');
INSERT INTO new_titles VALUES ('2000/10/23','QP551 .P76','ACE-6974','','Proteins');
INSERT INTO new_titles VALUES ('2000/10/23','QD47.C3 A35','ACD-6340','California Institute of Technology. Division of Chemistry and Chemical Engineering.','Chemistry and chemical engineering at the California Institute of Technology');
INSERT INTO new_titles VALUES ('2000/10/23','QA11.A1 R47','ACD-0611','Research report (Keio Gijuku Daigaku. Dept. of Mathematics)','Research report');
INSERT INTO new_titles VALUES ('2000/10/23','LB1027 .J635','ACC-0055','','Journal of curriculum and supervision.');
INSERT INTO new_titles VALUES ('2000/10/23','QE1 .J67','ACB-0936','','Irish journal of earth sciences');
INSERT INTO new_titles VALUES ('2000/10/23','QP1 .J58','ACB-7010','Journal of applied physiology (Bethesda, Md.)','Journal of applied physiology');
INSERT INTO new_titles VALUES ('2000/10/23','QR151 .Y32','ACA-7756','Yeast (Chichester, England)','Yeast');
INSERT INTO new_titles VALUES ('2000/10/23','QL1 .Z669','ABZ-4165','','Zoologicheskii zhurnal');
INSERT INTO new_titles VALUES ('2000/10/23','QR115 .I5','ACA-2056','','International journal of food microbiology.');
INSERT INTO new_titles VALUES ('2000/10/23','QL1 .B32','ABZ-1740','','BBC wildlife');
INSERT INTO new_titles VALUES ('2000/10/23','QK710 .A272','ABU-9399','','Acta physiologiae plantarum');
INSERT INTO new_titles VALUES ('2000/10/23','TH9446.3 .F56','ABY-2352','','Flammability and sensitivity of materials in oxygen-enriched atmospheres : a symposium /');
INSERT INTO new_titles VALUES ('2000/10/23','QE262.Y8 Y8','ABU-6560','','Proceedings of the Yorkshire Geological Society');
INSERT INTO new_titles VALUES ('2000/10/23','RA1190 .B715','ABT-7244','','Food and chemical toxicology');
INSERT INTO new_titles VALUES ('2000/10/23','QA13 .M16','ABU-2733','','Mathematics and computer education.');
INSERT INTO new_titles VALUES ('2000/10/23','Q181 .S34','ABS-8565','','The Science teacher');
INSERT INTO new_titles VALUES ('2000/10/23','SB1 .N58','ABR-9186','Research report (North Carolina State University. Dept. of Crop Science)','Research report.');
INSERT INTO new_titles VALUES ('2000/10/23','QH71.C75 A1','ABR-8972','Annual report (Colorado Museum of Natural History)','Annual report /');
INSERT INTO new_titles VALUES ('2000/10/23','QD1 .A56','ABR-5305','','Annales Universitatis Mariae Curie-Sklodowska.');
INSERT INTO new_titles VALUES ('2000/10/23','S65 .E33','ABR-8581','Agricultural economics research report (Kentucky Agricultural Experiment Station. Dept. of Agricultural Economics)','Agricultural economics research report.');
INSERT INTO new_titles VALUES ('2000/10/23','QP141.A1 N88','ABR-2914','Nutrition research (New York, N.Y.)','Nutrition research');
INSERT INTO new_titles VALUES ('2000/10/23','QL757 .S94','ABP-5677','','Systematic parasitology');
INSERT INTO new_titles VALUES ('2000/10/23','Z7203 .P987','ABP-8021','','Psycscan.');
INSERT INTO new_titles VALUES ('2000/10/23','QL614 .P73','ABO-9394','Proceedings (Southeastern Fishes Council)','Proceedings /');
INSERT INTO new_titles VALUES ('2000/10/23','QH301 .B37t','ABN-9985','','Biological abstracts/RRM');
INSERT INTO new_titles VALUES ('2000/10/23','SB612.A2 N62','ABL-3226','','Proceedings of the ... annual meeting of the Northeastern Weed Science Society');
INSERT INTO new_titles VALUES ('2000/10/23','QE201 .M32','ABM-2500','Anales (Universidad Nacional Autnoma de Mxico. Instituto de Geologa)','Anales');
INSERT INTO new_titles VALUES ('2000/10/23','QD462 .I52','ABJ-2026','','International journal of quantum chemistry.');
INSERT INTO new_titles VALUES ('2000/10/23','QP251.A1 A350','ABK-5318','','Animal reproduction science');
INSERT INTO new_titles VALUES ('2000/10/23','QC770 .P790','ABK-9876','','Progress in particle and nuclear physics');
INSERT INTO new_titles VALUES ('2000/10/23','QL614 .E58','ABF-8798','','Environmental biology of fishes');
INSERT INTO new_titles VALUES ('2000/10/23','QD65 .C4','ABG-9831','','CRC handbook of chemistry and physics');
INSERT INTO new_titles VALUES ('2000/10/23','QE282 .A21','ABC-0487','','Serie Af.');
INSERT INTO new_titles VALUES ('2000/10/23','QE89 .A2','ABD-0879','','California journal of mines and geology /');
INSERT INTO new_titles VALUES ('2000/10/23','TX556.M4 M450','ABF-6289','','Meat science');
INSERT INTO new_titles VALUES ('2000/10/23','QL461 .O5','ABC-0306','','Proceedings of the Entomological Society of Ontario');
INSERT INTO new_titles VALUES ('2000/10/23','QK1 .O26','ABC-0080','','Plant systematics and evolution');
INSERT INTO new_titles VALUES ('2000/10/23','LB1576.A1 E6','ABC-0148','','Language arts');
INSERT INTO new_titles VALUES ('2000/10/23','QL750 .B533','ABA-8039','','Behavioral ecology and sociobiology');
INSERT INTO new_titles VALUES ('2000/10/23','QP1 .J66','AAZ-2283','','Journal of evolutionary biochemistry and physiology');
INSERT INTO new_titles VALUES ('2000/10/23','SH334 .O74','AAZ-2264','','Review of fisheries in OECD member countries');
INSERT INTO new_titles VALUES ('2000/10/23','QL1 .L6','AAZ-2248','','Zoological journal of the Linnean Society');
INSERT INTO new_titles VALUES ('2000/10/23','QK603.2 .M9','AAZ-2200','','Mycotaxon');
INSERT INTO new_titles VALUES ('2000/10/23','QP1 .J6','AAZ-2011','','Journal of cellular physiology.');
INSERT INTO new_titles VALUES ('2000/10/23','QE39 .M46','AAZ-1888','','Meteor Forschungsergebnisse.');
INSERT INTO new_titles VALUES ('2000/10/23','QP620 .N8','AAZ-1857','','Nucleic acids research');
INSERT INTO new_titles VALUES ('2000/10/23','QH301 .C12','AAZ-1565','','Cahiers O.R.S.T.O.M.');
INSERT INTO new_titles VALUES ('2000/10/23','QR360 .J68','AAZ-1333','','Journal of virology');
INSERT INTO new_titles VALUES ('2000/10/23','QL461 .J87','AAZ-1230','','Journal of insect physiology');
INSERT INTO new_titles VALUES ('2000/10/23','QP351 .J57','AAZ-1229','','Journal of neurochemistry');
INSERT INTO new_titles VALUES ('2000/10/23','QR360 .V57','AAZ-0368','','Virology');
INSERT INTO new_titles VALUES ('2000/10/23','CT7200 .W6','AAZ-0422','','Who\'s who in art');
INSERT INTO new_titles VALUES ('2000/10/23','QK1 .P484','AAY-9627','','Phytochemistry');
INSERT INTO new_titles VALUES ('2000/10/23','QL461 .S5','AAZ-0011','','Annales de la Socit entomologique de France');
INSERT INTO new_titles VALUES ('2000/10/23','HD5701 .U65','AAY-9123','','Methods for manpower analysis');
INSERT INTO new_titles VALUES ('2000/10/23','QP171 .M48','AAY-9113','','Metabolism, clinical and experimental');
INSERT INTO new_titles VALUES ('2000/10/23','QL614 .J68','AAY-8868','','Journal of fish biology');
INSERT INTO new_titles VALUES ('2000/10/23','RC111.A2 J6','AAY-8880','','The Journal of infectious diseases');
INSERT INTO new_titles VALUES ('2000/10/23','QL461 .H4','AAY-8435','','Proceedings of the Hawaiian Entomological Society');
INSERT INTO new_titles VALUES ('2000/10/23','QL1 .S628','AAY-6143','','Bulletin de la Socit zoologique de France');
INSERT INTO new_titles VALUES ('2000/10/23','RC321 .N48','AAY-5957','Neurology (Minneapolis, Minn.)','Neurology official journal of the American Academy of Neurology.');
INSERT INTO new_titles VALUES ('2000/10/23','QL1 .J6','AAY-4770','','The Journal of experimental zoology.');
INSERT INTO new_titles VALUES ('2000/10/23','QK1 .P6','AAY-0467','Plant physiology (Lancaster, Pa.)','Plant physiology');
INSERT INTO new_titles VALUES ('2000/10/23','QP751 .L59','AAY-0566','','Lipids');
INSERT INTO new_titles VALUES ('2000/10/23','QL1 .D72','AAX-8957','','Zoologische Abhandlungen /');
INSERT INTO new_titles VALUES ('2000/10/23','QL461 .E618','AAX-3554','','Entomological review');
INSERT INTO new_titles VALUES ('2000/10/23','QP501 .F43','AAX-3718','','FEBS letters');
INSERT INTO new_titles VALUES ('2000/10/23','SH1 .F33','AAX-3773','','FAO fisheries reports');
INSERT INTO new_titles VALUES ('2000/10/23','Q1 .C6','AAX-3167','Transactions of the Connecticut Academy of Arts and Sciences.','Transactions');
INSERT INTO new_titles VALUES ('2000/10/23','QH301 .C4','AAX-2052','','Ceylon journal of science.');
INSERT INTO new_titles VALUES ('2000/10/23','RC261 .C34','AAX-1992','','Cancer research');
INSERT INTO new_titles VALUES ('2000/10/23','QL671 .C28','AAX-2018','','Cassinia');
INSERT INTO new_titles VALUES ('2000/10/23','RA565.A1 B8','AAX-0569','','Bulletin of environmental contamination and toxicology');
INSERT INTO new_titles VALUES ('2000/10/23','Z5301 .B5','AAX-0392','','Biography index');
INSERT INTO new_titles VALUES ('2000/10/23','QL461 .B8','AAX-0568','','Bulletin of entomological research');
INSERT INTO new_titles VALUES ('2000/10/23','QP501 .B54','AAX-0387','Biochemistry (American Chemical Society).','Biochemistry.');
INSERT INTO new_titles VALUES ('2000/10/23','SB349 .A54','AAW-4301','','American tomato yearbook');
INSERT INTO new_titles VALUES ('2000/10/23','QL700 .M25','AAW-1189','','Mammalia');
INSERT INTO new_titles VALUES ('2000/10/23','QL461 .A45','AAW-4109','','Contributions of the American Entomological Institute');
INSERT INTO new_titles VALUES ('2000/10/23','SH1 .F35','AAW-0589','','FAO fisheries technical paper.');
INSERT INTO new_titles VALUES ('2000/10/23','QH301 .W38','AAV-7070','','University of Washington publications in biology');
INSERT INTO new_titles VALUES ('2000/10/23','TA1001 .T684','AAV-1870','','Transportation research circular');
INSERT INTO new_titles VALUES ('2000/10/23','Q11 .K3','AAU-4085','','Transactions of the Kansas Academy of Science');
INSERT INTO new_titles VALUES ('2000/10/23','QH431.A2 J8','AAT-5007','','Archiv der Julius Klaus-Stiftung fr Vererbungsforschung, Sozialanthropologie und Rassenhygiene');
INSERT INTO new_titles VALUES ('2000/10/23','QD462.A1 I62','AAT-2375','','International journal of quantum chemistry.');
INSERT INTO new_titles VALUES ('2000/10/23','QC173 .J65','AAT-0101','','Journal of molecular structure.');
INSERT INTO new_titles VALUES ('2000/10/23','QK710 .A93','AAR-1284','','Australian journal of plant physiology');
INSERT INTO new_titles VALUES ('2000/10/23','QL750 .D4','AAQ-5516','','Developmental psychobiology');
INSERT INTO new_titles VALUES ('2000/10/23','QL671 .B4','AAP-9335','','Bird study');
INSERT INTO new_titles VALUES ('2000/10/26','I 19.76:99-384 A','ANW-8297','Boleneus, D. E.','Geologic datasets for weights-of-evidence ananlysis in northeast Washington.');
INSERT INTO new_titles VALUES ('2000/10/26','I 19.76:99-361','ANW-8296','','MCVCO HANDBOOK MCCHESNEY, P.J.');
INSERT INTO new_titles VALUES ('2000/10/26','I 19.76:99-184','ANW-8295','Winston, Richard B.','Upgrade to MODFLOW-GUI addition of MODPATH, ZONEBDGT, and additional MODFLOW packages to the U.S. Geological Survey MODF');
INSERT INTO new_titles VALUES ('2000/10/26','I 19.76:99-024','ANW-8294','','VOLCANO HAZARDS IN THE MOUNT JEFFERSON, OREGON WALDER, JOSEPH S., ET AL');
INSERT INTO new_titles VALUES ('2000/10/26','I 19.76:00-038','ANW-8293','','CHEMICAL DATA AND LEAD ISOTOPIC OF GEOCHEMICAL BASELINE SAMPLES FROM STREAMBED SEDIMENTS AND SMELTER SLAG, LEAD ISOTOPI');
INSERT INTO new_titles VALUES ('2000/10/26','I 19.76:00-031','ANW-8292','Fey, David L.','Analytical results for Bullion Mine and Crystal Mine waste samples and bed sediments from a small tributary to Jack Cree');
INSERT INTO new_titles VALUES ('2000/10/26','Y 1.1/5:106-303','ANW-8288','','REVISED ALLOCATION TO SUBCOMMITTEES OF BUDGET TOTALS FOR FISCAL YEAR 2001... REPORT 106-303... SENATE... 106TH CONGRESS');
INSERT INTO new_titles VALUES ('2000/10/26','Y 1.1/5:106-287','ANW-8283','United States. Congress. Senate. Committee on Commerce, Science, and Transportation.','Fritha : report of the Committee on Commerce, Science, and Transportation on S. 1853.');
INSERT INTO new_titles VALUES ('2000/10/26','Y 1.1/5:106-286','ANW-8282','United States. Congress. Senate. Committee on Commerce, Science, and Transportation.','M/V Sandpiper : report of the Committee on Commerce, Science, and Transportation on S. 1779.');
INSERT INTO new_titles VALUES ('2000/10/26','Y 1.1/5:106-285','ANW-8281','United States. Congress. Senate. Committee on Commerce, Science, and Transportation.','Enterprize : report of the Committee on Commerce, Science, and Transportation on S. 1615.');
INSERT INTO new_titles VALUES ('2000/10/26','Y 1.1/5:106-284','ANW-8280','United States. Congress. Senate. Committee on Commerce, Science, and Transportation.','Lucky Dog : report of the Committee on Commerce, Science, and Transportation on S. 1614.');
INSERT INTO new_titles VALUES ('2000/10/26','Y 1.1/5:106-283','ANW-8279','United States. Congress. Senate. Committee on Commerce, Science, and Transportation.','Victory of Burhnam : report of the Committee on Commerce, Science, and Transportation on S. 1613.');
INSERT INTO new_titles VALUES ('2000/10/26','Y 1.1/5:106-282','ANW-8278','United States. Congress. Senate. Committee on Commerce, Science, and Transportation.','Yankee : report of the Committee on Commerce, Science, and Transportation on S. 1261.');
INSERT INTO new_titles VALUES ('2000/10/26','Y 1.1/5:106-281','ANW-8277','United States. Congress. Senate. Committee on Commerce, Science, and Transportation.','Looking Glass : report of the Committee on Commerce, Science, and Transportation on S. 442.');
INSERT INTO new_titles VALUES ('2000/10/26','Y 1.1/4:106-24','ANW-8274','South Africa.','Extradition treaty with South Africa : message from the President of the United States transmitting Extradition Treaty b');
INSERT INTO new_titles VALUES ('2000/10/26','Y 4.IN 2/11:S.HRG.106-478','ANS-2697','United States. Congress. Senate. Committee on Indian Affairs (1993- )','Fiscal year 2001 budget : hearing before the Committee on Indian Affairs, United States Senate, One Hundred Sixth Congre');
INSERT INTO new_titles VALUES ('2000/10/26','Y 4.IN 2/11:S.HRG.106-385/PT.','ANR-9768','United States. Congress. Senate. Committee on Indian Affairs (1993- )','Native Hawaiian education reauthorization : hearing before the Committee on Indian Affairs, United States Senate, One Hu');
INSERT INTO new_titles VALUES ('2000/10/26','Y 4.R 86/1:C 76/18','ANQ-6415','','Congressional oversight : a \"how-to\" series of workshops : proceedings of the three-day workshop on congressional oversi');
INSERT INTO new_titles VALUES ('2000/10/26','PC4117 .I39 1989','ANQ-4163','','Imaginacin y fantasa : cuentos de las Amricas /');
INSERT INTO new_titles VALUES ('2000/10/26','TA656 .S778 1999','ANP-2967','','Structural stability in engineering practice /');
INSERT INTO new_titles VALUES ('2000/10/26','F784.D9 D85 1999','ANP-1364','Duke, P. G.','Points, pithouses, and pioneers : tracing Durango\'s archaeological past /');
INSERT INTO new_titles VALUES ('2000/10/26','PT7090 .N674 1999','ANP-0485','','Norse romance /');
INSERT INTO new_titles VALUES ('2000/10/26','GB665 .S64 1998','ANP-0486','Spellman, Frank R.','The science of water : concepts & applications /');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-707','AND-0597','Birch, Thomas W.','Characterizing Virginia\'s private forest owners and their forest lands');
INSERT INTO new_titles VALUES ('2000/10/26','PZ7.C92177 Bu 1999','ANA-5083','Curtis, Christopher Paul.','Bud, not Buddy /');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-706','AMZ-4872','','Reexamination of effects of paraformaldehyde on tissues around tapholes in sugar maple trees');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-705','AMZ-1235','Huyler, Neil K.','Cycle-time equation for the Koller K300 cable yarder operating on steep slopes in the Northeast');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-702','AMY-2934','Miller, Gary W.','Epicormic branching on central Appalachian hardwoods 10 years after deferment cutting');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-704','AMW-9211','Gemborys, Stanley R.','Structure and dynamics in a virgin northern hardwood-spruce-fir forest the Bowl, New Hampshire /');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-700','AMV-8601','Kochenderfer, J. N.','Effects of fertilization on the growth and development of a Japanese larch plantation in West Virginia');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-699','AMU-4490','Leak, William B.','Dynamics of white pine in New England');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-696','AMS-9724','Miller, Gary W.','Method for applying group selection in central Appalachian hardwoods');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-697','AMS-9718','Garrett, Peter W., 1933-','Sugar maple seed production in northern New Hampshire');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-698','AMS-7053','Dale, Martin E.','Size of clearcut opening affects species composition, growth rate and stand characteristics');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-675','AMR-1350','Houston, David R., 1932-','Recognizing and managing sapstreak disease of sugar maple');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-683','AMR-1044','Sendak, Paul E.','Northeastern regional timber stumpage prices');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-677','AMR-0341','Leak, William B.','Six-year beechnut production in New Hampshire');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-674','AMR-0333','Schuler, Thomas M.','Survival, growth, and target canker infection of black walnut families 15 years after establishment in West Virginia');
INSERT INTO new_titles VALUES ('2000/10/26','A 13.78:NE-694','AMQ-8453','Smith, H. Clay.','Crop-tree release thinning in 65-year-old commercial cherry-maple stands (5-year results)');
INSERT INTO new_titles VALUES ('2000/10/25','','AOF-0789','Hanning, Robert and Joan Ferrante, trans.','Lanval / Fresne / Bisclavret / Yonec');
INSERT INTO new_titles VALUES ('2000/10/25','','AOF-0787','Kahn, Russell L.','Effect of Technological Innovation on Organizational Structure');
INSERT INTO new_titles VALUES ('2000/10/25','','AOF-0785','Thrush, Emily Austin and Michael Bodary','Virtual Reality, Combat, and Communication');
INSERT INTO new_titles VALUES ('2000/10/25','','AOF-0783','Carliner, Saul','Taking Cues from the Culture: The Case of Network Earth');
INSERT INTO new_titles VALUES ('2000/10/25','','AOF-0760','Wojciechowski, Tom','Living green : a residence for environmental living and learning at Northland College[Photocopy]');
INSERT INTO new_titles VALUES ('2000/10/25','','AOF-0758','Northland College (Ashland, WI)','Sigurd Olson Environmental Institute');
INSERT INTO new_titles VALUES ('2000/10/25','','AOF-0636','Frushour, Bruce G. and Raymond S.Knorr','Acrylic Fibers (chapter 12)');
INSERT INTO new_titles VALUES ('2000/10/25','A 13.78:NE-322-337','AOF-0626','','A Perspective on the camping-involvement cycle : results of a 1973 nationwide household survey /');
INSERT INTO new_titles VALUES ('2000/10/25','','AOF-0595','Wishman, Marvin and Gerald E. Hagler','Polypropylene Fibers (chapter 3)');
INSERT INTO new_titles VALUES ('2000/10/25','EP 4.9:42/995/','AOF-0535','','Supplement D to compilation of air pollutant emission factors');
INSERT INTO new_titles VALUES ('2000/10/25','','AOF-0546','Reimschuessel, Herbert K.','Polyamide Fibers (chapter 2)');
INSERT INTO new_titles VALUES ('2000/10/25','','AOF-0520','Mcintyre, J.E','Polyester Fibers (chapter 1)');
INSERT INTO new_titles VALUES ('2000/10/25','A 13.78:NE-266-268, 270-287','AOF-0504','Anderson, R. Bruce.','Factors influencing the selection of state office furniture /');
INSERT INTO ne