#!/usr/bin/perl

# keys2urls.pl - convert list of keys to list of URLs for harvesting

# Eric Lease Morgan <emorgan@nd.edu>
# June 1, 2009 - first cut

use strict;
my $file = $ARGV[ 0 ];
open F, " < $file " or die "Can't open input: $!\n";
my $index = 0;
while ( <F> ) {

	# skip first item
	$index++;
	next if ( $index == 1 );
	
	# normalize;
	chop;
	s/"//g;
	
	# output desired URLs
	print "http://www.archive.org/download/$_/$_" . "_meta.mrc\n";
	print "http://www.archive.org/download/$_/$_" . ".pdf\n";
	print "http://www.archive.org/download/$_/$_" . "_djvu.txt\n";

}

# done
close F;
