<xsl:stylesheet 
	xmlns:xsl='http://www.w3.org/1999/XSL/Transform'
	xmlns:zs="http://www.loc.gov/zing/srw/"
	xmlns:slim="http://www.loc.gov/MARC21/slim"
	xmlns:zebra="http://www.indexdata.dk/zebra/"
	version='1.0'>

<!--

	mbooks.xsl - a stylesheet to render MARCXML
	
	Eric Lease Morgan (eric_morgan@infomotions.com)
	September 8, 2008
	
	This file is distributed under the GNU Public License.
	
-->

<xsl:output method="html" version="4.0" encoding="utf-8" indent="yes" omit-xml-declaration='no' />
  <xsl:template match='/'>
    <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
      <head>
        <meta http-equiv="content-type" content="text/html; charset=utf-8"></meta>
        <link rel="stylesheet" href="/etc/style.css" media="screen" />
        <title>MBooks</title>
		
		<!-- javascript to show/hide details -->
		<script type="text/javascript">
			function expand( id ) {
				var details = document.getElementById( id );
				details.style.display = ( details.style.display == 'block' ) ? 'none' : 'block';
			}
		</script>
      </head>
      <body>
        <div class='header'>
          <h1>MBooks</h1>
          
          <!-- echo the form so we can search again -->
          <form action='./mbooks' method='GET'>
            <input type='hidden' name='operation' value='searchRetrieve' />
            <input type='hidden' name='maximumRecords' value='50' />
            <input type='hidden' name='version' value='1.1' />
            <input type='hidden' name='stylesheet' value='/etc/mbooks.xsl' />
            <input type='text' name='query' size='45' class='large' />
            <input type='submit' value='Go' class='large' />
          </form>
        </div>
        <h2>Results</h2>
        
        <!-- list how may records were found; remember the SRU/CQL interface is both smart and dumb -->
        <xsl:choose>
			<xsl:when test='/zs:searchRetrieveResponse/zs:numberOfRecords'>
        		<p>Your search found <b><xsl:value-of select='/zs:searchRetrieveResponse/zs:numberOfRecords' /> records</b>, and no more than 50 are displayed below:</p>
        	</xsl:when>
        	<xsl:otherwise>
        		<p>Your search found zero (0) records. Remember this interface is rather dumb.</p>
        	</xsl:otherwise>
		</xsl:choose>
		<ol>

          <!-- process each record -->
          <xsl:for-each select='//slim:record'>
            <li>
            	
            	<!-- extract the title and make it hot -->
            	<a>
					<xsl:attribute name='href'>
					<xsl:value-of select='./slim:datafield[@tag="856"]/slim:subfield[@code="u"]' />
					</xsl:attribute>
					<xsl:value-of select='./slim:datafield[@tag="245"]/slim:subfield[@code="a"]' />
				</a>&#160;
				
				<!-- add the details link; rather zebra specfic without the localnumber -->
				<a><xsl:attribute name='href'>javascript:expand('d<xsl:value-of select='./zebra:idzebra/zebra:localnumber'/>')</xsl:attribute><xsl:attribute name='style'>color: silver</xsl:attribute>(MARC)</a>
			</li>
            <div>
            	<xsl:attribute name='id'>d<xsl:value-of select='./zebra:idzebra/zebra:localnumber'/></xsl:attribute>
            	<xsl:attribute name='style'>display: none</xsl:attribute>
            <ol class='marc-item'>
              
              <!-- display the leader -->
              <li><b>LDR</b>&#160;<xsl:value-of select='./slim:leader' /></li>
				
				<!-- process each control field -->
				<xsl:for-each select='.//slim:controlfield'>
					<li>
						<b><xsl:value-of select='./@tag' /></b>
						<xsl:text>&#160;</xsl:text>
						<xsl:value-of select='.' />
					</li>
				</xsl:for-each>
				
				<!-- process each data field; kewl -->
				<xsl:for-each select='.//slim:datafield'>
					<li>
						<b><xsl:value-of select='./@tag' /></b>
						<xsl:text>&#160;</xsl:text>
						<xsl:choose>
							<xsl:when test="boolean(number(./@ind1))">
								<xsl:value-of select='./@ind1' />
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>&#160;</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:value-of select='./@ind2' />
						<xsl:text>&#160;</xsl:text>
						<xsl:for-each select='.//slim:subfield'>
							<xsl:text>$</xsl:text>
							<xsl:value-of select='./@code' />
							<xsl:text> </xsl:text>
							<xsl:value-of select='.' />
							<xsl:text> </xsl:text>
						</xsl:for-each>
					</li>
				</xsl:for-each>
            </ol>
            </div>
          </xsl:for-each>
        </ol>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
