use Test::More tests => 13;
use strict;

# use the module
use_ok('C4LJ::Article');

# create an article object
my $article = C4LJ::Article->new();
isa_ok($article, "C4LJ::Article");

# create an article object
$article = C4LJ::Article->new( id => 23 );
isa_ok($article, "C4LJ::Article");

# get an article id
my $id = $article->id();
like ($id, qr/^\d+$/, 'get id()');

# get an article title
my $title = $article->title();
is ($article->title, 'Facet-Based Search and Navigation With LCSH: Problems and Opportunities', 'get title()');

# get an article url
my $url = $article->url();
is ($article->url, 'http://journal.code4lib.org/articles/23', 'get url()');

# get an article issue
my $issue = $article->issue();
is ($article->issue, '1', 'get issue()');

# get an article date
my $date = $article->date();
like ($article->date, qr(^\d\d\d\d-\d\d-\d\d$), 'get date()');

# get an article abstract
my $abstract = $article->abstract();
is ($article->abstract, "Facet-based interfaces demonstrate some limitations of Library of Congress Subject Headings (LCSH), which were designed to deal with constraints that do not exist in the current computerized environment. This paper discusses some challenges for using LCSH for faceted browsing and navigation in library catalogs. Ideas are provided for improving results through system design, changes to LCSH practice, and LCSH structure. ", 'get abstract()');

# get an article url
my $author = $article->author();
is ($article->author, 'Kelley McGrath', 'get author()');

# get articles
my @f = C4LJ::Article->get_articles();
my $article_count = scalar( @f );
like ($article_count, qr/^\d+$/, "get_articles() $article_count found");

# get articles with a particular term
@f = C4LJ::Article->get_articles( term => 'Issue 1');
$article_count = scalar( @f );
like ($article_count, qr/^\d+$/, "get_articles( tag => 'Issue 1' ) $article_count found");

# get articles from a particular issue
@f = C4LJ::Article->get_articles( term => 1);
$article_count = scalar( @f );
like ($article_count, qr/^\d+$/, "get_articles( issue => 1 ) $article_count found");



